<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2006 by CANTICO ({@link http://www.cantico.fr})
 */
include_once 'base.php';

/**
* Instanciates the widget factory.
*
* @return Func_Widgets
*/
function ckeditor_Widgets()
{
	return bab_Functionality::get('Widgets');
}

function ckeditor_translate($str)
{
	return bab_translate($str, 'LibCkEditor');
}

function ckeditor_iconised($class, $texte){
	$registry = bab_getRegistryInstance();
	$registry->changeDirectory('/LibCkEditor');
	$W = ckeditor_Widgets();
	
	$image = $W->Html('
			<span role="presentation" class="cke_toolbar">
				<span role="presentation" class="cke_toolgroup">
					<span class="cke_button">
						<a title="'.ckeditor_translate($texte).'" class="cke_off '.$class.'">
							<span class="cke_icon">&nbsp;</span>
							<span class="cke_label">'.ckeditor_translate($texte).'</span>
						</a>
					</span>
				</span>
			</span>');
	
	return $W->HboxItems(
		$image,
		$temp = $W->Label(ckeditor_translate($texte)),
		$W->CheckBox()->setAssociatedLabel($temp)->setCheckedValue('1')->setValue($registry->getValue($texte, true))->setName($texte)
	)->setHorizontalSpacing(5,'px')->setVerticalAlign('middle');
}

function ckeditor_labelised($class, $texte, $value = true){
	$registry = bab_getRegistryInstance();
	$registry->changeDirectory('/LibCkEditor');
	$W = ckeditor_Widgets();
	
	$image = $W->Html('
			<span role="presentation" class="cke_toolbar">
					<span role="presentation" class="cke_toolgroup">
						<span class="cke_rcombo">
							<span class="'.$class.' cke_off">
								<span class="cke_label">'.ckeditor_translate($texte).'</span>
								<a title="'.ckeditor_translate($texte).'">
									<span>
										<span class="cke_text">'.ckeditor_translate($texte).'</span>
									</span>
									<span class="cke_openbutton"></span>
								</a>
							</span>
						</span>
					</span>
				</span>');
	
	return $W->HboxItems(
		$image,
		$temp = $W->Label(ckeditor_translate($texte)),
		$W->CheckBox()->setAssociatedLabel($temp)->setCheckedValue('1')->setValue($registry->getValue($texte, $value))->setName($texte)
	)->setHorizontalSpacing(5,'px')->setVerticalAlign('middle');
}

function ckeditor_config(){
	$addonInfo = bab_getAddonInfosInstance('LibCkEditor');
	
	$registry = bab_getRegistryInstance();
	$registry->changeDirectory('/LibCkEditor');
	//$registry->setKeyValue('name', $workspaceName);
	
	$W = ckeditor_Widgets();
	$page = $W->BabPage('lcke-page');
	$page->addStyleSheet($addonInfo->getRelativePath().'LibCkEditor.css?t=B0VI4XQ');
	
	$page->addItemMenu('lib', ckeditor_translate('Shared Libraries'), '?tg=addons&idx=library');
	$page->addItemMenu('setting', ckeditor_translate('Settings'), '');
	$page->addItemMenu('styles', ckeditor_translate('Add Styles'), '?tg=addon/LibCkEditor/configuration&idx=styles');
	$page->setCurrentItemMenu('setting');
	
	if(bab_rp('save',false)){
		$page->addError(ckeditor_translate('Record done.'));
	}
	$optionsList = $W->Form(null, $W->VBoxLayout()->setVerticalSpacing(1,'em'))
		->setHiddenValue('tg', 'addon/LibCkEditor/configuration')
		->setHiddenValue('idx', 'save')
		->addItem($W->title(ckeditor_translate('LibCkEditor Settings'),1))
		->addItem($W->Label(ckeditor_translate('Choose which button should be display').' :'))
		->addItem(
		$W->HBoxItems(
			$iconColonLeft = $W->VBoxLayout()->setVerticalSpacing(.5,'em'),
			$iconColonRight = $W->VBoxLayout()->setVerticalSpacing(.5,'em')
		)->setHorizontalSpacing(1.5,'em')->addClass('cke_skin_kama')
	);
	
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_templates', 'Templates'));
	
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_cut', 'Cut'));
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_copy', 'Copy'));
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_paste', 'Paste'));
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_pastetext', 'PasteText'));
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_pastefromword', 'PasteFromWord'));
	
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_undo', 'Undo'));
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_redo', 'Redo'));
	
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_find', 'Find'));
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_replace', 'Replace'));
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_checkspell', 'SpellChecker'));
	
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_selectAll', 'SelectAll'));
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_removeFormat', 'RemoveFormat'));
	
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_maximize', 'Maximize'));
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_source', 'Source'));
	
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_bold', 'Bold'));
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_italic', 'Italic'));
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_underline', 'Underline'));
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_strike', 'Strike'));
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_subscript', 'Subscript'));
	$iconColonLeft->addItem(ckeditor_iconised('cke_button_superscript', 'Superscript'));
	
	$iconColonRight->addItem(ckeditor_iconised('cke_button_justifyleft', 'JustifyLeft'));
	$iconColonRight->addItem(ckeditor_iconised('cke_button_justifycenter', 'JustifyCenter'));
	$iconColonRight->addItem(ckeditor_iconised('cke_button_justifyright', 'JustifyRight'));
	$iconColonRight->addItem(ckeditor_iconised('cke_button_justifyblock', 'JustifyBlock'));
	
	$iconColonRight->addItem(ckeditor_iconised('cke_button_numberedlist', 'NumberedList'));
	$iconColonRight->addItem(ckeditor_iconised('cke_button_bulletedlist', 'BulletedList'));
	
	$iconColonRight->addItem(ckeditor_iconised('cke_button_outdent', 'Outdent'));
	$iconColonRight->addItem(ckeditor_iconised('cke_button_indent', 'Indent'));
	
	$iconColonRight->addItem(ckeditor_iconised('cke_button_table', 'Table'));
	$iconColonRight->addItem(ckeditor_iconised('cke_button_horizontalrule', 'HorizontalRule'));
	$iconColonRight->addItem(ckeditor_iconised('cke_button_specialchar', 'SpecialChar'));
	
	$iconColonRight->addItem(ckeditor_iconised('cke_button_link', 'Link'));
	$iconColonRight->addItem(ckeditor_iconised('cke_button_unlink', 'Unlink'));
	$iconColonRight->addItem(ckeditor_iconised('cke_button_anchor', 'Anchor'));
	$iconColonRight->addItem(ckeditor_iconised('cke_button_ovidentia', 'Ovidentia'));
	
	$iconColonRight->addItem(ckeditor_labelised('cke_styles', 'Styles', false));
	$iconColonRight->addItem(ckeditor_labelised('cke_format', 'Format'));
	$iconColonRight->addItem(ckeditor_labelised('cke_font', 'Font'));
	$iconColonRight->addItem(ckeditor_labelised('cke_fontSize', 'fontSize'));
	
	$iconColonRight->addItem(ckeditor_iconised('cke_button_textcolor', 'TextColor'));
	$iconColonRight->addItem(ckeditor_iconised('cke_button_bgcolor', 'BgColor'));
	
	$optionsList->addItem($W->SubmitButton()->setLabel(ckeditor_translate('Save')));
	
	$page->addItem($optionsList);
	
	$page->displayHtml();
}

function ckeditor_styles(){
	
	$I = bab_Functionality::get('Icons');
	if ($I) {
		$I->includeCss();
	}
	$addonInfo = bab_getAddonInfosInstance('LibCkEditor');
	global $babDB;
	
	$W = ckeditor_Widgets();
	$page = $W->BabPage('lcke-page');
	$page->addStyleSheet($addonInfo->getRelativePath().'LibCkEditor.css?t=B0VI4XQ');
	
	$page->addItemMenu('lib', ckeditor_translate('Shared Libraries'), '?tg=addons&idx=library');
	$page->addItemMenu('setting', ckeditor_translate('Settings'), '?tg=addon/LibCkEditor/configuration&idx=config');
	$page->addItemMenu('styles', ckeditor_translate('Add Styles'), '?tg=addon/LibCkEditor/configuration&idx=styles');
	$page->setCurrentItemMenu('styles');
	
	if(bab_rp('save',false) == 1){
		$page->addError(ckeditor_translate('Record done.'));
	}
	if(bab_rp('save',false) == 2){
		$page->addError(ckeditor_translate('Error, a field is missing.'));
	}
	$optionsList = $W->Form(null, $W->VBoxLayout()->setVerticalSpacing(1,'em'))
		->setHiddenValue('tg', 'addon/LibCkEditor/configuration')
		->setHiddenValue('idx', 'savestyles')
		->addItem($W->title(ckeditor_translate('Styles Settings'),1));
	
	$table = $W->TableView();
	$table->setView(Widget_TableView::VIEW_LIST);
	$table->addSection('lcke-table-header');
	$table->setCurrentSection('lcke-table-header');
	$table->addItem($W->Label(ckeditor_translate('Name')),0,0);
	$table->addItem($W->Label(ckeditor_translate('Class')),0,1);
	$table->addItem($W->Label(''),0,2);
	$table->addSection('lcke-table-content');
	$table->setCurrentSection('lcke-table-content');
	
	$req = "SELECT * FROM lcke_styles";
	$res = $babDB->db_query($req);
	
	$x = 1;
	while($arr = $babDB->db_fetch_assoc($res)){
		$y = 0;
		$table->addItem(
			$W->label($arr['name']),
			$x,
			$y
		);
		$y++;
		$table->addItem(
			$W->label($arr['class']),
			$x,
			$y
		);
		$y++;
		$table->addItem(
			$W->HBoxItems(
				$W->Link(
					$W->Icon('',Func_Icons::ACTIONS_EDIT_DELETE),
					$GLOBALS['babAddonUrl'].'configuration&idx=deletestyles&id='.$arr['id']
				)->setConfirmationMessage(ckeditor_translate('This will delete this style, continue?'))->setTitle(ckeditor_translate('Delete'))/*,
				$linkNext*/
			)->addClass('icon-left-24')->addClass('icon-24x24')->addClass('icon-left'),
			$x,
			$y
		);
		$x++;
	}
	
	$optionsList->addItem($table);
	
	$optionsList->addItem(
		$W->FlowItems(
			$W->VBoxItems(
				$tmp = $W->Label(ckeditor_translate('Name'))->colon(true),
				$W->LineEdit()->setName('name')->setAssociatedLabel($tmp)
			)->setVerticalSpacing(0.25,'em'),
			$W->VBoxItems(
				$tmp = $W->Label(ckeditor_translate('Class'))->colon(true),
				$W->LineEdit()->setName('class')->setAssociatedLabel($tmp)
			)->setVerticalSpacing(0.25,'em')
		)->setHorizontalSpacing(2,'em')->setVerticalSpacing(1,'em')
	);
	
	$optionsList->addItem($W->SubmitButton()->validate(true)->setLabel(ckeditor_translate('Add')));
	
	$page->addItem($optionsList);
	
	$page->displayHtml();
}

function ckeditor_deletestyles(){
	global $babDB;
	
	$id = bab_gp('id','');
	
	if(!$id){
		header('Location: ' . '?tg=addon/LibCkEditor/configuration&idx=styles&save=2');
		die;
	}
	
	$req = "DELETE FROM lcke_styles WHERE id=".$babDB->quote($id);
	$babDB->db_query($req);
	
	ckeditor_genstyles();
	
	header('Location: ' . '?tg=addon/LibCkEditor/configuration&idx=styles&save=1');
}

function ckeditor_savestyles(){
	global $babDB;
	
	$name = bab_pp('name','');
	$class = bab_pp('class','');
	
	if(!$name || !$class){
		header('Location: ' . '?tg=addon/LibCkEditor/configuration&idx=styles&save=2');
		die;
	}
	
	$req = "INSERT INTO lcke_styles (name, class) VALUES (".$babDB->quote($name).",".$babDB->quote($class).")";
	$babDB->db_query($req);
	
	ckeditor_genstyles();
	
	header('Location: ' . '?tg=addon/LibCkEditor/configuration&idx=styles&save=1');
}

function ckeditor_genstyles(){
	global $babDB;
	
	$req = "SELECT * FROM lcke_styles";
	$res = $babDB->db_query($req);
	
	$addonInfo = bab_getAddonInfosInstance('LibCkEditor');
	
	$uPath = new bab_Path($addonInfo->getUploadPath());
	if($uPath->isDir()){
		$uPath->push('styles.js');
		if(is_file($uPath->tostring())){
			$ourFileHandle = fopen($uPath->tostring(), 'w+');
			if(!$ourFileHandle){
				return -1;
			}
			fwrite($ourFileHandle, "CKEDITOR.stylesSet.add( 'my_styles', [");
		}
	}
	
	while($arr = $babDB->db_fetch_assoc($res)){
		fwrite($ourFileHandle, "{ name : '".$arr['name']."', element : 'p', attributes : { 'class' : '".$arr['class']."' } }, ");
	}
	
	fwrite($ourFileHandle, "]);");
	fclose($ourFileHandle);
}

function ckeditor_save(){
	$addonInfo = bab_getAddonInfosInstance('LibCkEditor');

	$registry = bab_getRegistryInstance();
	$registry->changeDirectory('/LibCkEditor');
	
	$registry->setKeyValue('Templates', bab_pp('Templates', true));
	
	$registry->setKeyValue('Cut', bab_pp('Cut', true));
	$registry->setKeyValue('Copy', bab_pp('Copy', true));
	$registry->setKeyValue('Paste', bab_pp('Paste', true));
	$registry->setKeyValue('PasteText', bab_pp('PasteText', true));
	$registry->setKeyValue('PasteFromWord', bab_pp('PasteFromWord', true));
	
	$registry->setKeyValue('Undo', bab_pp('Undo', true));
	$registry->setKeyValue('Redo', bab_pp('Redo', true));
	
	$registry->setKeyValue('Find', bab_pp('Find', true));
	$registry->setKeyValue('Replace', bab_pp('Replace', true));
	$registry->setKeyValue('SpellChecker', bab_pp('SpellChecker', true));
	
	$registry->setKeyValue('SelectAll', bab_pp('SelectAll', true));
	$registry->setKeyValue('RemoveFormat', bab_pp('RemoveFormat', true));
	
	$registry->setKeyValue('Maximize', bab_pp('Maximize', true));
	$registry->setKeyValue('Source', bab_pp('Source', true));
	
	$registry->setKeyValue('Bold', bab_pp('Bold', true));
	$registry->setKeyValue('Italic', bab_pp('Italic', true));
	$registry->setKeyValue('Underline', bab_pp('Underline', true));
	$registry->setKeyValue('Strike', bab_pp('Strike', true));
	$registry->setKeyValue('Subscript', bab_pp('Subscript', true));
	$registry->setKeyValue('Superscript', bab_pp('Superscript', true));
	
	$registry->setKeyValue('JustifyLeft', bab_pp('JustifyLeft', true));
	$registry->setKeyValue('JustifyCenter', bab_pp('JustifyCenter', true));
	$registry->setKeyValue('JustifyRight', bab_pp('JustifyRight', true));
	$registry->setKeyValue('JustifyBlock', bab_pp('JustifyBlock', true));
	
	$registry->setKeyValue('NumberedList', bab_pp('NumberedList', true));
	$registry->setKeyValue('BulletedList', bab_pp('BulletedList', true));
	
	$registry->setKeyValue('Outdent', bab_pp('Outdent', true));
	$registry->setKeyValue('Indent', bab_pp('Indent', true));
	
	$registry->setKeyValue('Table', bab_pp('Table', true));
	$registry->setKeyValue('HorizontalRule', bab_pp('HorizontalRule', true));
	$registry->setKeyValue('SpecialChar', bab_pp('SpecialChar', true));
	
	$registry->setKeyValue('Link', bab_pp('Link', true));
	$registry->setKeyValue('Unlink', bab_pp('Unlink', true));
	$registry->setKeyValue('Anchor', bab_pp('Anchor', true));
	$registry->setKeyValue('Ovidentia', bab_pp('Ovidentia', true));
	
	$registry->setKeyValue('Styles', bab_pp('Styles', false));
	$registry->setKeyValue('Format', bab_pp('Format', true));
	$registry->setKeyValue('Font', bab_pp('Font', true));
	$registry->setKeyValue('fontSize', bab_pp('fontSize', true));
	
	$registry->setKeyValue('TextColor', bab_pp('TextColor', true));
	$registry->setKeyValue('BgColor', bab_pp('BgColor', true));
	
	header('Location: ' . '?tg=addon/LibCkEditor/configuration&idx=config&save=1');
}

$idx = bab_rp('idx','config');

switch($idx){
	case 'save':
		ckeditor_save();
		break;
	case 'styles':
		ckeditor_styles();
		break;
	case 'savestyles':
		ckeditor_savestyles();
		break;
	case 'deletestyles':
		ckeditor_deletestyles();
		break;
	case 'config':
	default:
		ckeditor_config();
		break;
}