<?php
/************************************************************************
 * OVIDENTIA http://www.ovidentia.org                                   *
 ************************************************************************
 * Copyright (c) 2003 by CANTICO ( http://www.cantico.fr )              *
 *                                                                      *
 * This file is part of Ovidentia.                                      *
 *                                                                      *
 * Ovidentia is free software; you can redistribute it and/or modify    *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2, or (at your option)  *
 * any later version.													*
 *																		*
 * This program is distributed in the hope that it will be useful, but  *
 * WITHOUT ANY WARRANTY; without even the implied warranty of			*
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*
 * See the  GNU General Public License for more details.				*
 *																		*
 * You should have received a copy of the GNU General Public License	*
 * along with this program; if not, write to the Free Software			*
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,*
 * USA.																	*
************************************************************************/
require_once 'base.php';

/**
 * Ceci est une fonction evenementielle enregistree avec bab_addEventListener
 * elle sera appelee lors de l'affichage d'une zone de texte editeur WYSIWYG
 *
 * @param	bab_eventEditorContentToEditor	&$event
 *
 */
function ckeditor_onContentToEditor(bab_eventEditorContentToEditor $event) {
	
	
	if (!empty($event->content) && 'html' !== $event->format) {
		/**
		 * Pour le moment seul le format html est géré par le noyau mais il faut ignorer les autres format s'ils ne sont pas supportés
		 * car d'autres formats pourrais étres utilisés é l'avenir, gérés par leurs propres modules
		 */
		return;
	}

	require_once $GLOBALS['babAddonPhpPath']."ckeditor/ckeditor.php";
	
	$obj = new ckeditor($GLOBALS['babInstallPath'].'addons/LibCkEditor/ckeditor/');// le chemin d'installation de l'add-on
	
	if( empty($event->content)){
		$content = "";
	}else{
		$content = preg_replace("/src=\"(images[^\"]+)\"/", "src=\"".$GLOBALS['babUrl']."\\1\"", $event->content);
	}
	$obj->returnOutput = true;
	
	$obj->config['height'] = $event->parameters['height'];
	$toolbar = ckeditor_getToolbar();
	
	$config['toolbar'] = $toolbar;
	//$config['forcePasteAsPlainText'] = true;
	//$config['pasteFromWordRemoveStyles'] = true;
	//$config['pasteFromWordRemoveFontStyles'] = true;
	
	
	$registry = bab_getRegistryInstance();
	$registry->changeDirectory('/LibCkEditor');
	if($registry->getValue('Styles', false)){
		$addonInfo = bab_getAddonInfosInstance('LibCkEditor');
		$uPath = new bab_Path($addonInfo->getUploadPath());
		$uPath->push('styles.js');
		if(is_file($uPath->tostring())){
			$config['stylesSet'] = 'my_styles:'.$GLOBALS['babUrl'].'index.php?tg=addon/LibCkEditor/styles';
		}
	}
	
	$html = '<input type="hidden" name="'.$event->uid.'_format" value="html" />';
	$obj->textareaAttributes['id'] = $event->uid;
	$html .= $obj->editor($event->fieldname, $content, $config);
	
	$event->setOutputEditor($html);
}


function ckeditor_getToolbar() {
	$registry = bab_getRegistryInstance();
	$registry->changeDirectory('/LibCkEditor');
	$return = array();
	if($registry->getValue('Templates', true)){
		$return[] = array('Templates');
	}
	
	$temp = array();
	if($registry->getValue('Cut', true)){
		$temp[] = 'Cut';
	}
	if($registry->getValue('Copy', true)){
		$temp[] = 'Copy';
	}
	if($registry->getValue('Paste', true)){
		$temp[] = 'Paste';
	}
	if($registry->getValue('PasteText', true)){
		$temp[] = 'PasteText';
	}
	if($registry->getValue('PasteFromWord', true)){
		$temp[] = 'PasteFromWord';
	}
	if(!empty($temp)){
		$return[] = $temp;
	}
	
	$temp = array();
	if($registry->getValue('Undo', true)){
		$temp[] = 'Undo';
	}
	if($registry->getValue('Redo', true)){
		$temp[] = 'Redo';
	}
	if(!empty($temp)){
		$return[] = $temp;
	}
	
	$temp = array();
	if($registry->getValue('Find', true)){
		$temp[] = 'Find';
	}
	if($registry->getValue('Replace', true)){
		$temp[] = 'Replace';
	}
	if($registry->getValue('SpellChecker', true)){
		$temp[] = 'SpellChecker';
	}
	if(!empty($temp)){
		$return[] = $temp;
	}
	
	$temp = array();
	if($registry->getValue('SelectAll', true)){
		$temp[] = 'SelectAll';
	}
	if($registry->getValue('RemoveFormat', true)){
		$temp[] = 'RemoveFormat';
	}
	if(!empty($temp)){
		$return[] = $temp;
	}
	
	$temp = array();
	if($registry->getValue('Maximize', true)){
		$temp[] = 'Maximize';
	}
	if($registry->getValue('Source', true)){
		$temp[] = 'Source';
	}
	if(!empty($temp)){
		$return[] = $temp;
	}
	
	$temp = array();
	if($registry->getValue('Bold', true)){
		$temp[] = 'Bold';
	}
	if($registry->getValue('Italic', true)){
		$temp[] = 'Italic';
	}
	if($registry->getValue('Underline', true)){
		$temp[] = 'Underline';
	}
	if($registry->getValue('Strike', true)){
		$temp[] = 'Strike';
	}
	if($registry->getValue('Subscript', true)){
		$temp[] = 'Subscript';
	}
	if($registry->getValue('Superscript', true)){
		$temp[] = 'Superscript';
	}
	if(!empty($temp)){
		$return[] = $temp;
	}
	
	$temp = array();
	if($registry->getValue('JustifyLeft', true)){
		$temp[] = 'JustifyLeft';
	}
	if($registry->getValue('JustifyCenter', true)){
		$temp[] = 'JustifyCenter';
	}
	if($registry->getValue('JustifyRight', true)){
		$temp[] = 'JustifyRight';
	}
	if($registry->getValue('JustifyBlock', true)){
		$temp[] = 'JustifyBlock';
	}
	if(!empty($temp)){
		$return[] = $temp;
	}
	
	$temp = array();
	if($registry->getValue('NumberedList', true)){
		$temp[] = 'NumberedList';
	}
	if($registry->getValue('BulletedList', true)){
		$temp[] = 'BulletedList';
	}
	if(!empty($temp)){
		$return[] = $temp;
	}
	
	$temp = array();
	if($registry->getValue('Outdent', true)){
		$temp[] = 'Outdent';
	}
	if($registry->getValue('Indent', true)){
		$temp[] = 'Indent';
	}
	if(!empty($temp)){
		$return[] = $temp;
	}
	
	$temp = array();
	if($registry->getValue('Table', true)){
		$temp[] = 'Table';
	}
	if($registry->getValue('HorizontalRule', true)){
		$temp[] = 'HorizontalRule';
	}
	if($registry->getValue('SpecialChar', true)){
		$temp[] = 'SpecialChar';
	}
	if(!empty($temp)){
		$return[] = $temp;
	}
	
	$temp = array();
	if($registry->getValue('Link', true)){
		$temp[] = 'Link';
	}
	if($registry->getValue('Unlink', true)){
		$temp[] = 'Unlink';
	}
	if($registry->getValue('Anchor', true)){
		$temp[] = 'Anchor';
	}
	if($registry->getValue('Ovidentia', true)){
		$temp[] = 'Ovidentia';
	}
	if(!empty($temp)){
		$return[] = $temp;
	}
	
	$temp = array();
	if($registry->getValue('Styles', false)){
		$temp[] = 'Styles';
	}
	if($registry->getValue('Format', true)){
		$temp[] = 'Format';
	}
	if($registry->getValue('Font', true)){
		$temp[] = 'Font';
	}
	if($registry->getValue('FontSize', true)){
		$temp[] = 'FontSize';
	}
	if(!empty($temp)){
		$return[] = $temp;
	}
	
	$temp = array();
	if($registry->getValue('TextColor', true)){
		$temp[] = 'TextColor';
	}
	if($registry->getValue('BGColor', true)){
		$temp[] = 'BGColor';
	}
	if(!empty($temp)){
		$return[] = $temp;
	}
	
	return $return;
}


/**
 * Ceci est une fonction evenementielle enregistree avec bab_addEventListener
 * elle sera appelee lorsque le formulaire est soumis et que le programme cherche a enregistrer le texte saisi dans la base
 *
 * @param	bab_eventEditorRequestToContent	&$event
 *
 */
function ckeditor_onRequestToContent(bab_eventEditorRequestToContent $event) {
	
	if ('html' !== bab_pp($event->fieldname.'_format')) {
		return;
	}
	
	$content = bab_pp($event->fieldname);
	bab_editor_record($content);
	$event->setOutputContent($content, 'html');
}

/**
 * Ceci est une fonction evenementielle enregistree avec bab_addEventListener
 * elle sera appelee lorsque du texte saisi par l'editeur doit etre affiche en html
 *
 * @param	bab_eventEditorContentToHtml	&$event
 *
 */
function ckeditor_onContentToHtml(bab_eventEditorContentToHtml $event) {

	
	if ('html' !== $event->format) {
		return;
	}
	
	if (null !== $event->output_html) {
		// allredy done by another editor
		return;
	}
	
	if ('' === $event->content)
	{
		$event->setOutputHtml('');
		return;
	}

	$event->setOutputHtml(bab_toHtml($event->content, BAB_HTML_REPLACE));
}

?>
