<?php
/************************************************************************
 * OVIDENTIA http://www.ovidentia.org                                   *
 ************************************************************************
 * Copyright (c) 2003 by CANTICO ( http://www.cantico.fr )              *
 *                                                                      *
 * This file is part of Ovidentia.                                      *
 *                                                                      *
 * Ovidentia is free software; you can redistribute it and/or modify    *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2, or (at your option)  *
 * any later version.													*
 *																		*
 * This program is distributed in the hope that it will be useful, but  *
 * WITHOUT ANY WARRANTY; without even the implied warranty of			*
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*
 * See the  GNU General Public License for more details.				*
 *																		*
 * You should have received a copy of the GNU General Public License	*
 * along with this program; if not, write to the Free Software			*
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,*
 * USA.																	*
************************************************************************/
require_once "base.php";

function LibFileManagement_upgrade($version_base, $version_ini)
{
	require_once $GLOBALS['babInstallPath'].'utilit/functionalityincl.php';
	$functionalities = new bab_functionalities();
	
	if (false === $functionalities->register('FileUploader', $GLOBALS['babAddonPhpPath'] . 'functionalities.php')) {
		return false; 
	}
	
	if (false === $functionalities->register('FileUploader/GenericUploader', $GLOBALS['babAddonPhpPath'] . 'functionalities.php')) {
		return false; 
	}
	
	if (false === $functionalities->register('FileUploader/ImageUploader', $GLOBALS['babAddonPhpPath'] . 'functionalities.php')) {
		return false; 
	}
	
	if (false === $functionalities->register('Thumbnailer', $GLOBALS['babAddonPhpPath'] . 'functionalities.php')) {
		return false; 
	}
	
	if (false === $functionalities->register('FileInfos', $GLOBALS['babAddonPhpPath'] . 'functionalities.php')) {
		return false; 
	}
	
	if (false === $functionalities->register('DirectoryManager', $GLOBALS['babAddonPhpPath'] . 'functionalities.php')) {
		return false; 
	}
	
	if (false === $functionalities->register('ExcelExport', $GLOBALS['babAddonPhpPath'] . 'excel.class.php')) {
		return false; 
	}
	
	if (false === $functionalities->register('FileListUploader', $GLOBALS['babAddonPhpPath'] . 'multiplefile.php')) {
		return false; 
	}
	
	$functionalities->register('Ovml/Function/Thumbnail', dirname(__FILE__).'/thumbnail_ovml.php');

	
	return true;
}



function LibFileManagement_onDeleteAddon() {

	require_once $GLOBALS['babInstallPath'].'utilit/functionalityincl.php';
	$functionalities = new bab_functionalities();

	if (false === $functionalities->unregister('FileUploader/ImageUploader')) {
		return false;
	}
	
	if (false === $functionalities->unregister('FileUploader/GenericUploader')) {
		return false;
	}
	
	if (false === $functionalities->unregister('FileUploader')) {
		return false;
	}
	
	if (false === $functionalities->unregister('Thumbnailer')) {
		return false;
	}
	
	if (false === $functionalities->unregister('FileInfos')) {
		return false;
	}
	
	if (false === $functionalities->unregister('DirectoryManager')) {
		return false;
	}
	
	if (false === $functionalities->unregister('ExcelExport')) {
		return false;
	}
	
	if (false === $functionalities->unregister('FileListUploader')) {
		return false;
	}
	
	$functionalities->unregister('Ovml/Function/Thumbnail');
	

	return true;
}