<?php
/************************************************************************
 * OVIDENTIA http://www.ovidentia.org                                   *
 ************************************************************************
 * Copyright (c) 2003 by CANTICO ( http://www.cantico.fr )              *
 *                                                                      *
 * This file is part of Ovidentia.                                      *
 *                                                                      *
 * Ovidentia is free software; you can redistribute it and/or modify    *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2, or (at your option)  *
 * any later version.													*
 *																		*
 * This program is distributed in the hope that it will be useful, but  *
 * WITHOUT ANY WARRANTY; without even the implied warranty of			*
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*
 * See the  GNU General Public License for more details.				*
 *																		*
 * You should have received a copy of the GNU General Public License	*
 * along with this program; if not, write to the Free Software			*
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,*
 * USA.																	*
************************************************************************/
require_once "base.php";

bab_functionality::includeFile('Ovml/Function');



/**
 * 
 * 
 * <OFThumbnail [ id_directory_entry="" | id_user="" ] maxwidth="" maxheight="" resizemode="KEEP_ASPECT_RATIO | CROP_CENTER" default="path/to/default/image.jpg">
 *
 */
class Func_Ovml_Function_Thumbnail extends Func_Ovml_Function
{
	public function toString()
	{
		$T = bab_functionality::get('Thumbnailer');
		/*@var $T Func_Thumbnailer */
		
		
		if (!$T || !count($this->args))
		{
			return '';
		}
		
		
		$maxwidth = 400;
		$maxheight = 400;
		$innerbordercolor = '#ffffff';
		$outerbordercolor = '#cccccc';
		$innerborderwidth = 0;
		$outerborderwidth = 0;
		$resizemode = Func_Thumbnailer::KEEP_ASPECT_RATIO;
		$default = null;
		$saveas = null;
	
		
		foreach ($this->args as $p => $v) {
			switch (mb_strtolower(trim($p))) {
				
				case 'maxwidth':
					$maxwidth = $v;
					break;

				case 'maxheight':
					$maxheight = $v;
					break;

				case 'innerborderwidth':
					$innerborderwidth = $v;
					break;
				case 'innerbordercolor':
					$innerbordercolor = $v;
					break;
				case 'innerborder':
					list($innerborderwidth, $innerbordercolor) = explode(',', $v);
					break;

				case 'outerborderwidth':
					$outerborderwidth = $v;
					break;
				case 'outerbordercolor':
					$outerbordercolor = $v;
					break;
				case 'outerborder':
					list($outerborderwidth, $outerbordercolor) = explode(',', $v);
					break;
					
				case 'resizemode':
					
					switch($v)
					{
						case 'KEEP_ASPECT_RATIO':
							$resizemode = Func_Thumbnailer::KEEP_ASPECT_RATIO;
							break;
						case 'CROP_CENTER':
							$resizemode = Func_Thumbnailer::CROP_CENTER;
							break;
					}
					
					break;
					
				case 'default':
					$default = $v;
					break;

				case 'saveas':
					$saveas = $v;
					break;
			}
		}
		
		
		
		// get image URL by method 
		$sourceset = false;

		foreach ($this->args as $p => $v) {
			switch (mb_strtolower(trim($p))) {
				
				case 'id_user':
					$sourceset = $this->setSource($T, bab_getDirEntry($v, BAB_DIR_ENTRY_ID_USER));
					true;
					break;
		
				case 'id_directory_entry':
					$sourceset = $this->setSource($T, bab_getDirEntry($v, BAB_DIR_ENTRY_ID));
					break;
		
			}
		}
		
		if (!$sourceset && null !== $default)
		{
			$T->setSourceFile($default);
		}
	
		
		if ($sourceset)	
		{
			$T->setResizeMode($resizemode);
			$T->setBorder($outerborderwidth, $outerbordercolor, $innerborderwidth, $innerbordercolor);
			$imageUrl = $T->getThumbnail($maxwidth, $maxheight);
		} else {
			$imageUrl = '';
		}
		
		if (isset($saveas)) {
			$this->gctx->push($saveas, $imageUrl);
			return '';
		}
		
		return $imageUrl;
	}
	
	/**
	 * 
	 * @param unknown_type $T
	 * @param unknown_type $entry
	 * 
	 * return bool
	 */
	private function setSource($T, $entry)
	{
		if (!$entry)
		{
			throw new Exception('<OFThumbnail> directory entry does not exists');
		}
		
		if (!isset($entry['jpegphoto']['photo']))
		{
			return false;
		}
		
		$photo = $entry['jpegphoto']['photo'];
		$data = $photo->getData();
		if (null !== $data && '' !== $data)
		{
			$T->setSourceBinary($data, $photo->lastUpdate());
			return true;
		}
		
		return false;
	}
}