<?php
/************************************************************************
 * OVIDENTIA http://www.ovidentia.org                                   *
 ************************************************************************
 * Copyright (c) 2003 by CANTICO ( http://www.cantico.fr )              *
 *                                                                      *
 * This file is part of Ovidentia.                                      *
 *                                                                      *
 * Ovidentia is free software; you can redistribute it and/or modify    *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2, or (at your option)  *
 * any later version.													*
 *																		*
 * This program is distributed in the hope that it will be useful, but  *
 * WITHOUT ANY WARRANTY; without even the implied warranty of			*
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*
 * See the  GNU General Public License for more details.				*
 *																		*
 * You should have received a copy of the GNU General Public License	*
 * along with this program; if not, write to the Free Software			*
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,*
 * USA.																	*
************************************************************************/
require_once "base.php";
 

require_once dirname(__FILE__).'/functions.php';
require_once $GLOBALS['babInstallPath'].'utilit/uploadincl.php';
require_once $GLOBALS['babInstallPath'].'utilit/urlincl.php';






/**
 * Check if uploaded file is autorized
 * @param	string	$filepath
 * @param	string	&$error
 *
 * @param	boolean
 */
function lfm_suportedFileType($filepath, &$error) {

	$classname = bab_rp('classname');
	
	
	if ('Func_FileUploader_ImageUploader' === $classname) {
		
		$image_info = getImageSize($filepath) ; 
  
	   	switch ($image_info['mime']) {
		   case 'image/gif':
			   if (!(imagetypes() & IMG_GIF))  { 
				   $error = lfm_translate('GIF images are not supported');
				   return false;
			   }
			   break;
		   case 'image/jpeg':
			   if (!(imagetypes() & IMG_JPG))  {
				   $error = lfm_translate('JPEG images are not supported');
				   return false;
			   }
			   break;
		   case 'image/png':
			   if (!(imagetypes() & IMG_PNG))  {
				   $error = lfm_translate('PNG images are not supported');
				   return false;
			   }
			   break;
		   default:
			   $error = lfm_translate('This file format is not supported, the file must be an image');
			   return false;
	   	}
	}
	
	
	return true;

}












function lfm_iframeGeneric() {

	global $babBody;
	
	$tocken = bab_rp('tocken');
	
	if (!$tocken || !isset($_SESSION['LibFileManagement']['FileUploader'][$tocken]))
	{
		throw new Exception('missing tocken');
	}
	
	$arr = $_SESSION['LibFileManagement']['FileUploader'][$tocken];
	
	if (!$arr)
	{
		throw new Exception('missing required session informations');
	}
	
	$file_uid = $arr['uid'];
	$multiple = $arr['multiple'];
	$classname = $arr['classname'];
	

	if (1 === (int) bab_gp('delete')) {

		$file = lfm_getDirectory($file_uid).'/'.bab_rp('filename');
		unlink($file);
		header('location:'.bab_url::request('tg', 'idx', 'tocken'));
		exit;
	}
	
	
	
	if (1 === (int) bab_gp('delete_all')) {

		lfm_emptyDirectory($file_uid);
		header('location:'.bab_url::request('tg', 'idx', 'tocken'));
		exit;
	}
	
	
	
	$directory = lfm_getDirectory($file_uid);
			
	if (!empty($_POST) && false === $multiple) {
		lfm_emptyDirectory($file_uid);
	}
	
	if ($upload = bab_fileHandler::upload('Filedata')) {
		
		if ($upload->error) {
			header("HTTP/1.1 500 Internal Server Error");
			die($upload->error);
		} else {
		
			$upload->import($directory.bab_getStringAccordingToDatabase($upload->filename, 'UTF-8'));
			
			$error = '';
		
			if (!lfm_suportedFileType($directory.$upload->filename, $error)) {
				$file = lfm_getDirectory($file_uid).'/'.$upload->filename;
				unlink($file);
				header("HTTP/1.1 500 Internal Server Error");
				die($error);
			}
		
			echo "File Received";
			exit(0);
		}
	}
	

	
	if ($upload = bab_fileHandler::upload('lfm_file_upload')) {

		if ($upload->error) {
			$babBody->addError($upload->error);
		} else {

			$upload->import($directory.$upload->filename);
			
			$error = '';
		
			if (!lfm_suportedFileType($directory.$upload->filename, $error)) {
				$file = lfm_getDirectory($file_uid).'/'.$upload->filename;
				unlink($file);
				$babBody->addError($error);
			}
		}
	}

	
	require_once dirname(__FILE__).'/thumbnail.php';
	

	class temp {
	
		var $addon;
		var $files;
		var $uid;
		var $tocken;
		
		var $filename;
	
		function temp() {
			$this->addon = bab_getAddonInfosInstance('LibFileManagement');
			$this->filename = false;
			
			$this->session_name = session_name();
			$this->session_id = session_id();
			
			$this->refresh_url = bab_url::request('tg', 'idx', 'tocken');
			$this->t_upload_multiple = lfm_translate('Upload multiple files');
			
			$this->t_error_on_file = bab_toHtml(lfm_translate('Error on file'), BAB_HTML_JS);
		}
		
		
		
		function deleteall() {
			
			static $i = 0;
			$nb = count($this->files);
			
			if (0 === $i && $nb > 1) {

				$url = $this->addon->getUrl().'upload';
				$url = bab_url::mod($url,'idx',bab_rp('idx'));
				$url = bab_url::mod($url,'delete_all',1);
				$url = bab_url::mod($url,'tocken', $this->tocken);
				
				$this->deleteallurl = bab_toHtml($url);
				$this->t_delete_all_confirm = lfm_translate('Do you really want to delete all files?');
				$i++;
				return true;
			}
			$i++;
			return false;
		}
		
	
	
		function getnextfile() {
		
			if (list(,$filepath) = each($this->files)) {
	
				$filename = basename($filepath);
				$this->filename = bab_toHtml($filename);
				
				$this->filesize = bab_toHtml(sprintf("%01.2f %s",(filesize($filepath)/1024), lfm_translate('Ko')));
				
				$url = $this->addon->getUrl().'upload';
				$url = bab_url::mod($url,'idx',bab_rp('idx'));
				$url = bab_url::mod($url,'delete',1);
				$url = bab_url::mod($url,'tocken', $this->tocken);
				$url = bab_url::mod($url,'filename', $filename);

				
				$this->deleteurl = bab_toHtml($url);
				
				$func = bab_functionality::get('FileUploader');
				$func->setFileUid($this->uid);
				$url = $func->getDownloadUrl();
				$url = bab_url::mod($url,'filename', $filename);
				
				$this->downloadurl = bab_toHtml($url);
				$icon = new lfm_FileIcon($filepath, 32, 32);
				$this->iconurl = $icon->__tostring();

				return true;
			}
			
			return false;
		}

	}
	

	$temp = new temp();
	
	$temp->t_no_file = lfm_translate('No file uploaded');
	$temp->t_delete_confirm = lfm_translate('Do you really want to delete the file?');
	$temp->t_upload = lfm_translate('Upload the file');
	$temp->t_delete = lfm_translate('Delete the file');
	
	$temp->stylePath = $temp->addon->getStylePath();
	$temp->target = $temp->addon->getTarget();
	$temp->templatePath = $temp->addon->getTemplatePath();
	
	$temp->uid = $file_uid;
	$temp->tocken = $tocken;
	$temp->tocken_html = bab_toHtml($tocken);
	$temp->classname = bab_toHtml($classname);
	
	$temp->bodyclass = $multiple ? 'multiple' : 'simple';
	$temp->multiple = $multiple ? '1' : '0';
	
	
	

	$filepath = lfm_getFile($file_uid);
	
	if (!empty($babBody->msgerror)) {
		$temp->error = $babBody->msgerror;
	} else {
		$temp->error = false;
	}
	
	$temp->files = lfm_getFiles($file_uid);
	
	
	die(bab_printTemplate($temp, $temp->addon->getRelativePath().'uploader.html', 'generic'));
}










// main

$idx = bab_rp('idx', 'iframe_generic');


switch($idx) {


	
	case 'iframe_generic':
		lfm_iframeGeneric();
		break;

}