<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2008 by CANTICO ({@link http://www.cantico.fr})
 */
include_once 'base.php';
require_once dirname(__FILE__).'/functions.php';
require_once $GLOBALS['babInstallPath'].'utilit/urlincl.php';

class LibTimer_ConfigurationPage
{
	
	
	private function getForm()
	{
		$W = bab_functionality::get('Widgets');
		/*@var $W Func_Widgets */
		
		$form = $W->Form();
		$form->setName('configuration');
		$form->setHiddenValue('tg', bab_rp('tg'));
		
		$radioSet = $W->RadioSet()->setName('method');
		$radioSet->addOption('url', sprintf(libtimer_translate('Execute scheduled tasks when this link is called : %s'), $GLOBALS['babUrlScript'].'?tg=addon/LibTimer/call'));
		$radioSet->addOption('page', libtimer_translate('Try to execute scheduled tasks while users browse the site'));
		$radioSet->addOption('deamon', libtimer_translate('Try to execute scheduled tasks in background (linux server only)'));
		
		$form->addItem($radioSet);
		
		$form->addItem(
			$W->SubmitButton()
				->setLabel(libtimer_translate('Save'))
		);
		
		$registry = bab_getRegistryInstance();
		$registry->changeDirectory('/LibTimer/');
		
		$method = $registry->getValue('method', 'page');
		
		$form->setValues(array('configuration' => array('method' => $method)));
		
		return $form;
	}
	
	
	private function getLogTable()
	{
		$W = bab_functionality::get('Widgets');
		/*@var $W Func_Widgets */
		
		$table = $W->TableView();
		$table->addSection('Header');
		
		$table->addItem($W->Label(libtimer_translate('Module'))		, 0,0);
		$table->addItem($W->Label(libtimer_translate('Description')), 0,1);
		$table->addItem($W->Label(libtimer_translate('Date'))		, 0,2);
		$table->addItem($W->Label(libtimer_translate('Event'))		, 0,3);
		
		global $babDB;
		
		$res = $babDB->db_query('SELECT * FROM libtimer_log ORDER BY created DESC LIMIT 0,100');
		$row = 1;
		$table->addSection('Body');
		
		while ($arr = $babDB->db_fetch_assoc($res))
		{
			$table->addItem($W->Label($arr['module'])		, $row,0);
			$table->addItem($W->Label($arr['description'])	, $row,1);
			$table->addItem($W->Label($arr['created'])		, $row,2);
			$table->addItem($W->Label($arr['event'])		, $row,3);
			$row++;
		}
		
		return $table;
	}
	
	
	public function display()
	{
		$W = bab_functionality::get('Widgets');
		/*@var $W Func_Widgets */
		$page = $W->BabPage();
		
		
		
		$url = bab_url::get_request('tg');
		$url->idx = 'form';
		$page->addItemMenu('form', libtimer_translate('Configuration'), $url->toString());
		$url->idx = 'log';
		$page->addItemMenu('log', libtimer_translate('Scheduled tasks log'), $url->toString());
		$idx = bab_rp('idx', 'form');
		$page->setCurrentItemMenu($idx);
		
		switch($idx)
		{
			case 'form':
				$page->setTitle(libtimer_translate('Scheduled tasks options'));
				$page->addItem($this->getForm());
				break;
			case 'log':
				$page->setTitle(libtimer_translate('Scheduled tasks log'));
				$page->addItem($this->getLogTable());
				break;
			
		}
		$page->displayHtml();
	}
	
	
	public function save($configuration)
	{
		$registry = bab_getRegistryInstance();
		$registry->changeDirectory('/LibTimer/');
		
		$registry->setKeyValue('method', $configuration['method']);
	}
}


if (!bab_isUserAdministrator())
{
	return;
}


$page = new LibTimer_ConfigurationPage;

if (!empty($_POST))
{
	$page->save(bab_pp('configuration'));
}

$page->display();