<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2008 by CANTICO ({@link http://www.cantico.fr})
 */
include_once 'base.php';
require_once dirname(__FILE__).'/functions.php';


class LibTimer_Deamon
{

	private static function execCmd($cmd) {
	
		$handle = popen($cmd, 'r');
		if ($handle) {
			$buffer = '';
			while(!feof($handle)) {
			   $buffer .= fgets($handle, 1024);
			}
			pclose($handle);
			return $buffer;
		} 
		
		return false;
	}
	



	/**
	 * start php process
	 * @throws ErrorException
	 * @return bool
	 */
	public function start()
	{
		// search for php executable
		
		$arr = explode(' ', self::execCmd('whereis php'));
		if (count($arr) < 2) {
			throw new ErrorException(libtimer_translate('php executable not found'));
			return false;
		}
		unset($arr[0]);
		
		$bin = reset($arr);
		$command = $bin.' index.php "tg=addon/LibTimer/deamon"';
		exec($command.' > /dev/null &');
		
		if (!$this->isStarted())
		{
			throw new ErrorException(libtimer_translate('Error, the deamon has not started'));
			return false;
		}
		
		return true;
	}
	
	
	
	/**
	 * 
	 * @return unknown_type
	 */
	public function kill()
	{
		exec("kill $(ps ax | grep 'php index.php tg=addon/LibTimer/deamon' | grep -v grep | awk '{print $1}')");
	}
	
	
	/**
	 * 
	 * @return bool
	 */
	public function isStarted()
	{
		$ps = self::execCmd("ps ax | grep 'php index.php tg=addon/LibTimer/deamon' | grep -v grep");
		return !empty($ps);
	}
	
	/**
	 * Restart deamon automaticaly if stopped and if it has been started manually before
	 * try this for each new user session
	 * @return unknown_type
	 */
	public static function autoRestart()
	{
		//if (isset($_SESSION['LibTimer_deamon_started_once']))
		//{
		//	return;
		//}
		
		// processed one time in session, failed or not
		$_SESSION['LibTimer_deamon_started_once'] = 1;
		
		$D = new LibTimer_Deamon;
		
		if ($D->isStarted())
		{
			return;
		}
		
		try {
			$D->start();
		} catch(ErrorException $e)
		{
			bab_debug($e->getMessage());
		}
		
		
	}
}