<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2008 by CANTICO ({@link http://www.cantico.fr})
 */
require_once 'base.php';


/**
 * The version of jquery
 */
define('JQUERY_VERSION', '1_7_1_1');


/**
 * The JQUERY_COMPRESSION_xxx constants define the different types of compression
 * available for jquery files.
 *
 * @deprecated	since 1.3.2. Use Func_Jquery constants instead
 */
define('JQUERY_COMPRESSION_MINIFIED', 'minified');
define('JQUERY_COMPRESSION_PACKED', 'packed');
define('JQUERY_COMPRESSION_NONE', 'scripts');


/**
 * This functionality provides the possibility to includes jquery scripts in a page.
 */
class Func_Jquery extends bab_Functionality
{
	private $baseScriptsPath;
	private $baseStylesPath;
	private $compressionType;

	private $noConflictAdded = false;

	/**
	 * The page object in which scripts will be included.
	 * @var object
	 */
	private $page;

	/**
	 * @var string	Included files will be compressed (recommended for production).
	 */
	const COMPRESSION_MINIFIED = 'minified';

	/**
	 * @var string	Now equivalent to COMPRESSION_MINIFIED.
	 * @deprecated	Since 1.3.2 Use COMPRESSION_MINIFIED instead
	 */
	const COMPRESSION_PACKED = 'minified';

	/**
	 * @var string	Included files will not be compressed (recommended for javascript debugging).
	 */
	const COMPRESSION_NONE = 'scripts';


	function __construct()
	{
		$this->baseScriptsPath = $GLOBALS['babInstallPath'] . 'addons/jquery/';
		$this->baseStylesPath = $GLOBALS['babInstallPath'] . 'styles/addons/jquery/';
		$this->baseStylesPath = 'addons/jquery/';
		if (isset($_COOKIE['bab_debug'])) {
			$this->setCompression(self::COMPRESSION_NONE);
		} else {
			$this->setCompression(self::COMPRESSION_MINIFIED);
		}
		$this->page = $GLOBALS['babBody'];
	}


	/**
	 * Selects the compression that will be used for included javascript files.
	 *
	 * The $compressionType string can be any of the following constants:
	 * - JQUERY_COMPRESSION_MINIFIED
	 * - JQUERY_COMPRESSION_NONE
	 *
	 * @param string $compressionType		One of the JQUERY_COMPRESSION_xxx constants.
	 * @return string		The actually selected compression type.
	 */
	function setCompression($compressionType)
	{
		switch ($compressionType) {
			case self::COMPRESSION_MINIFIED:
			case self::COMPRESSION_NONE:
				$this->compressionType = $compressionType;
				break;
		}
		return $this->compressionType;
	}


	function getDescription() {
		return 'Includes jquery scripts';
	}


	protected function useCDN()
	{
		return (isset($GLOBALS['babUseJQueryCDN']) && $GLOBALS['babUseJQueryCDN'] == true);
	}

	/**
	 * Returns the url to the specified javascript file.
	 *
	 * @param string $filename
	 * @return string
	 */
	function getJavascriptUrl($filename)
	{
		if ($this->useCDN()) {
			if ($this->compressionType === self::COMPRESSION_MINIFIED) {
				$min = '.min';
			} else {
				$min = '';
			}
			switch ($filename) {
				case 'jquery':
					$this->page->addJavascriptFile('https://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery' . $min . '.js');
					break;
				case 'jquery-ui':
					$this->page->addJavascriptFile('https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.16/jquery-ui' . $min . '.js');
					break;
			}
		} else {

			switch ($this->compressionType) {
				case self::COMPRESSION_MINIFIED:
					return $this->baseScriptsPath . 'scripts/minified/' . $filename . '.min.js?version=' . JQUERY_VERSION;
				case self::COMPRESSION_NONE:
					return $this->baseScriptsPath . 'scripts/' . $filename . '.js?version=' . JQUERY_VERSION;
			}

		}
		return '';
	}

	/**
	 * Returns the url to the specified theme css file.
	 *
	 * @param string $theme
	 * @return string
	 */
	function getStyleSheetUrl($theme = '')
	{
		switch ($theme) {
			case 'base':
			default:
				return $this->baseStylesPath . 'base/jquery-ui.css?version=' . JQUERY_VERSION;
				
			case 'mobile':
				return $this->baseStylesPath . 'mobile/jquery.mobile.css?version=' . JQUERY_VERSION;
		}
		return '';
	}

	/**
	 * Returns the url to the specified localization script for the specified language.
	 *
	 * @param string $lang	or null for all available languages
	 * @return string
	 */
	function getI18nUrl($lang = null)
	{
		if ($this->useCDN()) {
			if ($this->compressionType === self::COMPRESSION_MINIFIED) {
				$min = '.min';
			} else {
				$min = '';
			}
			if (isset($lang)) {
				return 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.16/i18n/jquery.ui.datepicker-' . $lang . $min . '.js';
			}
		} else {
			if (isset($lang)) {
				return $this->baseScriptsPath . 'scripts/i18n/jquery.ui.datepicker-' . $lang . '.js?version=' . JQUERY_VERSION;
			}
		}
	}


	/**
	 * Adds the specified jquery javascript file to the current ovidentia page.
	 *
	 * @param string $filename
	 * @access protected
	 */
	function addJavascriptFile($filename)
	{
		include_once $GLOBALS['babInstallPath'] . '/utilit/devtools.php';

		$this->page->addJavascriptFile($this->getJavascriptUrl($filename));
	}


	function includeCore($noConflict = false)
	{
		if ($noConflict) {
			$this->addJavascriptFile('jquery');
			if (!$this->noConflictAdded) {
				$this->page->addJavascript('jQuery.noConflict();' . "\n");
				$this->noConflictAdded = true;
			}
		} else {
			$this->addJavascriptFile('jquery');
		}
	}

	function includeUi()
	{
		$this->addJavascriptFile('jquery-ui');
	}


	function includeMobile()
	{
		$this->addJavascriptFile('jquery.mobile');
	}

	
	/**
	 * @deprecated use Func_Jquery::includeUi()
	 */
	function includeUiCore()
	{
		$this->addJavascriptFile('jquery-ui');
	}


	/**
	 * @deprecated use Func_Jquery::includeUi()
	 */
	function includeEffectsCore()
	{
		$this->addJavascriptFile('jquery-ui');
	}


	/**
	 * @deprecated use Func_Jquery::includeUi()
	 */
	function includeEffects()
	{
		$this->addJavascriptFile('jquery-ui');
	}




	
	/**
	 * 
	 * @return string
	 */
	public function getLightboxJavascriptFile()
	{
		return $GLOBALS['babInstallPath'] . 'addons/jquery/jquery-lightbox/js/jquery.lightbox.js?version=' . JQUERY_VERSION;
	}
	
	/**
	 * 
	 * @return string
	 */
	public function getLightboxStyleSheet()
	{
		return $GLOBALS['babInstallPath'] . 'addons/jquery/jquery-lightbox/css/jquery.lightbox.css';
	}
	
	
	/**
	 * Include the lightbox jquery plugin
	 * @see http://leandrovieira.com/projects/jquery/lightbox/
	 * 
	 * @param	Widget_Page | babBody	$page
	 */
	public function includeLightbox($page = null)
	{
		if (null === $page)
		{
			$page = $this->page;
		}

		
		/*@var $page babBody */
		
		$page->addJavascriptFile($this->getLightboxJavascriptFile());
		$page->addStyleSheet($this->getLightboxStyleSheet());
	}

}
