<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2008 by CANTICO ({@link http://www.cantico.fr})
 */
include_once 'base.php';
require_once dirname(__FILE__).'/functions.php';


class mailspooler_configEditor
{
	private function getForm()
	{
		$W = bab_functionality::get('Widgets');
		/*@var $W Func_Widgets */
		
		$form = $W->Form();
		$form->setName('configuration');
		$form->setHiddenValue('tg', bab_rp('tg'));
		
		$radioSet = $W->RadioSet()->setName('method');
		$radioSet->addOption('realtime', mailspooler_translate('Send mail imediately'));
		$radioSet->addOption('timed', mailspooler_translate('Send mail periodically every fives minutes (experimental)'));
		
		$form->addItem($radioSet);
		
		$form->addItem(
			$W->SubmitButton()
				->setLabel(mailspooler_translate('Save'))
		);
		
		$registry = bab_getRegistryInstance();
		$registry->changeDirectory('/mailspooler/');
		
		$method = $registry->getValue('method');
		
		$form->setValues(array('configuration' => array('method' => $method)));
		
		return $form;
	}
	
	
	
	public function display()
	{
		$W = bab_functionality::get('Widgets');
		/*@var $W Func_Widgets */
		$page = $W->BabPage();

		$page->setTitle(mailspooler_translate('Mail spooler options'));
		$page->addItem($W->Link(mailspooler_translate('Unsent mail list'), '?tg=addon/mailspooler/mailspool'));
		$page->addItem($this->getForm());

		$page->displayHtml();
	}
	
	
	
	public function save(Array $configuration)
	{
		$registry = bab_getRegistryInstance();
		$registry->changeDirectory('/mailspooler/');
		
		$registry->setKeyValue('method', $configuration['method']);
	}
}





if (!bab_isUserAdministrator())
{
	return;
}


$page = new mailspooler_configEditor;

if (!empty($_POST))
{
	$page->save(bab_pp('configuration'));
}

$page->display();