<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2008 by CANTICO ({@link http://www.cantico.fr})
 */
include_once 'base.php';
require_once dirname(__FILE__).'/mail.class.php';

/**
 * 
 * @param bab_eventBeforeMailSent $event
 * @return unknown_type
 */
function mailspooler_onBeforeMailSent(bab_eventBeforeMailSent $event)
{
	// permet d'enregistrer le mail et d'annuler son envoi automatique
	
	$registry = bab_getRegistryInstance();
	$registry->changeDirectory('/mailspooler/');
	if ('timed' === $registry->getValue('method'))
	{
		$mail = new mailspooler_mail;
		$mail->recordMail($event);
		$event->cancel(true);
	}
}


/**
 * 
 * @param bab_eventAfterMailSent $event
 * @return unknown_type
 */
function mailspooler_onAfterMailSent(bab_eventAfterMailSent $event)
{
	$mail = new mailspooler_mail;
	
	
	if ($event->hash)
	{
		// update mailspooler status or delete row if the mail is associated to a hash
		
		global $babDB;
		
		if (!$event->sent_status) {
			
			$babDB->db_query("
					UPDATE mailspooler_mail SET 
						sent_status=".$babDB->quote($event->sent_status).",  
						error_msg=".$babDB->quote($event->ErrorInfo)." 
					WHERE mail_hash=".$babDB->quote($event->hash)
			);
			
			
		} else {
			
			$res = $babDB->db_query('
					SELECT * FROM mailspooler_mail WHERE mail_hash='.$babDB->quote($event->hash).'
					');
			
			while ($arr = $babDB->db_fetch_assoc($res))
			{
				$mail->deleteEmail($arr);
			}
		}
		
	} else if (!$event->sent_status) {
		
		// if no hash, the mail is not in spooler, add it if sending failed
		
		$mail->recordMail($event);
	}
}


/**
 * 
 * @param LibTimer_eventEvery5Min $event
 * @return unknown_type
 */
function mailspooler_onEvery5Min(LibTimer_eventEvery5Min $event)
{
	$mail = new mailspooler_mail;
	
	try {
		$n = $mail->sendWaiting();
	} catch (ErrorException $e)
	{
		$event->log('mailspooler', 'ErrorException : '.$e->getMessage());
		$n = 0;
	}
	
	if ($n > 0)
	{
		$event->log('mailspooler', sprintf('%d mail sent', $n));
	}
}