<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2008 by CANTICO ({@link http://www.cantico.fr})
 */
include_once 'base.php';




function mailspooler_upgrade($version_base,$version_ini)
{
	include_once $GLOBALS['babInstallPath']."utilit/eventincl.php";
	include_once $GLOBALS['babInstallPath']."utilit/path.class.php";
	include_once $GLOBALS['babInstallPath']."utilit/devtools.php";
	require_once $GLOBALS['babInstallPath'].'utilit/functionalityincl.php';
	
	bab_addEventListener('bab_eventBeforeMailSent'		, 'mailspooler_onBeforeMailSent'	, 'addons/mailspooler/events.php', 'mailspooler');
	bab_addEventListener('bab_eventAfterMailSent'		, 'mailspooler_onAfterMailSent'	, 'addons/mailspooler/events.php', 'mailspooler');
	bab_addEventListener('LibTimer_eventEvery5Min'		, 'mailspooler_onEvery5Min'	, 'addons/mailspooler/events.php', 'mailspooler');
	
	
	$addon = bab_getAddonInfosInstance('mailspooler');
	$tables = new bab_synchronizeSql($addon->getPhpPath().'dump.sql');
	
	if ($tables->isCreatedTable('mailspooler_mail') && bab_isTable('bab_mail_spooler'))
	{
		// reprise des donnes de la table du noyau
		global $babDB;
		
		$babDB->db_query('INSERT INTO mailspooler_mail SELECT * FROM bab_mail_spooler');
		$babDB->db_query('TRUNCATE bab_mail_spooler');
		
		// deplacer les pieces jointes
		if (is_dir($GLOBALS['babUploadPath'].'/mail/'))
		{
			$target = new bab_Path($addon->getUploadPath());
			$target->createDir();
			$target->push('mail');
			
			if (!$target->isDir())
			{
				rename($GLOBALS['babUploadPath'].'/mail/', $target->toString());
			}
		}
	}
	
	
	$addonInfo = bab_getAddonInfosInstance('mailspooler');
	
	
	$functionalities = new bab_functionalities();
	$functionalities->registerClass('Func_Mailspooler', $addonInfo->getPhpPath() . 'mailspooler.class.php');
	
	
	return true;
}






function mailspooler_onDeleteAddon()
{
	include_once $GLOBALS['babInstallPath']."utilit/eventincl.php";
	require_once $GLOBALS['babInstallPath'].'utilit/functionalityincl.php';
	
	bab_removeEventListener('bab_eventBeforeMailSent', 'mailspooler_onBeforeMailSent', 'addons/mailspooler/events.php');
	bab_removeEventListener('bab_eventAfterMailSent', 'mailspooler_onAfterMailSent', 'addons/mailspooler/events.php');
	bab_removeEventListener('LibTimer_eventEvery5Min', 'mailspooler_onEvery5Min', 'addons/mailspooler/events.php');
	
	
	$functionalities = new bab_functionalities();
	$functionalities->unregister('Mailspooler');
	
	return true;
}



