<?php
/************************************************************************
 * OVIDENTIA http://www.ovidentia.org                                   *
 ************************************************************************
 * Copyright (c) 2003 by CANTICO ( http://www.cantico.fr )              *
 *                                                                      *
 * This file is part of Ovidentia.                                      *
 *                                                                      *
 * Ovidentia is free software; you can redistribute it and/or modify    *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2, or (at your option)  *
 * any later version.													*
 *																		*
 * This program is distributed in the hope that it will be useful, but  *
 * WITHOUT ANY WARRANTY; without even the implied warranty of			*
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*
 * See the  GNU General Public License for more details.				*
 *																		*
 * You should have received a copy of the GNU General Public License	*
 * along with this program; if not, write to the Free Software			*
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,*
 * USA.																	*
************************************************************************/
include_once "base.php";
require_once dirname(__FILE__).'/functions.php';

function mailspool() {
	global $babBody;
	class temp
		{
		var $altbg = true;

		function temp()
			{
			$this->t_mail_subject = mailspooler_translate("Mail subject");
			$this->t_mail_date = mailspooler_translate("Date");
			$this->t_send = mailspooler_translate("Send");
			$this->t_delete = mailspooler_translate("Delete");
			$this->checkall = mailspooler_translate("Check all");
			$this->uncheckall = mailspooler_translate("Uncheck all");
			$this->t_waiting = mailspooler_translate("Wait for sending");

			$this->db = $GLOBALS['babDB'];
			

			$this->res = $this->db->db_query("
			SELECT 
				id,
				mail_subject, 
				UNIX_TIMESTAMP(mail_date) mail_date,
				error_msg, 
				sent_status  
			FROM mailspooler_mail 
				ORDER BY mail_date DESC
				");
			$this->count = $this->db->db_num_rows($this->res);
			}

		function getnext()
			{
			if ($arr = $this->db->db_fetch_assoc($this->res)) {
				$this->id = $arr['id'];
				$this->altbg = !$this->altbg;
				$this->mail_subject = bab_toHtml($arr['mail_subject']);
				$this->mail_date = bab_toHtml(bab_longDate($arr['mail_date']));
				$this->error_msg = bab_toHtml($arr['error_msg']);
				$this->waiting = null === $arr['sent_status'];
				return true;
			}
			return false;
		}
	}

	$temp = new temp();
	$babBody->babecho(bab_printTemplate($temp, "addons/mailspooler/mailspool.html", "list"));
}








function send_checked_mail() {

	global $babBody;
	include_once $GLOBALS['babInstallPath']."utilit/mailincl.php";
	include_once dirname(__FILE__).'/mail.class.php';

	$db = $GLOBALS['babDB'];
	$mail = bab_rp('mail', false);
	if ($mail) {

		$mail_obj = bab_mail();

		if (!$mail_obj) {
			$babBody->msgerror = mailspooler_translate("Mail is not configured");
			return false;
		}

		$res = $db->db_query("
			SELECT * FROM mailspooler_mail WHERE id IN(".$db->quote($mail).")
		");
		
		$spooler = new mailspooler_mail;
		
		try {

			while ($arr = $db->db_fetch_assoc($res)) {
				$spooler->sendMail($mail_obj, $arr);
			}
		
		} catch(ErrorException $e)
		{
			$babBody->addError($e->getMessage());
		}
	}
}



function delete_checked_mail() {
	global $babDB;
	include_once dirname(__FILE__).'/mail.class.php';

	$mail = bab_rp('mail', false);
	$spooler = new mailspooler_mail;
	
	if ($mail) {
	
		$res = $babDB->db_query('
			SELECT * FROM mailspooler_mail WHERE id IN('.$babDB->quote($mail).')
		');
		
		while ($arr = $babDB->db_fetch_assoc($res)) {
			$spooler->deleteEmail($arr);
		}

		
	}
}



/* main */

if( !bab_isUserAdministrator() )
{
	$babBody->addError(mailspooler_translate("Access denied"));
	return;
}

$idx = bab_rp('idx', 'list');
$item = bab_rp('item', 1); /* id site */

if (isset($_POST['send'])) {
	send_checked_mail();
}

if (isset($_POST['delete'])) {
	delete_checked_mail();
}


switch($idx)
	{

	case "list":
		mailspool();
		$babBody->title = mailspooler_translate("Undelivered mails");
		$babBody->addItemMenu("list", mailspooler_translate("Mails"), $GLOBALS['babUrlScript']."?tg=addon/mailspooler/mailspool&idx=list");
		break;
	}
$babBody->setCurrentItemMenu($idx);

?>
