<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2008 by CANTICO ({@link http://www.cantico.fr})
 */
include_once 'base.php';


include_once dirname(__FILE__)."/functions.php";


function portal_summary_upgrade($version_base,$version_ini)
{

	global $babBody;
	include_once $GLOBALS['babInstallPath'].'utilit/eventincl.php';
	bab_addEventListener('bab_eventBeforeSiteMapCreated'				,'portal_summary_onBeforeSiteMapCreated'		,'addons/portal_summary/init.php'		, 'portal_summary');


	return true;
}



function portal_summary_onDeleteAddon()
{
	
	// detach events
	include_once $GLOBALS['babInstallPath']."utilit/eventincl.php";
	bab_removeEventListener('bab_eventBeforeSiteMapCreated'				,'portal_summary_onBeforeSiteMapCreated'		,'addons/portal_summary/init.php');
	
	return true;
}


function portal_summary_onBeforeSiteMapCreated($event) 
{
	$delegations = bab_getUserVisiblesDelegations();

 
	bab_debug($delegations);

	foreach($delegations as $id_delegation => $deleg) {
	 
		$core_prefix = false === $deleg['id'] ? 'bab' : 'babDG'.$deleg['id'];
		$addon_prefix = false === $deleg['id'] ? 'portalSummary' : 'portalSummaryDG'.$deleg['id'];
	 
		$link = $event->createItem($addon_prefix.'Home');
		$link->setLabel(portal_summary_translate('Summary'));
		$link->setDescription(portal_summary_translate('Last published items'));
		$link->setLink('?tg=addon/portal_summary/main');
		$link->setPosition(array('root', $id_delegation, $core_prefix.'User', $core_prefix.'UserSection'));
		$link->addIconClassname('apps-summary');

		$event->addFunction($link);
	}
}

