/**
 * Creates a cookie
 * If expiration does not exist, the cookie is available only for the session
 * To delete a cookie, it is necessary to put expiration in 0
 * Example: ovidentia_themedefaut_savecookie("count", 10, (new Date(2010, 12).getTime()));
 */
function ovidentia_themedefaut_setcookie(nom, valeur, expiration) {
	if (expiration != undefined && expiration != "") {
		var timestamp = new Date(expiration);
		document.cookie = nom + "=" + escape(valeur) + "; expires=" + timestamp.toGMTString();
	} else {
		document.cookie = nom + "=" + escape(valeur) + "; expires=";
	}
}

/**
 * Recovers the data from a cookie
 * Return empty string if the cookie is not defined
 */
function ovidentia_themedefaut_getcookie(name) {
	var cookies = document.cookie.split(/;/);
	for(var i=0;i<=cookies.length - 1;i++) {
		var cook = cookies[i].split(/=/);
		cook[0] = cook[0].replace(/(^\s*)|(\s*$)/g,"");
		if (cook[0] == name) {
			return unescape(cook[1]);
		}
	}
	return '';
}

function bab_elementHasClass(element, className)
{
	var regExp = RegExp('(\\s|^)' + className + '(\\s|$)');
	return element.className.match(regExp);
}

function bab_elementAddClass(element, className)
{
	if (!bab_elementHasClass(element, className)) {
		element.className += ' ' + className;
	}
}

function bab_elementRemoveClass(element, className)
{
	if (bab_elementHasClass(element, className)) {
		var regExp = new RegExp('(\\s|^)' + className + '(\\s|$)');
		element.className = element.className.replace(regExp,' ');
	}
}


/**
 * Toggles the full page view: expands/shrinks the body of the
 * page by hiding/showing the header and the sections.
 */
function ovidentia_themedefaut_fullbody()
{
	var cookievalue = ovidentia_themedefaut_getcookie('ovidentia_themedefaut_fullbody');
	var body = document.getElementsByTagName('BODY')[0];

	if (cookievalue == undefined || cookievalue == 1) {
		ovidentia_themedefaut_setcookie('ovidentia_themedefaut_fullbody', 0);
		bab_elementRemoveClass(body, 'ovidentia_themedefaut_fullbody');
	} else {
		ovidentia_themedefaut_setcookie('ovidentia_themedefaut_fullbody', 1);
		bab_elementAddClass(body, 'ovidentia_themedefaut_fullbody');
	}
}




/**
 * Show the link for managing full body.
 */
function ovidentia_themedefaut_showfullbodylink()
{
	document.getElementById('ovidentia_toolbar_fullbodylink').style.display = 'block';
}

bab_initFunctions.push(function() { ovidentia_themedefaut_showfullbodylink(); });
