<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2011 by CANTICO ({@link http://www.cantico.fr})
 */

class Widget_SitemapItemPickerContent {

	protected	$sitemap;


	private function getHtml(bab_Node $node, $depth = 1) {

		$return = '';
		$classnames = array();

		$id = $node->getId();
		$siteMapItem = $node->getData();
		/* @var $siteMapItem bab_siteMapItem */

		$htmlData = '<a href="#" title="'.bab_toHtml($siteMapItem->id_function).'">'.bab_toHtml($siteMapItem->name).'</a>';

		$return .= '<li>'.$htmlData;

		if ($node->hasChildNodes()) {
			$return .= "<ul>\n";

			$node = $node->firstChild();
			do {
				//if (!$node->getData()->menuIgnore)
				//{
					$return .= $this->getHtml($node, $depth + 1);
				//}
			} while ($node = $node->nextSibling());

			$return .= "</ul>\n";
		}

		$return .= "</li>\n";

		return $return;
	}





	/**
	 *
	 * @return string
	 */
	public function toString()
	{
		$args = $_GET;

		if (isset($args['sitemap'])) {
			$sitemap = bab_siteMap::getByUid($args['sitemap']);
			$sitemap_name = $args['sitemap'];
		} else {
			global $babBody;
			$sitemap = bab_siteMap::getByUid($babBody->babsite['sitemap']);
			$sitemap_name = $babBody->babsite['sitemap'];
			if (!isset($sitemap)) {
				$sitemap_name = 'core';
				$sitemap = bab_siteMap::get();
			}
		}

		if (!isset($sitemap)) {
			return 'wrong sitemap';
		}

		$this->sitemap = $sitemap;

		$dg_node = $sitemap->firstChild();

		if (!($dg_node instanceOf bab_Node)) {
			return '';
		}

		if (empty($args['basenode']))
		{
			$args['basenode'] = bab_siteMap::getVisibleRootNodeByUid($sitemap_name);
		}

		if (isset($args['basenode']) && (!empty($args['basenode']))) {
			$home = $sitemap->getNodeById($args['basenode']);
			$baseNodeId = $args['basenode'];
		} else {
			$home = $dg_node->firstChild();
			$baseNodeId = null;
		}

		if (!($home instanceOf bab_Node)) {
			return '';
		}

	
		$node = $home->firstChild();
		$return = '';



		if ($node) {

			
			$return .= '<ul>'."\n";
			
			do {
				$return .= $this->getHtml($node);
			} while ($node = $node->nextSibling());

			$return .= '</ul>'."\n";
		}
		return $return;
	}
}



echo bab_getInstance('Widget_SitemapItemPickerContent')->toString();
exit;