<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2006 by CANTICO ({@link http://www.cantico.fr})
 */
//include_once 'base.php';

//require_once $GLOBALS['babInstallPath'] . 'utilit/devtools.php';
require_once $GLOBALS['babInstallPath'] . '/addons/widgets/widgets/inputwidget.class.php';




/**
 * Constructs a Widget_CheckBox.
 *
 * @param string $id			The item unique id.
 * @return Widget_CheckBox
 */
function Widget_CheckBox($id = null)
{
	return new Widget_CheckBox($id);
}


/**
 * A Widget_Checkbox is a widget that let the user enter a boolean value (on/off).
 *
 */
class Widget_CheckBox extends Widget_InputWidget implements Widget_Displayable_Interface
{

	private $checked_value = '1';
	private $unchecked_value = '0';


	/**
	 * @param string $id			The item unique id.
	 * @return Widget_CheckBox
	 */
	public function __construct($id = null)
	{
		parent::__construct($id);
	}


	public function getClasses()
	{
		$classes = parent::getClasses();
		$classes[] = 'widget-checkbox';
		return $classes;
	}

	/**
	 * @param	string	$str
	 * @return Widget_CheckBox
	 */
	public function setCheckedValue($str) {
		assert('is_string($str); /* The "str" parameter must be a string. */');
		$this->checked_value = $str;
		return $this;
	}

	/**
	 * @param	string	$str
	 * @return Widget_CheckBox
	 */
	public function setUncheckedValue($str) {
		assert('is_string($str); /* The "str" parameter must be a string. */');
		$this->unchecked_value = $str;
		return $this;
	}


	public function setValue($value)
	{
		assert('is_bool($value) || $value === $this->checked_value || $value === $this->unchecked_value; /* The "value" parameter must be a boolean or one of the values defined by setCheckedValue and setUncheckedValue. */');
		if (is_bool($value)) {
			$value = ($value ? $this->checked_value : $this->unchecked_value);
		}
		return parent::setValue($value);
	}


	public function display(Widget_Canvas $canvas)
	{
		if ($this->isDisplayMode()) {
			$this->disable();
		}


		return $canvas->checkBoxInput(
			$this->getId(),
			$this->getClasses(),
			$this->getFullName(),
			$this->getValue(),
			$this->checked_value,
			$this->unchecked_value,
			$this->isDisabled(),
			$this->getTitle()
		)
		. $canvas->metadata($this->getId(), $this->getMetadata());
	}
}
