<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2006 by CANTICO ({@link http://www.cantico.fr})
 */
include_once 'base.php';
require_once $GLOBALS['babInstallPath'] . '/addons/widgets/widgets/lineedit.class.php';


/**
 * Constructs a Widget_ColorPicker.
 *
 * @param string		$id			The item unique id.
 * @return Widget_ColorPicker
 */
function Widget_ColorPicker($id = null)
{
	return new Widget_ColorPicker($id);
}


/**
 * A Widget_ColorPicker is a widget that let the user enter a color hexadecimal code. 
 * or pick a color throw a dialog
 */
class Widget_ColorPicker extends Widget_LineEdit implements Widget_Displayable_Interface 
{
	
	/**
	 * @param string $id			The item unique id.
	 * @return Widget_DatePicker
	 */
	public function __construct($id = null)
	{
		parent::__construct($id);
		
		$this->setSize(8);
		$this->setMaxSize(6);
		
		$this->setTitle(widget_translate('Select a color'));
		
		// default color space
		
		$this->setColorSpace('HSL');
		
		$this->slider();
		$this->setSliderValue(0.5);
	}
	
	
	/**
	 * Enable or diasable the slider visibility
	 * @return Widget_ColorPicker
	 */
	public function slider($active = true)
	{
		$this->setMetaData('slider', $active);
		return $this;
	}
	
	
	/**
	 * fill the color picker value automatically with an autogenerated color from the string typed in the associated line edit widget
	 * @param	Widget_LineEdit		$widget
	 * @return Widget_ColorPicker
	 */
	public function setAssociatedLineEdit(Widget_LineEdit $widget)
	{
		$this->setMetaData('AssociatedLineEdit', $widget->getId());
		return $this;
	}
	
	/**
	 * Set color space name to use in color picker popup
	 * @param string $name	RGB | HSL | YUV
	 * @return Widget_ColorPicker
	 */
	public function setColorSpace($name)
	{
		$this->setMetaData('colorspace', $name);
		$this->setRules($name{0}, $name{1}, $name{2});
		return $this;
	}
	
	/**
	 * Set rules for color space traversal
	 * @param string $X			R | G | B | H | S | L | Y | U | V		set the X axis color component
	 * @param string $Y			R | G | B | H | S | L | Y | U | V		set the Y axis color component
	 * @param string $slider	R | G | B | H | S | L | Y | U | V		set the slider color component
	 * @return Widget_ColorPicker
	 */
	public function setRules($X, $Y, $slider)
	{
		$colorspace = $this->getMetaData('colorspace');
		
		$xpos = strpos($colorspace, $X);
		$ypos = strpos($colorspace, $Y);
		$sliderpos = strpos($colorspace, $slider);
		
		if (false === $xpos || false === $ypos || false === $sliderpos)
		{
			throw new Exception(sprintf('Error, only letters of colorspace %s can be used', $colorspace));
		}
		
		if (3 !== ($xpos + $ypos + $sliderpos))
		{
			throw new Exception(sprintf('Error, every letters of colorspace %s must be used as parameters', $colorspace));
		}
		
		$this->setMetaData('rules', array($xpos, $ypos, $sliderpos));
		
		return $this;
	}
	
	
	/**
	 * Set slider default value
	 * @param	float	$value
	 * @return Widget_Item
	 */
	public function setSliderValue($value)
	{
		$this->setMetaData('sliderValue', $value);
		return $this;
	}
	
	
	/**
	 * Sets the title of the item.
	 * title used in the popup of the color picker and as a tooltip in the input widget
	 *
	 * @param string $title
	 * @return Widget_Item
	 */
	public function setTitle($title)
	{
		parent::setTitle($title);
		$this->setMetaData('title', $title);
		return $this;
	}
	

	public function getClasses()
	{
		$classes = parent::getClasses();
		if (!$this->isDisplayMode()) {
			$classes[] = 'widget-colorpicker';
		}
		
		return $classes;
	}

	
	
	public function display(Widget_Canvas $canvas)
	{

		if ($this->isDisplayMode()) {
			return $canvas->div(
				$this->getId(), 
				$this->getClasses(), 
				array(bab_nbsp()), 
				$this->Options()->backgroundColor('#'.$this->getValue())->width($this->getSize(),'ex')
			);
		}
		
		return parent::display($canvas);
	}
}
