<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2006 by CANTICO ({@link http://www.cantico.fr})
 */
//include_once 'base.php';

//require_once $GLOBALS['babInstallPath'] . 'utilit/devtools.php';
require_once $GLOBALS['babInstallPath'] . '/addons/widgets/widgets/widget.class.php';




/**
 * A Widget_ContainerWidget is a widget that can be the parent of other items.
 * It is associated with a Widget_Layout to manage the way children items are
 * displayed.
 * 
 * @abstract
 */
class Widget_ContainerWidget extends Widget_Widget /* implements Widget_Displayable_Interface */ 
{
	private $_layout;



	/**
	 * @param Widget_Layout $layout	The layout that will manage how widgets are displayed in this container.
	 * @param string $id			The item unique id.
	 * @return Widget_ContainerWidget
	 */
	public function __construct($id = null, $layout = null)
	{
//		echo __METHOD__ . "\n";
//		assert('$layout instanceof Widget_Layout; /* The layout parameter must be a Widget_Layout object */');
		parent::__construct($id);
		$this->setLayout($layout);
//		$this->_layout = $layout;
//		$this->layout = $this->_layout;
	}


	/**
	 * Sets the layout manager for this container to $layout.
	 *
	 * @param Widget_Layout|null $layout
	 * @return Widget_ContainerWidget
	 */
	public function setLayout($layout)
	{
//		echo __METHOD__. "\n";
//		assert('$layout instanceof Widget_Layout; /* The layout parameter must be a Widget_Layout object */');
		$this->_layout = $layout;
//		$this->layout = $this->_layout;
//		echo $this->getId() . ' ';

//		echo gettype($this);
		if (null !== $layout) {
			$layout->setParent($this);
		}
//		echo (gettype($layout->getParent()));

		return $this;
	}

	/**
	 * Returns the layout manager for this container.
	 *
	 * @return Widget_Layout
	 */
	public function getLayout()
	{
		return $this->_layout;
	}


	/**
	 * Adds the item the container's layout.
	 * 
	 * @param Widget_Item	$item
	 * @return Widget_ContainerWidget
	 */
	public function addItem(Widget_Displayable_Interface $item = null /* additional parameters depending on the associated layout */)
	{
		assert('$this->_layout instanceof Widget_Layout; /* There must be a layout associated to this container. */');
		// When we add an item in a container, we actually add the item to its associated layout.
		// As parameters depend on the layout class we call the method addItem with all the parameters.
		$args = func_get_args();
		call_user_func_array(array($this->_layout, 'addItem'), $args);
		return $this;
	}


	/**
	 * For debugging purpose.
	 *
	 * @param string $prefix
	 * @return string
	 * @ignore
	 */
	public function dump($prefix = '')
	{
		$dumpString = parent::dump($prefix); //$prefix . '|' . "\n" . $prefix . '|___' . get_class($this) . '(' . $this->getId() . ') ';
		$dumpString .= $this->getLayout()->dump($prefix, false);
		return $dumpString;
	}


	
/*
	function toHtml()
	{
		$html = '<div id="' . $this->getHtmlId() . '">';
		$layout = $this->getLayout();
		$html .= $layout->toHtml();
		$html .= '</div>';
		
		return $html;
	}
*/

}

