<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2006 by CANTICO ({@link http://www.cantico.fr})
 */
include_once 'base.php';
require_once $GLOBALS['babInstallPath'] . '/addons/widgets/widgets/inputwidget.class.php';
require_once $GLOBALS['babInstallPath'] . '/addons/widgets/widgets/image.class.php';


/**
 * Constructs a Widget_ColorPicker.
 *
 * @param string		$id			The item unique id.
 * @return Widget_ColorPicker
 */
function Widget_ImageCropper($id = null)
{
	return new Widget_ImageCropper($id);
}


/**
 * A Widget_ColorPicker is a widget that let the user enter a color hexadecimal code. 
 * or pick a color throw a dialog
 */
class Widget_ImageCropper extends Widget_ContainerWidget implements Widget_Displayable_Interface 
{
	
	private	$maxW = 0;
	private	$minW = 0;
	private	$maxH = 0;
	private	$minH = 0;
	private	$ratio = 0;
	private	$color = 'black';
	private	$opacity = .3;
	private	$x1 = null;
	private	$x2 = null;
	private	$y1 = null;
	private	$y2 = null;
	private	$inputLayout = null;
	private	$imageWidget = null;
	
	/**
	 * @param string $id			The item unique id.
	 * @return Widget_ImageCropper
	 */
	public function __construct($id = null)
	{
		require_once FUNC_WIDGETS_PHP_PATH . 'flowlayout.class.php';
		require_once FUNC_WIDGETS_PHP_PATH . 'lineedit.class.php';
		require_once FUNC_WIDGETS_PHP_PATH . 'image.class.php';
		require_once FUNC_WIDGETS_PHP_PATH . 'namedcontainer.class.php';
		$layout = new Widget_VBoxLayout($id);
		$this->inputLayout = new Widget_NamedContainer();
		
		parent::__construct($id, $layout);
		
		$W = bab_functionality::get('Widgets');
		
		$this->x1 	= new Widget_LineEdit($this->getId().'_x1');
		$this->y1 	= new Widget_LineEdit($this->getId().'_y1');
		$this->x2 	= new Widget_LineEdit($this->getId().'_x2');
		$this->y2 	= new Widget_LineEdit($this->getId().'_y2');
		
		$this->x1->setName('x1')->setMetadata('x1', $this->x1->getId())->setSize(5);
		$this->y1->setName('y1')->setMetadata('y1', $this->y1->getId())->setSize(5);
		$this->x2->setName('x2')->setMetadata('x2', $this->x2->getId())->setSize(5);
		$this->y2->setName('y2')->setMetadata('y2', $this->y2->getId())->setSize(5);
		
		$this->imageWidget = new Widget_Image('', '', $this->getId().'_image');
		
		$layout->addItem(
			$this->imageWidget->addClass('widget-imagecropper')
		)->addItem(
			$this->inputLayout->addItem(
				$W->FlowLayout()->setHorizontalSpacing(20)->addItem(
					$W->FlowLayout()
						->addItem($this->x1Label = $W->Label(widget_translate('x1'). chr(160)))
						->addItem($this->x1->setAssociatedLabel($this->x1Label)
					)->setVerticalAlign('middle')
				)->addItem(
					$W->FlowLayout()
						->addItem($this->y1Label = $W->Label(widget_translate('y1'). chr(160)))
						->addItem($this->y1->setAssociatedLabel($this->y1Label)
					)->setVerticalAlign('middle')
				)->addItem(
					$W->FlowLayout()
						->addItem($this->x2Label = $W->Label(widget_translate('x2'). chr(160)))
						->addItem($this->x2->setAssociatedLabel($this->x2Label)
					)->setVerticalAlign('middle')
				)->addItem(
					$W->FlowLayout()
						->addItem($this->y2Label = $W->Label(widget_translate('y2'). chr(160)))
						->addItem($this->y2->setAssociatedLabel($this->y2Label)
					)->setVerticalAlign('middle')
				)
			)
		)->setVerticalSpacing(5, 'px');
	}
	
	/**
	* Sets the name of input.
	*
	* @param string	$name
	* @return Widget_ImageCropper
	*/
	public function setName($name)
	{
		$this->inputLayout->setName($name);
		
		return $this;
	}
	
	/**
	 * Sets the image url.
	 *
	 * @param string	$url
	 * @return Widget_ImageCropper
	 */
	public function setUrl($url)
	{
		$this->imageWidget->setUrl($url);
		return $this;
	}
	
	/**
	 * Sets the max image cropping size.
	 *
	 * @param int	$w
	 * @param int	$h
	 * @return Widget_ImageCropper
	 */
	public function setMaxSize($w, $h)
	{
		$this->maxW = $w;
		$this->maxH = $h;
		return $this;
	}
	
	/**
	 * Sets the min image cropping size.
	 *
	 * @param int	$w
	 * @param int	$h
	 * @return Widget_ImageCropper
	 */
	public function setMinSize($w, $h)
	{
		$this->minW = $w;
		$this->minH = $h;
		return $this;
	}
	
	/**
	 * Sets the image cropping ratio.
	 *
	 * @param float	$ratio
	 * @return Widget_ImageCropper
	 */
	public function setRatio($ratio)
	{
		$this->ratio = $ratio;
		return $this;
	}
	
	/**
	* Sets the image cropping selection.
	*
	* @param int	$x1
	* @param int	$x2
	* @param int	$y1
	* @param int	$y2
	* @return Widget_ImageCropper
	*/
	public function setValue( $x1, $x2, $y1, $y2)
	{
		$this->x1->setValue($x1);
		$this->x2->setValue($x2);
		$this->y1->setValue($y1);
		$this->y2->setValue($y2);
		
		return $this;
	}
	
	public function display(Widget_Canvas $canvas)
	{
		$this->imageWidget->setMetadata('minSizeW', $this->minW);
		$this->imageWidget->setMetadata('minSizeH', $this->minH);
		$this->imageWidget->setMetadata('maxSizeW', $this->maxW);
		$this->imageWidget->setMetadata('maxSizeH', $this->maxH);
		$this->imageWidget->setMetadata('aspectRatio', $this->ratio);
		$this->imageWidget->setMetadata('bgColor', $this->color);
		$this->imageWidget->setMetadata('bgOpacity', $this->opacity);
		$this->imageWidget->setMetadata('setSelect', array($this->x1->getValue(), $this->x2->getValue(), $this->y1->getValue(), $this->y2->getValue()) );
		
		return $canvas->div(
			$this->getId(),
			$this->getClasses(),
			array($this->getLayout()->display($canvas))
		);
	}

}
