<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2006 by CANTICO ({@link http://www.cantico.fr})
 */
include_once 'base.php';

//require_once $GLOBALS['babInstallPath'] . 'utilit/devtools.php';
require_once $GLOBALS['babInstallPath'] . '/addons/widgets/widgets/widget.class.php';



/**
 * Constructs a Widget_Link.
 *
 * @param 	string	[$text]	The link text.
 * @param	string	[$url]	The link url
 * @param 	string	[$id]	The item unique id.
 * @return Widget_Link
 */
function Widget_Link($text = '', $url = '', $id = null)
{
	return new Widget_Link($text, $url, $id);
}



/**
 * A Widget_Link.
 *
 */
class Widget_Link extends Widget_Widget implements Widget_Displayable_Interface
{
	private $_url = null;
	private $_ajaxUrl = null;
	private $_item = null;



	const OPEN_PAGE		= 1;
	const OPEN_POPUP	= 2;


	/**
	 * @param mixed $item		The link text or widget item.
	 * @param Widget_Action 	$action	The link action (or url).
	 * @param string $id		The item unique id.
	 */
	public function __construct($item = '', $action = '', $id = null)
	{
		parent::__construct($id);
		$this->_item = $item;
		if ($action instanceof Widget_Action) {
			$this->setAction($action);
		} else {
			$this->setUrl($action);
		}

		$this->setOpenMode(self::OPEN_PAGE);
	}


	/**
	 * Sets the link text.
	 *
	 * @param string $text
	 * @return Widget_Link
	 */
	public function setText($text)
	{
		$this->_item = $text;
		return $this;
	}


	/**
	 * Sets the link contained item.
	 *
	 * @param Widget_Item $item
	 * @return Widget_Link
	 */
	public function setItem(Widget_Item $item)
	{
		$this->_item = $item;
		return $this;
	}


	/**
	 * Get the item or the text contained in the link.
	 *
	 * @return Widget_Item || string
	 */
	public function getItem()
	{
		return $this->_item;
	}


	/**
	 * Sets the link Url.
	 *
	 * @param string $url
	 * @return Widget_Link
	 */
	public function setUrl($url)
	{
		$this->_url = $url;
		return $this;
	}


	/**
	 * Sets the link Url (using an action object).
	 *
	 * @param Widget_Action $action
	 * @return Widget_Link
	 */
	public function setAction(Widget_Action $action)
	{
		$this->_url = $action->url();
		return $this;
	}


	/**
	 * Specifies an action that will be called asynchronously on the server (ajax). If the action
	 * succeeds, the closest delayedItem of the page containing $reloadItem will be refreshed
	 * (or the whole page if there is none).
	 *
	 * @param Widget_Action $action     The action to call in ajax.
	 * @param Widget_Item   $reloadItem	 A Widget_Item, id of a Widget_Item, or array of Widget_Items
	 * @return Widget_Link
	 */
	public function setAjaxAction(Widget_Action $action, $reloadItem = null)
	{
		$this->_ajaxUrl = $action->url();
		$this->setMetadata('ajaxAction', $action->url());
		if(isset($reloadItem)){
			if(!is_array($reloadItem)){
				$reloadItem = array($reloadItem);
			}

			foreach($reloadItem as $k => $v){
				if($v instanceof Widget_Item){
					$reloadItem[$k] = $v->getId();
				}
			}
			$this->setMetadata('ajaxActionReload', $reloadItem);
		}
		return $this;
	}


	/**
	 * Set open mode, choose the opening method of the link
	 * @param	int	$mode
	 * @return Widget_Link
	 */
	public function setOpenMode($mode) {
		switch($mode) {
			case self::OPEN_POPUP:
				$this->addClass('widget-popup');
			break;
		}

		return $this;
	}


	/**
	 * set a confirmation message displayed in a modal dialog before the page change
	 * @param	string	$message
	 * @return 	Widget_Link
	 */
	public function setConfirmationMessage($message)
	{
		$this->setMetadata('confirmationMessage', $message);
		$this->addClass('widget-confirm');

		return $this;
	}



	/**
	 * @return array
	 */
	public function getClasses()
	{
		$classes = parent::getClasses();
		$classes[] = 'widget-link';
		if (isset($this->_ajaxUrl)) {
			$classes[] = 'widget-ajax';
		}
		return $classes;
	}


	/**
	 * (non-PHPdoc)
	 * @see programs/widgets/Widget_Displayable_Interface#display($canvas)
	 */
	public function display(Widget_Canvas $canvas)
	{
		if (is_string($this->_item)) {
			$item = $canvas->text($this->_item);
		} else {
			$item = $this->_item;
		}

		return $canvas->linkContainer(
			$this->getId(),
			$this->getClasses(),
			array($item),
			$this->_url,
			$this->getCanvasOptions(),
			$this->getTitle(),
			$this->getAttributes()
		) . $canvas->metadata($this->getId(), $this->getMetadata());
	}
}
