<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2008 by CANTICO ({@link http://www.cantico.fr})
 */
include_once 'base.php';

require_once dirname(__FILE__) . '/boxlayout.class.php';



/**
 * Create a Multicolumns widget
 * @param	string	$id
 * @return Widget_MulticolumnLayout
 */
function Widget_MulticolumnLayout($id = null)
{
	return new Widget_MulticolumnLayout($id);
}


class Widget_MulticolumnLayout extends Widget_BoxLayout implements Widget_Displayable_Interface {

	private $nbcolumn = 2;


	/**
	 * @param string	$id			The item unique id.
	 */
	public function __construct($id = null)
	{
		parent::__construct($id);
	}


	/**
	 * Define the number of columns
	 * @param	int	$nb
	 * @return 	Widget_MulticolumnLayout
	 */
	public function setNbColumns($nb)
	{
		if ($nb > 0) {
			$this->nbcolumn = $nb;
		}
		return $this;
	}
	
	
	public function getClasses()
	{
		$classes = parent::getClasses();
		$classes[] = 'widget-layout-hbox';
		$classes[] = 'widget-layout-multicolumn';
		return $classes;
	}

	
	public function display(Widget_Canvas $canvas)
	{
		
		$items = array_values($this->getItems());
		$nb_items = count($items);
		$hboxitems = array();
		$floor = floor($nb_items/$this->nbcolumn);
		$ceil = ceil($nb_items/$this->nbcolumn);
		$current_items_per_column = $ceil;
		
		
		$hboxOptions = $this->getCanvasOptions();
		/*@var $hboxOptions Widget_CanvasOptions */
		
		if ($vspacing = $hboxOptions->verticalSpacing()) {
			// report vertical spacing to vbox
			$vboxOptions = new Widget_CanvasOptions;
			$vboxOptions->verticalSpacing($vspacing, $hboxOptions->verticalSpacingUnit());
		} else {
			$vboxOptions = null;
		}
		

		
		for ($i = 0; $i < $this->nbcolumn; $i++) {
			
			$nb_ceil_column = $i;
			$nb_floor_column = $this->nbcolumn - $i;
			
			if ($nb_items <= ($nb_floor_column * $floor) + ($nb_ceil_column * $ceil)) {
				$current_items_per_column = $floor;
			}
			
			$column_items = array_slice($items, 0, $current_items_per_column);
			$items = array_slice($items, $current_items_per_column);

			$hboxitems[] = $canvas->vbox($this->getId().'-'.$i, array('widget-layout-column'), $column_items, $vboxOptions);
		}
		
		
		
		return $canvas->hbox($this->getId(), $this->getClasses(), $hboxitems, $hboxOptions);
	}
}