<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2006 by CANTICO ({@link http://www.cantico.fr})
 */
//include_once 'base.php';

//require_once $GLOBALS['babInstallPath'] . 'utilit/devtools.php';
require_once $GLOBALS['babInstallPath'] . '/addons/widgets/widgets/uploader.class.php';



/**
 * Constructs a Widget_MultiUploader.
 *
 * @param string		$id			The item unique id.
 * @return Widget_MultiUploader
 */
function Widget_MultiUploader($id = null)
{
	return new Widget_MultiUploader($id);
}


/**
 * A Widget_Uploader is a widget that let the user select files for uploading to the server. 
 */
class Widget_MultiUploader extends Widget_Uploader implements Widget_Displayable_Interface 
{
	private $acceptedMimeTypes = array();
	
	
	/**
	 * @var Widget_Item
	 */
	private $imagePreview = null;
	
	/**
	 * @param string $id			The item unique id.
	 * @return Widget_Uploader
	 */
	public function __construct($id = null)
	{
		parent::__construct($id);
	}


	/**
	 * Sets the array of accepted mime types.
	 *
	 * @param array|string $mimeTypes
	 * @return Widget_Uploader
	 */
	public function setAcceptedMimeTypes($mimeTypes)
	{
		if (is_string($mimeTypes)) {
			$this->acceptedMimeTypes = explode(',', $mimeTypes);
		} else {
			$this->acceptedMimeTypes = $mimeTypes;
		}
		return $this;
	}
	
	/**
	 * Returns the array of accepted mime types.
	 *
	 * @return array
	 */
	public function getAcceptedMimeTypes()
	{
		return $this->acceptedMimeTypes;
	}


	
	/**
	 * Sets a widget (having a setImageUrl method) that will display an preview of the file to upload.
	 * 
	 * @param $image
	 * @return Widget_Uploader
	 */
	function setPreviewImageItem($image)
	{
		$this->imagePreview = $image;
		return $this;
	}



	public function getClasses()
	{
		$classes = parent::getClasses();
		$classes[] = 'widget-multiuploader';
		return $classes;
	}


	/**
	 * (non-PHPdoc)
	 * @see programs/widgets/Widget_Displayable_Interface#display()
	 */
	public function display(Widget_Canvas $canvas)
	{
		$addonInfo = bab_getAddonInfosInstance('widgets');
		$templatePath = $addonInfo->getTemplatePath();


		$this->setMetadata('templatePath', $templatePath );
		if ($this->isDisplayMode()) {
			return '';
		}

//		var_dump($this->getMetadata())
//		echo $canvas->metadata("spanButtonPlaceholder", $this->getMetadata());
//		die;
		$span = $canvas->span($this->getId(), $this->getClasses(), array());
		return $span .
				'<input id="btnUpload" type="button" value="Select Files" style="width: 61px; height: 22px; font-size: 8pt;" />
				<input id="btnCancel" type="button" value="Cancel All Uploads" disabled="disabled" style="margin-left: 2px; height: 22px; font-size: 8pt;" />
		'.$canvas->metadata($this->getId(), $this->getMetadata());
		
		
		return $canvas->fileUpload(
					$this->getId(),
					$this->getClasses(),
					$this->getFullName(),
					$this->getAcceptedMimeTypes()
				)
				.$canvas->metadata($this->getId(), $this->getMetadata());
	}
}

