<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2006 by CANTICO ({@link http://www.cantico.fr})
 */
//include_once 'base.php';

//require_once $GLOBALS['babInstallPath'] . 'utilit/devtools.php';
require_once $GLOBALS['babInstallPath'] . '/addons/widgets/widgets/containerwidget.class.php';



/**
 * Constructs a Widget_PageSelector.
 *
 * @param string	$id		The item unique id.
 * @return Widget_PageSelector
 */
function Widget_PageSelector($id = null)
{
	return new Widget_PageSelector($id);
}



/**
 * Widget_PageSelector
 *
 */
class Widget_PageSelector extends Widget_Widget implements Widget_Displayable_Interface
{
	/**
	 * @var CountableIterator | Array
	 */
	private $iterator;

	/**
	 * @var int
	 */
	private $pageLength = 20;

	/**
	 * First page is 0.
	 * @var int
	 */
	private $currentPage = 0;

	/**
	 * @var int
	 */
	private $maxLinks = 15;


	private $pageNamePath = null;

	private $sortField = null;

	/**
	 *
	 * @var string
	 */
	private $anchorname = null;


	/**
	 * @param string $id	The item unique id.
	 * @return Widget_Label
	 */
	public function __construct($id = null)
	{
		parent::__construct($id);

	}

	/**
	 *
	 * @param CountableIterator | Array	 $iterator
	 * @return Widget_PageSelector
	 */
	public function setIterator($iterator)
	{
		$this->iterator = $iterator;
		return $this;
	}



	/**
	 * Sets the maximum number of rows that shall be displayed at once.
	 *
	 * @param int $pageLength		or null to unset the limit.
	 * @return Widget_PageSelector
	 */
	public function setPageLength($pageLength = null)
	{
		$this->pageLength = $pageLength;
		return $this;
	}

	/**
	 * Returns the maximum number of rows that shall be displayed at once.
	 *
	 * @return int		The maximum number of rows displayed or null if no limit.
	 */
	public function getPageLength()
	{
		return $this->pageLength;
	}


	/**
	 * Sets the currently displayed page. DIsplayed data depends on pageLength.
	 *
	 * @param $pageNumber		First page is 0.
	 * @return Widget_PageSelector
	 */
	public function setCurrentPage($pageNumber)
	{
		$this->currentPage = $pageNumber;
		return $this;
	}


	/**
	 * Returns the currently displayed page.
	 *
	 * @return int		The currently displayed page. First page is 0.
	 */
	public function getCurrentPage()
	{
		return $this->currentPage;
	}




	/**
	 * Returns the number of pages necessary to display all the data.
	 *
	 * @return int	The number of pages necessary to display all the data or null if impossible to determine.
	 */
	public function getNbPages()
	{
		if (!isset($this->pageLength)) {
			return 1;
		}
		if ($this->iterator instanceof Countable && $this->pageLength > 0) {
			return ceil($this->iterator->count() / $this->pageLength);
		}

		if (is_array($this->iterator) && $this->pageLength > 0) {
			return ceil(count($this->iterator) / $this->pageLength);
		}

		return null;
	}


	/**
	 * Set page name path
	 * @param array $path
	 * @return Widget_PageSelector
	 */
	public function setPageNamePath(array $path)
	{
		$this->pageNamePath = $path;
		return $this;
	}

	/**
	 * Get page name path
	 * @return array
	 */
	public function getPageNamePath()
	{
		if (null === $this->pageNamePath)
		{
			return $this->getNamePath();
		}

		return $this->pageNamePath;
	}



	/**
	 * Defines the data source field that will be used to perform sorting.
	 *
	 * @param string $fieldPath
	 * @return Widget_PageSelector
	 */
	public function setSortField($fieldPath)
	{
		$this->sortField = $fieldPath;
		return $this;
	}


	/**
	 * Set an anchor for destination page
	 * @param string $anchorname
	 * @return Widget_PageSelector
	 */
	public function setAnchor($anchorname)
	{
		$this->anchorname = $anchorname;
		return $this;
	}


	/**
	 * Get the anchor name of destination page
	 * @return string | null
	 */
	public function getAnchor()
	{
		return $this->anchorname;
	}



	/**
	 * @param ORM_Record	$record
	 * @param string		$fieldPath
	 *
	 * @return mixed
	 */
	static protected function getRecordFieldValue(ORM_Record $record, $fieldPath)
	{
		$fieldPathElements = explode('/', $fieldPath);
		$value = $record;
		$field = $record->getParentSet();
		foreach ($fieldPathElements as $fieldName) {
			if (!$field->fieldExist($fieldName)) {
				return null;
			}
			$field = $field->$fieldName;
			$value = $value->$fieldName;
		}

		return $field->output($value);
	}





	public function getClasses()
	{
		$classes = parent::getClasses();
		$classes[] = 'widget-pageselector';
		return $classes;
	}









	/**
	 *
	 * @return Widget_Select
	 */
	protected function dropdownPageSelector(Widget_Canvas $canvas)
	{
		$iterator = null;
		$nbRows = null;

		if (isset($this->sortField)) {
			if ($this->iterator instanceof Iterator)
			{
				$iterator = $this->iterator;
			}
			$nbRows = $iterator->count();
		}

		$options = array();
		for ($i = 0; $i < $this->getNbPages(); $i++) {
			if (isset($iterator)) {
				$iterator->seek($i * $this->getPageLength());
				$record = $iterator->current();
			    $pageStartValue = mb_convert_case(mb_substr(self::getRecordFieldValue($record, $this->sortField), 0, 5), MB_CASE_UPPER);
				$iterator->seek(min($nbRows - 1, ($i + 1) * $this->getPageLength() - 1));
				$record = $iterator->current();
				$pageEndValue = mb_convert_case(mb_substr(self::getRecordFieldValue($record, $this->sortField), 0, 5), MB_CASE_UPPER);
				$options[$i] = sprintf(widget_translate('Page %d : %s to %s'), ($i + 1), $pageStartValue, $pageEndValue);
				
			} else {
				$options[$i] = 'Page ' . ($i + 1);
			}
		}
		$pageSelector = $canvas->select(null, array(), $this->getPageNamePath(), $this->getCurrentPage(), $options, array(), false);
		return $pageSelector;
	}
	
	

	/**
	 * @param	array	multidimentional array for query parameters
	 * @return unknown_type
	 */
	private function pageSelectorUrl($gp)
	{
		$current_url = parse_url($_SERVER['REQUEST_URI']);
		
		require_once $GLOBALS['babInstallPath'] . 'utilit/urlincl.php';
		$url =  $current_url['path']. '?' . bab_url::buildQuery($gp);

		if (isset($this->anchorname))
		{
			$url .= '#'.urlencode($this->anchorname);
		}

		return $url;
	}



	/**
	 * Pagination display
	 *
	 *
	 * @return string
	 */
	protected function linksPageSelector(Widget_Canvas $canvas)
	{
		$gp = $_GET + $_POST;
		
		$url = parse_url($_SERVER['REQUEST_URI']);
		$rewrited_file = basename($url['path']);
		$real_file = basename($_SERVER['PHP_SELF']);
		
		if ($rewrited_file !== $real_file)
		{
			$gp = array();
		}


		$namePath = $this->getPageNamePath();
		$fieldname = array_pop($namePath);

		$pageNumberGp =& $gp;
		foreach ($namePath as $name) {
			if (!isset($pageNumberGp[$name])) {
				$pageNumberGp[$name] = array();
			}
			$pageNumberGp =& $pageNumberGp[$name];
		}
		$pageNumberGp[$fieldname] = null;
		$pageNumberGp =& $pageNumberGp[$fieldname];

		$nbPages = $this->getNbPages();
		$currentPage = $this->getCurrentPage();

		if ($nbPages > $this->maxLinks) {
			$step = ($nbPages - 1) / $this->maxLinks;
		} else {
			$step = 1;
		}

		$pageNumbers = array();
		for ($i = 0; $i < $nbPages; $i += $step) {
			$pageNumber = round($i + 1);
			$pageNumbers[$pageNumber] = $pageNumber;
		}
		$pageNumbers[$currentPage + 1] =  $currentPage + 1;
		if ($currentPage < $nbPages - 1) {
			$pageNumbers[$currentPage + 2] = $currentPage + 2;
		}
		if ($currentPage > 0) {
			$pageNumbers[$currentPage] =  $currentPage;
		}
		sort($pageNumbers);

		if (isset($this->sortField)) {
			$iterator = $this->iterator;
			$nbRows = $iterator->count();
		} else {
			$iterator = null;
			$nbRows = null;
		}


		// Previous page link
		if ($this->getCurrentPage() > 0) {
			$value = '';
			if (isset($iterator)) {
				$iterator->seek(($currentPage - 1) * $this->getPageLength());
				$record = $iterator->current();
				if ($record instanceof ORM_Record) {
				    $pageStartValue = mb_convert_case(self::getRecordFieldValue($record, $this->sortField), MB_CASE_UPPER);
					$iterator->seek(min($nbRows - 1, $currentPage * $this->getPageLength() - 1));
					$record = $iterator->current();
					$pageEndValue = mb_convert_case(self::getRecordFieldValue($record, $this->sortField), MB_CASE_UPPER);
					$value = sprintf(widget_translate('Page %d : %s to %s'), $currentPage, $pageStartValue, $pageEndValue);
				}
			}

			$pageNumberGp = $currentPage - 1;
			$url = $this->pageSelectorUrl($gp);
			$links[] = $canvas->linkContainer(null, array('widget-page-previous'), array(bab_toHtml('<')), $url, null, $value);
		} else {
			$links[] = $canvas->span(null, array('widget-page-previous'), array(bab_toHtml('<')));
		}

		// Intermediate pages links
		foreach ($pageNumbers as $pageNumber) {
			$value = '';
			if (isset($iterator)) {

				$iterator->seek(($pageNumber - 1) * $this->getPageLength());
				$record = $iterator->current();
				if ($record instanceof ORM_Record) {
					$sortField = self::getRecordFieldValue($record, $this->sortField);
					if (($sortField instanceof ORM_Record) && isset($sortField->name)) {
						$sortField = $sortField->name;
					}
				    $pageStartValue = mb_convert_case($sortField, MB_CASE_UPPER);

					$iterator->seek(min($nbRows - 1, $pageNumber * $this->getPageLength() - 1));
					$record = $iterator->current();
					$sortField = self::getRecordFieldValue($record, $this->sortField);
					if (($sortField instanceof ORM_Record) && isset($sortField->name)) {
						$sortField = $sortField->name;
					}
					$pageEndValue = mb_convert_case($sortField, MB_CASE_UPPER);
					$value = sprintf(widget_translate('Page %d : %s to %s'), $pageNumber, $pageStartValue, $pageEndValue);
				}
			}

			$pageNumberGp = $pageNumber - 1;
			$url = $this->pageSelectorUrl($gp);
			if ($pageNumber == $currentPage + 1) {
				$links[] = $canvas->span(null, array('widget-page-number-current'), array($pageNumber . ''), null, $value);
			} else {
				$links[] = $canvas->linkContainer(null, array('widget-page-number'), array($pageNumber . ''), $url, null, $value);
			}
		}

		// Next page link
		if ($this->getCurrentPage() < $nbPages - 1) {
			$value = '';
			if (isset($iterator)) {
//				$iterator->seek(($currentPage + 1) * $this->getPageLength());
//				$record = $iterator->current();
//			    $value = self::getRecordFieldValue($record, $this->sortField);
				$iterator->seek(($currentPage + 1) * $this->getPageLength());
				$record = $iterator->current();
				if ($record instanceof ORM_Record) {
					$sortField = self::getRecordFieldValue($record, $this->sortField);
					if (($sortField instanceof ORM_Record) && isset($sortField->name)) {
						$sortField = $sortField->name;
					}
				    $pageStartValue = mb_convert_case($sortField, MB_CASE_UPPER);
					$iterator->seek(min($nbRows - 1, ($currentPage + 2) * $this->getPageLength() - 1));
					$record = $iterator->current();
					$sortField = self::getRecordFieldValue($record, $this->sortField);
					if (($sortField instanceof ORM_Record) && isset($sortField->name)) {
						$sortField = $sortField->name;
					}
					$pageEndValue = mb_convert_case($sortField, MB_CASE_UPPER);
					$value = sprintf(widget_translate('Page %d : %s to %s'), ($currentPage + 2), $pageStartValue, $pageEndValue);
				}
			}
			$pageNumberGp = $currentPage + 1;
			$url = $this->pageSelectorUrl($gp);
			$links[] = $canvas->linkContainer(null, array('widget-page-next'), array(bab_toHtml('>')), $url, null, $value);
		} else {
			$links[] = $canvas->span(null, array('widget-page-next'), array(bab_toHtml('>')));
		}

	//	$pageSelector = implode(' ', $links);
		return $canvas->div($this->getId(), $this->getClasses(), $links);
	}




	public function display(Widget_Canvas $canvas)
	{
		if ($this->getNbPages() > 1) {

//			return $canvas->hbox(null, array(), array($this->linksPageSelector($canvas), $this->dropdownPageSelector($canvas)))
//				. $canvas->metadata($this->getId(), $this->getMetadata());
			return $this->linksPageSelector($canvas)
				. $canvas->metadata($this->getId(), $this->getMetadata());
		}

		return '';
	}
}
