<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2006 by CANTICO ({@link http://www.cantico.fr})
 */
include_once 'base.php';



/**
 * Constructs a Widget_PeriodPicker.
 *
 * @param string		$id			The item unique id.
 * @return Widget_DatePicker
 */
function Widget_PeriodPicker($id = null)
{
	return new Widget_DatePicker($id);
}


/**
 * A Widget_PeriodPicker is a widget that let the user enter a period of time (2 dates). 
 */
class Widget_PeriodPicker extends Widget_ContainerWidget implements Widget_Displayable_Interface 
{
	
	private $from = null;
	private $to = null;
	private $fromLabel = null;
	private $toLabel = null;

	/**
	 * @param string $id			The item unique id.
	 * @return Widget_DatePicker
	 */
	public function __construct($id = null)
	{
		require_once FUNC_WIDGETS_PHP_PATH . 'flowlayout.class.php';
		require_once FUNC_WIDGETS_PHP_PATH . 'datepicker.class.php';
		$layout = new Widget_FlowLayout();
	
		parent::__construct($id, $layout);
		
		$this->from 	= new Widget_DatePicker($this->getId().'_from');
		$this->to 		= new Widget_DatePicker($this->getId().'_to');

		$this->from->setName('from')->setMetadata('to', $this->to->getId());
		$this->to->setName('to')->setMetadata('from', $this->from->getId());
		
		$this->setFormat('%d-%m-%Y');

		
		$W = bab_functionality::get('Widgets');
		
		
		$layout
		//	->setHorizontalSpacing(20)
			
			->addItem(
				$W->FlowLayout()
					->addItem($this->fromLabel = $W->Label(widget_translate('From')))
					->addItem($this->from->setAssociatedLabel($this->fromLabel)
				)->setVerticalAlign('middle')->setHorizontalSpacing(.3,'em')
			)
			
			->addItem(
				$W->FlowLayout()->addItem($this->toLabel = $W->Label(widget_translate('To')))
					->addItem($this->to->setAssociatedLabel($this->toLabel)
				)->setVerticalAlign('middle')->setHorizontalSpacing(.3,'em')
			);
	}


	/**
	 * Sets the format of the date.
	 * Only usage of %d, %m, %Y are allowed
	 *
	 * @param string $format	The format string as described in the php strftime function.
	 * @return Widget_PeriodPicker
	 */
	public function setFormat($format)
	{
		$this->from->setFormat($format);
		$this->to->setFormat($format);
		return $this;
	}
	
	
	/**
	 * Set the names on date fields for the start date and the end date of the period
	 * @return Widget_PeriodPicker
	 */
	public function setNames($from_name, $to_name) {
		$this->from->setName($from_name);
		$this->to->setName($to_name);
		return $this;
	}

	
	/**
	 * Set the labels text for date fields for the start date and the end date of the period
	 * @return Widget_PeriodPicker
	 */
	public function setLabels($from_label, $to_label) {
		$this->fromLabel->setText($from_label);
		$this->toLabel->setText($to_label);
		return $this;
	}
	
	/**
	 * Set the size for date fields for the start date and the end date of the period
	 * @param inter $size
	 * @return Widget_PeriodPicker
	 */
	public function setSize($size) {
		$this->from->setSize($size);
		$this->to->setSize($size);
		return $this;
	}
	
	/**
	 * Set the labels text for date fields for the start date and the end date of the period
	 * @return Widget_PeriodPicker
	 */
	public function setValues($from_value, $to_value) {
		$this->from->setValue($from_value);
		$this->to->setValue($to_value);
		return $this;
	}
	

	public function getClasses()
	{
		$classes = parent::getClasses();
		$classes[] = 'widget-periodpicker';
		return $classes;
	}
	
	public function isMandatory()
	{
		if ( $this->from->isMandatory() || $this->to->isMandatory() ){
			return true;
		}else{
			return false;
		}
	}
	
	/**
	 * Sets whether the field is mandatory or not.
	 * 
	 * If the field is inside a dialog, the dialog will report an error to
	 * the user if he did not fill in the field on submit.
	 * This method returns the widget itself so that other methods can be chained.
	 * 
	 * @param boolean $mandatory
	 * @param string $message		The message displayed by the dialog if the field is left empty.
	 * @return Widget_Widget
	 */
	public function setMandatory($mandatory = true, $message = '')
	{
		$this->from->setMandatory($mandatory, $message = '');
		$this->to->setMandatory($mandatory, $message = '');
		return $this;
	}

	public function display(Widget_Canvas $canvas)
	{	
		$this->fromLabel->colon(false);
		$this->toLabel->colon(false);
		return $canvas->div(
			$this->getId(), 
			$this->getClasses(), 
			array($this->getLayout()->display($canvas))
		);
	}

}
