<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2006 by CANTICO ({@link http://www.cantico.fr})
 */
//include_once 'base.php';

//require_once $GLOBALS['babInstallPath'] . 'utilit/devtools.php';
require_once $GLOBALS['babInstallPath'] . '/addons/widgets/widgets/lineedit.class.php';



/**
 * Constructs a Widget_RegExpLineEdit.
 *
 * @param string		$id			The item unique id.
 * @return Widget_RegExpLineEdit
 */
function Widget_RegExpLineEdit($id = null)
{
	return new Widget_RegExpLineEdit($id);
}


/**
 * A Widget_RegExpLineEdit is a widget that let the user enter a single line of text with a regular expression check.
 * 
 */
class Widget_RegExpLineEdit extends Widget_LineEdit implements Widget_Displayable_Interface 
{
	private $_regExp;

	const DATE_FORMAT = '0[1-9]|[12][0-9]|3[01])[- /.](0[1-9]|1[012])[- /.](19|20)\d\d';
	const FLOAT_FORMAT = '[-+]?[0-9]*\.?[0-9]+';
	const EMAIL_FORMAT = '^\b[A-Za-z0-9.-]*[A-Za-z0-9]@[A-Za-z0-9.-]+\.[A-Za-z]{2,7}\b$';

	/**
	 * @param string $id			The item unique id.
	 * @return Widget_RegExpLineEdit
	 */
	public function __construct($id = null)
	{
		parent::__construct($id);
		$this->regExp = '';
	}


	/**
	 * Sets the regular expression used to validate the line edit.
	 *
	 * @param string $size
	 */
	public function setRegExp($regExp)
	{
		$this->_regExp = $regExp;
		return $this;
	}

	/**
	 * Returns the regular expression used to validate the line edit.
	 *
	 * @return string
	 */
	public function getRegExp()
	{
		return $this->_regExp;
	}





	public function toHtml()
	{
		$html = parent::toHtml();
		$html .= '
			<script type="text/javascript">
			jQuery(function() {
				var item = jQuery("#' . htmlspecialchars($this->getHtmlId()) . '");
				item.attr("Widget_regExp", "' .  htmlspecialchars(preg_quote($this->getRegExp())) . '")
				item.keyup( function() {
					var regExp = new RegExp(jQuery(this).attr("Widget_regExp"));
					if (jQuery(this).val().match(regExp)) {
						jQuery(this).removeClass("Widget_Invalid")
					} else {
						jQuery(this).addClass("Widget_Invalid")
					}
				});
			});
			</script>
		';
		return $html;
	}

}

