<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2006 by CANTICO ({@link http://www.cantico.fr})
 */
include_once 'base.php';

//require_once $GLOBALS['babInstallPath'] . 'utilit/devtools.php';
require_once $GLOBALS['babInstallPath'] . '/addons/widgets/widgets/containerwidget.class.php';



/**
 * Constructs a Widget_Section.
 *
 * @param Widget_Layout	$layout		The layout that will manage how widgets are displayed in this container.
 * @param string		$id			The item unique id.
 * @return Widget_Section
 */
function Widget_Section($headerText, Widget_Layout $layout = null, $id = null)
{
	return new Widget_Section($headerText, $layout, $id);
}



/**
 * A Widget_Section is similar to a Widget_Frame with a header.
 *
 */
class Widget_Section extends Widget_ContainerWidget implements Widget_Displayable_Interface
{
	protected $header;

	/**
	 *
	 * @var Widget_Title
	 */
	protected $headerTitle;
	protected $subLayout;

	protected $foldable = false;
	protected $folded = false;

	protected $level;
	protected $contextMenu;

	/**
	 * @var bool
	 */
	private $_colon = null;

	/**
	 * @param string                                $headerText     The text displayed in the section header.
	 * @param Widget_Layout|Widget_ContainerWidget  $containerItem  The layout/container that will manage how widgets are displayed in this container.
	 * @param int                                   $level          The header text will displayed as a Widget_Title of this level
	 * @param string                                $id             The item unique id.
	 */
	public function __construct($headerText, $containerItem = null, $level = 4, $id = null)
	{
		if (null === $containerItem) {
			require_once FUNC_WIDGETS_PHP_PATH . 'layout.class.php';
			$this->subLayout = new Widget_Layout();
		} else {
			$this->subLayout = $containerItem;
		}
		$this->subLayout->addClass('widget-section-content');
		$W = bab_Functionality::get('Widgets', true);

		$this->headerTitle = $W->Title($headerText, $level)
			->addClass('handle');

		$this->headerSubTitle =	$W->Title('', $level + 1)
			->addClass('handle');

		$this->header = $W->HBoxItems(
			$W->Frame()->addClass('arrow handle'),
			$W->VBoxItems(
				$this->headerTitle,
				$this->headerSubTitle
			)->setSizePolicy(Widget_SizePolicy::MAXIMUM)
		)
		->setHorizontalSpacing(4, 'px')
		->setVerticalAlign('middle')
		->addClass('widget-section-header');

		$this->level = $level;
		parent::__construct($id, $W->VBoxItems($this->header, $this->subLayout));
	}




	/**
	 * display a colon after title text
	 * @return Widget_Section
	 */
	public function colon($colon = true)
	{
		$this->headerTitle->colon($colon);
		return $this;
	}



	/**
	 * @param Widget_Displayable_Interface $item
	 *
	 * @return Widget_Section
	 */
	public function addItem(Widget_Displayable_Interface $item /* additional parameters depending on the associated layout */)
	{
		// When we add an item in a container, we actually add the item to its associated layout.
		// As parameters depend on the layout class we call the method addItem with all the parameters.
		$args = func_get_args();
		call_user_func_array(array($this->subLayout, 'addItem'), $args);
		return $this;
	}



	/**
	 * Sets the layout manager for this container to $layout.
	 *
	 * @param Widget_Layout|null $layout
	 * @return Widget_Section
	 */
	public function setSubLayout($layout)
	{
		$this->subLayout = $layout;

		if (null !== $layout) {
			$layout->setParent($this->getLayout());
		}

		return $this;
	}


	
	/**
	 * Gets the layout manager for this container to $layout.
	 *
	 * @return Widget_Layout
	 */
	public function getSubLayout()
	{
		return $this->subLayout;
	}



	/**
	 * Sets the text that will be used as header for the section
	 *
	 * @param string $headerText
	 * @return Widget_Section
	 */
	public function setHeaderText($headerText, $level = null)
	{
		$this->headerTitle->setText($headerText);
		if (isset($level)) {
			$this->headerTitle->setLevel($level);
		}
		return $this;
	}



	/**
	 * Sets the text that will be used as sub header for the section
	 *
	 * @param string $subHeaderText
	 * @return Widget_Section
	 */
	public function setSubHeaderText($subHeaderText, $level = null)
	{
		$this->headerSubTitle->setText($subHeaderText);
		if (isset($level)) {
			$this->headerSubTitle->setLevel($level);
		}
		return $this;
	}



	/**
	 * Sets/unset the foldable property (content visibility is toggled when clicking header).
	 *
	 * @return Widget_Section
	 */
	public function setFoldable($foldable = true, $folded = null)
	{
		$this->foldable = $foldable;
		$this->folded = $folded;

		return $this;
	}




	public function addToolbar()
	{
		/* @var $W Func_Widgets */
		$W = bab_Functionality::get('Widgets');
		$toolbar = $W->FlowLayout()
			->addClass('widget-toolbar')
			->addClass(Func_Icons::ICON_LEFT_16);
		$this->header->addItem($toolbar);

		return $toolbar;
	}



	/**
	 * @return Widget_Menu
	 */
	public function addPopupMenu()
	{
		/* @var $W Func_Widgets */
		$W = bab_Functionality::get('Widgets');

		$menu = $W->Menu()
			->setLayout($W->VBoxLayout())
			->addClass(Func_Icons::ICON_LEFT_16);

		$this->header->addItem($menu);
		$menu->attachTo($this->headerTitle);

		return $menu;
	}



	/**
	 * @return Widget_DisplayableItem
	 */
	public function addContextMenu($type = 'inline')
	{
		/* @var $W Func_Widgets */
		$W = bab_Functionality::get('Widgets');

		if ($type === 'popup') {
			$this->contextMenu = $W->Menu()
				->setLayout($W->FlowLayout())
				->addClass(Func_Icons::ICON_LEFT_16);

			$this->header->addItem($this->contextMenu);
//			$this->contextMenu->attachTo($this->header);
		} else {
			$this->contextMenu = $W->FlowLayout()
				//->addClass('widget-toolbar')
				->addClass(Func_Icons::ICON_LEFT_16);
			$this->header->addItem($this->contextMenu);
		}

		return $this->contextMenu;
	}




	/**
	 * @return array
	 */
	public function getClasses()
	{
		$classes = parent::getClasses();
		$classes[] = 'widget-section';
		if ($this->foldable) {
			$classes[] = 'widget-foldable';
		}
		$cookieName = 'widgets_Section_' . $this->getId();
		if (!isset($this->folded) && isset($_COOKIE[$cookieName])) {
			if ($_COOKIE[$cookieName] == 1) {
				$classes[] = 'widget-folded';
			}
		} else if ($this->folded) {
			$classes[] = 'widget-folded';
		}
		$classes[] = 'widget-level-' . $this->level;

		return $classes;
	}



	/**
	 * (non-PHPdoc)
	 * @see Widget_Displayable_Interface::display()
	 */
	public function display(Widget_Canvas $canvas)
	{

		if ($this->foldable) {
			$this->header->addClass('widget-foldable');
		}
		$section = $canvas->div(
			$this->getId(),
			$this->getClasses(),
			array($this->getLayout()),
			$this->getCanvasOptions()
		);
		$section .= $canvas->metadata($this->getId(), $this->getMetadata());
		$section .= $canvas->loadScript($this->getId(), bab_getAddonInfosInstance('widgets')->getTemplatePath().'widgets.section.jquery.js');
		return $section;
	}

}

