<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2006 by CANTICO ({@link http://www.cantico.fr})
 */
//include_once 'base.php';

//require_once $GLOBALS['babInstallPath'] . 'utilit/devtools.php';
require_once $GLOBALS['babInstallPath'] . '/addons/widgets/widgets/inputwidget.class.php';




/**
 * A Widget_SimpleHtmlEdit is a widget that let the user enter multiple lines of text with some style formatting.
 *
 * @abstract
 */
class Widget_SimpleHtmlEdit extends Widget_InputWidget implements Widget_Displayable_Interface
{
	private $_nbColumns = 80;
	private $_nbLines = 5;


	/**
	 * @param string $id			The item unique id.
	 * @return Widget_SimpleHtmlEdit
	 */
	public function __construct($id = null)
	{
		parent::__construct($id);
	}


	/**
	 * Sets the visible width of the text edit.
	 *
	 * @param int $nbColumns	The number of visible columns.
	 */
	public function setColumns($nbColumns)
	{
		assert('is_int($nbColumns); /* The "nbColumns" parameter must be an integer */');
		$this->_nbColumns = $nbColumns;
		return $this;
	}

	/**
	 * Returns the visible width (in characters) of the text edit.
	 *
	 * @access public
	 */
	public function getColumns()
	{
		return $this->_nbColumns;
	}


	/**
	 * Sets the vertical input size (in characters) of the text edit.
	 *
	 * @param int $nbLines		The number of visible lines.
	 */
	public function setLines($nbLines)
	{
		assert('is_int($nbLines); /* The "nbLines" parameter must be an integer */');
		$this->_nbLines = $nbLines;
		return $this;
	}

	/**
	 * Returns the vertical input size (in characters) of the text edit.
	 *
	 * @return int
	 */
	public function getLines()
	{
		return $this->_nbLines;
	}


	public function getClasses()
	{
		$classes = parent::getClasses();
		$classes[] = 'widget-simplehtmledit';
		return $classes;

	}


	public function display(Widget_Canvas $canvas)
	{
		if ($this->isDisplayMode()) {

			$classes = $this->getClasses();
			$classes[] = 'widget-displaymode';

			return $canvas->richtext(
				$this->getId(),
				$classes,
				$this->getValue(),
				BAB_HTML_ALL,
				$this->getCanvasOptions()
			);

		}

		if ($this->getMetadata('css') === null) {
			$this->setMetadata('css', bab_getCssUrl());
		}

		return $canvas->textInput(
		    $this->getId(),
            $this->getClasses(),
            $this->getFullName(),
            $this->getValue(),
            $this->getColumns(),
            $this->getLines(),
            $this->isDisabled()
		)
		. $canvas->metadata($this->getId(), $this->getMetadata())
		. $canvas->loadScript($this->getId(), bab_getAddonInfosInstance('widgets')->getTemplatePath().'widgets.simplehtmledit.jquery.js')
		. $canvas->loadStyleSheet(bab_getAddonInfosInstance('widgets')->getStylePath().'widgets.simplehtmledit.css');

	}

}

