<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2006 by CANTICO ({@link http://www.cantico.fr})
 */
include_once 'base.php';

require_once $GLOBALS['babInstallPath'] . '/addons/widgets/widgets/containerwidget.class.php';
require_once $GLOBALS['babInstallPath'] . 'utilit/tree.php';


/**
 * Constructs a Widget_SimpleTreeView.
 *
 * @param Widget_Layout	$layout		The layout that will manage how widgets are displayed in this container.
 * @param string		$id			The item unique id.
 * @return Widget_SimpleTreeView
 */
function Widget_SimpleTreeView($id = null, Widget_Layout $layout = null)
{
	return new Widget_SimpleTreeView($id, $layout);
}



/**
 * Widget_SimpleTreeView wrapper to bab_TreeView
 *
 */
class Widget_SimpleTreeView extends bab_TreeView implements Widget_Displayable_Interface
{
	private $widget;


	/**
	 * @param string $id			The item unique id.
	 * @return Widget_SimpleTreeView
	 */
	public function __construct($id = null)
	{
	    $this->widget = new Widget_Widget($id);
		parent::__construct($this->getId() . '_tree');


		$this->setClasses('bab-orgchart-entitysearch bab-hide-non-matching-items bab-expand-matching-items-sub-tree');

		$this->_templateFile = 'addons/widgets/simpletreeview.html';
		$this->_templateSection = 'simple_treeview';
		$this->_templateCss = 'treeview_css';
		$this->_templateScripts = 'treeview_scripts';
		
		// default : do not save one node in cookie, use ->setPersistent(true) to activate, this must be used with a fixed ID for the widget
		$this->setPersistent(false);
	}


	public function setId($id)
	{
		$this->_id = $id;
		$this->t_treeViewId= $this->_id;
	    $this->widget->setId($id);
	    return $this;
	}

	public function __call($name, $arguments)
	{
		return call_user_func_array(array($this->widget, $name), $arguments);
	}

	public function setName($name) { $this->widget->setName($name); return $this; }
	public function setParent($parent) { $this->widget->setParent($parent); return $this; }
	public function enable() { $this->widget->enable(); return $this; }
	public function disable() {	$this->widget->disable(); return $this; }
	public function setDisplayMode() { $this->widget->setDisplayMode(); return $this; }
	public function setEditMode() { $this->widget->setEditMode(); return $this; }
	public function setClasses($classes) { $this->widget->setClasses($classes); return $this; }
	public function addClasses($classes) { $this->widget->addClasses($classes); return $this; }
	public function setCanvasOptions(Widget_CanvasOptions $canvasOptions) { $this->widget->setCanvasOptions($canvasOptions); return $this; }
	public function setSizePolicy($policy) { $this->widget->setSizePolicy($policy); return $this; }
	public function addClass($class) { $this->widget->addClass($class); return $this; }
	public function setTitle($title) { $this->widget->setTitle($title); return $this; }
	public function setMetadata($key, $value) { $this->widget->setMetadata($key, $value); return $this; }
	public function setConfirmationMessage($message) { $this->widget->setConfirmationMessage($message); return $this; }
	

	/**
	 * @param string $title			The title (label) of the node.
	 * @param string $id			A unique element id in the treeview default is Root.
	 * @return bab_SimpleTreeViewElement
	 */
	public function createRootNode($title, $id = 'Root')
	{
		$root = $this->createElement($id, 'directory', $title, '', '');
		$root->setIcon($GLOBALS['babSkinPath'] . 'images/nodetypes/category.png');
		$this->appendElement($root, NULL);

		return $root;
	}

	public function showToolbar()
	{
		parent::addAttributes(BAB_TREE_VIEW_SHOW_TOOLBAR);
		return $this;
	}


	public function hideToolbar()
	{
		parent::removeAttributes(BAB_TREE_VIEW_SHOW_TOOLBAR);
		return $this;
	}


	/**
	 * @param string $id			A unique element id in the treeview.
	 * @param string $type			Will be used as a css class to style the element.
	 * @param string $title			The title (label) of the node.
	 * @param string $description	An additional description that will appear as a tooltip.
	 * @param string $link			A link when clicking the node title.
	 *
	 * @return Widget_SimpleTreeViewElement
	 */
	public function createElement($id, $type, $title, $description = '', $link = '')
	{
		$element = new Widget_SimpleTreeViewElement($id, $type, $title, $description, $link);
		return $element;
	}


	public function getClasses()
	{
		$classes = $this->widget->getClasses();
		$classes[] = 'widget-treeview';
		return $classes;
	}


	public function display(Widget_Canvas $canvas)
	{
		// persitent status to template variable
		$this->t_memorizeOpenNodes = $this->isPersistent();
		
		return $canvas->div(
			$this->getId(),
			$this->getClasses(),
			$this->printTemplate()
		)
//		. $canvas->loadScript($this->getId(), bab_getAddonInfosInstance('widgets')->getTemplatePath().'widgets.simpletreeview.js')
		. $canvas->loadStyleSheet(bab_getAddonInfosInstance('widgets')->getStylePath().'widgets.simpletreeview.css');


	}

}


$GLOBALS['Widget_SimpleTreeViewElementCanvas'] = bab_functionality::get('Widgets')->HtmlCanvas();

class Widget_SimpleTreeViewElement extends bab_TreeViewElement
{

	public function __construct($id, $type, $title, $description, $link)
	{
		parent::__construct($id, $type, $title, $description, $link);
	}


	public function setItem(Widget_Displayable_Interface $item)
	{
		global $Widget_SimpleTreeViewElementCanvas;

		$html = $item->display($Widget_SimpleTreeViewElementCanvas);

		$this->_title = $html;

		return $this;
	}
}
