<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2006 by CANTICO ({@link http://www.cantico.fr})
 */
include_once 'base.php';

//require_once $GLOBALS['babInstallPath'] . 'utilit/devtools.php';
require_once $GLOBALS['babInstallPath'] . '/addons/widgets/widgets/containerwidget.class.php';



/**
 * Constructs a Widget_Tab.
 *
 * @param string		$id			The item unique id.
 * @param string		$label
 * @param Widget_Layout	$layout		The layout that will manage how widgets are displayed in this container.
 * @return Widget_Tab
 */
function Widget_Tab($id = null, $label = null, Widget_Layout $layout = null)
{
	return new Widget_Tab($id, $layout);
}



/**
 * Widget_Tab
 *
 */
class Widget_Tab extends Widget_ContainerWidget implements Widget_Displayable_Interface
{

	private $_label						= null;
	private $_title 					= null;
	private $_action 					= null;
	private $_tabPanelCanvasOptions 	= null;
	
	/**
	 * used to generate unique ids.
	 * @var int 
	 */
	private static $idCounter = 1;
	


	/**
	 * @param string 		$id			The item unique id.
	 * @param string		$label
	 * @param Widget_Layout	$layout		The layout that will manage how widgets are displayed in this container.
	 * @return Widget_Frame
	 */
	public function __construct($id = null, $label = null, Widget_Layout $layout = null)
	{
		if (null === $layout) {
			require_once FUNC_WIDGETS_PHP_PATH . 'vboxlayout.class.php';
			$layout = new Widget_VBoxLayout();
		}

		parent::__construct($id, $layout);

		$this->setLabel($label);
	}
	
	
	
	/**
	 * Generates and return a unique id for the current page.
	 * use a counter only affected by other tabs
	 */
	protected function createId()
	{
		return strtolower(get_class($this)) . self::$idCounter++;
	}


	/**
	 * Add an action to execute when clicked
	 * @param Widget_Action	$action
	 * @return Widget_Tab
	 */
	public function setAction(Widget_Action $action) {
		$this->_action = $action;
		return $this;
	}

	/**
	 * @return null|Widget_Action
	 */
	public function getAction() {
		return $this->_action;
	}


	/**
	 * Set tab label
	 * @param	string	$str
	 * @return Widget_Tab
	 */
	public function setLabel($str) {
		$this->_label = $str;
		return $this;
	}

	/**
	 * get tab label
	 * @return string
	 */
	public function getLabel() {
		return $this->_label;
	}


	/**
	 * Set tab title, replace label for title in frame if defined
	 * @param	string	$str
	 * @return Widget_Tab
	 */
	public function setTitle($str) {
		$this->_title = $str;
		return $this;
	}

	/**
	 * disable title in tab frame
	 * @return Widget_Tab
	 */
	public function noTitle() {
		$this->_title = false;
		return $this;
	}

	/**
	 * get tab title
	 * @return string
	 */
	public function getTitle() {
		return null !== $this->_title ? $this->_title : $this->_label;
	}

	/**
	 * get classes for tab item
	 */
	public function getClasses()
	{
		$classes = parent::getClasses();
		$classes[] = 'widget-tab';
		$classes[] = 'ui-tabs-nav-item';


		if ($this === $this->getParent()->getSelectedTab()) {
			$classes[] = 'ui-tabs-selected';
			$classes[] = 'widget-tab-selected';
		}

		return $classes;
	}


	/**
	 * get classes for tab panel
	 */
	public function getTabPanelClasses() {

		$classes = parent::getClasses();
		$classes[] = 'ui-tabs-panel';


		return $classes;
	}


	/**
	 * Set tab panel canvas options
	 * @param	Widget_CanvasOptions	$options
	 * @return 	Widget_Tab
	 */
	public function setTabPanelCanvasOptions(Widget_CanvasOptions $options) {
		$this->_tabPanelCanvasOptions = $options;
		return $this;
	}








	public function display(Widget_Canvas $canvas)
	{

		$items = array();

		if (false === $this->getParent()->displayAllTabs() && $this !== $this->getParent()->getSelectedTab()) {
			return '';
		}

		$items[] = $canvas->anchor($this->getId());

		if ($this->getTitle()) {
			$items[] = $canvas->h('', array('widget-tab-panel-header'), $this->getTitle(), 4);
		}

		$items[] = $this->getLayout();



		$tab = $canvas->div(
			$this->getId(),
			$this->getTabPanelClasses(),
			$items,
			$this->_tabPanelCanvasOptions
		);
		$tab .= $canvas->metadata($this->getId(), $this->getMetadata());
//		$tab .= $canvas->loadScript($this->getId(), bab_getAddonInfosInstance('widgets')->getTemplatePath().'widgets.jquery.js');
		return $tab;
	}

}

