<?php
//-------------------------------------------------------------------------
// OVIDENTIA http://www.ovidentia.org
// Ovidentia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.
//-------------------------------------------------------------------------
/**
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License (GPL)
 * @copyright Copyright (c) 2006 by CANTICO ({@link http://www.cantico.fr})
 */
include_once 'base.php';

require_once $GLOBALS['babInstallPath'] . '/addons/widgets/widgets/lineedit.class.php';


/**
 * Constructs a Widget_UrlLineEdit.
 *
 * @param string		$id			The item unique id.
 * @return Widget_UrlLineEdit
 */
function Widget_UrlLineEdit($id = null)
{
	return new Widget_UrlLineEdit($id);
}


/**
 * A Widget_LineEdit is a widget that lets the user enter an url address.
 */
class Widget_UrlLineEdit extends Widget_LineEdit implements Widget_Displayable_Interface 
{
	

	/**
	 * @param string $id			The item unique id.
	 * @return Widget_LineEdit
	 */
	public function __construct($id = null)
	{
		parent::__construct($id);
		
		$this->setSubmitMessage(widget_translate('Invalid url address'));
		
		$this->setAllowedShemes(array('http', 'https', 'ftp'));
	}
	
	/**
	 * Message displayed on form submit if there is a url line edit widget with an invalid url address
	 * @return Widget_UrlLineEdit
	 */
	public function setSubmitMessage($str)
	{
		$this->setMetadata('submitMessage', $str);
		return $this;
	}
	
	/**
	 * Set a list of allowed sheme in url
	 * default allowed shemes are http, https, ftp
	 * 
	 * @param	Array	$arr
	 * @return Widget_UrlLineEdit
	 */
	public function setAllowedShemes(Array $arr)
	{
		$this->setMetadata('allowedSchemes', $arr);
		return $this;
	}
	

	public function getClasses()
	{
		$classes = parent::getClasses();
		$classes[] = 'widget-urllineedit';
		return $classes;
	}
	
	
	public function display(Widget_Canvas $canvas)
	{
	
		$output = parent::display($canvas);
		$output .= $canvas->loadScript($this->getId(), bab_getAddonInfosInstance('widgets')->getTemplatePath().'widgets.urllineedit.jquery.js');
	
		return $output;
	}
	
}
