
function widget_datePickerInit(domNode)
{
	if (jQuery.datepicker) {
		// Prepare datepicker widgets
		jQuery(domNode).find(".widget-datepicker").each(function() {
			var meta = window.babAddonWidgets.getMetadata(this.id);
			var datePickerOptions = {
				yearRange: '1900:2100',
				firstDay: 1,
				hideIfNoPrevNext: true, 
				constrainInput: true,
				numberOfMonths: meta.numberOfMonths,
				dateFormat: 
					meta.format
					.replace('%Y', 'yy')
					.replace('%m', 'mm')
					.replace('%d', 'dd'), 
				duration: 0, 
				beforeShow: function() {
					var meta = window.babAddonWidgets.getMetadata(this.id);
					if (meta.mindatey != null) {
						mindate = new Date();
						mindate.setYear(meta.mindatey);
						mindate.setMonth(meta.mindatem -1);
						mindate.setDate(meta.mindated);
					} else {
						mindate = null;
					}
					if (meta.maxdatey != null) {
						maxdate = new Date();
						maxdate.setYear(meta.maxdatey);
						maxdate.setMonth(meta.maxdatem -1);
						maxdate.setDate(meta.maxdated);
					} else {
						maxdate = null;
					}

					return {
							minDate: mindate==null ? meta.from	? jQuery('#'+meta.from).datepicker("getDate") 	: null : mindate,
							maxDate: maxdate==null ? meta.to	? jQuery('#'+meta.to).datepicker("getDate") 	: null : maxdate
					};
					
				}
			};
			if (meta.dateClickUrl != '') {
				datePickerOptions.onSelect = function(dateText, inst) {
					var dateClickUrl = meta.dateClickUrl.replace('__date__', dateText);
					window.location.href = dateClickUrl;
				};
			}
			if (jQuery(this).hasClass('widget-datepicker-changeyear')) {
				datePickerOptions.changeYear = true;
			}
			if (jQuery(this).hasClass('widget-datepicker-changemonth')) {
				datePickerOptions.changeMonth = true;
			}

			jQuery(this)
				.datepicker(datePickerOptions)
				.attr('autocomplete', 'off');
			
			// The show/hide is to avoid date picker initialization problem
			// (might not be necessary with newer versions of jquery/ui).
//			jQuery('#' + this.id)
//				.datepicker('show')
//				.datepicker('hide')
//				.blur();

		});
	}
	
}


jQuery(document).ready(function() {
	window.bab.initFunctions.push(widget_datePickerInit);
	widget_datePickerInit(document.getElementsByTagName("BODY")[0]);
});

	
