window.babAddonWidgets.emailLineEditEvent = function() {
	
	var input = jQuery(this);
	
	if ('' == input.val())
	{
		input.addClass('widget-emaillineedit-valid');
		input.removeClass('widget-emaillineedit-invalid');
		return;
	}

	var reg = /^([A-Za-z0-9_\-\.\+])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;
	if(reg.test(input.val()) == false) {
		input.removeClass('widget-emaillineedit-valid');
		input.addClass('widget-emaillineedit-invalid');
	} else {
		input.addClass('widget-emaillineedit-valid');
		input.removeClass('widget-emaillineedit-invalid');
	}
}



function widget_emailLineEditInit(domNode) {
	
	jQuery(domNode).find('.widget-emaillineedit').each(function() {
		var input = jQuery(this);
		
		if (input.data('widgetevent'))
		{
			return;
		}
		
		input.data('widgetevent', true);
		
		// lock form validation if not a valid email address
		
		input.blur(window.babAddonWidgets.emailLineEditEvent);
		input.keyup(window.babAddonWidgets.emailLineEditEvent);

		input.blur();
		
		
		// form event
		
		if (form = input.closest('form'))
		{
			form.submit(function() {
				var input = jQuery(this).find('.widget-emaillineedit-invalid')[0];
				
				if (input)
				{
					input.focus();
					var message = window.babAddonWidgets.getMetadata(input.id).submitMessage;
					
					if (window.babAddonWidgets.validatemandatory) {
						alert(message);
						return false;
					}
					
					if (window.babAddonWidgets.validate) {
						return confirm(message);
					}
				}
				
				return true;
			});
		}
		
	});

}



window.bab.addInitFunction(widget_emailLineEditInit);

