

jQuery(document).ready(function() {
	
	// All initialization function should be added to the window.bab object
	// using the addInitFunction method.
	// Init function should take a dom element as parameter.
	
	var body = document.getElementsByTagName("BODY")[0];
	
	window.bab.init(body);
});




/*
 * jQuery.appear
 * http://code.google.com/p/jquery-appear/
 *
 * Copyright (c) 2009 Michael Hixson
 * Licensed under the MIT license (http://www.opensource.org/licenses/mit-license.php)
*/
(function($) {
  
  $.fn.appear = function(fn, options) {
    
    var settings = $.extend({

      //arbitrary data to pass to fn
      data: undefined,

      //call fn only on the first appear?
      one: true 
      
    }, options);
    
    return this.each(function() {
    
      var t = $(this);
      
      //whether the element is currently visible
      t.appeared = false;
      
      if (!fn) {

        //trigger the custom event
        t.trigger('appear', settings.data);
        return;
      }
      
      var w = $(window);
      
      //fires the appear event when appropriate
      var check = function() {

        //is the element hidden?
        if (!t.is(':visible')) {
          
          //it became hidden
          t.appeared = false;
          return;
        }

        //is the element inside the visible window?
        var a = w.scrollLeft();
        var b = w.scrollTop();
        var o = t.offset();
        var x = o.left;
        var y = o.top;
        
        if (y + t.height() >= b && 
            y <= b + w.height() &&
            x + t.width() >= a && 
            x <= a + w.width()) {

          //trigger the custom event
          if (!t.appeared) t.trigger('appear', settings.data);
          
        } else {

          //it scrolled out of view
          t.appeared = false;
        }
      };

      //create a modified fn with some additional logic
      var modifiedFn = function() {
        
        //mark the element as visible
        t.appeared = true;

        //is this supposed to happen only once?
        if (settings.one) {

          //remove the check
          w.unbind('scroll', check);
          var i = $.inArray(check, $.fn.appear.checks);
          if (i >= 0) $.fn.appear.checks.splice(i, 1);
        }

        //trigger the original fn
        fn.apply(this, arguments);
      };
      
      //bind the modified fn to the element
      if (settings.one) t.one('appear', settings.data, modifiedFn);
      else t.bind('appear', settings.data, modifiedFn);
      
      //check whenever the window scrolls
      w.scroll(check);
      
      //check whenever the dom changes
      $.fn.appear.checks.push(check);
      
      //check now
      (check)();
    });
  };
  
  //keep a queue of appearance checks
  $.extend($.fn.appear, {
    
    checks: [],
    timeout: null,

    //process the queue
    checkAll: function() {
      var length = $.fn.appear.checks.length;
      if (length > 0) while (length--) ($.fn.appear.checks[length])();
    },

    //check the queue asynchronously
    run: function() {
      if ($.fn.appear.timeout) clearTimeout($.fn.appear.timeout);
      $.fn.appear.timeout = setTimeout($.fn.appear.checkAll, 20);
    }
  });
  
  //run checks when these methods are called
  $.each(['append', 'prepend', 'after', 'before', 'attr', 
          'removeAttr', 'addClass', 'removeClass', 'toggleClass', 
          'remove', 'css', 'show', 'hide'], function(i, n) {
    var old = $.fn[n];
    if (old) {
      $.fn[n] = function() {
        var r = old.apply(this, arguments);
        $.fn.appear.run();
        return r;
      };
    }
  });
  
})(jQuery);







function widget_datePickerInit(domNode)
{
	if (jQuery.datepicker) {
		// Prepare datepicker widgets
		jQuery(domNode).find(".widget-datepicker").each(function() {
			var meta = window.babAddonWidgets.getMetadata(this.id);
			var datePickerOptions = {
				yearRange: '1900:2100',
				firstDay: 1,
				hideIfNoPrevNext: true, 
				constrainInput: true,
				numberOfMonths: meta.numberOfMonths,
				dateFormat: 
					meta.format
					.replace('%Y', 'yy')
					.replace('%m', 'mm')
					.replace('%d', 'dd'), 
				duration: 0, 
				beforeShow: function() {
					var meta = window.babAddonWidgets.getMetadata(this.id);
					if (meta.mindatey != null) {
						mindate = new Date();
						mindate.setYear(meta.mindatey);
						mindate.setMonth(meta.mindatem -1);
						mindate.setDate(meta.mindated);
					} else {
						mindate = null;
					}
					if (meta.maxdatey != null) {
						maxdate = new Date();
						maxdate.setYear(meta.maxdatey);
						maxdate.setMonth(meta.maxdatem -1);
						maxdate.setDate(meta.maxdated);
					} else {
						maxdate = null;
					}

					return {
							minDate: mindate==null ? meta.from	? jQuery('#'+meta.from).datepicker("getDate") 	: null : mindate,
							maxDate: maxdate==null ? meta.to	? jQuery('#'+meta.to).datepicker("getDate") 	: null : maxdate
					};
					
				}
			};
			if (meta.dateClickUrl != '') {
				datePickerOptions.onSelect = function(dateText, inst) {
					var dateClickUrl = meta.dateClickUrl.replace('__date__', dateText);
					window.location.href = dateClickUrl;
				};
			}
			if (jQuery(this).hasClass('widget-datepicker-changeyear')) {
				datePickerOptions.changeYear = true;
			}
			if (jQuery(this).hasClass('widget-datepicker-changemonth')) {
				datePickerOptions.changeMonth = true;
			}

			jQuery(this)
				.datepicker(datePickerOptions)
				.attr('autocomplete', 'off');
		});
	}
	
}






jQuery.fn.limitMaxLength = function(options){

	var settings = jQuery.extend({
		attribute: "maxlength",
		onLimit: function(){},
		onEdit: function(){}
	}, options);

	// Event handler to limit the textarea
	var onEdit = function(){
		var textarea = jQuery(this);
		var maxlength = parseInt(textarea.attr(settings.attribute));

		if(textarea.val().length > maxlength){
			textarea.val(textarea.val().substr(0, maxlength));

			// Call the onlimit handler within the scope of the textarea
			jQuery.proxy(settings.onLimit, this)();
		}

		// Call the onEdit handler within the scope of the textarea
		jQuery.proxy(settings.onEdit, this)(maxlength - textarea.val().length);
	};

	this.each(onEdit);

	return this.keyup(onEdit)
				.keydown(onEdit)
				.focus(onEdit)
				.live('input paste', onEdit);
};



/*
 * jQuery autoResize (textarea auto-resizer)
 * @copyright James Padolsey http://james.padolsey.com
 * @version 1.04
 */

jQuery.fn.autoResize = function(options) {
        
    // Just some abstracted details,
    // to make plugin users happy:
    var settings = jQuery.extend({
        onResize : function(){},
        animate : false,
        animateDuration : 150,
        animateCallback : function(){},
        extraSpace : 4,
        limit: 400
    }, options);
    
    // Only textarea's auto-resize:
    this.filter('textarea').each(function(){
    	
            // Get rid of scrollbars and disable WebKit resizing:
        var textarea = jQuery(this).css({resize:'none','overflow-y':'hidden'}),
        
            // Cache original height, for use later:
            origHeight = 0; //textarea.height(),
            
            // Need clone of textarea, hidden off screen:
            clone = (function(){
            	

            	
                
                
                // Properties which may effect space taken up by characters:
                var props = ['height','width','lineHeight','textDecoration','letterSpacing'],
                    propOb = {};
                    
                // Create object of styles to apply:
                $.each(props, function(i, prop){
                    propOb[prop] = textarea.css(prop);
                });
                
                if (textarea.prev().css('left') === '-9999px')
            	{
                	return textarea.prev().css(propOb);
            	}
                
                // Clone the actual textarea removing unique properties
                // and insert before original textarea:
                return textarea.clone().removeAttr('id').removeAttr('name').css({
                    position: 'absolute',
                    top: 0,
                    left: -9999,
                    minHeight: 0
                }).css(propOb).attr('tabIndex','-1').insertBefore(textarea);
				
            })(),
            lastScrollTop = null,
            updateSize = function() {
            	
                // Prepare the clone:
                clone.height(0).val(jQuery(this).val()).scrollTop(10000);
				
                // Find the height of text:
                var scrollTop = Math.max(clone.scrollTop(), origHeight) + settings.extraSpace,
                    toChange = $(this).add(clone);
                    
					
                // Don't do anything if scrollTip hasen't changed:
                if (lastScrollTop === scrollTop) { return; }
                lastScrollTop = scrollTop;
				
                // Check for limit:
                if ( scrollTop >= settings.limit ) {
                    $(this).css('overflow-y','');
                    return;
                }
                // Fire off callback:
                settings.onResize.call(this);
				
                // Either animate or directly apply height:
                settings.animate && textarea.css('display') === 'block' ?
                    toChange.stop().animate({height:scrollTop}, settings.animateDuration, settings.animateCallback)
                    : toChange.height(scrollTop);
            };
        
        // Bind namespaced handlers to appropriate events:
        textarea
            .unbind('.dynSiz')
            .bind('keyup.dynSiz', updateSize)
            .bind('change.dynSiz', updateSize)
        	.bind('resize', updateSize);
        
        textarea.trigger('resize');
        
        
        
    });
    
    // Chain:
    return this;
};


function widget_delayedInit(item){
	var meta = window.babAddonWidgets.getMetadata(item.id);
	var widget = item;
	if (meta.delayedAction != '') {
		jQuery.ajax({
			url: meta.delayedAction,
			success: function(response) {
				var parent = jQuery(widget).parent().get(0);
				jQuery(parent).hide();
				jQuery(parent).html(response);
				var newmeta = window.babAddonWidgets.getMetadata(parent.firstChild.id);
				jQuery(parent).html(response);
				newmeta.delayedAction = meta.delayedAction;
				window.babAddonWidgets.addMetadata(parent.firstChild.id, newmeta);
				jQuery(parent).fadeIn('slow');
				
				window.bab.init(parent);
				window.bab.init(jQuery('body > .ui-dialog').get(0));
			}
		});
	}
}


function widget_baseInit(domNode) {

	// Prepare tab widgets
	if (jQuery().tabs) {
		jQuery(domNode).find(".widget-tabs").not('.widget-static-tabs').each(function() {
			
			var myFile = document.location.toString();
			if (myFile.match('#') && !jQuery(this).find('.widget-tab-selected').get(0)) {
				var tabid = myFile.split('#')[1];
				jQuery(this).find('a[href=#'+tabid+']').parent().addClass('widget-tab-selected');
			}
			
			var selectedTabNumber = 0;
			var tagNumber = 0;
			jQuery(this).find('.widget-tab').each(function() {
				if (jQuery(this).hasClass('widget-tab-selected')) {
					selectedTabNumber = tagNumber;
				}
				tagNumber++;
			}
			);
			jQuery(this).tabs({ selected: selectedTabNumber });
		}
		);
	}

	if (jQuery().accordion) {
		// Prepare accordions widgets
		jQuery(domNode).find(".widget-accordions").each(function () {
			
			var meta = window.babAddonWidgets.getMetadata(this.id);

			var accordionOptions = {
				header: "span.widget-accordion-header",
				navigation: true,
				autoHeight: false,
				active: false,
				clearStyle: true,
				collapsible: true,
				active: ".widget-accordion-header-open"
			};
			if (!meta.animated) {
				accordionOptions.animated = false;
			}
			if (meta.collapsible == false) {
				accordionOptions.collapsible = false;
			}
			jQuery(this)
				.accordion(accordionOptions);
		});
	}

	jQuery(domNode).find(".widget-link").not('.widget-init-done').each(function() {
		jQuery(this).addClass('widget-init-done');
		
		if (jQuery(this).hasClass('widget-ajax')) {
			jQuery(this).click(function(e) {
				
				var link = this;
				var meta = window.babAddonWidgets.getMetadata(jQuery(link).attr('id'));
				
				
				
				if (meta.ajaxActionReload) {
					for (var i in meta.ajaxActionReload){
						domNode = document.getElementById(meta.ajaxActionReload[i]);
						do {
							if (window.babAddonWidgets.getMetadata(domNode.id).delayedAction) {
								var parent = jQuery(domNode).parent().get(0);
								jQuery(parent).addClass('widget-delayed-action-loading');
								break;
							}
						} while (domNode = domNode.parentNode);
					}
				}
				
		
				jQuery.ajax({
					url: meta.ajaxAction,
					success: function(response) {
						if (meta.ajaxActionReload) {
							for (var i in meta.ajaxActionReload){
								if(document.getElementById(meta.ajaxActionReload[i])){
									window.babAddonWidgets.reload(document.getElementById(meta.ajaxActionReload[i]));
								}
							}
						}
					}
				});
				e.stopPropagation();
				return false;
			});
		}
		if (jQuery(this).hasClass('widget-popup')) {
			jQuery(this).click(function(e) {
				bab_popup(jQuery(this).attr('href'));
				e.stopPropagation();
				return false;
			});
		}
	});

	jQuery(domNode).find('.widget-confirm').not('.widget-confirm-init-done').each(function() {
		jQuery(this).addClass('widget-confirm-init-done');
		jQuery(this).click(function(e) {
			try {
				if (confirmationMessage = window.babAddonWidgets.getMetadata(this.id).confirmationMessage) {
					var confirmed = window.confirm(confirmationMessage);
					if (!confirmed) {
						e.stopPropagation();
						return false;
					}
				}
				e.stopPropagation();
				return true;
			} catch (ex) {
				return true;
			}
		});
	});



	
	
	
	// sortable
	if (jQuery().sortable) {
		jQuery(domNode).find(".widget-sortable").sortable({
			placeholder: 'widget-sortable-placeholder'
		});
	}

	
	jQuery(domNode).find(".widget-filter .header").click(function(e) {
		var filter = jQuery(this).parents('.widget-filter').get(0);
		form = jQuery(filter).find('form.widget-form').get(0);
		jQuery(form).toggle('normal');
	});


	jQuery(domNode).find('.widget-textedit').each(function () {
		var meta = window.babAddonWidgets.getMetadata(this.id);
		if (meta && meta.maxSize) {
			jQuery(this).attr('maxlength', meta.maxSize);
			jQuery(this).limitMaxLength({});
		}
	});

	
	if (jQuery().autoResize) {
		
		jQuery(domNode).find('.widget-textedit.widget-autoresize').autoResize();
		
		
		// add also the autoresize on the focus event because the autoresize does not not work with only the first line
		
		jQuery(domNode).find('.widget-textedit.widget-autoresize').live('focus', function () {
			jQuery(this).autoResize();
		}); 
		
	}
	
	

	
	
	// associated displayable widgets
	
	jQuery(domNode).find('.widget-associated-displayable').each(function(key, source) {
		
		
		
		source = jQuery(source);
		var metadata = window.babAddonWidgets.getMetadata(source.attr('id'));
		
		if (metadata.displayable)
		{
			var eventAction = function() {

				var selected = null;
				var source = jQuery(this);
				
				switch(true)
				{
					case source.is('select'):
						selected = source.find('option:selected').attr('value');
						break;
					
					case source.is('input[type="checkbox"]:checked'):
						selected = source.attr('value');
						break;
						
					case source.is('input[type="checkbox"]'):
						selected = jQuery('input[type="hidden"][name="'+source.attr('name')+'"]').attr('value');
						break;
						
					case source.is('input[type="radio"]'):
						selected = source.attr('value');
						break;
				}
				
				for(var i =0; i< metadata.displayable.length; i++)
				{
					var target = jQuery('#'+metadata.displayable[i][0]);
					var values = metadata.displayable[i][1];
					var disp = 0;
	
					for (var j=0; j < values.length; j++)
					{
						if (values[j] == selected)
						{
							target.show();
							disp = 1;
							break;
						}
					}
					
					if (disp == 0)
					{
						target.hide();
					}
				}
			};
			
			if (source.is('.widget-radioset'))
			{
				source.find('input[type=radio]').click(eventAction);
				
				if (source.find('input[type=radio]:checked').length == 0)
				{
					source.find('input[type=radio]:first').click();
				} else {
					source.find('input[type=radio]:checked').click();
				}
				
			} else {
				source.change(eventAction);
				source.change();
			}
		}
	});

	
	// Delayed items
	jQuery(domNode).find(".widget-delayeditem").not('.widget-init-done').each(function() {
		jQuery(this).addClass('widget-init-done');
		
		if (!jQuery(this).hasClass('widget-delayeditem-onreload')) {
			var meta = window.babAddonWidgets.getMetadata(this.id);
			if(meta.updateMode == 'on-appear'){			
				jQuery(this).appear(function() {
					jQuery(this).addClass('loading');
					widget_delayedInit(this);
				});
			}else if(meta.updateMode == 'on-page-load'){
				jQuery(this).addClass('loading');
				widget_delayedInit(this);
			}
		}
	});

	jQuery(domNode).find('.widget-hasHelp').not('.widget-hasHelp-init-done').each(function(){
		jQuery(this).addClass('widget-hasHelp-init-done');
		var id = jQuery(this).attr('id');
		var meta = window.babAddonWidgets.getMetadata(id);
		var html = meta.contextualHelp
		jQuery("body").append('<span class="'+id+'" style="z-index:1; padding: 5px; border-radius: .25em; display: none; background-color: #eee; border: 1px solid #aaa;" class="widget-activeHelp">'+html+'</span>');
		jQuery(this).focus(function(){
			var pos = jQuery('#'+id).offset();
			var bottom = jQuery(window).height() - jQuery('#'+id).height() - pos.top -6;
			var left = pos.left;
			left = left + jQuery('#'+id).width() + 9;
			jQuery('.'+id).css('display', 'inline-block');
			jQuery('.'+id).css('position', 'absolute');
			jQuery('.'+id).css('bottom', bottom);
			jQuery('.'+id).css('left', left);
		});

		jQuery(this).blur(function(){
			jQuery('.'+id).css('display', 'none');
		});
	})
}


window.bab.addInitFunction(widget_baseInit);

window.bab.addInitFunction(widget_datePickerInit);
