/*
 * widgets.js
 * add some default optional js actions associated to css classes
 * depend only from ovidentia.js
 */



window.bab = {
	initFunctions: [],
	
	addInitFunction: function (f) {
		this.initFunctions.push(f);
	},
	
	init: function (domNode) {
		for (var i = 0; i < this.initFunctions.length; i++) {
			var initFunction = this.initFunctions[i];
			initFunction(domNode);
		}		
	}
};


window.babAddonWidgets = new Object();



/**
 * @param	domNode	Objects
 */
window.babAddonWidgets.reload = function(/* domNodes */) {
	
	for (var i = 0; i < arguments.length; i++) {

		domNode = arguments[i];

		do {
			if (domNode.id) {
				var meta = window.babAddonWidgets.getMetadata(domNode.id);
				if (meta.delayedAction) {
					
					var parent = jQuery(domNode).parent().get(0);
					jQuery(parent).addClass('widget-delayed-action-loading');

					jQuery.ajax({
						url: meta.delayedAction,
						success: function(response) {
							jQuery(parent).removeClass('widget-delayed-action-loading');
							jQuery(parent).css('visibility', 'hidden');
							jQuery(parent).html(response);
							var newmeta = window.babAddonWidgets.getMetadata(parent.firstChild.id);
							newmeta.delayedAction = meta.delayedAction;
							window.babAddonWidgets.addMetadata(parent.firstChild.id, newmeta);
							jQuery(parent).css('visibility', 'visible');

							window.bab.init(parent);
							window.bab.init(jQuery('body > .ui-dialog').get(0));
						}
					});
	
					break;
				}
			}
		} while (domNode = domNode.parentNode);

	}
//	window.location.reload();
};


/**
 * @param	string	metaname
 * @param	arr		Object
 * @return Object
 */
window.babAddonWidgets.addMetadata = function(metaname, arr) {

	if (typeof window.babAddonWidgets.metadata == 'undefined') {
		window.babAddonWidgets.metadata = {};
	}

	window.babAddonWidgets.metadata[metaname] = arr;
};


/**
 * @param	string	metaname
 * @return Object
 */
window.babAddonWidgets.getMetadata = function(metaname) {

	if (typeof window.babAddonWidgets.metadata == 'undefined' || typeof window.babAddonWidgets.metadata[metaname] == 'undefined') {
		return {};
	}

	return window.babAddonWidgets.metadata[metaname];
};



window.babAddonWidgets.initLoad = new Object();


window.babAddonWidgets.loadScript = function (script, file)
{
	 script.onreadystatechange = function () {
         if (this.readyState == 'complete') {
        	 for (var i = 0; i < window.babAddonWidgets.initLoad[file].length; i++)
        	 {
        		 //var initLoad = window.babAddonWidgets.initLoad[file];
        		 node = document.getElementById(window.babAddonWidgets.initLoad[file][i]);
        		 window.bab.init(node.parentNode);
        	 }
         }
      };
      script.onload = function() {
    	 for (var i = 0; i < window.babAddonWidgets.initLoad[file].length; i++)
     	 {
    		 //var initLoad = window.babAddonWidgets.initLoad[file];
    		 if (window.babAddonWidgets.initLoad[file][i]) {
    			 
    			 node = document.getElementById(window.babAddonWidgets.initLoad[file][i]);
    			 window.bab.init(node.parentNode);
    		 }
     	 }
      };
};



/**
 * Include a Javascript file from the widget Addon
 * @param string	file
 */
window.babAddonWidgets.include = function(widget_id, file)
{
	if (!document.createElement || !document.getElementsByTagName) {
		alert('Your browser can\'t deal with the DOM standard. That means it\'s old.');
		return false;
	}
	
	url = file;
 
	if (typeof window.babAddonWidgets.initLoad[file] == 'undefined') {
		window.babAddonWidgets.initLoad[file] = [];
	}
 
	var node = document.getElementById(widget_id);
	
	if (!node && console) {
		console.log('failed to get widget id : '+widget_id);
	} 
 
	window.babAddonWidgets.initLoad[file].push(widget_id);

	var head = document.getElementsByTagName('head')[0];

	var s = head.getElementsByTagName('script');
	for (var i =0; i < s.length; i++) {
		if (url == s[i].getAttribute('src')) {
			return true;
		}
	}

	var script = document.createElement('script');
	script.setAttribute('type', 'text/javascript');
 
	script.setAttribute('src', url);

	head.appendChild(script);
 
	window.babAddonWidgets.loadScript(script, file);
	return true;
};



/**
 * Include a Javascript file from the widget Addon
 * @param string	file
 */
window.babAddonWidgets.stylesheet = function(file) {
	if (document.createElement && document.getElementsByTagName) {
		
	 url = file;
	
     var head = document.getElementsByTagName('head')[0];
     
     var s = head.getElementsByTagName('link');
     for (var i =0; i < s.length; i++)
    	 {
    	 if (url == s[i].getAttribute('href'))
    		 {
    		 return true;
    		 }
    	 }

     var script = document.createElement('link');
     script.setAttribute('type', 'text/css');
     script.setAttribute('rel', 'stylesheet');
     script.setAttribute('href', url);

     
     
     head.appendChild(script);
     return true;
   } else {
	   alert('Your browser can\'t deal with the DOM standard. That means it\'s old.');
   }

	return false;
};