/**
 * Add a button next to last field of a multifield container. The button create a copy of the last field and insert it under
 * The new field will have a new name.
 * 
 * @see Widget_MultiField
 */


jQuery(document).ready(function() {


	 window.babAddonWidgets.multiField_setBtn = function(vboxitem) {
		// create add button next to field
		container = jQuery(vboxitem).parents('.widget-multifield');

		if (container) {
			
			container.css('white-space', 'nowrap');

			// add button
			
			meta = window.babAddonWidgets.getMetadata(container.attr('id'));
			btn = jQuery('<small class="ui-default-state">'+meta.addlabel+'</small>').css('cursor', 'pointer');
			
			vboxitem.appendChild(btn.get(0));


			btn.click(function() {
				vboxitem = jQuery(this).parent();
				
				jQuery(this).next().remove();
				jQuery(this).remove();
				
				vbox = vboxitem.parent().get(0);
				newvboxitem = vboxitem.clone();
				newvboxitem.find('script').remove();
				newvboxitem.hide();
				vbox.appendChild(newvboxitem.get(0));
				
				// remove value

				newvboxitem.find('input').attr('value', '');
				newvboxitem.find('textarea').children().remove();
				newvboxitem.find('select option[selected]').removeAttr('selected');
				
				
				
				newvboxitem.slideDown('fast', function() {
					window.babAddonWidgets.multiField_setBtn(this);
				});

				currentname = newvboxitem.find('input, select, textarea').attr('name');
				result = /^(.*?)\[(\d+?)\]$/.exec(currentname);

				if (!result) {
					alert('unexpected matching error on name : '.currentname);
					return;
				}
				
				currentid = newvboxitem.find('input, select, textarea').attr('id');
				nameindex = (1+parseInt(result[2]));
				
				newvboxitem.find('input, select, textarea')
					.attr('name', result[1]+'['+nameindex+']')
					.attr('id', currentid+'-'+nameindex);
				
				// add metadata
				
				currentmeta = window.babAddonWidgets.getMetadata(currentid);
				window.babAddonWidgets.addMetadata(currentid+'-'+nameindex, currentmeta);
				
				
				
				if (newvboxitem.find('.widget-datepicker').get(0)) {
					newvboxitem.find('input').removeClass('hasDatepicker');
					widget_datePickerInit(newvboxitem);
				}
				
				if (newvboxitem.find('.widget-suggestedit').get(0)) {
					newvboxitem.find('input').removeAttr('jqac').removeAttr('autocomplete');
					window.babAddonWidgets.suggestedit_init(newvboxitem);
				}
				
			});


			// remove button
			
			if (jQuery(vboxitem).prev('.widget-layout-vbox-item').get(0)) {
				btn = jQuery('<small class="ui-default-state">'+meta.removelabel+'</small>').css('cursor', 'pointer');

				vboxitem.appendChild(btn.get(0));


				btn.click(function() {
					vboxitem = jQuery(this).parent();
					newlast = vboxitem.prev('.widget-layout-vbox-item').get(0);
					vboxitem.slideUp('fast', function() {
						jQuery(this).remove();
					});
	
					if (newlast) {
						window.babAddonWidgets.multiField_setBtn(newlast);
					}
				});

			}
		}
	}


	// add buttons on fields

	jQuery('.widget-multifield .widget-layout-vbox-item:last-child').each(function() {
 		 window.babAddonWidgets.multiField_setBtn(this);
	});
});

