 /*
 * Widget_RadioMenu based on 
 * jQuery UI selectmenu
 *
 * Copyright (c) 2009 AUTHORS.txt (http://jqueryui.com/about)
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 *
 * http://docs.jquery.com/UI
 */

(function(jQuery) {

jQuery.widget("widgets.radiomenu", {
	_init: function() {
		var self = this, o = this.options;
		
		//quick array of button and menu id's
		this.ids = [this.element.attr('id') + '-' + 'button', this.element.attr('id') + '-' + 'menu'];
		
		//define safe mouseup for future toggling
		this._safemouseup = true;
		
		//create menu button wrapper
		this.newelement = jQuery('<a class="'+ this.widgetBaseClass +' ui-state-default ui-corner-all" id="'+this.ids[0]+'" role="button" href="#" aria-haspopup="true" aria-owns="'+this.ids[1]+'"></a>')
			.insertAfter(this.element);
		
		//transfer tabindex
		var tabindex = this.element.attr('tabindex');
		if(tabindex){ this.newelement.attr('tabindex', tabindex); }
		
		//save reference to select in data for ease in calling methods
		this.newelement.data('selectelement', this.element);
		
		//menu icon
		this.selectmenuIcon = jQuery('<span class="'+ this.widgetBaseClass +'-icon ui-icon"></span>')
			.prependTo(this.newelement)
			.addClass( (o.style == "popup")? 'ui-icon-triangle-2-n-s' : 'ui-icon-triangle-1-s' );	
	
		
		//click toggle for menu visibility
		this.newelement
			.bind('mousedown', function(event){
				self._toggle(event);
				//make sure a click won't open/close instantly
				if(o.style == "popup"){
					self._safemouseup = false;
					setTimeout(function(){self._safemouseup = true;}, 300);
				}	
				return false;
			})
			.bind('click',function(){
				return false;
			})
			.keydown(function(event){
				var ret = true;
				switch (event.keyCode) {
					case jQuery.ui.keyCode.ENTER:
						ret = true;
						break;
					case jQuery.ui.keyCode.SPACE:
						ret = false;
						self._toggle(event);	
						break;
					case jQuery.ui.keyCode.UP:
					case jQuery.ui.keyCode.LEFT:
						ret = false;
						self._moveSelection(-1);
						break;
					case jQuery.ui.keyCode.DOWN:
					case jQuery.ui.keyCode.RIGHT:
						ret = false;
						self._moveSelection(1);
						break;	
					case jQuery.ui.keyCode.TAB:
						ret = true;
						break;	
					default:
						ret = false;
						self._typeAhead(event.keyCode, 'mouseup');
						break;	
				}
				return ret;
			})
			.bind('mouseover focus', function(){ 
				jQuery(this).addClass(self.widgetBaseClass+'-focus ui-state-hover'); 
			})
			.bind('mouseout blur', function(){  
				jQuery(this).removeClass(self.widgetBaseClass+'-focus ui-state-hover'); 
			});
		
		//document click closes menu
		jQuery(document)
			.mousedown(function(event){
				self.close(event);
			});

		//change event on original selectmenu
		this.element
			.click(function(){ this._refreshValue(); })
			.focus(function(){ this.newelement[0].focus(); });
		
		//create menu portion, append to body
		var cornerClass = (o.style == "dropdown")? " ui-corner-bottom" : " ui-corner-all"
		this.list = jQuery('<ul class="' + self.widgetBaseClass + '-menu ui-widget-content'+cornerClass+'" aria-hidden="true" role="listbox" aria-labelledby="'+this.ids[0]+'" id="'+this.ids[1]+'"></ul>').appendTo('body');				
		
		//serialize selectmenu element options	
		var selectOptionData = [];
		this.element
			.find('.widget-radio-menu-item')
			.each(function(){
				
				meta = window.babAddonWidgets.getMetadata(jQuery(this).attr('id'));
				var radio = jQuery(this).find('input[type=radio]');
				
				selectOptionData.push({
					value: radio.attr('value'),
					item: jQuery(this).find('.widget-radio-menu-item-selectable'),
					selected: radio.attr('checked'),
					classes: jQuery(this).attr('class'),
					parentOptGroup: null
				});
			});	
		
		
		//active state class is only used in popup style
		var activeClass = (self.options.style == "popup") ? " ui-state-active" : "";
		
		//write li's
		var selectOptionDataLength = selectOptionData.length;
		for (var i = 0; i < selectOptionDataLength; i++) {
			var thisLi = jQuery('<li role="presentation"><a href="#" tabindex="-1" role="option" aria-selected="false"></a></li>')
				.append(selectOptionData[i].item.clone())
				.data('index',i)
				.addClass(selectOptionData[i].classes)
				.data('optionClasses', selectOptionData[i].classes|| '')
				.mouseup(function(event){
						if(self._safemouseup){
							var changed = jQuery(this).data('index') != self._selectedIndex();
							self.value(jQuery(this).data('index'));
							self.select(event);
							if(changed){ self.change(event); }
							self.close(event,true);
						}
					return false;
				})
				.click(function(){
					return false;
				})
				.bind('mouseover focus', function(){ 
					self._selectedOptionLi().addClass(activeClass); 
					self._focusedOptionLi().removeClass(self.widgetBaseClass+'-item-focus ui-state-hover'); 
					jQuery(this).removeClass('ui-state-active').addClass(self.widgetBaseClass + '-item-focus ui-state-hover'); 
				})
				.bind('mouseout blur', function(){ 
					if(jQuery(this).is( self._selectedOptionLi() )){ jQuery(this).addClass(activeClass); }
					jQuery(this).removeClass(self.widgetBaseClass + '-item-focus ui-state-hover'); 
				});
				
			
			thisLi.appendTo(this.list);
			
			//this allows for using the scrollbar in an overflowed list
			this.list.bind('mousedown mouseup', function(){return false;});
			
		}	
		
		//add corners to top and bottom menu items
		this.list.find('li:last').addClass("ui-corner-bottom");
		if(o.style == 'popup'){ this.list.find('li:first').addClass("ui-corner-top"); }
		
		//transfer classes to radiomenu and list
		if(o.transferClasses){
			var transferClasses = this.element.attr('class') || ''; 
			this.newelement.add(this.list).addClass(transferClasses);
		}
		
		//original radiomenu width
		var selectWidth = this.element.width();
		
		var metadata = window.babAddonWidgets.getMetadata(this.element.attr('id'));
		
		//set menu button width
		this.newelement.width( (metadata.width) ? metadata.width : selectWidth);
		
		//set menu width to either menuWidth option value, width option value, or select width 
		if(o.style == 'dropdown')
		{ 
			this.list.width( (metadata.menuWidth) ? metadata.menuWidth : selectWidth); 
		}
		else 
		{ 
			if (metadata.menuWidth)
			{
				var width = metadata.menuWidth;
			} else {
				var width = ((metadata.width) ? (metadata.width - o.handleWidth) : (selectWidth - o.handleWidth));
			}
			
			
			this.list.width(width); 
		}	
		
		//set max height from option 
		if(o.maxHeight && o.maxHeight < this.list.height()){ this.list.height(o.maxHeight); }	
		
		//save reference to actionable li's (not group label li's)
		this._optionLis = this.list.find('li.widget-radio-menu-item');
				
		//transfer menu click to menu button
		this.list
			.keydown(function(event){
				var ret = true;
				switch (event.keyCode) {
					case jQuery.ui.keyCode.UP:
					case jQuery.ui.keyCode.LEFT:
						ret = false;
						self._moveFocus(-1);
						break;
					case jQuery.ui.keyCode.DOWN:
					case jQuery.ui.keyCode.RIGHT:
						ret = false;
						self._moveFocus(1);
						break;	
					case jQuery.ui.keyCode.HOME:
						ret = false;
						self._moveFocus(':first');
						break;	
					case jQuery.ui.keyCode.PAGE_UP:
						ret = false;
						self._scrollPage('up');
						break;	
					case jQuery.ui.keyCode.PAGE_DOWN:
						ret = false;
						self._scrollPage('down');
						break;
					case jQuery.ui.keyCode.END:
						ret = false;
						self._moveFocus(':last');
						break;			
					case jQuery.ui.keyCode.ENTER:
					case jQuery.ui.keyCode.SPACE:
						ret = false;
						self.close(event,true);
						jQuery(event.target).parents('li:eq(0)').trigger('mouseup');
						break;		
					case jQuery.ui.keyCode.TAB:
						ret = true;
						self.close(event,true);
						break;	
					case jQuery.ui.keyCode.ESCAPE:
						ret = false;
						self.close(event,true);
						break;	
					default:
						ret = false;
						self._typeAhead(event.keyCode,'focus');
						break;		
				}
				return ret;
			});
		
		//selectmenu style
		if(o.style == 'dropdown'){
			this.newelement
				.addClass(self.widgetBaseClass+"-dropdown");
			this.list
				.addClass(self.widgetBaseClass+"-menu-dropdown");	
		}
		else {
			this.newelement
				.addClass(self.widgetBaseClass+"-popup");
			this.list
				.addClass(self.widgetBaseClass+"-menu-popup");	
		}
		
		//append status span to button
		this.newelement.prepend(jQuery('<span class="'+self.widgetBaseClass+'-status"></span>').append(this._visibleitem()));
		
		//transfer disabled state
		if(this.element.attr('disabled') == true){ this.disable(); }
		
		//update value
		this.value(this._selectedIndex());
		
		//hide original selectmenu element
		this.element.hide();
	},
	_visibleitem: function() {
		var visibleitem = null;
		meta = window.babAddonWidgets.getMetadata(jQuery(this.element).attr('id'));
		
		
		this.element
		.find('.widget-radio-menu-item')
		.each(function(){
			radio = jQuery(this).find('input[type=radio]:checked');

			if (radio.get(0)) {
				var value = radio.attr('value');
				if (meta.visible && value && meta.visible[value]) {
					visibleitem = jQuery(meta.visible[value]);
				}
				if (null == visibleitem) {
					visibleitem = jQuery(this).find('.widget-radio-menu-item-selectable').clone();
				}
				return;
			}
		});	
		
		return visibleitem;
	},
	
	destroy: function() {
		this.element.removeData(this.widgetName)
			.removeClass(this.widgetBaseClass + '-disabled' + ' ' + this.namespace + '-state-disabled')
			.removeAttr('aria-disabled');
	
		//unbind click on label, reset its for attr
		jQuery('label[for='+this.newelement.attr('id')+']')
			.attr('for',this.element.attr('id'))
			.unbind('click');
		this.newelement.remove();
		this.list.remove();
		this.element.show();	
	},
	_typeAhead: function(code, eventType){
		var self = this;
		//define self._prevChar if needed
		if(!self._prevChar){ self._prevChar = ['',0]; }
		var C = String.fromCharCode(code);
		c = C.toLowerCase();
		var focusFound = false;
		function focusOpt(elem, ind){
			focusFound = true;
			jQuery(elem).trigger(eventType);
			self._prevChar[1] = ind;
		};
		this.list.find('li a').each(function(i){	
			if(!focusFound){
				var thisText = jQuery(this).text();
				if( thisText.indexOf(C) == 0 || thisText.indexOf(c) == 0){
						if(self._prevChar[0] == C){
							if(self._prevChar[1] < i){ focusOpt(this,i); }	
						}
						else{ focusOpt(this,i); }	
				}
			}
		});
		this._prevChar[0] = C;
	},
	_uiHash: function(){
		return {
			value: this.value()
		};
	},
	open: function(event){
		var self = this;
		var disabledStatus = this.newelement.attr("aria-disabled");
		if(disabledStatus != 'true'){
			this._refreshPosition();
			this._closeOthers(event);
			this.newelement
				.addClass('ui-state-active');
			
			this.list
				.appendTo('body')
				.addClass(self.widgetBaseClass + '-open')
				.attr('aria-hidden', false)
				.find('li.widget-radio-menu-item:eq('+ this._selectedIndex() +') a')[0].focus();	
			if(this.options.style == "dropdown"){ this.newelement.removeClass('ui-corner-all').addClass('ui-corner-top'); }	
			this._refreshPosition();
			this._trigger("open", event, this._uiHash());
		}
	},
	close: function(event, retainFocus){
		if(this.newelement.is('.ui-state-active')){
			this.newelement
				.removeClass('ui-state-active');
			this.list
				.attr('aria-hidden', true)
				.removeClass(this.widgetBaseClass+'-open');
			if(this.options.style == "dropdown"){ this.newelement.removeClass('ui-corner-top').addClass('ui-corner-all'); }
			if(retainFocus){this.newelement[0].focus();}	
			this._trigger("close", event, this._uiHash());
		}
	},
	change: function(event) {
		this.element.trigger('change');
		this._trigger("change", event, this._uiHash());
	},
	select: function(event) {
		this._trigger("select", event, this._uiHash());
	},
	_closeOthers: function(event){
		jQuery('.'+ this.widgetBaseClass +'.ui-state-active').not(this.newelement).each(function(){
			jQuery(this).data('selectelement').radiomenu('close',event);
		});
		jQuery('.'+ this.widgetBaseClass +'.ui-state-hover').trigger('mouseout');
	},
	_toggle: function(event,retainFocus){
		if(this.list.is('.'+ this.widgetBaseClass +'-open')){ this.close(event,retainFocus); }
		else { this.open(event); }
	},
	_formatText: function(text){
		return this.options.format ? this.options.format(text) : text;
	},
	_selectedIndex: function(){
		var pos = 0;
		this.element.find('input[type=radio]').each(function(key, obj) {
			if (jQuery(obj).is(':checked')) {
				pos = key;
				return;
			}
		});
		return pos;
	},
	_selectedOptionLi: function(){
		return this._optionLis.eq(this._selectedIndex());
	},
	_focusedOptionLi: function(){
		return this.list.find('.'+ this.widgetBaseClass +'-item-focus');
	},
	_moveSelection: function(amt){
		var currIndex = parseInt(this._selectedOptionLi().data('index'), 10);
		var newIndex = currIndex + amt;
		return this._optionLis.eq(newIndex).trigger('mouseup');
	},
	_moveFocus: function(amt){
		if(!isNaN(amt)){
			var currIndex = parseInt(this._focusedOptionLi().data('index'), 10);
			var newIndex = currIndex + amt;
		}
		else { var newIndex = parseInt(this._optionLis.filter(amt).data('index'), 10); }
		
		if(newIndex < 0){ newIndex = 0; }
		if(newIndex > this._optionLis.size()-1){
			newIndex =  this._optionLis.size()-1;
		}
		var activeID = this.widgetBaseClass + '-item-' + Math.round(Math.random() * 1000);
		
		this._focusedOptionLi().find('a:eq(0)').attr('id','');
		this._optionLis.eq(newIndex).find('a:eq(0)').attr('id',activeID)[0].focus();
		this.list.attr('aria-activedescendant', activeID);
	},
	_scrollPage: function(direction){
		var numPerPage = Math.floor(this.list.outerHeight() / this.list.find('li:first').outerHeight());
		numPerPage = (direction == 'up') ? -numPerPage : numPerPage;
		this._moveFocus(numPerPage);
	},
	_setData: function(key, value) {
		this.options[key] = value;
		if (key == 'disabled') {
			this.close();
			this.element
				.add(this.newelement)
				.add(this.list)
					[value ? 'addClass' : 'removeClass'](
						this.widgetBaseClass + '-disabled' + ' ' +
						this.namespace + '-state-disabled')
					.attr("aria-disabled", value);
		}
	},
	value: function(newValue) {
		if (arguments.length) {
			this.element.find('.widget-radio-menu-item input[type=radio]:checked').removeAttr('checked');
			var radio = this.element.find('.widget-radio-menu-item').eq(newValue).find('input[type=radio]');
			radio.attr('checked', true);
			
			this._refreshValue();
			this._refreshPosition();
		}
		return newValue;
	},
	_refreshValue: function() {
		var activeClass = (this.options.style == "popup") ? " ui-state-active" : "";
		var activeID = this.widgetBaseClass + '-item-' + Math.round(Math.random() * 1000);
		//deselect previous
		this.list
			.find('.'+ this.widgetBaseClass +'-item-selected')
			.removeClass(this.widgetBaseClass + "-item-selected" + activeClass)
			.find('a')
			.attr('aria-selected', 'false')
			.attr('id', '');
		//select new
		this._selectedOptionLi()
			.addClass(this.widgetBaseClass + "-item-selected"+activeClass)
			.find('a')
			.attr('aria-selected', 'true')
			.attr('id', activeID);
			
		//toggle any class brought in from option
		var currentOptionClasses = this.newelement.data('optionClasses') ? this.newelement.data('optionClasses') : "";
		var newOptionClasses = this._selectedOptionLi().data('optionClasses') ? this._selectedOptionLi().data('optionClasses') : "";
		var status = this.newelement
			.removeClass(currentOptionClasses)
			.data('optionClasses', newOptionClasses)
			.addClass( newOptionClasses )
			.find('.'+this.widgetBaseClass+'-status');
		
		status.empty();
		status.append(this._visibleitem());
			
		this.list.attr('aria-activedescendant', activeID)
	},
	_refreshPosition: function(){	
		//set left value
		this.list.css('left', this.newelement.offset().left);
		
		//set top value
		var menuTop = this.newelement.offset().top;
		var scrolledAmt = this.list[0].scrollTop;
		this.list.find('li:lt('+this._selectedIndex()+')').each(function(){
			scrolledAmt -= jQuery(this).outerHeight();
		});
		
		if(this.newelement.is('.'+this.widgetBaseClass+'-popup')){
			menuTop+=scrolledAmt; 
			this.list.css('top', menuTop); 
		}	
		else { 
			menuTop += this.newelement.height();
			this.list.css('top', menuTop); 
		}
	}
});

jQuery.extend(jQuery.widgets.radiomenu, {
	getter: "value",
	version: "@VERSION",
	eventPrefix: "radiomenu"
});

})(jQuery);



function widget_radioMenuInit(domNode)
{
	jQuery(domNode).find('.widget-radio-menu').not('.widget-init-done').each(function() {
		jQuery(this).addClass('widget-init-done');

		jQuery(this).radiomenu(
		{
			transferClasses: true,
			style: 'dropdown',  
			handleWidth: 26, 
			maxHeight: 350
		});
	});
}


window.bab.addInitFunction(widget_radioMenuInit);
