



window.babAddonWidgets.urlLineEditEvent = function() {
	
	
	var enable = function(input) {
		
		input.addClass('widget-urllineedit-valid');
		input.removeClass('widget-urllineedit-invalid');
	}
	
	var disable = function(input) {
		
		input.removeClass('widget-urllineedit-valid');
		input.addClass('widget-urllineedit-invalid');
	}

	
	
	
	var input = jQuery(this);
	
	if ('' == input.val())
	{
		enable(input);
		return;
	}

	var arr = input.val().match(/(^[a-zA-Z]+):\/\//);
	
	
	
	if(arr == null) {
		disable(input);
		return;
	}
	
	if (input.val().match(/\s/))
	{
		disable(input);
		return;
	}
	
	var scheme = arr[1];
	
	var allowed = window.babAddonWidgets.getMetadata(input.attr('id')).allowedSchemes;
	
	for (var i=0; i<allowed.length; i++)
	{
		if (allowed[i] == scheme)
		{
			enable(input);
			return;
		}
	}
	
	disable(input);
	return;
}



function widget_urlLineEditInit(domNode) {
	
	jQuery(domNode).find('.widget-urllineedit').each(function() {
		var input = jQuery(this);
		
		if (input.data('widgetevent'))
		{
			return;
		}
		
		input.data('widgetevent', true);
		
		
		// lock form validation if not a valid url address
		
		input.blur(window.babAddonWidgets.urlLineEditEvent);
		input.keyup(window.babAddonWidgets.urlLineEditEvent);
		
		input.blur();
		
		
		// form event
		
		if (form = input.closest('form'))
		{
			form.submit(function() {
				var input = jQuery(this).find('.widget-urllineedit-invalid')[0];
				
				if (input)
				{
					input.focus();
					var message = window.babAddonWidgets.getMetadata(input.id).submitMessage;
					
					if (window.babAddonWidgets.validatemandatory) {
						alert(message);
						return false;
					}
					
					
					if (window.babAddonWidgets.validate)
					{
						return confirm(message);
					}
					
					
				}
				
				return true;
			});
		}
		
	});

}



window.bab.addInitFunction(widget_urlLineEditInit);

