/**
 *      @file    1024_DH_PARAMS.h
 *      @version 5a72845 (tag: 4-0-1-open)
 *
 *      Summary.
 */
/******************************************************************************/
/*
    In-Memory version of the PEM file 1024_DH_PARAMS.pem

    PKCS#3 DH Parameters: (1024 bit)
        prime:
            00:97:f6:42:61:ca:b5:05:dd:28:28:e1:3f:1d:68:
            b6:d3:db:d0:f3:13:04:7f:40:e8:56:da:58:cb:13:
            b8:a1:bf:2b:78:3a:4c:6d:59:d5:f9:2a:fc:6c:ff:
            3d:69:3f:78:b2:3d:4f:31:60:a9:50:2e:3e:fa:f7:
            ab:5e:1a:d5:a6:5e:55:43:13:82:8d:a8:3b:9f:f2:
            d9:41:de:e9:56:89:fa:da:ea:09:36:ad:df:19:71:
            fe:63:5b:20:af:47:03:64:60:3c:2d:e0:59:f5:4b:
            65:0a:d8:fa:0c:f7:01:21:c7:47:99:d7:58:71:32:
            be:9b:99:9b:b9:b7:87:e8:ab
        generator: 2 (0x2)
   -----BEGIN DH PARAMETERS-----
   MIGHAoGBAJf2QmHKtQXdKCjhPx1ottPb0PMTBH9A6FbaWMsTuKG/K3g6TG1Z1fkq
   /Gz/PWk/eLI9TzFgqVAuPvr3q14a1aZeVUMTgo2oO5/y2UHe6VaJ+trqCTat3xlx
   /mNbIK9HA2RgPC3gWfVLZQrY+gz3ASHHR5nXWHEyvpuZm7m3h+irAgEC
   -----END DH PARAMETERS-----
 */
#define DHPARAM1024_SIZE    138
static const unsigned char DHPARAM1024[DHPARAM1024_SIZE] =
    "\x30\x81\x87\x02\x81\x81\x00\x97\xf6\x42\x61\xca\xb5\x05\xdd\x28"
    "\x28\xe1\x3f\x1d\x68\xb6\xd3\xdb\xd0\xf3\x13\x04\x7f\x40\xe8\x56"
    "\xda\x58\xcb\x13\xb8\xa1\xbf\x2b\x78\x3a\x4c\x6d\x59\xd5\xf9\x2a"
    "\xfc\x6c\xff\x3d\x69\x3f\x78\xb2\x3d\x4f\x31\x60\xa9\x50\x2e\x3e"
    "\xfa\xf7\xab\x5e\x1a\xd5\xa6\x5e\x55\x43\x13\x82\x8d\xa8\x3b\x9f"
    "\xf2\xd9\x41\xde\xe9\x56\x89\xfa\xda\xea\x09\x36\xad\xdf\x19\x71"
    "\xfe\x63\x5b\x20\xaf\x47\x03\x64\x60\x3c\x2d\xe0\x59\xf5\x4b\x65"
    "\x0a\xd8\xfa\x0c\xf7\x01\x21\xc7\x47\x99\xd7\x58\x71\x32\xbe\x9b"
    "\x99\x9b\xb9\xb7\x87\xe8\xab\x02\x01\x02";

