/**
 *      @file    1536_DH_PARAMS.h
 *      @version 5a72845 (tag: 4-0-1-open)
 *
 *      Summary.
 */
/******************************************************************************/
/*
    In-Memory version of the PEM file 1536_DH_PARAMS.pem

    DH Parameters: (1536 bit)
        prime:
            00:d0:4f:9f:b8:98:7f:ce:d3:80:98:2b:94:57:2f:
            c2:37:7c:50:94:40:f3:8b:e2:c1:8c:e1:30:55:f8:
            00:55:e6:e0:50:69:52:77:42:60:3f:32:d6:11:90:
            15:20:c9:9b:24:59:e0:9e:ad:e4:5f:c1:c1:5e:83:
            6c:49:f2:8e:6e:a4:fc:03:03:8d:c0:9d:ea:83:98:
            04:5e:61:2b:67:03:b7:8a:86:bb:01:16:67:83:8d:
            bf:d9:2a:09:19:02:a7:f9:b3:d9:c7:57:0f:30:8f:
            1e:8a:7f:38:fd:5d:62:9a:fe:d3:07:7e:1f:7f:6b:
            df:ea:d6:c4:34:0f:39:ba:62:a8:1f:f1:42:a2:b4:
            cf:70:e3:27:a8:05:9a:a2:ed:07:97:31:1c:9f:1b:
            ee:2c:bf:e6:31:67:61:da:53:51:97:d3:e4:82:86:
            0c:72:a7:df:60:94:5d:00:d8:27:88:f7:12:34:e6:
            37:69:98:f5:59:c1:5a:6d:53:ea:c3:f4:53
        generator: 2 (0x2)
    -----BEGIN DH PARAMETERS-----
    MIHHAoHBANBPn7iYf87TgJgrlFcvwjd8UJRA84viwYzhMFX4AFXm4FBpUndCYD8y
    1hGQFSDJmyRZ4J6t5F/BwV6DbEnyjm6k/AMDjcCd6oOYBF5hK2cDt4qGuwEWZ4ON
    v9kqCRkCp/mz2cdXDzCPHop/OP1dYpr+0wd+H39r3+rWxDQPObpiqB/xQqK0z3Dj
    J6gFmqLtB5cxHJ8b7iy/5jFnYdpTUZfT5IKGDHKn32CUXQDYJ4j3EjTmN2mY9VnB
    Wm1T6sP0UwIBAg==
    -----END DH PARAMETERS-----
 */
#define DHPARAM1536_SIZE    202
static const unsigned char DHPARAM1536[DHPARAM1536_SIZE] = {
  0x30, 0x81, 0xc7, 0x02, 0x81, 0xc1, 0x00, 0xd0, 0x4f, 0x9f, 0xb8, 0x98,
  0x7f, 0xce, 0xd3, 0x80, 0x98, 0x2b, 0x94, 0x57, 0x2f, 0xc2, 0x37, 0x7c,
  0x50, 0x94, 0x40, 0xf3, 0x8b, 0xe2, 0xc1, 0x8c, 0xe1, 0x30, 0x55, 0xf8,
  0x00, 0x55, 0xe6, 0xe0, 0x50, 0x69, 0x52, 0x77, 0x42, 0x60, 0x3f, 0x32,
  0xd6, 0x11, 0x90, 0x15, 0x20, 0xc9, 0x9b, 0x24, 0x59, 0xe0, 0x9e, 0xad,
  0xe4, 0x5f, 0xc1, 0xc1, 0x5e, 0x83, 0x6c, 0x49, 0xf2, 0x8e, 0x6e, 0xa4,
  0xfc, 0x03, 0x03, 0x8d, 0xc0, 0x9d, 0xea, 0x83, 0x98, 0x04, 0x5e, 0x61,
  0x2b, 0x67, 0x03, 0xb7, 0x8a, 0x86, 0xbb, 0x01, 0x16, 0x67, 0x83, 0x8d,
  0xbf, 0xd9, 0x2a, 0x09, 0x19, 0x02, 0xa7, 0xf9, 0xb3, 0xd9, 0xc7, 0x57,
  0x0f, 0x30, 0x8f, 0x1e, 0x8a, 0x7f, 0x38, 0xfd, 0x5d, 0x62, 0x9a, 0xfe,
  0xd3, 0x07, 0x7e, 0x1f, 0x7f, 0x6b, 0xdf, 0xea, 0xd6, 0xc4, 0x34, 0x0f,
  0x39, 0xba, 0x62, 0xa8, 0x1f, 0xf1, 0x42, 0xa2, 0xb4, 0xcf, 0x70, 0xe3,
  0x27, 0xa8, 0x05, 0x9a, 0xa2, 0xed, 0x07, 0x97, 0x31, 0x1c, 0x9f, 0x1b,
  0xee, 0x2c, 0xbf, 0xe6, 0x31, 0x67, 0x61, 0xda, 0x53, 0x51, 0x97, 0xd3,
  0xe4, 0x82, 0x86, 0x0c, 0x72, 0xa7, 0xdf, 0x60, 0x94, 0x5d, 0x00, 0xd8,
  0x27, 0x88, 0xf7, 0x12, 0x34, 0xe6, 0x37, 0x69, 0x98, 0xf5, 0x59, 0xc1,
  0x5a, 0x6d, 0x53, 0xea, 0xc3, 0xf4, 0x53, 0x02, 0x01, 0x02
};

