<?php
/**
 * User mailing list
 * 
 * A tool to send e-mails to all registered users who have provided an e-mail address.
 * 
 * @package admin
 */

define('OFFSET_PATH', 3);
chdir(dirname(dirname(__FILE__)));

require_once(dirname(dirname(__FILE__)).'/admin-functions.php');
require_once(dirname(dirname(__FILE__)).'/admin-globals.php');

if(getOption('zp_plugin_zenphoto_sendmail')) {
	require_once(dirname(dirname(__FILE__)).'/'.PLUGIN_FOLDER.'/zenphoto_sendmail.php');
} else if(getOption('zp_plugin_PHPMailer')) {
	require_once(dirname(dirname(__FILE__)).'/'.PLUGIN_FOLDER.'/PHPMailer.php');
}
$button_text = gettext('User mailing list');
$button_hint = gettext('A tool to send e-mails to all registered users who have provided an e-mail address.');
$button_icon = 'images/icon_mail.gif';
$button_rights = ADMIN_RIGHTS;

if (getOption('zenphoto_release') != ZENPHOTO_RELEASE) {
	header("Location: " . FULLWEBPATH . "/" . ZENFOLDER . "/setup.php");
	exit();
}
if (!zp_loggedin(OVERVIEW_RIGHTS)) { // prevent nefarious access to this page.
	header('Location: ' . FULLWEBPATH . '/' . ZENFOLDER . '/admin.php?from=' . currentRelativeURL(__FILE__));
	exit();
}

$gallery = new Gallery();
$webpath = WEBPATH.'/'.ZENFOLDER.'/';
$admins = $_zp_authority->getAdministrators();
printAdminHeader();
?>
</head>
<body>
<?php printLogoAndLinks(); ?>
<div id="main">
<?php printTabs('home'); ?>
<div id="content">
<h1><?php echo gettext('User mailing list'); ?></h1>
<p><?php echo gettext("A tool to send e-mails to all registered users who have provided an e-mail address. There is always a copy sent to the current admin and all e-mails are sent as <em>blind copies</em>."); ?></p>
<?php
if (!zp_has_filter('sendmail')) {
	$disabled = ' disabled="disabled"';
	?>
	<p class="notebox">
	<?php
	echo gettext("<strong>Note: </strong>No <em>sendmail</em> filter is registered. You must activate and configure a mailer plugin."); 	
	?>
	</p>
	<?php
} else {
	$disabled = '';
	}

if(isset($_GET['sendmail'])) {
	//form handling stuff to add...
	$subject = NULL;
	$message = NULL;
	if(isset($_POST['subject'])) {
		$subject = sanitize($_POST['subject']);
	}
	if(isset($_POST['message'])) {
		$message = sanitize($_POST['message']);
	}
	$cc_addresses = NULL;
	$count = '';
	$admincount = count($admins);
	foreach($admins as $admin) {
		$count++;
		if (isset($_POST["admin_".$admin['id']])) {
			$cc_addresses .= $admin['email'].", ";
		}
	}
	$cc_addresses = substr($cc_addresses,0,-2);
	$currentadminmail = $_zp_current_admin_obj->getEmail();
	if(!empty($currentadminmail)) {
		$cc_addresses .= ', '.$currentadminmail;
	} 
	$err_msg = zp_mail($subject, $message, null, $cc_addresses);	
	if($err_msg) {
		echo '<p class="errorbox">'.$err_msg.'</p>';
	} else {
		echo '<p class="messagebox">'.gettext('Mail sent.').'</p>';
		?>
	<h3><strong><?php echo gettext('Subject:'); ?> </strong><?php echo $subject; ?></h3>
	<p><strong><?php echo gettext('To:'); ?> </strong><?php echo $cc_addresses; ?></p>
	<strong><?php echo gettext('Message:'); ?> </strong><?php echo $message; ?>
	<p class="buttons"><a href="user_mailing_list.php" title="<?php echo gettext('Send another mail'); ?>"><?php echo gettext('Send another mail'); ?></a></p>
	<?php
	}
} else {
?>
<h2><?php echo gettext('Please enter the message you want to send.'); ?></h2>
<form id="massmail" action="?sendmail" method="post" accept-charset="UTF-8">
	<table>
		<tr>
				<td valign="top">
				<labelfor="subject"><?php echo gettext('Subject:'); ?></label><br />
				<input type="text" id="subject" name="subject" value="" size="70"<?php echo $disabled; ?> /><br /><br />
				<label for="message"><?php echo gettext('Message:'); ?></label><br />
				<textarea id="message" name="message" value="" cols="68" rows="10"<?php echo $disabled; ?> ></textarea>
				</td>
				<td valign="top" align="left">
				<?php echo gettext('Select users:'); ?>
				<ul class="customchecklist" style="height: 205px; width: 30em;">
				<?php 
				$currentadminuser = $_zp_current_admin_obj->getUser();
				foreach($admins as $admin) {
					if(!empty($admin['email']) && $currentadminuser != $admin['user']) {
						?>
						<li>
							<label for="admin_<?php echo $admin['id']; ?>">
								<input name="admin_<?php echo $admin['id']; ?>" id="admin_<?php echo $admin['id']; ?>" type="checkbox" value="<?php  echo $admin['email']; ?>" checked="checked"  <?php echo $disabled; ?>/>
								<?php
								echo $admin['user']." (";
								if (!empty($admin['name'])) {
									echo $admin['name']." - ";
								}
								echo $admin['email'].")";
								?>
							</label>
						</li>
						<?php
					}
				}
				?>
				</ul>
				<br />
				</td>
		</tr>
</table>
<p class="buttons">
		<button class="submitbutton" type="submit"
		title="<?php echo gettext("Send mail"); ?>"<?php echo $disabled; ?> ><img
		src="../images/pass.png" alt="" /><strong><?php echo gettext("Send mail"); ?></strong></button>
</p>
<p class="buttons">
<button class="submitbutton" type="reset"
		title="<?php echo gettext("Reset"); ?>"><img src="../images/reset.png"
		alt="" /><strong><?php echo gettext("Reset"); ?></strong></button>
</p>
<br style="clear: both" />
</form>
<?php } ?>
</div><!-- content -->
</div><!-- main -->
<?php printAdminFooter(); ?>
</body>
</html>