# phpMyAdmin MySQL-Dump

# Host: localhost

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_backendmenu`
#

DROP TABLE IF EXISTS cms_backendmenu;
CREATE TABLE cms_backendmenu (
  idbackendmenu int(11) NOT NULL auto_increment,
  parent int(11) NOT NULL default '0',
  idclient int(11) NOT NULL default '0',
  sortindex int(11) default NULL,
  entry_langstring varchar(63) NOT NULL default '',
  entry_url varchar(255) NOT NULL default '',
  url_target enum('single','frame') NOT NULL default 'single',
  entry_validate varchar(255) default NULL,
  PRIMARY KEY  (idbackendmenu),
  KEY idclient (idclient)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_backendmenu`
#

INSERT INTO cms_backendmenu VALUES (1, 0, 0, 10, 'nav_1_0', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (2, 0, 0, 20, 'nav_2_0', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (3, 0, 0, 30, 'nav_3_0', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (4, 0, 0, 40, 'nav_4_0', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (5, 0, 0, 40, 'empty_dummy', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (6, 0, 0, 40, 'empty_dummy', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (7, 0, 0, 40, 'empty_dummy', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (8, 0, 0, 40, 'empty_dummy', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (9, 0, 0, 40, 'empty_dummy', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (10, 0, 0, 40, 'empty_dummy', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (11, 0, 0, 40, 'empty_dummy', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (12, 0, 0, 40, 'empty_dummy', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (13, 0, 0, 40, 'empty_dummy', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (14, 0, 0, 40, 'empty_dummy', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (15, 0, 0, 40, 'empty_dummy', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (16, 0, 0, 40, 'empty_dummy', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (17, 0, 0, 40, 'empty_dummy', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (18, 0, 0, 40, 'empty_dummy', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (19, 0, 0, 40, 'empty_dummy', 'root', 'single', 'root');
INSERT INTO cms_backendmenu VALUES (20, 1, 0, 10, 'nav_1_1', 'main.php?area=con', 'single', '$perm->have_perm(\'area_con\')');
INSERT INTO cms_backendmenu VALUES (21, 1, 0, 32, 'nav_1_2', 'main.php?area=upl', 'single', '$perm->have_perm(\'area_upl\')');
INSERT INTO cms_backendmenu VALUES (22, 2, 0, 10, 'nav_2_1', 'main.php?area=lay&idclient=$client', 'single', '$perm->have_perm(\'area_lay\')');
INSERT INTO cms_backendmenu VALUES (23, 2, 0, 20, 'nav_2_2', 'main.php?area=css&idclient=$client', 'single', '$perm->have_perm(\'area_css\')');
INSERT INTO cms_backendmenu VALUES (24, 2, 0, 40, 'nav_2_4', 'main.php?area=mod&idclient=$client', 'single', '$perm->have_perm(\'area_mod\')');
INSERT INTO cms_backendmenu VALUES (25, 2, 0, 30, 'nav_2_3', 'main.php?area=js&idclient=$client', 'single', '$perm->have_perm(\'area_js\')');
INSERT INTO cms_backendmenu VALUES (26, 2, 0, 50, 'nav_2_5', 'main.php?area=tpl', 'single', '$perm->have_perm(\'area_tpl\')');
INSERT INTO cms_backendmenu VALUES (27, 3, 0, 10, 'nav_3_1', 'main.php?area=user', 'single', '$perm->have_perm(\'area_user\')');
INSERT INTO cms_backendmenu VALUES (28, 3, 0, 20, 'nav_3_2', 'main.php?area=group', 'single', '$perm->have_perm(\'area_group\')');
INSERT INTO cms_backendmenu VALUES (29, 3, 0, 30, 'nav_3_3', 'main.php?area=clients', 'single', '$perm->have_perm(\'area_clients\')');
INSERT INTO cms_backendmenu VALUES (30, 3, 0, 40, 'nav_3_4', 'main.php?area=settings', 'single', '$perm->have_perm(\'area_settings\')');
INSERT INTO cms_backendmenu VALUES (31, 3, 0, 50, 'nav_3_5', 'main.php?area=plug&idclient=$client', 'single', '$perm->have_perm(\'area_plug\')');
# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_cat`
#

DROP TABLE IF EXISTS cms_cat;
CREATE TABLE cms_cat (
  idcat int(6) NOT NULL auto_increment,
  parent int(6) NOT NULL default '0',
  rootparent int(6) NOT NULL default '0',
  sortindex int(6) NOT NULL default '1',
  idclient int(6) NOT NULL default '0',
  PRIMARY KEY  (idcat),
  KEY parent (parent),
  KEY rootparent (rootparent),
  KEY sortindex (sortindex),
  KEY idclient (idclient)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_cat`
#

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_cat_expand`
#

DROP TABLE IF EXISTS cms_cat_expand;
CREATE TABLE cms_cat_expand (
  idusers int(6) NOT NULL default '0',
  idcat int(6) NOT NULL default '0'
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_cat_expand`
#

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_cat_lang`
#

DROP TABLE IF EXISTS cms_cat_lang;
CREATE TABLE cms_cat_lang (
  idcatlang int(6) NOT NULL auto_increment,
  idcat int(6) NOT NULL default '0',
  idlang int(6) NOT NULL default '0',
  idtplconf int(6) NOT NULL default '0',
  name varchar(255) NOT NULL default '',
  description text,
  rewrite_use_automatic TINYINT( 1 ) NOT NULL DEFAULT '1',
  rewrite_alias VARCHAR( 255 ) default NULL,
  visible tinyint(1) NOT NULL default '0',
  author int(6) NOT NULL default '0',
  created int(10) NOT NULL default '0',
  lastmodified int(10) NOT NULL default '0',
  PRIMARY KEY  (idcatlang),
  KEY idcat (idcat),
  KEY idlang (idlang),
  KEY rewrite_use_automatic (rewrite_use_automatic),
  KEY rewrite_alias (rewrite_alias),
  KEY idtplconf (idtplconf),
  KEY visible (visible)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_cat_lang`
#

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_cat_side`
#

DROP TABLE IF EXISTS cms_cat_side;
CREATE TABLE cms_cat_side (
  idcatside int(6) NOT NULL auto_increment,
  idcat int(6) NOT NULL default '0',
  idside int(6) NOT NULL default '0',
  sortindex int(6) unsigned NOT NULL,
  is_start tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (idcatside),
  KEY is_start (is_start),
  KEY idcat (idcat),
  KEY idside (idside),
  KEY sortindex (sortindex)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_cat_side`
#

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_clients`
#

DROP TABLE IF EXISTS cms_clients;
CREATE TABLE cms_clients (
  idclient int(6) NOT NULL auto_increment,
  name varchar(255) NOT NULL default '',
  description varchar(255) default NULL,
  author int(6) NOT NULL default '0',
  created int(10) NOT NULL default '0',
  lastmodified int(10) NOT NULL default '0',
  PRIMARY KEY  (idclient)
) ENGINE=MyISAM;
#
# Daten fr Tabelle `cms_clients`
#

INSERT INTO cms_clients VALUES (1, '1. Projekt', NULL, 1, 0, 0);
# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_clients_lang`
#

DROP TABLE IF EXISTS cms_clients_lang;
CREATE TABLE cms_clients_lang (
  idclientslang int(6) NOT NULL auto_increment,
  idclient int(6) NOT NULL default '0',
  idlang int(6) NOT NULL default '0',
  author int(6) NOT NULL default '0',
  created int(10) NOT NULL default '0',
  lastmodified int(10) NOT NULL default '0',
  PRIMARY KEY  (idclientslang),
  KEY idclient (idclient),
  KEY idlang (idlang)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_clients_lang`
#

INSERT INTO cms_clients_lang VALUES (1, 1, 1, 1, 0, 0);
# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_code`
#

DROP TABLE IF EXISTS cms_code;
CREATE TABLE cms_code (
  idcode int(6) NOT NULL auto_increment,
  idlang int(6) NOT NULL default '0',
  idcatside int(6) NOT NULL default '0',
  code mediumtext NOT NULL,
  changed tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (idcode),
  KEY idlang (idlang),
  KEY idcatside (idcatside)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_code`
#

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_container`
#

DROP TABLE IF EXISTS cms_container;
CREATE TABLE cms_container (
  idcontainer int(6) NOT NULL auto_increment,
  idtpl int(6) NOT NULL default '0',
  container int(6) NOT NULL default '0',
  idmod int(6) NOT NULL default '0',
  PRIMARY KEY  (idcontainer),
  KEY container (container),
  KEY idmod (idmod)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_container`
#

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_container_conf`
#

DROP TABLE IF EXISTS cms_container_conf;
CREATE TABLE cms_container_conf (
  idcontainerconf int(6) NOT NULL auto_increment,
  idtplconf int(6) NOT NULL default '0',
  idcontainer int(6) NOT NULL default '0',
  config text NOT NULL,
  view int(6) NOT NULL default '0',
  edit int(6) NOT NULL default '0',
  PRIMARY KEY  (idcontainerconf),
  KEY idtplconf (idtplconf),
  KEY idcontainer (idcontainer)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_container_conf`
#

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_content`
#

DROP TABLE IF EXISTS cms_content;
CREATE TABLE cms_content (
  idcontent int(10) NOT NULL auto_increment,
  idsidelang int(6) NOT NULL default '0',
  container int(6) NOT NULL default '0',
  number int(6) NOT NULL default '0',
  idtype int(11) default NULL,
  typenumber int(10) NOT NULL default '0',
  value text NOT NULL,
  online tinyint(1) NOT NULL default '1',
  version int(6) NOT NULL default '0',
  author int(6) NOT NULL default '0',
  created int(10) NOT NULL default '0',
  lastmodified int(10) NOT NULL default '0',
  PRIMARY KEY  (idcontent),
  KEY idsidelang (idsidelang),
  KEY container (container),
  KEY number (number),
  KEY typenumber (typenumber),
  FULLTEXT KEY value (value)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_content`
#

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_content_external`
#

DROP TABLE IF EXISTS cms_content_external;
CREATE TABLE cms_content_external (
  idcontent int(10) NOT NULL auto_increment,
  idsidelang int(6) NOT NULL default '0',
  container int(6) NOT NULL default '0',
  number int(6) NOT NULL default '0',
  idtype varchar(255) NOT NULL default '',
  typenumber int(10) NOT NULL default '0',
  value text NOT NULL,
  online tinyint(1) NOT NULL default '1',
  version int(6) NOT NULL default '0',
  author int(6) NOT NULL default '0',
  created int(10) NOT NULL default '0',
  lastmodified int(10) NOT NULL default '0',
  PRIMARY KEY  (idcontent),
  KEY idsidelang (idsidelang),
  KEY container (container),
  KEY number (number),
  KEY typenumber (typenumber),
  FULLTEXT KEY value (value)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_content_external`
#

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_css`
#

DROP TABLE IF EXISTS cms_css;
CREATE TABLE cms_css (
  idcss int(6) NOT NULL auto_increment,
  idclient int(6) NOT NULL default '0',
  type varchar(8) NOT NULL default '0',
  name varchar(255) NOT NULL default '',
  description varchar(255) NOT NULL default '',
  styles text NOT NULL,
  status int(6) NOT NULL default '0',
  warning text,
  author int(6) NOT NULL default '0',
  lastmodified timestamp NOT NULL,
  created timestamp NOT NULL,
  PRIMARY KEY  (idcss)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_css`
#

INSERT INTO cms_css VALUES (1, 0, '', 'a:active', '', 'color: #000000; ', 1, '', 1, 20030310204808, 20030310204808);
INSERT INTO cms_css VALUES (2, 0, '', 'a:hover', '', 'color: #000000; text-decoration: underline; ', 1, '', 1, 20030310204808, 20030310204808);
INSERT INTO cms_css VALUES (3, 0, '', 'a:link', '', 'color: #777777; ', 1, '', 1, 20030310204808, 20030310204808);
INSERT INTO cms_css VALUES (4, 0, '', 'body', '', 'background-color: #ffffff; color: #000000; ', 1, '', 1, 20030310204811, 20030310204811);
INSERT INTO cms_css VALUES (5, 0, '.', 'Arial-12px', '', 'font-family: Arial, Helvetica, sans-serif; font-size: 12px; ', 1, '', 1, 20030310204809, 20030310204809);
INSERT INTO cms_css VALUES (6, 0, '.', 'Navigation-Ordner', '', 'font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 12px; font-weight: bold; text-decoration: none; color: #FFFFFF;', 1, '', 1, 20030516003228, 20030516002644);
INSERT INTO cms_css VALUES (7, 0, '.', 'Navigation-Ordner:active', '', 'font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 12px; font-weight: bold; text-decoration: none; color: #FFFFFF;', 1, '', 1, 20030516003242, 20030516002825);
INSERT INTO cms_css VALUES (8, 0, '.', 'Navigation-Ordner:hover', '', 'font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 12px; font-weight: bold; text-decoration: none; color: #FFFFFF;', 1, '', 1, 20030516003254, 20030516002925);
INSERT INTO cms_css VALUES (9, 0, '.', 'Navigation-Ordner:link', '', 'font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 12px; font-weight: bold; text-decoration: none; color: #FFFFFF;', 1, '', 1, 20030516003306, 20030516002949);
INSERT INTO cms_css VALUES (10, 0, '.', 'Navigation-Seiten', '', 'font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 12px; text-decoration: none; color: #000000;', 1, '', 1, 20030516003449, 20030516003449);
INSERT INTO cms_css VALUES (11, 0, '.', 'Navigation-Seiten:active', '', 'font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 12px; text-decoration: none; color: #000000;', 1, '', 1, 20030516003516, 20030516003516);
INSERT INTO cms_css VALUES (12, 0, '.', 'Navigation-Seiten:hover', '', 'font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 12px; text-decoration: none; color: #000000;', 1, '', 1, 20030516003532, 20030516003532);
INSERT INTO cms_css VALUES (13, 0, '.', 'Navigation-Seiten:link', '', 'font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 12px; text-decoration: none; color: #000000;', 1, '', 1, 20030516003548, 20030516003548);
# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_css_upl`
#

DROP TABLE IF EXISTS cms_css_upl;
CREATE TABLE cms_css_upl (
  idcssupl int(6) NOT NULL auto_increment,
  idcss int(6) NOT NULL default '0',
  idupl int(6) NOT NULL default '0',
  intSort int(4) NOT NULL default '0',
  PRIMARY KEY  (idcssupl)
) ENGINE=MyISAM;
#
# Daten fr Tabelle `cms_css_upl`
#

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_directory`
#

DROP TABLE IF EXISTS cms_directory;
CREATE TABLE cms_directory (
  iddirectory int(6) NOT NULL auto_increment,
  idclient int(6) NOT NULL default '0',
  name varchar(255) NOT NULL default '',
  dirname varchar(255) NOT NULL default '',
  description varchar(255) NOT NULL default '',
  parentid int(6) NOT NULL default '0',
  status int(6) NOT NULL default '0',
  author int(6) NOT NULL default '0',
  lastmodified timestamp NOT NULL,
  created timestamp NOT NULL,
  PRIMARY KEY  (iddirectory)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_directory`
#

INSERT INTO cms_directory VALUES (1, 1, 'css', 'cms/css/', '', 0, 4, 1, 20030521025421, 20030521025421);
INSERT INTO cms_directory VALUES (2, 1, 'js', 'cms/js/', '', 0, 4, 1, 20030521025421, 20030521025421);
# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_filetype`
#

DROP TABLE IF EXISTS cms_filetype;
CREATE TABLE cms_filetype (
  idfiletype int(6) NOT NULL auto_increment,
  filetype varchar(20) NOT NULL default '',
  description varchar(255) NOT NULL default '',
  filetypepict varchar(255) NOT NULL default 'unknown.gif',
  status int(6) NOT NULL default '0',
  filetypegroup varchar(20) NOT NULL default '',
  mimetype varchar(60) NOT NULL default 'x-cms/x-unknown',
  addinfo_names varchar(100) NOT NULL default '',
  author int(6) NOT NULL default '0',
  lastmodified timestamp NOT NULL,
  created timestamp NOT NULL,
  PRIMARY KEY  (idfiletype)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_filetype`
#

INSERT INTO cms_filetype VALUES (1, 'css', 'Cascading Style Sheet', 'css.gif', 1, 'Style', 'text/css', '', 1, 20030610005436, 20030305185033);
INSERT INTO cms_filetype VALUES (2, 'js', 'Javascript', 'unknown.gif', 1, 'Script', 'text/javascript', '', 1, 20030610005454, 20030305185136);
INSERT INTO cms_filetype VALUES (3, 'jpg', 'JPEG', 'jpg.gif', 0, 'Bilder', 'image/jpeg', 'width,height', 1, 20030610005505, 20030305185214);
INSERT INTO cms_filetype VALUES (4, 'gif', 'GIF', 'gif.gif', 0, 'Bilder', 'image/gif', 'width,height', 1, 20030610005535, 20030305185237);
INSERT INTO cms_filetype VALUES (5, 'php', 'PHP-Script', 'php.gif', 1, 'Text', 'text/plain', '', 1, 20030609232705, 20030330162104);
INSERT INTO cms_filetype VALUES (6, 'html', 'HTML-Dokument', 'html.gif', 1, 'Text', 'text/html', '', 1, 20030610005521, 20030330162104);
INSERT INTO cms_filetype VALUES (7, 'pdf', 'Acrobat PDF-Dokument', 'pdf.gif', 0, 'Asset', 'application/pdf', '', 1, 20030609234945, 20030330162125);
INSERT INTO cms_filetype VALUES (8, 'ico', 'Icon', 'image.gif', 1, 'Bilder', 'image/vnd.microsoft.icon', '', 1, 20030609232618, 20030330180911);
INSERT INTO cms_filetype VALUES (9, 'txt', 'Textdatei', 'txt.gif', 0, 'Text', 'text/plain', '', 1, 20030610005552, 20030330180911);
INSERT INTO cms_filetype VALUES (10, 'zip', 'ZIP-Archiv', 'zip.gif', 0, 'Asset', 'application/zip', '', 1, 20030610004229, 20030516004100);
INSERT INTO cms_filetype VALUES (11, 'htm', 'HTML-Dokument', 'html.gif', 0, 'Text', 'text/html', '', 1, 20030610005527, 20030519000527);
INSERT INTO cms_filetype VALUES (12, 'png', 'Portable Network Graphic', 'png.gif', 0, 'Bilder', 'image/png', 'width,height', 1, 20030610005605, 20030601003713);
INSERT INTO cms_filetype VALUES (13, 'jpeg', 'JPEG', 'jpg.gif', 0, 'Bilder', 'image/jpeg', 'width,height', 1, 20030610005510, 20030305185214);
INSERT INTO cms_filetype VALUES (14, 'doc', 'Word-Dokument', 'word.gif', 0, 'Text', 'application/msword', '', 1, 20030610004315, 20030610004315);
INSERT INTO cms_filetype VALUES (15, 'xls', 'Excel-Dokument', 'xls.gif', 0, 'Asset', 'application/vnd.ms-excel', '', 1, 20030610004352, 20030610004352);
INSERT INTO cms_filetype VALUES (16, 'vsd', 'Visio-Zeichnung', 'unknown.gif', 0, 'Asset', 'application/vnd.visio', '', 1, 20030610004424, 20030610004424);
INSERT INTO cms_filetype VALUES (17, 'ppt', 'PowerPoint-Prsentation', 'ppt.gif', 0, 'Asset', 'application/vnd.ms-powerpoint', '', 1, 20030610004533, 20030610004533);
# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_groups`
#

DROP TABLE IF EXISTS cms_groups;
CREATE TABLE cms_groups (
  idgroup int(11) NOT NULL auto_increment,
  name varchar(255) NOT NULL default '',
  description text,
  is_sys_admin int(11) NOT NULL default '0',
  is_active int(11) NOT NULL default '0',
  is_deletable tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (idgroup),
  KEY idgroup (idgroup)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_groups`
#

INSERT INTO cms_groups VALUES (1, '--keine--', 'Der User besitzt keine Gruppe', 0, 0, 0);
INSERT INTO cms_groups VALUES (2, 'System- Administrator', 'Diese Gruppe hat Zugriff auf das gesamte System.', 1, 1, 0);
# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_js`
#

DROP TABLE IF EXISTS cms_js;
CREATE TABLE cms_js (
  idjs int(6) NOT NULL auto_increment,
  idupl int(6) NOT NULL default '0',
  idclient int(6) NOT NULL default '0',
  filecontent text NOT NULL,
  status int(6) NOT NULL default '0',
  author int(6) NOT NULL default '0',
  lastmodified timestamp NOT NULL,
  created timestamp NOT NULL,
  KEY idjs (idjs),
  KEY idupl (idupl)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_js`
#
INSERT INTO cms_js VALUES (1, 1, 0, '<!--\r\nfunction new_window(theURL,winName,features,myWidth,myHeight,isCenter) {\r\n  if(window.screen)if(isCenter)if(isCenter == \'true\') {\r\n    var myLeft = (screen.width-myWidth)/2;\r\n    var myTop = (screen.height-myHeight)/2;\r\n    features+=(features!=\'\')?\',\':\'\';\r\n    features+=\',left=\'+myLeft+\',top=\'+myTop;\r\n  }\r\n  window.open(theURL,winName,features+((features!=\'\')?\',\':\'\')+\'width=\'+myWidth+\',height=\'+myHeight);\r\n}\r\n\r\nfunction new_imagepopup(theURL,winName,altName,features,myWidth,myHeight,isCenter) {\r\n  if(window.screen)if(isCenter)if(isCenter == \'true\') {\r\n    var myLeft = (screen.width-myWidth)/2;\r\n    var myTop = (screen.height-myHeight)/2;\r\n    features+=(features!=\'\')?\',\':\'\';\r\n    features+=\',left=\'+myLeft+\',top=\'+myTop;\r\n  }\r\n  imagepopup = window.open(\'\',\'\',features+((features!=\'\')?\',\':\'\')+\'width=\'+myWidth+\',height=\'+myHeight);\r\n  with (imagepopup) {\r\n    \r\n    //document.open();\r\n    //document.write(\'<title>\'+winName+\'</title>\');\r\n    //document.write(\'<meta http-equiv="imagetoolbar" content="no">\');\r\n    //document.write(\'<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" scroll="no">\');\r\n    //document.write(\'<a href="javascript:self.close()">\');\r\n    //document.write(\'<img src="\'+theURL+\'" border="0" alt="\'+altName+\'" title="\'+altName+\'">\');\r\n    //document.write(\'</a></body>\');\r\n    //document.close();\r\n    \r\n    document.open();\r\n        document.write(\'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\');\r\n		document.write(\'<html xmlns="http://www.w3.org/1999/xhtml" lang="de" xml:lang="de">\');\r\n		document.write(\'<head><title>\'+ winName + \'</title>\');\r\n		document.write(\'<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />\');\r\n		document.write(\'<meta http-equiv="ImageToolbar" content="no" />\');\r\n		document.write(\'<meta http-equiv="Language" content="de" />\');\r\n		document.write(\'<style type="text/css"><!--\')\r\n		document.write(\'body,div{margin:0;padding:0;overflow:hidden;}img{border:0 none;margin:0;padding:0;}\')\r\n		document.write(\'--></style></head>\')\r\n		document.write(\'<body><div>\')\r\n		document.write(\'<a href="javascript:self.close()"><img src="\'+theURL+\'" border="0" alt="\'+altName+\'" title="\'+altName+\'"></a>\')\r\n		document.write(\'</div></body></html>\');\r\n    document.close();\r\n  }\r\n}\r\n\r\nfunction newImage(arg) {\r\n  if (document.images) {\r\n    rslt = new Image();\r\n    rslt.src = arg;\r\n    return rslt;\r\n  }\r\n}\r\n\r\nvar preloadFlag = false;\r\nfunction preloadImages() {\r\n  if (document.images) {\r\n    for (var i=0; i<preloadImages.arguments.length; i++) {\r\n      rslt = newImage(preloadImages.arguments[i]);\r\n    }\r\n    preloadFlag = true;\r\n  }\r\n}\r\n\r\nfunction changeImages() {\r\n  if (document.images && (preloadFlag == true)) {\r\n    for (var i=0; i<changeImages.arguments.length; i+=2) {\r\n      document[changeImages.arguments[i]].src = changeImages.arguments[i+1];\r\n    }\r\n  }\r\n}\r\n//-->', 1, 1, 20050421122042, 20050313185333);
INSERT INTO cms_js VALUES (2, 2, 0, '<!--\r\nfunction verifyCompatibleBrowser() {\r\n	this.ver=navigator.appVersion\r\n	this.dom=document.getElementById?1:0\r\n	this.ie5=(this.ver.indexOf("MSIE 5")>-1 && this.dom)?1:0;\r\n	this.ie4=(document.all && !this.dom)?1:0;\r\n	this.ns5=(this.dom && parseInt(this.ver) >= 5) ?1:0;\r\n	this.ns4=(document.layers && !this.dom)?1:0;\r\n	this.bw=(this.ie5 || this.ie4 || this.ns4 || this.ns5)\r\n	return this\r\n}\r\nbw=new verifyCompatibleBrowser()\r\nvar speed=50\r\nvar loop, timer\r\n\r\nfunction ConstructObject(obj,nest) {\r\n	nest=(!nest) ? \'\':\'document.\'+nest+\'.\'\r\n	this.el=bw.dom?document.getElementById(obj):bw.ie4?document.all[obj]:bw.ns4?eval(nest+\'document.\'+obj):0;\r\n	this.css=bw.dom?document.getElementById(obj).style:bw.ie4?document.all[obj].style:bw.ns4?eval(nest+\'document.\'+obj):0;\r\n	this.scrollHeight=bw.ns4?this.css.document.height:this.el.offsetHeight\r\n	this.clipHeight=bw.ns4?this.css.clip.height:this.el.offsetHeight\r\n	this.up=MoveAreaUp;this.down=MoveAreaDown;\r\n	this.MoveArea=MoveArea; this.x; this.y;\r\n	this.obj = obj + "Object"\r\n	eval(this.obj + "=this")\r\n	return this\r\n}\r\n\r\nfunction MoveArea(x,y) {\r\n	this.x=x;this.y=y\r\n	this.css.left=this.x\r\n	this.css.top=this.y\r\n}\r\n\r\nfunction MoveAreaDown(move) {\r\n	if(this.y>-this.scrollHeight+objContainer.clipHeight) {\r\n		this.MoveArea(0,this.y-move)\r\n		if(loop) setTimeout(this.obj+".down("+move+")",speed)\r\n	}\r\n}\r\n\r\nfunction MoveAreaUp(move){\r\n	if(this.y<0){\r\n    this.MoveArea(0,this.y-move)\r\n    if(loop) setTimeout(this.obj+".up("+move+")",speed)\r\n	}\r\n}\r\n\r\nfunction PerformScroll(speed){\r\n	if(initialised){\r\n		loop=true;\r\n		if(speed>0) objScroller.down(speed)\r\n		else objScroller.up(speed)\r\n	}\r\n}\r\n\r\nfunction CeaseScroll() {\r\n	loop=false\r\n	if(timer) clearTimeout(timer)\r\n}\r\n\r\nvar initialised;\r\nfunction InitialiseScrollableArea() {\r\n	objContainer=new ConstructObject(\'divContainer\')\r\n	objScroller=new ConstructObject(\'divContent\',\'divContainer\')\r\n	objScroller.MoveArea(0,0)\r\n	objContainer.css.visibility=\'visible\'\r\n	initialised=true;\r\n}\r\n//-->', 1, 1, 20030310214759, 20030207204900);
INSERT INTO cms_js VALUES (3, 3, 0, '<!--\r\n/****************************************************************************\r\nDHTML library from DHTMLCentral.com\r\n*   Copyright (C) 2001 Thomas Brattli 2001\r\n*   This script was released at DHTMLCentral.com\r\n*   Visit for more great scripts!\r\n*   This may be used and changed freely as long as this msg is intact!\r\n*   We will also appreciate any links you could give us.\r\n*\r\n*   Made by Thomas Brattli 2001\r\n***************************************************************************/\r\n\r\n//Browsercheck (needed) ***************\r\nfunction lib_bwcheck(){\r\n  this.ver=navigator.appVersion\r\n  this.agent=navigator.userAgent\r\n  this.dom=document.getElementById?1:0\r\n  this.opera5=this.agent.indexOf("Opera 5")>-1\r\n  this.ie5=(this.ver.indexOf("MSIE 5")>-1 && this.dom && !this.opera5)?1:0;\r\n  this.ie6=(this.ver.indexOf("MSIE 6")>-1 && this.dom && !this.opera5)?1:0;\r\n  this.ie4=(document.all && !this.dom && !this.opera5)?1:0;\r\n  this.ie=this.ie4||this.ie5||this.ie6\r\n  this.mac=this.agent.indexOf("Mac")>-1\r\n  this.ns6=(this.dom && parseInt(this.ver) >= 5) ?1:0;\r\n  this.ns4=(document.layers && !this.dom)?1:0;\r\n  this.bw=(this.ie6||this.ie5||this.ie4||this.ns4||this.ns6||this.opera5)\r\n  return this\r\n}\r\nbw=new lib_bwcheck() //Browsercheck object\r\n\r\n//Debug function ******************\r\nfunction lib_message(txt){alert(txt); return false}\r\n\r\n//Lib objects  ********************\r\nfunction lib_obj(obj,nest){\r\n  if(!bw.bw) return lib_message(\'Old browser\')\r\n  nest=(!nest) ? "":\'document.\'+nest+\'.\'\r\n  this.evnt=bw.dom? document.getElementById(obj):\r\n    bw.ie4?document.all[obj]:bw.ns4?eval(nest+"document.layers." +obj):0;\r\n  if(!this.evnt) return lib_message(\'The layer does not exist (\'+obj+\')\'\r\n    +\'- \nIf your using Netscape please check the nesting of your tags!\')\r\n  this.css=bw.dom||bw.ie4?this.evnt.style:this.evnt;\r\n  this.ref=bw.dom||bw.ie4?document:this.css.document;\r\n  this.x=parseInt(this.css.left)||this.css.pixelLeft||this.evnt.offsetLeft||0;\r\n  this.y=parseInt(this.css.top)||this.css.pixelTop||this.evnt.offsetTop||0\r\n  this.w=this.evnt.offsetWidth||this.css.clip.width||\r\n    this.ref.width||this.css.pixelWidth||0;\r\n  this.h=this.evnt.offsetHeight||this.css.clip.height||\r\n    this.ref.height||this.css.pixelHeight||0\r\n  this.c=0 //Clip values\r\n  if((bw.dom || bw.ie4) && this.css.clip) {\r\n  this.c=this.css.clip; this.c=this.c.slice(5,this.c.length-1);\r\n  this.c=this.c.split(\' \');\r\n  for(var i=0;i<4;i++){this.c[i]=parseInt(this.c[i])}\r\n  }\r\n  this.ct=this.css.clip.top||this.c[0]||0;\r\n  this.cr=this.css.clip.right||this.c[1]||this.w||0\r\n  this.cb=this.css.clip.bottom||this.c[2]||this.h||0;\r\n  this.cl=this.css.clip.left||this.c[3]||0\r\n  this.obj = obj + "Object"; eval(this.obj + "=this")\r\n  return this\r\n}\r\n\r\n//Moving object to **************\r\nlib_obj.prototype.moveIt = function(x,y){\r\n  this.x=x;this.y=y; this.css.left=x;this.css.top=y\r\n}\r\n\r\n//Moving object by ***************\r\nlib_obj.prototype.moveBy = function(x,y){\r\n  this.css.left=this.x+=x; this.css.top=this.y+=y\r\n}\r\n\r\n//Showing object ************\r\nlib_obj.prototype.showIt = function(){this.css.visibility="visible"}\r\n\r\n//Hiding object **********\r\nlib_obj.prototype.hideIt = function(){this.css.visibility="hidden"}\r\n\r\n//Changing backgroundcolor ***************\r\nlib_obj.prototype.bg = function(color){\r\n	if(bw.opera) this.css.background=color\r\n	else if(bw.dom || bw.ie4) this.css.backgroundColor=color\r\n	else if(bw.ns4) this.css.bgColor=color\r\n}\r\n\r\n//Writing content to object ***\r\nlib_obj.prototype.writeIt = function(text,startHTML,endHTML){\r\n	if(bw.ns4){\r\n    if(!startHTML){startHTML=""; endHTML=""}\r\n	  this.ref.open("text/html");\r\n    this.ref.write(startHTML+text+endHTML);\r\n    this.ref.close()\r\n	}else this.evnt.innerHTML=text\r\n}\r\n\r\n//Clipping object to ******\r\nlib_obj.prototype.clipTo = function(t,r,b,l,setwidth){\r\n  this.ct=t; this.cr=r; this.cb=b; this.cl=l\r\n  if(bw.ns4){\r\n    this.css.clip.top=t;this.css.clip.right=r\r\n    this.css.clip.bottom=b;this.css.clip.left=l\r\n  }else{\r\n    if(t<0)t=0;if(r<0)r=0;if(b<0)b=0;if(b<0)b=0\r\n    this.css.clip="rect("+t+","+r+","+b+","+l+")";\r\n    if(setwidth){this.css.pixelWidth=this.css.width=r;\r\n    this.css.pixelHeight=this.css.height=b}\r\n  }\r\n}\r\n\r\n//Clipping object by ******\r\nlib_obj.prototype.clipBy = function(t,r,b,l,setwidth){\r\n  this.clipTo(this.ct+t,this.cr+r,this.cb+b,this.cl+l,setwidth)\r\n}\r\n\r\n//Clip animation ************\r\nlib_obj.prototype.clipIt = function(t,r,b,l,step,fn,wh){\r\n  tstep=Math.max(Math.max(Math.abs((t-this.ct)/step),Math.abs((r-this.cr)/step)),\r\n    Math.max(Math.abs((b-this.cb)/step),Math.abs((l-this.cl)/step)))\r\n  if(!this.clipactive){\r\n    this.clipactive=true; if(!wh) wh=0; if(!fn) fn=0\r\n    this.clip(t,r,b,l,(t-this.ct)/tstep,(r-this.cr)/tstep,\r\n      (b-this.cb)/tstep,(l-this.cl)/tstep,tstep,0, fn,wh)\r\n  }\r\n}\r\nlib_obj.prototype.clip = function(t,r,b,l,ts,rs,bs,ls,tstep,astep,fn,wh){\r\n  if(astep<tstep){\r\n    if(wh) eval(wh);\r\n    astep++\r\n    this.clipBy(ts,rs,bs,ls,1);\r\n    setTimeout(this.obj+".clip("+t+","+r+","+b+","+l+","+ts+","+rs+","\r\n      +bs+","+ls+","+tstep+","+astep+",\'"+fn+"\',\'"+wh+"\')",50)\r\n  }else{\r\n    this.clipactive=false; this.clipTo(t,r,b,l,1);\r\n    if(fn) eval(fn)\r\n  }\r\n}\r\n\r\n//Slide animation ***********\r\nlib_obj.prototype.slideIt = function(endx,endy,inc,speed,fn,wh){\r\n  if(!this.slideactive){\r\n    var distx = endx - this.x;\r\n    var disty = endy - this.y\r\n    var num = Math.sqrt(Math.pow(distx,2)+Math.pow(disty,2))/inc\r\n    var dx = distx/num; var dy = disty/num\r\n    this.slideactive = 1;\r\n    if(!wh) wh=0; if(!fn) fn=0\r\n    this.slide(dx,dy,endx,endy,speed,fn,wh)\r\n    }\r\n}\r\nlib_obj.prototype.slide = function(dx,dy,endx,endy,speed,fn,wh) {\r\n  if(this.slideactive&&\r\n  (Math.floor(Math.abs(dx))<Math.floor(Math.abs(endx-this.x))||\r\n    Math.floor(Math.abs(dy))<Math.floor(Math.abs(endy-this.y)))){\r\n    this.moveBy(dx,dy);\r\n    if(wh) eval(wh)\r\n    setTimeout(this.obj+".slide("+dx+","+dy+","+endx+","+endy+","+speed+",\'"\r\n    +fn+"\',\'"+wh+"\')",speed)\r\n  }else{\r\n    this.slideactive = 0;\r\n    this.moveIt(endx,endy);\r\n    if(fn) eval(fn)\r\n  }\r\n}\r\n\r\n//Circle animation ****************\r\nlib_obj.prototype.circleIt = function(rad,ainc,a,enda,xc,yc,speed,fn) {\r\n  if((Math.abs(ainc)<Math.abs(enda-a))) {\r\n    a += ainc\r\n    var x = xc + rad*Math.cos(a*Math.PI/180)\r\n    var y = yc - rad*Math.sin(a*Math.PI/180)\r\n    this.moveIt(x,y)\r\n    setTimeout(this.obj+".circleIt("+rad+","+ainc+","+a+","+enda+","\r\n      +xc+","+yc+","+speed+",\'"+fn+"\')",speed)\r\n  }else if(fn&&fn!="undefined") eval(fn)\r\n}\r\n\r\n//Document size object ********\r\nfunction lib_doc_size(){\r\n  this.x=0;this.x2=bw.ie && document.body.offsetWidth-20||innerWidth||0;\r\n  this.y=0;this.y2=bw.ie && document.body.offsetHeight-5||innerHeight||0;\r\n  if(!this.x2||!this.y2) return message(\'Document has no width or height\')\r\n  this.x50=this.x2/2;this.y50=this.y2/2;\r\n  return this;\r\n}\r\n\r\n//Drag drop functions start *******************\r\ndd_is_active=0; dd_obj=0; dd_mobj=0\r\nfunction lib_dd(){\r\n  dd_is_active=1\r\n  if(bw.ns4){\r\n    document.captureEvents(Event.MOUSEMOVE|Event.MOUSEDOWN|Event.MOUSEUP)\r\n  }\r\n  document.onmousemove=lib_dd_move;\r\n  document.onmousedown=lib_dd_down\r\n  document.onmouseup=lib_dd_up\r\n}\r\nlib_obj.prototype.dragdrop = function(obj){\r\n  if(!dd_is_active) lib_dd()\r\n  this.evnt.onmouseover=new Function("lib_dd_over("+this.obj+")")\r\n  this.evnt.onmouseout=new Function("dd_mobj=0")\r\n  if(obj) this.ddobj=obj\r\n}\r\nlib_obj.prototype.nodragdrop = function(){\r\n  this.evnt.onmouseover=""; this.evnt.onmouseout=""\r\n  dd_obj=0; dd_mobj=0\r\n}\r\n//Drag drop event functions\r\nfunction lib_dd_over(obj){dd_mobj=obj}\r\nfunction lib_dd_up(e){dd_obj=0}\r\nfunction lib_dd_down(e){ //Mousedown\r\n  if(dd_mobj){\r\n    x=(bw.ns4 || bw.ns6)?e.pageX:event.x||event.clientX\r\n    y=(bw.ns4 || bw.ns6)?e.pageY:event.y||event.clientY\r\n    dd_obj=dd_mobj\r\n    dd_obj.clX=x-dd_obj.x;\r\n    dd_obj.clY=y-dd_obj.y\r\n  }\r\n}\r\nfunction lib_dd_move(e,y,rresize){ //Mousemove\r\n  x=(bw.ns4 || bw.ns6)?e.pageX:event.x||event.clientX\r\n  y=(bw.ns4 || bw.ns6)?e.pageY:event.y||event.clientY\r\n  if(dd_obj){\r\n    nx=x-dd_obj.clX; ny=y-dd_obj.clY\r\n    if(dd_obj.ddobj) dd_obj.ddobj.moveIt(nx,ny)\r\n    else dd_obj.moveIt(nx,ny)\r\n  }\r\n  if(!bw.ns4) return false\r\n}\r\n//Drag drop functions end *************\r\n//-->', 1, 1, 20030310214759, 20030207204900);
INSERT INTO cms_js VALUES (4, 4, 0, '<!--\r\nself.onError=null;\r\ncurrentX = currentY = 0;\r\nwhichIt = null;\r\nlastScrollX = 0; lastScrollY = 0;\r\nNS = (document.layers) ? 1 : 0;\r\nIE = (document.all) ? 1: 0;\r\nfunction heartBeat() {\r\n	if(IE) {\r\n         	diffY = document.body.scrollTop;\r\n                 diffX = document.body.scrollLeft;\r\n         }\r\n         if(NS) {\r\n         	diffY = self.pageYOffset;\r\n                 diffX = self.pageXOffset;\r\n	}\r\n	if(diffY != lastScrollY) {\r\n		percent = .1 * (diffY - lastScrollY);\r\n		if(percent > 0) percent = Math.ceil(percent);\r\n		else percent = Math.floor(percent);\r\n		if(IE) document.all.slide.style.pixelTop += percent;\r\n		if(NS) document.slide.top += percent;\r\n		lastScrollY = lastScrollY + percent;\r\n	}\r\n	if(diffX != lastScrollX) {\r\n		percent = .1 * (diffX - lastScrollX);\r\n		if(percent > 0) percent = Math.ceil(percent);\r\n		else percent = Math.floor(percent);\r\n		if(IE) document.all.slide.style.pixelLeft += percent;\r\n		if(NS) document.slide.left += percent;\r\n		lastScrollX = lastScrollX + percent;\r\n	}\r\n}\r\n\r\nfunction checkFocus(x,y) {\r\n	var totalY, totalX;\r\n	floatx = document.slide.pageX;\r\n	floaty = document.slide.pageY;\r\n	floatwidth = document.slide.clip.width;\r\n	floatheight = document.slide.clip.height;\r\n\r\n	if(20 == 0) totalY = floatheight;\r\n	else totalY = 25;\r\n	if(0 == 0) totalX = floatwidth;\r\n	else totalX = 0;\r\n	if( (x > floatx && x < (floatx+totalX)) && (y > floaty && y < (floaty+totalY))) return true;\r\n	else return false;\r\n}\r\n\r\nfunction grabIt(e) {\r\n	if(IE) {\r\n		whichIt = event.srcElement;\r\n		while (whichIt.id.indexOf(\'slide\') == -1) {\r\n			whichIt = whichIt.parentElement;\r\n			if (whichIt == null) return true;\r\n		}\r\n		whichIt.style.pixelLeft = whichIt.offsetLeft;\r\n		whichIt.style.pixelTop = whichIt.offsetTop;\r\n		currentX = (event.clientX + document.body.scrollLeft);\r\n		currentY = (event.clientY + document.body.scrollTop);\r\n\r\n		if(20 == 0) totalY = whichIt.style.pixelHeight;\r\n		else totalY = 20;\r\n		if(0 == 0) totalX = whichIt.style.pixelWidth;\r\n		else totalX = 0;\r\n		if(!(event.clientX > whichIt.offsetLeft && event.clientX < whichIt.offsetLeft + totalX) || !(currentY > whichIt.offsetTop && currentY < whichIt.offsetTop + totalY)) whichIt = null;\r\n	} else {\r\n		window.captureEvents(Event.MOUSEMOVE);\r\n		if (checkFocus (e.pageX,e.pageY)) {\r\n			whichIt = document.slide;\r\n			FloatTouchedX = e.pageX-document.slide.pageX;\r\n			FloatTouchedY = e.pageY-document.slide.pageY;\r\n		}\r\n	}\r\n	return true;\r\n}\r\n\r\nfunction moveIt(e) {\r\n	if (whichIt == null) return false;\r\n	if(IE) {\r\n		newX = (event.clientX + document.body.scrollLeft);\r\n		newY = (event.clientY + document.body.scrollTop);\r\n		distanceX = (newX - currentX);\r\n                 distanceY = (newY - currentY);\r\n		currentX = newX;\r\n                 currentY = newY;\r\n		whichIt.style.pixelLeft += distanceX;\r\n		whichIt.style.pixelTop += distanceY;\r\n		if(whichIt.style.pixelTop < document.body.scrollTop) whichIt.style.pixelTop = document.body.scrollTop;\r\n		if(whichIt.style.pixelLeft < document.body.scrollLeft) whichIt.style.pixelLeft = document.body.scrollLeft;\r\n		if(whichIt.style.pixelLeft > document.body.offsetWidth - document.body.scrollLeft - whichIt.style.pixelWidth - 20) whichIt.style.pixelLeft = document.body.offsetWidth - whichIt.style.pixelWidth - 20;\r\n		if(whichIt.style.pixelTop > document.body.offsetHeight + document.body.scrollTop - whichIt.style.pixelHeight - 5) whichIt.style.pixelTop = document.body.offsetHeight + document.body.scrollTop - whichIt.style.pixelHeight - 5;\r\n		event.returnValue = false;\r\n	} else {\r\n		whichIt.moveTo(e.pageX-FloatTouchedX,e.pageY-FloatTouchedY);\r\n		if(whichIt.left < 0+self.pageXOffset) whichIt.left = 0+self.pageXOffset;\r\n		if(whichIt.top < 0+self.pageYOffset) whichIt.top = 0+self.pageYOffset;\r\n		if( (whichIt.left + whichIt.clip.width) >= (window.innerWidth+self.pageXOffset-17)) whichIt.left = ((window.innerWidth+self.pageXOffset)-whichIt.clip.width)-17;\r\n		if( (whichIt.top + whichIt.clip.height) >= (window.innerHeight+self.pageYOffset-17)) whichIt.top = ((window.innerHeight+self.pageYOffset)-whichIt.clip.height)-17;\r\n		return false;\r\n	}\r\n	return false;\r\n}\r\n\r\nfunction dropIt() {\r\n	whichIt = null;\r\n	if(NS) window.releaseEvents (Event.MOUSEMOVE);\r\n	return true;\r\n}\r\n\r\nif(NS) {\r\n	window.captureEvents(Event.MOUSEUP|Event.MOUSEDOWN);\r\n	window.onmousedown = grabIt;\r\n	window.onmousemove = moveIt;\r\n	window.onmouseup = dropIt;\r\n}\r\nif(IE) {\r\n	document.onmousedown = grabIt;\r\n	document.onmousemove = moveIt;\r\n	document.onmouseup = dropIt;\r\n}\r\nif(NS || IE) action = window.setInterval(\'heartBeat()\', 1);\r\n//-->', 1, 1, 20030310214759, 20030207204900);
# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_lang`
#

DROP TABLE IF EXISTS cms_lang;
CREATE TABLE cms_lang (
  idlang int(6) NOT NULL auto_increment,
  name varchar(255) NOT NULL default '',
  description varchar(255) default NULL,
  charset varchar(255) NOT NULL default '',
  iso_3166_code varchar(8) default NULL,
  rewrite_key VARCHAR( 255 ) NOT NULL,
  rewrite_mapping VARCHAR( 15 ) NOT NULL,
  is_start enum('0','1') NOT NULL default '0',
  author int(10) NOT NULL default '0',
  created int(10) NOT NULL default '0',
  lastmodified int(10) NOT NULL default '0',
  PRIMARY KEY  (idlang),
  KEY rewrite_key (rewrite_key)
) ENGINE=MyISAM;
#
# Daten fr Tabelle `cms_lang`
#

INSERT INTO cms_lang VALUES (1, 'deutsch', '', 'utf-8', 'de', 'de', 'standard', '1', 1, 0, 0);

#
# Tabellenstruktur fr Tabelle `cms_lay`
#

DROP TABLE IF EXISTS cms_lay;
CREATE TABLE cms_lay (
  idlay int(6) NOT NULL auto_increment,
  idclient int(6) NOT NULL default '0',
  name varchar(255) NOT NULL default '',
  description text,
  code text NOT NULL,
  doctype varchar(63) default NULL,
  doctype_autoinsert tinyint(4) default '0',
  deletable tinyint(1) default '1',
  author varchar(32) NOT NULL default '',
  created int(10) NOT NULL default '0',
  lastmodified int(10) NOT NULL default '0',
  PRIMARY KEY  (idlay),
  KEY idclient (idclient)
) ENGINE=MyISAM;


#
# Daten fr Tabelle `cms_lay`
#

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_lay_upl`
#

DROP TABLE IF EXISTS cms_lay_upl;
CREATE TABLE cms_lay_upl (
  idlayupl int(6) NOT NULL auto_increment,
  idlay int(6) NOT NULL default '0',
  idupl int(6) NOT NULL default '0',
  PRIMARY KEY  (idlayupl),
  KEY idlay (idlay),
  KEY idupl (idupl)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_lay_upl`
#

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_mod`
#

DROP TABLE IF EXISTS cms_mod;
CREATE TABLE cms_mod (
  idmod int(6) NOT NULL auto_increment,
  name varchar(255) NOT NULL default '',
  version varchar(63) default NULL,
  cat varchar(63) default NULL,
  description text,
  input LONGTEXT NOT NULL,
  output LONGTEXT NOT NULL,
  config text,
  idclient int(6) NOT NULL default '0',
  deletable tinyint(1) NOT NULL default '1',
  author int(6) NOT NULL default '0',
  created int(10) NOT NULL default '0',
  lastmodified int(10) NOT NULL default '0',
  repository_id varchar(255) default NULL,
  install_sql text,
  uninstall_sql text,
  update_sql text,
  source_id int(6) unsigned NOT NULL default '0',
  is_install enum('0','1') NOT NULL default '0',
  verbose varchar(100) default NULL,
  checked enum('1','0') NOT NULL default '0',
  PRIMARY KEY  (idmod),
  KEY idclient (idclient)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_mod`
#
INSERT INTO `cms_mod` VALUES (1, 'Textfeld (einzeilig)', '1.1', 'Content', 'Textfeld, gut geeignet fr berschriften.', '<?PHP\r\n//configmode\r\n$mip_form[''13''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''13''][''cat''] = ''option'';\r\n$mip_form[''13''][''size''] = ''1'';\r\n$mip_form[''13''][''option_desc''][] = ''Normal'';\r\n$mip_form[''13''][''option_val''][] =  '''';\r\n$mip_form[''13''][''option_desc''][] = ''Erweitert'';\r\n$mip_form[''13''][''option_val''][] =  ''advanced'';\r\n$mip_form[''13''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''13''][''option_val''][] =  ''hidden'';\r\n$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n$mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n$mip_form[''13''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''13'']);//configmode\r\n$mip_form[''hide_in_standard_mode''] = array(0,2);\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''13''] == ''hidden''){\r\n  foreach($cms_mod[''value''] AS $ke=>$va){\r\n    if($ke != ''13''){\r\n    ?>\r\n      <input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n    <?php\r\n     }\r\n  }\r\n}\r\n//simple and advanced config\r\nelse if($cms_mod[''value''][''13''] == '''' || $cms_mod[''value''][''13''] == ''advanced''){\r\n\r\n\r\n\r\n//Formularname\r\n$mip_form[''0''][''cat''] = ''txt'';\r\n$mip_form[''0''][''type''] = '''';\r\n$mip_form[''0''][''desc''] = ''Formularfeldname'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''cms_val_default''] = ''Einzeiliges Textfeld'';\r\n$mip_form[''0''][''tab''] = ''0'';\r\n\r\n//Style\r\n$mip_form[''1''][''desc''] = $mod_lang[''gen_font''];\r\n$mip_form[''1''][''cat''] = ''app_css'';\r\n$mip_form[''1''][''output_cat''] = ''option'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''flag''] = ''class_only'';\r\n\r\n//Erweitertes Bearbeitungsmen\r\n$mip_form[''2''][''cat''] = ''radio'';\r\n$mip_form[''2''][''type''] = '''';\r\n$mip_form[''2''][''desc''] = ''Bearbeitungsmen<br>\r\n<small>Ein <b>normales Men</b> besteht aus der Schalflche "bearbeiten", das <b>erweiterte Men</b> \r\nbietet darberhinaus die Schaltflchen "neu, lschen, nach oben, nach unten". Wird <b>kein Men</b> gewhlt, ist der \r\nContent nicht editierbar.</small>'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''cms_val_default''] = ''true'';\r\n$mip_form[''2''][''option_desc''][''0''] = ''Normales Men'';\r\n$mip_form[''2''][''option_val''][''0''] = ''true'';\r\n$mip_form[''2''][''option_desc''][''1''] = ''Erweitertes Men'';\r\n$mip_form[''2''][''option_val''][''1''] = ''advanced'';\r\n$mip_form[''2''][''option_desc''][''2''] = ''Kein Men'';\r\n$mip_form[''2''][''option_val''][''2''] = ''false'';\r\n$mip_form[''2''][''tab''] = ''0'';\r\n\r\n// Template\r\n$mip_form[''3''][''desc''] = ''Template'';\r\n$mip_form[''3''][''cat''] = ''txtarea'';\r\n$mip_form[''3''][''rows''] = ''6'';\r\n$mip_form[''3''][''type''] = ''long'';\r\n$mip_form[''3''][''cms_var''] = ''MOD_VAR[3]'';\r\n$mip_form[''3''][''cms_val''] = $cms_mod[''value''][''3''];\r\n$mip_form[''3''][''cms_val_default''] = ''{text}'';\r\n\r\n//if simple mode\r\nif($cms_mod[''value''][''13''] == ''''){\r\n   foreach ($mip_form[''hide_in_standard_mode'']  AS $ke=>$va){\r\n     $mip_form[$va][''cat''] = ''hidden'';\r\n   }\r\n }\r\n\r\nmip_formsp($mip_form[''0'']);\r\nmip_formsp($mip_form[''1'']);\r\nmip_formsp($mip_form[''2'']);\r\nmip_formsp($mip_form[''3'']);\r\necho '' <small><b>Legende:</b><br> \r\nEinzeiliges Textfeld: {text}, Ausgewhltes Stylesheet: {style}<br>\r\nPhp-Code: &lt;?PHP echo "Ich bin gecachter phpcode! Ich werde immer nur dann neu generiert, wenn es eine<br> \r\nnderung auf der Seite gegeben hat"; ?&gt;<br>\r\n&lt;CMSPHP&gt; echo "Ich bin ungecachter phpcode! Ich werde bei jedem Aufruf der Seite ausgefhrt";&lt;/CMSPHP&gt;<br>\r\n</small>'';\r\n}\r\nunset($mip_form);\r\n\r\n?>', '<?PHP\r\n$myText[''text''] = <cms:mod type="text" id="1" title="MOD_VALUE[0]" styleclass="MOD_VALUE[1]" menuoptions="MOD_VALUE[2]" addslashes="true" />;\r\n$myText[''style''] = "MOD_VALUE[1]";\r\n\r\n$myTplVars[''text''] = ''{text}'';\r\n$myTplVars[''style''] = ''{style}'';\r\n$myTpl = "MOD_VALUE[3]";\r\n    \r\n$myTpl = str_replace($myTplVars, $myText, $myTpl);\r\n\r\neval(''?>''.$myTpl); \r\nunset($myTpl, $myTplVars, $myText);\r\n?>\r\n', '', 0, 1, 1, 1066927900, 1125070451, 'mod:e39de608156656814b7b2e8ee199adcc:81e36234', '', '', '', 0, '', '', '1');
INSERT INTO `cms_mod` VALUES (2, 'Textarea', '1.1', 'Content', 'Erzeugt eine Textarea', '<?PHP\r\n//configmode\r\n$mip_form[''13''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''13''][''cat''] = ''option'';\r\n$mip_form[''13''][''size''] = ''1'';\r\n$mip_form[''13''][''option_desc''][] = ''Normal'';\r\n$mip_form[''13''][''option_val''][] =  '''';\r\n$mip_form[''13''][''option_desc''][] = ''Erweitert'';\r\n$mip_form[''13''][''option_val''][] =  ''advanced'';\r\n$mip_form[''13''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''13''][''option_val''][] =  ''hidden'';\r\n$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n$mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n$mip_form[''13''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''13'']);//configmode\r\n$mip_form[''hide_in_standard_mode''] = array(0,2);\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''13''] == ''hidden''){\r\n  foreach($cms_mod[''value''] AS $ke=>$va){\r\n    if($ke != ''13''){\r\n    ?>\r\n      <input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n    <?php\r\n     }\r\n  }\r\n}\r\n//simple and advanced config\r\nelse if($cms_mod[''value''][''13''] == '''' || $cms_mod[''value''][''13''] == ''advanced''){\r\n\r\n\r\n//Formularname\r\n$mip_form[''0''][''cat''] = ''txt'';\r\n$mip_form[''0''][''type''] = '''';\r\n$mip_form[''0''][''desc''] = ''Formularfeldname'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''cms_val_default''] = ''Textfeld'';\r\n$mip_form[''0''][''tab''] = ''0'';\r\n\r\n//Style\r\n$mip_form[''1''][''desc''] = $mod_lang[''gen_font''];\r\n$mip_form[''1''][''cat''] = ''app_css'';\r\n$mip_form[''1''][''output_cat''] = ''option'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''flag''] = ''class_only'';\r\n\r\n//Erweitertes Bearbeitungsmen\r\n$mip_form[''2''][''cat''] = ''radio'';\r\n$mip_form[''2''][''type''] = '''';\r\n$mip_form[''2''][''desc''] = ''Bearbeitungsmen<br>\r\n<small>Ein <b>normales Men</b> besteht aus der Schalflche "bearbeiten", das <b>erweiterte Men</b> \r\nbietet darberhinaus die Schaltflchen "neu, lschen, nach oben, nach unten". Wird <b>kein Men</b> gewhlt, ist der \r\nContent nicht editierbar.</small>'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''cms_val_default''] = ''true'';\r\n$mip_form[''2''][''option_desc''][''0''] = ''Normales Men'';\r\n$mip_form[''2''][''option_val''][''0''] = ''true'';\r\n$mip_form[''2''][''option_desc''][''1''] = ''Erweitertes Men'';\r\n$mip_form[''2''][''option_val''][''1''] = ''advanced'';\r\n$mip_form[''2''][''option_desc''][''2''] = ''Kein Men'';\r\n$mip_form[''2''][''option_val''][''2''] = ''false'';\r\n$mip_form[''2''][''tab''] = ''0'';\r\n\r\n// Template\r\n$mip_form[''3''][''desc''] = ''Template'';\r\n$mip_form[''3''][''cat''] = ''txtarea'';\r\n$mip_form[''3''][''rows''] = ''6'';\r\n$mip_form[''3''][''type''] = ''long'';\r\n$mip_form[''3''][''cms_var''] = ''MOD_VAR[3]'';\r\n$mip_form[''3''][''cms_val''] = $cms_mod[''value''][''3''];\r\n$mip_form[''3''][''cms_val_default''] = ''{textarea}'';\r\n\r\n//if simple mode\r\nif($cms_mod[''value''][''13''] == ''''){\r\n   foreach ($mip_form[''hide_in_standard_mode'']  AS $ke=>$va){\r\n     $mip_form[$va][''cat''] = ''hidden'';\r\n   }\r\n }\r\nmip_formsp($mip_form[''0'']);\r\nmip_formsp($mip_form[''1'']);\r\nmip_formsp($mip_form[''2'']);\r\nmip_formsp($mip_form[''3'']);\r\necho '' <small><b>Legende:</b><br> \r\nTextarea: {textarea}, Ausgewhltes Stylesheet: {style}<br>\r\nPhp-Code: &lt;?PHP echo "Ich bin gecachter phpcode! Ich werde immer nur dann neu generiert, wenn es eine<br>\r\nnderung auf der Seite gegeben hat"; ?&gt;<br>\r\n&lt;CMSPHP&gt; echo "Ich bin ungecachter phpcode! Ich werde bei jedem Aufruf der Seite ausgefhrt";&lt;/CMSPHP&gt;<br>\r\n</small>'';\r\n}\r\nunset($mip_form);\r\n\r\n?>', '<?PHP\r\n$myTextarea[''text''] = <cms:mod type="textarea" id="1"  styleclass="MOD_VALUE[1]" title="MOD_VALUE[0]" menuoptions="MOD_VALUE[2]" addslashes="true" />;\r\n$myTextarea[''style''] = "MOD_VALUE[1]";\r\n\r\n$myTplVars[''textarea''] = ''{textarea}'';\r\n$myTplVars[''style''] = ''{style}'';\r\n$myTpl = "MOD_VALUE[3]";\r\n    \r\n$myTpl = str_replace($myTplVars, $myTextarea, $myTpl);\r\n\r\neval(''?>''.$myTpl); \r\nunset($myTpl, $myTplVars, $myTextarea);\r\n?>\r\n', '', 0, 1, 1, 1066927900, 1125070430, 'mod:6394d816bfb4220289a6f4b29cfb1834:420ce664', '', '', '', 0, '', '', '1');
INSERT INTO `cms_mod` VALUES (3, 'Sourcecode', '1.1', 'Content', 'HTML- Quelltexteditor', '<?PHP\r\n//configmode\r\n$mip_form[''13''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''13''][''cat''] = ''option'';\r\n$mip_form[''13''][''size''] = ''1'';\r\n$mip_form[''13''][''option_desc''][] = ''Normal'';\r\n$mip_form[''13''][''option_val''][] =  '''';\r\n$mip_form[''13''][''option_desc''][] = ''Erweitert'';\r\n$mip_form[''13''][''option_val''][] =  ''advanced'';\r\n$mip_form[''13''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''13''][''option_val''][] =  ''hidden'';\r\n$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n$mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n$mip_form[''13''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''13'']);//configmode\r\n$mip_form[''hide_in_standard_mode''] = array(0,1);\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''13''] == ''hidden''){\r\n  foreach($cms_mod[''value''] AS $ke=>$va){\r\n    if($ke != ''13''){\r\n    ?>\r\n      <input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n    <?php\r\n     }\r\n  }\r\n}\r\n//simple and advanced config\r\nelse if($cms_mod[''value''][''13''] == '''' || $cms_mod[''value''][''13''] == ''advanced''){\r\n\r\n\r\n//Formularname\r\n$mip_form[''0''][''cat''] = ''txt'';\r\n$mip_form[''0''][''type''] = '''';\r\n$mip_form[''0''][''desc''] = ''Formularfeldname'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''cms_val_default''] = ''Quelltext'';\r\n$mip_form[''0''][''tab''] = ''0'';\r\n\r\n//Erweitertes Bearbeitungsmen\r\n$mip_form[''1''][''cat''] = ''radio'';\r\n$mip_form[''1''][''type''] = '''';\r\n$mip_form[''1''][''desc''] = ''Bearbeitungsmen<br>\r\n<small>Ein <b>normales Men</b> besteht aus der Schalflche "bearbeiten", das <b>erweiterte Men</b> \r\nbietet darberhinaus die Schaltflchen "neu, lschen, nach oben, nach unten". Wird <b>kein Men</b> gewhlt, ist der \r\nContent nicht editierbar.</small>'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''cms_val_default''] = ''true'';\r\n$mip_form[''1''][''option_desc''][''0''] = ''Normales Men'';\r\n$mip_form[''1''][''option_val''][''0''] = ''true'';\r\n$mip_form[''1''][''option_desc''][''1''] = ''Erweitertes Men'';\r\n$mip_form[''1''][''option_val''][''1''] = ''advanced'';\r\n$mip_form[''1''][''option_desc''][''2''] = ''Kein Men'';\r\n$mip_form[''1''][''option_val''][''2''] = ''false'';\r\n$mip_form[''1''][''tab''] = ''0'';\r\n\r\n// Template\r\n$mip_form[''2''][''desc''] = ''Template'';\r\n$mip_form[''2''][''cat''] = ''txtarea'';\r\n$mip_form[''2''][''rows''] = ''6'';\r\n$mip_form[''2''][''type''] = ''long'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''cms_val_default''] = ''{sourcecode}'';\r\n\r\n//if simple mode\r\nif($cms_mod[''value''][''13''] == ''''){\r\n   foreach ($mip_form[''hide_in_standard_mode'']  AS $ke=>$va){\r\n     $mip_form[$va][''cat''] = ''hidden'';\r\n   }\r\n }\r\nmip_formsp($mip_form[''0'']);\r\nmip_formsp($mip_form[''1'']);\r\nmip_formsp($mip_form[''2'']);\r\necho '' <small><b>Legende:</b><br> \r\nQuelltexteditor: {sourcecode}<br>\r\nPhp-Code: &lt;?PHP echo "Ich bin gecachter phpcode! Ich werde immer nur dann neu generiert, wenn<br>\r\nes eine nderung auf der Seite gegeben hat"; ?&gt;<br>\r\n&lt;CMSPHP&gt; echo "Ich bin ungecachter phpcode! Ich werde bei jedem Aufruf der Seite ausgefhrt";&lt;/CMSPHP&gt;<br>\r\n</small>'';\r\n}\r\nunset($mip_form);\r\n?>', '<?PHP\r\n$mySource = <cms:mod type="sourcecode" id="1"   title="MOD_VALUE[0]" menuoptions="MOD_VALUE[1]" addslashes="true" />;\r\n\r\n$myTplVar = ''{sourcecode}'';\r\n$myTpl = "MOD_VALUE[2]";\r\n    \r\n$myTpl = str_replace($myTplVar, $mySource, $myTpl);\r\n\r\neval(''?>''.$myTpl); \r\nunset($myTpl, $myTplVar, $mySource);\r\n?>\r\n', '', 0, 1, 1, 1066927900, 1125070405, 'mod:99e4c8121cd7d4b0d4c6f388df4e4c82:6ed629dc', '', '', '', 0, '', '', '1');
INSERT INTO `cms_mod` VALUES (4, 'WYSIWYG', '1.1', 'Content', 'WYSIWYG-Editor zum bearbeiten von Text / HTML.', '<?PHP\r\n//configmode\r\n$mip_form[''13''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''13''][''cat''] = ''option'';\r\n$mip_form[''13''][''size''] = ''1'';\r\n$mip_form[''13''][''option_desc''][] = ''Normal'';\r\n$mip_form[''13''][''option_val''][] =  '''';\r\n$mip_form[''13''][''option_desc''][] = ''Erweitert'';\r\n$mip_form[''13''][''option_val''][] =  ''advanced'';\r\n$mip_form[''13''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''13''][''option_val''][] =  ''hidden'';\r\n$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n$mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n$mip_form[''13''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''13'']);//configmode\r\n$mip_form[''hide_in_standard_mode''] = array(0,2);\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''13''] == ''hidden''){\r\n  foreach($cms_mod[''value''] AS $ke=>$va){\r\n    if($ke != ''13''){\r\n    ?>\r\n      <input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n    <?php\r\n     }\r\n  }\r\n}\r\n//simple and advanced config\r\nelse if($cms_mod[''value''][''13''] == '''' || $cms_mod[''value''][''13''] == ''advanced''){\r\n\r\n\r\n//Formularname\r\n$mip_form[''0''][''cat''] = ''txt'';\r\n$mip_form[''0''][''type''] = '''';\r\n$mip_form[''0''][''desc''] = ''Formularfeldname'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''cms_val_default''] = ''WYSIWYG'';\r\n$mip_form[''0''][''tab''] = ''0'';\r\n\r\n//Style\r\n$mip_form[''1''][''desc''] = $mod_lang[''gen_font''];\r\n$mip_form[''1''][''cat''] = ''app_css'';\r\n$mip_form[''1''][''output_cat''] = ''option'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''flag''] = ''class_only'';\r\n\r\n//Erweitertes Bearbeitungsmen\r\n$mip_form[''2''][''cat''] = ''radio'';\r\n$mip_form[''2''][''type''] = '''';\r\n$mip_form[''2''][''desc''] = ''Bearbeitungsmen<br>\r\n<small>Ein <b>normales Men</b> besteht aus der Schalflche "bearbeiten", das <b>erweiterte Men</b> \r\nbietet darberhinaus die Schaltflchen "neu, lschen, nach oben, nach unten". Wird <b>kein Men</b> gewhlt, ist der \r\nContent nicht editierbar.</small>'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''cms_val_default''] = ''true'';\r\n$mip_form[''2''][''option_desc''][''0''] = ''Normales Men'';\r\n$mip_form[''2''][''option_val''][''0''] = ''true'';\r\n$mip_form[''2''][''option_desc''][''1''] = ''Erweitertes Men'';\r\n$mip_form[''2''][''option_val''][''1''] = ''advanced'';\r\n$mip_form[''2''][''option_desc''][''2''] = ''Kein Men'';\r\n$mip_form[''2''][''option_val''][''2''] = ''false'';\r\n$mip_form[''2''][''tab''] = ''0'';\r\n\r\n// Template\r\n$mip_form[''3''][''desc''] = ''Template'';\r\n$mip_form[''3''][''cat''] = ''txtarea'';\r\n$mip_form[''3''][''rows''] = ''6'';\r\n$mip_form[''3''][''type''] = ''long'';\r\n$mip_form[''3''][''cms_var''] = ''MOD_VAR[3]'';\r\n$mip_form[''3''][''cms_val''] = $cms_mod[''value''][''3''];\r\n$mip_form[''3''][''cms_val_default''] = ''{wysiwyg}'';\r\n\r\n//if simple mode\r\nif($cms_mod[''value''][''13''] == ''''){\r\n   foreach ($mip_form[''hide_in_standard_mode'']  AS $ke=>$va){\r\n     $mip_form[$va][''cat''] = ''hidden'';\r\n   }\r\n }\r\n\r\nmip_formsp($mip_form[''0'']);\r\nmip_formsp($mip_form[''1'']);\r\nmip_formsp($mip_form[''2'']);\r\nmip_formsp($mip_form[''3'']);\r\necho '' <small><b>Legende:</b><br> \r\nWYSIWYG- Editor: {wysiwyg}, Ausgewhltes Stylesheet: {style}<br>\r\nPhp-Code: &lt;?PHP echo "Ich bin gecachter phpcode! Ich werde immer nur dann neu generiert, wenn es eine<br> \r\nnderung auf der Seite gegeben hat"; ?&gt;<br>\r\n&lt;CMSPHP&gt; echo "Ich bin ungecachter phpcode! Ich werde bei jedem Aufruf der Seite ausgefhrt";&lt;/CMSPHP&gt;<br>\r\n</small>'';\r\n}\r\nunset($mip_form);\r\n\r\n?>', '<?PHP\r\n$myWysiwyg[''wysiwyg''] = <cms:mod type="wysiwyg" id="1"  styleclass="MOD_VALUE[1]" title="MOD_VALUE[0]" menuoptions="MOD_VALUE[2]" addslashes="true" />;\r\n$myWysiwyg[''style''] = "MOD_VALUE[1]";\r\n\r\n$myTplVars[''wysiwyg''] = ''{wysiwyg}'';\r\n$myTplVars[''style''] = ''{style}'';\r\n$myTpl = "MOD_VALUE[3]";\r\n    \r\n$myTpl = str_replace($myTplVars, $myWysiwyg, $myTpl);\r\n\r\neval(''?>''.$myTpl); \r\nunset($myTpl, $myTplVars, $myWysiwyg);\r\n?>\r\n', '', 0, 1, 1, 1066927900, 1125070491, 'mod:7d7915c405c8ce1ec5db4e7408825a12:2127276a', '', '', '', 0, '', '', '1');
INSERT INTO `cms_mod` VALUES (5, 'WYSIWYG2', '1.2', 'Content', 'Erweiterter WYSIWYG- Editor', '<?PHP\r\n//configmode\r\n$mip_form[''13''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''13''][''cat''] = ''option'';\r\n$mip_form[''13''][''size''] = ''1'';\r\n$mip_form[''13''][''option_desc''][] = ''Normal'';\r\n$mip_form[''13''][''option_val''][] =  '''';\r\n$mip_form[''13''][''option_desc''][] = ''Erweitert'';\r\n$mip_form[''13''][''option_val''][] =  ''advanced'';\r\n$mip_form[''13''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''13''][''option_val''][] =  ''hidden'';\r\n$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n$mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n$mip_form[''13''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''13'']);//configmode\r\n$mip_form[''hide_in_standard_mode''] = array(0,2,3,4,5,6,7,8,9,10,11);\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''13''] == ''hidden''){\r\n  foreach($cms_mod[''value''] AS $ke=>$va){\r\n    if($ke != ''13''){\r\n    ?>\r\n      <input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n    <?php\r\n     }\r\n  }\r\n}\r\n//simple and advanced config\r\nelse if($cms_mod[''value''][''13''] == '''' || $cms_mod[''value''][''13''] == ''advanced''){\r\n\r\n\r\n\r\n\r\n//Formularname\r\n$mip_form[''0''][''cat''] = ''txt'';\r\n$mip_form[''0''][''type''] = '''';\r\n$mip_form[''0''][''desc''] = ''Beschriftung Textfeld'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''cms_val_default''] = ''WYSIWYG 2'';\r\n$mip_form[''0''][''tab''] = ''0'';\r\n\r\n//Style\r\n$mip_form[''1''][''desc''] = $mod_lang[''gen_font''];\r\n$mip_form[''1''][''cat''] = ''app_css'';\r\n$mip_form[''1''][''output_cat''] = ''option'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''flag''] = ''class_only'';\r\n\r\n//Erweitertes Bearbeitungsmen\r\n$mip_form[''2''][''cat''] = ''radio'';\r\n$mip_form[''2''][''type''] = '''';\r\n$mip_form[''2''][''desc''] = ''Erweitertes Bearbeitungsmen'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''cms_val_default''] = ''true'';\r\n$mip_form[''2''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''2''][''option_val''][''0''] = ''advanced'';\r\n$mip_form[''2''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''2''][''option_val''][''1''] = ''true'';\r\n\r\n//Featureauswahl\r\n$mip_form[''3''][''desc''] = ''Angezeigt Schaltflchen'';\r\n$mip_form[''3''][''cat''] = ''option'';\r\n$mip_form[''3''][''flag''] = ''multiple'';\r\n$mip_form[''3''][''size''] = ''7'';\r\n$mip_form[''3''][''option_desc''][] = ''Alle Felder sichtbar'';\r\n$mip_form[''3''][''option_val''][] =  ''true'';\r\n$mip_form[''3''][''option_desc''][] = ''Fonts'';\r\n$mip_form[''3''][''option_val''][] =  ''font'';\r\n$mip_form[''3''][''option_desc''][] = ''Fontgre'';\r\n$mip_form[''3''][''option_val''][] =  ''fontsize'';\r\n$mip_form[''3''][''option_desc''][] = ''Stylesheets'';\r\n$mip_form[''3''][''option_val''][] =  ''styles'';\r\n$mip_form[''3''][''option_desc''][] = ''Text zurcksetzten'';\r\n$mip_form[''3''][''option_val''][] =  ''reset'';\r\n$mip_form[''3''][''option_desc''][] = ''Vorschau'';\r\n$mip_form[''3''][''option_val''][] =  ''preview'';\r\n$mip_form[''3''][''option_desc''][] = ''Drucken'';\r\n$mip_form[''3''][''option_val''][] =  ''print'';\r\n$mip_form[''3''][''option_desc''][] = ''Zwischenablagefunktionen'';\r\n$mip_form[''3''][''option_val''][] =  ''clipboardtools'';\r\n$mip_form[''3''][''option_desc''][] = ''HTMLtags entfernen'';\r\n$mip_form[''3''][''option_val''][] =  ''striptag'';\r\n$mip_form[''3''][''option_desc''][] = ''Undo/ Redo'';\r\n$mip_form[''3''][''option_val''][] =  ''undo'';\r\n$mip_form[''3''][''option_desc''][] = ''Suchen und Ersetzen'';\r\n$mip_form[''3''][''option_val''][] =  ''search'';\r\n$mip_form[''3''][''option_desc''][] = ''Upper-, Lowercase'';\r\n$mip_form[''3''][''option_val''][] =  ''changecase'';\r\n$mip_form[''3''][''option_desc''][] = ''Umschalten in HTMLansicht'';\r\n$mip_form[''3''][''option_val''][] =  ''changemode'';\r\n$mip_form[''3''][''option_desc''][] = ''Externes Bearbeitungsfenster'';\r\n$mip_form[''3''][''option_val''][] =  ''popupeditor'';\r\n$mip_form[''3''][''option_desc''][] = ''Tabellen'';\r\n$mip_form[''3''][''option_val''][] =  ''table'';\r\n$mip_form[''3''][''option_desc''][] = ''Fett'';\r\n$mip_form[''3''][''option_val''][] =  ''bold'';\r\n$mip_form[''3''][''option_desc''][] = ''Kursiv'';\r\n$mip_form[''3''][''option_val''][] =  ''italic'';\r\n$mip_form[''3''][''option_desc''][] = ''Unterstrichen'';\r\n$mip_form[''3''][''option_val''][] =  ''underline'';\r\n$mip_form[''3''][''option_desc''][] = ''Durchgestrichen'';\r\n$mip_form[''3''][''option_val''][] =  ''strikethrough'';\r\n$mip_form[''3''][''option_desc''][] = ''Tiefgestellt'';\r\n$mip_form[''3''][''option_val''][] =  ''subscript'';\r\n$mip_form[''3''][''option_desc''][] = ''Hochgestellt'';\r\n$mip_form[''3''][''option_val''][] =  ''superscript'';\r\n$mip_form[''3''][''option_desc''][] = ''Ausrichtung'';\r\n$mip_form[''3''][''option_val''][] =  ''align'';\r\n$mip_form[''3''][''option_desc''][] = ''Fontfarbe'';\r\n$mip_form[''3''][''option_val''][] =  ''fontcolor'';\r\n$mip_form[''3''][''option_desc''][] = ''Hintergrundfarbe'';\r\n$mip_form[''3''][''option_val''][] =  ''backgroundcolor'';\r\n$mip_form[''3''][''option_desc''][] = ''Listen'';\r\n$mip_form[''3''][''option_val''][] =  ''list'';\r\n$mip_form[''3''][''option_desc''][] = ''Einrckung'';\r\n$mip_form[''3''][''option_val''][] =  ''indent'';\r\n$mip_form[''3''][''option_desc''][] = ''Links einfgen'';\r\n$mip_form[''3''][''option_val''][] =  ''link'';\r\n$mip_form[''3''][''option_desc''][] = ''Bilder einfgen'';\r\n$mip_form[''3''][''option_val''][] =  ''image'';\r\n$mip_form[''3''][''option_desc''][] = ''Dateien einfgen'';\r\n$mip_form[''3''][''option_val''][] =  ''file'';\r\n$mip_form[''3''][''option_desc''][] = ''Liveresize'';\r\n$mip_form[''3''][''option_val''][] =  ''liveresize'';\r\n$mip_form[''3''][''option_desc''][] = ''Mehrfachauswahl'';\r\n$mip_form[''3''][''option_val''][] =  ''multipleselect'';\r\n$mip_form[''3''][''option_desc''][] = ''Trennlinie'';\r\n$mip_form[''3''][''option_val''][] =  ''hr'';\r\n$mip_form[''3''][''option_desc''][] = ''Besondere Zeichen'';\r\n$mip_form[''3''][''option_val''][] =  ''specialchars'';\r\n$mip_form[''3''][''option_desc''][] = ''Aktuelles Datum'';\r\n$mip_form[''3''][''option_val''][] =  ''date'';\r\n$mip_form[''3''][''option_desc''][] = ''Lauftexteditor'';\r\n$mip_form[''3''][''option_val''][] =  ''marquee'';\r\n$mip_form[''3''][''cms_var''] = ''MOD_VAR[3]'';\r\n$mip_form[''3''][''cms_val''] = $cms_mod[''value''][''3''];\r\n\r\n//Auswhlbare Stylesheets\r\n$mip_form[''4''][''desc''] = ''Fr den Redakteur auswhlbare Stylesheets'';\r\n$mip_form[''4''][''cat''] = ''app_css'';\r\n$mip_form[''4''][''output_cat''] = ''option'';\r\n$mip_form[''4''][''output_flag''] = ''multiple'';\r\n$mip_form[''4''][''size''] = ''5'';\r\n$mip_form[''4''][''cms_var''] = ''MOD_VAR[4]'';\r\n$mip_form[''4''][''cms_val''] = $cms_mod[''value''][''4''];\r\n$mip_form[''4''][''flag''] = ''class_only'';\r\n$mip_form[''4''][''return_val''] = ''idcssupl'';\r\n\r\n//Grafikordner\r\n$mip_form[''5''][''desc''] = ''Grafikauswahl aus folgenden Verzeichnissen ermglichen'';\r\n$mip_form[''5''][''cat''] = ''app_directory'';\r\n$mip_form[''5''][''output_cat''] = ''option'';\r\n$mip_form[''5''][''cms_var''] = ''MOD_VAR[5]'';\r\n$mip_form[''5''][''cms_val''] = $cms_mod[''value''][''5''];\r\n$mip_form[''5''][''flag''] = ''multiple'';\r\n$mip_form[''5''][''size''] = ''5'';\r\n\r\n//Mit Unterverzeichnissen\r\n$mip_form[''6''][''cat''] = ''option'';\r\n$mip_form[''6''][''type''] = '''';\r\n$mip_form[''6''][''desc''] = ''Automatischa Anzeige von Unterverzeichnissen'';\r\n$mip_form[''6''][''cms_var''] = ''MOD_VAR[6]'';\r\n$mip_form[''6''][''cms_val''] = $cms_mod[''value''][''6''];\r\n$mip_form[''6''][''cms_val_default''] = ''false'';\r\n$mip_form[''6''][''option_desc''][''0''] = ''Nein'';\r\n$mip_form[''6''][''option_val''][''0''] = ''false'';\r\n$mip_form[''6''][''option_desc''][''1''] = ''Ja'';\r\n$mip_form[''6''][''option_val''][''1''] = ''true'';\r\n$mip_form[''6''][''tab''] = ''0'';\r\n\r\n//Grafiktypen\r\n$mip_form[''7''][''desc''] = ''Auswhlbare Grafiktypen: '';\r\n$mip_form[''7''][''cat''] = ''option'';\r\n$mip_form[''7''][''cms_var''] = ''MOD_VAR[7]'';\r\n$mip_form[''7''][''cms_val''] = $cms_mod[''value''][''7''];\r\n$mip_form[''7''][''option_desc''][] = ''Alle Webtypen'';\r\n$mip_form[''7''][''option_val''][] =  '''';\r\n$mip_form[''7''][''option_val''][] =  ''gif'';\r\n$mip_form[''7''][''option_val''][] =  ''jpg'';\r\n$mip_form[''7''][''option_val''][] =  ''jpeg'';\r\n$mip_form[''7''][''option_val''][] =  ''png'';\r\n$mip_form[''7''][''flag''] = ''multiple'';\r\n$mip_form[''7''][''size''] = ''5'';\r\n\r\n//Dateilinks Ordner\r\n$mip_form[''8''][''desc''] = ''Ordner: '';\r\n$mip_form[''8''][''cat''] = ''app_directory'';\r\n$mip_form[''8''][''output_cat''] = ''option'';\r\n$mip_form[''8''][''cms_var''] = ''MOD_VAR[8]'';\r\n$mip_form[''8''][''cms_val''] = $cms_mod[''value''][''8''];\r\n$mip_form[''8''][''flag''] = ''multiple'';\r\n$mip_form[''8''][''size''] = ''5'';\r\n\r\n//Mit Unterverzeichnissen\r\n$mip_form[''9''][''cat''] = ''option'';\r\n$mip_form[''9''][''type''] = '''';\r\n$mip_form[''9''][''desc''] = ''Automatischa Anzeige von Unterverzeichnissen'';\r\n$mip_form[''9''][''cms_var''] = ''MOD_VAR[9]'';\r\n$mip_form[''9''][''cms_val''] = $cms_mod[''value''][''9''];\r\n$mip_form[''9''][''cms_val_default''] = ''false'';\r\n$mip_form[''9''][''option_desc''][''0''] = ''Nein'';\r\n$mip_form[''9''][''option_val''][''0''] = ''false'';\r\n$mip_form[''9''][''option_desc''][''1''] = ''Ja'';\r\n$mip_form[''9''][''option_val''][''1''] = ''true'';\r\n$mip_form[''9''][''tab''] = ''0'';\r\n\r\n//Dateilinks -typen\r\n$mip_form[''10''][''desc''] = ''Dateitypen: '';\r\n$mip_form[''10''][''cat''] = ''app_filetype'';\r\n$mip_form[''10''][''output_cat''] = ''option'';\r\n$mip_form[''10''][''cms_var''] = ''MOD_VAR[10]'';\r\n$mip_form[''10''][''cms_val''] = $cms_mod[''value''][''10''];\r\n$mip_form[''10''][''flag''] = ''multiple'';\r\n$mip_form[''10''][''size''] = ''5'';\r\n\r\n//Bearbeitungsrecht Gruppen\r\n$mip_form[''11''][''desc''] = ''Bearbeitungsrecht (Gruppen): '';\r\n$mip_form[''11''][''cat''] = ''app_group'';\r\n$mip_form[''11''][''output_cat''] = ''option'';\r\n$mip_form[''11''][''cms_var''] = ''MOD_VAR[11]'';\r\n$mip_form[''11''][''cms_val''] = $cms_mod[''value''][''11''];\r\n$mip_form[''11''][''flag''] = ''multiple'';\r\n$mip_form[''11''][''size''] = ''5'';\r\n$mip_form[''11''][''cms_val_default''] = ''true'';\r\n\r\n// Template\r\n$mip_form[''12''][''desc''] = ''Template'';\r\n$mip_form[''12''][''cat''] = ''txtarea'';\r\n$mip_form[''12''][''rows''] = ''6'';\r\n$mip_form[''12''][''type''] = ''long'';\r\n$mip_form[''12''][''cms_var''] = ''MOD_VAR[12]'';\r\n$mip_form[''12''][''cms_val''] = $cms_mod[''value''][''12''];\r\n$mip_form[''12''][''cms_val_default''] = ''{wysiwyg2}'';\r\n\r\n//if simple mode\r\nif($cms_mod[''value''][''13''] == ''''){\r\n   foreach ($mip_form[''hide_in_standard_mode'']  AS $ke=>$va){\r\n     $mip_form[$va][''cat''] = ''hidden'';\r\n   }\r\n }\r\n\r\nmip_formsp($mip_form[''0'']);//formularname\r\nmip_formsp($mip_form[''1'']);//style\r\nmip_formsp($mip_form[''2'']);//erweitertes men\r\nmip_formsp($mip_form[''3'']);//features\r\nmip_formsp($mip_form[''4'']);//auswhlbare styles\r\nmip_formsp($mip_form[''5'']);//gfx folders\r\nmip_formsp($mip_form[''6'']);//gfx subfolder\r\nmip_formsp($mip_form[''7'']);//grafiktypen\r\nmip_formsp($mip_form[''8'']);//ordener dateilinks\r\nmip_formsp($mip_form[''9'']);//subfolder\r\nmip_formsp($mip_form[''10'']);//dateitypen\r\nmip_formsp($mip_form[''11'']);//gruppenrechte\r\nmip_formsp($mip_form[''12'']);//template\r\necho '' <small><b>Legende:</b><br> \r\nWYSIWYG- Editor: {wysiwyg2}<br>\r\nPhp-Code: &lt;?PHP echo "Ich bin gecachter phpcode!"; ?&gt;<br>\r\n&lt;CMSPHP&gt;echo "Ich bin ungecachter phpcode!";&lt;/CMSPHP&gt;</small>'';\r\n\r\n}\r\nunset($mip_form);\r\n\r\n?>', '<?PHP\r\n$myTplContent[''wysiwyg2''] = <cms:mod \r\ntype="wysiwyg2" \r\nid="1" \r\ntitle="MOD_VALUE[0]" \r\nstyleclass="MOD_VALUE[1]" \r\nmenuoptions="MOD_VALUE[2]" \r\nfeatures="MOD_VALUE[3]" \r\nselectablestyles = "MOD_VALUE[4]"\r\nimagefolders = "MOD_VALUE[5]"\r\nimagesubfolders ="MOD_VALUE[6]"\r\nimagefiletypes = "MOD_VALUE[7]" \r\nfilefolders = "MOD_VALUE[8]"\r\nfilesubfolders ="MOD_VALUE[9]"\r\nfilefiletypes = "MOD_VALUE[10]" \r\neditable = "MOD_VALUE[11]"\r\naddslashes="true" />;\r\n\r\n$myTplVars[''wysiwyg2''] = ''{wysiwyg2}'';\r\n$myTpl = "MOD_VALUE[12]";\r\n    \r\n$myTpl = str_replace($myTplVars, $myTplContent, $myTpl);\r\n\r\neval(''?>''.$myTpl); \r\nunset($myTpl, $myTplVars, $myLink);\r\n?>', '', 0, 1, 1, 1079916519, 1125070528, 'mod:d095bc10015c1aaa14189fcf842c8266:7d8a0ffd', '', '', '', 0, '0', '', '1');
INSERT INTO `cms_mod` VALUES (6, 'Bild', '1.2', 'Content', 'Erzeugt ein Bild', '<?PHP\r\n//configmode\r\n$mip_form[''10''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''10''][''cat''] = ''option'';\r\n$mip_form[''10''][''size''] = ''1'';\r\n$mip_form[''10''][''option_desc''][] = ''Normal'';\r\n$mip_form[''10''][''option_val''][] =  '''';\r\n$mip_form[''10''][''option_desc''][] = ''Erweitert'';\r\n$mip_form[''10''][''option_val''][] =  ''advanced'';\r\n$mip_form[''10''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''10''][''option_val''][] =  ''hidden'';\r\n$mip_form[''10''][''cms_var''] = ''MOD_VAR[10]'';\r\n$mip_form[''10''][''cms_val''] = $cms_mod[''value''][''10''];\r\n$mip_form[''10''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''10'']);//configmode\r\n$mip_form[''hide_in_standard_mode''] = array(0,5,6,7,8);\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''10''] == ''hidden''){\r\n  foreach($cms_mod[''value''] AS $ke=>$va){\r\n    if($ke != ''10''){\r\n    ?>\r\n      <input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n    <?php\r\n     }\r\n  }\r\n}\r\n//simple and advanced config\r\nelse if($cms_mod[''value''][''10''] == '''' || $cms_mod[''value''][''10''] == ''advanced''){\r\n\r\n\r\n//Formularname\r\n$mip_form[''0''][''cat''] = ''txt'';\r\n$mip_form[''0''][''type''] = '''';\r\n$mip_form[''0''][''desc''] = ''Formularfeldname'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''cms_val_default''] = ''Bild'';\r\n$mip_form[''0''][''tab''] = ''0'';\r\n\r\n//Style Beschreibung\r\n$mip_form[''4''][''desc''] = ''Stylesheet fr Bildbeschreibung '';\r\n$mip_form[''4''][''cat''] = ''app_css'';\r\n$mip_form[''4''][''output_cat''] = ''option'';\r\n$mip_form[''4''][''cms_var''] = ''MOD_VAR[4]'';\r\n$mip_form[''4''][''cms_val''] = $cms_mod[''value''][''4''];\r\n$mip_form[''4''][''flag''] = ''class_only'';\r\n\r\n//Dateitypen\r\n$mip_form[''5''][''desc''] = ''Dateitypen'';\r\n$mip_form[''5''][''cat''] = ''option'';\r\n$mip_form[''5''][''flag''] = ''multiple'';\r\n$mip_form[''5''][''size''] = ''5'';\r\n$mip_form[''5''][''cms_var''] = ''MOD_VAR[5]'';\r\n$mip_form[''5''][''cms_val''] = $cms_mod[''value''][''5''];\r\n$mip_form[''5''][''cms_val_default''] = ''true'';\r\n$mip_form[''5''][''option_desc''][''0''] = ''Alle verfgbaren Webgrafiken'';\r\n$mip_form[''5''][''option_val''][''0''] = ''true'';\r\n$mip_form[''5''][''option_desc''][''1''] = ''*.gif'';\r\n$mip_form[''5''][''option_val''][''1''] = ''gif'';\r\n$mip_form[''5''][''option_desc''][''2''] = ''*.jpg'';\r\n$mip_form[''5''][''option_val''][''2''] = ''jpg'';\r\n$mip_form[''5''][''option_desc''][''3''] = ''*.jpeg'';\r\n$mip_form[''5''][''option_val''][''3''] = ''jpeg'';\r\n$mip_form[''5''][''option_desc''][''4''] = ''*.png'';\r\n$mip_form[''5''][''option_val''][''4''] = ''png'';\r\n\r\n//Ordner\r\n$mip_form[''6''][''desc''] = ''Ordner: '';\r\n$mip_form[''6''][''cat''] = ''app_directory'';\r\n$mip_form[''6''][''output_cat''] = ''option'';\r\n$mip_form[''6''][''cms_var''] = ''MOD_VAR[6]'';\r\n$mip_form[''6''][''cms_val''] = $cms_mod[''value''][''6''];\r\n$mip_form[''6''][''flag''] = ''multiple'';\r\n$mip_form[''6''][''size''] = ''5'';\r\n\r\n//Unterordner anzeigen\r\n$mip_form[''7''][''cat''] = ''option'';\r\n$mip_form[''7''][''desc''] = ''Vorhandene Unterordner automatisch anzeigen'';\r\n$mip_form[''7''][''cms_var''] = ''MOD_VAR[7]'';\r\n$mip_form[''7''][''cms_val''] = $cms_mod[''value''][''7''];\r\n$mip_form[''7''][''cms_val_default''] = ''false'';\r\n$mip_form[''7''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''7''][''option_val''][''0''] = ''true'';\r\n$mip_form[''7''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''7''][''option_val''][''1''] = ''false'';\r\n$mip_form[''7''][''tab''] = ''0'';\r\n\r\n//Erweitertes Bearbeitungsmen\r\n$mip_form[''8''][''cat''] = ''radio'';\r\n$mip_form[''8''][''type''] = '''';\r\n$mip_form[''8''][''desc''] = ''Bearbeitungsmen<br>\r\n<small>Ein <b>normales Men</b> besteht aus der Schalflche "bearbeiten", das <b>erweiterte Men</b> \r\nbietet darberhinaus die Schaltflchen "neu, lschen, nach oben, nach unten". Wird <b>kein Men</b> gewhlt, ist der \r\nContent nicht editierbar.</small>'';\r\n$mip_form[''8''][''cms_var''] = ''MOD_VAR[8]'';\r\n$mip_form[''8''][''cms_val''] = $cms_mod[''value''][''8''];\r\n$mip_form[''8''][''cms_val_default''] = ''true'';\r\n$mip_form[''8''][''option_desc''][''0''] = ''Normales Men'';\r\n$mip_form[''8''][''option_val''][''0''] = ''true'';\r\n$mip_form[''8''][''option_desc''][''1''] = ''Erweitertes Men'';\r\n$mip_form[''8''][''option_val''][''1''] = ''advanced'';\r\n$mip_form[''8''][''option_desc''][''2''] = ''Kein Men'';\r\n$mip_form[''8''][''option_val''][''2''] = ''false'';\r\n$mip_form[''8''][''tab''] = ''0'';\r\n\r\n//beschreibung/ Legende\r\n$mip_form[''9''][''cat''] = ''desc'';\r\n$mip_form[''9''][''type''] = '''';\r\n$mip_form[''9''][''desc''] = '' <small><b>Legende:</b><br> \r\nBild: {image}, Bildbeschreibung {desc}, Dateigrsse {filesize}, Titel aus dem Dateimanager {fmtitle}, Beschreibung aus dem Dateimanager {fmdesc}, Stylesheet fr Bildbeschreibung: {style}<br />\r\nPhp-Code: &lt;?PHP echo "Ich bin gecachter phpcode! Ich werde immer nur dann neu generiert, wenn es eine<br />\r\nnderung auf der Seite gegeben hat"; ?&gt;<br />\r\n&lt;CMSPHP&gt; echo "Ich bin ungecachter phpcode! Ich werde bei jedem Aufruf der Seite ausgefhrt";&lt;/CMSPHP&gt;<br />\r\n</small>'';\r\n\r\n// Template\r\n$mip_form[''2''][''desc''] = ''Template'';\r\n$mip_form[''2''][''cat''] = ''txtarea'';\r\n$mip_form[''2''][''rows''] = ''6'';\r\n$mip_form[''2''][''type''] = ''long'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''cms_val_default''] = ''{image}'';\r\n\r\n//if simple mode\r\nif($cms_mod[''value''][''10''] == ''''){\r\n   foreach ($mip_form[''hide_in_standard_mode'']  AS $ke=>$va){\r\n     $mip_form[$va][''cat''] = ''hidden'';\r\n   }\r\n }\r\n\r\nmip_formsp($mip_form[''0'']);//Formularfeldname\r\nmip_formsp($mip_form[''4'']);//Style Beschreibung\r\nmip_formsp($mip_form[''5'']);//Dateitypen\r\nmip_formsp($mip_form[''6'']);//Ordner\r\nmip_formsp($mip_form[''7'']);//Unterordner anzeigen\r\nmip_formsp($mip_form[''8'']);//Men\r\nmip_formsp($mip_form[''2'']);//Template\r\nmip_formsp($mip_form[''9'']);//Legende\r\n\r\n}\r\nunset($mip_form);\r\n\r\n?>', '<?PHP\r\n$myImage[''style''] = "MOD_VALUE[4]";\r\n$myImage[''desc''] = <cms:mod type="image" id="1" mode="desc" addslashes="true" />;\r\n//Stylesheet fr Text hinzufgen\r\n$myImage[''desc''] = (  "MOD_VALUE[4]" == "") ? $myImage[''desc''] : ''<span class="MOD_VALUE[4]">''. $myImage[''desc''] .''</span>'';\r\n//Gibt es mehrere Tags, bei denen type und id gleich sind, ist es wichtig, dass das letzt "gleiche" Element alle erweiterten\r\n//Konfigurationsvariablen enthlt (z.B. folders, subfolders) . Den nur die Variablen des "letzten" Tags knnen im Formular\r\n//weiterverarbeitet werden. Andernfalls bleibt z.B. die Auswahl von bestimmten Dateitypen ohne Wirkung.\r\n$myImage[''fmtitle'']     = <cms:mod type="image" id="1" mode="fmtitle" addslashes="true" />;\r\n$myImage[''fmdesc'']      = <cms:mod type="image" id="1" mode="fmdesc" addslashes="true" />;\r\n$myImage[''filesize'']    = <cms:mod type="image" id="1" mode="filesize" addslashes="true" />;\r\n$myImage[''image'']       = <cms:mod type="image" id="1" title="MOD_VALUE[0]"  filetypes = "MOD_VALUE[5]" folders = "MOD_VALUE[6]" subfolders ="MOD_VALUE[7]" menuoptions ="MOD_VALUE[8]" addslashes="true" />;\r\n\r\n$myTplVars[''style'']     = ''{style}'';\r\n$myTplVars[''desc'']      = ''{desc}'';\r\n$myTplVars[''fmtitle'']   = ''{fmtitle}'';\r\n$myTplVars[''fmdesc'']    = ''{fmdesc}'';\r\n$myTplVars[''filesize'']  = ''{filesize}'';\r\n$myTplVars[''image'']     = ''{image}'';\r\n\r\n$myTpl = "MOD_VALUE[2]";\r\n\r\n$myTpl = str_replace($myTplVars, $myImage, $myTpl);\r\neval(''?>''.$myTpl); \r\nunset($myTpl, $myTplVars, $myImage);\r\n?>', '', 0, 1, 1, 1066927900, 1177010492, 'mod:bb21a2f11b3957f442f721fd6a9bcbd7:d91b784d', '', '', '', 0, '', '', '1');
INSERT INTO `cms_mod` VALUES (7, 'Link', '1.3', 'Content', 'Erzeugt einen Textlink', '<?PHP\r\n//configmode\r\n$mip_form[''13''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''13''][''cat''] = ''option'';\r\n$mip_form[''13''][''size''] = ''1'';\r\n$mip_form[''13''][''option_desc''][] = ''Normal'';\r\n$mip_form[''13''][''option_val''][] =  '''';\r\n$mip_form[''13''][''option_desc''][] = ''Erweitert'';\r\n$mip_form[''13''][''option_val''][] =  ''advanced'';\r\n$mip_form[''13''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''13''][''option_val''][] =  ''hidden'';\r\n$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n$mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n$mip_form[''13''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''13'']);//configmode\r\n$mip_form[''hide_in_standard_mode''] = array(0,2);\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''13''] == ''hidden''){\r\n  foreach($cms_mod[''value''] AS $ke=>$va){\r\n    if($ke != ''13''){\r\n    ?>\r\n      <input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n    <?php\r\n     }\r\n  }\r\n}\r\n//simple and advanced config\r\nelse if($cms_mod[''value''][''13''] == '''' || $cms_mod[''value''][''13''] == ''advanced''){\r\n\r\n\r\n//Formularname\r\n$mip_form[''0''][''cat''] = ''txt'';\r\n$mip_form[''0''][''type''] = '''';\r\n$mip_form[''0''][''desc''] = ''Formularfeldname'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''cms_val_default''] = ''Link'';\r\n$mip_form[''0''][''tab''] = ''0'';\r\n\r\n//Style\r\n$mip_form[''1''][''desc''] = $mod_lang[''gen_font''];\r\n$mip_form[''1''][''cat''] = ''app_css'';\r\n$mip_form[''1''][''output_cat''] = ''option'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''flag''] = ''class_only'';\r\n\r\n//Erweitertes Bearbeitungsmen\r\n$mip_form[''2''][''cat''] = ''radio'';\r\n$mip_form[''2''][''type''] = '''';\r\n$mip_form[''2''][''desc''] = ''Bearbeitungsmen<br>\r\n<small>Ein <b>normales Men</b> besteht aus der Schalflche "bearbeiten", das <b>erweiterte Men</b> \r\nbietet darberhinaus die Schaltflchen "neu, lschen, nach oben, nach unten". Wird <b>kein Men</b> gewhlt, ist der \r\nContent nicht editierbar.</small>'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''cms_val_default''] = ''true'';\r\n$mip_form[''2''][''option_desc''][''0''] = ''Normales Men'';\r\n$mip_form[''2''][''option_val''][''0''] = ''true'';\r\n$mip_form[''2''][''option_desc''][''1''] = ''Erweitertes Men'';\r\n$mip_form[''2''][''option_val''][''1''] = ''advanced'';\r\n$mip_form[''2''][''option_desc''][''2''] = ''Kein Men'';\r\n$mip_form[''2''][''option_val''][''2''] = ''false'';\r\n$mip_form[''2''][''tab''] = ''0'';\r\n\r\n// Template\r\n$mip_form[''3''][''desc''] = ''Template'';\r\n$mip_form[''3''][''cat''] = ''txtarea'';\r\n$mip_form[''3''][''rows''] = ''6'';\r\n$mip_form[''3''][''type''] = ''long'';\r\n$mip_form[''3''][''cms_var''] = ''MOD_VAR[3]'';\r\n$mip_form[''3''][''cms_val''] = $cms_mod[''value''][''3''];\r\n$mip_form[''3''][''cms_val_default''] = ''{textlink}'';\r\n\r\n//if simple mode\r\nif($cms_mod[''value''][''13''] == ''''){\r\n   foreach ($mip_form[''hide_in_standard_mode'']  AS $ke=>$va){\r\n     $mip_form[$va][''cat''] = ''hidden'';\r\n   }\r\n }\r\n\r\nmip_formsp($mip_form[''0'']);\r\nmip_formsp($mip_form[''1'']);\r\nmip_formsp($mip_form[''2'']);\r\nmip_formsp($mip_form[''3'']);\r\necho '' <small><b>Legende:</b><br> \r\nKompletter Textlink: {textlink}, Url: {url}, Beschreibung/Linkname: {desc}, Linkziel: {target}, Stylesheet: {style}<br>\r\nPhp-Code: &lt;?PHP echo "Ich bin gecachter phpcode! Ich werde immer nur dann neu generiert, wenn es eine<br>\r\nnderung auf der Seite gegeben hat"; ?&gt;<br>\r\n&lt;CMSPHP&gt; echo "Ich bin ungecachter phpcode! Ich werde bei jedem Aufruf der Seite ausgefhrt";&lt;/CMSPHP&gt;<br>\r\n</small>'';\r\n}\r\nunset($mip_form);\r\n?>', '<?PHP\r\n$myLink[''url''] = <cms:mod type="link" id="1" mode="url" addslashes="true" />;\r\n$myLink[''desc''] = <cms:mod type="link" id="1" mode="desc"  addslashes="true" />;\r\n$myLink[''target''] = <cms:mod type="link" id="1" mode="target" addslashes="true" />;\r\n$myLink[''style''] = "MOD_VALUE[1]";\r\n$myLink[''textlink''] = <cms:mod type="link" id="1" mode="textlink" styleclass="MOD_VALUE[1]" title="MOD_VALUE[0]" menuoptions="MOD_VALUE[2]" addslashes="true" />;\r\n\r\n$myTplVars[''url''] = ''{url}'';\r\n$myTplVars[''desc''] = ''{desc}'';\r\n$myTplVars[''target''] = ''{target}'';\r\n$myTplVars[''style''] = ''{style}'';\r\n$myTplVars[''textlink''] = ''{textlink}'';\r\n$myTpl = "MOD_VALUE[3]";\r\n    \r\n$myTpl = str_replace($myTplVars, $myLink, $myTpl);\r\n\r\neval(''?>''.$myTpl); \r\nunset($myTpl, $myTplVars, $myLink);\r\n?>\r\n', '', 0, 1, 1, 1066927900, 1125070381, 'mod:2a304a1348456ccd2234cd71a81bd338:c674bb5e', '', '', '', 0, '', '', '1');
INSERT INTO `cms_mod` VALUES (8, 'Dateilink', '1.1', 'Content', 'Es kann auf eine beliebige Datei gelinkt werden, die vom Dateimanger verwaltet wird', '<?PHP\r\n//configmode\r\n$mip_form[''13''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''13''][''cat''] = ''option'';\r\n$mip_form[''13''][''size''] = ''1'';\r\n$mip_form[''13''][''option_desc''][] = ''Normal'';\r\n$mip_form[''13''][''option_val''][] =  '''';\r\n$mip_form[''13''][''option_desc''][] = ''Erweitert'';\r\n$mip_form[''13''][''option_val''][] =  ''advanced'';\r\n$mip_form[''13''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''13''][''option_val''][] =  ''hidden'';\r\n$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n$mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n$mip_form[''13''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''13'']);//configmode\r\n$mip_form[''hide_in_standard_mode''] = array(0,2,4,5,6,7);\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''13''] == ''hidden''){\r\n  foreach($cms_mod[''value''] AS $ke=>$va){\r\n    if($ke != ''13''){\r\n    ?>\r\n      <input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n    <?php\r\n     }\r\n  }\r\n}\r\n//simple and advanced config\r\nelse if($cms_mod[''value''][''13''] == '''' || $cms_mod[''value''][''13''] == ''advanced''){\r\n\r\n\r\n//Formularname\r\n$mip_form[''0''][''cat''] = ''txt'';\r\n$mip_form[''0''][''type''] = '''';\r\n$mip_form[''0''][''desc''] = ''Formularfeldname'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''cms_val_default''] = ''Dateilink'';\r\n$mip_form[''0''][''tab''] = ''0'';\r\n\r\n//Style\r\n$mip_form[''1''][''desc''] = $mod_lang[''gen_font''];\r\n$mip_form[''1''][''cat''] = ''app_css'';\r\n$mip_form[''1''][''output_cat''] = ''option'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''flag''] = ''class_only'';\r\n\r\n//Dateitypen\r\n$mip_form[''4''][''desc''] = ''Dateitypen: '';\r\n$mip_form[''4''][''cat''] = ''app_filetype'';\r\n$mip_form[''4''][''output_cat''] = ''option'';\r\n$mip_form[''4''][''cms_var''] = ''MOD_VAR[4]'';\r\n$mip_form[''4''][''cms_val''] = $cms_mod[''value''][''4''];\r\n$mip_form[''4''][''flag''] = ''multiple'';\r\n$mip_form[''4''][''size''] = ''5'';\r\n\r\n//Ordner\r\n$mip_form[''5''][''desc''] = ''Ordner: '';\r\n$mip_form[''5''][''cat''] = ''app_directory'';\r\n$mip_form[''5''][''output_cat''] = ''option'';\r\n$mip_form[''5''][''cms_var''] = ''MOD_VAR[5]'';\r\n$mip_form[''5''][''cms_val''] = $cms_mod[''value''][''5''];\r\n$mip_form[''5''][''flag''] = ''multiple'';\r\n$mip_form[''5''][''size''] = ''5'';\r\n\r\n//Unterordner anzeigen\r\n$mip_form[''7''][''cat''] = ''option'';\r\n$mip_form[''7''][''desc''] = ''Vorhandene Unterordner automatisch anzeigen'';\r\n$mip_form[''7''][''cms_var''] = ''MOD_VAR[7]'';\r\n$mip_form[''7''][''cms_val''] = $cms_mod[''value''][''7''];\r\n$mip_form[''7''][''cms_val_default''] = ''false'';\r\n$mip_form[''7''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''7''][''option_val''][''0''] = ''true'';\r\n$mip_form[''7''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''7''][''option_val''][''1''] = ''false'';\r\n$mip_form[''7''][''tab''] = ''0'';\r\n\r\n//target verstecken\r\n$mip_form[''6''][''cat''] = ''option'';\r\n$mip_form[''6''][''type''] = '''';\r\n$mip_form[''6''][''desc''] = ''Im Bearbeitungsmodus Zielfensterfeld ausblenden'';\r\n$mip_form[''6''][''cms_var''] = ''MOD_VAR[6]'';\r\n$mip_form[''6''][''cms_val''] = $cms_mod[''value''][''6''];\r\n$mip_form[''6''][''cms_val_default''] = ''false'';\r\n$mip_form[''6''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''6''][''option_val''][''0''] = ''true'';\r\n$mip_form[''6''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''6''][''option_val''][''1''] = ''false'';\r\n$mip_form[''6''][''tab''] = ''0'';\r\n\r\n//Erweitertes Bearbeitungsmen\r\n$mip_form[''2''][''cat''] = ''radio'';\r\n$mip_form[''2''][''type''] = '''';\r\n$mip_form[''2''][''desc''] = ''Bearbeitungsmen<br>\r\n<small>Ein <b>normales Men</b> besteht aus der Schalflche "bearbeiten", das <b>erweiterte Men</b> \r\nbietet darberhinaus die Schaltflchen "neu, lschen, nach oben, nach unten". Wird <b>kein Men</b> gewhlt, ist der \r\nContent nicht editierbar.</small>'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''cms_val_default''] = ''true'';\r\n$mip_form[''2''][''option_desc''][''0''] = ''Normales Men'';\r\n$mip_form[''2''][''option_val''][''0''] = ''true'';\r\n$mip_form[''2''][''option_desc''][''1''] = ''Erweitertes Men'';\r\n$mip_form[''2''][''option_val''][''1''] = ''advanced'';\r\n$mip_form[''2''][''option_desc''][''2''] = ''Kein Men'';\r\n$mip_form[''2''][''option_val''][''2''] = ''false'';\r\n$mip_form[''2''][''tab''] = ''0'';\r\n\r\n// Template\r\n$mip_form[''3''][''desc''] = ''Template'';\r\n$mip_form[''3''][''cat''] = ''txtarea'';\r\n$mip_form[''3''][''rows''] = ''6'';\r\n$mip_form[''3''][''type''] = ''long'';\r\n$mip_form[''3''][''cms_var''] = ''MOD_VAR[3]'';\r\n$mip_form[''3''][''cms_val''] = $cms_mod[''value''][''3''];\r\n$mip_form[''3''][''cms_val_default''] = ''{filelink}'';\r\n\r\n//if simple mode\r\nif($cms_mod[''value''][''13''] == ''''){\r\n   foreach ($mip_form[''hide_in_standard_mode'']  AS $ke=>$va){\r\n     $mip_form[$va][''cat''] = ''hidden'';\r\n   }\r\n }\r\nmip_formsp($mip_form[''0'']);//Formularfeldname\r\nmip_formsp($mip_form[''1'']);//Style\r\nmip_formsp($mip_form[''4'']);//Dateitypen\r\nmip_formsp($mip_form[''5'']);//Ordner\r\nmip_formsp($mip_form[''7'']);//Unterordner anzeigen\r\nmip_formsp($mip_form[''6'']);//Target verstecken\r\nmip_formsp($mip_form[''2'']);//Men\r\nmip_formsp($mip_form[''3'']);//Template\r\necho '' <small><b>Legende:</b><br> \r\nKompletter Dateilink: {filelink}, URL: {url}, Dateipfad: {path}, Zielfenster: {target}, <br>\r\nid_upl der Datei aus Tabelle cms_upl {id}, Stylesheet: {style}<br>\r\nPhp-Code: &lt;?PHP echo "Ich bin gecachter phpcode! Ich werde immer nur dann neu generiert, wenn es eine <br>\r\nnderung auf der Seite gegeben hat"; ?&gt;<br>\r\n&lt;CMSPHP&gt; echo "Ich bin ungecachter phpcode! Ich werde bei jedem Aufruf der Seite ausgefhrt";&lt;/CMSPHP&gt;<br>\r\n</small>'';\r\n}\r\nunset($mip_form);\r\n\r\n?>', '<?PHP\r\n$myLink[''url''] = <cms:mod type="file" id="1" mode="url" addslashes="true" />;\r\n$myLink[''path''] = <cms:mod type="file" id="1" mode="path" addslashes="true" />;\r\n$myLink[''desc''] = <cms:mod type="file" id="1" mode="desc"  addslashes="true" />;\r\n$myLink[''target''] = <cms:mod type="file" id="1" mode="target" addslashes="true" />;\r\n$myLink[''id''] = <cms:mod type="file" id="1" mode="id" addslashes="true" />;\r\n$myLink[''style''] = "MOD_VALUE[1]";\r\n//Gibt es mehrere Tags, bei denen type und id gleich sind, ist es wichtig, dass das letzt "gleiche" Element alle erweiterten\r\n//Konfigurationsvariablen enthlt (z.B. folders, subfolders) . Den nur die Variablen des "letzten" Tags knnen im Formular\r\n//weiterverarbeitet werden. Andernfalls bleibt z.B. die Auswahl von bestimmten Dateitypen ohne Wirkung.\r\n$myLink[''filelink''] = <cms:mod type="file" id="1" title="MOD_VALUE[0]" styleclass="MOD_VALUE[1]" hidetarget ="MOD_VALUE[6]" folders = "MOD_VALUE[5]" subfolders ="MOD_VALUE[7]" filetypes = "MOD_VALUE[4]" menuoptions ="MOD_VALUE[2]" addslashes="true" />;\r\n\r\n$myTplVars[''url''] = ''{url}'';\r\n$myTplVars[''path''] = ''{path}'';\r\n$myTplVars[''desc''] = ''{desc}'';\r\n$myTplVars[''target''] = ''{target}'';\r\n$myTplVars[''id''] = ''{id}'';\r\n$myTplVars[''style''] = ''{style}'';\r\n$myTplVars[''filelink''] = ''{filelink}'';\r\n\r\n$myTpl = "MOD_VALUE[3]";\r\n    \r\n$myTpl = str_replace($myTplVars, $myLink, $myTpl);\r\n\r\neval(''?>''.$myTpl); \r\nunset($myTpl, $myTplVars, $myLink);\r\n?>\r\n', '', 0, 1, 1, 1066927900, 1125070356, 'mod:dfbc83af929dc44d0bb85fdef4ef3010:4e5865ad', '', '', '', 0, '', '', '1');
INSERT INTO `cms_mod` VALUES (9, 'Linkliste', '1.2', 'Contentliste', 'Fr eine nicht limitierte Anzahl von Links und Linkbeschreibungen', '<?PHP\r\n//configmode\r\n$mip_form[''13''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''13''][''cat''] = ''option'';\r\n$mip_form[''13''][''size''] = ''1'';\r\n$mip_form[''13''][''option_desc''][] = ''Normal'';\r\n$mip_form[''13''][''option_val''][] =  '''';\r\n$mip_form[''13''][''option_desc''][] = ''Erweitert'';\r\n$mip_form[''13''][''option_val''][] =  ''advanced'';\r\n$mip_form[''13''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''13''][''option_val''][] =  ''hidden'';\r\n$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n$mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n$mip_form[''13''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''13'']);//configmode\r\n$mip_form[''hide_in_standard_mode''] = array(0,2,4);\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''13''] == ''hidden''){\r\n  foreach($cms_mod[''value''] AS $ke=>$va){\r\n    if($ke != ''13''){\r\n    ?>\r\n      <input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n    <?php\r\n     }\r\n  }\r\n}\r\n//simple and advanced config\r\nelse if($cms_mod[''value''][''13''] == '''' || $cms_mod[''value''][''13''] == ''advanced''){\r\n\r\n//Formularname Link\r\n$mip_form[''0''][''cat''] = ''txt'';\r\n$mip_form[''0''][''type''] = '''';\r\n$mip_form[''0''][''desc''] = ''Formularfeldname Link'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''cms_val_default''] = ''Bitte geben Sie einen Link ein'';\r\n$mip_form[''0''][''tab''] = ''0'';\r\n\r\n//Style Link\r\n$mip_form[''1''][''desc''] = ''Stylesheet Link'';\r\n$mip_form[''1''][''cat''] = ''app_css'';\r\n$mip_form[''1''][''output_cat''] = ''option'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''flag''] = ''class_only'';\r\n\r\n//Formularname Linkbeschreibung\r\n$mip_form[''2''][''cat''] = ''txt'';\r\n$mip_form[''2''][''type''] = '''';\r\n$mip_form[''2''][''desc''] = ''Formularfeldname Linkbeschreibung'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''cms_val_default''] = ''Linkbeschreibung'';\r\n$mip_form[''2''][''tab''] = ''0'';\r\n\r\n//Style Linkbeschreibung\r\n$mip_form[''3''][''desc''] = ''Stylesheet Linkbeschreibung'';\r\n$mip_form[''3''][''cat''] = ''app_css'';\r\n$mip_form[''3''][''output_cat''] = ''option'';\r\n$mip_form[''3''][''cms_var''] = ''MOD_VAR[3]'';\r\n$mip_form[''3''][''cms_val''] = $cms_mod[''value''][''3''];\r\n$mip_form[''3''][''flag''] = ''class_only'';\r\n\r\n//Name des Layermenus\r\n$mip_form[''4''][''cat''] = ''txt'';\r\n$mip_form[''4''][''type''] = '''';\r\n$mip_form[''4''][''desc''] = ''Menname'';\r\n$mip_form[''4''][''cms_var''] = ''MOD_VAR[4]'';\r\n$mip_form[''4''][''cms_val''] = $cms_mod[''value''][''4''];\r\n$mip_form[''4''][''cms_val_default''] = ''Linklisteneintrag'';\r\n$mip_form[''4''][''tab''] = ''0'';\r\n\r\n\r\n// Template\r\n$mip_form[''5''][''desc''] = ''Template<small>Mgliche Templatevariablen: {link}, {desc}, {editbutton}</small>'';\r\n$mip_form[''5''][''cat''] = ''txtarea'';\r\n$mip_form[''5''][''rows''] = ''6'';\r\n$mip_form[''5''][''type''] = ''long'';\r\n$mip_form[''5''][''cms_var''] = ''MOD_VAR[5]'';\r\n$mip_form[''5''][''cms_val''] = $cms_mod[''value''][''5''];\r\n$mip_form[''5''][''cms_val_default''] = ''<table width="100%" align="center" border="0" cellspacing="1" cellpadding="2" bgcolor="#BBC2CE" >\r\n  <tr height="20">\r\n    <td bgcolor="#E5E8EB" valign="middle" >\r\n       {editbutton}{link}\r\n     </td>\r\n  </tr>\r\n  <tr height="40" valign="top">\r\n    <td bgcolor="#FFFFFF" >\r\n      {desc}\r\n    </td>\r\n  </tr>\r\n</table>\r\n<br>'';\r\n\r\n//if simple mode\r\nif($cms_mod[''value''][''13''] == ''''){\r\n   foreach ($mip_form[''hide_in_standard_mode'']  AS $ke=>$va){\r\n     $mip_form[$va][''cat''] = ''hidden'';\r\n   }\r\n }\r\nmip_formsp($mip_form[''4'']);\r\nmip_formsp($mip_form[''0'']);\r\nmip_formsp($mip_form[''2'']);\r\nmip_formsp($mip_form[''1'']);\r\nmip_formsp($mip_form[''3'']);\r\nmip_formsp($mip_form[''5'']);\r\n}\r\nunset($mip_form);\r\n?>', '<CMSPHP:CACHE>\r\n$myList[''link''] = <cms:mod type="link" id="1" menuoptions="false" title="MOD_VALUE[0]" styleclass="MOD_VALUE[1]" addslashes="true" />;\r\n$myList[''desc''] = <cms:mod type="textarea" id="1" menuoptions="false" title="MOD_VALUE[2]" styleclass="MOD_VALUE[3]" addslashes="true" />;\r\n$myList[''editbutton''] = <cms:mod type="typegroup" elements="link[1],textarea[1]" menuoptions="advanced" title="MOD_VALUE[4]" addslashes="true" />;\r\n\r\n$myTplVars[''link''] = ''{link}'';\r\n$myTplVars[''desc''] = ''{desc}'';\r\n$myTplVars[''editbutton''] = ''{editbutton}'';\r\n$myTpl = "MOD_VALUE[5]";\r\n    \r\n$myTpl = str_replace($myTplVars, $myList, $myTpl);\r\n\r\neval(''?>''.$myTpl); \r\nunset($myTpl, $myTplVars, $myList);\r\n</CMSPHP:CACHE>', '', 0, 1, 1, 1066927900, 1125073727, 'mod:99663ed64b93be0047d7fedfdc8f0efe:f2cf9446', '', '', '', 0, '', '', '1');
INSERT INTO `cms_mod` VALUES (10, 'URHere', '1.1.1', 'Navigation', 'Horizontale Pfad- Navigation in der Atrt von Oberpunkt -> Unterpunkt -> Unterpunkt', '<?PHP\r\n//Schriftart\r\n$mip_form[''0''][''desc''] = ''Schriftart Links {font1}'';\r\n$mip_form[''0''][''cat''] = ''app_css'';\r\n$mip_form[''0''][''output_cat''] = ''option'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''cms_val_default''] = '''';\r\n$mip_form[''0''][''type''] = '''';\r\n\r\n//Schriftart\r\n$mip_form[''1''][''desc''] = ''Schritart  Non-Links {font1}'';\r\n$mip_form[''1''][''cat''] = ''app_css'';\r\n$mip_form[''1''][''output_cat''] = ''option'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''cms_val_default''] = '''';\r\n$mip_form[''1''][''type''] = '''';\r\n\r\n//Schriftart Trennzeichen\r\n$mip_form[''2''][''desc''] = ''Schriftart des Trennzeichens {font2}'';\r\n$mip_form[''2''][''cat''] = ''app_css'';\r\n$mip_form[''2''][''output_cat''] = ''option'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''cms_val_default''] = '''';\r\n$mip_form[''2''][''type''] = '''';\r\n\r\n\r\n//Mit Ebene 0\r\n$mip_form[''3''][''desc''] = ''Ebene 0 mit anzeigen? (1. Ordner)'';\r\n$mip_form[''3''][''cat''] = ''chk'';\r\n$mip_form[''3''][''option_var''][''0''] = ''MOD_VAR[3]'';\r\n$mip_form[''3''][''option_val''][''0''] = $cms_mod[''value''][''3''];\r\n$mip_form[''3''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''3''][''option_val_select''][''0''] = ''true'';\r\n\r\n//Mit aktueller Seite\r\n$mip_form[''4''][''desc''] = ''aktuelle Seite mit anzeigen?'';\r\n$mip_form[''4''][''cat''] = ''chk'';\r\n$mip_form[''4''][''option_var''][''0''] = ''MOD_VAR[4]'';\r\n$mip_form[''4''][''option_val''][''0''] = $cms_mod[''value''][''4''];\r\n$mip_form[''4''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''4''][''option_val_select''][''0''] = ''true'';\r\n\r\n//aktuelle Seite als Link?\r\n$mip_form[''5''][''desc''] = ''aktuelle Seite als Link anzeigen?'';\r\n$mip_form[''5''][''cat''] = ''chk'';\r\n$mip_form[''5''][''option_var''][''0''] = ''MOD_VAR[5]'';\r\n$mip_form[''5''][''option_val''][''0''] = $cms_mod[''value''][''5''];\r\n$mip_form[''5''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''5''][''option_val_select''][''0''] = ''true'';\r\n\r\n//Startseiten ausblenden?\r\n$mip_form[''8''][''desc''] = ''Startseiten ausblenden?'';\r\n$mip_form[''8''][''cat''] = ''chk'';\r\n$mip_form[''8''][''option_var''][''0''] = ''MOD_VAR[8]'';\r\n$mip_form[''8''][''option_val''][''0''] = $cms_mod[''value''][''8''];\r\n$mip_form[''8''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''8''][''option_val_select''][''0''] = ''true'';\r\n\r\n// Trennsymbol\r\n$mip_form[''6''][''desc''] = ''Trennzeichen zwischen Links'';\r\n$mip_form[''6''][''cat''] = ''txt'';\r\n$mip_form[''6''][''cms_var''] = ''MOD_VAR[6]'';\r\n$mip_form[''6''][''cms_val''] = $cms_mod[''value''][''6''];\r\n$mip_form[''6''][''cms_val_default''] = '' &rArr; '';\r\n\r\n//Ausgaben umkehren\r\n$mip_form[''10''][''desc''] = ''Ausgaben umkehren'';\r\n$mip_form[''10''][''cat''] = ''chk'';\r\n$mip_form[''10''][''option_var''][''0''] = ''MOD_VAR[10]'';\r\n$mip_form[''10''][''option_val''][''0''] = $cms_mod[''value''][''10''];\r\n$mip_form[''10''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''10''][''option_val_select''][''0''] = ''true'';\r\n\r\n// Template der Links\r\n$mip_form[''9''][''cat''] = ''txtarea'';\r\n$mip_form[''9''][''type''] = ''long'';\r\n$mip_form[''9''][''rows''] = ''1'';\r\n$mip_form[''9''][''desc''] = ''Link-Template <small>{name}, {link}, {font1}</small>'';\r\n$mip_form[''9''][''cms_var''] = ''MOD_VAR[9]'';\r\n$mip_form[''9''][''cms_val''] = $cms_mod[''value''][''9''];\r\n$mip_form[''9''][''cms_val_default''] = ''<a href="{link}" class="{font1}">{name}</a>'';\r\n\r\n// Gesamt - Template\r\n$mip_form[''7''][''cat''] = ''txtarea'';\r\n$mip_form[''7''][''type''] = ''long'';\r\n$mip_form[''7''][''rows''] = ''1'';\r\n$mip_form[''7''][''desc''] = ''Template <small>{nav}</small>'';\r\n$mip_form[''7''][''cms_var''] = ''MOD_VAR[7]'';\r\n$mip_form[''7''][''cms_val''] = $cms_mod[''value''][''7''];\r\n$mip_form[''7''][''cms_val_default''] = ''<nobr>{nav}</nobr>'';\r\n\r\n\r\nmip_formsp($mip_form[''0'']);\r\nmip_formsp($mip_form[''1'']);\r\nmip_formsp($mip_form[''2'']);\r\nmip_formsp($mip_form[''3'']);\r\nmip_formsp($mip_form[''4'']);\r\nmip_formsp($mip_form[''5'']);\r\nmip_formsp($mip_form[''8'']);\r\nmip_formsp($mip_form[''6'']);\r\nmip_formsp($mip_form[''10'']);\r\nmip_formsp($mip_form[''9'']);\r\nmip_formsp($mip_form[''7'']);\r\nunset($mip_form);\r\n?>', '<CMSPHP>\r\n$a = $idcat;\r\n$mod[''path''] = array();\r\n\r\nwhile($a > 0 && $catlist_level[$a] > 0){\r\n	array_push($mod[''path''],$a);\r\n	$a = $con_tree[$a][''parent''];\r\n}\r\nif("MOD_VALUE[3]" == ''true'') { array_push($mod[''path''],$a); };\r\n\r\n$mod[''rpath''] = array_reverse($mod[''path'']);\r\n$mod[''array''] = array();\r\nforeach ($mod[''rpath''] as $a){\r\n	$mod[''tmp''] = str_replace("{font1}","MOD_VALUE[0]","MOD_VALUE[9]");\r\n	$mod[''tmp''] = str_replace("{name}",$con_tree[$a][''name''],$mod[''tmp'']);\r\n	$mod[''tmp''] = str_replace("{link}",$con_tree[$a][''link''],$mod[''tmp'']);\r\n	array_push($mod[''array''] , $mod[''tmp'']);\r\n};\r\nif("MOD_VALUE[4]" == ''true'') {\r\n	if ("MOD_VALUE[8]" != ''true'' || $con_side[$idcatside][''is_start''] != ''1'') {\r\n		if("MOD_VALUE[5]" == ''true''){\r\n			$mod[''tmp''] = str_replace("{font1}","MOD_VALUE[0]","MOD_VALUE[9]");\r\n			$mod[''tmp''] = str_replace("{name}",$con_side[$idcatside][''name''],$mod[''tmp'']);\r\n			$mod[''tmp''] = str_replace("{link}",$con_side[$idcatside][''link''],$mod[''tmp'']);\r\n		} else {\r\n			$mod[''tmp''] = $con_side[$idcatside][''name''];\r\n		};\r\n		array_push($mod[''array''], $mod[''tmp'']);\r\n	};\r\n};\r\n\r\nif("MOD_VALUE[10]" == ''true'') { $mod[''array''] = array_reverse($mod[''array'']); };\r\n$mod[''output''] = implode("MOD_VALUE[6]", $mod[''array'']);\r\necho str_replace(''{nav}'', $mod[''output''], "MOD_VALUE[7]");\r\n\r\nunset($a, $mod);\r\n</CMSPHP>', '', 0, 1, 1, 1122308829, 1156774073, 'mod:f85bd11a7839e81e5e787bee97693b9a:8dd6fb04', '', '', '', 0, '0', '', '1');
INSERT INTO `cms_mod` VALUES (11, 'Druckversion', '1.3', 'System', 'Das Modul ermglicht es einzelne Container auszuwhlen und deren Inhalte innerhalb eines eigenen Templates ohne Verwendung des erstellten Layouts asszugeben.', '<?php\r\n// (c) 2004 -2005 by Bjrn Brockmann\r\n// based on code by P. Eppner\r\n\r\n//changelog\r\n// V 1.0\r\n// - FEATURE: add Templatemechanismen for links\r\n// V 1.0.1 (4.10.2004)\r\n// - FIX: get paramet will be parsed in print- version link\r\n// - FEATURE: add {idcatside} parameter\r\n// V 1.1 (7.4.2005)\r\n// - FEATURE: manuel container config possible\r\n// - FEATURE: show container ID after containerselect\r\n\r\n\r\n\r\n\r\n//valref\r\n//13 configmode\r\n\r\n//0 container from sideconfig\r\n//1 tpl print\r\n//2 tpl link\r\n//3 option container from sidetpl/ container manuel \r\n//4 container manuel\r\n\r\n\r\n//configmode\r\n$mip_form[''13''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''13''][''cat''] = ''option'';\r\n$mip_form[''13''][''size''] = ''1'';\r\n$mip_form[''13''][''option_val''][] =  '''';\r\n$mip_form[''13''][''option_desc''][] = ''Normal'';\r\n$mip_form[''13''][''option_desc''][] = ''Erweitert'';\r\n$mip_form[''13''][''option_val''][] =  ''advanced'';\r\n$mip_form[''13''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''13''][''option_val''][] =  ''hidden'';\r\n$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n$mip_form[''13''][''cms_val''] = $dedi_mod[''value''][''13''];\r\n$mip_form[''13''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''13'']);//configmode\r\n$mip_form[''hide_in_standard_mode''] = array(1,2);\r\n\r\n//hidden config\r\nif($dedi_mod[''value''][''13''] == ''hidden''){\r\n  foreach($dedi_mod[''value''] AS $ke=>$va){\r\n    if($ke != ''13''){\r\n    ?>\r\n      <input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n    <?php\r\n     }\r\n  }\r\n}\r\n//simple and advanced config\r\nelse if($dedi_mod[''value''][''13''] == '''' || $dedi_mod[''value''][''13''] == ''advanced''){\r\n\r\n// Container auswhlen\r\n$mip_form[''4''][''cat''] = ''txt'';\r\n$mip_form[''4''][''type''] = ''radio''; \r\n$mip_form[''4''][''desc''] = ''Container manuell einstellen<br />\r\n<small>Containerids kommasepariert eingeben (z.B.: 1,2,3)</small>'';\r\n$mip_form[''4''][''radio_var''] = ''MOD_VAR[3]'';\r\n$mip_form[''4''][''radio_val''] = $dedi_mod[''value''][''3'']; \r\n$mip_form[''4''][''radio_user_val''] = ''manuel'';\r\n$mip_form[''4''][''radio_val_default''] = ''manuel'';\r\n$mip_form[''4''][''cms_var''] = ''MOD_VAR[4]'';\r\n$mip_form[''4''][''cms_val''] = $dedi_mod[''value''][''4'']; \r\n$mip_form[''4''][''cms_val_default''] = '''';\r\n$mip_form[''4''][''tab''] = ''0'';\r\n\r\n$config[''number''] = 0;\r\n$mip_form[''0''][''desc''] = ''Container, welche angezeigt werden sollen:<br />\r\n<small>Diese Option ist nicht in der Modulkonfiguration anwendbar'';\r\n$mip_form[''0''][''cat''] = ''option'';\r\n$mip_form[''0''][''type''] = ''radio'';\r\n$mip_form[''0''][''radio_var''] = ''MOD_VAR[3]'';\r\n$mip_form[''0''][''radio_val''] = $dedi_mod[''value''][''3''];\r\n$mip_form[''0''][''radio_user_val''] = ''sidetpl'';\r\n$mip_form[''0''][''flag''] = ''multiple'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $dedi_mod[''value''][''0''];\r\n//print_r($list);\r\nif (! empty($list[''id''][''0''])){\r\n	$mip_form[''0''][''size''] = ''5'';\r\n	foreach ($list[''id''] as $config[''value'']) {\r\n		$config[''_container_name''] = !empty($list[$config[''value'']][''title'']) ? $list[$config[''value'']][''title''] .'' (ID: ''.$config[''value''].'')'': $config[''value''].''&nbsp;''.$dedi_lang[''tpl_container''];\r\n		$mip_form[''0''][''option_desc''][$config[''number'']] = $config[''_container_name''];\r\n		$mip_form[''0''][''option_val''][$config[''number'']] = $config[''value''];\r\n		$config[''number''] = $config[''number'']+1;\r\n	}\r\n} else{\r\n	$mip_form[''0''][''size''] = ''2'';\r\n	$mip_form[''0''][''option_desc''][''0''] = ''Konfiguration nur im Template mglich!'';\r\n	$mip_form[''0''][''option_val''][''0''] = '''';\r\n}\r\n\r\n\r\n\r\n// Template\r\n$mip_form[''1''][''desc''] = ''Block fr Druckversionlayout<br>\r\n<small>Mgliche Blockvariablen:<br> angezeigte Container: {head}, {inhalt}, {basehref}</small>'';\r\n$mip_form[''1''][''cat''] = ''txtarea'';\r\n$mip_form[''1''][''rows''] = ''6'';\r\n$mip_form[''1''][''type''] = ''long'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $dedi_mod[''value''][''1''];\r\n$mip_form[''1''][''cms_val_default''] = ''<html>\r\n<head>\r\n{head}\r\n</head>\r\n<body>\r\n{inhalt}\r\n</body>\r\n</html>'';\r\n\r\n// Template\r\n$mip_form[''2''][''desc''] = ''Block fr Druckversionlinks<br>\r\n<small>Mgliche Blockvariablen: Url zur Druckversion: {url}, Idcatside der aktuellen Seite: {idcatside}</small>'';\r\n$mip_form[''2''][''cat''] = ''txtarea'';\r\n$mip_form[''2''][''rows''] = ''6'';\r\n$mip_form[''2''][''type''] = ''long'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $dedi_mod[''value''][''2''];\r\n$mip_form[''2''][''cms_val_default''] = ''<a href="{url}" target="_blank">Druckversion</a>'';\r\n\r\n//if simple mode\r\nif($dedi_mod[''value''][''13''] == ''''){\r\n   foreach ($mip_form[''hide_in_standard_mode'']  AS $ke=>$va){\r\n     $mip_form[$va][''cat''] = ''hidden'';\r\n   }\r\n }\r\n\r\nmip_formsp($mip_form[''4'']);\r\nmip_formsp($mip_form[''0'']);\r\nmip_formsp($mip_form[''1'']);\r\nmip_formsp($mip_form[''2'']);\r\n\r\n}\r\nunset($mip_form, $config);\r\n?>', '<CMSPHP>\r\nif(${''mod''.$cms_mod[''container''][''id''].''_''.$cms_mod[''modul''][''id'']} == ''print'') {\r\n	// Druckversionsausgabe\r\n	<?PHP\r\n	$cms_mod[''value''][''4''] = str_replace('' '', '''', $cms_mod[''value''][''4'']);\r\n	$mod[''print_ids''] = ($cms_mod[''value''][''3''] == ''manuel'') ? $cms_mod[''value''][''4'']: $cms_mod[''value''][''0''];\r\n	$mod[''tpl_copy''] = $cms_mod[''value''][''1''];\r\n\r\n//basehref\r\n$mod[''tpl_copy''] = str_replace(''{basehref}'', ''$print_basehref'', $mod[''tpl_copy'']);\r\n$mod[''tpl_copy''] = str_replace(''{head}'', ''$print_head'', $mod[''tpl_copy'']);\r\n$mod[''tpl_copy''] = str_replace(''{inhalt}'', ''$print_area'', $mod[''tpl_copy'']);\r\n\r\n	// {head} ersetzen\r\n//        $mod[''tpl_copy''] = substr_replace ($mod[''tpl_copy''], ''$print_head'', $mod[''tpl_pos'']-1, 6);\r\n//	while ($mod[''tpl_pos''] = strpos ('' ''.$mod[''tpl_copy''], ''{head}'')){\r\n//		$mod[''tpl_copy''] = substr_replace ($mod[''tpl_copy''], ''$print_head'', $mod[''tpl_pos'']-1, 6);\r\n//	}\r\n\r\n	// {inhalt} ersetzen\r\n//	while ($mod[''tpl_pos''] = strpos ('' ''.$mod[''tpl_copy''], ''{inhalt}'')){\r\n//		$mod[''tpl_copy''] = substr_replace ($mod[''tpl_copy''], ''$print_area'', $mod[''tpl_pos'']-1, 8);\r\n//	}\r\n	?>\r\n        $mod[''manipulate_output''] = ''$print_basehref = htmlspecialchars(str_replace(\\''{%http_host}\\'',  $_SERVER[\\''HTTP_HOST\\''], $cfg_client[\\''url_rewrite_basepath\\'']), ENT_COMPAT, \\''utf-8\\'');'';\r\n\r\n	$mod[''manipulate_output''] .= ''$print_cont = explode(\\'',\\'', \\''<?PHP echo $mod[''print_ids'']; ?>\\'');'';\r\n	$mod[''manipulate_output''] .= ''$print_area = \\''\\'';'';\r\n	$mod[''manipulate_output''] .= ''if (is_array($print_cont)) {'';\r\n	$mod[''manipulate_output''] .= ''	foreach ($print_cont as $cont_nr) {'';\r\n	$mod[''manipulate_output''] .= ''		$start = strpos($output, "<!--START $cont_nr//-->");'';\r\n	$mod[''manipulate_output''] .= ''		$ende = strpos($output, "<!--END $cont_nr//-->");'';\r\n	$mod[''manipulate_output''] .= ''		$ende = $ende - $start;'';\r\n	$mod[''manipulate_output''] .= ''		$print_area .= substr($output, $start, $ende);'';\r\n	$mod[''manipulate_output''] .= ''	}'';\r\n	$mod[''manipulate_output''] .= ''}'';\r\n\r\n	$mod[''manipulate_output''] .= ''$start = strpos($output, "<!--START head//-->");'';\r\n	$mod[''manipulate_output''] .= ''$ende = strpos($output, "<!--END head//-->");'';\r\n	$mod[''manipulate_output''] .= ''$ende = $ende - $start;'';\r\n	$mod[''manipulate_output''] .= ''$print_head .= substr($output, $start, $ende);'';\r\n	$mod[''manipulate_output''] .= ''$output = "<?PHP echo addslashes($mod[''tpl_copy'']); ?>";'';\r\n	$cfg_client[''manipulate_output''] = $mod[''manipulate_output''].$cfg_client[''manipulate_output''];\r\n} else {\r\n// Druckversions Link\r\n	$mod[''print_call''] = ''mod''.$cms_mod[''container''][''id''].''_''.$cms_mod[''modul''][''id''];\r\n	$mod[''extra_parms''] = array();\r\n	foreach($_GET AS $k => $v){\r\n		switch($k){\r\n			case ''lang'':\r\n			case ''idcatside'':\r\n			case ''idcat'':\r\n			case ''sf_rewrite'':\r\n			case $mod[''print_call'']:\r\n				break;\r\n			default:\r\n				array_push($mod[''extra_parms''], $k.''=''.$v);\r\n				break;\r\n\r\n		}\r\n	}\r\n	if($mod[''final_extra_pams''] = implode("&amp;", $mod[''extra_parms''])) \r\n		$mod[''final_extra_pams''] = ''&amp;''.$mod[''final_extra_pams''];\r\n	else\r\n		$mod[''final_extra_pams''] = '''';\r\n\r\n	$mod[''tpl_link''] = str_replace(''{url}'', $con_side[$idcatside][''link''].''&amp;''.$mod[''print_call''].''=print''. $mod[''final_extra_pams''], "MOD_VALUE[2]");\r\n		 $mod[''tpl_link''] = str_replace(''{idcatside}'', $idcatside, $mod[''tpl_link'']);\r\n		 echo $mod[''tpl_link''];\r\n}\r\nunset($mod);\r\n</CMSPHP>', '', 0, 1, 1, 1122304080, 1156773689, 'mod:88953b0f14170e8ce929064e618b2ff7:ad72caaa', '', '', '', 0, '0', '', '1');
INSERT INTO `cms_mod` VALUES (12, 'Kontaktformular', '2.2', 'Interaktion', 'Erstellung eines Kontaktformulars mit beliebig vielen Feldern. XHTML- konform ', '<?php\r\n$is_dev = false;\r\n\r\nif($is_dev) {\r\ninclude "C:/Programme/xampp/htdocs/sefrengo_dev/moddev/kontakformularIN.php";\r\n//include "C:/_server/www/_sefrengo/mod_dev/Kontaktformular/config.php";\r\n} else{\r\n\r\n\r\n//val ref\r\n//0-9 system reserved\r\n//0 Anzahl Formularelemente \r\n//1 switch Elemente hinzufgen/ entfernen\r\n//\r\n//10-99 common config vars\r\n//10 configmode \r\n//11 subject in mail\r\n//12 emailadress empfnger manuell\r\n//13 fehler\r\n//14 erfolgreich verschickt\r\n//15 style fehler	\r\n//16 style besttigung\r\n//17 style label\r\n//18 style label fehler\r\n//19 style text\r\n//20 style textarea\r\n//21 style select\r\n//22 style checkbox\r\n//23 style submitbutton\r\n//24 beschriftung submitbutton\r\n//25 tpl gesamt\r\n//26 tpl elementcontainer nr1\r\n//27 Absenderadresse\r\n//28 Mit fieldset (ENFERNT)\r\n//29 Fieldset Beschriftung Legend (ENTFERNT)\r\n//31 style password (neu)\r\n//32 style optionMutiple (neu)\r\n//33 style radio (neu)\r\n//34 style label (neu)\r\n//35 style locumtenency/ platzhalter (neu)\r\n//36 trennersymbol werte (neu)\r\n//37 trennersymbol key, value (8)\r\n//38 tpl usermessage (neu)\r\n//39 tpl form start (neu)\r\n//40 tpl form end (neu)\r\n//41 email to switch (neu)\r\n//42 tpl platzhalter (neu)\r\n//43 tpl element fehlermedung (neu2)\r\n//44 debug  (neu2)\r\n//45 \r\n//46 tpl elementcontainer nr2 (neu2)\r\n//47 upload fileextensions  (neu2)\r\n//48 upload maxsize (neu2)\r\n//49 upload error fileextension (neu2)\r\n//50 upload error maxfilesize (neu2)\r\n//51 upload error intern (neu2)\r\n//52 style upload (neu2)\r\n//53 style custom error (neu2)\r\n//54 fallback {textfromdynamic}(3)\r\n//55 fallback {textareafromdynamic}(3)\r\n//56 tpl email (4)\r\n//57 txt email cc  (#gruppe, +user, email@something.de) (5)\r\n//58 txt email bcc (#gruppe, +user, email@something.de) (5)\r\n//59 select daten in db speichern ja, nein (5)\r\n//60 txt default gruppen identifier (5)\r\n//61 select Dateiuploads im Dateisystem ablegen: Nein, Ja - gleichlautene Dateien werden berschrieben, \r\n//                                               Ja - gleichlautenen Dateien werden umbenannt (5)\r\n//62 select Ordner fr Uploads  (5)\r\n//63 select Formulareingaben mitloggen ja/ nein (5)\r\n//64 txt logfile relativ vom frontend aus, default logs/ (5)\r\n//65 select emails versenden ja, nein (5)\r\n//66 tpl elementcontainer3 (8)\r\n\r\n//67 txt weiterleitung bei erfogreichen formularversand (6)\r\n//68 txt Weitere Email verschicken nein|ja (6)\r\n//69 txt Weitere Email subject (6)\r\n//70 txt Weitere Email template (6)\r\n//71 select gespeicherte db werte sind online|offline (6)\r\n//72 txt addon path||classname (6)\r\n\r\n//73 txt captchaimage length (7)\r\n//74 txt captchaimage width (7)\r\n//75 txt captchaimage height (7)\r\n//76 txt captchaimage attributes (7)\r\n//77 txt captchaimage styleset (7)\r\n//78 txtarea captchaimage template (7)\r\n//79 select captchaimage textfield (7)\r\n//80 txt additional emailaress sender (7)\r\n//81 txt additional emailaress recipient (7)\r\n//82 txt tpl required notice (8)\r\n//83 txt tpl label within required notice (8)\r\n\r\n\r\n//86 tpl elementcontainer4 (8)\r\n\r\n//NEXT version\r\n//freie positionierung der formularelemente\r\n\r\n//100-1000 form config vars - in 20 Schritten\r\n//n+0 aktiv\r\n//n+1 type\r\n//n+2 label\r\n//n+3 default\r\n//n+4 validate\r\n//n+5 attributes label\r\n//n+6 attributes formelement\r\n//n+7 custom element- error\r\n//n+8 select tpl elementcontainer\r\n//-----------------------------\r\n		\r\n//configmode\r\n$mip_form[''10''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''10''][''cat''] = ''option'';\r\n$mip_form[''10''][''size''] = ''1'';\r\n$mip_form[''10''][''option_desc''][] = ''Normal'';\r\n$mip_form[''10''][''option_val''][] =  '''';\r\n$mip_form[''10''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''10''][''option_val''][] =  ''hidden'';\r\n$mip_form[''10''][''cms_var''] = ''MOD_VAR[10]'';\r\n$mip_form[''10''][''cms_val''] = $cms_mod[''value''][''10''];\r\n$mip_form[''10''][''flag''] = ''reload'';\r\n\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''10''] == ''hidden''){\r\n	mip_formsp($mip_form[''10'']);//configmode\r\n	foreach($cms_mod[''value''] AS $ke=>$va){\r\n		if($ke != ''10''){\r\n			?>\r\n			<input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n			<?php\r\n		}\r\n	}\r\n//normal config\r\n} else {\r\n	// Anzahl der Spalten\r\n	if ($cms_mod[''value''][''0''] == '''' || $cms_mod[''value''][''0''] <= ''0'') $cms_mod[''value''][''0''] = 3;\r\n	if ($cms_mod[''value''][''1''] != ''0'') $cms_mod[''value''][''0''] = (int) $cms_mod[''value''][''0'']+ $cms_mod[''value''][''1''];\r\n	$mip_form[''0''][''cat''] = ''hidden'';\r\n	$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n	$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n\r\n	$mip_form[''44''][''cat''] = ''option'';\r\n	$mip_form[''44''][''desc''] = ''Debugmodus<br />\r\n<small>Ausgabe von Debugmeldungen<br><br></small>'';\r\n	$mip_form[''44''][''size''] = ''1'';\r\n	$mip_form[''44''][''option_desc''][] = ''nein'';\r\n	$mip_form[''44''][''option_val''][] =  ''false'';\r\n	$mip_form[''44''][''option_desc''][] = ''ja'';\r\n	$mip_form[''44''][''option_val''][] =  ''true'';\r\n	$mip_form[''44''][''cms_var''] = ''MOD_VAR[''.''44''.'']'';\r\n	$mip_form[''44''][''cms_val''] = $cms_mod[''value''][''44''];\r\n	\r\n	$mip_form[''63''][''cat''] = ''option'';\r\n	$mip_form[''63''][''desc''] = ''Maildaten loggen'';\r\n	$mip_form[''63''][''size''] = ''1'';\r\n	$mip_form[''63''][''option_desc''][] = ''Nein'';\r\n	$mip_form[''63''][''option_val''][] =  ''false'';\r\n	$mip_form[''63''][''option_desc''][] = ''Ja'';\r\n	$mip_form[''63''][''option_val''][] =  ''true'';\r\n	$mip_form[''63''][''cms_var''] = ''MOD_VAR[''.''63''.'']'';\r\n	$mip_form[''63''][''cms_val''] = $cms_mod[''value''][''63''];\r\n	$mip_form[''63''][''tab''] = ''0'';\r\n	\r\n	$mip_form[''64''][''cat''] = ''txt'';\r\n	$mip_form[''64''][''desc''] = ''Pfad logifle relativ vom Frontend'';\r\n	$mip_form[''64''][''cms_var''] = ''MOD_VAR[64]'';\r\n	$mip_form[''64''][''cms_val''] = $cms_mod[''value''][''64''];\r\n	$mip_form[''64''][''cms_val_default''] = ''logs/log_contactform.txt'';\r\n	$mip_form[''64''][''tab''] = ''0'';\r\n	\r\n	$mip_form[''11''][''cat''] = ''txt'';\r\n	$mip_form[''11''][''desc''] = ''Beeffzeile/ Subject der Email'';\r\n	$mip_form[''11''][''cms_var''] = ''MOD_VAR[11]'';\r\n	$mip_form[''11''][''cms_val''] = $cms_mod[''value''][''11''];\r\n	$mip_form[''11''][''cms_val_default''] = ''Kontaktformular'';\r\n	$mip_form[''11''][''tab''] = ''0'';\r\n	\r\n	$mip_form[''desc''][''cat''] = ''desc'';\r\n	$mip_form[''desc''][''type''] = '''';\r\n	$mip_form[''desc''][''desc''] = ''Emailadresse Empfnger'';\r\n	$mip_form[''desc''][''tab''] = ''0'';	\r\n	\r\n	$mip_form[''65''][''cat''] = ''option'';\r\n	$mip_form[''65''][''desc''] = ''Mailversand aktiviert'';\r\n	$mip_form[''65''][''size''] = ''1'';\r\n	$mip_form[''65''][''option_desc''][] = ''Ja'';\r\n	$mip_form[''65''][''option_val''][] =  ''true'';\r\n	$mip_form[''65''][''option_desc''][] = ''Nein'';\r\n	$mip_form[''65''][''option_val''][] =  ''false'';\r\n	$mip_form[''65''][''cms_var''] = ''MOD_VAR[''.''65''.'']'';\r\n	$mip_form[''65''][''cms_val''] = $cms_mod[''value''][''65''];\r\n	$mip_form[''65''][''cms_val_default''] = ''false'';\r\n\r\n	$mip_form[''12''][''cat''] = ''txt'';\r\n	$mip_form[''12''][''type''] = ''radio''; \r\n	$mip_form[''12''][''desc''] = ''Empfnger aus Textfeld beziehen<br />\r\n	<small>Mgliche Formate: mail@somewehre.de, +benutzername,<br /> \r\n	#gruppenname, mehrere Empfnger mit Komma trennen</small>'';\r\n	$mip_form[''12''][''radio_var''] = ''MOD_VAR[41]''; \r\n	$mip_form[''12''][''radio_val''] = $cms_mod[''value''][''41'']; \r\n	$mip_form[''12''][''radio_user_val''] = ''textfield''; \r\n	$mip_form[''12''][''radio_val_default''] = ''textfield'';\r\n	$mip_form[''12''][''cms_var''] = ''MOD_VAR[12]'';\r\n	$mip_form[''12''][''cms_val''] = $cms_mod[''value''][''12'']; \r\n	$mip_form[''12''][''cms_val_default''] = ''me@localhost.de'';\r\n	$mip_form[''12''][''tab''] = ''1'';\r\n	\r\n	$mip_form[''57''][''cat''] = ''txt'';\r\n	$mip_form[''57''][''desc''] = ''Empfnger cc<br />\r\n	<small>Mgliche Formate: mail@somewehre.de, +benutzername,<br /> \r\n	#gruppenname, mehrere Empfnger mit Komma trennen</small>'';\r\n	$mip_form[''57''][''cms_var''] = ''MOD_VAR[57]'';\r\n	$mip_form[''57''][''cms_val''] = $cms_mod[''value''][''57''];\r\n	$mip_form[''57''][''cms_val_default''] = '''';\r\n	$mip_form[''57''][''tab''] = ''2'';\r\n\r\n	$mip_form[''58''][''cat''] = ''txt'';\r\n	$mip_form[''58''][''desc''] = ''Empfnger bcc<br />\r\n	<small>Mgliche Formate: mail@somewehre.de, +benutzername,<br /> \r\n	#gruppenname, mehrere Empfnger mit Komma trennen</small>'';\r\n	$mip_form[''58''][''cms_var''] = ''MOD_VAR[58]'';\r\n	$mip_form[''58''][''cms_val''] = $cms_mod[''value''][''58''];\r\n	$mip_form[''58''][''cms_val_default''] = '''';\r\n	$mip_form[''58''][''tab''] = ''2'';\r\n\r\n	$mip_form[''59''][''cat''] = ''option'';\r\n	$mip_form[''59''][''desc''] = ''Formulardaten in Datenbank speichern<br />\r\n<small>Zur Nutzung der Funktionalitt muss das Modul Reportviewer installiert sein</small>'';\r\n	$mip_form[''59''][''size''] = ''1'';\r\n	$mip_form[''59''][''option_desc''][] = ''nein'';\r\n	$mip_form[''59''][''option_val''][] =  ''false'';\r\n	$mip_form[''59''][''option_desc''][] = ''ja'';\r\n	$mip_form[''59''][''option_val''][] =  ''true'';\r\n	$mip_form[''59''][''cms_var''] = ''MOD_VAR[''.''59''.'']'';\r\n	$mip_form[''59''][''cms_val''] = $cms_mod[''value''][''59''];\r\n\r\n    $mip_form[''60''][''cat''] = ''txt'';\r\n	$mip_form[''60''][''desc''] = ''Standardgruppe fr Speicherung in Datenbank:'';\r\n	$mip_form[''60''][''cms_var''] = ''MOD_VAR[60]'';\r\n	$mip_form[''60''][''cms_val''] = $cms_mod[''value''][''60''];\r\n	$mip_form[''60''][''cms_val_default''] = ''default'';\r\n	$mip_form[''60''][''tab''] = ''0'';\r\n\r\n	$mip_form[''71''][''cat''] = ''option'';\r\n	$mip_form[''71''][''desc''] = ''Neue Datenstze sind zuerst'';\r\n	$mip_form[''71''][''size''] = ''1'';\r\n	$mip_form[''71''][''option_desc''][] = ''online'';\r\n	$mip_form[''71''][''option_val''][] =  ''online'';\r\n	$mip_form[''71''][''option_desc''][] = ''offline'';\r\n	$mip_form[''71''][''option_val''][] =  ''offline'';\r\n	$mip_form[''71''][''cms_var''] = ''MOD_VAR[''.''71''.'']'';\r\n	$mip_form[''71''][''cms_val''] = $cms_mod[''value''][''71''];	\r\n	\r\n	$mip_form[''41''][''cat''] = ''desc'';\r\n	$mip_form[''41''][''type''] = ''radio''; \r\n	$mip_form[''41''][''desc''] = ''Wenn mglich, dynamisch aus Seitencontent generieren<br /><small>Benutzen Sie dazu z.B. das Modul Dynamische Empfngeradresse</small>'';\r\n	$mip_form[''41''][''radio_var''] = ''MOD_VAR[41]''; \r\n	$mip_form[''41''][''radio_val''] = $cms_mod[''value''][''41'']; \r\n	$mip_form[''41''][''radio_user_val''] = ''get''; \r\n	$mip_form[''41''][''tab''] = ''1'';\r\n	\r\n	//Emailadresse Absender\r\n	$mip_form[''27''][''cat''] = ''option'';\r\n	$mip_form[''27''][''desc''] = ''Emailadresse Absender'';\r\n	$mip_form[''27''][''size''] = ''1'';\r\n	$mip_form[''27''][''option_desc''][] = ''Wie Empfnger'';\r\n	$mip_form[''27''][''option_val''][] =  ''receiver'';\r\n	for($i=0;$i < $cms_mod[''value''][''0''];$i++){\r\n		$element_nr = ($i < 9) ? (''0''. ($i+1) ): $i+1;\r\n		$mip_form[''27''][''option_desc''][] = ''Beziehen aus Formularfeld ''.$element_nr;\r\n		$mip_form[''27''][''option_val''][] = 100 + $i*20;\r\n	}\r\n	$mip_form[''27''][''cms_var''] = ''MOD_VAR[27]'';\r\n	$mip_form[''27''][''cms_val''] = $cms_mod[''value''][''27''];\r\n\r\n//	//Fieldset DEPRECATED\r\n//	$mip_form[''28''][''cat''] = ''option'';\r\n//	$mip_form[''28''][''desc''] = ''Formular enthlt ein Fieldset'';\r\n//	$mip_form[''28''][''size''] = ''1'';\r\n//	$mip_form[''28''][''option_desc''][] = ''Nein'';\r\n//	$mip_form[''28''][''option_val''][] =  ''false'';\r\n//	$mip_form[''28''][''option_desc''][] = ''Ja'';\r\n//	$mip_form[''28''][''option_val''][] =  ''true'';\r\n//	$mip_form[''28''][''cms_var''] = ''MOD_VAR[28]'';\r\n//	$mip_form[''28''][''cms_val''] = $cms_mod[''value''][''28''];\r\n//\r\n//	//Fieldset Beschriftung\r\n//	$mip_form[''29''][''cat''] = ''txt'';\r\n//	$mip_form[''29''][''desc''] = ''Fieldset Beschriftung (Legend)'';\r\n//	$mip_form[''29''][''cms_var''] = ''MOD_VAR[29]'';\r\n//	$mip_form[''29''][''cms_val''] = $cms_mod[''value''][''29''];\r\n//	$mip_form[''29''][''cms_val_default''] = ''Ihre Mitteilung an uns:'';\r\n//	$mip_form[''29''][''tab''] = ''0'';\r\n	\r\n	$mip_form[''13''][''cat''] = ''txt'';\r\n	$mip_form[''13''][''desc''] = ''Fehlermeldung, bei falsch ausgeflltem Formular'';\r\n	$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n	$mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n	$mip_form[''13''][''cms_val_default''] = ''Bitte berprfen Sie Ihre Formulareingaben:'';\r\n	$mip_form[''13''][''tab''] = ''0'';\r\n	\r\n	$mip_form[''14''][''cat''] = ''txt'';\r\n	$mip_form[''14''][''desc''] = ''Erfolgsmeldung, Formular wurde korrekt versendet'';\r\n	$mip_form[''14''][''cms_var''] = ''MOD_VAR[14]'';\r\n	$mip_form[''14''][''cms_val''] = $cms_mod[''value''][''14''];\r\n	$mip_form[''14''][''cms_val_default''] = ''Vielen Dank, die Daten wurden versandt'';\r\n	$mip_form[''14''][''tab''] = ''0'';\r\n	\r\n	$mip_form[''67''][''cat''] = ''txt'';\r\n	$mip_form[''67''][''desc''] = ''Nach Erfolg weiterleiten auf folgende URL<br />\r\n<small>Url oder Idcatside eingeben, leer lassen fr keine Weiterleitung</small>'';\r\n	$mip_form[''67''][''cms_var''] = ''MOD_VAR[67]'';\r\n	$mip_form[''67''][''cms_val''] = $cms_mod[''value''][''67''];\r\n	$mip_form[''67''][''cms_val_default''] = '''';\r\n	$mip_form[''67''][''tab''] = ''0'';\r\n	\r\n	$mip_form[''24''][''cat''] = ''txt'';\r\n	$mip_form[''24''][''desc''] = ''Beschriftung Submitbutton'';\r\n	$mip_form[''24''][''cms_var''] = ''MOD_VAR[24]'';\r\n	$mip_form[''24''][''cms_val''] = $cms_mod[''value''][''24''];\r\n	$mip_form[''24''][''cms_val_default''] = ''Abschicken'';\r\n	$mip_form[''24''][''tab''] = ''0'';\r\n		\r\n	$mip_form[''15''][''desc''] = ''Styleklasse Fehlermeldung: '';\r\n	$mip_form[''15''][''cat''] = ''app_css'';\r\n	$mip_form[''15''][''output_cat''] = ''option'';\r\n	$mip_form[''15''][''cms_var''] = ''MOD_VAR[15]'';\r\n	$mip_form[''15''][''cms_val''] = $cms_mod[''value''][''15''];\r\n	$mip_form[''15''][''flag''] = ''class_only'';\r\n	\r\n	$mip_form[''16''][''desc''] = ''Styleklasse Erfolgsmeldung: '';\r\n	$mip_form[''16''][''cat''] = ''app_css'';\r\n	$mip_form[''16''][''output_cat''] = ''option'';\r\n	$mip_form[''16''][''cms_var''] = ''MOD_VAR[16]'';\r\n	$mip_form[''16''][''cms_val''] = $cms_mod[''value''][''16''];\r\n	$mip_form[''16''][''flag''] = ''class_only'';\r\n	\r\n	$mip_form[''17''][''desc''] = ''Styleklasse Label: '';\r\n	$mip_form[''17''][''cat''] = ''app_css'';\r\n	$mip_form[''17''][''output_cat''] = ''option'';\r\n	$mip_form[''17''][''cms_var''] = ''MOD_VAR[17]'';\r\n	$mip_form[''17''][''cms_val''] = $cms_mod[''value''][''17''];\r\n	$mip_form[''17''][''flag''] = ''class_only'';\r\n\r\n	$mip_form[''18''][''desc''] = ''Styleklasse Label, bei Fehlermeldung: '';\r\n	$mip_form[''18''][''cat''] = ''app_css'';\r\n	$mip_form[''18''][''output_cat''] = ''option'';\r\n	$mip_form[''18''][''cms_var''] = ''MOD_VAR[18]'';\r\n	$mip_form[''18''][''cms_val''] = $cms_mod[''value''][''18''];\r\n	$mip_form[''18''][''flag''] = ''class_only'';\r\n	\r\n	$mip_form[''19''][''desc''] = ''Styleklasse einzeiliges Textfeld: '';\r\n	$mip_form[''19''][''cat''] = ''app_css'';\r\n	$mip_form[''19''][''output_cat''] = ''option'';\r\n	$mip_form[''19''][''cms_var''] = ''MOD_VAR[19]'';\r\n	$mip_form[''19''][''cms_val''] = $cms_mod[''value''][''19''];\r\n	$mip_form[''19''][''flag''] = ''class_only'';\r\n	\r\n	$mip_form[''20''][''desc''] = ''Styleklasse mehrzeiliges Textfeld: '';\r\n	$mip_form[''20''][''cat''] = ''app_css'';\r\n	$mip_form[''20''][''output_cat''] = ''option'';\r\n	$mip_form[''20''][''cms_var''] = ''MOD_VAR[20]'';\r\n	$mip_form[''20''][''cms_val''] = $cms_mod[''value''][''20''];\r\n	$mip_form[''20''][''flag''] = ''class_only'';\r\n	\r\n	$mip_form[''21''][''desc''] = ''Styleklasse Selectbox: '';\r\n	$mip_form[''21''][''cat''] = ''app_css'';\r\n	$mip_form[''21''][''output_cat''] = ''option'';\r\n	$mip_form[''21''][''cms_var''] = ''MOD_VAR[21]'';\r\n	$mip_form[''21''][''cms_val''] = $cms_mod[''value''][''21''];\r\n	$mip_form[''21''][''flag''] = ''class_only'';\r\n	\r\n	$mip_form[''22''][''desc''] = ''Styleklasse Checkbox: '';\r\n	$mip_form[''22''][''cat''] = ''app_css'';\r\n	$mip_form[''22''][''output_cat''] = ''option'';\r\n	$mip_form[''22''][''cms_var''] = ''MOD_VAR[22]'';\r\n	$mip_form[''22''][''cms_val''] = $cms_mod[''value''][''22''];\r\n	$mip_form[''22''][''flag''] = ''class_only'';\r\n\r\n	$mip_form[''31''][''desc''] = ''Styleklasse Einzeiliges Passwortfeld: '';\r\n	$mip_form[''31''][''cat''] = ''app_css'';\r\n	$mip_form[''31''][''output_cat''] = ''option'';\r\n	$mip_form[''31''][''cms_var''] = ''MOD_VAR[31]'';\r\n	$mip_form[''31''][''cms_val''] = $cms_mod[''value''][''31''];\r\n	$mip_form[''31''][''flag''] = ''class_only'';\r\n\r\n	$mip_form[''32''][''desc''] = ''Styleklasse Selectbox, Mehrfachauswahl: '';\r\n	$mip_form[''32''][''cat''] = ''app_css'';\r\n	$mip_form[''32''][''output_cat''] = ''option'';\r\n	$mip_form[''32''][''cms_var''] = ''MOD_VAR[32]'';\r\n	$mip_form[''32''][''cms_val''] = $cms_mod[''value''][''32''];\r\n	$mip_form[''32''][''flag''] = ''class_only'';\r\n\r\n	$mip_form[''33''][''desc''] = ''Styleklasse Optionsfelder: '';\r\n	$mip_form[''33''][''cat''] = ''app_css'';\r\n	$mip_form[''33''][''output_cat''] = ''option'';\r\n	$mip_form[''33''][''cms_var''] = ''MOD_VAR[33]'';\r\n	$mip_form[''33''][''cms_val''] = $cms_mod[''value''][''33''];\r\n	$mip_form[''33''][''flag''] = ''class_only'';\r\n\r\n	$mip_form[''34''][''desc''] = ''Styleklasse Nur Beschriftung: '';\r\n	$mip_form[''34''][''cat''] = ''app_css'';\r\n	$mip_form[''34''][''output_cat''] = ''option'';\r\n	$mip_form[''34''][''cms_var''] = ''MOD_VAR[34]'';\r\n	$mip_form[''34''][''cms_val''] = $cms_mod[''value''][''34''];\r\n	$mip_form[''34''][''flag''] = ''class_only'';\r\n\r\n	$mip_form[''35''][''desc''] = ''Styleklasse Platzhalter: '';\r\n	$mip_form[''35''][''cat''] = ''app_css'';\r\n	$mip_form[''35''][''output_cat''] = ''option'';\r\n	$mip_form[''35''][''cms_var''] = ''MOD_VAR[35]'';\r\n	$mip_form[''35''][''cms_val''] = $cms_mod[''value''][''35''];\r\n	$mip_form[''35''][''flag''] = ''class_only'';\r\n\r\n	$mip_form[''52''][''desc''] = ''Styleklasse Dateiupload: '';\r\n	$mip_form[''52''][''cat''] = ''app_css'';\r\n	$mip_form[''52''][''output_cat''] = ''option'';\r\n	$mip_form[''52''][''cms_var''] = ''MOD_VAR[52]'';\r\n	$mip_form[''52''][''cms_val''] = $cms_mod[''value''][''52''];\r\n	$mip_form[''52''][''flag''] = ''class_only'';\r\n\r\n	$mip_form[''79''][''desc''] = ''Styleklasse Captchbild Textfeld: '';\r\n	$mip_form[''79''][''cat''] = ''app_css'';\r\n	$mip_form[''79''][''output_cat''] = ''option'';\r\n	$mip_form[''79''][''cms_var''] = ''MOD_VAR[79]'';\r\n	$mip_form[''79''][''cms_val''] = $cms_mod[''value''][''79''];\r\n	$mip_form[''79''][''flag''] = ''class_only'';\r\n\r\n	$mip_form[''53''][''desc''] = ''Styleklasse Fehlermeldung im Formularelement: '';\r\n	$mip_form[''53''][''cat''] = ''app_css'';\r\n	$mip_form[''53''][''output_cat''] = ''option'';\r\n	$mip_form[''53''][''cms_var''] = ''MOD_VAR[53]'';\r\n	$mip_form[''53''][''cms_val''] = $cms_mod[''value''][''53''];\r\n	$mip_form[''53''][''flag''] = ''class_only'';\r\n\r\n		\r\n	$mip_form[''23''][''desc''] = ''Styleklasse Submitbutton: '';\r\n	$mip_form[''23''][''cat''] = ''app_css'';\r\n	$mip_form[''23''][''output_cat''] = ''option'';\r\n	$mip_form[''23''][''cms_var''] = ''MOD_VAR[23]'';\r\n	$mip_form[''23''][''cms_val''] = $cms_mod[''value''][''23''];\r\n	$mip_form[''23''][''flag''] = ''class_only'';\r\n\r\n	$mip_form[''36''][''cat''] = ''txt'';\r\n	$mip_form[''36''][''desc''] = ''Trennersymbol - bei Feldern, wo mehreren Werte angegeben werden knnen<br />\r\n<small>Selectboxen und Optionsfelder</small>'';\r\n	$mip_form[''36''][''cms_var''] = ''MOD_VAR[36]'';\r\n	$mip_form[''36''][''cms_val''] = $cms_mod[''value''][''36''];\r\n	$mip_form[''36''][''cms_val_default''] = '','';\r\n	\r\n\r\n	$mip_form[''37''][''cat''] = ''txt'';\r\n	$mip_form[''37''][''desc''] = ''Trennersymbol - bei Feldern, wo angezeigter Name und bergebener Wert unterschiedlich sein knnen<br />\r\n<small>Selectboxen, Optionsfelder und Checkboxen</small>'';\r\n	$mip_form[''37''][''cms_var''] = ''MOD_VAR[37]'';\r\n	$mip_form[''37''][''cms_val''] = $cms_mod[''value''][''37''];\r\n	$mip_form[''37''][''cms_val_default''] = ''@@'';\r\n\r\n\r\n	$mip_form[''47''][''cat''] = ''txt'';\r\n	$mip_form[''47''][''desc''] = ''Dateiuploads - erlaubte Dateiendungen<br>\r\n<small>kommasepariert anzugeben ("doc,pdf"), leer bedeutet keine Einschrnkungen</small>'';\r\n	$mip_form[''47''][''cms_var''] = ''MOD_VAR[47]'';\r\n	$mip_form[''47''][''cms_val''] = $cms_mod[''value''][''47''];\r\n	$mip_form[''47''][''cms_val_default''] = '''';\r\n	$mip_form[''47''][''tab''] = ''0'';\r\n\r\n	$mip_form[''48''][''cat''] = ''txt'';\r\n	$mip_form[''48''][''desc''] = ''Dateiuploads - erlaubte, maximale Dateigre in kb<br>\r\n<small>1024 kb entsprechen 1mb, leer oder 0 bedeutet keine Einschrnkungen</small>'';\r\n	$mip_form[''48''][''cms_var''] = ''MOD_VAR[48]'';\r\n	$mip_form[''48''][''cms_val''] = $cms_mod[''value''][''48''];\r\n	$mip_form[''48''][''cms_val_default''] = '''';\r\n	$mip_form[''48''][''tab''] = ''0'';\r\n\r\n	$mip_form[''49''][''cat''] = ''txt'';\r\n	$mip_form[''49''][''rows''] = ''1'';\r\n	$mip_form[''49''][''type''] = ''long'';	\r\n	$mip_form[''49''][''desc''] = ''Dateiuploads Fehlermeldung "Dateiendung nicht erlaubt"'';\r\n	$mip_form[''49''][''cms_var''] = ''MOD_VAR[49]'';\r\n	$mip_form[''49''][''cms_val''] = $cms_mod[''value''][''49''];\r\n	$mip_form[''49''][''cms_val_default''] = ''Der von Ihnen gewhlte Dateityp darf nicht hochgeladen werden'';\r\n	$mip_form[''49''][''tab''] = ''0'';\r\n\r\n	$mip_form[''50''][''cat''] = ''txt'';\r\n	$mip_form[''50''][''rows''] = ''1'';\r\n	$mip_form[''50''][''type''] = ''long'';	\r\n	$mip_form[''50''][''desc''] = ''Dateiuploads Fehlermeldung "Uploadlimit berschritten"'';\r\n	$mip_form[''50''][''cms_var''] = ''MOD_VAR[50]'';\r\n	$mip_form[''50''][''cms_val''] = $cms_mod[''value''][''50''];\r\n	$mip_form[''50''][''cms_val_default''] = ''Die maximal zulssige Dateigre wurde berschritten'';\r\n	$mip_form[''50''][''tab''] = ''0'';\r\n	\r\n	$mip_form[''51''][''cat''] = ''txt'';\r\n	$mip_form[''51''][''rows''] = ''1'';\r\n	$mip_form[''51''][''type''] = ''long'';	\r\n	$mip_form[''51''][''desc''] = ''Dateiuploads Fehlermeldung "Interner Fehler"'';\r\n	$mip_form[''51''][''cms_var''] = ''MOD_VAR[51]'';\r\n	$mip_form[''51''][''cms_val''] = $cms_mod[''value''][''51''];\r\n	$mip_form[''51''][''cms_val_default''] = ''Beim Upload ist ein interner Fehler aufgetreten'';\r\n	$mip_form[''51''][''tab''] = ''0'';\r\n\r\n	$mip_form[''61''][''cat''] = ''option'';\r\n	$mip_form[''61''][''desc''] = ''Dateiuploads im Dateisystem ablegen'';\r\n	$mip_form[''61''][''size''] = ''1'';\r\n	$mip_form[''61''][''option_desc''][] = ''Nein'';\r\n	$mip_form[''61''][''option_val''][] =  ''false'';\r\n	$mip_form[''61''][''option_desc''][] = ''Ja, gleichlautene Dateien werden berschrieben'';\r\n	$mip_form[''61''][''option_val''][] =  ''overwrite'';\r\n	$mip_form[''61''][''option_desc''][] = ''Ja, gleichlautene Dateien werden umbenannt'';\r\n	$mip_form[''61''][''option_val''][] =  ''rename'';\r\n	$mip_form[''61''][''cms_var''] = ''MOD_VAR[''.''61''.'']'';\r\n	$mip_form[''61''][''cms_val''] = $cms_mod[''value''][''61''];\r\n	\r\n	$mip_form[''62''][''desc''] = "Ordner in dem Uploads abgelegt werden";\r\n	$mip_form[''62''][''cat''] = ''app_directory'';\r\n	$mip_form[''62''][''output_cat''] = ''option'';\r\n	$mip_form[''62''][''size''] = 1; \r\n	$mip_form[''62''][''cms_var''] = "MOD_VAR[62]"; \r\n	$mip_form[''62''][''cms_val''] = $dedi_mod[''value''][''62''];\r\n	$mip_form[''62''][''without_all_folders''] = true;\r\n		\r\n	\r\n	$mip_form[''25''][''desc''] = ''Verbindungstemplate<br>\r\n	<small>Mgliche Templatevariablen: {usermessage} = Erfolgs oder Fehlermeldung beim verschicken des Formulars,<br>\r\n    {messageblock} = Gleiche Funktionalitt wie {usermessage}, es wird aber das Template Fehlermeldung<br /> eingebunden   \r\n	{formstart} = Formularkopf, mu vor {formelements}, {submit} eingefgt werden,<br />\r\n    {formelements} = enthlt alle Formularelement, wird aus dem Template "Formelementblock" generiert, <br />\r\n    {submit} = Absendenbutton, {formend} = Formularende, mu hinter {formelements} und {submit} eingefgt <br />\r\n    werden, {textfromdynamic} = Optionaler Inhalt aus Textfeld, der im Modul Dynamische Empfngeradresse<br /> \r\n    angegeben werden kann, {textareafromdynamic} = Optionale Inhalt aus Textarea, die im Modul Dynamische<br /> \r\n    Empfngeradresse angegeben werden kann,<br />\r\n	{page_name}, {page_url}, {cat_name}, {cat_url} = Kategorie und Seiteninformationen, die <br />\r\n	a) von der Seite stammen, von der das Formular verschickt wurde, wenn die Empfngeradresse<br />\r\n	statisch in der Konfiguration eingetragen ist<br />\r\n	b) von der Seite stammen, auf der das Modul Dynamische Empfngeradresse liegt, wenn die Daten<br />\r\n	dynamisch generiert wurden.<br /> \r\n	{debugmessages} = Debugmeldungen, wenn aktiviert</small>'';\r\n	$mip_form[''25''][''cat''] = ''txtarea'';\r\n	$mip_form[''25''][''rows''] = ''6'';\r\n	$mip_form[''25''][''type''] = ''long'';\r\n	$mip_form[''25''][''cms_var''] = ''MOD_VAR[25]'';\r\n	$mip_form[''25''][''cms_val''] = $cms_mod[''value''][''25''];\r\n	$mip_form[''25''][''cms_val_default''] = ''<table border="0" cellpadding="0" cellspacing="0">\r\n<tr><td align="right" colspan="2">{usermessage}</td></tr>\r\n  {formstart} {formelementblock}  \r\n  <tr><td align="right" colspan="2">{submit}</td></tr>\r\n  {formend}\r\n</table>'';	\r\n	\r\n	$mip_form[''26''][''desc''] = ''Template Elementcontainer 1<br>\r\n	<small>Mgliche Templatevariablen: {label} = Labes des Formularelements,{element} = Formularelement, z.B. <br>\r\n	Textfeld/ Selectbox, {errormessage} = Fehlermeldung im Element, {requirenotice} = Auszeichnung wenn Pflichtfeld</small>'';\r\n	$mip_form[''26''][''cat''] = ''txtarea'';\r\n	$mip_form[''26''][''rows''] = ''6'';\r\n	$mip_form[''26''][''type''] = ''long'';\r\n	$mip_form[''26''][''cms_var''] = ''MOD_VAR[26]'';\r\n	$mip_form[''26''][''cms_val''] = $cms_mod[''value''][''26''];\r\n	$mip_form[''26''][''cms_val_default''] = ''<tr>\r\n  <td valign="top">{label} &nbsp;&nbsp;</td>\r\n  <td>{errormessage}{element}</td>\r\n</tr>'';	\r\n\r\n	$mip_form[''46''][''desc''] = ''Template Elementcontainer 2<br>\r\n	<small>Mgliche Templatevariablen: {label} = Labes des Formularelements,{element} = Formularelement, z.B. <br>\r\n	Textfeld/ Selectbox,  {errormessage} = Fehlermeldung im Element, {requirenotice} = Auszeichnung wenn Pflichtfeld</small>'';\r\n	$mip_form[''46''][''cat''] = ''txtarea'';\r\n	$mip_form[''46''][''rows''] = ''6'';\r\n	$mip_form[''46''][''type''] = ''long'';\r\n	$mip_form[''46''][''cms_var''] = ''MOD_VAR[46]'';\r\n	$mip_form[''46''][''cms_val''] = $cms_mod[''value''][''46''];\r\n	$mip_form[''46''][''cms_val_default''] = ''<tr>\r\n    <td valign="top">{errormessage}{element} &nbsp;&nbsp;</td>\r\n  <td>{label}</td>\r\n</tr>'';\r\n\r\n	$mip_form[''66''][''desc''] = ''Template Elementcontainer 3<br>\r\n	<small>Mgliche Templatevariablen: {label} = Labes des Formularelements,{element} = Formularelement, z.B. <br>\r\n	Textfeld/ Selectbox,  {errormessage} = Fehlermeldung im Element, {requirenotice} = Auszeichnung wenn Pflichtfeld</small>'';\r\n	$mip_form[''66''][''cat''] = ''txtarea'';\r\n	$mip_form[''66''][''rows''] = ''6'';\r\n	$mip_form[''66''][''type''] = ''long'';\r\n	$mip_form[''66''][''cms_var''] = ''MOD_VAR[66]'';\r\n	$mip_form[''66''][''cms_val''] = $cms_mod[''value''][''66''];\r\n	$mip_form[''66''][''cms_val_default''] = ''<tr>\r\n  <td valign="top" colspan="2">{label}<br />{errormessage}{element} &nbsp;&nbsp;</td>\r\n</tr>'';	\r\n\r\n	$mip_form[''86''][''desc''] = ''Template Elementcontainer 4<br>\r\n	<small>Mgliche Templatevariablen: {label} = Labes des Formularelements,{element} = Formularelement, z.B. <br>\r\n	Textfeld/ Selectbox,  {errormessage} = Fehlermeldung im Element, {requirenotice} = Auszeichnung wenn Pflichtfeld</small>'';\r\n	$mip_form[''86''][''cat''] = ''txtarea'';\r\n	$mip_form[''86''][''rows''] = ''6'';\r\n	$mip_form[''86''][''type''] = ''long'';\r\n	$mip_form[''86''][''cms_var''] = ''MOD_VAR[86]'';\r\n	$mip_form[''86''][''cms_val''] = $cms_mod[''value''][''86''];\r\n	$mip_form[''86''][''cms_val_default''] = ''<tr>\r\n  <td valign="top" colspan="2">{errormessage}{element}<br />{label}{requirenotice}</td>\r\n</tr>'';		\r\n\r\n	$mip_form[''38''][''desc''] = ''Template Messageblock<br>\r\n	<small>Mgliche Templatevariablen: {usermessage} = Enthlt CSS formatierte Fehler- Besttigungsmeldung</small>'';\r\n	$mip_form[''38''][''cat''] = ''txtarea'';\r\n	$mip_form[''38''][''rows''] = ''6'';\r\n	$mip_form[''38''][''type''] = ''long'';\r\n	$mip_form[''38''][''cms_var''] = ''MOD_VAR[38]'';\r\n	$mip_form[''38''][''cms_val''] = $cms_mod[''value''][''38''];\r\n	$mip_form[''38''][''cms_val_default''] = ''<hr />{usermessage}<hr />'';\r\n	\r\n	$mip_form[''82''][''cat''] = ''txt'';\r\n	$mip_form[''82''][''desc''] = ''Template fr "{requirenotice}"'';\r\n	$mip_form[''82''][''cms_var''] = ''MOD_VAR[82]'';\r\n	$mip_form[''82''][''cms_val''] = $cms_mod[''value''][''82'']; \r\n	$mip_form[''82''][''cms_val_default''] = ''&nbsp;*'';\r\n	\r\n	$mip_form[''83''][''cat''] = ''txt'';\r\n	$mip_form[''83''][''desc''] = ''Template fr Labeltext<br>\r\n	<small>Mgliche Templatevariablen: {labelcontent} = Labeltext, {requirenotice} = Auszeichnung wenn Pflichtfeld</small>'';\r\n	$mip_form[''83''][''cms_var''] = ''MOD_VAR[83]'';\r\n	$mip_form[''83''][''cms_val''] = $cms_mod[''value''][''83'']; \r\n	$mip_form[''83''][''cms_val_default''] = ''{labelcontent}{requirenotice}'';\r\n\r\n	$mip_form[''39''][''desc''] = ''Template Formularstart<br>\r\n	<small>Mgliche Templatevariablen: {url} = Ziellink des Formulars, {transmitted} = gibt falls das Formular versendet wurde den String "transmitted" aus</small>'';\r\n	$mip_form[''39''][''cat''] = ''txtarea'';\r\n	$mip_form[''39''][''rows''] = ''1'';\r\n	$mip_form[''39''][''type''] = ''long'';\r\n	$mip_form[''39''][''cms_var''] = ''MOD_VAR[39]'';\r\n	$mip_form[''39''][''cms_val''] = $cms_mod[''value''][''39''];\r\n	$mip_form[''39''][''cms_val_default''] = ''<form id="feedback" class="{transmitted}" method="post" action="{url}" enctype="multipart/form-data" >'';	\r\n\r\n\r\n	$mip_form[''40''][''desc''] = ''Template Formularende<br>\r\n	<small>Mgliche Templatevariablen: keine</small>'';\r\n	$mip_form[''40''][''cat''] = ''txtarea'';\r\n	$mip_form[''40''][''rows''] = ''1'';\r\n	$mip_form[''40''][''type''] = ''long'';\r\n	$mip_form[''40''][''cms_var''] = ''MOD_VAR[40]'';\r\n	$mip_form[''40''][''cms_val''] = $cms_mod[''value''][''40''];\r\n	$mip_form[''40''][''cms_val_default''] = ''</form>'';	\r\n\r\n	$mip_form[''42''][''desc''] = ''Template Platzhalter<br>\r\n	<small>Dieses Template wird beim Platzhalterelement als "defaulttext" eingetragen<br>\r\nMgliche Templatevariablen: keine</small>'';\r\n	$mip_form[''42''][''cat''] = ''txtarea'';\r\n	$mip_form[''42''][''rows''] = ''1'';\r\n	$mip_form[''42''][''type''] = ''long'';\r\n	$mip_form[''42''][''cms_var''] = ''MOD_VAR[42]'';\r\n	$mip_form[''42''][''cms_val''] = $cms_mod[''value''][''42''];\r\n	$mip_form[''42''][''cms_val_default''] = ''<br /><br />'';	\r\n\r\n	$mip_form[''43''][''desc''] = ''Template Element- Fehlermeldung<br>\r\n	<small>Mgliche Templatevariablen: {elementerrormessage}</small>'';\r\n	$mip_form[''43''][''cat''] = ''txtarea'';\r\n	$mip_form[''43''][''rows''] = ''1'';\r\n	$mip_form[''43''][''type''] = ''long'';\r\n	$mip_form[''43''][''cms_var''] = ''MOD_VAR[43]'';\r\n	$mip_form[''43''][''cms_val''] = $cms_mod[''value''][''43''];\r\n	$mip_form[''43''][''cms_val_default''] = ''{elementerrormessage}<br />'';\r\n	\r\n	$mip_form[''54''][''cat''] = ''txt'';\r\n	$mip_form[''54''][''desc''] = ''Template Defaultwert fr {textfromdynamic}<br />\r\n	<small>Standardwert fr {textfromdynamic}, liegt ein Wert aus dem Modul <br />\r\n    "Dynamische Empfngeradresse" vor, wird dieser genommen.</small>'';\r\n	$mip_form[''54''][''cms_var''] = ''MOD_VAR[54]'';\r\n	$mip_form[''54''][''cms_val''] = $cms_mod[''value''][''54'']; \r\n	$mip_form[''54''][''cms_val_default''] = '''';\r\n	\r\n	$mip_form[''55''][''cat''] = ''txtarea'';\r\n	$mip_form[''55''][''rows''] = ''2'';\r\n	$mip_form[''55''][''type''] = ''long'';\r\n	$mip_form[''55''][''desc''] = ''Template Defaultwert fr {textareafromdynamic}<br />\r\n	<small>Standardwert fr {textareafromdynamic}, liegt ein Wert aus dem Modul<br />\r\n    "Dynamische Empfngeradresse" vor, wird dieser genommen.</small>'';\r\n	$mip_form[''55''][''cms_var''] = ''MOD_VAR[55]'';\r\n	$mip_form[''55''][''cms_val''] = $cms_mod[''value''][''55'']; \r\n	$mip_form[''55''][''cms_val_default''] = '''';\r\n	\r\n	$mip_form[''56''][''desc''] = ''Template Email <br>\r\n	<small>Mgliche Templatevariablen: {automessage} = vom System automatisch zusammengestellter Text<br />\r\naus allen Formularelementen, {elementlabel:1} = Label des ersten Formularfeldes, {elementvalue:1} = <br />\r\nWert des ersten Formularfeldes. Es kann auf jedes Formularfeld zugegriffen werden, {elementlabel:3}<br />\r\nentspricht beispielsweise dem Label des dritten Formularfeldes<br />\r\n{page_name}, {page_url}, {cat_name}, {cat_url} = Kategorie und Seiteninformationen, die <br />\r\na) von der Seite stammen, von der das Formular verschickt wurde, wenn die Empfngeradresse<br />\r\nstatisch in der Konfiguration eingetragen ist<br />\r\nb) von der Seite stammen, auf der das Modul Dynamische Empfngeradresse liegt, wenn die Daten<br />\r\ndynamisch generiert wurden. \r\n</small>'';\r\n	$mip_form[''56''][''cat''] = ''txtarea'';\r\n	$mip_form[''56''][''rows''] = ''6'';\r\n	$mip_form[''56''][''type''] = ''long'';\r\n	$mip_form[''56''][''cms_var''] = ''MOD_VAR[56]'';\r\n	$mip_form[''56''][''cms_val''] = $cms_mod[''value''][''56''];\r\n	$mip_form[''56''][''cms_val_default''] = ''{automessage}'';\r\n	\r\n	//Weitere Email Ja/ Nein\r\n	$mip_form[''68''][''cat''] = ''option'';\r\n	$mip_form[''68''][''desc''] = ''Weitere Email verschicken?'';\r\n	$mip_form[''68''][''size''] = ''1'';\r\n	$mip_form[''68''][''option_desc''][] = ''Ja'';\r\n	$mip_form[''68''][''option_val''][] =  ''true'';\r\n	$mip_form[''68''][''option_desc''][] = ''Nein'';\r\n	$mip_form[''68''][''option_val''][] =  ''false'';\r\n	$mip_form[''68''][''cms_var''] = ''MOD_VAR[''.''68''.'']'';\r\n	$mip_form[''68''][''cms_val''] = $cms_mod[''value''][''68''];\r\n	$mip_form[''68''][''cms_val_default''] = ''false'';\r\n	\r\n	//Subject Weitere Email\r\n	$mip_form[''69''][''cat''] = ''txt'';\r\n	$mip_form[''69''][''desc''] = ''Weitere Email Subject'';\r\n	$mip_form[''69''][''cms_var''] = ''MOD_VAR[69]'';\r\n	$mip_form[''69''][''cms_val''] = $cms_mod[''value''][''69''];\r\n	$mip_form[''69''][''cms_val_default''] = ''Ihre gettigten Eingaben'';\r\n	$mip_form[''69''][''tab''] = ''0'';\r\n	\r\n	//Template Weitere Email	\r\n	$mip_form[''70''][''desc''] = ''Template Weitere Email<br />\r\n	<small>Mgliche Templatevariablen: Identisch mit Template Email</small>'';\r\n	$mip_form[''70''][''cat''] = ''txtarea'';\r\n	$mip_form[''70''][''rows''] = ''6'';\r\n	$mip_form[''70''][''type''] = ''long'';\r\n	$mip_form[''70''][''cms_var''] = ''MOD_VAR[70]'';\r\n	$mip_form[''70''][''cms_val''] = $cms_mod[''value''][''70''];\r\n	$mip_form[''70''][''cms_val_default''] = ''{automessage}'';\r\n	\r\n	//Addonobject\r\n	$mip_form[''72''][''cat''] = ''txt'';\r\n	$mip_form[''72''][''rows''] = ''1'';\r\n	$mip_form[''72''][''type''] = ''long'';	\r\n	$mip_form[''72''][''desc''] = ''Addonstring<br />\r\n<small>Syntax: [pfad]||[klassenname]</small>'';\r\n	$mip_form[''72''][''cms_var''] = ''MOD_VAR[72]'';\r\n	$mip_form[''72''][''cms_val''] = $cms_mod[''value''][''72''];\r\n	$mip_form[''72''][''cms_val_default''] = '''';\r\n	$mip_form[''72''][''tab''] = ''0'';\r\n\r\n	//Captchaimage length\r\n	$mip_form[''73''][''cat''] = ''txt'';\r\n	$mip_form[''73''][''desc''] = ''Captcha-Code Lnge <small>(Anzahl der einzugebenen Zeichen)</small>'';\r\n	$mip_form[''73''][''cms_var''] = ''MOD_VAR[73]'';\r\n	$mip_form[''73''][''cms_val''] = $cms_mod[''value''][''73''];\r\n	$mip_form[''73''][''cms_val_default''] = ''4'';\r\n	\r\n	//Captchaimage width\r\n	$mip_form[''74''][''cat''] = ''txt'';\r\n	$mip_form[''74''][''desc''] = ''Captcha-Code Bildbreite <small>(in Pixeln)</small>'';\r\n	$mip_form[''74''][''cms_var''] = ''MOD_VAR[74]'';\r\n	$mip_form[''74''][''cms_val''] = $cms_mod[''value''][''74''];\r\n	$mip_form[''74''][''cms_val_default''] = ''100'';\r\n	\r\n	//Captchaimage height\r\n	$mip_form[''75''][''cat''] = ''txt'';\r\n	$mip_form[''75''][''desc''] = ''Captcha-Code Bildhhe <small>(in Pixeln)</small>'';\r\n	$mip_form[''75''][''cms_var''] = ''MOD_VAR[75]'';\r\n	$mip_form[''75''][''cms_val''] = $cms_mod[''value''][''75''];\r\n	$mip_form[''75''][''cms_val_default''] = ''30'';\r\n	$mip_form[''75''][''tab''] = ''0'';\r\n	\r\n	//Captchaimage attributes\r\n	$mip_form[''76''][''cat''] = ''txt'';\r\n	$mip_form[''76''][''desc''] = ''Captcha-Code optionale, zustzliche Imagetag-Attribute'';\r\n	$mip_form[''76''][''cms_var''] = ''MOD_VAR[76]'';\r\n	$mip_form[''76''][''cms_val''] = $cms_mod[''value''][''76''];\r\n	$mip_form[''76''][''cms_val_default''] = '''';\r\n	$mip_form[''76''][''tab''] = ''0'';\r\n	\r\n	//Captchaimage styleset\r\n	$mip_form[''77''][''cat''] = ''option'';\r\n	$mip_form[''77''][''desc''] = ''Captcha-Code Bilddesign'';\r\n	$mip_form[''77''][''size''] = ''1'';\r\n	$mip_form[''77''][''option_desc''][] = ''throwCHARS'';\r\n	$mip_form[''77''][''option_val''][] =  '''';\r\n	$mip_form[''77''][''option_desc''][] = ''binCLEAR'';\r\n	$mip_form[''77''][''option_val''][] = ''1'';\r\n	$mip_form[''77''][''option_desc''][] = ''psychoPIXEL'';\r\n	$mip_form[''77''][''option_val''][] = ''2'';\r\n	$mip_form[''77''][''cms_var''] = ''MOD_VAR[77]'';\r\n	$mip_form[''77''][''cms_val''] = $cms_mod[''value''][''77''];\r\n	\r\n	//Template Captchaimage\r\n	$mip_form[''78''][''desc''] = ''Template Captchaelement<br>\r\n	<small>Mgliche Templatevariablen: {image}, {textfield}, {hiddentoken}</small>'';\r\n	$mip_form[''78''][''cat''] = ''txtarea'';\r\n	$mip_form[''78''][''rows''] = ''1'';\r\n	$mip_form[''78''][''type''] = ''long'';\r\n	$mip_form[''78''][''cms_var''] = ''MOD_VAR[78]'';\r\n	$mip_form[''78''][''cms_val''] = $cms_mod[''value''][''78''];\r\n	$mip_form[''78''][''cms_val_default''] = ''{image} {textfield}{hiddentoken}'';	\r\n	\r\n	//Weitere Email Emailadresse\r\n	$mip_form[''80''][''cat''] = ''txt'';\r\n	$mip_form[''80''][''desc''] = ''Weitere Email Emailadresse Absender<small>(Entweder Emailadresse oder Formulardeldnummer)'';\r\n	$mip_form[''80''][''cms_var''] = ''MOD_VAR[80]'';\r\n	$mip_form[''80''][''cms_val''] = $cms_mod[''value''][''80''];\r\n	$mip_form[''80''][''cms_val_default''] = ''me@local.de'';\r\n	$mip_form[''80''][''tab''] = ''0'';\r\n		\r\n	//Weitere Email Emailadresse\r\n	$mip_form[''81''][''cat''] = ''txt'';\r\n	$mip_form[''81''][''desc''] = ''Weitere Email Emailadresse Empfnger<small>(Entweder Emailadresse oder Formulardeldnummer)'';\r\n	$mip_form[''81''][''cms_var''] = ''MOD_VAR[81]'';\r\n	$mip_form[''81''][''cms_val''] = $cms_mod[''value''][''81''];\r\n	$mip_form[''81''][''cms_val_default''] = ''me_too@local.de'';\r\n	$mip_form[''81''][''tab''] = ''0'';\r\n\r\n\r\n\r\n	//------------------------------------------------\r\n	//START GENERATE FORMFIELDS\r\n	//------------------------------------------------\r\n	$cf_formfieldtable = '''';\r\n	$cf_formfieldtable .= ''\r\n\r\n\r\n<script type="text/javascript">\r\n\r\n		// array to memorize a set of form element values\r\n		var val_mem_MOD_VAR=new Array();\r\n		// memorized flag\r\n		var val_mem_saved_MOD_VAR=false;\r\n		// current memorized entry (the id of the div-element to change the background color on copy)\r\n		var centry_mem_MOD_VAR;\r\n		// starting cmsmod-var id - depends on the module config\r\n		var cmvid_MOD_VAR=100;\r\n		// difference value betweend the cms_mod-var ids from entry to entry\r\n		var cmviddiff_MOD_VAR=20;\r\n		// element counter per entry\r\n		var ec_MOD_VAR=10;\r\n				\r\n		function copyentry_MOD_VAR(no,entry) {\r\n\r\n			if (centry_mem_MOD_VAR==entry) {\r\n				document.getElementById(centry_mem_MOD_VAR).style.backgroundColor="transparent";\r\n				val_mem_MOD_VAR=new Array();\r\n				val_mem_saved_MOD_VAR=false;	\r\n				centry_mem_MOD_VAR=null;		\r\n				return false;\r\n			}	\r\n\r\n			if (centry_mem_MOD_VAR)\r\n				document.getElementById(centry_mem_MOD_VAR).style.backgroundColor="transparent";\r\n				\r\n			document.getElementById(entry).style.backgroundColor="white";\r\n			centry_mem_MOD_VAR=entry;\r\n\r\n			val_mem_saved_MOD_VAR=true;\r\n			\r\n			for (i=0;i<ec_MOD_VAR;i++) {\r\n				var no1=no+i;\r\n				if (document.editform["MOD_VAR["+no1+"]"]){\r\n					if (document.editform["MOD_VAR["+no1+"]"].type=="checkbox") {\r\n						val_mem_MOD_VAR[i]=document.editform["MOD_VAR["+no1+"]"].checked;\r\n					}\r\n					if (document.editform["MOD_VAR["+no1+"]"].type=="text" || document.editform["MOD_VAR["+no1+"]"].type=="textarea" || document.editform["MOD_VAR["+no1+"]"].type=="hidden") {\r\n						val_mem_MOD_VAR[i]=document.editform["MOD_VAR["+no1+"]"].value;\r\n					}\r\n					if (document.editform["MOD_VAR["+no1+"]"].type=="select-one") {\r\n						val_mem_MOD_VAR[i]=document.editform["MOD_VAR["+no1+"]"].selectedIndex;\r\n					}\r\n				}\r\n			}\r\n		}\r\n\r\n		function pasteentry_MOD_VAR(no) {\r\n			if (val_mem_saved_MOD_VAR==false)\r\n				return false;\r\n			if (centry_mem_MOD_VAR)\r\n				document.getElementById(centry_mem_MOD_VAR).style.backgroundColor="transparent";\r\n			for (i=0;i<ec_MOD_VAR;i++) {\r\n				var no1=no+i;\r\n				if (document.editform["MOD_VAR["+no1+"]"]){\r\n					if (document.editform["MOD_VAR["+no1+"]"].type=="checkbox") {\r\n						document.editform["MOD_VAR["+no1+"]"].checked=val_mem_MOD_VAR[i];\r\n					}\r\n					if (document.editform["MOD_VAR["+no1+"]"].type=="text" || document.editform["MOD_VAR["+no1+"]"].type=="textarea" || document.editform["MOD_VAR["+no1+"]"].type=="hidden") {\r\n						document.editform["MOD_VAR["+no1+"]"].value=val_mem_MOD_VAR[i];\r\n					}\r\n					if (document.editform["MOD_VAR["+no1+"]"].type=="select-one") {\r\n						document.editform["MOD_VAR["+no1+"]"].selectedIndex=val_mem_MOD_VAR[i];\r\n					}\r\n				}\r\n			}\r\n			val_mem_MOD_VAR=new Array();\r\n			val_mem_saved_MOD_VAR=false;\r\n			centry_mem_MOD_VAR=null;\r\n		}\r\n		\r\n		function inserentry_MOD_VAR(no,entries) {\r\n\r\n			if (document.editform["MOD_VAR["+(cmvid_MOD_VAR+(cmviddiff_MOD_VAR*(entries-1)))+"]"].checked==true) {\r\n				alert("Einfgen eines Eintrags nicht mglich, da der letzte Eintrag aktiv ist!\\nInsertion of an entry not possible because the last entry is active!");\r\n				return false;\r\n			}	\r\n\r\n			for (j=1;j<entries-((no-cmvid_MOD_VAR)/cmviddiff_MOD_VAR);j++) {\r\n					\r\n				for (i=0;i<ec_MOD_VAR;i++) {\r\n					var no2=(cmvid_MOD_VAR+(cmviddiff_MOD_VAR*(entries-j)))+i;\r\n					var no1=(cmvid_MOD_VAR+(cmviddiff_MOD_VAR*(entries-j-1)))+i;\r\n\r\n					if (document.editform["MOD_VAR["+no1+"]"]){\r\n\r\n						if(document.editform["MOD_VAR["+no1+"]"].type=="checkbox") {\r\n							document.editform["MOD_VAR["+no2+"]"].checked=document.editform["MOD_VAR["+no1+"]"].checked;\r\n						}\r\n						if(document.editform["MOD_VAR["+no1+"]"].type=="text" || document.editform["MOD_VAR["+no1+"]"].type=="textarea" || document.editform["MOD_VAR["+no1+"]"].type=="hidden") {\r\n							document.editform["MOD_VAR["+no2+"]"].value=document.editform["MOD_VAR["+no1+"]"].value;\r\n						}\r\n						if(document.editform["MOD_VAR["+no1+"]"].type=="select-one") {\r\n							document.editform["MOD_VAR["+no2+"]"].selectedIndex=document.editform["MOD_VAR["+no1+"]"].selectedIndex;\r\n						}\r\n						\r\n					}\r\n				}\r\n				\r\n			}\r\n			\r\n			if (val_mem_saved_MOD_VAR==false) {\r\n				for (i=no;i<no+ec_MOD_VAR;i++) {\r\n					if (document.editform["MOD_VAR["+i+"]"]){\r\n					\r\n						if(document.editform["MOD_VAR["+i+"]"].type=="checkbox") {\r\n							document.editform["MOD_VAR["+i+"]"].checked=false;\r\n						}\r\n						if(document.editform["MOD_VAR["+i+"]"].type=="text" || document.editform["MOD_VAR["+i+"]"].type=="textarea" || document.editform["MOD_VAR["+i+"]"].type=="hidden") {\r\n							document.editform["MOD_VAR["+i+"]"].value="";\r\n						}\r\n						if(document.editform["MOD_VAR["+i+"]"].type=="select-one") {\r\n							document.editform["MOD_VAR["+i+"]"].selectedIndex=null;\r\n						}\r\n						\r\n					}\r\n				}\r\n			} else {\r\n				if (centry_mem_MOD_VAR)\r\n					document.getElementById(centry_mem_MOD_VAR).style.backgroundColor="transparent";\r\n				for (i=0;i<ec_MOD_VAR;i++) {\r\n					var no1=no+i;\r\n					if (document.editform["MOD_VAR["+no1+"]"]){\r\n						if (document.editform["MOD_VAR["+no1+"]"].type=="checkbox") {\r\n							document.editform["MOD_VAR["+no1+"]"].checked=val_mem_MOD_VAR[i];\r\n						}\r\n						if (document.editform["MOD_VAR["+no1+"]"].type=="text" || document.editform["MOD_VAR["+no1+"]"].type=="textarea" || document.editform["MOD_VAR["+no1+"]"].type=="hidden") {\r\n							document.editform["MOD_VAR["+no1+"]"].value=val_mem_MOD_VAR[i];\r\n						}\r\n						if (document.editform["MOD_VAR["+no1+"]"].type=="select-one") {\r\n							document.editform["MOD_VAR["+no1+"]"].selectedIndex=val_mem_MOD_VAR[i];\r\n						}\r\n					}\r\n				}\r\n				val_mem_MOD_VAR=new Array();\r\n				val_mem_saved_MOD_VAR=false;	\r\n				centry_mem_MOD_VAR=null;			\r\n			}\r\n			\r\n		}\r\n		\r\n		function cutentry_MOD_VAR(no,entries,entry) {\r\n			if (document.editform["MOD_VAR["+no+"]"].checked==true) {\r\n				alert("Aktive Eintrge knnen nicht entfernt werden!\\nActive entries can\\''t be removed!");\r\n				return false;\r\n			}	\r\n		\r\n			if (centry_mem_MOD_VAR)\r\n				document.getElementById(centry_mem_MOD_VAR).style.backgroundColor="transparent";\r\n				\r\n			document.getElementById(entry).style.backgroundColor="white";\r\n			centry_mem_MOD_VAR=entry;\r\n\r\n			val_mem_saved_MOD_VAR=true;\r\n			\r\n			for (i=0;i<ec_MOD_VAR;i++) {\r\n				var no1=no+i;\r\n				if (document.editform["MOD_VAR["+no1+"]"]){\r\n					if (document.editform["MOD_VAR["+no1+"]"].type=="checkbox") {\r\n						val_mem_MOD_VAR[i]=document.editform["MOD_VAR["+no1+"]"].checked;\r\n					}\r\n					if (document.editform["MOD_VAR["+no1+"]"].type=="text" || document.editform["MOD_VAR["+no1+"]"].type=="textarea" || document.editform["MOD_VAR["+no1+"]"].type=="hidden") {\r\n						val_mem_MOD_VAR[i]=document.editform["MOD_VAR["+no1+"]"].value;\r\n					}\r\n					if (document.editform["MOD_VAR["+no1+"]"].type=="select-one") {\r\n						val_mem_MOD_VAR[i]=document.editform["MOD_VAR["+no1+"]"].selectedIndex;\r\n					}\r\n				}\r\n			}		\r\n			\r\n			\r\n			\r\n			for (j=((no-cmvid_MOD_VAR)/cmviddiff_MOD_VAR);j<entries;j++) {\r\n			\r\n				for (i=0;i<ec_MOD_VAR;i++) {\r\n					var no2=(cmvid_MOD_VAR+(cmviddiff_MOD_VAR*(j+1)))+i;\r\n					var no1=(cmvid_MOD_VAR+(cmviddiff_MOD_VAR*(j)))+i;\r\n\r\n					if (document.editform["MOD_VAR["+no2+"]"]){\r\n						if(document.editform["MOD_VAR["+no2+"]"].type=="checkbox") {\r\n							document.editform["MOD_VAR["+no1+"]"].checked=document.editform["MOD_VAR["+no2+"]"].checked;\r\n						}\r\n						if(document.editform["MOD_VAR["+no2+"]"].type=="text" || document.editform["MOD_VAR["+no2+"]"].type=="textarea" || document.editform["MOD_VAR["+no2+"]"].type=="hidden") {\r\n							document.editform["MOD_VAR["+no1+"]"].value=document.editform["MOD_VAR["+no2+"]"].value;\r\n						}\r\n						if(document.editform["MOD_VAR["+no2+"]"].type=="select-one") {\r\n							document.editform["MOD_VAR["+no1+"]"].selectedIndex=document.editform["MOD_VAR["+no2+"]"].selectedIndex;\r\n						}\r\n					}\r\n				}\r\n			}\r\n	\r\n			for (i=(cmvid_MOD_VAR+((entries-1)*cmviddiff_MOD_VAR));i<(cmvid_MOD_VAR+((entries-1)*cmviddiff_MOD_VAR))+ec_MOD_VAR;i++) {\r\n				if (document.editform["MOD_VAR["+i+"]"]){\r\n					if(document.editform["MOD_VAR["+i+"]"].type=="checkbox") {\r\n						document.editform["MOD_VAR["+i+"]"].checked=false;\r\n					}\r\n					if(document.editform["MOD_VAR["+i+"]"].type=="text" || document.editform["MOD_VAR["+i+"]"].type=="textarea" || document.editform["MOD_VAR["+i+"]"].type=="hidden") {\r\n						document.editform["MOD_VAR["+i+"]"].value="";\r\n					}\r\n					if(document.editform["MOD_VAR["+i+"]"].type=="select-one") {\r\n						document.editform["MOD_VAR["+i+"]"].selectedIndex=null;\r\n					}\r\n				}\r\n			}	\r\n		}		\r\n\r\n\r\n		function rotateentry_MOD_VAR(no,direction) {\r\n			for (i=0;i<ec_MOD_VAR;i++) {\r\n				if (direction=="up") {\r\n					var no1=no+i;\r\n					var no2=no-cmviddiff_MOD_VAR+i;\r\n				} \r\n				if (direction=="down") {\r\n					var no1=no+i;\r\n					var no2=cmviddiff_MOD_VAR+no+i;\r\n				} \r\n				if (document.editform["MOD_VAR["+no1+"]"]){\r\n					if (document.editform["MOD_VAR["+no1+"]"].type=="checkbox") {\r\n						var val_mem1=document.editform["MOD_VAR["+no1+"]"].checked;\r\n						var val_mem2=document.editform["MOD_VAR["+no2+"]"].checked;\r\n						document.editform["MOD_VAR["+no1+"]"].checked=val_mem2;\r\n						document.editform["MOD_VAR["+no2+"]"].checked=val_mem1;\r\n					}\r\n					if (document.editform["MOD_VAR["+no1+"]"].type=="text" || document.editform["MOD_VAR["+no1+"]"].type=="textarea" || document.editform["MOD_VAR["+no1+"]"].type=="hidden") {\r\n						var val_mem1=document.editform["MOD_VAR["+no1+"]"].value;\r\n						var val_mem2=document.editform["MOD_VAR["+no2+"]"].value;\r\n						document.editform["MOD_VAR["+no1+"]"].value=val_mem2;\r\n						document.editform["MOD_VAR["+no2+"]"].value=val_mem1;\r\n					}\r\n					if (document.editform["MOD_VAR["+no1+"]"].type=="select-one") {\r\n						var val_mem1=document.editform["MOD_VAR["+no1+"]"].selectedIndex;\r\n						var val_mem2=document.editform["MOD_VAR["+no2+"]"].selectedIndex;\r\n						document.editform["MOD_VAR["+no1+"]"].selectedIndex=val_mem2\r\n						document.editform["MOD_VAR["+no2+"]"].selectedIndex=val_mem1;\r\n					}\r\n				}\r\n			}\r\n		}\r\n\r\n	</script>\r\n\r\n\r\n\r\n\r\n	\r\n	<table border="0" width="100%">\r\n	      <tr>\r\n	      <td  style="background-color:#B7D9FF;font-weight:bold;">Nr</td>\r\n	      <td  style="background-color:#B7D9FF;font-weight:bold;">Aktiv</td>\r\n	      <td  style="background-color:#DFEEFF;font-weight:bold;" style="width:90%">Typ</td>'';\r\n\r\n	$mip_forms_tab_temp = $mip_forms_tab;\r\n	\r\n	$mip_forms_tab[''open'']  = '''';\r\n	$mip_forms_tab[''close'']  = '''';\r\n	$mip_forms_tab[''left'']  = ''<!--%s-->%s'';\r\n	$mip_forms_tab[''left_width''] = '''';\r\n	$mip_forms_tab[''right''] = ''%s'';\r\n	$mip_forms_tab[''full''] = ''<td>%s<br>%s</td><td width="5">&nbsp;</td></tr>'';\r\n	$mip_forms_tab[''tab''] = ''<td width="20" valign="top">%s</td>'';	\r\n	$ecount = 100;\r\n\r\n	for($i=0;$i < $cms_mod[''value''][''0''];$i++){\r\n		$frm_active = $ecount;\r\n		$frm_type = $ecount+1;\r\n		$frm_label = $ecount+2;\r\n		$frm_default = $ecount+3;\r\n		$frm_validate = $ecount+4;\r\n		$frm_attributes_label = $ecount+5;\r\n		$frm_attributes_formelement = $ecount+6;\r\n		$frm_custom_element_error = $ecount+7;\r\n		$frm_select_elementcontainer = $ecount+8;				\r\n//n+7 custom element- error\r\n//n+8 select tpl elementcontainer		\r\n		//aktiv\r\n		$mip_form[$frm_active][''cat''] = ''chk'';\r\n		$mip_form[$frm_active][''option_var''][''0''] = ''MOD_VAR[''.$frm_active.'']'';\r\n		$mip_form[$frm_active][''option_val''][''0''] = $cms_mod[''value''][$frm_active];\r\n		$mip_form[$frm_active][''option_val_select''][''0''] = ''true'';\r\n		\r\n		//typ\r\n		$mip_form[$frm_type][''cat''] = ''option'';\r\n		$mip_form[$frm_type][''size''] = ''1'';\r\n		$mip_form[$frm_type][''option_desc''][] = ''Einzeiliges Textfeld'';\r\n		$mip_form[$frm_type][''option_val''][] =  ''text'';\r\n		$mip_form[$frm_type][''option_desc''][] = ''Einzeiliges Passwortfeld'';\r\n		$mip_form[$frm_type][''option_val''][] =  ''password'';\r\n		$mip_form[$frm_type][''option_desc''][] = ''Mehrzeiliges Textfeld'';\r\n		$mip_form[$frm_type][''option_val''][] =  ''textarea'';\r\n		$mip_form[$frm_type][''option_desc''][] = ''Selectbox'';\r\n		$mip_form[$frm_type][''option_val''][] =  ''option'';\r\n		$mip_form[$frm_type][''option_desc''][] = ''Selectbox, Mehrfachauswahl'';\r\n		$mip_form[$frm_type][''option_val''][] =  ''optionMutiple'';\r\n		$mip_form[$frm_type][''option_desc''][] = ''Optionsfelder'';\r\n		$mip_form[$frm_type][''option_val''][] =  ''radio'';\r\n		$mip_form[$frm_type][''option_desc''][] = ''Checkbox'';\r\n		$mip_form[$frm_type][''option_val''][] =  ''checkbox'';\r\n		$mip_form[$frm_type][''option_desc''][] = ''Checkbox, vorselektiert'';\r\n		$mip_form[$frm_type][''option_val''][] =  ''checkboxSelected'';\r\n		$mip_form[$frm_type][''option_desc''][] = ''Dateiupload'';\r\n		$mip_form[$frm_type][''option_val''][] =  ''upload'';\r\n		$mip_form[$frm_type][''option_desc''][] = ''Versteckter Wert'';\r\n		$mip_form[$frm_type][''option_val''][] =  ''hidden'';\r\n		$mip_form[$frm_type][''option_desc''][] = ''Nur Beschriftung'';\r\n		$mip_form[$frm_type][''option_val''][] =  ''label'';\r\n		$mip_form[$frm_type][''option_desc''][] = ''Platzhalter'';\r\n		$mip_form[$frm_type][''option_val''][] =  ''locumtenency'';		\r\n		$mip_form[$frm_type][''option_desc''][] = ''Captchabild'';\r\n		$mip_form[$frm_type][''option_val''][] =  ''captchaimage'';		\r\n		$mip_form[$frm_type][''cms_var''] = ''MOD_VAR[''.$frm_type.'']'';\r\n		$mip_form[$frm_type][''cms_val''] = $cms_mod[''value''][$frm_type];\r\n		\r\n		//label\r\n		$label_element = ''<input type="text" name="MOD_VAR[''.$frm_label.'']" style="width:240px" value="''.htmlentities( $cms_mod[''value''][$frm_label], ENT_COMPAT, ''UTF-8'' ).''" />'';\r\n		\r\n		//default\r\n		$def_element = ''<input type="text" name="MOD_VAR[''.$frm_default.'']" style="width:240px" value="''.htmlentities( $cms_mod[''value''][$frm_default], ENT_COMPAT, ''UTF-8'' ).''" />'';\r\n		\r\n		//opt attributes\r\n		$opt_attributes_label = ''<input type="text" name="MOD_VAR[''.$frm_attributes_label.'']" style="width:240px" value="''.htmlentities( $cms_mod[''value''][$frm_attributes_label], ENT_COMPAT, ''UTF-8'' ).''" />'';\r\n		$opt_attributes_formelement = ''<input type="text" name="MOD_VAR[''.$frm_attributes_formelement.'']" style="width:240px" value="''.htmlentities( $cms_mod[''value''][$frm_attributes_formelement], ENT_COMPAT, ''UTF-8'' ).''" />'';\r\n		\r\n		//custom error\r\n		$frm_custom_element_error = ''<input type="text" name="MOD_VAR[''.$frm_custom_element_error.'']" style="width:240px" value="''.htmlentities( $cms_mod[''value''][$frm_custom_element_error], ENT_COMPAT, ''UTF-8'' ).''" />'';\r\n		\r\n		//validierung\r\n		$mip_form[$frm_validate][''cat''] = ''option'';\r\n		$mip_form[$frm_validate][''size''] = ''1'';\r\n		$mip_form[$frm_validate][''option_desc''][] = ''Keine'';\r\n		$mip_form[$frm_validate][''option_val''][] =  ''false'';\r\n		$mip_form[$frm_validate][''option_desc''][] = ''Nicht leer'';\r\n		$mip_form[$frm_validate][''option_val''][] =  ''required'';\r\n		$mip_form[$frm_validate][''option_desc''][] = ''Email'';\r\n		$mip_form[$frm_validate][''option_val''][] =  ''email'';\r\n		$mip_form[$frm_validate][''option_desc''][] = ''Email oder leer'';\r\n		$mip_form[$frm_validate][''option_val''][] =  ''emailOrEmpty'';\r\n		$mip_form[$frm_validate][''cms_var''] = ''MOD_VAR[''.$frm_validate.'']'';\r\n		$mip_form[$frm_validate][''cms_val''] = $cms_mod[''value''][$frm_validate];\r\n		\r\n		//tpl elementcontainer\r\n		$mip_form[$frm_select_elementcontainer][''cat''] = ''option'';\r\n		$mip_form[$frm_select_elementcontainer][''size''] = ''1'';\r\n		$mip_form[$frm_select_elementcontainer][''option_desc''][] = ''Elementcontainer 1'';\r\n		$mip_form[$frm_select_elementcontainer][''option_val''][] =  ''1'';\r\n		$mip_form[$frm_select_elementcontainer][''option_desc''][] = ''Elementcontainer 2''; \r\n		$mip_form[$frm_select_elementcontainer][''option_val''][] =  ''2'';\r\n		$mip_form[$frm_select_elementcontainer][''option_desc''][] = ''Elementcontainer 3'';\r\n		$mip_form[$frm_select_elementcontainer][''option_val''][] =  ''3'';\r\n		$mip_form[$frm_select_elementcontainer][''option_desc''][] = ''Elementcontainer 4''; \r\n		$mip_form[$frm_select_elementcontainer][''option_val''][] =  ''4'';\r\n		$mip_form[$frm_select_elementcontainer][''cms_var''] = ''MOD_VAR[''.$frm_select_elementcontainer.'']'';\r\n		$mip_form[$frm_select_elementcontainer][''cms_val''] = $cms_mod[''value''][$frm_select_elementcontainer];\r\n\r\n		\r\n		$cf_formfieldtable .= ''<tr>'';\r\n		$element_nr = ($i < 9) ? (''0''. ($i+1) ): $i+1;\r\n		$cf_formfieldtable .= ''<td valign="top" style="background-color:#B7D9FF"><b>''. $element_nr  .''</b></td>'';\r\n		$cf_formfieldtable .= ''<td align="center" valign="top"  style="background-color:#B7D9FF">''. mip_forms($mip_form[$frm_active]) .''</td>'';\r\n		$cf_formfieldtable .= ''<td valign="top" style="background-color:#DFEEFF">''. mip_forms($mip_form[$frm_type]) .''</td>'';\r\n		$cf_formfieldtable .= ''</tr><tr><td align="center" colspan="2" style="padding-top:3px;background-color:#B7D9FF;">'';\r\n		if ($cms_mod[''value''][''0'']>1)\r\n			$cf_formfieldtable .= ''			<div id="copy_MOD_VAR_''.$ecount.''" style="padding:3px 3px 3px 3px;width:40px;margin:auto;"	>\r\n				<input type="button" value="cut" title="Formularfled ausschneiden, darunterliegenden Felder rcken um eine Position nach oben" onclick="cutentry_MOD_VAR(''.$ecount.'',''.$cms_mod[''value''][''0''].'',\\''copy_MOD_VAR_''.$ecount.''\\'')" style="width:40px;font-weight:bold;font-size:10px;display:block;" />\r\n				<input type="button" value="copy" title="In die Zwischenablage kopieren" onclick="copyentry_MOD_VAR(''.$ecount.'',\\''copy_MOD_VAR_''.$ecount.''\\'')" style="width:40px;font-weight:bold;font-size:10px;cursor:pointer;display:block;" />\r\n				<input type="button" value="paste" title="Einfgen, vorhandene Formulardaten werden berschrieben" onclick="pasteentry_MOD_VAR(''.$ecount.'')" style="width:40px;font-weight:bold;font-size:10px;cursor:pointer;display:block;" />\r\n				<input type="button" value="insert" title="Einfgen, vorhanden Formulardaten verschieben sich eine Position nach unten" onclick="inserentry_MOD_VAR(''.$ecount.'',''.$cms_mod[''value''][''0''].'');" style="width:40px;font-weight:bold;font-size:10px;cursor:pointer;display:block;" />\r\n			</div>			\r\n			<div style="padding:3px 3px 5px 3px;width:40px;margin:auto;"	>'';\r\n\r\n		if ($i>0)\r\n			$cf_formfieldtable .= ''				<input type="button" value="up" title="Eine Position nach oben verschieben" onclick="rotateentry_MOD_VAR(''.$ecount.'',\\''up\\'');" style="width:40px;font-weight:bold;font-size:10px;cursor:pointer;display:block;" />'';\r\n		else\r\n			$cf_formfieldtable .= ''				<div style="width:40px;height:18px;">&nbsp;</div>'';\r\n	\r\n		if ($i<$cms_mod[''value''][''0'']-1)\r\n			$cf_formfieldtable .= ''				<input type="button" value="down" title="Eine Position nach unten verschieben" onclick="rotateentry_MOD_VAR(''.$ecount.'',\\''down\\'')" style="width:40px;font-weight:bold;font-size:10px;cursor:pointer;display:block;" />'';\r\n		else\r\n			$cf_formfieldtable .= ''				<div style="width:40px;height:18px;">&nbsp;</div>'';		\r\n\r\n\r\n		$cf_formfieldtable .= ''			</div></div>\r\n		</td><td>'';\r\n		\r\n		$cf_formfieldtable .= ''<table border="0" width="100%">\r\n	      <tr style="font-weight: bold;">\r\n	      <td>Label</td>\r\n	      <td>Defaultwert*</td>\r\n	      <td>Validierung</td>\r\n	      </tr>\r\n	      <tr>\r\n	      <td>''. $label_element .''</td>\r\n	      <td>''. $def_element .''</td>\r\n	      <td>''. mip_forms($mip_form[$frm_validate]) .''</td>\r\n	      </tr>\r\n	      <tr style="font-weight: bold;">\r\n	      <td>Optionale Attribute Label</td>\r\n          <td>Opt. Attribute Formularelement</td>\r\n          <td>Template</td>\r\n	      </tr>\r\n	      <tr>\r\n	      <td>''. $opt_attributes_label .''</td>\r\n		  <td>''. $opt_attributes_formelement .''</td>\r\n          <td>''.mip_forms($mip_form[$frm_select_elementcontainer]).''</td>\r\n	      </tr>\r\n	      <tr style="font-weight: bold;">\r\n	      <td>Fehlermeldung</td>\r\n          <td></td>\r\n          <td></td>\r\n	      </tr>\r\n	      <tr>\r\n	      <td>''. $frm_custom_element_error .''</td>\r\n		  <td></td>\r\n          <td></td>\r\n	      </tr>\r\n	      </table>'';\r\n	      \r\n	    $cf_formfieldtable .= ''</td></tr>'';\r\n		\r\n		$ecount = $ecount+20;		\r\n	}\r\n	$mip_forms_tab = $mip_forms_tab_temp;\r\n	      	\r\n	\r\n	$cf_formfieldtable .= ''</table>\r\n	<small>*: Wird das Element Selectbox ausgewhlt, sind die einezelnen Auswahlelemente kommasepariert anzugben,\r\n	z.B. "Tomaten ,Birnen ,Orangen". Checkbox- Defaultwerte werden im Formular nicht angezeigt. Wird die\r\n	Checkbox vom Versender markiert, wird dieser Wert im bermittelten Kontaktformular sichtbar.</small>'';\r\n	\r\n	\r\n	$cf_formfieldtable .= ''<table cellspacing="0" cellpadding="0" border="0" width="100%">\r\n	  <tr>\r\n	    <td align="right"><select name="MOD_VAR[1]" size="1" onchange="document.editform.action.value=\\''change\\'';if(document.editform.anchor){document.editform.anchor.value=\\''''. $_container_name .''\\''};document.editform.submit();">\r\n	      <option value="0" selected>Spalte erstellen - lschen</option>'';\r\n	      if ($cms_mod[''value''][''0''] >= ''13'') $cf_formfieldtable .= "<option value=\\"-12\\">-12</option>";\r\n	      if ($cms_mod[''value''][''0''] >= ''7'') $cf_formfieldtable .= "<option value=\\"-6\\">-6</option>";\r\n	      if ($cms_mod[''value''][''0''] >= ''4'') $cf_formfieldtable .= "<option value=\\"-3\\">-3</option>";\r\n	      if ($cms_mod[''value''][''0''] >= ''3'') $cf_formfieldtable .= "<option value=\\"-2\\">-2</option>";\r\n	      if ($cms_mod[''value''][''0''] >= ''2'') $cf_formfieldtable .= "<option value=\\"-1\\">-1</option>";\r\n	      $cf_formfieldtable .= ''<option value="1">+1</option>\r\n	      <option value="2">+2</option>\r\n	      <option value="3">+3</option>\r\n          <option value="6">+6</option>\r\n          <option value="12">+12</option>\r\n	    </select><br /><br /></td>\r\n	  </tr>\r\n	</table>'';\r\n	//------------------------------------------------\r\n	//END GENERATE FORMFIELDS\r\n	//------------------------------------------------\r\n\r\nmip_forms_tabpane_beginp();\r\nmip_forms_tabitem_beginp(''Formularfelder'');	\r\n	mip_formsp($mip_form[''0'']);//hidden anzahl formularfehler\r\n	echo $cf_formfieldtable;//all formfields\r\nmip_forms_tabitem_endp();\r\n\r\nmip_forms_tabitem_beginp(''Maileinstellungen'');\r\n	echo ''<p><strong>Email 1:</strong></p>'';\r\n	mip_formsp($mip_form[''65'']);//select email versenden ja, nein\r\n	mip_formsp($mip_form[''desc'']);//email empfnger\r\n	mip_formsp($mip_form[''12'']);//empfnger aus textfeld\r\n	mip_formsp($mip_form[''57'']);//txt email cc \r\n	mip_formsp($mip_form[''58'']);//txt email bcc\r\n	mip_formsp($mip_form[''41'']);//empfnger aus GET Parameter\r\n	mip_formsp($mip_form[''27'']);//email absender\r\n	mip_formsp($mip_form[''11'']);//subject\r\n	mip_formsp($mip_form[''56'']);//template email\r\n	//DEPRECATED\r\n	//	mip_formsp($mip_form[''28'']);//mit fieldset\r\n	//	mip_formsp($mip_form[''29'']);//fieldset legend\r\n	\r\n	echo ''<p><strong>Email 2:</strong></p>'';\r\n	mip_formsp($mip_form[''68'']);//select Weitere Email verschicken ja|nein\r\n	mip_formsp($mip_form[''80'']);//txt Weitere Email Emailadresse Absender\r\n	mip_formsp($mip_form[''81'']);//txt Weitere Email Emailadresse Empfnger\r\n	mip_formsp($mip_form[''69'']);//txt Weitere Email subject\r\n	mip_formsp($mip_form[''70'']);//txtarea template Weitere Email\r\n	\r\nmip_forms_tabitem_endp();\r\nmip_forms_tabitem_beginp(''Styles'');\r\n	mip_formsp($mip_form[''15'']);//style fehler		\r\n	mip_formsp($mip_form[''16'']);//style besttigung		\r\n	mip_formsp($mip_form[''17'']);//style label	\r\n	mip_formsp($mip_form[''18'']);//style label bei fehler\r\n	mip_formsp($mip_form[''53'']);//style fehlermeldung im element		\r\n\r\n	mip_formsp($mip_form[''19'']);//style text		\r\n	mip_formsp($mip_form[''31'']);//style passwort		\r\n	mip_formsp($mip_form[''20'']);//style textarea	\r\n	mip_formsp($mip_form[''21'']);//style select		\r\n	mip_formsp($mip_form[''32'']);//style select, mutiple		\r\n	mip_formsp($mip_form[''33'']);//style option		\r\n	mip_formsp($mip_form[''22'']);//style checkbox\r\n	mip_formsp($mip_form[''52'']);//style upload		\r\n	mip_formsp($mip_form[''34'']);//style nur beschriftung\r\n	mip_formsp($mip_form[''79'']);//style captcha textfield		\r\n	mip_formsp($mip_form[''35'']);//style label\r\n	mip_formsp($mip_form[''23'']);//style submitbutton		\r\n\r\nmip_forms_tabitem_endp();\r\nmip_forms_tabitem_beginp(''Meldungen & Templates'');\r\n	echo ''<p><strong>Meldungen:</strong></p>'';\r\n	mip_formsp($mip_form[''14'']);//erfolgreich verschickt\r\n	mip_formsp($mip_form[''24'']);//beschriftung submitbutton\r\n	mip_formsp($mip_form[''13'']);//fehler\r\n	mip_formsp($mip_form[''49'']);//upload err ext\r\n	mip_formsp($mip_form[''50'']);//upload err size\r\n	mip_formsp($mip_form[''51'']);//upload err int\r\n	\r\n	echo ''<p><strong>Templates:</strong></p>'';\r\n	mip_formsp($mip_form[''25'']);//template gesamt		\r\n	mip_formsp($mip_form[''26'']);//template elementcontainer 1\r\n	mip_formsp($mip_form[''46'']);//template elementcontainer 2\r\n	mip_formsp($mip_form[''66'']);//template elementcontainer 3\r\n	mip_formsp($mip_form[''86'']);//template elementcontainer 4\r\n	mip_formsp($mip_form[''82'']);//template requirenotice\r\n	mip_formsp($mip_form[''83'']);//template labelcontent\r\n	mip_formsp($mip_form[''78'']);//template captchaimage		\r\n	mip_formsp($mip_form[''38'']);//template messageblock		\r\n	mip_formsp($mip_form[''39'']);//template formstart		\r\n	mip_formsp($mip_form[''40'']);//template formend	\r\n	mip_formsp($mip_form[''42'']);//template platzhalter\r\n	mip_formsp($mip_form[''43'']);//template element fehler\r\n	mip_formsp($mip_form[''54'']);//template standard {textfromdynamic} \r\n	mip_formsp($mip_form[''55'']);//template standard {textareafromdynamic} \r\n	\r\nmip_forms_tabitem_endp();\r\nmip_forms_tabitem_beginp(''Sonstiges'');\r\n	\r\n	echo ''<p><strong>Captcha:</strong></p>'';\r\n	mip_formsp($mip_form[''73'']);//txt captchaimage length\r\n	mip_formsp($mip_form[''74'']);//txt captchaimage width\r\n	mip_formsp($mip_form[''75'']);//txt captchaimage height\r\n	mip_formsp($mip_form[''76'']);//txt captchaimage attributes\r\n	mip_formsp($mip_form[''77'']);//txt captchaimage styleset\r\n\r\n	echo ''<p><strong>Dateiuploads:</strong></p>'';\r\n	mip_formsp($mip_form[''47'']);//upload allowed extensions\r\n	mip_formsp($mip_form[''48'']);//upload max filesize\r\n	mip_formsp($mip_form[''61'']);//select Dateiuploads im Dateisystem ablegen\r\n	mip_formsp($mip_form[''62'']);//select Ordner fr Uploads\r\n	\r\n	//reportviewersettings\r\n	if(is_file($cfg_cms[''cms_path''].''plugins/reportviewer/index.php'')) {\r\n		echo ''<p><strong>Reportviewer:</strong></p>'';\r\n		mip_formsp($mip_form[''59'']);//select daten in db speichern ja, nein\r\n		mip_formsp($mip_form[''60'']);//txt default gruppen identifier \r\n		mip_formsp($mip_form[''71'']);//select gespeicherte db werte sind online|offline\r\n	}\r\n\r\n	echo ''<p><strong>Logging:</strong></p>'';\r\n	mip_formsp($mip_form[''63'']);//select Formulareingaben mitloggen ja/ nein\r\n	mip_formsp($mip_form[''64'']);//txt logfile relativ vom frontend aus, default logs/\r\n	\r\n	echo ''<p><strong>Sonstige Einstellungen:</strong></p>'';\r\n	mip_formsp($mip_form[''67'']);//weiterleitung bei erfolg\r\n	mip_formsp($mip_form[''44'']);//debug\r\n	mip_formsp($mip_form[''36'']);//trenner - einzelne auswahlmglichkeiten\r\n	mip_formsp($mip_form[''37'']);//trenner - key, value FEATURE VERSCHOBEN\r\n	mip_formsp($mip_form[''10'']);//configmode\r\n	mip_formsp($mip_form[''72'']);//txt addon object	\r\n	\r\n		\r\nmip_forms_tabitem_endp();\r\nmip_forms_tabpane_endp();\r\n\r\n}\r\nunset($mip_form);\r\n\r\n\r\n\r\n\r\n\r\n} // end $is_dev\r\nunset($is_dev);\r\n?>', '<CMSPHP>\r\n$is_dev = false;\r\n</CMSPHP>\r\n\r\n\r\n<CMSPHP:CACHE>\r\n// (c) 2004 - 2006 by Bjrn Brockmann\r\n// needs PHP 4.1+\r\n\r\n//Alle Variablen, die nur innerhalb des gecachten PHPs sichtbar sind, auch fr dynamisches PHP zur Verfgung stellen\r\necho ''<CMSPHP>'';\r\nif (is_array($cms_mod[''value''])) {\r\nforeach($cms_mod[''value''] AS $k => $v){\r\n	echo ''$mvars["''.$k.''"] = "''. addslashes($v) .''";''."\\n";\r\n}}\r\necho ''</CMSPHP>'';\r\n</CMSPHP:CACHE>\r\n\r\n<CMSPHP>\r\n\r\nif($is_dev) {\r\ninclude "C:/Programme/xampp/htdocs/sefrengo_dev/moddev/kontakformularOUT.php";\r\n} else {\r\n\r\nif(! class_exists(gooseberry_form)){\r\nclass gooseberry_form\r\n{\r\n	var $version = 0.82;\r\n	//debug mode\r\n	var $debug = false;\r\n	//debug message\r\n	var $debugmessage = '''';\r\n	//send mail\r\n	var $send_mail = true;\r\n	//logging\r\n	var $logging_active = false;\r\n	var $logging_file = ''logs/contact_log.txt'';\r\n	\r\n	var $charset = ''iso-8859-1'';\r\n	var $is_rule_violation = false;\r\n	var $invalid_fields = array();\r\n	var $rules = array(\r\n					''required''     => ''/(\\s|\\S)/'',\r\n					''email''        => ''/^[a-zA-Z0-9\\._-]+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$/'',\r\n					''emailOrEmpty'' => ''/(^$)|(^[a-zA-Z0-9\\._-]+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$)/''\r\n					);\r\n	var $field_styles = array();\r\n	var $stack = array();\r\n	\r\n	//final template to combinate all elements\r\n	var $combination_tpl = ''<table border="0" cellpadding="0" cellspacing="0">\r\n                              <tr><td align="right" colspan="2">{usermessage}</td></tr>\r\n                                {formstart} {formelementblock}  \r\n                              <tr><td align="right" colspan="2">{submit}</td></tr>\r\n                              {formend}\r\n                            </table>'';\r\n	\r\n	//message block template\r\n	var $message_block_tpl = ''{usermessage}'';\r\n\r\n	//template for the form element seperator \r\n	var $separator_tpl = ''<br /><br />'';\r\n\r\n	//template for one form row\r\n	var $row_tpl = array(1 =>''<tr><td valign="top">{label} &nbsp;&nbsp;</td><td>{element}</td></tr>'');\r\n	\r\n	//template labelcontent\r\n	var $tpl_labeltext = ''{labelcontent}{requirenotice}'';\r\n	\r\n	//template required notice\r\n	var $tpl_label_required_notice = ''&nbsp;*'';\r\n\r\n	//template for formstarttag\r\n	var $tpl_formstarttag = ''<form id="b2st-form" method="post" action="{url}" enctype="multipart/form-data">'';\r\n\r\n	//template for formendttag\r\n	var $tpl_formendtag = ''</form>'';\r\n\r\n	//template for elementerror\r\n	var $tpl_elementerror = ''{errormessage}<br /><br />'';\r\n	\r\n	//some fallbacks if get mode is active, but no data was found\r\n	var $fallback_textfromdynamic = '''';\r\n	var $fallback_textareafromdynamic = '''';\r\n\r\n	//url for form- action- parameter\r\n	var $form_target_url;\r\n\r\n	//email receiptor mode - possible values are textfield and get\r\n	var $email_receiptor_mode = ''textfield'';\r\n\r\n	//settings for email receiptor mode ''get''\r\n	var $email_receiptor_get_mode_idcatside;\r\n	var $email_receiptor_get_mode_idcontainer;	\r\n\r\n	//settings for email receiptor mode ''textfield''\r\n	var $email_receiptor_textfield_mode_mailadress;\r\n	\r\n	// cc and bcc\r\n	var $email_receiptor_cc;\r\n	var $email_receiptor_bcc;\r\n	\r\n	\r\n	//emailadress sender\r\n	var $email_sender;\r\n\r\n	//email subject\r\n	var $email_subject;\r\n	\r\n	//success message\r\n	var $message_success = ''Vielen Dank, die Daten wurden versandt'';\r\n\r\n	//error message\r\n	var $message_error = ''Bitte berprfen Sie Ihre Formulareingaben:'';\r\n\r\n	//submitbutton text\r\n	var $submitbutton_text = ''Abschicken'';\r\n\r\n	//mutiple value separator\r\n	var $mutiple_value_separator = '','';\r\n\r\n	//key/ value separator\r\n	var $key_value_separator = ''@@'';\r\n	\r\n	//all hidden values\r\n	var $hiddenvalues;	\r\n	\r\n	//email template\r\n	var $tpl_email = ''{automessage}'';\r\n	\r\n	//send confirmmail\r\n	var $confirm_mail_active = false;\r\n	//\r\n	var $confirm_mail_subject = ''Kontaktformular Confirm'';\r\n	//\r\n	var $confirm_mail_tpl = ''{automessage}'';\r\n	\r\n	//addon object\r\n	var $addon;\r\n	\r\n	\r\n	//2d array with all informations about uploaded files in it\r\n	//[''element_name''][''file''] - filepath\r\n	//[''element_name''][''error''] - contains errormessage for user if occurs\r\n	//[''element_name''][''int_error''] - contains internal errormessage\r\n	var $uploads = array();\r\n	\r\n	var $upload_errors = array( ''deb_filesize_php_ini'' => ''Die hochgeladene Datei ueberschreitet die in der Anweisung upload_max_filesize in php.ini festgelegte Groesse.'',\r\n								''deb_filesize_browser'' => ''Die hochgeladene Datei ueberschreitet die in dem HTML Formular mittels der Anweisung MAX_FILE_SIZE angegebene maximale Dateigroesse.'',\r\n								''deb_filesize_incremental'' => ''Die Datei wurde nur teilweise hochgeladen.'',\r\n								''deb_no_file'' => ''Es wurde keine Datei hochgeladen.'',\r\n								''deb_filecopy_fails'' => ''upload fails - check writepremissons for backend/upload/in/'',\r\n								''usr_allowed_ext'' => ''Dieser Dateityp darf nicht hochgeladen werden'',\r\n								''usr_allowed_size'' => ''Die maximal zulaessige Dateigroesse wurde ueberschritten'',\r\n								''usr_internal_error'' => ''Beim Upload ist ein interner Fehler aufgetreten''\r\n									);	\r\n	\r\n	//allowed fileextensions for uploadfiles - comma separated\r\n	var $upload_allowed_extensions;\r\n\r\n	//allowed filesize for uploadfiles in kb\r\n	var $upload_allowed_filesize;\r\n	\r\n	//temp upload dir for files\r\n	var $upload_dir;\r\n	\r\n	//snippet replacement stuff. Possible values are str unknown, true false\r\n	var $snippet_replacement_found = ''unknown'';\r\n	var $snippet_object = false;\r\n	\r\n	function gooseberry_form() \r\n	{\r\n		$this->addon =& new gooseberry_form_addon;\r\n	}\r\n	\r\n	\r\n	/*\r\n	 * -----------------------------------------------------------\r\n	 * FORM PARSER METHODS\r\n	 * -----------------------------------------------------------\r\n	 */\r\n	function parse_elements()\r\n	{\r\n		$this->parsed_plain = '''';\r\n		$this->parsed = '''';\r\n		$p =''''; $pp ='''';\r\n		//print_r($this->stack);\r\n		foreach ($this->stack AS $k => $v)\r\n		{\r\n			\r\n			//addon preParse\r\n			$this->addon->onPreParse($v, $this->stack);\r\n			\r\n			//collect all hidden values separatly\r\n			if ($v[''type''] == ''hidden'')\r\n			{\r\n				$this->hiddenvalues .= $this->get_formelement($v[''name''], $v[''type''], $v[''value''], $v[''default_value''], \r\n							$v[''opt_attributes_formelement'']);\r\n				continue;\r\n			}\r\n			\r\n			//special handling for checkboxes in plainform / unchecked checkboxes have no value \r\n			$def_v_for_plain = ($v[''type''] == ''checkbox'' && $this->is_submitted()) ? $v[''default_value'']: $v[''default_value''];\r\n			\r\n			//get formelement\r\n			$element = $this->get_formelement($v[''name''], $v[''type''], $v[''value''], $v[''default_value''], \r\n							$v[''opt_attributes_formelement''], false);\r\n			\r\n			//get plain HTML formelement\r\n			if ($v[''type''] != ''captchaimage'') \r\n			{\r\n				$element_plain = $this->get_formelement($v[''name''], $v[''type''], $def_v_for_plain, $v[''default_value''], \r\n								$v[''opt_attributes_formelement''], true);\r\n			} \r\n			//no need to generate a second captcha for plainform	\r\n			else \r\n			{\r\n				$element_plain = $element;\r\n			}\r\n											\r\n			//find out if element must validate\r\n			$mv = (($v[''validate_rule''] != ''false'' && $v[''validate_rule''] != ''emailOrEmpty'')) ? true:false;\r\n			\r\n			//special validation for ceckboxes and radios\r\n			if ($v[''type''] == ''checkbox'' || $v[''type''] == ''radio'') \r\n			{\r\n				$vr = $this->validate($v[''validate_rule''] , $_REQUEST[ $v[''name''] ]);\r\n			} \r\n			//special validation for uploads\r\n			else if ($v[''type''] == ''upload'')\r\n			{\r\n				$vr = $this->validate_upload($v[''name''], $v[''label''], $v[''validate_rule''], $k);\r\n				\r\n				// upload fails\r\n				if (! $vr)\r\n				{\r\n					if ($this->uploads[ $v[''name''] ][''error''] != '''')\r\n					{\r\n						$v[''errormessage''] = $this->uploads[ $v[''name''] ][''error''];\r\n					}\r\n				}\r\n			//validate captcha\r\n			} \r\n			else if ($v[''type''] == ''captchaimage'' && $this->is_submitted()) \r\n			{\r\n				$this->init_captcha_object();\r\n				$vr = $this->captcha_object->validateByCharseqAndRequestFieldname($v[''value''], $v[''name'']);\r\n				if (! $vr) \r\n				{\r\n					$this->is_rule_violation = true;\r\n				}\r\n			} \r\n			//validate other elements\r\n			else \r\n			{\r\n				$vr = $this->validate($v[''validate_rule''] , $v[''value'']);\r\n			}\r\n			\r\n			//validation fail - set error\r\n			if (!$vr) \r\n			{\r\n				array_push($this->invalid_fields, $v[''label'']);\r\n			}\r\n			\r\n			//addon validate\r\n			$this->addon->onValidate($v, $vr, $this->stack);\r\n			\r\n			//get label\r\n			$label = $this->get_label($v[''name''], $v[''label''], $v[''opt_attributes_label''], $mv, $vr);\r\n			\r\n			//addon parse row\r\n			$this->addon->onParseRow($v, $label, $element, $element_plain, $this->stack);\r\n			\r\n		    //add to forms\r\n		    $p .= $this->parse_form_row($v[''tpl_index''], $label, $element, $vr, $v[''errormessage''], $mv); \r\n		    $pp .= $this->parse_form_row($v[''tpl_index''], $label, $element_plain, false, false, $mv); \r\n		}\r\n		\r\n		$this->parsed =	$p;\r\n		$this->parsed_plain = $pp;\r\n		\r\n		//log errors\r\n		if (count($this->invalid_fields) > 0 && $this->logging_active) \r\n		{\r\n			$logmessage = sprintf( "%s: Mail Rule Violation: %s%s\\n\\n",\r\n            date( ''Y-m-d (D) H:i:s'' ), \r\n			"IP: ".$_SERVER[''REMOTE_ADDR''] ."\\n-------------------------------\\n", \r\n			"Invalied Fields: ".implode('', '', $this->invalid_fields)."\\n"\r\n			."Values:$log \\n-------------------------------\\n");\r\n			$this->_log($logmessage);\r\n		}\r\n		\r\n		//set controlvalue formwassubmitted as hiddenvalue\r\n		$this->hiddenvalues .= $this->get_formelement(''formSubmitted'', ''hidden'', ''true'', ''true'');\r\n		\r\n		//if email receiver mode =''get'', add some more hiddenvalues\r\n		if($this->email_receiptor_mode == ''get'')\r\n		{\r\n			$this->hiddenvalues .= $this->get_formelement(''contactidcs'', ''hidden'',  $this->email_receiptor_get_mode_idcatside, '''');\r\n			$this->hiddenvalues .= $this->get_formelement(''contactcontainer'', ''hidden'', $this->email_receiptor_get_mode_idcontainer, '''');\r\n		}\r\n		\r\n		if ($this->is_submitted() && ! $this->is_validated() )\r\n		{\r\n			$this->addon->onFailure($this->stack);\r\n		}\r\n	}\r\n	\r\n	function get_label($element_name, $element_label, $element_attributes, $must_validated, $is_validated)\r\n	{\r\n		\r\n		$rn = ($must_validated) ? $this->tpl_label_required_notice : '''';\r\n		//{labelcontent}{requirenotice}\r\n		$element_label = str_replace(array(''{labelcontent}'',''{requirenotice}''), array($element_label, $rn), $this->tpl_labeltext);\r\n		$style = (! $is_validated) ? $this->field_styles[''label_error''] : $this->field_styles[''label''];\r\n		$label = ($style !='''') ? ''<span class="''.$style.''">''.$element_label.''</span>'': $element_label ;\r\n		return ''<label for="''.$element_name.''" ''.$element_attributes.'' >''.$label.''</label>'';\r\n	}\r\n	\r\n	function parse_form_row($tplindex, $label, $element, $is_valid = true, $errormessage = '''', $must_validated) \r\n	{		\r\n		$errormessage = ($is_valid) ? '''': $errormessage;\r\n		$rn = ($must_validated) ? $this->tpl_label_required_notice : '''';\r\n		\r\n		if($errormessage != '''')\r\n		{\r\n			$errormessage = str_replace(''{elementerrormessage}'', $errormessage, $this->tpl_elementerror);\r\n			$errormessage = $this->_get_styled_message($errormessage, $this->field_styles[''element_error'']);	\r\n		}\r\n		\r\n		return str_replace( array(''{label}'', ''{element}'', ''{errormessage}'', ''{requirenotice}''), \r\n								array($label, $element, $errormessage, ''''), \r\n								$this->row_tpl[$tplindex]);\r\n	} \r\n	\r\n	function get_formelement($element_name, $element_type, $element_value, $element_default_value, \r\n					$element_attributes ='''', $get_plain = false) \r\n	{			\r\n		\r\n		switch($element_type)\r\n		{\r\n			case ''hidden'':\r\n				$e  = ''<input type="hidden" name="''.$element_name.''" id="''.$element_name.''" '';\r\n				$e .= '' value="''. $this->_htmlentities($element_value) .''" ''.$element_attributes.'' />'';\r\n				break;				\r\n			case ''text'':\r\n			case ''password'':\r\n				$e  = ''<input type="''.$element_type.''" name="''.$element_name.''" id="''.$element_name.''" ''\r\n						. $this->_format_styleclass($this->field_styles[$element_type]) .$element_attributes .'' '';\r\n				$e .= '' value="''. $this->_htmlentities($element_value) .''" />'';\r\n				break;	\r\n			case ''textarea'':\r\n				$e  = ''<textarea name="''.$element_name.''"  id="''.$element_name.''" '' .$element_attributes.'' ''\r\n					. $this->_format_styleclass($this->field_styles[$element_type]) .''>''.$this->_htmlentities($element_value).''</textarea>''; \r\n				break;	\r\n			case ''option'':\r\n				$e  = ''<select name="''.$element_name.''"  id="''.$element_name.''"  ''.$element_attributes.'' '' \r\n					. $this->_format_styleclass($this->field_styles[$element_type]) .''>''."\\n";\r\n				$p = explode($this->mutiple_value_separator, $element_default_value);\r\n				foreach($p AS $k=>$v){\r\n					$v_key = $v;\r\n					if (strstr($v, $this->key_value_separator) !== false) \r\n					{\r\n						$v_pairs = explode($this->key_value_separator, $v);\r\n						$v_key = $v_pairs[''0''];\r\n						$v = $v_pairs[''1''];\r\n					}\r\n					$s = ( $element_value == $v_key && ! $get_plain) ? ''selected="selected"'':''''; \r\n					$e .= ''<option value="''.$this->_htmlentities($v_key).''" ''.$s.'' >''.$this->_htmlentities($v).''</option>''."\\n";\r\n				}\r\n				$e .= ''</select>''."\\n";\r\n				break;	\r\n			case ''optionMutiple'':\r\n				$e  = ''<select name="''.$element_name.''[]"  id="''.$element_name.''"  ''\r\n						. $this->field_styles[$element_type] .'' multiple>''."\\n";         \r\n				$p = explode($this->mutiple_value_separator, $element_default_value);\r\n                //$selected_options = (is_array($_REQUEST[$element_name])) ? $_REQUEST[$element_name] : array();\r\n                $selected_options = explode($this->mutiple_value_separator, $element_value);\r\n                //print_r($selected_options);\r\n				foreach($p AS $k=>$v)\r\n				{\r\n					$s = '''';\r\n					$v_key = $v;\r\n					if (strstr($v, $this->key_value_separator) !== false) \r\n					{\r\n						$v_pairs = explode($this->key_value_separator, $v);\r\n						$v_key = $v_pairs[''0''];\r\n						$v = $v_pairs[''1''];\r\n					}\r\n					\r\n					if (count($selected_options) > 0) \r\n					{\r\n						$s =  (in_array($v_key, $selected_options) && ! $get_plain)\r\n								? '' selected="selected" '': '''';\r\n					}\r\n					$e .= ''<option value="''.$this->_htmlentities($v_key).''" ''.$s.''>''.$this->_htmlentities($v).''</option>''."\\n";\r\n				}\r\n				$e .= ''</select>''."\\n";\r\n				break;\r\n			case ''radio'':\r\n				$p = explode($this->mutiple_value_separator, $element_default_value);\r\n				foreach($p AS $k=>$v)\r\n				{\r\n					$v_key = $v;\r\n					if (strstr($v, $this->key_value_separator) !== false) \r\n					{\r\n						$v_pairs = explode($this->key_value_separator, $v);\r\n						$v_key = $v_pairs[''0''];\r\n						$v = $v_pairs[''1''];\r\n					}\r\n					$c = ($element_value == $v_key && ! $get_plain) ? ''checked="checked"'':''''; \r\n					$e .= ''<input type="radio" name="''.$element_name.''" id="''.$element_name.''" value="''.$this->_htmlentities($v_key).''" ''.$c.'' />''\r\n							.''&nbsp;''. $this->_htmlentities($v);\r\n				}\r\n				break;\r\n			case ''checkbox'':\r\n			case ''checkboxSelected'':\r\n				$element_default_value_key = $element_default_value;\r\n				if (strstr($element_default_value, $this->key_value_separator) !== false) \r\n				{\r\n					$v_pairs = explode($this->key_value_separator, $element_default_value);\r\n					$element_default_value_key = $v_pairs[''0''];\r\n					$element_default_value = $v_pairs[''1''];\r\n				}\r\n				\r\n				$c = ( ($element_default_value_key == $element_value && ! $get_plain ) \r\n							||  ( ! $this->is_submitted() && $element_type == ''checkboxSelected'') )\r\n							? ''checked="checked"'':''''; \r\n				$e = ''<input type="checkbox" name="''.$element_name.''"  id="''.$element_name.''" ''\r\n					. $this->_format_styleclass($this->field_styles[''checkbox'']) .'' '';\r\n				$e .= ''value="''.$this->_htmlentities($element_default_value_key).''"  ''.$c.''  ''.$element_attributes.'' />''\r\n						.''<label for="''.$element_name.''" ''. $this->_format_styleclass($this->field_styles[''label'']).''>''\r\n						. $this->_htmlentities($element_default_value) .''</label>'';\r\n				break;\r\n			case ''upload'':\r\n				$e  = ''<input type="file" name="''.$element_name.''" id="''.$element_name.''" ''\r\n						. $this->_format_styleclass($this->field_styles[$element_type]) .$element_attributes .'' '';\r\n				$e .= '' />'';			\r\n				break;\r\n			case ''captchaimage'':\r\n				$this->init_captcha_object();\r\n				$e = $this->captcha_object->getCaptchaHtml($element_name, \r\n								$this->captchavals[''length''], \r\n								$this->_format_styleclass($this->field_styles[$element_type]) .$element_attributes, \r\n								$this->captchavals[''attributes''], \r\n								$this->captchavals[''styleset''], \r\n								$this->captchavals[''width''], \r\n								$this->captchavals[''height'']);\r\n				break;\r\n			case ''label''://label_as_formfield, placeholder\r\n				$e = ''<span ''.$this->_format_styleclass($this->field_styles[''label_as_formfield'']).'' >''.$element_value.''</span>'';\r\n				break;\r\n			case ''locumtenency'':\r\n				$e = ''<span ''.$this->_format_styleclass($this->field_styles[''placeholder'']).'' >''. $this->separator_tpl .''</span>'';\r\n				break;			\r\n		}\r\n		\r\n		return $e;	\r\n	}\r\n	\r\n	function init_captcha_object() \r\n	{\r\n		global $cfg_client;\r\n		\r\n		if (is_object($this->captcha_object)) \r\n		{\r\n			return true;\r\n		} \r\n		else\r\n		{\r\n			$this->captcha_object =& sf_factoryGetObject(''GUI'', ''CaptchaImage'');\r\n			$this->captcha_object->setCaptchaTemplate($this->captchavals[''template'']);\r\n			return true;\r\n		}\r\n	}\r\n	\r\n	function get_value($element_type, $element_name, $element_default, $element_selected, $skip_default = false)\r\n	{\r\n		//echo "$element_type, $element_name, $element_default, $element_selected, $skip_default <br>";\r\n		if(isset($_REQUEST[$element_name]))\r\n		{\r\n			$v = is_array($_REQUEST[$element_name]) ? implode($this->mutiple_value_separator, $_REQUEST[$element_name]): $_REQUEST[$element_name];\r\n			return $this->_strip_slashes($v);\r\n		} \r\n		else if (($element_type == ''checkbox'' || $element_type == ''checkboxSelected'' || $element_type == ''radio'') \r\n					&& ! $_REQUEST[$element_name] && $this->is_submitted()) \r\n		{\r\n			return false;\r\n		}\r\n		else if ($element_selected != '''') \r\n		{\r\n			return $element_selected;\r\n		} \r\n		else if ($skip_default) \r\n		{\r\n			return false;\r\n		}\r\n	\r\n		return $element_default;\r\n	}\r\n	\r\n	\r\n	function validate($element_validate , $element_value)\r\n	{\r\n		if(! $this->is_submitted())\r\n		{\r\n			return true;\r\n		}\r\n		\r\n		//validate captcha\r\n		if ($element_validate == ''imagecaptcha'') \r\n		{\r\n			//do nothing\r\n		} \r\n		//validate regex\r\n		else if(array_key_exists($element_validate, $this->rules))\r\n		{\r\n			if(! preg_match($this->rules[$element_validate], $element_value))\r\n			{\r\n				$this->is_rule_violation = true;\r\n				return false;				\r\n			}\r\n		}\r\n		\r\n		return true;\r\n	}\r\n	\r\n	function validate_upload($element_name, $element_label, $validate_rule, $stack_key)\r\n	{\r\n		$upload_dir = $this->upload_dir;\r\n		$upload_allowed_extension = $this->upload_allowed_extensions;\r\n		$upload_allowed_filesize = $this->upload_allowed_filesize;\r\n	\r\n		$size = $_FILES[$element_name][''size''];\r\n		$name = $_FILES[$element_name][''name''];\r\n		$type = $_FILES[$element_name][''type''];\r\n		$tmp_name = $_FILES[$element_name][''tmp_name''];\r\n		$err = $_FILES[$element_name][''error''];\r\n		$parts = pathinfo(''sicheristsicher/''.$name);\r\n		$ext =  strtolower ($parts[''extension'']);\r\n		$allowed_ext =  strtolower (str_replace('' '', '''',$upload_allowed_extension));\r\n\r\n		$this->uploads[$element_name][''label''] = $element_label;		\r\n		$this->uploads[$element_name][''file''] = '''';\r\n		$this->uploads[$element_name][''error''] = '''';\r\n		$this->uploads[$element_name][''int_error''] = '''';\r\n		\r\n		\r\n		//no file found/ uploaded\r\n		if($tmp_name =='''')\r\n		{\r\n			//check if upload is required\r\n			if($validate_rule == ''required'')\r\n			{\r\n				$this->is_rule_violation = true;\r\n				return false;	\r\n			} \r\n			else\r\n			{\r\n				return true;	\r\n			}\r\n		}\r\n\r\n		$upload_error = '''';\r\n		//check php errors\r\n		switch($err)\r\n		{\r\n			case 1:\r\n				$upload_error = $this->upload_errors[''deb_filesize_php_ini''];\r\n				break;\r\n			case 2:\r\n				$upload_error = $this->upload_errors[''deb_filesize_browser''];\r\n				break;\r\n			case 3:\r\n				$upload_error = $this->upload_errors[''deb_filesize_incremental''];\r\n				break;\r\n			case 4:\r\n				$upload_error = $this->upload_errors[''deb_no_file''];\r\n				break;								\r\n		}\r\n			\r\n		if($err > 0)\r\n		{\r\n			$this->uploads[$element_name][''error''] = $this->upload_errors[''usr_internal_error''];\r\n			$this->uploads[$element_name][''int_error''] = $upload_error;\r\n			$this->is_rule_violation = true;\r\n			return false;\r\n		}\r\n		\r\n		//check extensions\r\n		if(strlen($allowed_ext) > 0)\r\n		{\r\n			$ax = explode('','', $allowed_ext);\r\n			if(! in_array($ext, $ax))\r\n			{\r\n				$this->uploads[$element_name][''error''] = $this->upload_errors[''usr_allowed_ext''];\r\n				$this->is_rule_violation = true;\r\n				return false;\r\n			}\r\n		}\r\n		\r\n		//checkfilesize\r\n		if($upload_allowed_filesize > 0)\r\n		{\r\n			$upload_allowed_filesize *= 1024;\r\n			if($size >$upload_allowed_filesize){\r\n				$this->uploads[$element_name][''error''] = $this->upload_errors[''usr_allowed_size''];\r\n				$this->is_rule_violation = true;\r\n				return false;	\r\n			}\r\n		}\r\n		\r\n		//move file\r\n		if (! move_uploaded_file($_FILES[$element_name][''tmp_name''], \r\n				$upload_dir . $name))\r\n		{\r\n			\r\n			$this->uploads[$element_name][''error''] = $this->upload_errors[''usr_internal_error''];\r\n			$this->uploads[$element_name][''int_error''] = $this->upload_errors[''deb_filecopy_fails''];\r\n			$this->is_rule_violation = true;\r\n			return false;		\r\n		}\r\n		\r\n		$this->uploads[$element_name][''file''] = $upload_dir . $name;\r\n		$this->uploads[$element_name][''name''] = $name;\r\n		$this->uploads[$element_name][''type''] = $type;\r\n		$this->uploads[$element_name][''size''] = $size;\r\n		$this->uploads[$element_name][''ext'']  = $ext;\r\n		$this->stack[$stack_key][''advanced''] = $this->uploads[$element_name];\r\n		return true;	\r\n	}\r\n	\r\n	\r\n	/*\r\n	 * -----------------------------------------------------------\r\n	 * "FORM TO FINAL HTML" AND SOME MISC METHODS\r\n	 * -----------------------------------------------------------\r\n	 */\r\n	function get_form(){\r\n		return $this->_get_form();\r\n	}\r\n	\r\n	function get_form_plain(){\r\n		return $this->_get_form(true);\r\n	}\r\n	\r\n	function _get_form($is_plain = false){\r\n		global $con_side, $con_tree, $cfg_client, $idcatside;\r\n		\r\n		$frm_vals[''formstart''] = $this->get_form_head()."\\n";\r\n		$frm_vals[''formend''] = $this->get_form_footer()."\\n";\r\n		$frm_vals[''submit''] = $this->get_submitbutton();\r\n		\r\n		$arr[''email''] = '''';\r\n		if ( $this->email_receiptor_mode == ''get'' && $this->email_receiptor_get_mode_idcatside > 0) {\r\n			$arr = $this->get_receiptor_data_from_content_as_array();\r\n			$frm_vals[''textareafromdynamic''] = nl2br($arr[''textareafromdynamic'']);\r\n			$frm_vals[''textfromdynamic''] = $arr[''textfromdynamic''];\r\n			\r\n			$idcatside_from = $this->email_receiptor_get_mode_idcatside;\r\n			$frm_vals[''page_name''] = $con_side[$idcatside_from][''name''];\r\n			$frm_vals[''page_url''] = $cfg_client[''htmlpath''] . str_replace(''&amp;'', ''&'', $con_side[$idcatside_from][''link'']);\r\n			$frm_vals[''cat_name''] = $con_tree[ $con_side[$idcatside_from][''idcat''] ][''name''];\r\n			$frm_vals[''cat_url''] =  $cfg_client[''htmlpath''] . str_replace(''&amp;'', ''&'', $con_tree[ $con_side[$idcatside_from][''idcat''] ][''link'']);		\r\n		} else {\r\n			$frm_vals[''textareafromdynamic''] = nl2br($this->fallback_textareafromdynamic);\r\n			$frm_vals[''textfromdynamic''] = $this->fallback_textfromdynamic;	\r\n			$frm_vals[''page_name''] = $con_side[$idcatside][''name''];\r\n			$frm_vals[''page_url''] = $cfg_client[''htmlpath''] .  str_replace(''&amp;'', ''&'', $con_side[$idcatside][''link'']);\r\n			$frm_vals[''cat_name''] = $con_tree[ $con_side[$idcatside][''idcat''] ][''name''];\r\n			$frm_vals[''cat_url''] =  $cfg_client[''htmlpath''] .  str_replace(''&amp;'', ''&'', $con_tree[ $con_side[$idcatside][''idcat''] ][''link'']);						\r\n		}\r\n		\r\n		if($is_plain)\r\n			$frm_vals[''formelementblock''] = $this->parsed_plain;\r\n		else\r\n			$frm_vals[''formelementblock''] = $this->parsed;\r\n		$frm_vals[''usermessage''] = $this->get_usermessage();\r\n		if ($frm_vals[''usermessage''] != '''')\r\n			$frm_vals[''messageblock''] = str_replace(''{usermessage}'',$this->get_usermessage(), $this->message_block_tpl);\r\n		else\r\n			$frm_vals[''messageblock''] = '''';\r\n		\r\n		$tpl = $this->combination_tpl;\r\n		foreach($frm_vals AS $k=>$v){\r\n			$tpl = str_replace(''{''.$k.''}'', $v, $tpl);\r\n		}\r\n		\r\n		$deb = ($this->debug) ? $this->debugmessage: '''';\r\n		$tpl = str_replace(''{debugmessages}'', $deb, $tpl);\r\n		return $tpl;		\r\n	}\r\n	\r\n	function get_form_head(){\r\n		$a = str_replace(''{url}'', $this->form_target_url, $this->tpl_formstarttag);\r\n		if ($_REQUEST[''formSubmitted''] == ''true'' AND $this->is_validated() ){ $a = str_replace(''{transmitted}'', "transmitted", $a);}\r\n		return $a;\r\n	}\r\n	\r\n	function get_form_footer(){\r\n		return $this->hiddenvalues . $this->tpl_formendtag;\r\n	}\r\n	\r\n	function get_submitbutton(){\r\n		return ''<input type="submit" name="fmsubmit" ''. \r\n					$this->_format_styleclass($this->field_styles[''submitbutton'']) \r\n					.'' value="''.$this->submitbutton_text.''" />'';\r\n	}\r\n	\r\n	function get_usermessage(){\r\n		\r\n		$m = '''';\r\n		if($this->is_submitted()){\r\n			if($this->is_validated())\r\n				$m = $this->_get_styled_message($this->message_success, $this->field_styles[''submit'']);\r\n			else\r\n				$m = $this->_get_styled_message($this->message_error .'' ''. $this->get_invalid_fields(), \r\n								$this->field_styles[''submit_error'']);\r\n		}\r\n		\r\n		return $m;\r\n	}\r\n	\r\n	\r\n	function get_invalid_fields(){\r\n		return implode('', '', $this->invalid_fields);	\r\n	}\r\n	\r\n	function get_stack() {\r\n		return $this->stack;\r\n	}\r\n	\r\n	function is_validated(){\r\n		return  ( !$this->is_rule_violation);		\r\n	}\r\n	\r\n	function is_submitted(){\r\n		return ($_REQUEST[''formSubmitted''] == ''true'');\r\n	}\r\n	\r\n	\r\n	/*\r\n	 * -----------------------------------------------------------\r\n	 * MAIL METHODS\r\n	 * -----------------------------------------------------------\r\n	 */	\r\n	function send_mail(){\r\n		global $con_side, $con_tree, $cfg_client, $idcatside;	\r\n		\r\n		$tpl_email = $this->tpl_email;\r\n	\r\n		$to = '''';\r\n		if ($this->email_receiptor_mode == ''get'') {\r\n			$arr = $this->get_receiptor_data_from_content_as_array();\r\n			$to = trim($arr[''email'']);\r\n			\r\n			$idcatside_from = $this->email_receiptor_get_mode_idcatside;\r\n			$page_name = $con_side[$idcatside_from][''name''];\r\n			$page_url = $cfg_client[''htmlpath''] . str_replace(''&amp;'', ''&'', $con_side[$idcatside_from][''link'']);\r\n			$cat_name = $con_tree[ $con_side[$idcatside_from][''idcat''] ][''name''];\r\n			$cat_url =  $cfg_client[''htmlpath''] . str_replace(''&amp;'', ''&'', $con_tree[ $con_side[$idcatside_from][''idcat''] ][''link'']);\r\n		}\r\n		\r\n		if ($this->email_receiptor_mode == ''textfield'' || $to == '''') {\r\n			$to = $this->email_receiptor_textfield_mode_mailadress;\r\n			\r\n			if ($this->email_receiptor_mode == ''textfield'') {\r\n				$page_name = $con_side[$idcatside][''name''];\r\n				$page_url = $cfg_client[''htmlpath''] .  str_replace(''&amp;'', ''&'', $con_side[$idcatside][''link'']);\r\n				$cat_name = $con_tree[ $con_side[$idcatside][''idcat''] ][''name''];\r\n				$cat_url =  $cfg_client[''htmlpath''] .  str_replace(''&amp;'', ''&'', $con_tree[ $con_side[$idcatside][''idcat''] ][''link'']);\r\n				\r\n				$arr[''textfromdynamic''] = $this->fallback_textfromdynamic;\r\n				$arr[''textareafromdynamic''] = $this->fallback_textareafromdynamic;\r\n			}\r\n		}\r\n		\r\n		\r\n		//no emailadress found - break up\r\n		if ($to =='''' && $this->send_mail) {\r\n			return;\r\n		}\r\n			\r\n		$sender = $this->email_sender;\r\n		$subject = $this->generate_email_template($this->email_subject);\r\n		\r\n		\r\n\r\n		$mail =& $GLOBALS[''sf_factory'']->getObject(''UTILS'', ''Mail'');\r\n		$mail->setCharset($this->charset);\r\n		$mail->setFrom($sender);\r\n		$mail->setSubject($subject);\r\n		\r\n		$arr[''to''] = explode('','', $to);\r\n		$arr[''cc''] = explode('','', $this->email_receiptor_cc);\r\n		$arr[''bcc''] = explode('','', $this->email_receiptor_bcc);\r\n		foreach ($arr AS $k=>$v) {		\r\n			if (is_array($v)) {\r\n				foreach ($v AS $adr) {\r\n					$adr = trim($adr);\r\n					if (substr($adr, 0, 1) == ''+'') {\r\n						$mail->addAdressByUsername(substr($adr, 1), $k);\r\n					} else if (substr($adr, 0, 1) == ''#'') {\r\n						$mail->addAdressByGroupname(substr($adr, 1), $k);\r\n					} else {\r\n						$mail->addAdress($adr, $k);\r\n					}\r\n				}\r\n			}\r\n		}\r\n		\r\n		//add attachements\r\n		if (is_array($this->uploads)){\r\n			foreach($this->uploads AS $k=>$v){\r\n				if($v[''file''] != ''''){\r\n					$mail->addAttachment($v[''file''], $v[''type''], $v[''name'']);\r\n				}\r\n			}\r\n		}\r\n		\r\n		//give possibility to manipulate the stack\r\n		////////////////////////////////////////////////////////$this->addon->onSuccess($this->stack);\r\n		\r\n		//generate email template\r\n		$tpl_email = $this->generate_email_template($tpl_email, $to, $arr[''textfromdynamic''], $arr[''textareafromdynamic''],\r\n										$page_name, $page_url, $cat_name, $cat_url);\r\n		//echo $tpl_email;exit;\r\n		$mail->setTxtBody($tpl_email);\r\n		\r\n		if ($this->debug){\r\n			$this->debugmessage .= "Mail to: $to || Mail from:  $sender || Mail subject: $subject <br>";\r\n			echo $this->debugmessage .= ''Mailtext:<br>-------------<br>''.nl2br($tpl_email).''<br>-------------<br>'';\r\n		} \r\n		\r\n		if($this->send_mail) {\r\n			$result = $mail->process();//$mail->send(array($to), ''mail''); \r\n		}\r\n		\r\n		//send second email\r\n		if ($this->confirm_mail_active) {\r\n			$mail->adresses = array(''to'' => array(),\r\n    							''cc'' => array(),\r\n    							''bcc'' => array());\r\n			$tpl_email2 = $this->generate_email_template($this->confirm_mail_tpl, $to, $arr[''textfromdynamic''], $arr[''textareafromdynamic''],\r\n										$page_name, $page_url, $cat_name, $cat_url);    							\r\n    		\r\n    		\r\n    		//get sender\r\n    		if(is_numeric(trim($this->second_email_sender))) {\r\n    			foreach ($this->stack AS $k=>$v)\r\n    			{\r\n    				if ($v[''elementnumber''] == (int) $this->second_email_sender) {\r\n    					$sender = $v[''value''];\r\n    				}\r\n    			}\r\n    		} else {\r\n    			$sender = $this->second_email_sender;\r\n    		}\r\n    		\r\n    		//get recipient\r\n    		if(is_numeric(trim($this->second_email_recipient))) {\r\n    			foreach ($this->stack AS $k=>$v)\r\n    			{\r\n    				if ($v[''elementnumber''] == (int) $this->second_email_recipient) {\r\n    					$recipient = $v[''value''];\r\n    				}\r\n    			}\r\n    		} else {\r\n    			$recipient = $this->second_email_recipient;\r\n    		}\r\n    		\r\n    		\r\n    		$rec_array = explode($this->mutiple_value_separator, $recipient);\r\n    		\r\n    		\r\n    		$this->confirm_mail_subject = $this->generate_email_template($this->confirm_mail_subject);\r\n    				\r\n    		$mail->setFrom($sender);\r\n			$mail->setSubject($this->confirm_mail_subject);\r\n			\r\n			foreach ($rec_array AS $v)\r\n			{\r\n				$v2 = explode($this->key_value_separator, $v);\r\n				$mail->addAdress($v2[''0''], ''to'');\r\n			}\r\n\r\n			$mail->setTxtBody($tpl_email2);\r\n			$result = $mail->process();\r\n		}\r\n		\r\n		if ($this->logging_active) {\r\n			$mailstatus = ($result) ? ''OK'' : ''Error - Mailfunction does not work'';\r\n			$logmessage = sprintf( "%s: Send Mail: %s%s\\n\\n",\r\n	            date( ''Y-m-d (D) H:i:s'' ), \r\n				"IP: ".$_SERVER[''REMOTE_ADDR''] ." Mail to: $to || Mail from:  $sender || Mail subject: $subject \\nStatus: $mailstatus \\n-------------------------------\\n", \r\n				"Mail Conent1: $tpl_email \\n-------------------------------\\n"\r\n				."Mail Conent2: $tpl_email2 \\n-------------------------------\\n");\r\n			$this->_log($logmessage);\r\n		}\r\n		\r\n		\r\n	}\r\n	\r\n	function generate_email_template($tpl_email, $to ='''', $textfromdynamic ='''', $textareafromdynamic ='''',\r\n										$page_name ='''', $page_url ='''', $cat_name ='''', $cat_url ='''') {\r\n		\r\n		// convert all linebreaks to \\r\\n linebreaks\r\n		$tpl_email = preg_replace("#(\\r\\n)|(\\r)#m", "\\n", $tpl_email);\r\n		//$tpl_email = preg_replace("#(\\n)#m", "\\r\\n", $tpl_email);\r\n		\r\n		\r\n		// fill emailtemplate\r\n		$tpl_email = str_replace(array(''{email_receiptor}'', ''{textfromdynamic}'', ''{textareafromdynamic}'',\r\n										''{page_name}'', ''{page_url}'', ''{cat_name}'', ''{cat_url}'') , \r\n								array($to, $textfromdynamic, $textareafromdynamic,\r\n										$page_name, $page_url, $cat_name, $cat_url ),\r\n												 $tpl_email);\r\n		\r\n		$automessage = '''';\r\n		foreach($this->stack AS $k => $v){\r\n			//echo $k.": ";print_r($v);echo "<br><br>";\r\n			switch($v[''type'']){\r\n				case ''label'':\r\n					$tpl_email = str_replace(array(''{elementlabel:''. $v[''elementnumber''] .''}'', ''{elementvalue:''. $v[''elementnumber''] .''}'') , \r\n												array($v[''label''], $v[''value''] ),\r\n												 $tpl_email);\r\n				case ''locumtenency'':\r\n				case ''upload'':\r\n				case ''captchaimage'':\r\n					break;\r\n				case ''optionMutiple'':\r\n					//print_r($v);\r\n					$s = $_REQUEST[$v[''name'']];\r\n					if (count($s) > 0){\r\n						$m_inner = '''';\r\n						foreach($s AS $v2){\r\n							$m_inner .= $this->_strip_slashes($v2). "\\n";\r\n						}\r\n						$automessage .= $v[''label''].":\\n". $m_inner ."\\n\\n";\r\n						$tpl_email = str_replace(array(''{elementlabel:''. $v[''elementnumber''] .''}'', ''{elementvalue:''. $v[''elementnumber''] .''}'') , \r\n												array($v[''label''], $m_inner ),\r\n												 $tpl_email);\r\n					}		\r\n					break;\r\n				default:\r\n					$automessage .= $v[''label''].":\\n". $v[''value'']. "\\n\\n";\r\n					$tpl_email = str_replace(array(''{elementlabel:''. $v[''elementnumber''] .''}'', ''{elementvalue:''. $v[''elementnumber''] .''}'') , \r\n												array($v[''label''], $v[''value''] ),\r\n												 $tpl_email);\r\n			}\r\n		}\r\n		\r\n		if (is_array($this->uploads)){\r\n			foreach($this->uploads AS $k=>$v){\r\n				if($v[''file''] != ''''){\r\n					$automessage .= "ATTACHMENT ''". $v[''label'']."'': ". $v[''name'']. "\\n";\r\n				}\r\n			}\r\n		}\r\n		\r\n		//generate email template\r\n		$tpl_email = str_replace(''{automessage}'', $automessage, $tpl_email);\r\n		\r\n		//replace snippets\r\n		$tpl_email = $this->_snippetReplace($tpl_email);\r\n		\r\n		\r\n		return $tpl_email;\r\n	}\r\n	\r\n	function get_receiptor_data_from_content_as_array(){\r\n		global $db, $cms_db, $lang;\r\n		\r\n		$arr = array(''email'' => '''', ''textfromdynamic'' => '''', ''textareafromdynamic'' => '''', );\r\n		\r\n		if($this->email_receiptor_get_mode_idcatside == '''' \r\n			|| $this->email_receiptor_get_mode_idcontainer =='''')\r\n			return $arr;\r\n		\r\n		$grab_conf[''idcatside''] = $this->email_receiptor_get_mode_idcatside;\r\n		$grab_conf[''idlang''] = $lang;\r\n		$grab_conf[''container''] = $this->email_receiptor_get_mode_idcontainer; \r\n		$grab_conf[''id''] = ''1,2''; //id of cmstag\r\n		$grab_conf[''type''] = ''1,3'';//text + textarea\r\n		\r\n		$sql = "SELECT\r\n					CS.sortindex, CS.idcatside, CS.idcat,\r\n					CONTENT.container, CONTENT.idtype AS type, CONTENT.typenumber AS id, \r\n					CONTENT.number AS repeatid, CONTENT.value\r\n				FROM\r\n					".$cms_db[''content'']." CONTENT,\r\n					".$cms_db[''side_lang'']." SL \r\n					LEFT JOIN ".$cms_db[''cat_side'']."  CS USING (idside)\r\n				WHERE\r\n					CONTENT.idsidelang = SL.idsidelang\r\n					AND CS.idcatside = ".$grab_conf[''idcatside'']."\r\n					AND SL.idlang= ".$grab_conf[''idlang'']." \r\n					AND CONTENT.container IN (".$grab_conf[''container''].")\r\n					AND CONTENT.typenumber IN (".$grab_conf[''id''].")\r\n					AND CONTENT.idtype IN (".$grab_conf[''type''].")";\r\n		$db->query($sql);\r\n		\r\n		while($db->next_record()){\r\n			if ($db->f(''type'') == 1 && $db->f(''id'') == 1){\r\n				if (preg_match($this->rules[''email''], trim($db->f(''value'')))) {\r\n					$arr[''email''] = trim($db->f(''value''));\r\n				}\r\n			} else if ($db->f(''type'') == 1 && $db->f(''id'') == 2){\r\n				$arr[''textfromdynamic''] = $db->f(''value'');\r\n			} else if ($db->f(''type'') == 3 && $db->f(''id'') == 1){\r\n				$arr[''textareafromdynamic''] = $db->f(''value'');\r\n			}\r\n		}	\r\n		\r\n		return $arr;	\r\n	}\r\n	\r\n	\r\n	/*\r\n	 * -----------------------------------------------------------\r\n	 * SET METHODS\r\n	 * -----------------------------------------------------------\r\n	 */\r\n\r\n	/**\r\n	 * Set all used stylesheets for the form\r\n	 * \r\n	 * @args array style_array - possible values are\r\n	 * submit_error, submit (Styles for textmessages), \r\n	 * label, label_error, text, textarea, option, checkbox, submitbutton,\r\n	 * \r\n	 * new:  password, select_mutiple, radio, label_as_formfield, placeholder\r\n	 */\r\n	function set_styles($style_array){\r\n		if(! is_array($style_array) ) return;\r\n		\r\n		foreach($style_array AS $k => $v){\r\n			$this->field_styles[$k] = $v;\r\n		}		\r\n	}\r\n	\r\n	//mainmethod to add form elements\r\n	function set_formelement($element_name, $element_type, $element_default, $element_validate, $element_label,\r\n					$attributes_formelement, $attributes_label, $element_errormessage, $element_tplindex, $element_default_selected_val, $elementnumber){\r\n		$i = count($this->stack);\r\n		$this->stack[$i][''name''] = $element_name;\r\n		$this->stack[$i][''type''] = $element_type;\r\n		$this->stack[$i][''default_value''] = $element_default;\r\n		$this->stack[$i][''validate_rule''] = $element_validate;\r\n		$this->stack[$i][''label''] = $this->_strip_slashes($element_label);\r\n		$this->stack[$i][''value''] = $this->get_value($element_type, $element_name, $element_default, $element_default_selected_val,\r\n														(in_array($element_type, array(''checkbox'', ''checkboxSelected'', ''optionMutiple'') )));\r\n		$this->stack[$i][''opt_attributes_label''] = $this->_strip_slashes($attributes_label);\r\n		$this->stack[$i][''opt_attributes_formelement''] = $this->_strip_slashes($attributes_formelement);\r\n		$this->stack[$i][''errormessage''] = $this->_strip_slashes($element_errormessage);\r\n		$this->stack[$i][''tpl_index''] = $element_tplindex;\r\n		$this->stack[$i][''elementnumber''] = $elementnumber;\r\n		//$this->stack[$i][''selected_value''] = $element_default_selected_val;\r\n		//some fields have advanced informations, like the upload \r\n		$this->stack[$i][''advanced''] = false;\r\n	}\r\n	\r\n	//set anonymous hidden vars\r\n	function set_anonymus_hidden($name, $value) {\r\n		$this->hiddenvalues .= $this->get_formelement($name, ''hidden'',  $value, '''');\r\n	}\r\n	\r\n	//debugmessage\r\n	function set_debug($d){ $this->debug = $d; }\r\n	\r\n	//final template to combinate all elements\r\n	function set_combination_tpl($tpl) { $this->combination_tpl= $tpl; }\r\n	\r\n	//message block template\r\n	function set_message_block_tpl($tpl) { $this->message_block_tpl= $tpl; }\r\n	\r\n	//template for the form element seperator \r\n	function set_separator_tpl($tpl) { $this->separator_tpl= $tpl; }\r\n	\r\n	//template for one form row\r\n	function set_row_tpl($index, $tpl) { $this->row_tpl[$index] = $tpl; }\r\n	\r\n	//template for formstarttag\r\n	function set_formstart_tpl($tpl){ $this->tpl_formstarttag= $tpl;}\r\n	\r\n	//template for formendttag\r\n	function set_formend_tpl($tpl){ $this->tpl_formendtag= $tpl;}\r\n	\r\n	//template for elementerror\r\n	function set_tpl_elementerror($tpl){ $this->tpl_elementerror= $tpl;}\r\n	\r\n	//url for form- action- parameter\r\n	function set_form_target_url($url){ $this->form_target_url= $url;}\r\n	\r\n	//email sender mode\r\n	function set_email_receiptor_mode($mode){ $this->email_receiptor_mode= $mode;}\r\n	\r\n	//settings for email sender mode ''get''\r\n	function set_email_receiptor_get_mode_data($idcatside, $container){ \r\n		$this->email_receiptor_get_mode_idcatside= $idcatside;\r\n		$this->email_receiptor_get_mode_idcontainer= $container;	\r\n	}\r\n	\r\n	//settings for email sender mode ''textfield''\r\n	function set_email_receiptor_textfield_mode_data($mailadress){ \r\n		$this->email_receiptor_textfield_mode_mailadress= $mailadress;\r\n	}\r\n\r\n	//emailadress sender\r\n	function set_email_sender($mailadress){ $this->email_sender= $mailadress;}\r\n\r\n	//email subject\r\n	function set_email_subject($s){$this->email_subject = $s;}\r\n	\r\n	//success message\r\n	function set_form_message_success($message){ $this->message_success= $message;}\r\n	\r\n	//error message\r\n	function set_form_message_error($message){ $this->message_error= $message;}\r\n	\r\n	//submitbutton text\r\n	function set_submitbutton_text($txt){ $this->submitbutton_text= $txt;}\r\n	\r\n	//mutiple value separator\r\n	function set_mutiple_value_separator($sep){ $this->mutiple_value_separator= $sep;}\r\n	\r\n	//key/ value value separator\r\n	function set_key_value_separator($sep){ $this->key_value_separator= $sep;}\r\n	\r\n	//upload dir\r\n	function set_upload_dir($dir){ $this->upload_dir= $dir;}\r\n	\r\n	//upload restrictions\r\n	function set_upload_restrictions($a){ \r\n		$this->upload_allowed_extensions= $a[''upload_allowed_extensions''];\r\n		$this->upload_allowed_filesize= $a[''upload_allowed_filesize''];\r\n	}\r\n	\r\n	//upload errors\r\n	function set_upload_errors($a){\r\n		$this->upload_errors[''usr_allowed_ext''] = $a[''usr_allowed_ext''];\r\n		$this->upload_errors[''usr_allowed_size''] = $a[''usr_allowed_size''];\r\n		$this->upload_errors[''usr_internal_error''] = $a[''usr_internal_error''];\r\n	}\r\n	\r\n	//fallback {textfromdynamic}\r\n	function set_fallback_textfromdynamic($in){ $this->fallback_textfromdynamic= $in;}\r\n\r\n	//fallback {textfarearomdynamic}\r\n	function set_fallback_textareafromdynamic($in){ $this->fallback_textareafromdynamic= $in;}\r\n	\r\n	function set_charset($set){ $this->charset = strtolower($set); }\r\n	\r\n	function set_tpl_email($tpl){ $this->tpl_email = $tpl; }\r\n	\r\n	function set_send_mail($set) {\r\n		$this->send_mail = (boolean) $set;\r\n	}\r\n	\r\n	function set_logging_active($set) {\r\n		$this->logging_active = (boolean) $set;\r\n	}\r\n	\r\n	function set_logging_file($set) {\r\n		$this->logging_file = $set;\r\n	}\r\n	\r\n	function set_email_receiptor_cc($set) { $this->email_receiptor_cc = $set; }\r\n	function set_email_receiptor_bcc($set) { $this->email_receiptor_bcc = $set; }\r\n	\r\n	function set_confirmmail_vars($is_active, $subject, $tpl) {\r\n		$this->confirm_mail_active = (boolean) $is_active;\r\n		$this->confirm_mail_subject = $subject;\r\n		$this->confirm_mail_tpl = $tpl;	\r\n	}\r\n	\r\n	function set_addon($addonstring) {\r\n		if (trim($addonstring) != '''') {\r\n			$p = explode(''||'', $addonstring);\r\n			if (is_file($p[''0''])) {\r\n				include_once $p[''0''];\r\n				if (class_exists($p[''1''])) {\r\n					$this->addon =& new $p[''1''];\r\n				}\r\n			}\r\n		}\r\n	}\r\n	\r\n	function set_captcha_vals($length = 4, $width = 100, $height = 30, $attributes = '''', $styleset = '''', $template = ''{image} {textfield}{hiddentoken}'') {\r\n		$this->captchavals[''length''] = $length;\r\n		$this->captchavals[''width''] = $width;\r\n		$this->captchavals[''height''] = $height;\r\n		$this->captchavals[''attributes''] = $attributes;\r\n		$this->captchavals[''styleset''] = $styleset;\r\n		$this->captchavals[''template''] = $template; \r\n	}\r\n	\r\n	function set_second_email_sender($email) {\r\n		$this->second_email_sender = $email;\r\n	}\r\n	\r\n	function set_second_email_recipient($email) {\r\n		$this->second_email_recipient = $email;\r\n	}\r\n	\r\n	function set_tpl_requirenotice($tpl) {\r\n		$this->tpl_label_required_notice = $tpl;\r\n	}\r\n	\r\n	function set_tpl_labeltext($tpl) {\r\n		$this->tpl_labeltext = $tpl;\r\n	}\r\n			\r\n	/*\r\n	 * -----------------------------------------------------------\r\n	 * PRIVATE HELPER METHODS\r\n	 * -----------------------------------------------------------\r\n	 */\r\n	function _strip_slashes($in){\r\n		if (get_magic_quotes_gpc() != 0) {\r\n			return stripslashes($in);\r\n		}\r\n		return $in;\r\n	}\r\n	\r\n	function _snippetReplace($content)\r\n	{\r\n		//no snippet replacement found\r\n		if ($this->snippet_replacement_found === false)\r\n		{\r\n			return $content;\r\n		}\r\n		//figure out if snippet replacement exist\r\n		else if ($this->snippet_replacement_found == ''unknown'')\r\n		{\r\n			if (file_exists($GLOBALS[''cfg_cms''][''cms_path'']. ''plugins/snippet_replacement/inc/class.SnippetReplacement.php''))\r\n			{\r\n				include_once $GLOBALS[''cfg_cms''][''cms_path'']. ''plugins/snippet_replacement/inc/class.SnippetReplacement.php'';\r\n				$this->snippet_object  =& new snippetReplacement();\r\n				$this->snippet_replacement_found = true;\r\n			}\r\n			else\r\n			{\r\n				$this->snippet_replacement_found = false;\r\n			}\r\n		}\r\n		\r\n		//replace\r\n		if ($this->snippet_replacement_found == true)\r\n		{\r\n			$content = $this->snippet_object->replace($content, ''sr_lang'', $GLOBALS[''client''], $GLOBALS[''lang'']);\r\n		}\r\n		\r\n		return $content;\r\n	}\r\n	\r\n	function _htmlentities($in) {\r\n		if($this->charset == ''utf-8'') {\r\n			return htmlentities($in, ENT_COMPAT, ''UTF-8'');\r\n		} else {\r\n			return htmlentities($in);\r\n		}\r\n	}	\r\n	\r\n	function _format_styleclass($style){\r\n		return ( $style != '''' ) ? '' class="''.$style.''" '' : null;\r\n		\r\n	}\r\n	\r\n	function _get_styled_message($message, $style){\r\n		if($c = $this->_format_styleclass($style) )\r\n			return ''<span ''.$c.''>''.$message.''</span>'';\r\n		\r\n		return $message; 	\r\n	}\r\n	\r\n	function _log($message) {\r\n		if (! $this->logging_active) {\r\n			return false;\r\n		}\r\n		\r\n		$fp = @fopen($this->logging_file, ''a+'');\r\n		@fputs($fp, $message);\r\n		@fclose($fp);\r\n	}\r\n	\r\n}}\r\n\r\n/* EXPERIMENTAL */\r\nif(! class_exists(gooseberry_form_addon)){\r\nclass gooseberry_form_addon {\r\n	function onPreParse(&$current, &$stack)\r\n	{\r\n		\r\n	}\r\n	\r\n	function onValidate(&$current, &$is_valid, &$stack)\r\n	{\r\n		\r\n	}\r\n	\r\n	function onParseRow(&$current, &$label, &$element, &$element_plain, &$stack)\r\n	{\r\n		\r\n	}\r\n	\r\n	function onFailure(&$stack)\r\n	{\r\n		\r\n	}\r\n	\r\n	function onSuccess(&$stack)\r\n	{\r\n\r\n	}\r\n}}\r\n\r\nif (! class_exists(gooseberry_formcontroller)) {\r\nclass gooseberry_formcontroller {\r\n	var $frm;//form object\r\n	var $content;//form html content\r\n	var $dbdata;// dataitem object\r\n	var $dbmeta;// reportdesc object\r\n\r\n\r\n	var $db_mode_active = false;\r\n	var $db_mode_default_datagroup;\r\n	var $mutiple_value_separator = '','';\r\n	var $redirect_after_success = false;\r\n	var $redirect_after_success_url = '''';\r\n	\r\n	var $save_in_filemanager = false;\r\n	var $filemanager_iddirectory = false;\r\n	\r\n	\r\n	function gooseberry_formcontroller() {\r\n		global $con_side;\r\n		if ((int)$_REQUEST[''rvbackidcatside''] >0) {\r\n			$this->redirect_after_success = true;\r\n			$this->redirect_after_success_url = $con_side[(int) $_REQUEST[''rvbackidcatside'']][''link''];\r\n			$parms = '''';\r\n			$parms .= ''&rvsortfield=''. $_REQUEST[''rvsortfield''];\r\n			$parms .= ''&rvstart=''. $_REQUEST[''rvstart''];\r\n			$parms .= ''&rvsortdirec=''. $_REQUEST[''rvsortdirec''];\r\n			$parms .= ''&rvsearchquery=''. $_REQUEST[''rvsearchquery''];\r\n			if (is_array($_REQUEST[''rvkeyfilter''])) {\r\n				foreach($_REQUEST[''rvkeyfilter''] AS $k=>$v) {\r\n					$parms .= ''&rvkeyfilter[''.$k.'']=''. $v;\r\n				}\r\n			}\r\n			if (is_array($_REQUEST[''rvfreefilter''])) {\r\n				foreach($_REQUEST[''rvfreefilter''] AS $k=>$v) {\r\n					$parms .= ''&rvfreefilter[''.$k.'']=''. $v;\r\n				}\r\n			}\r\n			$this->redirect_after_success_url .= $parms;\r\n			\r\n			//$this->redirect_after_success_url;exit;\r\n		}\r\n	}\r\n	\r\n	function set_formobject(&$frm) {\r\n		$this->frm =& $frm;\r\n	}\r\n	\r\n	function set_db_mode_active($set) {\r\n		$this->db_mode_active = (boolean) $set;\r\n	}\r\n	\r\n	function set_db_mode_default_datagroup($set) {\r\n		$this->db_mode_default_datagroup = $set;\r\n	}\r\n	\r\n	function set_db_mode_items_are_online($set) {\r\n		$this->db_mode_items_are_online = (boolean) $set;\r\n	}\r\n	\r\n	function set_mutiple_value_separator($set) {\r\n		$this->mutiple_value_separator = $set;\r\n	}\r\n	\r\n	function set_save_in_filemanager($set) {\r\n		$this->save_in_filemanager = $set;	\r\n	}\r\n	\r\n	function set_filemanager_iddirectory($id) {\r\n		$this->filemanager_iddirectory = (int) $id;\r\n	}\r\n	\r\n	function set_tpl_labeltext($tpl) {\r\n		$this->tpl_labeltext = $tpl;\r\n	}\r\n	\r\n	function set_redirect_after_success($bol, $url) {\r\n		global $con_side;\r\n		\r\n		if (trim($url) == '''') {\r\n			return false;\r\n		}\r\n		\r\n		if ((int) $url > 0) {\r\n			$url = $con_side[(int) $url][''link''];\r\n		}\r\n		\r\n		$this->redirect_after_success = (boolean) $bol;\r\n		$this->redirect_after_success_url = $url;\r\n	}\r\n	\r\n	function start() {\r\n		global $mvars;\r\n		$rvidnew = $rvidedit = 0;\r\n		//dbmode\r\n		if ($this->db_mode_active) {\r\n			//check external db mode\r\n			$rvidedit = (int) $_REQUEST[''rvidedit''];\r\n			$rvidnew = (int) $_REQUEST[''rvidnew''];\r\n			$is_db_mode_and_new_record = false;\r\n			\r\n			//from reportviewer context\r\n			if ($rvidedit > 0 || $rvidnew > 0) {\r\n				if ($rvidnew > 0) {\r\n					$this->dbmeta =& new rv_Reportdesc;\r\n					$this->dbmeta->loadByIddescreption($rvidnew);\r\n					$this->dbdata =& new rv_DataItem;\r\n					$this->dbdata->setDatagroup($this->dbmeta->getGroupname());\r\n				} else {\r\n					$this->dbdata =& new rv_DataItem;\r\n					$this->dbdata->loadByIdreportdata($rvidedit);\r\n					$this->dbmeta =& new rv_Reportdesc;\r\n					$this->dbmeta->loadByGroupname($this->dbdata->getDatagroup());\r\n				}\r\n				$is_db_mode_and_new_record = $this->dbdata->isEmptyRecord();\r\n				for ($iter =& $this->dbdata->getFormvalueIterator(); $iter->valid(); $iter->next() ) {\r\n		        	$formkey = ($iter->key()-1);\r\n		        	$fieldtype = $mvars[($formkey*20+101)];\r\n		        	switch ($fieldtype) {\r\n		        		case ''option'':\r\n						case ''optionMutiple'':\r\n						case ''radio'':\r\n						case ''checkbox'':\r\n						case ''checkboxSelected'':\r\n		        			$mvars[($formkey*20+109)] = $iter->current();\r\n		        			break;\r\n		        		default:\r\n		        			$mvars[($formkey*20+103)] = $iter->current();\r\n		        	}			\r\n				}\r\n			} else if ($this->db_mode_default_datagroup != ''''){\r\n				//from default\r\n				$this->dbdata =& new rv_DataItem;\r\n				$this->dbdata->setDatagroup($this->db_mode_default_datagroup);\r\n				\r\n				$this->dbmeta =& new rv_Reportdesc;\r\n				$this->dbmeta->loadByGroupname($this->db_mode_default_datagroup);\r\n				$is_db_mode_and_new_record = true;\r\n			} else {\r\n				$this->db_mode_active = false;\r\n			}\r\n			\r\n			//new record is per default online or offline\r\n			if ($is_db_mode_and_new_record) {\r\n				$this->dbdata->setIs_online($this->db_mode_items_are_online);\r\n			}\r\n		}\r\n		\r\n		//Formular erstellen\r\n		//n+0 aktiv\r\n		//n+1 type\r\n		//n+2 label\r\n		//n+3 default\r\n		//n+4 validate\r\n		//n+5 attributes label\r\n		//n+6 attributes formelement\r\n		//n+7 custom element- error\r\n		//n+8 index tpl elementcontainer\r\n		//n+9 default selected\r\n		//elementnumber $i/100\r\n		for($i=100; array_key_exists(($i+1), $mvars); $i=$i+20){	\r\n			if($mvars[$i]){\r\n				if ($mvars[$i+1] == ''checkboxSelected'' && $is_db_mode_and_new_record) {\r\n					$mvars[$i+9] = $mvars[$i+3];\r\n				}\r\n				$this->frm->set_formelement(''go_frm''.$i, $mvars[$i+1], $mvars[$i+3], $mvars[$i+4], $mvars[$i+2],\r\n						$mvars[$i+6], $mvars[$i+5], $mvars[$i+7], $mvars[$i+8], $mvars[$i+9], (($i/20)-4));\r\n			}\r\n		}\r\n		\r\n\r\n		//hidden vars by reportviewer\r\n		//sortfield=2&sortdirec=asc&start=0&rvidedit=7&rvbackidcatside=8 (edit)\r\n		//sortfield=2&sortdirec=asc&start=0&rvidnew=-1&rvbackidcatside=8 (new)\r\n		if ($this->db_mode_active) {\r\n			if ($rvidedit > 0 || $rvidnew == -1) {\r\n				$this->frm->set_anonymus_hidden(''rvsortfield'', $_REQUEST[''rvsortfield'']);\r\n				$this->frm->set_anonymus_hidden(''rvsortdirec'', $_REQUEST[''rvsortdirec'']);\r\n				$this->frm->set_anonymus_hidden(''rvsearchquery'', $_REQUEST[''rvsearchquery'']);\r\n				$this->frm->set_anonymus_hidden(''rvstart'', (int) $_REQUEST[''rvstart'']);\r\n				$this->frm->set_anonymus_hidden(''rvbackidcatside'', (int) $_REQUEST[''rvbackidcatside'']);\r\n				if (is_array($_REQUEST[''rvkeyfilter''])) {\r\n					foreach($_REQUEST[''rvkeyfilter''] AS $k=>$v) {\r\n						$this->frm->set_anonymus_hidden(''rvkeyfilter[''.$k.'']'', $this->frm->_strip_slashes($v));\r\n					}\r\n				}\r\n				if (is_array($_REQUEST[''freefilter''])) {\r\n					foreach($_REQUEST[''freefilter''] AS $k=>$v) {\r\n						$this->frm->set_anonymus_hidden(''freefilter[''.$k.'']'', $this->frm->_strip_slashes($v));\r\n					}\r\n				}\r\n			}\r\n			if ($rvidedit > 0) {\r\n				$this->frm->set_anonymus_hidden(''rvidedit'', (int) $_REQUEST[''rvidedit'']);\r\n			} else if ($rvidnew == -1) {\r\n				$this->frm->set_anonymus_hidden(''rvidnew'', (int) $_REQUEST[''rvidnew'']);\r\n			}\r\n		}\r\n		\r\n		$this->frm->parse_elements();\r\n		if ($this->frm->is_submitted()){\r\n			if ($this->frm->is_validated()){\r\n				$this->frm->send_mail();\r\n				$this->_reportviewer_save();\r\n				$this->process_redirect();\r\n				$this->content = $this->frm->get_form_plain();\r\n			} else {\r\n				$this->content = $this->frm->get_form();\r\n			}\r\n		} else {\r\n			$this->content = $this->frm->get_form();\r\n		}\r\n		\r\n	}\r\n	\r\n	function get_content() {\r\n		return $this->content;\r\n	}\r\n	\r\n	function _reportviewer_save() {\r\n		\r\n		$stack = $this->frm->get_stack();		\r\n		$used_keys = array();\r\n		\r\n		//id dbmode isn''t active catch upload files and exit\r\n		if (! $this->db_mode_active) {\r\n			foreach ($stack AS $k=>$v) {\r\n				switch ($v[''type'']) {\r\n					case ''upload'':\r\n						if ($v[''advanced''][''file''] == '''') {\r\n							continue;\r\n						} else {\r\n							$f =& $GLOBALS[''sf_factory'']->getObjectForced(''ASSETS'', ''DbFile'');\r\n							if ($this->save_in_filemanager == ''overwrite'') {\r\n								$f->setOverwriteExistingFile(true);\r\n								$f->setAutorenameIfExists(false);\r\n							} else if ($this->save_in_filemanager == ''rename'') {\r\n								$f->setOverwriteExistingFile(false);\r\n								$f->setAutorenameIfExists(true);\r\n							} else {\r\n								continue;\r\n							}\r\n							$f->setExternalSourceFile($v[''advanced''][''file''], $v[''advanced''][''type'']);\r\n							$f->setIddirectory($this->filemanager_iddirectory);\r\n							$f->save();\r\n						}\r\n					break;\r\n				}\r\n			} \r\n			return false;\r\n		}\r\n\r\n		foreach ($stack AS $k=>$v) {\r\n			switch ($v[''type'']) {\r\n				case ''locumtenency'':\r\n				case ''label'':\r\n					break;\r\n				case ''upload'':\r\n					if ($v[''advanced''][''file''] == '''') {\r\n						if ($this->dbdata->isEmptyRecord()) {\r\n							$v[''value''] = '''';\r\n						} else {\r\n							continue;\r\n						}\r\n					} else {\r\n						$f =& $GLOBALS[''sf_factory'']->getObjectForced(''ASSETS'', ''DbFile'');\r\n						if ($this->save_in_filemanager == ''overwrite'') {\r\n							$f->setOverwriteExistingFile(true);\r\n							$f->setAutorenameIfExists(false);\r\n						} else if ($this->save_in_filemanager == ''rename'') {\r\n							$f->setOverwriteExistingFile(false);\r\n							$f->setAutorenameIfExists(true);\r\n						} else {\r\n							continue;\r\n						}\r\n						$f->setExternalSourceFile($v[''advanced''][''file''], $v[''advanced''][''type'']);\r\n						$f->setIddirectory($this->filemanager_iddirectory);\r\n						$f->save();\r\n						$v[''value''] = $f->getCmsLink();\r\n					}\r\n				default:\r\n					//special handling for ''option'' and ''optionMutiple''\r\n					$this->dbdata->setFormvalueByFormkey(($k+1), $v[''value'']);\r\n					array_push($used_keys, ($k+1));\r\n					$this->dbmeta->setFieldlabelByFieldkey(($k+1), $v[''label'']);\r\n\r\n			} \r\n		}\r\n		\r\n\r\n		$this->dbmeta->deleteFieldkeysByKeysNotInArray($used_keys);\r\n		\r\n		\r\n		$this->dbdata->save();\r\n		$this->dbmeta->save();\r\n		//print_r($this->dbmeta);\r\n	}\r\n	\r\n	function process_redirect() {\r\n		if(! $this->redirect_after_success) {\r\n			return false;\r\n		}\r\n		//echo $this->redirect_after_success_url;exit;\r\n		sf_header_redirect($this->redirect_after_success_url);\r\n	}\r\n	\r\n}}\r\n\r\n//\r\n// START WORKING\r\n//\r\n\r\n//look for reportviewer plugin\r\nif (is_file($cfg_cms[''cms_path''].''plugins/reportviewer/index.php'')) {\r\n	$mvars[''reportviewer_included''] = true;\r\n	include_once $cfg_cms[''cms_path''].''plugins/reportviewer/includes/class.rv_ArrayIterator.php'';\r\n	include_once $cfg_cms[''cms_path''].''plugins/reportviewer/includes/class.rv_DataItem.php'';\r\n	include_once $cfg_cms[''cms_path''].''plugins/reportviewer/includes/class.rv_Reportdesc.php'';\r\n} else {\r\n	$mvars[''reportviewer_included''] = false;\r\n}\r\ninclude_once $cfg_cms[''cms_path''].''external/misc/class.captcha.php'';\r\n$frm = new gooseberry_form;\r\n//set debug\r\n$frm->set_debug( ($mvars[''44''] == ''true'') ? true: false);\r\n//set form styles\r\n$frm->set_styles (array(   \r\n   ''submit_error'' => $mvars[''15''],\r\n   ''submit'' => $mvars[''16''],\r\n   ''label'' => $mvars[''17''],\r\n   ''label_error'' => $mvars[''18''],\r\n   ''element_error'' => $mvars[''53''],   \r\n   ''text'' => $mvars[''19''],\r\n   ''textarea'' => $mvars[''20''],\r\n   ''option'' => $mvars[''21''],\r\n   ''checkbox'' => $mvars[''22''],\r\n   ''upload'' => $mvars[''52''],\r\n   ''password'' => $mvars[''31''],\r\n   ''select_mutiple'' => $mvars[''32''],\r\n   ''radio'' => $mvars[''33''],\r\n   ''captchaimage'' => $mvars[''79''],\r\n   ''label_as_formfield'' => $mvars[''34''],\r\n   ''placeholder'' => $mvars[''35''],\r\n   ''submitbutton'' => $mvars[''23'']));\r\n//final template to combinate all elements\r\n$frm->set_combination_tpl($mvars[''25'']);\r\n//message block template\r\n$frm->set_message_block_tpl($mvars[''38'']);\r\n//template for the form element seperator \r\n$frm->set_separator_tpl($mvars[''42'']);\r\n//template for elementerror\r\n$frm->set_tpl_elementerror($mvars[''43'']);\r\n//template for one form row\r\n$frm->set_row_tpl(1, $mvars[''26'']);\r\n$frm->set_row_tpl(2, $mvars[''46'']);\r\n$frm->set_row_tpl(3, $mvars[''66'']);\r\n$frm->set_row_tpl(4, $mvars[''86'']);\r\n//template for formstarttag\r\n$frm->set_formstart_tpl($mvars[''39'']);\r\n//template for formendttag\r\n$frm->set_formend_tpl($mvars[''40'']);\r\n//upload restrictions\r\n$frm->set_upload_restrictions(array(''upload_allowed_extensions'' => $mvars[''47''],\r\n										''upload_allowed_filesize'' => $mvars[''48'']));\r\n//upload \r\n$frm->set_upload_errors(array(''usr_allowed_ext'' => $mvars[''49''],\r\n										''usr_allowed_size'' => $mvars[''50''],\r\n										''usr_internal_error'' => $mvars[''51'']));\r\n											\r\n//url for form- action- parameter\r\n$frm->set_form_target_url($con_side[(int) $idcatside][''link'']);\r\n//email receiptor mode - get or textfield are possible\r\n$frm->set_email_receiptor_mode($mvars[''41'']);\r\n//settings for email receiptor mode ''get'' idcatside and container\r\n$frm->set_email_receiptor_get_mode_data($_REQUEST[''contactidcs''], $_REQUEST[''contactcontainer'']); \r\n//settings for email receiptor mode ''textfield''\r\n$frm->set_email_receiptor_textfield_mode_data($mvars[''12'']);\r\n//emailadress sender\r\n$frm->set_email_sender((is_numeric($mvars[''27'']))? \r\n							$_REQUEST[''go_frm''.$mvars[''27''] ]: $mvars[''12'']);\r\n//email subject\r\n$frm->set_email_subject($mvars[''11'']);\r\n//success message\r\n$frm->set_form_message_success($mvars[''14'']);\r\n//error message\r\n$frm->set_form_message_error($mvars[''13'']);\r\n//submitbutton text\r\n$frm->set_submitbutton_text($mvars[''24'']);\r\n//mutiple value separator\r\n$frm->set_mutiple_value_separator($mvars[''36'']);\r\n//key/ value value separator\r\n$frm->set_key_value_separator($mvars[''37'']);\r\n//upload dir\r\n$frm->set_upload_dir($cfg_cms[''cms_path'']. ''upload/in/'');\r\n//fallback {textfromdynamic}\r\n$frm->set_fallback_textfromdynamic($mvars[''54'']);\r\n//fallback {textareafromdynamic}\r\n$frm->set_fallback_textareafromdynamic($mvars[''55'']);\r\n//charset\r\n$frm->set_charset($lang_charset);\r\n//tple email\r\n$frm->set_tpl_email($mvars[''56'']);\r\n//send email\r\n$frm->set_send_mail($mvars[''65''] == ''true'');\r\n//en/ disable logging\r\n$frm->set_logging_active($mvars[''63''] == ''true'');\r\n//logfile\r\n$frm->set_logging_file($mvars[''64'']);\r\n//cc and bcc\r\n$frm->set_email_receiptor_cc($mvars[''57'']);\r\n$frm->set_email_receiptor_bcc($mvars[''58'']);\r\n//confirmmail vals: boolean sendiit|subject|body\r\n$frm->set_confirmmail_vars( ($mvars[''68''] == ''true''), $mvars[''69''], $mvars[''70'']);\r\n//addon object string\r\n$frm->set_addon($mvars[''72'']);\r\n//captcha vals\r\n$frm->set_captcha_vals($mvars[''73''], $mvars[''74''], $mvars[''75''], $mvars[''76''], $mvars[''77''], $mvars[''78'']);\r\n//second email\r\n$frm->set_second_email_sender($mvars[''80'']);\r\n$frm->set_second_email_recipient($mvars[''81'']);\r\n//requirenotice\r\n$frm->set_tpl_requirenotice($mvars[''82'']);\r\n//labeltext\r\n$frm->set_tpl_labeltext($mvars[''83'']);\r\n\r\n$frm_control =& new gooseberry_formcontroller;\r\n$frm_control->set_formobject($frm);\r\n$frm_control->set_db_mode_active($mvars[''59''] == ''true'' && $mvars[''reportviewer_included'']);\r\n$frm_control->set_db_mode_default_datagroup($mvars[''60'']);\r\n$frm_control->set_db_mode_items_are_online( ($mvars[''71''] == ''online'') );\r\n$frm_control->set_mutiple_value_separator($mvars[''36'']);\r\n$frm_control->set_save_in_filemanager($mvars[''61'']);\r\n$frm_control->set_filemanager_iddirectory($mvars[''62'']);\r\n$frm_control->set_redirect_after_success( (trim($mvars[''67'']) != ''''), $mvars[''67'']);\r\n$frm_control->start();\r\n//print_r($mvars);\r\necho $frm_control->get_content();\r\n\r\nunset($frm, $frm_control, $inner_form, $outer_form, $to_replace, $replacer, $frm_vals, $mvars, $a);\r\n\r\n\r\n\r\n}\r\n\r\nunset($is_dev);\r\n\r\n</CMSPHP>', '', 0, 1, 1, 1159227335, 1215636767, 'mod:c7ec67c74104a45bde479c5d666bdc75:256d7c93', '', '', '', 0, '0', '', '1');
INSERT INTO `cms_mod` VALUES (13, 'Listen-Navigation', '1.1', 'Navigation', '', '<?php\r\n// VALREF\r\n// 01 Startordner\r\n// 02 Anzeigeart (Ordner mit Seiten, nur Ordner, nur Seiten)\r\n// 03 Komplette Ordnerstruktur anzeigen\r\n// 04 Startseiten anzeigen\r\n// 05 Anzahl darzustellender Ebenen\r\n// 06 Ausgeschlossene Seiten und Ordner auch im Backend verbergen\r\n// 07 Ordner ausschliessen\r\n// 08 Seiten ausschliessen\r\n// 09 Ordner nur als aktiv markieren, wenn Startseite angezeigt wird\r\n// 11 Pfad als aktiv verfolgen\r\n// 12 Einleitung/Ende der Navigation verbergen, falls Navigation "leer"\r\n// 13 Startnummer Tabindex\r\n// 14 Sortierung\r\n// 15 Richtung der Sortierung\r\n// 16 Erst Ordner, dann Seiten anzeigen\r\n// 17 Bei Ordnerlinks immer Link zur Startseite des Ordners generieren (neu2)\r\n// 20 Template: Einleitung der Navigation\r\n// 21 Template: Ende der Navigation\r\n// 22 Template: Seite\r\n// 23 Template: Aktuelle Seite\r\n// 24 Template: Ordner\r\n// 25 Template: Aktiver Ordner\r\n// 26 Template: Ebene\r\n// 27 Template: Ordner, wenn als aktiv verfolgt (neu)\r\n// 28 In folgenden Ordnern keine Seiten anzeigen (neu)\r\n// 29 Rootlevel verschieben (neu)\r\n// 30 Routing (neu)\r\n\r\n\r\n// 99 Configmode\r\n\r\n//Hinweis: $mod nicht in der Modulkonfiguration verwenden!\r\n\r\n$mip_form[''99''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''99''][''cat''] = ''option'';\r\n$mip_form[''99''][''size''] = ''1'';\r\n$mip_form[''99''][''option_desc''][0] = ''Normal'';\r\n$mip_form[''99''][''option_val''][0] =  '''';\r\n$mip_form[''99''][''option_desc''][1] = ''Erweitert'';\r\n$mip_form[''99''][''option_val''][1] =  ''advanced'';\r\n$mip_form[''99''][''option_desc''][2] = ''Ausgeblendet'';\r\n$mip_form[''99''][''option_val''][2] =  ''hidden'';\r\n$mip_form[''99''][''cms_var''] = ''MOD_VAR[99]'';\r\n$mip_form[''99''][''cms_val''] = $cms_mod[''value''][99];\r\n$mip_form[''99''][''flag''] = ''reload'';\r\n\r\n$listnavi[''show_in_standard_mode''] = array(1,2,3,4,14,15,16);\r\n\r\n\r\n// Defaultwerte setzen\r\nif ($cms_mod[''value''][1] == '''')\r\n{\r\n	$cms_mod[''value''][1] = ''root'';\r\n}\r\n\r\n$mip_form[''14''][''cms_val_default''] = ''sortindex'';\r\n$mip_form[''15''][''cms_val_default''] = ''SORT_ASC'';\r\n\r\n$mip_form[''2''][''cms_val_default''] = ''folders_and_pages'';\r\n$mip_form[''3''][''cms_val_default''] = '''';\r\n$mip_form[''5''][''cms_val_default''] = ''0'';\r\n\r\n$mip_form[''1''][''desc''] = ''Startordner:'';\r\n$mip_form[''1''][''cat''] = ''app_cat'';\r\n$mip_form[''1''][''output_cat''] = ''option'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][1];\r\n$mip_form[''1''][''size''] = ''5'';\r\n$mip_form[''1''][''flag''] = ''reload'';\r\n\r\n$mip_form[''29''][''cat''] = ''txt'';\r\n$mip_form[''29''][''type''] = '''';\r\n$mip_form[''29''][''desc''] = ''Angezeigter Startebene von Ordnern manipulieren<small>(leer oder 0 = deaktiviert, 1 = Ordner ab Ebene eins, 2 = Ordner ab Ebene zwei,...)</small>:'';\r\n$mip_form[''29''][''cms_var''] = ''MOD_VAR[29]'';\r\n$mip_form[''29''][''cms_val''] = $cms_mod[''value''][29];\r\n\r\n$mip_form[''2''][''desc''] = ''Anzeigeart:'';\r\n$mip_form[''2''][''cat''] = ''option'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][2];\r\n$mip_form[''2''][''option_desc''][0] = ''Ordner mit Seiten'';\r\n$mip_form[''2''][''option_desc''][1] = ''nur Ordner'';\r\n$mip_form[''2''][''option_desc''][2] = ''nur Seiten'';\r\n$mip_form[''2''][''option_val''][0] = ''folders_and_pages'';\r\n$mip_form[''2''][''option_val''][1] = ''folders'';\r\nif ($cms_mod[''value''][1] != ''root'')\r\n{\r\n	$mip_form[''2''][''option_val''][2] = ''pages'';\r\n}\r\n$mip_form[''2''][''flag''] = ''reload'';\r\n\r\n$mip_form[''6''][''desc''] = ''Ausgeschlossene Seiten und Ordner auch im Backend verbergen:'';\r\n$mip_form[''6''][''cat''] = ''chk'';\r\n$mip_form[''6''][''option_var''][0] = ''MOD_VAR[6]'';\r\n$mip_form[''6''][''option_val''][0] = $cms_mod[''value''][6];\r\n$mip_form[''6''][''option_desc''][0] = ''ja'';\r\n$mip_form[''6''][''option_val_select''][0] = ''true'';\r\n\r\n$mip_form[''12''][''desc''] = ''Einleitung/Ende der Navigation anzeigen, falls Navigation &quot;leer&quot;'';\r\n$mip_form[''12''][''cat''] = ''chk'';\r\n$mip_form[''12''][''option_var''][0] = ''MOD_VAR[12]'';\r\n$mip_form[''12''][''option_val''][0] = $cms_mod[''value''][12];\r\n$mip_form[''12''][''option_desc''][0] = ''ja'';\r\n$mip_form[''12''][''option_val_select''][0] = ''true'';\r\n\r\n$mip_form[''13''][''cat''] = ''txt'';\r\n$mip_form[''13''][''type''] = '''';\r\n$mip_form[''13''][''desc''] = ''Startnummer f&uuml;r tabindex:'';\r\n$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n$mip_form[''13''][''cms_val''] = $cms_mod[''value''][13];\r\n\r\n$mip_form[''14''][''desc''] = ''Sortierung:'';\r\n$mip_form[''14''][''cat''] = ''option'';\r\n$mip_form[''14''][''cms_var''] = ''MOD_VAR[14]'';\r\n$mip_form[''14''][''cms_val''] = $cms_mod[''value''][14];\r\n$mip_form[''14''][''option_desc''][0] = ''Standard (wie Backend)'';\r\n$mip_form[''14''][''option_desc''][1] = ''Name'';\r\n$mip_form[''14''][''option_desc''][2] = ''Erstellungsdatum'';\r\n$mip_form[''14''][''option_desc''][3] = ''&Auml;nderungsdatum'';\r\n$mip_form[''14''][''option_val''][0] = ''sortindex'';\r\n$mip_form[''14''][''option_val''][1] = ''name'';\r\n$mip_form[''14''][''option_val''][2] = ''created'';\r\n$mip_form[''14''][''option_val''][3] = ''lastmodified'';\r\n\r\n$mip_form[''15''][''cat''] = ''radio'';\r\n$mip_form[''15''][''cms_var''] = ''MOD_VAR[15]'';\r\n$mip_form[''15''][''cms_val''] = $cms_mod[''value''][15];\r\n$mip_form[''15''][''option_desc''][0] = ''aufsteigend'';\r\n$mip_form[''15''][''option_val''][0] = ''SORT_ASC'';\r\n$mip_form[''15''][''option_desc''][1] = ''absteigend'';\r\n$mip_form[''15''][''option_val''][1] = ''SORT_DESC'';\r\n\r\nif ($cms_mod[''value''][2] == ''folders_and_pages'')\r\n{\r\n	$mip_form[''16''][''desc''] = ''Erst Ordner, dann Seiten anzeigen:'';\r\n	$mip_form[''16''][''cat''] = ''chk'';\r\n	$mip_form[''16''][''option_var''][0] = ''MOD_VAR[16]'';\r\n	$mip_form[''16''][''option_val''][0] = $cms_mod[''value''][16];\r\n	$mip_form[''16''][''option_desc''][0] = ''ja'';\r\n	$mip_form[''16''][''option_val_select''][0] = ''true'';\r\n}\r\nelse\r\n{\r\n	$mip_form[''16''][''cat''] = ''hidden'';\r\n	$mip_form[''16''][''cms_var''] = ''MOD_VAR[16]'';\r\n	$mip_form[''16''][''cms_val''] = $cms_mod[''value''][16];\r\n\r\n}\r\n\r\n$mip_form[''20''][''cat''] = ''txtarea'';\r\n$mip_form[''20''][''type''] = ''long'';\r\n$mip_form[''20''][''rows''] = ''3'';\r\n$mip_form[''20''][''desc''] = ''Einleitung der Navigation:<br/><small>M&ouml;gliche Templatevariablen: {name}, {link}, {desc}, {id}, {tabindex}. (Beziehen sich auf den Startordner)</small>'';\r\n$mip_form[''20''][''cms_var''] = ''MOD_VAR[20]'';\r\n$mip_form[''20''][''cms_val''] = $cms_mod[''value''][20];\r\n\r\n$mip_form[''21''][''cat''] = ''txtarea'';\r\n$mip_form[''21''][''type''] = ''long'';\r\n$mip_form[''21''][''rows''] = ''3'';\r\n$mip_form[''21''][''desc''] = ''Ende der Navigation:<br/><small>M&ouml;gliche Templatevariablen: {name}, {link}, {desc}, {id}, {tabindex}. (Beziehen sich auf den Startordner)</small>'';\r\n$mip_form[''21''][''cms_var''] = ''MOD_VAR[21]'';\r\n$mip_form[''21''][''cms_val''] = $cms_mod[''value''][21];\r\n\r\n$mip_form[''26''][''cat''] = ''txtarea'';\r\n$mip_form[''26''][''type''] = ''long'';\r\n$mip_form[''26''][''rows''] = ''3'';\r\n$mip_form[''26''][''desc''] = ''Ebene:<br/><small>M&ouml;gliche Templatevariablen: {layer}, {id}</small>'';\r\n$mip_form[''26''][''cms_var''] = ''MOD_VAR[26]'';\r\n$mip_form[''26''][''cms_val''] = $cms_mod[''value''][26];\r\n$mip_form[''26''][''cms_val_default''] = ''<ul>\r\n{layer}</ul>\r\n'';\r\n\r\n\r\n$mip_form[''30''][''cat''] = ''txtarea'';\r\n$mip_form[''30''][''type''] = ''long'';\r\n$mip_form[''30''][''rows''] = ''3'';\r\n$mip_form[''30''][''desc''] = ''Routing des aktiven Status:<br/><small>Leitet den Aktivstatus einer Seite oder einer Kategorie um auf eine andere Seite oder Kategorie. Pro Zeile kann eine Route erstellt werden. Beispiele<br />\r\nidcat:2 > idcat:1 <i>(Ist idcat 2 aktiv, wird stattdessen idcat 1 als aktiv gekennzeichnet)</i><br />\r\nidcat:5 > idcatside:11 <i>(Ist idcat 5 aktiv, wird stattdessen idcatside 11 als aktiv gekennzeichnet)</i><br />\r\nidcatside:2 > idcat:3 <i>(Ist idcatside 2 aktiv, wird stattdessen idcat 3 als aktiv gekennzeichnet)</i><br />\r\nidcatside:17 > idcatside:11 <i>(Ist idcatside 17 aktiv, wird stattdessen idcatside 11 als aktiv gekennzeichnet)</i></small>'';\r\n$mip_form[''30''][''cms_var''] = ''MOD_VAR[30]'';\r\n$mip_form[''30''][''cms_val''] = $cms_mod[''value''][''30''];\r\n\r\nif ($cms_mod[''value''][2] != ''pages'')\r\n{\r\n	$mip_form[''3''][''desc''] = ''Komplette Ordnerstruktur anzeigen:'';\r\n	$mip_form[''3''][''cat''] = ''chk'';\r\n	$mip_form[''3''][''option_var''][0] = ''MOD_VAR[3]'';\r\n	$mip_form[''3''][''option_val''][0] = $cms_mod[''value''][3];\r\n	$mip_form[''3''][''option_desc''][0] = ''ja'';\r\n	$mip_form[''3''][''option_val_select''][0] = ''true'';\r\n\r\n	$mip_form[''5''][''cat''] = ''txt'';\r\n	$mip_form[''5''][''type''] = '''';\r\n	$mip_form[''5''][''desc''] = ''Anzahl darzustellender Ebenen <small>(0: alle)</small>:'';\r\n	$mip_form[''5''][''cms_var''] = ''MOD_VAR[5]'';\r\n	$mip_form[''5''][''cms_val''] = $cms_mod[''value''][5];\r\n\r\n	$mip_form[''7''][''cat''] = ''txt'';\r\n	$mip_form[''7''][''type''] = '''';\r\n	$mip_form[''7''][''desc''] = ''Ordner ausschlie&szlig;en <small>(idcat kommasepariert angeben)</small>:'';\r\n	$mip_form[''7''][''cms_var''] = ''MOD_VAR[7]'';\r\n	$mip_form[''7''][''cms_val''] = $cms_mod[''value''][7];\r\n\r\n	$mip_form[''9''][''desc''] = ''Ordner nur als aktiv markieren, wenn Startseite angezeigt wird'';\r\n	$mip_form[''9''][''cat''] = ''chk'';\r\n	$mip_form[''9''][''option_var''][0] = ''MOD_VAR[9]'';\r\n	$mip_form[''9''][''option_val''][0] = $cms_mod[''value''][9];\r\n	$mip_form[''9''][''option_desc''][0] = ''ja'';\r\n	$mip_form[''9''][''option_val_select''][0] = ''true'';\r\n\r\n	$mip_form[''11''][''desc''] = ''Pfad als aktiv verfolgen'';\r\n	$mip_form[''11''][''cat''] = ''chk'';\r\n	$mip_form[''11''][''option_var''][0] = ''MOD_VAR[11]'';\r\n	$mip_form[''11''][''option_val''][0] = $cms_mod[''value''][11];\r\n	$mip_form[''11''][''option_desc''][0] = ''ja'';\r\n	$mip_form[''11''][''option_val_select''][0] = ''true'';\r\n	\r\n	$mip_form[''17''][''desc''] = ''Bei Ordnerlinks immer Link zur Startseite des Ordners generieren<br /> <small>(statt Link zum Ordner)</small>'';\r\n	$mip_form[''17''][''cat''] = ''chk'';\r\n	$mip_form[''17''][''option_var''][''0''] = ''MOD_VAR[17]'';\r\n	$mip_form[''17''][''option_val''][''0''] = $dedi_mod[''value''][''17''];\r\n	$mip_form[''17''][''option_desc''][''0''] = ''ja'';\r\n	$mip_form[''17''][''option_val_select''][''0''] = ''true'';\r\n\r\n	$mip_form[''24''][''cat''] = ''txtarea'';\r\n	$mip_form[''24''][''type''] = ''long'';\r\n	$mip_form[''24''][''rows''] = ''3'';\r\n	$mip_form[''24''][''desc''] = ''Ordner:<br/><small>M&ouml;gliche Templatevariablen: {name}, {link}, {desc}, {id}, {tabindex}, {depth}, {first}...[{else}...]{/first}, {last}...[{else}...]{/last}, {folder}</small>'';\r\n	$mip_form[''24''][''cms_var''] = ''MOD_VAR[24]'';\r\n	$mip_form[''24''][''cms_val''] = $cms_mod[''value''][24];\r\n	$mip_form[''24''][''cms_val_default''] = ''<li><a href="{link}">{name}</a>{folder}</li>\r\n'';\r\n\r\n\r\n	$mip_form[''25''][''cat''] = ''txtarea'';\r\n	$mip_form[''25''][''type''] = ''long'';\r\n	$mip_form[''25''][''rows''] = ''3'';\r\n	$mip_form[''25''][''desc''] = ''Aktiver Ordner:<br/><small>M&ouml;gliche Templatevariable: {name}, {link}, {desc}, {id}, {tabindex}, {depth}, {first}...[{else}...]{/first}, {last}...[{else}...]{/last}, {folder}</small>'';\r\n	$mip_form[''25''][''cms_var''] = ''MOD_VAR[25]'';\r\n	$mip_form[''25''][''cms_val''] = $cms_mod[''value''][25];\r\n	$mip_form[''25''][''cms_val_default''] = ''<li><a href="{link}">{name}</a>{folder}</li>\r\n'';	\r\n\r\n  $mip_form[''27''][''cat''] = ''txtarea'';\r\n	$mip_form[''27''][''type''] = ''long'';\r\n	$mip_form[''27''][''rows''] = ''3'';\r\n	$mip_form[''27''][''desc''] = ''Verfolgter Ordner:<br/><small>M&ouml;gliche Templatevariable: {name}, {link}, {desc}, {id}, {tabindex}, {first}...{/first}, {last}...{/last}, {folder}</small>'';\r\n	$mip_form[''27''][''cms_var''] = ''MOD_VAR[27]'';\r\n	$mip_form[''27''][''cms_val''] = $cms_mod[''value''][27];\r\n	$mip_form[''27''][''cms_val_default''] = ''<li><a href="{link}">{name}</a>{folder}</li>\r\n'';	\r\n\r\n}\r\nelse\r\n{\r\n	$mip_form[''3''][''cat''] = ''hidden'';\r\n	$mip_form[''3''][''cms_var''] = ''MOD_VAR[3]'';\r\n	$mip_form[''3''][''cms_val''] = $cms_mod[''value''][''3''];\r\n\r\n	$mip_form[''5''][''cat''] = ''hidden'';\r\n	$mip_form[''5''][''cms_var''] = ''MOD_VAR[5]'';\r\n	$mip_form[''5''][''cms_val''] = $cms_mod[''value''][''5''];\r\n\r\n	$mip_form[''7''][''cat''] = ''hidden'';\r\n	$mip_form[''7''][''cms_var''] = ''MOD_VAR[7]'';\r\n	$mip_form[''7''][''cms_val''] = $cms_mod[''value''][''7''];\r\n\r\n	$mip_form[''9''][''cat''] = ''hidden'';\r\n	$mip_form[''9''][''cms_var''] = ''MOD_VAR[9]'';\r\n	$mip_form[''9''][''cms_val''] = $cms_mod[''value''][''9''];\r\n\r\n	$mip_form[''11''][''cat''] = ''hidden'';\r\n	$mip_form[''11''][''cms_var''] = ''MOD_VAR[11]'';\r\n	$mip_form[''11''][''cms_val''] = $cms_mod[''value''][''11''];\r\n\r\n	$mip_form[''17''][''cat''] = ''hidden'';\r\n	$mip_form[''17''][''cms_var''] = ''MOD_VAR[17]'';\r\n	$mip_form[''17''][''cms_val''] = $cms_mod[''value''][''17''];\r\n	\r\n	$mip_form[''24''][''cat''] = ''hidden'';\r\n	$mip_form[''24''][''cms_var''] = ''MOD_VAR[24]'';\r\n	$mip_form[''24''][''cms_val''] = $cms_mod[''value''][''24''];\r\n\r\n	$mip_form[''25''][''cat''] = ''hidden'';\r\n	$mip_form[''25''][''cms_var''] = ''MOD_VAR[25]'';\r\n	$mip_form[''25''][''cms_val''] = $cms_mod[''value''][''25''];\r\n\r\n	$mip_form[''27''][''cat''] = ''hidden'';\r\n	$mip_form[''27''][''cms_var''] = ''MOD_VAR[27]'';\r\n	$mip_form[''27''][''cms_val''] = $cms_mod[''value''][''27''];\r\n	\r\n}\r\n\r\nif ($cms_mod[''value''][2] != ''folders'')\r\n{\r\n	$mip_form[''4''][''desc''] = ''Startseiten anzeigen'';\r\n	$mip_form[''4''][''cat''] = ''option'';\r\n    $mip_form[''4''][''cms_var''] = ''MOD_VAR[4]'';\r\n    $mip_form[''4''][''cms_val''] = $cms_mod[''value''][''4''];	\r\n    $mip_form[''4''][''option_desc''][0] = ''Nein'';\r\n    $mip_form[''4''][''option_desc''][1] = ''Ja'';\r\n    $mip_form[''4''][''option_desc''][2] = ''Bei mehr als einer Seite'';\r\n    $mip_form[''4''][''option_val''][0] = '''';\r\n    $mip_form[''4''][''option_val''][1] = ''true'';\r\n    $mip_form[''4''][''option_val''][2] = ''gt1'';\r\n	\r\n	$mip_form[''8''][''cat''] = ''txt'';\r\n	$mip_form[''8''][''type''] = '''';\r\n	$mip_form[''8''][''desc''] = ''Seiten ausschlie&szlig;en <small>(idcatside kommasepariert angeben)</small>:'';\r\n	$mip_form[''8''][''cms_var''] = ''MOD_VAR[8]'';\r\n	$mip_form[''8''][''cms_val''] = $cms_mod[''value''][''8''];\r\n\r\n	$mip_form[''22''][''cat''] = ''txtarea'';\r\n	$mip_form[''22''][''type''] = ''long'';\r\n	$mip_form[''22''][''rows''] = ''3'';\r\n	$mip_form[''22''][''desc''] = ''Seite:<br/><small>M&ouml;gliche Templatevariable: {name}, {link}, {desc}, {summary}, {id}, {tabindex}, {depth}, {first}...[{else}...]{/first}, {last}...[{else}...]{/last}</small>'';\r\n	$mip_form[''22''][''cms_var''] = ''MOD_VAR[22]'';\r\n	$mip_form[''22''][''cms_val''] = $cms_mod[''value''][''22''];\r\n	$mip_form[''22''][''cms_val_default''] = ''<li><a href="{link}">{name}</a></li>\r\n'';\r\n\r\n	$mip_form[''23''][''cat''] = ''txtarea'';\r\n	$mip_form[''23''][''type''] = ''long'';\r\n	$mip_form[''23''][''rows''] = ''3'';\r\n	$mip_form[''23''][''desc''] = ''Aktuelle Seite:<br/><small>M&ouml;gliche Templatevariable: {name}, {link}, {desc}, {summary}, {id}, {tabindex}, {depth}, {first}...[{else}...]{/first}, {last}...[{else}...]{/last}</small>'';\r\n	$mip_form[''23''][''cms_var''] = ''MOD_VAR[23]'';\r\n	$mip_form[''23''][''cms_val''] = $cms_mod[''value''][''23''];\r\n	$mip_form[''23''][''cms_val_default''] = ''<li><a href="{link}">{name}</a></li>\r\n'';\r\n\r\n	$mip_form[''28''][''cat''] = ''txt'';\r\n	$mip_form[''28''][''type''] = '''';\r\n	$mip_form[''28''][''desc''] = ''In folgenden Ordnern keine Seiten anzeigen <small>(idcat kommasepariert angeben)</small>:'';\r\n	$mip_form[''28''][''cms_var''] = ''MOD_VAR[28]'';\r\n	$mip_form[''28''][''cms_val''] = $cms_mod[''value''][28];\r\n}\r\nelse\r\n{\r\n	$mip_form[''4''][''cat''] = ''hidden'';\r\n	$mip_form[''4''][''cms_var''] = ''MOD_VAR[4]'';\r\n	$mip_form[''4''][''cms_val''] = $cms_mod[''value''][''4''];\r\n\r\n	$mip_form[''8''][''cat''] = ''hidden'';\r\n	$mip_form[''8''][''cms_var''] = ''MOD_VAR[8]'';\r\n	$mip_form[''8''][''cms_val''] = $cms_mod[''value''][''8''];\r\n\r\n	$mip_form[''22''][''cat''] = ''hidden'';\r\n	$mip_form[''22''][''cms_var''] = ''MOD_VAR[22]'';\r\n	$mip_form[''22''][''cms_val''] = $cms_mod[''value''][''22''];\r\n\r\n	$mip_form[''23''][''cat''] = ''hidden'';\r\n	$mip_form[''23''][''cms_var''] = ''MOD_VAR[23]'';\r\n	$mip_form[''23''][''cms_val''] = $cms_mod[''value''][''23''];\r\n\r\n	$mip_form[''28''][''cat''] = ''hidden'';\r\n	$mip_form[''28''][''cms_var''] = ''MOD_VAR[28]'';\r\n	$mip_form[''28''][''cms_val''] = $cms_mod[''value''][''28''];	\r\n}\r\n\r\n\r\nmip_formsp($mip_form[''99'']);	// Konfigurationsmodus\r\n\r\nif ($cms_mod[''value''][99] != ''advanced'')\r\n{\r\n	foreach($mip_form AS $listnavi[''id'']=>$listnavi[''mip''])\r\n	{\r\n		if (($cms_mod[''value''][99] == ''hidden'') || !in_array($listnavi[''id''], $listnavi[''show_in_standard_mode'']))\r\n		{\r\n			$mip_form[$listnavi[''id'']][''cat''] = ''hidden'';\r\n			$mip_form[$listnavi[''id'']][''cms_var''] = ''MOD_VAR['' . $listnavi[''id''] . '']'';\r\n			$mip_form[$listnavi[''id'']][''cms_val''] = $cms_mod[''value''][$listnavi[''id'']];\r\n		}\r\n	}\r\n}\r\n\r\nmip_formsp($mip_form[''1'']);		// Startordner\r\nmip_formsp($mip_form[''29'']);		// Rootlevel verschieben\r\nmip_formsp($mip_form[''2'']);		// Anzeigeart (Ordner mit Seiten, nur Ordner, nur Seiten)\r\nmip_formsp($mip_form[''14'']);		// Sortierung\r\nmip_formsp($mip_form[''15'']);		// Richtung der Sortierung\r\nmip_formsp($mip_form[''16'']);		// Erst Ordner, dann Seiten anzeigen\r\nmip_formsp($mip_form[''17'']);		// Bei Ordnerlinks immer Link zur Startseite des Ordners generieren (statt Link zum Ordner)\r\nmip_formsp($mip_form[''3'']);		// Komplette Ordnerstruktur anzeigen\r\nmip_formsp($mip_form[''5'']);		// Anzahl darzustellender Ebenen\r\nmip_formsp($mip_form[''4'']);		// Startseiten anzeigen\r\nmip_formsp($mip_form[''9'']);		// Ordner nur als aktiv markieren, wenn Startseite angezeigt wird\r\nmip_formsp($mip_form[''11'']);		// Pfad als aktiv verfolgen\r\nmip_formsp($mip_form[''7'']);		// Ordner ausschliessen\r\nmip_formsp($mip_form[''28'']);		// Ordner ohne Seiten anzeigen\r\nmip_formsp($mip_form[''8'']);		// Seiten ausschliessen\r\nmip_formsp($mip_form[''6'']);		// Ausgeschlossene Seiten und Ordner auch im Backend verbergen\r\nmip_formsp($mip_form[''12'']);		// Einleitung/Ende der Navigation verbergen, falls Navigation "leer"\r\nmip_formsp($mip_form[''13'']);		// Startnummer Tabindex\r\nmip_formsp($mip_form[''30'']);		// Routing\r\nmip_formsp($mip_form[''20'']);		// Template: Einleitung der Navigation\r\nmip_formsp($mip_form[''21'']);		// Template: Ende der Navigation\r\nmip_formsp($mip_form[''26'']);		// Template: Ebene\r\nmip_formsp($mip_form[''22'']);		// Template: Seite\r\nmip_formsp($mip_form[''23'']);		// Template: Aktuelle Seite\r\nmip_formsp($mip_form[''24'']);		// Template: Ordner\r\nmip_formsp($mip_form[''25'']);		// Template: Aktiver Ordner\r\nmip_formsp($mip_form[''27'']);		// Template: Ordner, wenn als aktiv verfolgt\r\n\r\nunset($mip_form);\r\n?>', '<CMSPHP>\r\n\r\n<CMSPHP:CACHE>\r\n\r\n\r\n\r\n$ln_routing[''idcatside''] = $idcatside;\r\n$ln_routing[''idcat''] = $idcat;\r\n$ln_routing[''routings''] = array();\r\n$ln_routing[''idcat_temp''] = $ln_routing[''idcatside_temp''] = false;\r\n$ln_routing[''raw''] = trim( str_replace('' '', '''', "MOD_VALUE[30]"));\r\n\r\nif (strlen($ln_routing[''raw'']) > 14) {\r\n  $ln_routing[''raw_vals''] = explode("\\n", $ln_routing[''raw'']);\r\n  foreach ($ln_routing[''raw_vals''] AS $v) {\r\n    $pieces = explode(''>'', $v);\r\n    $ln_routing[''routings''][ $pieces[''0''] ] = $pieces[''1''];\r\n  }\r\n}\r\n\r\n\r\n//source idcatside\r\nif (array_key_exists(''idcatside:''.$idcatside, $ln_routing[''routings''])) {\r\n  //idcatside to idcatside\r\n  if( strstr ( $ln_routing[''routings''][''idcatside:''.$idcatside], ''idcatside'')) {\r\n    $ln_routing[''idcatside_temp''] = (int) str_replace(''idcatside:'', '''', $ln_routing[''routings''][''idcatside:''.$idcatside]);\r\n	if ($ln_routing[''idcatside_temp''] > 0) {\r\n	  $idcatside = $ln_routing[''idcatside_temp''];\r\n	  $idcat = $con_side[$idcatside][''idcat''];\r\n	}\r\n  //idcatside to idcat\r\n  } else {\r\n  	$ln_routing[''idcat_temp''] = (int) str_replace(''idcat:'', '''', $ln_routing[''routings''][''idcatside:''.$idcatside]);\r\n    if ($ln_routing[''idcat_temp''] > 0) {\r\n		$idcat = $ln_routing[''idcat_temp''];\r\n		$idcatside = $SF_catinfos->getIdcatsideStartpage($idcat);\r\n    }\r\n  }\r\n// source idcat\r\n} else if (array_key_exists(''idcat:''.$idcat, $ln_routing[''routings''])) {\r\n	//idcat to idcatside\r\n	if( strstr ( $ln_routing[''routings''][''idcat:''.$idcat], ''idcatside'')) {\r\n	    $ln_routing[''idcatside_temp''] = (int) str_replace(''idcatside:'', '''', $ln_routing[''routings''][''idcat:''.$idcat]);\r\n	    if ($ln_routing[''idcatside_temp''] > 0) {\r\n			$idcatside = $ln_routing[''idcatside_temp''];\r\n			$idcat = $con_side[$idcatside][''idcat''];\r\n	    }\r\n	//idcat to idcat\r\n	} else {\r\n		$ln_routing[''idcat_temp''] = (int) str_replace(''idcat:'', '''', $ln_routing[''routings''][''idcat:''.$idcat]);\r\n		if ($ln_routing[''idcat_temp''] > 0) {\r\n		  $idcat = $ln_routing[''idcat_temp''];\r\n		  $idcatside = $SF_catinfos->getIdcatsideStartpage($idcat);\r\n		}\r\n	}\r\n}\r\n\r\n\r\n</CMSPHP:CACHE>\r\n\r\n\r\n\r\n//Description of cats\r\nif(! function_exists(get_cat_desc)){\r\n    function get_cat_desc($a)\r\n{\r\nglobal $db,$cms_db;\r\n$sql  = "SELECT\r\n			*\r\n		FROM \r\n	   ".$cms_db[''cat_lang'']." \r\n		WHERE idcatlang = ''".$a."''";\r\n$db->query($sql);\r\n$db->next_record();\r\nreturn $db->f(''description''); \r\n}}\r\n\r\n//Descritpion of pages\r\nif(! function_exists(get_side_desc)){\r\n    function get_side_desc($a,$which)\r\n{\r\nglobal $db,$cms_db;\r\n$sql  = "SELECT\r\n			*\r\n		FROM \r\n	   ".$cms_db[''side_lang'']." LEFT JOIN\r\n		".$cms_db[''cat_side'']." USING(IDSIDE)\r\n		WHERE \r\nidcatside = ''".$a."''";\r\n$db->query($sql);\r\n$db->next_record();\r\n\r\nif ($which == ''desc'') {\r\nreturn $db->f(''meta_description''); }\r\nelseif ($which == ''summary''){\r\nreturn $db->f(''summary''); }\r\n}}\r\n\r\n\r\n\r\n\r\n\r\n\r\n//global $evil_global_variable_for_easy_tabindex_implementation, $mod;\r\n$evil_global_variable_for_easy_tabindex_implementation = 1;\r\n\r\n$mod[''desc''] = array();\r\n\r\n// idcat des Start-Ordners besorgen\r\n<CMSPHP:CACHE>\r\nif(! function_exists(''nav_negotiate_startlevel'') ){\r\nfunction nav_negotiate_startlevel( $current_cat, $startlevel ){\r\n        global $con_tree;\r\n\r\n        //echo "$cat, $searcharray <br />";//return false;\r\n        if (empty($current_cat) || $current_cat == 0 || ! is_int($current_cat) || ! is_int($startlevel)  ) {\r\n                return $current_cat;\r\n        }\r\n\r\n        $levels = array();\r\n        array_push($levels, $current_cat);\r\n        $cat = $current_cat;\r\n        while(true) {\r\n                $cat = (int) $con_tree[$cat][''parent''];\r\n                array_push($levels, $cat);\r\n                if ($cat == 0) break;\r\n        }\r\n        $levels_rev = array_reverse($levels);\r\n        //print_r($levels_rev);exit;\r\n\r\n        if ($levels_rev[$startlevel] > 0) {\r\n                return $levels_rev[$startlevel];\r\n        } else {\r\n                return $current_cat;\r\n        }\r\n}}\r\n\r\n\r\nif ($cms_mod[''value''][1] == ''root'')\r\n{\r\n        $cms_mod[''value''][1] = ''0'';\r\n}\r\nelseif ($cms_mod[''value''][1] == ''this'')\r\n{\r\n        $cms_mod[''value''][1] = $idcat;\r\n}\r\n\r\n$mod[''startlevel'']  = (int) "MOD_VALUE[29]";\r\nif ($mod[''startlevel''] > 0) {\r\n  $cms_mod[''value''][1] = (string) nav_negotiate_startlevel( (int) $idcat, $mod[''startlevel'']);\r\n}\r\n\r\nif (!$cms_mod[''value''][14])\r\n{\r\n	// Update von einer Version kleiner als 0.9-dev => Diese Variablen wurden noch nicht durch die Modulkonfiguration gesetzt\r\n	$cms_mod[''value''][14] = ''sortindex'';\r\n	$cms_mod[''value''][15] = ''SORT_ASC'';\r\n}\r\n\r\n\r\n// Anzahl darzustellender Ebenen auf 0 setzen, falls unsinnige Werte angegeben wurden\r\nif (!is_numeric($cms_mod[''value''][5]) || ($cms_mod[''value''][5] < 0))\r\n{\r\n	$cms_mod[''value''][5] = 0;\r\n}\r\n\r\n// Startnummer fuer tabindex auf 1 setzen, falls unsinnige Werte angegeben wurden\r\nif (!is_numeric($cms_mod[''value''][13]) || ($cms_mod[''value''][13] < 1))\r\n{\r\n	$cms_mod[''value''][13] = 1;\r\n}\r\n</CMSPHP:CACHE>\r\n\r\n\r\n/*\r\n * Hilfs-Funktionen\r\n */\r\n\r\nfunction print_folder_<CMSPHP:CACHE>echo $cms_mod[''container''][''id''];</CMSPHP:CACHE>($folder, $depth)\r\n{\r\n	<CMSPHP:CACHE>\r\n	if ($cms_mod[''value''][16] == ''true'')\r\n	{\r\n	</CMSPHP:CACHE>\r\n		$output = print_folder_helper_folders_<CMSPHP:CACHE>echo $cms_mod[''container''][''id''];</CMSPHP:CACHE>($folder, $depth);\r\n		$output .= print_folder_helper_pages_<CMSPHP:CACHE>echo $cms_mod[''container''][''id''];</CMSPHP:CACHE>($folder, $depth);\r\n	<CMSPHP:CACHE>\r\n	}\r\n	else\r\n	{\r\n	</CMSPHP:CACHE>\r\n		$output = print_folder_helper_pages_<CMSPHP:CACHE>echo $cms_mod[''container''][''id''];</CMSPHP:CACHE>($folder, $depth);\r\n		$output .= print_folder_helper_folders_<CMSPHP:CACHE>echo $cms_mod[''container''][''id''];</CMSPHP:CACHE>($folder, $depth);\r\n	<CMSPHP:CACHE>\r\n	}\r\n	</CMSPHP:CACHE>\r\n	\r\n	if (strlen($output) > 0)\r\n	{\r\n		$tpl = str_replace(''{id}'', $folder[''idcat''], "MOD_VALUE[26]"); \r\n		$output = str_replace(''{layer}'', $output, $tpl);\r\n	}\r\n	\r\n	return $output;\r\n}\r\n\r\n\r\nfunction print_folder_helper_pages_<CMSPHP:CACHE>echo $cms_mod[''container''][''id''];</CMSPHP:CACHE>($folder, $depth)\r\n{\r\n	global $evil_global_variable_for_easy_tabindex_implementation, $con_side, $mod, $sess;\r\n	\r\n	$cats_no_pages = explode(",", trim(str_replace('' '', '''', "MOD_VALUE[28]")));\r\n	\r\n	// Seiten ausgeben\r\n	if (isset($folder[''pages'']))\r\n	{  \r\n	  $pagevals = array_values($folder[''pages'']);\r\n	  if(! in_array($con_side[ $pagevals[''0''] ][''idcat''],$cats_no_pages) || (''MOD_VALUE[6]'' != ''true'' && $sess->name == ''sefrengo'' ) )\r\n    {\r\n	   \r\n  		foreach ($folder[''pages''] as $idcatside)\r\n  		{\r\n  			$template = ($idcatside == <CMSPHP:CACHE>echo $idcatside;</CMSPHP:CACHE>) ? "MOD_VALUE[23]" : "MOD_VALUE[22]";\r\n  			$item = str_replace(''{name}'', htmlspecialchars($con_side[$idcatside][''name''], ENT_COMPAT, ''UTF-8''), $template);\r\n  			$item = str_replace(''{desc}'', htmlspecialchars(get_side_desc($idcatside,''desc''), ENT_COMPAT, ''UTF-8''), $item);\r\n  			$item = str_replace(''{summary}'', htmlspecialchars(get_side_desc($idcatside,''summary''), ENT_COMPAT, ''UTF-8''), $item);\r\n  			$item = str_replace(''{link}'', $con_side[$idcatside][''link''], $item);\r\n  			$item = str_replace(''{id}'', $idcatside, $item);\r\n  			$item = str_replace(''{depth}'', $depth, $item);\r\n  			if (strstr($item, ''{tabindex}'') !== false)\r\n  			{\r\n  				$item = str_replace(''{tabindex}'', $evil_global_variable_for_easy_tabindex_implementation++, $item);\r\n  			}\r\n  \r\n  			<CMSPHP:CACHE>\r\n  			if (strstr($cms_mod[''value''][22], ''{first}'') || strstr($cms_mod[''value''][23], ''{first}''))\r\n  			{\r\n  			</CMSPHP:CACHE>\r\n  				if ($folder[''first''])\r\n  				{\r\n  					$folder[''first''] = false;\r\n  					$item = preg_replace("/{first}(.*?)({else}(.*?))?{\\/first}/", "\\\\1", $item);\r\n  				}\r\n  				else\r\n  				{\r\n  					$item = preg_replace("/{first}(.*?)({else}(.*?))?{\\/first}/", "\\\\3", $item);\r\n  				}\r\n  			<CMSPHP:CACHE>\r\n  			}\r\n  \r\n  			if (strstr($cms_mod[''value''][22], ''{last}'') || strstr($cms_mod[''value''][23], ''{last}''))\r\n  			{\r\n  			</CMSPHP:CACHE>\r\n  				if (($folder[''last_thing''] == ''page'') && ($folder[''last''] == $idcatside))\r\n  				{\r\n  					$item = preg_replace("/{last}(.*?)({else}(.*?))?{\\/last}/", "\\\\1", $item);\r\n  				}\r\n  				else\r\n  				{\r\n  					$item = preg_replace("/{last}(.*?)({else}(.*?))?{\\/last}/", "\\\\3", $item);\r\n  				}\r\n  			<CMSPHP:CACHE>\r\n  			}\r\n  			</CMSPHP:CACHE>\r\n  \r\n  			$temp .= $item;\r\n  		}\r\n  	}\r\n	}\r\n	\r\n	return $temp;\r\n}\r\n\r\n\r\nfunction print_folder_helper_folders_<CMSPHP:CACHE>echo $cms_mod[''container''][''id''];</CMSPHP:CACHE>($folder, $depth)\r\n{\r\n	global $evil_global_variable_for_easy_tabindex_implementation, $con_tree, $con_side, $mod;\r\n  \r\n  $cats_no_pages = explode(",", trim(str_replace('' '', '''', "MOD_VALUE[28]")));\r\n  \r\n	// Ordner ausgeben\r\n	if (is_array($folder[''children'']))\r\n	{\r\n		// Alle Unterordner dieses Ordners durchgehen\r\n		foreach ($folder[''children''] as $subfolder)\r\n		{\r\n			$idcat = $subfolder[''idcat''];\r\n			$active_side_is_start = <CMSPHP:CACHE>echo $con_side[$idcatside][''is_start''];</CMSPHP:CACHE>;\r\n      $active_cat = <CMSPHP:CACHE>echo $idcat;</CMSPHP:CACHE>;\r\n      $show_start_page = "<CMSPHP:CACHE>echo "MOD_VALUE[4]";</CMSPHP:CACHE>";\r\n				\r\n			<CMSPHP:CACHE>\r\n			// Falls "Ordner nur als aktiv markieren, wenn Startseite angezeigt wird" gewaehlt wurde\r\n			// und die aktuelle (die angezeigte) Seite keine Startseite ist, ...\r\n			if (($cms_mod[''value''][9] == ''true'') && ($con_side[$idcatside][''is_start''] != ''1''))\r\n			{\r\n			</CMSPHP:CACHE>\r\n				// ... die Vorlage (Template) "Ordner" nehmen, ...\r\n				$template = "MOD_VALUE[24]";\r\n			<CMSPHP:CACHE>\r\n			}\r\n			else\r\n			{\r\n			</CMSPHP:CACHE>\r\n				// ... andernfalls die Vorlage "Aktiver Ordner" benutzen, wenn der Unterordner\r\n				// der aktuelle ("angezeigte") Ordner ist und sonst die Vorlage "Ordner" verwenden.\r\n				$template = ($idcat == <CMSPHP:CACHE>echo $idcat;</CMSPHP:CACHE>) ? "MOD_VALUE[25]" : "MOD_VALUE[24]";\r\n				<CMSPHP:CACHE>\r\n				if ($cms_mod[''value''][11] == ''true'')\r\n				{\r\n				</CMSPHP:CACHE>\r\n					if (in_array($idcat, $mod[''active'']))\r\n					{\r\n					   //aktive (25) oder verfolgte (27) kategorie\r\n					   if ($idcat == $active_cat){\r\n					        //ist aktiver ordner\r\n					        //print_r($folder);\r\n                  if ( in_array($idcat, $cats_no_pages)  \r\n                  || ($active_side_is_start == ''1'' && ($show_start_page == ''false'' || ($show_start_page == ''gt1'' && count($subfolder[''pages'']) < 2) ) ) \r\n                 /*|| count($folder[''pages'']) < 2 && */ ) {\r\n                    $template = "MOD_VALUE[25]";\r\n                  //ist verfolter ordner\r\n                  } else {\r\n                    $template = "MOD_VALUE[27]";\r\n                  }\r\n              } else {\r\n                  $template = "MOD_VALUE[27]";\r\n              }\r\n					}\r\n				<CMSPHP:CACHE>\r\n				}\r\n			}\r\n			</CMSPHP:CACHE>\r\n\r\n			$item = str_replace(''{name}'', htmlspecialchars($con_tree[$idcat][''name''], ENT_COMPAT, ''UTF-8''), $template);\r\n			$item = str_replace(''{desc}'', htmlspecialchars(get_cat_desc($idcat), ENT_COMPAT, ''UTF-8''), $item);\r\n			//$item = str_replace(''{link}'', $con_tree[$idcat][''link''], $item);\r\n			if (''MOD_VALUE[17]'' == ''true'')\r\n			{\r\n                $item = str_replace(''{link}'', $con_side[ $GLOBALS[''SF_catinfos'']->getIdcatsideStartpage($idcat) ][''link''], $item);\r\n			} else {\r\n			     $item = str_replace(''{link}'', $con_tree[$idcat][''link''], $item);\r\n			} \r\n			\r\n			$item = str_replace(''{id}'', $idcat, $item);\r\n			$item = str_replace(''{depth}'', $depth, $item);\r\n			if (strstr($item, ''{tabindex}'') !== false)\r\n			{\r\n				$item = str_replace(''{tabindex}'', $evil_global_variable_for_easy_tabindex_implementation++, $item);\r\n			}\r\n\r\n			<CMSPHP:CACHE>\r\n			if (strstr($cms_mod[''value''][24], ''{first}'') || strstr($cms_mod[''value''][25], ''{first}''))\r\n			{\r\n			</CMSPHP:CACHE>\r\n				if ($folder[''first''])\r\n				{\r\n					$folder[''first''] = false;\r\n					$item = preg_replace("/{first}(.*?)({else}(.*?))?{\\/first}/", "\\\\1", $item);\r\n				}\r\n				else\r\n				{\r\n					$item = preg_replace("/{first}(.*?)({else}(.*?))?{\\/first}/", "\\\\3", $item);\r\n				}\r\n			<CMSPHP:CACHE>\r\n			}\r\n\r\n			if (strstr($cms_mod[''value''][24], ''{last}'') || strstr($cms_mod[''value''][25], ''{last}''))\r\n			{\r\n			</CMSPHP:CACHE>\r\n				if (($folder[''last_thing''] == ''folder'') && ($folder[''last''] == $idcat))\r\n				{\r\n					$item = preg_replace("/{last}(.*?)({else}(.*?))?{\\/last}/", "\\\\1", $item);\r\n				}\r\n				else\r\n				{\r\n					$item = preg_replace("/{last}(.*?)({else}(.*?))?{\\/last}/", "\\\\3", $item);\r\n				}\r\n			<CMSPHP:CACHE>\r\n			}\r\n			</CMSPHP:CACHE>\r\n\r\n			$subfolder_data = print_folder_<CMSPHP:CACHE>echo $cms_mod[''container''][''id''];</CMSPHP:CACHE>($subfolder, $depth+1);\r\n						\r\n			$temp .= str_replace("{folder}", $subfolder_data, $item);\r\n		}\r\n	}\r\n\r\n	return $temp;	\r\n}\r\n\r\n\r\nfunction build_navi_tree_<CMSPHP:CACHE>echo $cms_mod[''container''][''id''];</CMSPHP:CACHE>($start, $depth, $first = false)\r\n{\r\n	global $catlist, $con_tree, $con_side, $cms_side, $db, $mod, $cms_db, $lang;\r\n\r\n	$entry[''idcat''] = $start;\r\n	\r\n	if ($first)\r\n	{\r\n		$entry[''first''] = true;\r\n	}\r\n\r\n	<CMSPHP:CACHE>\r\n	if ($cms_mod[''value''][3] != ''true'')\r\n	{\r\n		echo ''else if (!in_array($start, $mod[\\''path\\''])) return $entry;'';\r\n	}\r\n\r\n	if ($cms_mod[''value''][5] > 0)\r\n	{\r\n		echo ''if ($depth >= '' . (int)$cms_mod[''value''][5] . '') return $entry;'';\r\n	}\r\n	</CMSPHP:CACHE>\r\n	\r\n\r\n	// $hide == true <=> Ausgeschlossene Seiten und Ordner verbergen\r\n	$hide = <CMSPHP:CACHE>echo ($cms_mod[''value''][6] == ''true'') ? ''true'' : ''(!isset($cms_side[\\''view\\'']))'';</CMSPHP:CACHE>;\r\n\r\n	<CMSPHP:CACHE>\r\n	if ($cms_mod[''value''][2] != ''folders'')\r\n	{\r\n	</CMSPHP:CACHE>\r\n		// Alle zu diesem Ordner gehoerigen Seiten zusammensuchen\r\n		foreach ($con_side as $idcatside=>$page)\r\n		{\r\n			// Seite ins Array aufnehmen, wenn ...\r\n			if ( ($page[''idcat''] == $start) &&\r\n                 (\r\n				   <CMSPHP:CACHE>\r\n				   // ... es keine Startseite ist (nur wenn keine Startseiten angezeigt werden sollen) und ...\r\n				   if ($cms_mod[''value''][''4''] == '''')\r\n				   {\r\n			         echo ''($con_side[$idcatside][\\''is_start\\''] == \\''0\\'') &&'';\r\n				   }\r\n				   </CMSPHP:CACHE>\r\n				   (\r\n				     // ... wir im Backend sind, oder ...\r\n				     isset($cms_side[''view'']) ||\r\n				     // ... diese online ist ...\r\n				     ($con_side[$idcatside][''online''] != 0)\r\n				   )\r\n				 ) &&\r\n				 // ... und diese Seite nicht ausgeschlossen wurde (oder wir im Backend sind und ausgeschlossene Seiten dort angezeigt werden sollen)\r\n				 (!$hide || !strstr('',<CMSPHP:CACHE>echo str_replace('' '', '''', $cms_mod[''value''][8]);</CMSPHP:CACHE>,'', ",$idcatside,"))\r\n			   )\r\n			{\r\n				$entry[''pages''][] = $idcatside;\r\n				\r\n				<CMSPHP:CACHE>\r\n				// "Notizen"-Felder der Seiten lesen, falls diese verwendet werden\r\n				if (strstr($cms_mod[''value''][22], ''{desc}'') || strstr($cms_mod[''value''][23], ''{desc}''))\r\n				{\r\n				</CMSPHP:CACHE>\r\n\r\n					$db->query("SELECT summary FROM `" . $cms_db[''side_lang''] . "` WHERE idlang=''" . $lang . "'' AND idside=''" . $idcatside . "''" );\r\n					if ($db->next_record())\r\n					{\r\n						$mod[''desc''][$idcatside] = $db->f(''summary'');\r\n					}\r\n\r\n				<CMSPHP:CACHE>\r\n				}\r\n				</CMSPHP:CACHE>\r\n			}\r\n		}\r\n		//print_r($entry[''pages'']);print_r($cms_mod);echo "xxxxxxxxxxxxxxxx";\r\n		// seiten nur wenn mindestens zwei \r\n		if (''MOD_VALUE[4]'' == ''gt1'') {\r\n		  if (count($entry[''pages'']) < 2) {\r\n		      unset($entry[''pages'']);\r\n		  }\r\n		}\r\n		// Seiten sortieren\r\n		if (is_array($entry[''pages'']))\r\n		{\r\n			foreach ($entry[''pages''] as $idcatside)\r\n			{\r\n				$sortarray[] = $con_side[$idcatside][''<CMSPHP:CACHE>echo $cms_mod[''value''][14];</CMSPHP:CACHE>''];\r\n			}\r\n			array_multisort($sortarray, <CMSPHP:CACHE>echo (($cms_mod[''value''][14] == ''name'') ? "SORT_STRING" : "SORT_NUMERIC") . ", " . $cms_mod[''value''][15];</CMSPHP:CACHE>, $entry[''pages'']);\r\n		}\r\n\r\n	<CMSPHP:CACHE>\r\n	}\r\n	</CMSPHP:CACHE>\r\n\r\n\r\n	<CMSPHP:CACHE>\r\n	if ($cms_mod[''value''][2] != ''pages'')\r\n	{\r\n	</CMSPHP:CACHE>\r\n		\r\n		// Lokale Kopie von $catlist, weil der "foreach zeiger" fuer\r\n		// das globale Array durch die Rekursion verloren gehen wuerde\r\n		$catlist2 = $catlist;\r\n\r\n		// Fuer jeden Unterordner dieses Ordners diese Funktion aufrufen (Seiten und Unterordner zusammensuchen)\r\n		foreach ($catlist2 as $idcat)\r\n		{\r\n			// Unterordner ins Array aufnehmen, wenn ...\r\n			if ( ($con_tree[$idcat][''parent''] == $start) &&\r\n			     (\r\n			       // ... wir im Backend sind, oder ...\r\n			       isset($cms_side[''view'']) ||\r\n			       // ... dieser sichtbar/online ist ...\r\n			       ($con_tree[$idcat][''visible''] != 0)\r\n			     ) &&\r\n			     // ... und dieser Ordner nicht ausgeschlossen wurde (oder wir im Backend sind und ausgeschlossene Ordner dort angezeigt werden sollen)\r\n			     (!$hide || !strstr('',<CMSPHP:CACHE>echo str_replace('' '', '''', $cms_mod[''value''][7]);</CMSPHP:CACHE>,'', ",$idcat,"))\r\n			   )\r\n			{\r\n				$entry[''children''][$idcat] = build_navi_tree_<CMSPHP:CACHE>echo $cms_mod[''container''][''id''];</CMSPHP:CACHE>($idcat, $depth+1);\r\n			}\r\n		}\r\n\r\n\r\n		// Ordner sortieren\r\n		if (is_array($entry[''children'']))\r\n		{\r\n			unset($sortarray);\r\n			<CMSPHP:CACHE>\r\n			if ($cms_mod[''value''][14] == ''sortindex'')\r\n			{\r\n			</CMSPHP:CACHE>\r\n				$catlist2 = array();\r\n				foreach ($catlist as $key=>$value)\r\n				{\r\n					if (is_array($entry[''children''][$value]))\r\n					{\r\n						$catlist2[$value] = $key;\r\n					}\r\n				}\r\n	\r\n				foreach ($entry[''children''] as $idcat => $v)\r\n				{\r\n					$sortarray[] = $catlist2[$idcat];\r\n				}\r\n				\r\n				array_multisort($sortarray, SORT_NUMERIC, <CMSPHP:CACHE>echo $cms_mod[''value''][15];</CMSPHP:CACHE>, $entry[''children'']);\r\n			<CMSPHP:CACHE>\r\n			}\r\n			else\r\n			{\r\n			</CMSPHP:CACHE>\r\n				foreach ($entry[''children''] as $idcat => $v)\r\n				{\r\n					$sortarray[] = $con_tree[$idcat][''<CMSPHP:CACHE>echo $cms_mod[''value''][14];</CMSPHP:CACHE>''];\r\n				}\r\n				array_multisort($sortarray, <CMSPHP:CACHE>echo (($cms_mod[''value''][14] == ''name'') ? "SORT_STRING" : "SORT_NUMERIC") . ", " . $cms_mod[''value''][15];</CMSPHP:CACHE>, $entry[''children'']);\r\n			<CMSPHP:CACHE>\r\n			}\r\n			</CMSPHP:CACHE>\r\n		}\r\n\r\n	<CMSPHP:CACHE>\r\n	}\r\n	</CMSPHP:CACHE>\r\n\r\n	if ($first)\r\n	{\r\n		<CMSPHP:CACHE>\r\n		if (strstr($cms_mod[''value''][22], ''{last}'') || strstr($cms_mod[''value''][23], ''{last}'') ||\r\n		    strstr($cms_mod[''value''][24], ''{last}'') || strstr($cms_mod[''value''][25], ''{last}''))\r\n		{\r\n			if ($cms_mod[''value''][16] == true)\r\n			{\r\n			</CMSPHP:CACHE>\r\n				$current = &$entry;\r\n				$parent = &$entry;\r\n				$last = false;\r\n				do\r\n				{\r\n					if (is_array($current[''pages'']))\r\n					{\r\n						$temp = $current[''pages''];\r\n						$current[''last''] = array_pop($temp);\r\n						$current[''last_thing''] = ''page'';\r\n						$last = true;\r\n					}\r\n					else if (is_array($current[''children'']))\r\n					{\r\n						$index = array_pop(array_keys($current[''children'']));\r\n						$parent = &$current;\r\n						$current = &$current[''children''][$index];\r\n					}\r\n					else\r\n					{\r\n						$parent[''last_thing''] = ''folder'';\r\n						$parent[''last''] = $current[''idcat''];\r\n						$last = true;\r\n					}\r\n				}\r\n				while (!$last);\r\n			<CMSPHP:CACHE>\r\n			} else {\r\n			</CMSPHP:CACHE>\r\n				$current =& $entry;\r\n				$parent =& $entry;\r\n				$last = false;\r\n				do\r\n				{\r\n					if (is_array($current[''children'']))\r\n					{\r\n						$index = array_pop(array_keys($current[''children'']));\r\n						$parent =& $current;\r\n						$current =& $current[''children''][$index];\r\n					}\r\n					else if (is_array($current[''pages'']))\r\n					{\r\n						$temp = $current[''pages''];\r\n						$current[''last''] = array_pop($temp);\r\n						$current[''last_thing''] = ''page'';\r\n						$last = true;\r\n					}\r\n					else\r\n					{\r\n						$parent[''last_thing''] = ''folder'';\r\n						$parent[''last''] = $current[''idcat''];\r\n						$last = true;\r\n					}\r\n				}\r\n				while (!$last);\r\n		<CMSPHP:CACHE>\r\n			}\r\n		}\r\n		</CMSPHP:CACHE>\r\n	}\r\n\r\n	return $entry;\r\n}\r\n\r\n\r\n/*\r\n * "Hauptprogramm"\r\n */\r\n\r\n<CMSPHP:CACHE>\r\n// Falls nicht alle Unterordner angezeigt werden sollen oder der Pfad als aktiv verfolgt werden soll...\r\nif (($cms_mod[''value''][2] != ''pages'') && (($cms_mod[''value''][3] != ''true'') || ($cms_mod[''value''][11] == ''true'')))\r\n{\r\n</CMSPHP:CACHE>\r\n	// Pfad vom aktuellen Ordner zum Start-Ordner "berechnen"\r\n	$mod[''current_idcat''] = <CMSPHP:CACHE>echo $idcat;</CMSPHP:CACHE>;\r\n	$mod[''path''] = array();\r\n	<CMSPHP:CACHE>\r\n	if ($cms_mod[''value''][11] == ''true'')\r\n	{\r\n	</CMSPHP:CACHE>\r\n		$mod[''flag''] = true;\r\n	<CMSPHP:CACHE>\r\n	}\r\n	</CMSPHP:CACHE>\r\n	\r\n	while ($mod[''current_idcat''] != <CMSPHP:CACHE>echo $cms_mod[''value''][1];</CMSPHP:CACHE>)\r\n	{\r\n		$mod[''path''][] = $mod[''current_idcat''];\r\n		$mod[''current_idcat''] = $con_tree[$mod[''current_idcat'']][''parent''];\r\n\r\n		<CMSPHP:CACHE>\r\n		// Falls der Start-Ordner nicht "root" ist, ...\r\n		if ($cms_mod[''value''][1] != ''0'')\r\n		{\r\n		</CMSPHP:CACHE>\r\n\r\n			if ($mod[''current_idcat''] == 0)\r\n			{\r\n				// ... aber wir dort angekommen sind und den Startordner noch nicht gefunden haben,\r\n				// liegt die aktuelle Seite nicht im "Pfad"\r\n				<CMSPHP:CACHE>\r\n				if ($cms_mod[''value''][11] == ''true'')\r\n				{\r\n				</CMSPHP:CACHE>\r\n					$mod[''active''] = $mod[''path''];\r\n					$mod[''flag''] = false;\r\n				<CMSPHP:CACHE>\r\n				}\r\n				</CMSPHP:CACHE>\r\n				$mod[''path''] = array();\r\n				break;\r\n			}\r\n\r\n		<CMSPHP:CACHE>\r\n		}\r\n		</CMSPHP:CACHE>\r\n	}\r\n	\r\n	<CMSPHP:CACHE>\r\n	if ($cms_mod[''value''][11] == ''true'') {\r\n	</CMSPHP:CACHE>\r\n\r\n		if ($mod[''flag''])\r\n		{\r\n			$mod[''active''] = $mod[''path''];\r\n		}\r\n\r\n	<CMSPHP:CACHE>\r\n	}\r\n}\r\n</CMSPHP:CACHE>\r\n\r\n// Mit tabindex + 1 anfangen, wenn der Startordner ungleich Root ist, da in "Einleitung der Navigation" der tabindex benutzt werden koennte\r\n$evil_global_variable_for_easy_tabindex_implementation = <CMSPHP:CACHE>echo ($cms_mod[''value''][13] + (($cms_mod[''value''][1] != 0) ? 1 : 0));</CMSPHP:CACHE>;\r\n\r\n// Die Liste gemaess den gewaehlten Einstellungen aufbauen\r\n$mod[''output''] = print_folder_<CMSPHP:CACHE>echo $cms_mod[''container''][''id''];</CMSPHP:CACHE>(build_navi_tree_<CMSPHP:CACHE>echo $cms_mod[''container''][''id''];</CMSPHP:CACHE>(<CMSPHP:CACHE>echo $cms_mod[''value''][1];</CMSPHP:CACHE>, 0, true), 1);\r\n\r\n<CMSPHP:CACHE>\r\n\r\nif ($cms_mod[''value''][12] != ''true'')\r\n{\r\n	echo ''if ($mod[\\''output\\''] != "") {'';\r\n}\r\n\r\n</CMSPHP:CACHE>\r\n\r\n$mod[''intro''] = "MOD_VALUE[20]";\r\n$mod[''outro''] = "MOD_VALUE[21]";\r\n\r\n// Templatevariablen in Einleitung/Ende der Navigation ersetzen, falls der Startordner ungleich "root" ist und der Ordner sichtbar ist.\r\nif (<CMSPHP:CACHE>echo ($cms_mod[''value''][1] != 0) ? ''true'' : ''false'';</CMSPHP:CACHE> &&\r\n    ((isset($cms_side[''view'']) && <CMSPHP:CACHE>echo ($cms_mod[''value''][6] != ''true'') ? ''true'' : ''false'';</CMSPHP:CACHE>) ||\r\n    ($con_tree[<CMSPHP:CACHE>echo $cms_mod[''value''][1];</CMSPHP:CACHE>][''visible''] != 0)) )\r\n{\r\n	$mod[''intro''] = str_replace(''{name}'', htmlspecialchars($con_tree[<CMSPHP:CACHE>echo $cms_mod[''value''][1];</CMSPHP:CACHE>][''name''], ENT_COMPAT, ''UTF-8''), $mod[''intro'']);\r\n	$mod[''intro''] = str_replace(''{desc}'', htmlspecialchars(get_cat_desc(<CMSPHP:CACHE>echo $cms_mod[''value''][1];</CMSPHP:CACHE>), ENT_COMPAT, ''UTF-8''), $mod[''intro'']);\r\n	$mod[''intro''] = str_replace(''{link}'', $con_tree[<CMSPHP:CACHE>echo $cms_mod[''value''][1];</CMSPHP:CACHE>][''link''], $mod[''intro'']);\r\n	$mod[''intro''] = str_replace(''{id}'', ''<CMSPHP:CACHE>echo $cms_mod[''value''][1];</CMSPHP:CACHE>'', $mod[''intro'']);\r\n	$mod[''intro''] = str_replace(''{tabindex}'', ''<CMSPHP:CACHE>echo $cms_mod[''value''][13];</CMSPHP:CACHE>'', $mod[''intro'']);\r\n	\r\n	$mod[''outro''] = str_replace(''{name}'', htmlspecialchars($con_tree[<CMSPHP:CACHE>echo $cms_mod[''value''][1];</CMSPHP:CACHE>][''name''], ENT_COMPAT, ''UTF-8''), $mod[''outro'']);\r\n	$mod[''outro''] = str_replace(''{desc}'', htmlspecialchars(get_cat_desc(<CMSPHP:CACHE>echo $cms_mod[''value''][1];</CMSPHP:CACHE>), ENT_COMPAT, ''UTF-8''), $mod[''outro'']);\r\n	$mod[''outro''] = str_replace(''{link}'', $con_tree[<CMSPHP:CACHE>echo $cms_mod[''value''][1];</CMSPHP:CACHE>][''link''], $mod[''outro'']);\r\n	$mod[''outro''] = str_replace(''{id}'', ''<CMSPHP:CACHE>echo $cms_mod[''value''][1];</CMSPHP:CACHE>'', $mod[''outro'']);\r\n	$mod[''outro''] = str_replace(''{tabindex}'', $evil_global_variable_for_easy_tabindex_implementation, $mod[''outro'']);\r\n}\r\n\r\n// Navigation ausgeben\r\necho $mod[''intro''] . $mod[''output''] . $mod[''outro''];\r\n\r\n<CMSPHP:CACHE>\r\nif ($cms_mod[''value''][12] != ''true'')\r\n{\r\n	echo ''}'';\r\n}\r\n</CMSPHP:CACHE>\r\n\r\n\r\n\r\n<CMSPHP:CACHE>\r\n//clean routing\r\n$idcatside = $ln_routing[''idcatside''];\r\n$idcat = $ln_routing[''idcat''];\r\n</CMSPHP:CACHE>\r\n\r\n\r\nunset ($mod, $evil_global_variable_for_easy_tabindex_implementation);\r\n\r\n</CMSPHP>\r\n', '', 0, 1, 1, 1153347642, 1177010768, 'mod:cc080bc8e2dbf4cdb277a68dbbad8561:e88ffb4e', '', '', '', 0, '0', NULL, '1');
INSERT INTO `cms_mod` VALUES (14, 'Navigation', '2.01.00', 'Navigation', 'Stellt eine umfangreich konfigurierbare Navigation fr Ordner und Seiten zur Verfgung. Ist primr darauf ausgerichtet, die einzelnen Menpunkte als Textlinks in einer HTML Tabelle zu organisieren.', '<?PHP\r\n// Defaultwerte setzen\r\nif ($cms_mod[''value''][''29''] == '''') $cms_mod[''value''][''29''] = ''simple_mode'';\r\nif ($cms_mod[''value''][''6''] == '''') $cms_mod[''value''][''6''] = ''groupside'';\r\n$mip_form[''1''][''cms_val_default''] = ''Navigation-Ordner'';\r\n$mip_form[''2''][''cms_val_default''] = ''Navigation-Seiten'';\r\n$mip_form[''4''][''cms_val_default''] = ''sortindex'';\r\n$mip_form[''5''][''cms_val_default''] = ''SORT_ASC'';\r\n$mip_form[''7''][''cms_val_default''] = ''autosub'';\r\n$mip_form[''9''][''cms_val_default''] = ''root'';\r\n$mip_form[''10''][''cms_val_default''] = ''<table width="100%" cellspacing="1" cellpadding="0" border="0">'';\r\n$mip_form[''11''][''cms_val_default''] = "<tr><td onMouseOver=\\"this.style[''background'']=''#5A7BAD'';\\" onMouseOut=\\"this.style[''background'']=''#A8BADE'';\\" bgcolor=\\"#A8BADE\\" nowrap>&nbsp;&nbsp;{space}<a href=\\"{link}\\" class=\\"{font1}\\">{name}</a></td></tr>";\r\n$mip_form[''12''][''cms_val_default''] = "<tr><td bgcolor=\\"#5A7BAD\\" nowrap>&nbsp;&nbsp;{space}<a href=\\"{link}\\" class=\\"{font1}\\">{name}</a></td></tr>";\r\n$mip_form[''14''][''cms_val_default''] = "<tr><td onMouseOver=\\"this.style[''background'']=''#5A7BAD'';\\" onMouseOut=\\"this.style[''background'']=''#A8BADE'';\\" bgcolor=\\"#A8BADE\\" nowrap>&nbsp;&nbsp;{space}<a href=\\"{link}\\" class=\\"{font1}\\">{name}</a></td></tr>";\r\n$mip_form[''15''][''cms_val_default''] = "<tr><td bgcolor=\\"#5A7BAD\\" nowrap>&nbsp;&nbsp;{space}<a href=\\"{link}\\" class=\\"{font1}\\">{name}</a></td></tr>";\r\n$mip_form[''17''][''cms_val_default''] = "<tr><td onMouseOver=\\"this.style[''background'']=''#C7D5EB'';\\" onMouseOut=\\"this.style[''background'']=''#DBE3EF'';\\" bgcolor=\\"#DBE3EF\\" nowrap>&nbsp;&nbsp;{space}<a href=\\"{link}\\" class=\\"{font2}\\">{name}</a></td></tr>";\r\n$mip_form[''18''][''cms_val_default''] = "<tr><td bgcolor=\\"#C7D5EB\\" nowrap>&nbsp;&nbsp;{space}<span class=\\"{font2}\\">{name}</span></td></tr>";\r\n$mip_form[''20''][''cms_val_default''] = "</table>";\r\n$mip_form[''21''][''cms_val_default''] = "<tr><td onMouseOver=\\"this.style[''background'']=''#C7D5EB'';\\" onMouseOut=\\"this.style[''background'']=''#DBE3EF'';\\" bgcolor=\\"#DBE3EF\\" nowrap>&nbsp;&nbsp;{space}<a href=\\"{link}\\"class=\\"{font2}\\">{name}</a></td></tr>";\r\n$mip_form[''22''][''cms_val_default''] = "<tr><td bgcolor=\\"#C7D5EB\\" nowrap>&nbsp;&nbsp;{space}<span class=\\"{font2}\\">{name}</span></td></tr>";\r\n$mip_form[''28''][''cms_val_default''] = ''0'';\r\n\r\n// Modus konfigurieren\r\n$mip_form[''29''][''desc''] = ''Konfigurationsmodus: '';\r\n$mip_form[''29''][''cat''] = ''option'';\r\n$mip_form[''29''][''cms_var''] = ''MOD_VAR[29]'';\r\n$mip_form[''29''][''cms_val''] = $cms_mod[''value''][''29''];\r\n$mip_form[''29''][''option_desc''][''0''] = ''einfach'';\r\n$mip_form[''29''][''option_desc''][''1''] = ''erweitert'';\r\n$mip_form[''29''][''option_val''][''0''] = ''simple_mode'';\r\n$mip_form[''29''][''option_val''][''1''] = ''advanced_mode'';\r\n$mip_form[''29''][''flag''] = ''reload'';\r\n\r\n//Struktur zur auswahl der Kategorie\r\n$mip_form[''9''][''desc''] = ''Verzeichnis whlen'';\r\n$mip_form[''9''][''cat''] = ''app_cat'';\r\n$mip_form[''9''][''output_cat''] = ''option'';\r\n$mip_form[''9''][''cms_var''] = ''MOD_VAR[9]'';\r\n$mip_form[''9''][''cms_val''] = $cms_mod[''value''][''9''];\r\n$mip_form[''9''][''size''] = ''5'';\r\n\r\n//Kategorieauswahl Ordner/Seiten\r\n$mip_form[''6''][''desc''] = ''anzeigen von'';\r\n$mip_form[''6''][''cat''] = ''option'';\r\n$mip_form[''6''][''cms_var''] = ''MOD_VAR[6]'';\r\n$mip_form[''6''][''cms_val''] = $cms_mod[''value''][''6''];\r\n$mip_form[''6''][''option_desc''][''0''] = ''nur Ordner'';\r\n$mip_form[''6''][''option_desc''][''1''] = ''Ordner mit Seiten'';\r\n$mip_form[''6''][''option_desc''][''2''] = ''nur Seiten'';\r\n$mip_form[''6''][''option_val''][''0''] = ''group'';\r\n$mip_form[''6''][''option_val''][''1''] = ''groupside'';\r\n$mip_form[''6''][''option_val''][''2''] = ''side'';\r\n$mip_form[''6''][''flag''] = ''reload'';\r\n\r\n//Darstellungsform (Unterordner)\r\nif ($cms_mod[''value''][''6''] != ''side'') {\r\n	$mip_form[''7''][''desc''] = ''Darstellungsform'';\r\n	$mip_form[''7''][''cat''] = ''option'';\r\n	$mip_form[''7''][''cms_var''] = ''MOD_VAR[7]'';\r\n	$mip_form[''7''][''cms_val''] = $cms_mod[''value''][''7''];\r\n	$mip_form[''7''][''option_desc''][''0''] = ''keine Unterordner anzeigen'';\r\n	$mip_form[''7''][''option_desc''][''1''] = ''Unterordner automatisch anzeigen'';\r\n	$mip_form[''7''][''option_desc''][''2''] = ''alle Unterordner anzeigen'';\r\n	$mip_form[''7''][''option_val''][''0''] = ''nosub'';\r\n	$mip_form[''7''][''option_val''][''1''] = ''autosub'';\r\n	$mip_form[''7''][''option_val''][''2''] = ''allsub'';\r\n	if ($cms_mod[''value''][''29''] == ''advanced_mode'') $mip_form[''7''][''flag''] = ''reload'';\r\n\r\n} else {\r\n	$mip_form[''7''][''cat''] = ''hidden'';\r\n	$mip_form[''7''][''cms_var''] = ''MOD_VAR[4]'';\r\n	$mip_form[''7''][''cms_val''] = $cms_mod[''value''][''4''];\r\n}\r\n\r\n//Sortierung der Seiten\r\nif ($cms_mod[''value''][''6''] == ''groupside'' || $cms_mod[''value''][''6''] == ''side'') {\r\n	$mip_form[''4''][''desc''] = ''Seiten sortieren nach'';\r\n	$mip_form[''4''][''cat''] = ''option'';\r\n	$mip_form[''4''][''cms_var''] = ''MOD_VAR[4]'';\r\n	$mip_form[''4''][''cms_val''] = $cms_mod[''value''][''4''];\r\n	$mip_form[''4''][''option_desc''][''0''] = ''Standard (wie backend)'';\r\n	$mip_form[''4''][''option_desc''][''1''] = ''Name'';\r\n	$mip_form[''4''][''option_desc''][''2''] = ''Erstellungsdatum'';\r\n	$mip_form[''4''][''option_desc''][''3''] = ''nderungsdatum'';\r\n	$mip_form[''4''][''option_desc''][''4''] = ''Besucherzahl'';\r\n	$mip_form[''4''][''option_val''][''0''] = ''sortindex'';\r\n	$mip_form[''4''][''option_val''][''1''] = ''name'';\r\n	$mip_form[''4''][''option_val''][''2''] = ''created'';\r\n	$mip_form[''4''][''option_val''][''3''] = ''lastmodified'';\r\n	$mip_form[''4''][''option_val''][''4''] = ''visited'';\r\n\r\n	//aufsteigend-absteigend\r\n	$mip_form[''5''][''cat''] = ''radio'';\r\n	$mip_form[''5''][''cms_var''] = ''MOD_VAR[5]'';\r\n	$mip_form[''5''][''cms_val''] = $cms_mod[''value''][''5''];\r\n	$mip_form[''5''][''option_desc''][''0''] = ''aufsteigend'';\r\n	$mip_form[''5''][''option_val''][''0''] = ''SORT_ASC'';\r\n	$mip_form[''5''][''option_desc''][''1''] = ''absteigend'';\r\n	$mip_form[''5''][''option_val''][''1''] = ''SORT_DESC'';\r\n\r\n	//Mit oder ohne Startseite\r\n	$mip_form[''8''][''desc''] = ''Startseiten anzeigen'';\r\n	$mip_form[''8''][''cat''] = ''chk'';\r\n	$mip_form[''8''][''option_var''][''0''] = ''MOD_VAR[8]'';\r\n	$mip_form[''8''][''option_val''][''0''] = $cms_mod[''value''][''8''];\r\n	$mip_form[''8''][''option_desc''][''0''] = ''ja'';\r\n	$mip_form[''8''][''option_val_select''][''0''] = ''true'';\r\n} else {\r\n	$mip_form[''4''][''cat''] = ''hidden'';\r\n	$mip_form[''4''][''cms_var''] = ''MOD_VAR[4]'';\r\n	$mip_form[''4''][''cms_val''] = $cms_mod[''value''][''4''];\r\n	$mip_form[''5''][''cat''] = ''hidden'';\r\n	$mip_form[''5''][''cms_var''] = ''MOD_VAR[5]'';\r\n	$mip_form[''5''][''cms_val''] = $cms_mod[''value''][''5''];\r\n	$mip_form[''8''][''cat''] = ''hidden'';\r\n	$mip_form[''8''][''cms_var''] = ''MOD_VAR[8]'';\r\n	$mip_form[''8''][''cms_val''] = $cms_mod[''value''][''8''];\r\n}\r\n\r\n// Advanced-Mode\r\nif ($cms_mod[''value''][''29''] == ''advanced_mode'') {\r\n\r\n	// Ordner ausschliessen\r\n	if ($cms_mod[''value''][''6''] != ''side'') {\r\n\r\n		// Navigation template connav_fcat\r\n		$mip_form[''11''][''cat''] = ''txtarea'';\r\n		$mip_form[''11''][''type''] = ''long'';\r\n		$mip_form[''11''][''rows''] = ''3'';\r\n		$mip_form[''11''][''desc''] = ''Layout der Ordner in der 1. Ebene <br><small>Mgliche Templatevariablen: {space}, {link}, {name} ({s_name} Sonderzeichen!), {id}, {font1}{font2}{font3}</small>'';\r\n		$mip_form[''11''][''cms_var''] = ''MOD_VAR[11]'';\r\n		$mip_form[''11''][''cms_val''] = $cms_mod[''value''][''11''];\r\n\r\n		// Navigation template connav_fcat_act\r\n		$mip_form[''12''][''cat''] = ''txtarea'';\r\n		$mip_form[''12''][''type''] = ''long'';\r\n		$mip_form[''12''][''rows''] = ''3'';\r\n		$mip_form[''12''][''desc''] = ''Layout des aktiven Ordners der 1. Ebene <br><small>Mgliche Templatevariablen: {space}, {link}, {name} ({s_name} Sonderzeichen!), {id}, {font1}{font2}{font3}</small>'';\r\n		$mip_form[''12''][''cms_var''] = ''MOD_VAR[12]'';\r\n		$mip_form[''12''][''cms_val''] = $cms_mod[''value''][''12''];\r\n\r\n		// Navigation template connav_fcat_int\r\n		$mip_form[''13''][''cat''] = ''txtarea'';\r\n		$mip_form[''13''][''type''] = ''long'';\r\n		$mip_form[''13''][''rows''] = ''3'';\r\n		$mip_form[''13''][''desc''] = ''Layout zwischen Ordnern der 1. Ebene'';\r\n		$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n		$mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n\r\n		if ($cms_mod[''value''][''7''] != ''nosub'') {\r\n			$mip_form[''25''][''cat''] = ''txt'';\r\n			$mip_form[''25''][''type''] = '''';\r\n			$mip_form[''25''][''desc''] = ''Ordner ausschliessen <small>(idcat kommasepariert angeben)</small>'';\r\n			$mip_form[''25''][''cms_var''] = ''MOD_VAR[25]'';\r\n			$mip_form[''25''][''cms_val''] = $cms_mod[''value''][''25''];\r\n\r\n			// Anzahl Ebenen\r\n			$mip_form[''28''][''desc''] = ''Anzahl darzustellender Ebenen'';\r\n			$mip_form[''28''][''cat''] = ''option'';\r\n			$mip_form[''28''][''cms_var''] = ''MOD_VAR[28]'';\r\n			$mip_form[''28''][''cms_val''] = $cms_mod[''value''][''28''];\r\n			$mip_form[''28''][''option_desc''][''0''] = ''alle'';\r\n			$mip_form[''28''][''option_desc''][''1''] = ''2'';\r\n			$mip_form[''28''][''option_desc''][''2''] = ''3'';\r\n			$mip_form[''28''][''option_desc''][''3''] = ''4'';\r\n			$mip_form[''28''][''option_desc''][''4''] = ''5'';\r\n			$mip_form[''28''][''option_desc''][''5''] = ''6'';\r\n			$mip_form[''28''][''option_desc''][''6''] = ''7'';\r\n			$mip_form[''28''][''option_desc''][''7''] = ''8'';\r\n			$mip_form[''28''][''option_desc''][''8''] = ''9'';\r\n			$mip_form[''28''][''option_desc''][''9''] = ''10'';\r\n			$mip_form[''28''][''option_val''][''0''] = ''0'';\r\n			$mip_form[''28''][''option_val''][''1''] = ''2'';\r\n			$mip_form[''28''][''option_val''][''2''] = ''3'';\r\n			$mip_form[''28''][''option_val''][''3''] = ''4'';\r\n			$mip_form[''28''][''option_val''][''4''] = ''5'';\r\n			$mip_form[''28''][''option_val''][''5''] = ''6'';\r\n			$mip_form[''28''][''option_val''][''6''] = ''7'';\r\n			$mip_form[''28''][''option_val''][''7''] = ''8'';\r\n			$mip_form[''28''][''option_val''][''8''] = ''9'';\r\n			$mip_form[''28''][''option_val''][''9''] = ''10'';\r\n\r\n			//Pfad als aktiv verfolgen\r\n			$mip_form[''30''][''desc''] = ''Pfad als aktiv verfolgen'';\r\n			$mip_form[''30''][''cat''] = ''chk'';\r\n			$mip_form[''30''][''option_var''][''0''] = ''MOD_VAR[30]'';\r\n			$mip_form[''30''][''option_val''][''0''] = $cms_mod[''value''][''30''];\r\n			$mip_form[''30''][''option_desc''][''0''] = ''ja'';\r\n			$mip_form[''30''][''option_val_select''][''0''] = ''true'';\r\n\r\n			if ($cms_mod[''value''][''6''] != ''side'') {			\r\n			//Pfad als aktiv verfolgen\r\n			$mip_form[''31''][''desc''] = ''Startseite bei {page_count} mitzhlen?'';\r\n			$mip_form[''31''][''cat''] = ''chk'';\r\n			$mip_form[''31''][''option_var''][''0''] = ''MOD_VAR[31]'';\r\n			$mip_form[''31''][''option_val''][''0''] = $cms_mod[''value''][''31''];\r\n			$mip_form[''31''][''option_desc''][''0''] = ''ja'';\r\n			$mip_form[''31''][''option_val_select''][''0''] = ''true''; }\r\n\r\n			// Template Ebenenwechsel tiefer\r\n			$mip_form[''26''][''cat''] = ''txtarea'';\r\n			$mip_form[''26''][''type''] = ''long'';\r\n			$mip_form[''26''][''rows''] = ''3'';\r\n			$mip_form[''26''][''desc''] = ''Layout beim Wechsel in tiefere Ebene'';\r\n			$mip_form[''26''][''cms_var''] = ''MOD_VAR[26]'';\r\n			$mip_form[''26''][''cms_val''] = $cms_mod[''value''][''26''];\r\n\r\n			// Template Ebenenwechsel hoeher\r\n			$mip_form[''27''][''cat''] = ''txtarea'';\r\n			$mip_form[''27''][''type''] = ''long'';\r\n			$mip_form[''27''][''rows''] = ''3'';\r\n			$mip_form[''27''][''desc''] = ''Layout beim Wechsel in hoehere Ebene'';\r\n			$mip_form[''27''][''cms_var''] = ''MOD_VAR[27]'';\r\n			$mip_form[''27''][''cms_val''] = $cms_mod[''value''][''27''];\r\n\r\n			// Navigation template connav_cat\r\n			$mip_form[''14''][''cat''] = ''txtarea'';\r\n			$mip_form[''14''][''type''] = ''long'';\r\n			$mip_form[''14''][''rows''] = ''3'';\r\n			$mip_form[''14''][''desc''] = ''Layout der Ordner <br><small>Mgliche Templatevariablen: {space}, {link}, {name} ({s_name} Sonderzeichen!), {id}, {page_count}, {font1}{font2}{font3}</small>'';\r\n			$mip_form[''14''][''cms_var''] = ''MOD_VAR[14]'';\r\n			$mip_form[''14''][''cms_val''] = $cms_mod[''value''][''14''];\r\n\r\n			// Navigation template connav_cat_act\r\n			$mip_form[''15''][''cat''] = ''txtarea'';\r\n			$mip_form[''15''][''type''] = ''long'';\r\n			$mip_form[''15''][''rows''] = ''3'';\r\n			$mip_form[''15''][''desc''] = ''Layout des aktiven Ordners <br><small>Mgliche Templatevariablen: {space}, {link}, {name} ({s_name} Sonderzeichen!), {page_count}, {id}, {font1}{font2}{font3}</small>'';\r\n			$mip_form[''15''][''cms_var''] = ''MOD_VAR[15]'';\r\n			$mip_form[''15''][''cms_val''] = $cms_mod[''value''][''15''];\r\n\r\n			// Navigation template connav_cat_int\r\n			$mip_form[''16''][''cat''] = ''txtarea'';\r\n			$mip_form[''16''][''type''] = ''long'';\r\n			$mip_form[''16''][''rows''] = ''3'';\r\n			$mip_form[''16''][''desc''] = ''Layout zwischen den Ordner'';\r\n			$mip_form[''16''][''cms_var''] = ''MOD_VAR[16]'';\r\n			$mip_form[''16''][''cms_val''] = $cms_mod[''value''][''16''];\r\n\r\n			if ($cms_mod[''value''][''6''] == ''groupside'') {\r\n\r\n				// Navigation template connav_side\r\n				$mip_form[''17''][''cat''] = ''txtarea'';\r\n				$mip_form[''17''][''type''] = ''long'';\r\n				$mip_form[''17''][''rows''] = ''3'';\r\n				$mip_form[''17''][''desc''] = ''Layout der Seiten <br><small>Mgliche Templatevariablen: {space}, {link}, {name} ({s_name} Sonderzeichen!), {id}, {font1}{font2}{font3}</small>'';\r\n				$mip_form[''17''][''cms_var''] = ''MOD_VAR[17]'';\r\n				$mip_form[''17''][''cms_val''] = $cms_mod[''value''][''17''];\r\n\r\n				// Navigation template connav_side_act\r\n				$mip_form[''18''][''cat''] = ''txtarea'';\r\n				$mip_form[''18''][''type''] = ''long'';\r\n				$mip_form[''18''][''rows''] = ''3'';\r\n				$mip_form[''18''][''desc''] = ''Layout der aktuellen Seite <br><small>Mgliche Templatevariablen: {space}, {link}, {name} ({s_name} Sonderzeichen!), {id}, {font1}{font2}{font3}</small>'';\r\n				$mip_form[''18''][''cms_var''] = ''MOD_VAR[18]'';\r\n				$mip_form[''18''][''cms_val''] = $cms_mod[''value''][''18''];\r\n\r\n				// Navigation template connav_side_int\r\n				$mip_form[''19''][''cat''] = ''txtarea'';\r\n				$mip_form[''19''][''type''] = ''long'';\r\n				$mip_form[''19''][''rows''] = ''3'';\r\n				$mip_form[''19''][''desc''] = ''Layout zwischen den Seiten'';\r\n				$mip_form[''19''][''cms_var''] = ''MOD_VAR[19]'';\r\n				$mip_form[''19''][''cms_val''] = $cms_mod[''value''][''19''];\r\n			} else {\r\n				$mip_form[''17''][''cat''] = ''hidden'';\r\n				$mip_form[''17''][''cms_var''] = ''MOD_VAR[17]'';\r\n				$mip_form[''17''][''cms_val''] = $cms_mod[''value''][''17''];\r\n				$mip_form[''18''][''cat''] = ''hidden'';\r\n				$mip_form[''18''][''cms_var''] = ''MOD_VAR[18]'';\r\n				$mip_form[''18''][''cms_val''] = $cms_mod[''value''][''18''];\r\n				$mip_form[''19''][''cat''] = ''hidden'';\r\n				$mip_form[''19''][''cms_var''] = ''MOD_VAR[19]'';\r\n				$mip_form[''19''][''cms_val''] = $cms_mod[''value''][''19''];\r\n                         }\r\n                 } else {\r\n			$mip_form[''25''][''cat''] = ''hidden'';\r\n			$mip_form[''25''][''cms_var''] = ''MOD_VAR[25]'';\r\n			$mip_form[''25''][''cms_val''] = $cms_mod[''value''][''25''];\r\n			$mip_form[''28''][''cat''] = ''hidden'';\r\n			$mip_form[''28''][''cms_var''] = ''MOD_VAR[28]'';\r\n			$mip_form[''28''][''cms_val''] = $cms_mod[''value''][''28''];\r\n			$mip_form[''30''][''cat''] = ''hidden'';\r\n			$mip_form[''30''][''cms_var''] = ''MOD_VAR[30]'';\r\n			$mip_form[''30''][''cms_val''] = $cms_mod[''value''][''30''];\r\n			$mip_form[''31''][''cat''] = ''hidden'';\r\n			$mip_form[''31''][''cms_var''] = ''MOD_VAR[31]'';\r\n			$mip_form[''31''][''cms_val''] = $cms_mod[''value''][''31''];\r\n			$mip_form[''26''][''cat''] = ''hidden'';\r\n			$mip_form[''26''][''cms_var''] = ''MOD_VAR[26]'';\r\n			$mip_form[''26''][''cms_val''] = $cms_mod[''value''][''26''];\r\n			$mip_form[''27''][''cat''] = ''hidden'';\r\n			$mip_form[''27''][''cms_var''] = ''MOD_VAR[27]'';\r\n			$mip_form[''27''][''cms_val''] = $cms_mod[''value''][''27''];\r\n			$mip_form[''14''][''cat''] = ''hidden'';\r\n			$mip_form[''14''][''cms_var''] = ''MOD_VAR[14]'';\r\n			$mip_form[''14''][''cms_val''] = $cms_mod[''value''][''14''];\r\n			$mip_form[''15''][''cat''] = ''hidden'';\r\n			$mip_form[''15''][''cms_var''] = ''MOD_VAR[15]'';\r\n			$mip_form[''15''][''cms_val''] = $cms_mod[''value''][''15''];\r\n			$mip_form[''16''][''cat''] = ''hidden'';\r\n			$mip_form[''16''][''cms_var''] = ''MOD_VAR[16]'';\r\n			$mip_form[''16''][''cms_val''] = $cms_mod[''value''][''16''];\r\n			$mip_form[''17''][''cat''] = ''hidden'';\r\n			$mip_form[''17''][''cms_var''] = ''MOD_VAR[17]'';\r\n			$mip_form[''17''][''cms_val''] = $cms_mod[''value''][''17''];\r\n			$mip_form[''18''][''cat''] = ''hidden'';\r\n			$mip_form[''18''][''cms_var''] = ''MOD_VAR[18]'';\r\n			$mip_form[''18''][''cms_val''] = $cms_mod[''value''][''18''];\r\n			$mip_form[''19''][''cat''] = ''hidden'';\r\n			$mip_form[''19''][''cms_var''] = ''MOD_VAR[19]'';\r\n			$mip_form[''19''][''cms_val''] = $cms_mod[''value''][''19''];\r\n                 }\r\n	} else {\r\n		$mip_form[''11''][''cat''] = ''hidden'';\r\n		$mip_form[''11''][''cms_var''] = ''MOD_VAR[11]'';\r\n		$mip_form[''11''][''cms_val''] = $cms_mod[''value''][''11''];\r\n		$mip_form[''12''][''cat''] = ''hidden'';\r\n		$mip_form[''12''][''cms_var''] = ''MOD_VAR[12]'';\r\n		$mip_form[''12''][''cms_val''] = $cms_mod[''value''][''12''];\r\n		$mip_form[''13''][''cat''] = ''hidden'';\r\n		$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n		$mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n		$mip_form[''25''][''cat''] = ''hidden'';\r\n		$mip_form[''25''][''cms_var''] = ''MOD_VAR[25]'';\r\n		$mip_form[''25''][''cms_val''] = $cms_mod[''value''][''25''];\r\n		$mip_form[''28''][''cat''] = ''hidden'';\r\n		$mip_form[''28''][''cms_var''] = ''MOD_VAR[28]'';\r\n		$mip_form[''28''][''cms_val''] = $cms_mod[''value''][''28''];\r\n		$mip_form[''30''][''cat''] = ''hidden'';\r\n		$mip_form[''30''][''cms_var''] = ''MOD_VAR[30]'';\r\n		$mip_form[''30''][''cms_val''] = $cms_mod[''value''][''30''];\r\n		$mip_form[''31''][''cat''] = ''hidden'';\r\n		$mip_form[''31''][''cms_var''] = ''MOD_VAR[31]'';\r\n		$mip_form[''31''][''cms_val''] = $cms_mod[''value''][''31''];\r\n		$mip_form[''26''][''cat''] = ''hidden'';\r\n		$mip_form[''26''][''cms_var''] = ''MOD_VAR[26]'';\r\n		$mip_form[''26''][''cms_val''] = $cms_mod[''value''][''26''];\r\n		$mip_form[''27''][''cat''] = ''hidden'';\r\n		$mip_form[''27''][''cms_var''] = ''MOD_VAR[27]'';\r\n		$mip_form[''27''][''cms_val''] = $cms_mod[''value''][''27''];\r\n		$mip_form[''14''][''cat''] = ''hidden'';\r\n		$mip_form[''14''][''cms_var''] = ''MOD_VAR[14]'';\r\n		$mip_form[''14''][''cms_val''] = $cms_mod[''value''][''14''];\r\n		$mip_form[''15''][''cat''] = ''hidden'';\r\n		$mip_form[''15''][''cms_var''] = ''MOD_VAR[15]'';\r\n		$mip_form[''15''][''cms_val''] = $cms_mod[''value''][''15''];\r\n		$mip_form[''16''][''cat''] = ''hidden'';\r\n		$mip_form[''16''][''cms_var''] = ''MOD_VAR[16]'';\r\n		$mip_form[''16''][''cms_val''] = $cms_mod[''value''][''16''];\r\n		$mip_form[''17''][''cat''] = ''hidden'';\r\n		$mip_form[''17''][''cms_var''] = ''MOD_VAR[17]'';\r\n		$mip_form[''17''][''cms_val''] = $cms_mod[''value''][''17''];\r\n		$mip_form[''18''][''cat''] = ''hidden'';\r\n		$mip_form[''18''][''cms_var''] = ''MOD_VAR[18]'';\r\n		$mip_form[''18''][''cms_val''] = $cms_mod[''value''][''18''];\r\n		$mip_form[''19''][''cat''] = ''hidden'';\r\n		$mip_form[''19''][''cms_var''] = ''MOD_VAR[19]'';\r\n		$mip_form[''19''][''cms_val''] = $cms_mod[''value''][''19''];\r\n         }\r\n\r\n	// Seiten ausschliessen\r\n	if ($cms_mod[''value''][''6''] == ''groupside'' || $cms_mod[''value''][''6''] == ''side'') {\r\n		$mip_form[''24''][''cat''] = ''txt'';\r\n		$mip_form[''24''][''desc''] = ''Seiten ausschliessen <small>(idcatsides kommasepariert angeben)</small>'';\r\n		$mip_form[''24''][''cms_var''] = ''MOD_VAR[24]'';\r\n		$mip_form[''24''][''cms_val''] = $cms_mod[''value''][''24''];\r\n\r\n		// Navigation template connav_fside\r\n		$mip_form[''21''][''cat''] = ''txtarea'';\r\n		$mip_form[''21''][''type''] = ''long'';\r\n		$mip_form[''21''][''rows''] = ''3'';\r\n		$mip_form[''21''][''desc''] = ''Layout der Seiten in der 1. Ebene<br><small>Mgliche Templatevariablen: {space}, {link}, {name} ({s_name} Sonderzeichen!), {id}, {font1}{font2}{font3}</small>'';\r\n		$mip_form[''21''][''cms_var''] = ''MOD_VAR[21]'';\r\n		$mip_form[''21''][''cms_val''] = $cms_mod[''value''][''21''];\r\n\r\n		// Navigation template connav_fside_act\r\n		$mip_form[''22''][''cat''] = ''txtarea'';\r\n		$mip_form[''22''][''type''] = ''long'';\r\n		$mip_form[''22''][''rows''] = ''3'';\r\n		$mip_form[''22''][''desc''] = ''Layout der aktuellen Seite in der 1. Ebene<br><small>Mgliche Templatevariablen: {space}, {link}, {name} ({s_name} Sonderzeichen!), {id}, {font1}{font2}{font3}</small>'';\r\n		$mip_form[''22''][''cms_var''] = ''MOD_VAR[22]'';\r\n		$mip_form[''22''][''cms_val''] = $cms_mod[''value''][''22''];\r\n\r\n		// Navigation template connav_fside_int\r\n		$mip_form[''23''][''cat''] = ''txtarea'';\r\n		$mip_form[''23''][''type''] = ''long'';\r\n		$mip_form[''23''][''rows''] = ''3'';\r\n		$mip_form[''23''][''desc''] = ''Layout zwischen den Seiten in der 1. Ebene'';\r\n		$mip_form[''23''][''cms_var''] = ''MOD_VAR[23]'';\r\n		$mip_form[''23''][''cms_val''] = $cms_mod[''value''][''23''];\r\n	} else {\r\n		$mip_form[''24''][''cat''] = ''hidden'';\r\n		$mip_form[''24''][''cms_var''] = ''MOD_VAR[24]'';\r\n		$mip_form[''24''][''cms_val''] = $cms_mod[''value''][''24''];\r\n		$mip_form[''21''][''cat''] = ''hidden'';\r\n		$mip_form[''21''][''cms_var''] = ''MOD_VAR[21]'';\r\n		$mip_form[''21''][''cms_val''] = $cms_mod[''value''][''21''];\r\n		$mip_form[''22''][''cat''] = ''hidden'';\r\n		$mip_form[''22''][''cms_var''] = ''MOD_VAR[22]'';\r\n		$mip_form[''22''][''cms_val''] = $cms_mod[''value''][''22''];\r\n		$mip_form[''23''][''cat''] = ''hidden'';\r\n		$mip_form[''23''][''cms_var''] = ''MOD_VAR[23]'';\r\n		$mip_form[''23''][''cms_val''] = $cms_mod[''value''][''23''];\r\n         }\r\n\r\n	//Schriftart 1\r\n	$mip_form[''1''][''desc''] = $mod_lang[''gen_font'']." {font1}";\r\n	$mip_form[''1''][''cat''] = ''app_css'';\r\n	$mip_form[''1''][''output_cat''] = ''option'';\r\n	$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n	$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n\r\n	//Schriftart 2\r\n	$mip_form[''2''][''desc''] = $mod_lang[''gen_font'']." {font2}";\r\n	$mip_form[''2''][''cat''] = ''app_css'';\r\n	$mip_form[''2''][''output_cat''] = ''option'';\r\n	$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n	$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n\r\n	//Schriftart 3\r\n	$mip_form[''3''][''desc''] = $mod_lang[''gen_font'']." {font3}";\r\n	$mip_form[''3''][''cat''] = ''app_css'';\r\n	$mip_form[''3''][''output_cat''] = ''option'';\r\n	$mip_form[''3''][''cms_var''] = ''MOD_VAR[3]'';\r\n	$mip_form[''3''][''cms_val''] = $cms_mod[''value''][''3''];\r\n\r\n	// Navigation template connav_pre\r\n	$mip_form[''10''][''cat''] = ''txtarea'';\r\n	$mip_form[''10''][''type''] = ''long'';\r\n	$mip_form[''10''][''rows''] = ''3'';\r\n	$mip_form[''10''][''desc''] = ''Einleitung der Navigation'';\r\n	$mip_form[''10''][''cms_var''] = ''MOD_VAR[10]'';\r\n	$mip_form[''10''][''cms_val''] = $cms_mod[''value''][''10''];\r\n\r\n	// Navigation template connav_post\r\n	$mip_form[''20''][''cat''] = ''txtarea'';\r\n	$mip_form[''20''][''type''] = ''long'';\r\n	$mip_form[''20''][''rows''] = ''3'';\r\n	$mip_form[''20''][''desc''] = ''Ende der Navigation'';\r\n	$mip_form[''20''][''cms_var''] = ''MOD_VAR[20]'';\r\n	$mip_form[''20''][''cms_val''] = $cms_mod[''value''][''20''];\r\n\r\n// Simple-Mode\r\n} else {\r\n\r\n	// Navigation template connav_fcat\r\n	$mip_form[''11''][''cat''] = ''hidden'';\r\n	$mip_form[''11''][''cms_var''] = ''MOD_VAR[11]'';\r\n	$mip_form[''11''][''cms_val''] = $cms_mod[''value''][''11''];\r\n\r\n	// Navigation template connav_fcat_act\r\n	$mip_form[''12''][''cat''] = ''hidden'';\r\n	$mip_form[''12''][''cms_var''] = ''MOD_VAR[12]'';\r\n	$mip_form[''12''][''cms_val''] = $cms_mod[''value''][''12''];\r\n\r\n	// Navigation template connav_fcat_int\r\n	$mip_form[''13''][''cat''] = ''hidden'';\r\n	$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n	$mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n\r\n	// Navigation template connav_cat\r\n	$mip_form[''14''][''cat''] = ''hidden'';\r\n	$mip_form[''14''][''cms_var''] = ''MOD_VAR[14]'';\r\n	$mip_form[''14''][''cms_val''] = $cms_mod[''value''][''14''];\r\n\r\n	// Navigation template connav_cat_act\r\n	$mip_form[''15''][''cat''] = ''hidden'';\r\n	$mip_form[''15''][''cms_var''] = ''MOD_VAR[15]'';\r\n	$mip_form[''15''][''cms_val''] = $cms_mod[''value''][''15''];\r\n\r\n	// Navigation template connav_cat_int\r\n	$mip_form[''16''][''cat''] = ''hidden'';\r\n	$mip_form[''16''][''cms_var''] = ''MOD_VAR[16]'';\r\n	$mip_form[''16''][''cms_val''] = $cms_mod[''value''][''16''];\r\n\r\n	// Navigation template connav_side\r\n	$mip_form[''17''][''cat''] = ''hidden'';\r\n	$mip_form[''17''][''cms_var''] = ''MOD_VAR[17]'';\r\n	$mip_form[''17''][''cms_val''] = $cms_mod[''value''][''17''];\r\n\r\n	// Navigation template connav_side_act\r\n	$mip_form[''18''][''cat''] = ''hidden'';\r\n	$mip_form[''18''][''cms_var''] = ''MOD_VAR[18]'';\r\n	$mip_form[''18''][''cms_val''] = $cms_mod[''value''][''18''];\r\n\r\n	// Navigation template connav_side_int\r\n	$mip_form[''19''][''cat''] = ''hidden'';\r\n	$mip_form[''19''][''cms_var''] = ''MOD_VAR[19]'';\r\n	$mip_form[''19''][''cms_val''] = $cms_mod[''value''][''19''];\r\n\r\n	//Pfad als aktiv verfolgen\r\n	$mip_form[''30''][''cat''] = ''hidden'';\r\n	$mip_form[''30''][''cms_var''] = ''MOD_VAR[30]'';\r\n	$mip_form[''30''][''cms_val''] = $cms_mod[''value''][''30''];\r\n\r\n	//Pfad als aktiv verfolgen\r\n	$mip_form[''31''][''cat''] = ''hidden'';\r\n	$mip_form[''31''][''cms_var''] = ''MOD_VAR[31]'';\r\n	$mip_form[''31''][''cms_val''] = $cms_mod[''value''][''31''];\r\n\r\n	// Anzahl Ebenen\r\n	$mip_form[''28''][''cat''] = ''hidden'';\r\n	$mip_form[''28''][''cms_var''] = ''MOD_VAR[28]'';\r\n	$mip_form[''28''][''cms_val''] = $cms_mod[''value''][''28''];\r\n\r\n	// Ordner ausschliessen\r\n	$mip_form[''25''][''cat''] = ''hidden'';\r\n	$mip_form[''25''][''cms_var''] = ''MOD_VAR[25]'';\r\n	$mip_form[''25''][''cms_val''] = $cms_mod[''value''][''25''];\r\n\r\n	// Seiten ausschliessen\r\n	$mip_form[''24''][''cat''] = ''hidden'';\r\n	$mip_form[''24''][''cms_var''] = ''MOD_VAR[24]'';\r\n	$mip_form[''24''][''cms_val''] = $cms_mod[''value''][''24''];\r\n\r\n	// Navigation template connav_fside\r\n	$mip_form[''21''][''cat''] = ''hidden'';\r\n	$mip_form[''21''][''cms_var''] = ''MOD_VAR[21]'';\r\n	$mip_form[''21''][''cms_val''] = $cms_mod[''value''][''21''];\r\n\r\n	// Navigation template connav_fside_act\r\n	$mip_form[''22''][''cat''] = ''hidden'';\r\n	$mip_form[''22''][''cms_var''] = ''MOD_VAR[22]'';\r\n	$mip_form[''22''][''cms_val''] = $cms_mod[''value''][''22''];\r\n\r\n	// Navigation template connav_fside_int\r\n	$mip_form[''23''][''cat''] = ''hidden'';\r\n	$mip_form[''23''][''cms_var''] = ''MOD_VAR[23]'';\r\n	$mip_form[''23''][''cms_val''] = $cms_mod[''value''][''23''];\r\n\r\n	//Schriftart 1\r\n	$mip_form[''1''][''cat''] = ''hidden'';\r\n	$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n	$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n\r\n	//Schriftart 2\r\n	$mip_form[''2''][''cat''] = ''hidden'';\r\n	$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n	$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n\r\n	//Schriftart 3\r\n	$mip_form[''3''][''cat''] = ''hidden'';\r\n	$mip_form[''3''][''cms_var''] = ''MOD_VAR[3]'';\r\n	$mip_form[''3''][''cms_val''] = $cms_mod[''value''][''3''];\r\n\r\n	// Template Ebenenwechsel tiefer\r\n	$mip_form[''26''][''cat''] = ''hidden'';\r\n	$mip_form[''26''][''cms_var''] = ''MOD_VAR[26]'';\r\n	$mip_form[''26''][''cms_val''] = $cms_mod[''value''][''26''];\r\n\r\n	// Template Ebenenwechsel hoeher\r\n	$mip_form[''27''][''cat''] = ''hidden'';\r\n	$mip_form[''27''][''cms_var''] = ''MOD_VAR[27]'';\r\n	$mip_form[''27''][''cms_val''] = $cms_mod[''value''][''27''];\r\n\r\n	// Navigation template connav_pre\r\n	$mip_form[''10''][''cat''] = ''hidden'';\r\n	$mip_form[''10''][''cms_var''] = ''MOD_VAR[10]'';\r\n	$mip_form[''10''][''cms_val''] = $cms_mod[''value''][''10''];\r\n\r\n	// Navigation template connav_post\r\n	$mip_form[''20''][''cat''] = ''hidden'';\r\n	$mip_form[''20''][''cms_var''] = ''MOD_VAR[20]'';\r\n	$mip_form[''20''][''cms_val''] = $cms_mod[''value''][''20''];\r\n}\r\n\r\nmip_formsp($mip_form[''29'']);\r\nmip_formsp($mip_form[''9'']);\r\nmip_formsp($mip_form[''6'']);\r\nmip_formsp($mip_form[''7'']);\r\nmip_formsp($mip_form[''8'']);\r\nmip_formsp($mip_form[''4'']);\r\nmip_formsp($mip_form[''5'']);\r\nif ($cms_mod[''value''][''29''] == ''advanced_mode'') echo ''<hr>'';\r\nmip_formsp($mip_form[''28'']);\r\nmip_formsp($mip_form[''30'']);\r\nmip_formsp($mip_form[''31'']);\r\nmip_formsp($mip_form[''25'']);\r\nmip_formsp($mip_form[''24'']);\r\nif ($cms_mod[''value''][''29''] == ''advanced_mode'' && $cms_mod[''value''][''7''] != ''group'' && $cms_mod[''value''][''7''] != ''nosub'') echo ''<br>'';\r\nmip_formsp($mip_form[''1'']);\r\nmip_formsp($mip_form[''2'']);\r\nmip_formsp($mip_form[''3'']);\r\nif ($cms_mod[''value''][''29''] == ''advanced_mode'') echo "<br><b>Templates:</b><br><br>";\r\nmip_formsp($mip_form[''10'']);\r\nmip_formsp($mip_form[''11'']);\r\nmip_formsp($mip_form[''12'']);\r\nmip_formsp($mip_form[''13'']);\r\nmip_formsp($mip_form[''21'']);\r\nmip_formsp($mip_form[''22'']);\r\nmip_formsp($mip_form[''23'']);\r\nmip_formsp($mip_form[''26'']);\r\nmip_formsp($mip_form[''27'']);\r\nmip_formsp($mip_form[''14'']);\r\nmip_formsp($mip_form[''15'']);\r\nmip_formsp($mip_form[''16'']);\r\nmip_formsp($mip_form[''17'']);\r\nmip_formsp($mip_form[''18'']);\r\nmip_formsp($mip_form[''19'']);\r\nmip_formsp($mip_form[''20'']);\r\nunset($mip_form);\r\n?>', '<CMSPHP:CACHE>\r\n// (c) 2004 - 2005  Bjrn Brockmann\r\n// needs PHP 4.1+\r\n\r\n//Alle Variablen, die nur innerhalb des gecachten PHPs sichtbar sind, auch fr dynamisches PHP zur Verfgung stellen\r\necho ''<CMSPHP>'';\r\nif (is_array($cms_mod[''value''])) {\r\nforeach($cms_mod[''value''] AS $k => $v){\r\n	echo ''$cms_mod[\\''value\\'']["''.$k.''"] = "''. addslashes($v) .''";''."\\n";\r\n}}\r\necho ''</CMSPHP>'';\r\n</CMSPHP:CACHE>\r\n\r\n<CMSPHP>\r\necho "MOD_VALUE[31]";\r\n\r\n// INITIALISIERUNG\r\necho $cms_mod[''value''][''10''];\r\n\r\n\r\nif(! function_exists(''nav_cat_is_in_tree'') ){\r\nfunction nav_cat_is_in_tree( $cat, $start ){\r\n	global $con_tree;\r\n	\r\n	//echo "$cat, $start";return false;\r\n	if(empty($cat) || empty($start) )\r\n		return false;\r\n		\r\n	if($cat == $start)\r\n		return true;\r\n\r\n	while($cat != $start || ! empty($cat) ) {\r\n		$cat = $con_tree[ $cat ][''parent''];\r\n		if($cat == $start)\r\n			return true;\r\n		if($cat == ''0'') break;\r\n	}\r\n	return false;\r\n}}\r\n\r\n\r\nif($cms_mod[''value''][''9''] == ''root'') {\r\n	$mod[''startpt''] = ''0'';\r\n	$mod[''level''] = 1;\r\n} elseif($cms_mod[''value''][''9''] == ''this'') {\r\n	$mod[''startpt''] = $idcat;\r\n	$mod[''level''] = 2;\r\n} else {\r\n	$mod[''startpt''] = $cms_mod[''value''][''9''];\r\n	$mod[''level''] = 2;\r\n}\r\n\r\n$mod[''startlevel''] = $catlist_level[ $mod[''startpt''] ];\r\n\r\n// OFFENEN PFAD FINDEN\r\nif($cms_mod[''value''][''7''] != ''nosub'') {\r\n	$a = $idcat;\r\n	$mod[''path''] = array();\r\n	while($a != $mod[''startpt''] && $catlist_level[$a] > $mod[''startlevel'']) {\r\n		array_push($mod[''path''],$a);\r\n		$a = $con_tree[$a][''parent''];\r\n	}\r\n	array_push($mod[''path''],$mod[''startpt'']);\r\n} else {\r\n	$mod[''path''] = array($mod[''startpt'']);\r\n}\r\n\r\n// ORDNERLISTE VORBEREITEN\r\nif($mod[''startpt''] == ''0'') {\r\n	$mod[''temp''] = ''start'';\r\n} else {\r\n	$mod[''temp''] = '''';\r\n}\r\n\r\n$mod[''catlist_temp''] = array();\r\n$mod[''tmplvl''] = ''-'';\r\nforeach ($catlist as $a){\r\n	switch ($cms_mod[''value''][''7'']) {\r\n		case ''nosub'' :\r\n			if ($con_tree[$a][''parent''] == $mod[''startpt''] && !strstr(",MOD_VALUE[25],",",$a,")) { \r\n				array_push($mod[''catlist_temp''],$a); \r\n			};\r\n			break;\r\n		case ''allsub'' :\r\n			if($a == $mod[''startpt'']){\r\n				$mod[''temp''] = `start`;\r\n			} elseif ($mod[''temp''] != "stop" && $catlist_level[$a] <= $mod[''startlevel'']){\r\n				$mod[''temp''] = "stop";\r\n			} elseif ($mod[''temp''] == `start` && strstr(",MOD_VALUE[25],",",$a,")){\r\n				$mod[''temp''] = "wait";\r\n				$mod[''tmplvl''] = $catlist_level[$a];\r\n			} elseif ($mod[''temp''] == `start` && "MOD_VALUE[28]" > 0 && $catlist_level[$a] >= ("MOD_VALUE[28]"+$mod[''startlevel''])){\r\n				$mod[''temp''] = "level";\r\n				$mod[''tmplvl''] = $catlist_level[$a];\r\n			} elseif ($mod[''temp''] == "wait" && $mod[''tmplvl''] != "-" && $catlist_level[$a] <= $mod[''tmplvl'']){\r\n				$mod[''temp''] = `start`;\r\n				$mod[''tmplvl''] = "-";\r\n				array_push($mod[''catlist_temp''],$a);\r\n			} elseif ($mod[''temp''] == "level" && $mod[''tmplvl''] != "-" && $catlist_level[$a] < $mod[''tmplvl'']){\r\n				$mod[''temp''] = `start`;\r\n				$mod[''tmplvl''] = "-";\r\n				array_push($mod[''catlist_temp''],$a);\r\n			} else {\r\n				if($mod[''temp''] == `start`){\r\n					array_push($mod[''catlist_temp''],$a);\r\n				}\r\n			}\r\n			break;\r\n		case ''autosub'' :\r\n			if (in_array($con_tree[$a][''parent''],$mod[''path'']) && !strstr(",MOD_VALUE[25],",",$a,")) { \r\n				array_push($mod[''catlist_temp''],$a); \r\n			}\r\n			break;\r\n	}\r\n}\r\n\r\n//vergleich auf parent\r\n$mod[''catlist''] = array();\r\nif($mod[''startpt''] != 0 && is_array($mod[''catlist_temp''])){\r\n	foreach ($mod[''catlist_temp''] as $a) {\r\n		if( nav_cat_is_in_tree($a, $mod[''startpt'']) ){\r\n			array_push($mod[''catlist''],$a);\r\n		}\r\n	}\r\n} else {\r\n	$mod[''catlist''] = $mod[''catlist_temp''];\r\n}\r\n\r\n// SEITENLISTE VORBEREITEN\r\nforeach (array_keys($con_side) as $a) {\r\n	if( isset($cms_side[''view''])  || ($con_side[$a][''online''] && $con_side[$a][''online''] != ''0'')){\r\n		if(!is_array($mod[''sidelist''][$con_side[$a][''idcat'']]))	$mod[''sidelist''][$con_side[$a][''idcat'']] = array();\r\n		array_push($mod[''sidelist''][$con_side[$a][''idcat'']],$a);\r\n	}\r\n}\r\n\r\n\r\n// ORDNER AUSGEBEN\r\nif($cms_mod[''value''][''6''] != ''side'') {\r\n	$mod[''firstc''] = 1;\r\n	$mod[''lastlevel''] = $catlist_level[ $mod[''catlist''][''0''] ];\r\n	foreach ($mod[''catlist''] as $a) {\r\n		if( isset($cms_side[''view''])  || ($con_tree[$a][''visible''] == 1 && is_array($mod[''sidelist''][$a]))){\r\n   			if($catlist_level[$a] < ($mod[''startlevel'']+$mod[''level''])) {\r\n				if($a == $idcat || ("MOD_VALUE[30]" == ''true'' && strstr('',''.implode('','',$mod[''path'']).'','' , ",$a,"))) $mod[''tpl''] = "MOD_VALUE[12]";\r\n				else $mod[''tpl''] = "MOD_VALUE[11]";\r\n				$mod[''tpli''] = "MOD_VALUE[13]";\r\n				$mod[''space''] = '''';\r\n			} else {\r\n				if($a == $idcat || ("MOD_VALUE[30]" == ''true'' && strstr('',''.implode('','',$mod[''path'']).'','' , ",$a,"))) $mod[''tpl''] = "MOD_VALUE[15]";\r\n				else $mod[''tpl''] = "MOD_VALUE[14]";\r\n				$mod[''tpli''] = "MOD_VALUE[16]";\r\n				$mod[''space''] = str_repeat(''&nbsp;'',$catlist_level[$a]);\r\n			}\r\n			if($mod[''firstc''] == 0){\r\n				if($catlist_level[$a] < $mod[''lastlevel'']) echo "MOD_VALUE[27]";\r\n				elseif($catlist_level[$a] > $mod[''lastlevel'']) echo "MOD_VALUE[26]";\r\n				echo $mod[''tpli''];\r\n			}\r\n			$mod[''lastlevel''] = $catlist_level[$a];\r\n			$mod[''firstc''] = 0;\r\n			$mod[''temp''] = '''';\r\n			$mod[''temp''] = str_replace(''{space}'', $mod[''space''], $mod[''tpl'']);\r\n			$mod[''temp''] = str_replace(''{name}'', htmlentities($con_tree[$a][''name''], ENT_COMPAT, ''UTF-8''), $mod[''temp'']);\r\n			$mod[''temp''] = str_replace(''{link}'', $con_tree[$a][''link''], $mod[''temp'']);\r\n			$mod[''temp''] = str_replace(''{id}'', ''lang_''.$lang.''cat_''.$a, $mod[''temp'']);\r\n			if ("MOD_VALUE[30]" == true) {\r\n			$mod[''page_count''] = count($mod[''sidelist''][$a]); \r\n			} else {\r\n			$mod[''page_count''] = count($mod[''sidelist''][$a]) - 1 ;\r\n			}\r\n			if ($mod[''page_count''] < 0) {\r\n			$mod[''page_count''] = 0;\r\n			}\r\n			$mod[''temp''] = str_replace(''{page_count}'', $mod[''page_count''], $mod[''temp'']);\r\n			$mod[''temp''] = str_replace(''{font1}'', "MOD_VALUE[1]", $mod[''temp'']);\r\n			$mod[''temp''] = str_replace(''{font2}'', "MOD_VALUE[2]", $mod[''temp'']);\r\n			$mod[''temp''] = str_replace(''{font3}'', "MOD_VALUE[3]", $mod[''temp'']);\r\n			$mod[''temp''] = cms_stripslashes($mod[''temp'']);\r\n			$mod[''temp''] = str_replace(''{s_name}'', htmlentities(cms_addslashes($con_tree[$a][''name'']), ENT_COMPAT, ''UTF-8''), $mod[''temp'']);\r\n			echo $mod[''temp''];\r\n\r\n			// SEITEN DAZU\r\n			if("MOD_VALUE[6]" == ''groupside'' && is_array($mod[''sidelist''][$a]) && (in_array($a,$mod[''path'']) || "MOD_VALUE[7]" != ''autosub'')){\r\n				// SEITEN SORTIEREN\r\n				$mod[''sortarray''] = array();\r\n				foreach ($mod[''sidelist''][$a] as $b) {\r\n					if ($cms_mod[''value''][''4''] == ''name'') {\r\n						$sortit = strtolower($con_side[$b][''name'']);\r\n					} else {\r\n						$sortit = $con_side[$b][''MOD_VALUE[4]''];\r\n					}\r\n					array_push($mod[''sortarray''], $sortit);\r\n				}\r\n				\r\n				array_multisort($mod[''sortarray''], MOD_VALUE[5], $mod[''sidelist''][$a], MOD_VALUE[5]);\r\n				\r\n				// SEITEN AUSGEBEN\r\n				$mod[''firsts''] = 1;\r\n				foreach ($mod[''sidelist''][$a] as $b) {\r\n					if(($con_side[$b][''is_start''] == ''0'' || "MOD_VALUE[8]" == ''true'') && !strstr(",MOD_VALUE[24],",",$b,")){\r\n						if ($catlist_level[$a] < ($mod[''startlevel'']+$mod[''level''])) {\r\n							$b == $idcatside ? $mod[''tpl''] = "MOD_VALUE[22]" : $mod[''tpl''] = "MOD_VALUE[21]";\r\n							$mod[''tplis''] = "MOD_VALUE[23]";\r\n						} else {\r\n		                    $b == $idcatside ? $mod[''tpl''] = "MOD_VALUE[18]" : $mod[''tpl''] = "MOD_VALUE[17]";\r\n		                    $mod[''tplis''] = "MOD_VALUE[19]";\r\n		                }\r\n						\r\n						if($mod[''firsts''] == 0) { \r\n							echo $mod[''tplis''];\r\n						} \r\n						\r\n						$mod[''firsts''] = 0;\r\n						\r\n						$mod[''temp''] = '''';\r\n						$mod[''temp''] = str_replace(''{space}'', str_repeat(''&nbsp;'',($catlist_level[$a] + 1)), $mod[''tpl'']);\r\n						$mod[''temp''] = str_replace(''{name}'', htmlentities($con_side[$b][''name''], ENT_COMPAT, ''UTF-8''), $mod[''temp'']);\r\n						$mod[''temp''] = str_replace(''{link}'', $con_side[$b][''link''], $mod[''temp'']);\r\n						$mod[''temp''] = str_replace(''{id}'', ''lang_''.$lang.''side_''.$b, $mod[''temp'']);\r\n						$mod[''temp''] = str_replace(''{font1}'', "MOD_VALUE[1]", $mod[''temp'']);\r\n						$mod[''temp''] = str_replace(''{font2}'', "MOD_VALUE[2]", $mod[''temp'']);\r\n						$mod[''temp''] = str_replace(''{font3}'', "MOD_VALUE[3]", $mod[''temp'']);\r\n						$mod[''temp''] = cms_stripslashes($mod[''temp'']);\r\n						$mod[''temp''] = str_replace(''{s_name}'', htmlentities(cms_addslashes($con_tree[$b][''name'']), ENT_COMPAT, ''UTF-8''), $mod[''temp'']);\r\n			            echo $mod[''temp''];\r\n					}\r\n				}\r\n			}\r\n		}\r\n	}\r\n}\r\n\r\nif($cms_mod[''value''][''6''] != ''group'' && $mod[''startpt''] != ''0'') {\r\n	// SEITEN SORTIEREN\r\n	$mod[''sortarray''] = array();\r\n	if (is_array($mod[''sidelist''][ $mod[''startpt''] ]) ) {\r\n		foreach($mod[''sidelist''][ $mod[''startpt''] ] as $b){\r\n			 if ($cms_mod[''value''][''4''] == ''name'') {\r\n				$sortit = strtolower($con_side[$b][''name'']);\r\n			 } elseif ($cms_mod[''value''][''4''] == ''created'' || $cms_mod[''value''][''4''] == ''lastmodified'') {\r\n				$sortit = strtotime($con_side[$b][''MOD_VALUE[4]'']);\r\n			 } else {\r\n				$sortit = $con_side[$b][''MOD_VALUE[4]''];\r\n			 }\r\n\r\n			array_push($mod[''sortarray''], $sortit);\r\n		}\r\n\r\n		array_multisort($mod[''sortarray''], MOD_VALUE[5], $mod[''sidelist''][ $mod[''startpt''] ], MOD_VALUE[5]);\r\n		//SEITEN AUSGEBEN\r\n		$mod[''firsts''] = 1;\r\n		foreach($mod[''sidelist''][ $mod[''startpt''] ] as $b){\r\n			if (($con_side[$b][''is_start''] == ''0'' || "MOD_VALUE[8]" == ''true'') && !strstr(",MOD_VALUE[24],",",$b,")) {\r\n				if ("MOD_VALUE[21]" != "" && "MOD_VALUE[21]" != " "){\r\n					$b == $idcatside ? $mod[''tpl''] = "MOD_VALUE[22]" : $mod[''tpl''] = "MOD_VALUE[21]";\r\n					$mod[''tplis''] = "MOD_VALUE[23]";\r\n				} else {\r\n					$b == $idcatside ? $mod[''tpl''] = "MOD_VALUE[18]" : $mod[''tpl''] = "MOD_VALUE[17]";\r\n					$mod[''tplis''] = "MOD_VALUE[19]";\r\n				}\r\n				if ($mod[''firsts''] == 0) {\r\n					echo $mod[''tplis''];\r\n				}\r\n\r\n				$mod[''firsts''] = 0;\r\n				$mod[''temp''] = '''';\r\n				$mod[''temp''] = str_replace(''{space}'','''', $mod[''tpl'']);\r\n				$mod[''temp''] = str_replace(''{name}'', htmlentities($con_side[$b][''name''], ENT_COMPAT, ''UTF-8''), $mod[''temp'']);\r\n				$mod[''temp''] = str_replace(''{link}'', $con_side[$b][''link''], $mod[''temp'']);\r\n				$mod[''temp''] = str_replace(''{id}'', ''lang_''.$lang.''side_''.$b, $mod[''temp'']);\r\n				$mod[''temp''] = str_replace(''{font1}'', "MOD_VALUE[1]", $mod[''temp'']);\r\n				$mod[''temp''] = str_replace(''{font2}'', "MOD_VALUE[2]", $mod[''temp'']);\r\n				$mod[''temp''] = str_replace(''{font3}'', "MOD_VALUE[3]", $mod[''temp'']);\r\n				$mod[''temp''] = cms_stripslashes($mod[''temp'']);\r\n				$mod[''temp''] = str_replace(''{s_name}'', htmlentities(cms_addslashes($con_tree[$b][''name'']), ENT_COMPAT, ''UTF-8''), $mod[''temp'']);\r\n				echo $mod[''temp''];\r\n			}\r\n	   }\r\n   }\r\n}\r\n// VARIABLEN LEEREN\r\necho $cms_mod[''value''][''20''];\r\n\r\nreset($catlist);\r\nunset ($mod, $a, $b);\r\n</CMSPHP>\r\n', '', 0, 1, 1, 1077574226, 1177011989, 'mod:fd9160bbd656f75ab74e8935e4330d9e:f2431aba', '', '', '', 0, '0', '', '1');
INSERT INTO `cms_mod` VALUES (15, 'Sprachauswahl', '2.0', 'System', 'Ermglicht die Auswahl der Sprachversionen einer Seite.', '<?php\r\n/******************************************************************************\r\n @author:	Andreas Lechner (cliff), Peter Fuchs (renard)\r\n @link		http://www.cms4you.at\r\n******************************************************************************/\r\n\r\n//configmode\r\n$mip_form[''99''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''99''][''cat''] = ''option'';\r\n$mip_form[''99''][''size''] = ''1'';\r\n$mip_form[''99''][''option_desc''][] = ''Normal'';\r\n$mip_form[''99''][''option_val''][] =  '''';\r\n$mip_form[''99''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''99''][''option_val''][] =  ''hidden'';\r\n$mip_form[''99''][''cms_var''] = ''MOD_VAR[99]'';\r\n$mip_form[''99''][''cms_val''] = $cms_mod[''value''][''99''];\r\n$mip_form[''99''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''99'']);//configmode\r\necho ''<br />'';\r\n\r\n//hidden config\r\nif ($cms_mod[''value''][''99''] == ''hidden'') {\r\n	foreach ($cms_mod[''value''] AS $ke=>$va) {\r\n		if ($ke != ''99'') {\r\n		?>\r\n			<input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va);?>">\r\n		<?php\r\n		}\r\n	}\r\n//simple, advanced and all config (not hidden config)\r\n} else if ($cms_mod[''value''][''99''] == '''' || $cms_mod[''value''][''99''] == ''advanced'') {\r\n\r\n	$sql = "SELECT b.idlang, b.name, b.description FROM ".$cms_db[''clients_lang'']." AS a, ".$cms_db[''lang'']." AS b WHERE a.idlang=b.idlang AND a.idclient=''".$client."'' ORDER BY b.idlang ASC";\r\n\r\n	$db->query($sql);\r\n	$num_langs = $db->num_rows();\r\n \r\n	if ($db->affected_rows()) {\r\n\r\n		$counter_langs = 0;\r\n			\r\n		while ($db->next_record()) {\r\n\r\n			// config pulldown lang list\r\n			$frm_opt_list[$counter_langs][''desc'']	= htmlentities($db->f(''name''), ENT_COMPAT, ''utf-8'');\r\n			$frm_opt_list[$counter_langs][''val'']	= $db->f(''idlang'');\r\n\r\n			$counter_langs++;\r\n		}\r\n	}\r\n\r\n	// number of columns\r\n	$cms_mod[''value''][''0''] = $num_langs;\r\n	$mip_form[''0''][''cat''] = ''hidden'';\r\n	$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n	$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n\r\n	// font 1\r\n	$mip_form[''1''][''desc''] = ''Schriftart fr {font1}'';\r\n	$mip_form[''1''][''cat''] = ''app_css'';\r\n	$mip_form[''1''][''output_cat''] = ''option'';\r\n	$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n	$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n	$mip_form[''1''][''cms_val_default''] = '''';\r\n	$mip_form[''1''][''type''] = '''';\r\n\r\n	// font 2\r\n	$mip_form[''2''][''desc''] = ''Schriftart fr {font2}'';\r\n	$mip_form[''2''][''cat''] = ''app_css'';\r\n	$mip_form[''2''][''output_cat''] = ''option'';\r\n	$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n	$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n	$mip_form[''2''][''cms_val_default''] = '''';\r\n	$mip_form[''2''][''type''] = '''';\r\n\r\n	// font 3\r\n	$mip_form[''3''][''desc''] = ''Schriftart fr {font3}'';\r\n	$mip_form[''3''][''cat''] = ''app_css'';\r\n	$mip_form[''3''][''output_cat''] = ''option'';\r\n	$mip_form[''3''][''cms_var''] = ''MOD_VAR[3]'';\r\n	$mip_form[''3''][''cms_val''] = $cms_mod[''value''][''3''];\r\n	$mip_form[''3''][''cms_val_default''] = '''';\r\n	$mip_form[''3''][''type''] = '''';\r\n	\r\n	// link to page or display current page in different language?\r\n	$mip_form[''5''][''cat''] = ''txt'';\r\n	$mip_form[''5''][''type''] = '''';\r\n	$mip_form[''5''][''desc''] = "Link zu einer anderen Seite <small>(idside / leer -> Link auf die gleiche Seite)</small>";\r\n	$mip_form[''5''][''cms_var''] = ''MOD_VAR[5]'';\r\n	$mip_form[''5''][''cms_val''] = $cms_mod[''value''][''5''];\r\n	$mip_form[''5''][''cms_val_default''] = '''';\r\n	$mip_form[''5''][''tab''] = ''0'';\r\n\r\n	// show current language, too?\r\n	$mip_form[''6''][''desc''] = ''Aktuelle Sprache mit anzeigen?'';\r\n	$mip_form[''6''][''cat''] = ''chk'';\r\n	$mip_form[''6''][''option_var''][''0''] = ''MOD_VAR[6]'';\r\n	$mip_form[''6''][''option_val''][''0''] = $cms_mod[''value''][''6''];\r\n	$mip_form[''6''][''option_desc''][''0''] = ''ja'';\r\n	$mip_form[''6''][''option_val_select''][''0''] = ''true'';\r\n\r\n	// show not available languages, too?\r\n	$mip_form[''7''][''desc''] = ''Nicht verfgbare Sprachen mit ausgeben?'';\r\n	$mip_form[''7''][''cat''] = ''chk'';\r\n	$mip_form[''7''][''option_var''][''0''] = ''MOD_VAR[7]'';\r\n	$mip_form[''7''][''option_val''][''0''] = $cms_mod[''value''][''7''];\r\n	$mip_form[''7''][''option_desc''][''0''] = ''ja'';\r\n	$mip_form[''7''][''option_val_select''][''0''] = ''true'';\r\n\r\n	// show not available languages in backend, too?\r\n	$mip_form[''8''][''desc''] = ''Nicht verfgbare Sprachen im Backend anzeigen?'';\r\n	$mip_form[''8''][''cat''] = ''chk'';\r\n	$mip_form[''8''][''option_var''][''0''] = ''MOD_VAR[8]'';\r\n	$mip_form[''8''][''option_val''][''0''] = $cms_mod[''value''][''8''];\r\n	$mip_form[''8''][''option_desc''][''0''] = ''ja'';\r\n	$mip_form[''8''][''option_val_select''][''0''] = ''true'';\r\n\r\n	// surrounding template for languages\r\n	$mip_form[''10''][''desc''] = ''Template Sprachen (auen):<br><small>Zwingend erforderlich Templatevariable: {content}</small>'';\r\n	$mip_form[''10''][''cat''] = ''txtarea'';\r\n	$mip_form[''10''][''rows''] = ''3'';\r\n	$mip_form[''10''][''type''] = ''long'';\r\n	$mip_form[''10''][''cms_var''] = ''MOD_VAR[10]'';\r\n	$mip_form[''10''][''cms_val''] = $cms_mod[''value''][''10''];\r\n	$mip_form[''10''][''cms_val_default''] = ''{content}'';\r\n\r\n	// take the master Tpl\r\n	$mip_form[''11''][''desc''] = ''Master Templates fr alle Sprachen verwenden?'';\r\n	$mip_form[''11''][''cat''] = ''chk'';\r\n	$mip_form[''11''][''option_var''][''0''] = ''MOD_VAR[11]'';\r\n	$mip_form[''11''][''option_val''][''0''] = $cms_mod[''value''][''11''];\r\n	$mip_form[''11''][''option_desc''][''0''] = ''ja'';\r\n	$mip_form[''11''][''option_val_select''][''0''] = ''true'';\r\n\r\n	// show all languages \r\n	$mip_form[''12''][''desc''] = ''Alle Sprachen anzeigen (Automatisch Erweitern)?'';\r\n	$mip_form[''12''][''cat''] = ''chk'';\r\n	$mip_form[''12''][''option_var''][''0''] = ''MOD_VAR[12]'';\r\n	$mip_form[''12''][''option_val''][''0''] = $cms_mod[''value''][''12''];\r\n	$mip_form[''12''][''option_desc''][''0''] = ''ja'';\r\n	$mip_form[''12''][''option_val_select''][''0''] = ''true'';\r\n\r\n	// master template lang available \r\n	$mip_form[''20''][''cat''] = ''txtarea'';\r\n	$mip_form[''20''][''rows''] = ''3'';\r\n	$mip_form[''20''][''type''] = ''long''; \r\n	$mip_form[''20''][''desc''] = ''Template wenn Sprachen-Elemente verfgbar und NICHT Aktiv ist(wird pro sprache in {content} eingefgt):<br><small>Mgliche Templatevariablen: {font1}, {font2}, {font3}, {url}, {idlang}, {name}, {description}, {rewrite_key}, {id}, {parity}</small>'';\r\n	$mip_form[''20''][''cms_var''] = "MOD_VAR[20]";\r\n	$mip_form[''20''][''cms_val''] = $cms_mod[''value''][''20'']; \r\n	$mip_form[''20''][''cms_val_default''] = ''<a href="{url}">{name}</a><br>'';\r\n	$mip_form[''20''][''tab''] = ''0'';\r\n\r\n	// master template lang active \r\n	$mip_form[''21''][''cat''] = ''txtarea'';\r\n	$mip_form[''21''][''rows''] = ''3'';\r\n	$mip_form[''21''][''type''] = ''long''; \r\n	$mip_form[''21''][''desc''] = ''<b>Master Templates:</b><br><br>Template wenn Sprachen-Elemente verfgbar und Aktiv ist (wird pro sprache in {content} eingefgt):<br><small>Mgliche Templatevariablen: {font1}, {font2}, {font3}, {url}, {idlang}, {name}, {description}, {rewrite_key}, {id}, {parity}</small>'';\r\n	$mip_form[''21''][''cms_var''] = "MOD_VAR[21]";\r\n	$mip_form[''21''][''cms_val''] = $cms_mod[''value''][''21'']; \r\n	$mip_form[''21''][''cms_val_default''] = ''<a href="{url}">{name}</a><br>'';\r\n	$mip_form[''21''][''tab''] = ''0'';\r\n\r\n	// master template lang not available \r\n	$mip_form[''22''][''cat''] = ''txtarea'';\r\n	$mip_form[''22''][''rows''] = ''3'';\r\n	$mip_form[''22''][''type''] = ''long''; \r\n	$mip_form[''22''][''desc''] = ''Template wenn Sprachen-Elemente nicht verfgbare  (wird pro sprache in {content} eingefgt):<br><small>Mgliche Templatevariablen: {font1}, {font2}, {font3}, {idlang}, {name}, {description}, {rewrite_key}, {id}, {parity}</small>'';\r\n	$mip_form[''22''][''cms_var''] = "MOD_VAR[22]";\r\n	$mip_form[''22''][''cms_val''] = $cms_mod[''value''][''22'']; \r\n	$mip_form[''22''][''cms_val_default''] = ''<a href="{url}">{name}</a><br>'';\r\n	$mip_form[''22''][''tab''] = ''0'';\r\n\r\n	mip_formsp($mip_form[''0'']); //hidden\r\n\r\n	mip_forms_tabpane_beginp();\r\n\r\n	mip_forms_tabitem_beginp(''Allgemeine Einstellungen'');\r\n\r\n		mip_formsp($mip_form[''1'']);\r\n		mip_formsp($mip_form[''2'']);\r\n		mip_formsp($mip_form[''3'']);\r\n		mip_formsp($mip_form[''5'']);\r\n		mip_formsp($mip_form[''6'']);\r\n		mip_formsp($mip_form[''7'']);\r\n		mip_formsp($mip_form[''8'']);\r\n		mip_formsp($mip_form[''11'']);\r\n		mip_formsp($mip_form[''12'']);\r\n\r\n		echo ''<br />'';\r\n\r\n		mip_formsp($mip_form[''10'']);\r\n\r\n		echo ''<br />'';\r\n\r\n		mip_formsp($mip_form[''21'']);\r\n		mip_formsp($mip_form[''20'']);\r\n		mip_formsp($mip_form[''22'']);\r\n\r\n	mip_forms_tabitem_endp();\r\n\r\n	$ecount = 100;\r\n\r\n	// count the language\r\n	for ($i=0; $i < $cms_mod[''value''][''0'']; $i++) {\r\n\r\n		$frm_view				= $ecount;\r\n		$frm_lang				= $ecount+1;\r\n		$frm_lang_available		= $ecount+2;\r\n		$frm_lang_active		= $ecount+3;\r\n		$frm_lang_not_available = $ecount+4;\r\n\r\n		// activate language\r\n		$mip_form[$frm_view][''cat''] = ''chk'';\r\n		$mip_form[$frm_view][''desc''] = ''Sprache anzeigen?'';\r\n		$mip_form[$frm_view][''option_var''][''0''] = "MOD_VAR[$frm_view]";\r\n		$mip_form[$frm_view][''option_val''][''0''] = $cms_mod[''value''][$frm_view];\r\n		$mip_form[$frm_view][''option_desc''][''0''] = ''ja'';\r\n		$mip_form[$frm_view][''option_val_select''][''0''] = ''1'';\r\n\r\n		// list languages\r\n		if (is_array($frm_opt_list)) {\r\n			$mip_form[$frm_lang][''cat''] = ''option'';\r\n			$mip_form[$frm_lang][''type''] = '''';\r\n			$mip_form[$frm_lang][''desc''] = ''Auswahl der Sprache:'';\r\n			$mip_form[$frm_lang][''cms_var''] = "MOD_VAR[$frm_lang]";\r\n			$mip_form[$frm_lang][''cms_val''] = $cms_mod[''value''][$frm_lang];\r\n			$mip_form[$frm_lang][''cms_val_default''] = '''';\r\n			$index = 0;\r\n			foreach ($frm_opt_list AS $lang_va) {\r\n				$mip_form[$frm_lang][''option_desc''][$index] = $lang_va[''desc''];\r\n				$mip_form[$frm_lang][''option_val''][$index] = $lang_va[''val''];\r\n				$index++;\r\n			}\r\n			$mip_form[$frm_lang][''size''] = 1;\r\n			$mip_form[$frm_lang][''tab''] = ''0'';\r\n		}\r\n\r\n		// template lang available \r\n		$mip_form[$frm_lang_available][''cat''] = ''txtarea'';\r\n		$mip_form[$frm_lang_available][''rows''] = ''3'';\r\n		$mip_form[$frm_lang_available][''type''] = ''long''; \r\n		$mip_form[$frm_lang_available][''desc''] = ''Template wenn Sprachen-Elemente verfgbar und NICHT Aktiv ist(wird pro sprache in {content} eingefgt):<br><small>Mgliche Templatevariablen: {font1}, {font2}, {font3}, {url}, {idlang}, {name}, {description}, {rewrite_key}, {id}, {parity}</small>'';\r\n		$mip_form[$frm_lang_available][''cms_var''] = "MOD_VAR[$frm_lang_available]";\r\n		$mip_form[$frm_lang_available][''cms_val''] = $cms_mod[''value''][$frm_lang_available]; \r\n		if ($cms_mod[''value''][''20''] == '''') {\r\n			$mip_form[$frm_lang_available][''cms_val_default''] = $mip_form[''20''][''cms_val_default''];\r\n		} else {\r\n			$mip_form[$frm_lang_available][''cms_val_default''] = $cms_mod[''value''][''20''];\r\n		}\r\n		$mip_form[$frm_lang_available][''tab''] = ''0'';\r\n\r\n		// template lang active \r\n		$mip_form[$frm_lang_active][''cat''] = ''txtarea'';\r\n		$mip_form[$frm_lang_active][''rows''] = ''3'';\r\n		$mip_form[$frm_lang_active][''type''] = ''long''; \r\n		$mip_form[$frm_lang_active][''desc''] = ''Template wenn Sprachen-Elemente verfgbar und Aktiv ist (wird pro sprache in {content} eingefgt):<br><small>Mgliche Templatevariablen: {font1}, {font2}, {font3}, {url}, {idlang}, {name}, {description}, {rewrite_key}, {id}, {parity}</small>'';\r\n		$mip_form[$frm_lang_active][''cms_var''] = "MOD_VAR[$frm_lang_active]";\r\n		$mip_form[$frm_lang_active][''cms_val''] = $cms_mod[''value''][$frm_lang_active];\r\n		if ($cms_mod[''value''][''21''] == '''') {\r\n			$mip_form[$frm_lang_active][''cms_val_default''] = $mip_form[''21''][''cms_val_default''];\r\n		} else {\r\n			$mip_form[$frm_lang_active][''cms_val_default''] = $cms_mod[''value''][''21''];\r\n		}\r\n		$mip_form[$frm_lang_active][''tab''] = ''0'';\r\n\r\n		// template lang not available \r\n		$mip_form[$frm_lang_not_available][''cat''] = ''txtarea'';\r\n		$mip_form[$frm_lang_not_available][''rows''] = ''3'';\r\n		$mip_form[$frm_lang_not_available][''type''] = ''long''; \r\n		$mip_form[$frm_lang_not_available][''desc''] = ''Template wenn Sprachen-Elemente nicht verfgbare  (wird pro sprache in {content} eingefgt):<br><small>Mgliche Templatevariablen: {font1}, {font2}, {font3}, {idlang}, {name}, {description}, {rewrite_key}, {id}, {parity}</small>'';\r\n		$mip_form[$frm_lang_not_available][''cms_var''] = "MOD_VAR[$frm_lang_not_available]";\r\n		$mip_form[$frm_lang_not_available][''cms_val''] = $cms_mod[''value''][$frm_lang_not_available];\r\n		if ($cms_mod[''value''][''22''] == '''') {\r\n			$mip_form[$frm_lang_not_available][''cms_val_default''] = $mip_form[''22''][''cms_val_default''];\r\n		} else {\r\n			$mip_form[$frm_lang_not_available][''cms_val_default''] = $cms_mod[''value''][''22''];\r\n		}\r\n		$mip_form[$frm_lang_not_available][''tab''] = ''0'';\r\n\r\n		mip_forms_tabitem_beginp(''Sprache ''.($i+1));\r\n			mip_formsp($mip_form[$frm_view]);\r\n			mip_formsp($mip_form[$frm_lang]);\r\n			mip_formsp($mip_form[$frm_lang_active]);\r\n			mip_formsp($mip_form[$frm_lang_available]);\r\n			mip_formsp($mip_form[$frm_lang_not_available]);\r\n		mip_forms_tabitem_endp();\r\n\r\n		$ecount = $ecount+10;\r\n	}\r\n}\r\n\r\nunset($mip_form);\r\n?>', '<CMSPHP>\r\n/******************************************************************************\r\n @author:	Andreas Lechner (cliff), Peter Fuchs (renard)\r\n @link		http://www.cms4you.at\r\n******************************************************************************/\r\n</CMSPHP>\r\n\r\n<CMSPHP:CACHE>\r\necho ''<CMSPHP>'';\r\nif (is_array($cms_mod[''value''])) {\r\n	foreach($cms_mod[''value''] AS $k => $v){\r\n		echo ''$mvars["''.$k.''"] = "''. addslashes($v) .''";''."\\n";\r\n	}\r\n}\r\necho ''</CMSPHP>'';\r\n</CMSPHP:CACHE>\r\n\r\n<CMSPHP>\r\n// get idcatside\r\nif ($mvars[''5''] != '''') {\r\n	$newidcatside = $mvars[''5''];\r\n} else {\r\n	$newidcatside = $idcatside;\r\n}\r\n\r\nif (!is_array($langs_data)) {\r\n\r\n	$sql = "SELECT b.idlang, b.name, b.description, b.rewrite_key FROM  ".$cms_db[''clients_lang'']." AS a, ".$cms_db[''lang'']." AS b WHERE a.idlang=b.idlang AND a.idclient=''".$client."''";\r\n\r\n	$db->query($sql);\r\n	if ($db->affected_rows()) {\r\n		while ($db->next_record()) {\r\n			$langs_data[$db->f(''idlang'')][''idlang'']			= $db->f(''idlang'');\r\n			$langs_data[$db->f(''idlang'')][''name'']			= htmlentities($db->f(''name''), ENT_COMPAT, ''utf-8'');\r\n			$langs_data[$db->f(''idlang'')][''description'']	= htmlentities($db->f(''description''), ENT_COMPAT, ''utf-8'');			\r\n			$langs_data[$db->f(''idlang'')][''rewrite_key'']	= htmlentities($db->f(''rewrite_key''), ENT_COMPAT, ''utf-8'');			\r\n		}\r\n	}\r\n}\r\n\r\nif (!is_array($langs_online)) {\r\n\r\n	$sql2 = " AND (  (b.online & 0x03) = 0x01 OR (  (b.online & 0x02) = 0x02 AND ( UNIX_TIMESTAMP(NOW()) BETWEEN b.start AND b.end))) ";\r\n	$sql2 .=  ( $perm->have_perm(2, ''area_frontend'', 0) ) ?  '''': '' AND (b.online & 0x04) = 0x00 '';\r\n	$sql = "SELECT b.idlang, c.name FROM ((".$cms_db[''cat_side'']." AS a INNER JOIN ".$cms_db[''side_lang'']." AS b ON a.idside = b.idside) INNER JOIN ".$cms_db[''lang'']." AS c ON b.idlang = c.idlang) INNER JOIN ".$cms_db[''side'']. " AS d ON a.idside = d.idside WHERE (a.idcatside=" . $newidcatside. " ) AND (d.idclient=" . $client . ") ".$sql2;\r\n	\r\n	$db->query($sql);\r\n	if ($db->affected_rows()) {\r\n		while ($db->next_record()) {\r\n			$langs_online[] = $db->f(''idlang'');\r\n		}\r\n	}\r\n}\r\n\r\n// create link\r\nif (!function_exists(''createLinkUrl'')) {\r\n	function createLinkUrl($langid, $newidcatside, $is_online) {\r\n		global $cfg_client, $sess, $view;\r\n		// backend view\r\n		if (isset($view) && $view != "") {\r\n			if ($is_online == "1") {\r\n				return $sess->url($cfg_client["contentfile"].''?idcatside=''.$newidcatside.''&lang=''.$langid.''&view=''.$view);\r\n			}\r\n		// frontend view\r\n		} else {\r\n			if ($is_online == "1") {\r\n				// apache mod_rewrite support = 1\r\n				if ($cfg_client[''url_rewrite''] == ''1'') {\r\n					$url_rewrite_in = array(\r\n						"''(?<!/)".$cfg_client[''contentfile'']."\\?idcat=([1-9][0-9]*)(&|&amp;)lang=([1-9][0-9]?)''",\r\n						"''(?<!/)".$cfg_client[''contentfile'']."\\?idcatside=([1-9][0-9]*)(&|&amp;)lang=([1-9][0-9]?)''"\r\n					);\r\n					$url_rewrite_out = array(\r\n						"cat\\\\1-\\\\3.html",\r\n						"page\\\\1-\\\\3.html"\r\n					);\r\n					$linkUrl = $sess->url($cfg_client["contentfile"].''?idcatside=''.$newidcatside.''&amp;lang=''.$langid);\r\n					$linkUrl = preg_replace($url_rewrite_in, $url_rewrite_out, $linkUrl);\r\n				// apache mod_rewrite support = 2\r\n				} elseif ($cfg_client[''url_rewrite''] == ''2'') {\r\n					$linkUrl = rewriteGetPageUrl($newidcatside, $langid, true);\r\n				} else {\r\n					$linkUrl = $sess->url($cfg_client["contentfile"].''?idcatside=''.$newidcatside.''&amp;lang=''.$langid);\r\n				}\r\n\r\n				return $linkUrl;\r\n			}\r\n		}\r\n	}\r\n}\r\n\r\n// process element template\r\n$elements = '''';\r\n$ecount = 100;\r\n$my_langs_all = count($langs_data);\r\n\r\nfor ($index = 0; $index < $my_langs_all; $index++) {\r\n\r\n	$frm_view				= $ecount;\r\n	$frm_lang				= $ecount+1;\r\n	$frm_lang_available		= $ecount+2;\r\n	$frm_lang_active		= $ecount+3;\r\n	$frm_lang_not_available = $ecount+4;\r\n\r\n	$my_flag_sort = false;\r\n\r\n	// sort\r\n	if ((isset($langs_data [$mvars[$frm_lang]][''idlang''])) && ($mvars[$frm_view] == 1 || (isset($cms_side[''view'']) && $mvars[''8''] == ''true''))) {\r\n		// from config\r\n		$my_flag_sort = true;\r\n		$my_lang_id = $mvars[$frm_lang];\r\n	} elseif($mvars[''7''] == ''true'' || (isset($cms_side[''view'']) && $mvars[''8''] == ''true'' && $mvars[''12''] == ''true'')) {\r\n		// from backend\r\n		$my_array_key = array_keys($langs_data);\r\n		$my_lang_id = $my_array_key[0]; \r\n	} else {\r\n		$my_lang_id = '''';\r\n	}\r\n\r\n	// lang available\r\n	if (((!empty($langs_online) && (in_array($my_lang_id, $langs_online))) || (isset($cms_side[''view'']) && ( ($mvars[''7''] == ''true'' && ($mvars[''12''] == ''true'' || $my_flag_sort == true)) || $mvars[''8''] == ''true''))) && $my_lang_id != '''') {\r\n		$is_available = 1;\r\n	} else {\r\n		$is_available = 0;\r\n	}\r\n\r\n	$my_flag_count = false;\r\n	\r\n	// what template\r\n	if ($mvars[''6''] == ''true'' && $my_lang_id == $lang && $is_available == 1) {\r\n\r\n		$my_flag_count = true;\r\n\r\n		if ($mvars[''11''] == ''true'' || ($mvars[''12''] == ''true'' && !$my_flag_sort)) {\r\n			// master tpl\r\n			$template = $mvars[''21''];\r\n		} else {\r\n			$template = $mvars[$frm_lang_active];\r\n		}\r\n\r\n	} elseif (($my_lang_id != $lang && $is_available == 1) || ($my_lang_id != $lang && $is_available == 1 && isset($cms_side[''view'']) && ( ($mvars[''7''] == ''true'' && ($mvars[''12''] == ''true'' || $my_flag_sort == true)) || $mvars[''8''] == ''true'') )) {\r\n\r\n		$my_flag_count = true;\r\n\r\n		if ($mvars[''11''] == ''true'' || ($mvars[''12''] == ''true'' && !$my_flag_sort)) {\r\n			// master tpl\r\n			$template = $mvars[''20''];\r\n		} else {\r\n			$template = $mvars[$frm_lang_available];\r\n		}\r\n\r\n	} elseif ($is_available == 0 && ($mvars[''7''] == ''true'' && ($mvars[''12''] == ''true'' || $my_flag_sort == true))) {\r\n\r\n		$my_flag_count = true;\r\n\r\n		if ($mvars[''11''] == ''true'' || ($mvars[''12''] == ''true'' && !$my_flag_sort)) {\r\n			// master tpl\r\n			$template = $mvars[''22''];\r\n		} else {\r\n			$template = $mvars[$frm_lang_not_available];\r\n		}\r\n\r\n	} else {\r\n		$template = '''';\r\n	}\r\n\r\n	if ($my_flag_count) {\r\n		if ($index == 0) {\r\n			$my_counter = 1;\r\n		} else {\r\n			$my_counter++;\r\n		}\r\n	}\r\n\r\n	if ($my_counter % 2 != 0) {\r\n		$my_parity = ''odd'';\r\n	} else {\r\n		$my_parity = ''even'';\r\n	}\r\n\r\n	$template = str_replace("{font1}", $mvars[''1''], $template);\r\n	$template = str_replace("{font2}", $mvars[''2''], $template);\r\n	$template = str_replace("{font3}", $mvars[''3''], $template);\r\n	$template = str_replace("{url}", createLinkUrl($my_lang_id, $newidcatside, $is_available), $template);\r\n	$template = str_replace("{idlang}", $langs_data[$my_lang_id][''idlang''], $template);\r\n	$template = str_replace("{name}", $langs_data[$my_lang_id][''name''], $template);\r\n	$template = str_replace("{description}", $langs_data[$my_lang_id][''description''], $template);\r\n	$template = str_replace("{rewrite_key}", $langs_data[$my_lang_id][''rewrite_key''], $template);\r\n	$template = str_replace("{id}", $my_counter, $template);\r\n	$template = str_replace("{parity}", $my_parity, $template);\r\n\r\n	$elements .= $template;\r\n\r\n	// dual language edition prevent\r\n	if ($my_lang_id != '''') {\r\n		unset($langs_data[$my_lang_id]);\r\n	}\r\n\r\n	$ecount = $ecount+10;\r\n}\r\n\r\n// process global template\r\n$globaltemplate = str_replace("{content}", $elements, $mvars[''10'']);\r\necho $globaltemplate;\r\nunset($globaltemplate,$newidcatside,$elements,$template,$is_available,$langs_data,$langs_online,$sql,$mvars);\r\n</CMSPHP>', '', 0, 1, 1, 1066927900, 1215637017, 'mod:d3cac1d21bfb93f3a602c393202cd379:1dc9cdab', '', '', '', 0, '', '', '1');
INSERT INTO `cms_mod` VALUES (16, 'Login', '2.2', 'System', 'Login/out-Formular fr die geschtzten Bereiche.', '<?PHP\r\n//val ref\r\n// 01 txt Datumsformat\r\n// 02 txt Zeitformat\r\n// 03 txtarea Template fr die Fehlermeldung\r\n// 06 txt attribute benutzername\r\n// 07 txt attribute passwort\r\n// 08 Template Anmeldung\r\n// 09 Template Logout\r\n// 10 Frontendbearbeitung erlauben \r\n// 12 txt weiterleitung nach login\r\n// 13 txt weiterleitung nach logout\r\n// 14 txtarea tpl date\r\n// 15 txtarea tpl date_empty\r\n// 16 txt weiterleitung wenn eingeloggt\r\n// 17 txt weiterleitung wenn eingeloggt nicht im backend\r\n// 18 chkbox Login nur mit Benutzernamen (Benutzername und Passwort sind identisch) \r\n\r\n//Template Fehlermeldung\r\n$mip_form[''3''][''desc''] = ''Template Fehlermeldung bei ungltigem Login'';\r\n$mip_form[''3''][''type''] = ''long'';\r\n$mip_form[''3''][''rows''] = ''3'';\r\n$mip_form[''3''][''cat''] = ''txtarea'';\r\n$mip_form[''3''][''cms_var''] = ''MOD_VAR[3]'';\r\n$mip_form[''3''][''cms_val''] = $cms_mod[''value''][''3''];\r\n$mip_form[''3''][''cms_val_default''] = ''<tr>\r\n    <td colspan="2">Login fehlgeschlagen! Falscher Benutzername oder falsches Passwort!</td>\r\n</tr>'';\r\n$mip_form[''3''][''tab''] = ''0'';\r\n\r\n//attribute benutzername\r\n$mip_form[''6''][''desc''] = ''Optionale Formularattribute f&uuml;r Benutzername'';\r\n$mip_form[''6''][''cat''] = ''txt'';\r\n$mip_form[''6''][''cms_var''] = ''MOD_VAR[6]'';\r\n$mip_form[''6''][''cms_val''] = $cms_mod[''value''][''6''];\r\n$mip_form[''6''][''cms_val_default''] = '''';\r\n\r\n//attribute passwort\r\n$mip_form[''7''][''desc''] = ''Optionale Formularattribute f&uuml;r Passwort'';\r\n$mip_form[''7''][''cat''] = ''txt'';\r\n$mip_form[''7''][''cms_var''] = ''MOD_VAR[7]'';\r\n$mip_form[''7''][''cms_val''] = $cms_mod[''value''][''7''];\r\n$mip_form[''7''][''cms_val_default''] = '''';\r\n\r\n//Datumsformat \r\n$mip_form[''1''][''desc''] = ''Formatierung Datum letzter Login'';\r\n$mip_form[''1''][''cat''] = ''txt'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''cms_val_default''] = ''d.m.Y'';\r\n\r\n//Zeitformat\r\n$mip_form[''2''][''desc''] = ''Formatierung Uhrzeit letzter Login'';\r\n$mip_form[''2''][''cat''] = ''txt'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''cms_val_default''] = ''H:i:s'';\r\n\r\n// Template Anmeldung\r\n$mip_form[''8''][''cat''] = ''txtarea'';\r\n$mip_form[''8''][''type''] = ''long'';\r\n$mip_form[''8''][''rows''] = ''8'';\r\n$mip_form[''8''][''desc''] = ''Template<br><small>Mgliche Templatevariablen: {form_attributes}, {input_name}, {input_password}, {errortemplate}</small>'';\r\n$mip_form[''8''][''cms_var''] = ''MOD_VAR[8]'';\r\n$mip_form[''8''][''cms_val''] = $cms_mod[''value''][''8''];\r\n$mip_form[''8''][''cms_val_default''] = ''<form {form_attributes}>\r\n<table cellspacing="0" cellpadding="0" border="0">\r\n  {errortemplate}\r\n  <tr>\r\n    <td>&nbsp;Username :&nbsp;</td>\r\n    <td>&nbsp;{input_name}&nbsp;</td>\r\n  </tr>\r\n  <tr>\r\n    <td>&nbsp;Passwort :&nbsp;</td>\r\n    <td>&nbsp;{input_password}&nbsp;</td>\r\n  </tr>\r\n  <tr>\r\n    <td colspan="2" align="right"><input type="submit" name="submit" value="Einloggen" \\></td>\r\n  </tr>\r\n</table>\r\n</form>'';\r\n\r\n// Template Logout\r\n$mip_form[''9''][''cat''] = ''txtarea'';\r\n$mip_form[''9''][''type''] = ''long'';\r\n$mip_form[''9''][''rows''] = ''8'';\r\n$mip_form[''9''][''desc''] = ''Template Logout<br><small>Mgliche Templatevariablen: {name}, {surname}, {firm}, {position}, {salutation}, {street}, {zip}, {location}, {phone}, {fax}, {comment}, {email}, {lastlogin}, {form_attributes}, {form_hiddenvals}</small>'';\r\n$mip_form[''9''][''cms_var''] = ''MOD_VAR[9]'';\r\n$mip_form[''9''][''cms_val''] = $cms_mod[''value''][''9''];\r\n$mip_form[''9''][''cms_val_default''] = ''<form {form_attributes}>\r\n<table cellspacing="0" cellpadding="0" border="0">\r\n  <tr>\r\n    <td>Guten Tag {salutation} {name} {surname}!</td>\r\n  </tr>\r\n  <tr>\r\n    <td align="right"><input type="submit" name="submit" value="Ausloggen" /></td>\r\n  </tr>\r\n</table>\r\n{form_hiddenvals}\r\n</form>'';\r\n\r\n// Frontendbearbeitung erlauben\r\n$mip_form[''10''][''desc''] = ''Frontendbearbeitung erlauben'';\r\n$mip_form[''10''][''cat''] = ''chk'';\r\n$mip_form[''10''][''option_var''][''0''] = "MOD_VAR[10]";\r\n$mip_form[''10''][''option_val''][''0''] = $cms_mod[''value''][''10''];\r\n$mip_form[''10''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''10''][''option_val_select''][''0''] = ''true'';\r\n\r\n//Weiterleitung nach Login\r\n$mip_form[''12''][''desc''] = ''Nach Login weiterleiten auf Seite <small>(Idcatside angeben, Eingabe "0" = keine Weiterleitung)</small>'';\r\n$mip_form[''12''][''cat''] = ''txt'';\r\n$mip_form[''12''][''cms_var''] = ''MOD_VAR[12]'';\r\n$mip_form[''12''][''cms_val''] = $cms_mod[''value''][''12''];\r\n$mip_form[''12''][''cms_val_default''] = ''0'';\r\n\r\n//Weiterleitung nach Logout\r\n$mip_form[''13''][''desc''] = ''Nach Logout weiterleiten auf Seite <small>(Idcatside angeben, Eingabe "0" = keine Weiterleitung)</small>'';\r\n$mip_form[''13''][''cat''] = ''txt'';\r\n$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n$mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n$mip_form[''13''][''cms_val_default''] = ''0'';\r\n\r\n//Template Datum\r\n$mip_form[''14''][''desc''] = ''Template Letzter Login<br /><small>Templatevariablen: {lastlogin_date}, {lastlogin_time}</small>'';\r\n$mip_form[''14''][''type''] = ''long'';\r\n$mip_form[''14''][''rows''] = ''2'';\r\n$mip_form[''14''][''cat''] = ''txtarea'';\r\n$mip_form[''14''][''cms_var''] = ''MOD_VAR[14]'';\r\n$mip_form[''14''][''cms_val''] = $cms_mod[''value''][''14''];\r\n$mip_form[''14''][''cms_val_default''] = ''Letzter Login am {lastlogin_date}, um {lastlogin_time} Uhr'';\r\n$mip_form[''14''][''tab''] = ''0'';\r\n\r\n//Template Datum leer\r\n$mip_form[''15''][''desc''] = ''Template letzer Login, wenn kein Wert vorhanden'';\r\n$mip_form[''15''][''type''] = ''long'';\r\n$mip_form[''15''][''rows''] = ''2'';\r\n$mip_form[''15''][''cat''] = ''txtarea'';\r\n$mip_form[''15''][''cms_var''] = ''MOD_VAR[15]'';\r\n$mip_form[''15''][''cms_val''] = $cms_mod[''value''][''15''];\r\n$mip_form[''15''][''cms_val_default''] = ''Sie haben sich noch nie eingeloggt.'';\r\n$mip_form[''15''][''tab''] = ''0'';\r\n\r\n//Weiterleitung wenn eingeloggt\r\n$mip_form[''16''][''desc''] = ''Wenn eingeloggt, grundstzlich weiterleiten auf Seite <small>(Idcatside angeben, Eingabe "0" = keine Weiterleitung, Weiterleitung gilt nur fr das Frontend)</small>'';\r\n$mip_form[''16''][''cat''] = ''txt'';\r\n$mip_form[''16''][''cms_var''] = ''MOD_VAR[16]'';\r\n$mip_form[''16''][''cms_val''] = $cms_mod[''value''][''16''];\r\n$mip_form[''16''][''cms_val_default''] = ''0'';\r\n\r\n\r\n// Weiterleitung auch im Backend\r\n$mip_form[''17''][''desc''] = ''Wenn eingeloggt Weiterleitung auch im Backend'';\r\n$mip_form[''17''][''cat''] = ''chk'';\r\n$mip_form[''17''][''option_var''][''0''] = "MOD_VAR[17]";\r\n$mip_form[''17''][''option_val''][''0''] = $cms_mod[''value''][''17''];\r\n$mip_form[''17''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''17''][''option_val_select''][''0''] = ''true'';\r\n\r\n// Login nur mit Benutzernamen (Benutzername und Passwort sind identisch) \r\n$mip_form[''18''][''desc''] = ''Login nur mit Benutzernamen  <small>(Benutzername und Passwort sind identisch, es wird nur die Variable {input_name} geprft)</small>'';\r\n$mip_form[''18''][''cat''] = ''chk'';\r\n$mip_form[''18''][''option_var''][''0''] = "MOD_VAR[18]";\r\n$mip_form[''18''][''option_val''][''0''] = $cms_mod[''value''][''18''];\r\n$mip_form[''18''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''18''][''option_val_select''][''0''] = ''true'';\r\n\r\n\r\nmip_formsp($mip_form[''12'']); //Weiterleitung nach login\r\nmip_formsp($mip_form[''16'']); //Weiterleitung wenn eingeloggt\r\nmip_formsp($mip_form[''17'']); //Weiterleitung wenn eingeloggt, auch im Backend\r\nmip_formsp($mip_form[''13'']); //Weiterleitung nach logout\r\nmip_formsp($mip_form[''10'']); //Frontendbearbeitung erlauben\r\nmip_formsp($mip_form[''18'']); //Login nur mit Benutzernamen\r\nmip_formsp($mip_form[''6'']);  //Attribute benutzername\r\nmip_formsp($mip_form[''7'']);  //Attribute passwort\r\nmip_formsp($mip_form[''8'']);  //Template Anmeldung  \r\nmip_formsp($mip_form[''3'']);  //Template fr die Fehlermeldung\r\nmip_formsp($mip_form[''9'']);  //Template Logout\r\nmip_formsp($mip_form[''1'']);  //Datumsformat\r\nmip_formsp($mip_form[''2'']);  //Zeitformat\r\nmip_formsp($mip_form[''14'']); //Template Datum\r\nmip_formsp($mip_form[''15'']); //Template Datum leer\r\n\r\nunset($mip_form);\r\n?>', '<CMSPHP>\r\n$is_dev = false;\r\n\r\n//config\r\n$mod[''dateformat''] = "MOD_VALUE[1]";\r\n$mod[''timeformat''] = "MOD_VALUE[2]";\r\n$mod[''tpl_lastlogin''] = "MOD_VALUE[14]";\r\n$mod[''tpl_lastlogin_empty''] = "MOD_VALUE[15]";\r\n$mod[''tpl_login''] = "MOD_VALUE[8]";\r\n$mod[''tpl_login_error''] = "MOD_VALUE[3]";\r\n$mod[''tpl_logout''] = "MOD_VALUE[9]";\r\n$mod[''redirect_login''] = (int) trim("MOD_VALUE[12]");\r\n$mod[''redirect_logout''] = (int) trim("MOD_VALUE[13]");\r\n$mod[''redirect_if_logged_in_and backend''] = "MOD_VALUE[17]";\r\n$mod[''allow_backendlogin''] = "MOD_VALUE[10]";\r\n$mod[''attributes_username''] = "MOD_VALUE[6]";\r\n$mod[''attributes_password''] = "MOD_VALUE[7]";\r\n$mod[''redirect_if_logged_in''] = (int) "MOD_VALUE[16]";\r\n$mod[''username_is_password''] = "MOD_VALUE[18]";\r\n\r\n$mod[''throw_error''] = false;\r\n\r\nif ($is_dev) {\r\n   include_once "C:/Programme/xampp/htdocs/sefrengo_dev/moddev/login-out.php";\r\n} else {\r\n\r\n\r\nif ($_REQUEST[''action''] == ''login'') \r\n{\r\n	//write loginaction to log\r\n    $sf_wr =& $GLOBALS[''sf_factory'']->getObject(''HTTP'', ''WebRequest'');\r\n	$username = $sf_wr->getVal(''username''); \r\n	$password = ($mod[''username_is_password''] == ''true'') ? $username : $sf_wr->getVal(''password''); \r\n	$sf_user =& sf_factoryGetObject(''ADMINISTRATION'', ''User''); \r\n    $sf_user->loadByUsernamePassword($username, $password, true);\r\n    unset($sf_user);\r\n    \r\n	if ($username != '''') {\r\n        $auth->auth[''uname''] = $username;\r\n    } else if ($auth->nobody) {\r\n		$uid = $auth->auth[''uname''] = $auth->auth[''uid''] = ''nobody'';\r\n	}\r\n	\r\n    // User aus der Datenbank suchen\r\n	$username = addslashes($username);\r\n	$sql_password = ($mod[''username_is_password''] == ''true'') ? md5($username):md5($password);\r\n	$sql = "SELECT \r\n		firm, position, salutation, street, zip, location, phone, fax, comment, A.user_id, password, A.name, surname, email, C.name AS groupname, C.description\r\n		FROM ".$cms_db[''users'']." A\r\n		LEFT JOIN ".$cms_db[''users_groups'']." B USING(user_id)\r\n		LEFT JOIN ".$cms_db[''groups'']." C USING(idgroup)\r\n		LEFT JOIN ".$cms_db[''perms'']." D USING(idgroup)\r\n		WHERE A.username=''$username''\r\n		AND A.password=''".$sql_password."''\r\n		AND A.is_active=''1''\r\n		AND C.is_active=''1''\r\n		AND ((D.type=''cms_access'' AND D.id=''area_backend'' AND D.perm>0) OR C.is_sys_admin=''1'') LIMIT 0, 1";\r\n	$db->query($sql);\r\n	\r\n	//login to backend\r\n	if ($db->next_record() && $mod[''allow_backendlogin''] == ''true'') {\r\n		\r\n		// Backenduser Login\r\n		$auth->logout();\r\n		$sess = new cms_Backend_Session;\r\n		$auth = new cms_Backend_Auth;\r\n		$HTTP_GET_VARS[''cms''] = $_GET[''cms''] = md5(uniqid($sess->magic));\r\n		$sess->start();\r\n		$auth->auth[''name''] = $db->f(''name'');\r\n		$auth->auth[''surname''] = $db->f(''surname'');\r\n		$auth->auth[''group_name''] = $db->f(''groupname'');\r\n		$auth->auth[''group_desc''] = $db->f(''description'');\r\n		$auth->auth[''email''] = $db->f(''email'');\r\n		$auth->auth[''firm''] = $db->f(''firm'');\r\n		$auth->auth[''position''] = $db->f(''position'');\r\n		$auth->auth[''salutation''] = $db->f(''salutation'');\r\n		$auth->auth[''street''] = $db->f(''street'');\r\n		$auth->auth[''zip''] = $db->f(''zip'');\r\n		$auth->auth[''location''] = $db->f(''location'');\r\n		$auth->auth[''phone''] = $db->f(''phone'');\r\n		$auth->auth[''fax''] = $db->f(''fax'');\r\n		$auth->auth[''comment''] = $db->f(''comment'');\r\n		$auth->auth[''uid''] = $db->f(''user_id'');\r\n		$auth->auth[''uname''] = $username;\r\n		$auth->auth[''exp''] = time() + (60 * $auth->lifetime);\r\n		$auth->auth[''refresh''] = time() + (60 * $auth->refresh);\r\n		$sess->register(''auth'');\r\n		$sess->register(''sid_sniffer'');\r\n		$sess->freeze();\r\n\r\n		// redirect\r\n		$sf_idcatside_redirect = $mod[''redirect_login''];\r\n		if ($sf_idcatside_redirect < 1) {\r\n		  $sf_idcatside_redirect = $idcatside;\r\n		}\r\n\r\n		sf_header_redirect($cfg_client[''contentfile'']."?lang=$lang&idcatside=$sf_idcatside_redirect&view=preview&".$sess->name.''=''.$sess->id);\r\n	//login to frontend\r\n    } else {\r\n		$sql = "SELECT \r\n		firm, position, salutation, street, zip, location, phone, fax, comment, A.user_id, password, A.name, surname, email, C.name AS groupname, C.description\r\n		FROM ".$cms_db[''users'']." A\r\n		LEFT JOIN ".$cms_db[''users_groups'']." B USING(user_id)\r\n		LEFT JOIN ".$cms_db[''groups'']." C USING(idgroup)\r\n		LEFT JOIN ".$cms_db[''perms'']." D USING(idgroup)\r\n		WHERE A.username=''$username''\r\n		AND A.password=''".$sql_password."''\r\n		AND A.is_active=''1''\r\n		AND C.is_active=''1''\r\n		AND ((D.type=''cms_access'' AND D.id=''area_frontend'' AND D.perm=''1'') OR C.is_sys_admin=''1'') LIMIT 0, 1";\r\n		$db->query($sql);\r\n		if ($db->next_record()) {\r\n			// Frontenduser Login\r\n			$auth->auth[''name''] = $db->f(''name'');\r\n			$auth->auth[''surname''] = $db->f(''surname'');\r\n			$auth->auth[''group_name''] = $db->f(''groupname'');\r\n			$auth->auth[''group_desc''] = $db->f(''description'');\r\n			$auth->auth[''email''] = $db->f(''email'');\r\n			$auth->auth[''firm''] = $db->f(''firm'');\r\n			$auth->auth[''position''] = $db->f(''position'');\r\n			$auth->auth[''salutation''] = $db->f(''salutation'');\r\n			$auth->auth[''street''] = $db->f(''street'');\r\n			$auth->auth[''zip''] = $db->f(''zip'');\r\n			$auth->auth[''location''] = $db->f(''location'');\r\n			$auth->auth[''phone''] = $db->f(''phone'');\r\n			$auth->auth[''fax''] = $db->f(''fax'');\r\n			$auth->auth[''comment''] = $db->f(''comment'');\r\n			$auth->auth[''uid''] = $db->f(''user_id'');\r\n			$auth->auth[''uname''] = $username;\r\n			$auth->auth[''exp''] = time() + (60 * $auth->lifetime);\r\n			$auth->auth[''refresh''] = time() + (60 * $auth->refresh);\r\n			$sess->register(''auth'');\r\n			$sess->register(''sid_sniffer'');\r\n			$sess->freeze();\r\n			\r\n            // redirect\r\n    		$sf_idcatside_redirect = $mod[''redirect_login''];\r\n    		if ($sf_idcatside_redirect < 1) {\r\n    		  $sf_idcatside_redirect = $idcatside;\r\n    		}\r\n			sf_header_redirect($cfg_client[''contentfile'']."?lang=$lang&idcatside=$sf_idcatside_redirect&".$sess->name.''=''.$sess->id);\r\n		}\r\n	}\r\n\r\n	// Login fails\r\n	if ($auth->auth[''uid''] == ''nobody'') {\r\n		$mod[''throw_error''] = true;\r\n	}\r\n}\r\n\r\nif ($action == ''logout'') {\r\n	$auth->logout();\r\n	$sf_idcatside_redirect = $mod[''redirect_logout''];\r\n\r\n	if ($sf_idcatside_redirect > 0) {\r\n	    sf_header_redirect($cfg_client[''contentfile'']."?lang=$lang&idcatside=$sf_idcatside_redirect");\r\n	} else {\r\n        sf_header_redirect($cfg_client[''contentfile'']."?lang=$lang&idcatside=$idcatside");\r\n    }\r\n}\r\nif ($uid != ''nobody'') {\r\n    $auth->auth[''exp''] = time() + (60 * $auth->lifetime);\r\n}\r\n\r\n//tpl login\r\nif ($auth->auth[''uid''] == ''nobody'') {\r\n    $mod[''tpl_login_error''] = ($mod[''throw_error'']) ? $mod[''tpl_login_error'']:''''; \r\n\r\n	$mod[''usr_input''] = "<input type=\\"text\\" name=\\"username\\" value=\\"".htmlentities($username, ENT_COMPAT, ''UTF-8'')."\\" size=\\"10\\" maxlength=\\"32\\" ".$mod[''attributes_username'']." />\r\n							<input type=\\"hidden\\" name=\\"action\\" value=\\"login\\" />";\r\n    $mod[''pwd_input''] = "<input type=\\"password\\" name=\\"password\\" size=\\"10\\" maxlength=\\"32\\" ".$mod[''attributes_username'']." />";\r\n    \r\n    $mod[''tpl_form''] = $mod[''tpl_login''];\r\n	$mod[''tpl_form''] = str_replace(''{input_name}'', $mod[''usr_input''], $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{input_password}'', $mod[''pwd_input''], $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{input_password}'', $mod[''pwd_input''], $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{errortemplate}'', $mod[''tpl_login_error''], $mod[''tpl_form'']);\r\n	   \r\n//tpl logout\r\n} else {\r\n\r\n    if ($mod[''redirect_if_logged_in''] > 0 && $_REQUEST[''action''] != ''login'' && $_REQUEST[''action''] != ''logout'' &&\r\n    		( ($mod[''redirect_if_logged_in_and backend''] == ''true'' && $sess->name == ''sefrengo'')\r\n    		|| ($sess->name != ''sefrengo'') ) )\r\n    \r\n    {\r\n$addon = '''';\r\nif ($sess->name == ''sefrengo'')\r\n{\r\n  $addon = ''&view=''.$view;\r\n}\r\n        sf_header_redirect($cfg_client[''htmlpath''].$cfg_client[''contentfile'']."?lang=$lang&idcatside=".$mod[''redirect_if_logged_in''].$addon);\r\n    }\r\n    \r\n    $sf_user =& sf_factoryGetObject(''ADMINISTRATION'', ''User''); \r\n    $sf_user->loadByIduser( $auth->auth[''uid''] );\r\n	$mod[''tpl_form''] = $mod[''tpl_logout''];\r\n	$mod[''tpl_form''] = str_replace(''{id}'', $sf_user->getIduser(), $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{loginname}'', $sf_user->getUsername(), $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{name}'', $sf_user->getName(), $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{surname}'', $sf_user->getSurname(), $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{email}'', $sf_user->getEmail(), $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{firm}'', $sf_user->getFirm(), $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{position}'', $sf_user->getPosition(), $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{salutation}'', $sf_user->getSalutation(), $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{street}'', $sf_user->getStreet(), $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{zip}'', $sf_user->getZip(), $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{location}'', $sf_user->getLocation(), $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{phone}'', $sf_user->getPhone(), $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{fax}'', $sf_user->getFax(), $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{homepage}'', $sf_user->getHomepage(), $mod[''tpl_form'']);\r\n	$mod[''tpl_form''] = str_replace(''{comment}'', $sf_user->getComment(), $mod[''tpl_form'']);\r\n	\r\n    $mod[''timestamp_lastlogin''] = (int) $sf_user->getLastLoginTimestamp();\r\n    if ($mod[''timestamp_lastlogin''] > 0) {\r\n        $mod[''tpl_lastlogin''] = str_replace(''{lastlogin_date}'', date($mod[''dateformat''], $mod[''timestamp_lastlogin'']), $mod[''tpl_lastlogin'']);\r\n        $mod[''tpl_lastlogin''] = str_replace(''{lastlogin_time}'', date($mod[''timeformat''], $mod[''timestamp_lastlogin'']), $mod[''tpl_lastlogin'']);\r\n        $mod[''tpl_form''] = str_replace(''{lastlogin}'', $mod[''tpl_lastlogin''], $mod[''tpl_form'']);\r\n    } else {\r\n        $mod[''tpl_form''] = str_replace(''{lastlogin}'', $mod[''tpl_lastlogin_empty''], $mod[''tpl_form'']);\r\n    }\r\n    \r\n    $mod[''hidden_input''] = "<input type=\\"hidden\\" name=\\"action\\" value=\\"logout\\" />";\r\n	$mod[''tpl_form''] = str_replace(''{form_hiddenvals}'', $mod[''hidden_input''], $mod[''tpl_form'']);\r\n	\r\n    unset($sf_user);\r\n}\r\n\r\n$mod[''tpl_form''] = str_replace(''{form_attributes}'', "action=\\"".$con_side[$idcatside][''link'']."\\" method=\\"post\\" name=\\"login\\"", $mod[''tpl_form'']);\r\necho $mod[''tpl_form''];\r\nunset($mod);\r\n\r\n\r\n}\r\n</CMSPHP>\r\n', '', 0, 1, 1, 1079610875, 1215636782, 'mod:d56b699830e77ba53855679cb1d252da:a75a7742', '', '', '', 0, '', 'Login', '1');
INSERT INTO `cms_mod` VALUES (17, 'Info', '1.0', 'Tools', 'Zeigt allgemeine Informationen fr Seite, Ordner und andere Infos an.', '<?php\r\n// Schriftart normal\r\n$mip_form[''0''][''desc''] = $mod_lang[''gen_font''];\r\n$mip_form[''0''][''cat''] = ''app_css'';\r\n$mip_form[''0''][''output_cat''] = ''option'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''cms_val_default''] = ''font2'';\r\n$mip_form[''0''][''flag''] = ''class_only'';\r\n\r\n// Schriftart Infos\r\n$mip_form[''1''][''desc''] = $mod_lang[''gen_font''].'' der Infos'';\r\n$mip_form[''1''][''cat''] = ''app_css'';\r\n$mip_form[''1''][''output_cat''] = ''option'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''cms_val_default''] = ''font1'';\r\n$mip_form[''1''][''flag''] = ''class_only'';\r\n\r\n// Template\r\n$mip_form[''2''][''desc''] = ''Template'';\r\n$mip_form[''2''][''cat''] = ''txtarea'';\r\n$mip_form[''2''][''rows''] = ''6'';\r\n$mip_form[''2''][''type''] = ''long'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''cms_val_default''] = ''letzte nderung: am {lastmodified_date} um {lastmodified_time} Uhr von {authorname} {authorsurname}'';\r\n\r\nmip_formsp($mip_form[''0'']);\r\nmip_formsp($mip_form[''1'']);\r\nmip_formsp($mip_form[''2'']);\r\necho '' <small><b>Legende:</b><br>{author} ID des Redakteurs, {authorusername} Benutzerkennung des Redakteurs, {authorname} Vorname, {authorsurname} Nachname<br>{created} erstellt am, {created_date} erstellt am (Datum), {created_time} erstellt am (Uhrzeit)<br>{lastmodified} letzte nderung, {lastmodified_date} Datum, {lastmodified_time} Uhrzeit<br>{lastmodified_projekt} letzte nderung im Projekt, {lastmodified_projekt_date} Datum, {lastmodified_projekt_time} Uhrzeit<br>{name} Seitenname, {notes} Notizen, {summary} Kurzbeschreibung, {catname} Ordnername<br>{time} aktuelle Uhrzeit, {day} aktueller Tag, {date} aktuelles Datum<br>Falls Statistikplugin vorhanden: {visits} Anzahl Aufrufe der aktuellen Seite, {allvisits} Anzahl Aufrufe aller Seiten des Projekts<br> Php-Code: <CMSPHP> echo "Ich bin phpcode!"; </CMSPHP></small>'';\r\nunset($mip_form);\r\n?>', '<CMSPHP>\r\n<?PHP\r\nif ($cms_mod[''value''][1]) {\r\n               $formatting_front=''<span class="''.$cms_mod[''value''][1].''">'';\r\n               $formatting_end=''</span>'';\r\n} else {\r\n               $formatting_front='''';\r\n               $formatting_end='''';\r\n}\r\n$tpl[''code''] = str_replace(''{author}'', $formatting_front.$con_side[$idcatside][''author''].$formatting_end, $cms_mod[''value''][2]);\r\nif (strpos($tpl[''code''],''{authorusername}'')!==FALSE || strpos($tpl[''code''],''{authorname}'')!==FALSE || strpos($tpl[''code''],''{authorsurname}'')!==FALSE) {\r\n	$db->query(''SELECT username,name,surname FROM ''.$cms_db[''users''].'' WHERE user_id=''.$con_side[$idcatside][''author'']);\r\n	$db->next_record();\r\n	$tpl[''authorusername''] = $db->f(''username'');\r\n	$tpl[''authorname''] = $db->f(''name'');\r\n	$tpl[''authorsurname''] = $db->f(''surname'');\r\n}\r\n$tpl[''code''] = str_replace(''{authorusername}'', $formatting_front.$tpl[''authorusername''].$formatting_end, $tpl[''code'']);\r\n$tpl[''code''] = str_replace(''{authorname}'', $formatting_front.$tpl[''authorname''].$formatting_end, $tpl[''code'']);\r\n$tpl[''code''] = str_replace(''{authorsurname}'', $formatting_front.$tpl[''authorsurname''].$formatting_end, $tpl[''code'']);\r\n$tpl[''code''] = str_replace(''{created}'', $formatting_front.date($cfg_cms[''FormatDate''].'' ''.$cfg_cms[''FormatTime''], $con_side[$idcatside][''created'']).$formatting_end, $tpl[''code'']);\r\n$tpl[''code''] = str_replace(''{created_date}'', $formatting_front.date($cfg_cms[''FormatDate''], $con_side[$idcatside][''created'']).$formatting_end, $tpl[''code'']);\r\n$tpl[''code''] = str_replace(''{created_time}'', $formatting_front.date($cfg_cms[''FormatTime''], $con_side[$idcatside][''created'']).$formatting_end, $tpl[''code'']);\r\n$tpl[''code''] = str_replace(''{lastmodified}'', $formatting_front.date($cfg_cms[''FormatDate''].'' ''.$cfg_cms[''FormatTime''], $con_side[$idcatside][''lastmodified'']).$formatting_end, $tpl[''code'']);\r\n$tpl[''code''] = str_replace(''{lastmodified_date}'', $formatting_front.date($cfg_cms[''FormatDate''], $con_side[$idcatside][''lastmodified'']).$formatting_end, $tpl[''code'']);\r\n$tpl[''code''] = str_replace(''{lastmodified_time}'', $formatting_front.date($cfg_cms[''FormatTime''], $con_side[$idcatside][''lastmodified'']).$formatting_end, $tpl[''code'']);\r\nif ((strpos($tpl[''code''],''{lastmodified_projekt}'')!==FALSE) || (strpos($tpl[''code''],''{lastmodified_projekt_date}'')!==FALSE) || (strpos($tpl[''code''],''{lastmodified_projekt_time}'')!==FALSE)) {\r\n  $db->query(''SELECT max(''.$cms_db[''content''].''.lastmodified) as lastmodified FROM ''.\r\n      $cms_db[''content''].'', ''.$cms_db[''container''].'', ''.$cms_db[''tpl''].'' WHERE ''.\r\n      $cms_db[''content''].''.container=''.$cms_db[''container''].''.container AND ''.\r\n      $cms_db[''container''].''.idtpl=''.$cms_db[''tpl''].''.idtpl AND ''.$cms_db[''tpl''].\r\n      ''.idclient=''.$client);\r\n  $db->next_record();\r\n  $tpl[''lastmodified''] = ($db->affected_rows()) ? $db->f(''lastmodified'') : $con_side[$idcatside][''lastmodified''];\r\n  $tpl[''code''] = str_replace(''{lastmodified_projekt}'', $formatting_front.date($cfg_cms[''FormatDate''].'' ''.$cfg_cms[''FormatTime''], $tpl[''lastmodified'']).$formatting_end, $tpl[''code'']);\r\n  $tpl[''code''] = str_replace(''{lastmodified_projekt_date}'', $formatting_front.date($cfg_cms[''FormatDate''], $tpl[''lastmodified'']).$formatting_end, $tpl[''code'']);\r\n  $tpl[''code''] = str_replace(''{lastmodified_projekt_time}'', $formatting_front.date($cfg_cms[''FormatTime''], $tpl[''lastmodified'']).$formatting_end, $tpl[''code'']);\r\n}\r\n$tpl[''code''] = str_replace("\\''","''", addslashes($tpl[''code'']));\r\n$tpl[''code''] = str_replace(''{name}'', str_replace("\\''","''", addslashes($formatting_front)).''".$con_side[$idcatside][\\''name\\'']."''.str_replace("\\''","''", addslashes($formatting_end)), $tpl[''code'']);\r\n$tpl[''code''] = str_replace(''{summary}'', str_replace("\\''","''", addslashes($formatting_front)).''".$con_side[$idcatside][\\''meta_description\\'']."''.str_replace("\\''","''", addslashes($formatting_end)), $tpl[''code'']);\r\n$tpl[''code''] = str_replace(''{notes}'', str_replace("\\''","''", addslashes($formatting_front)).''".$con_side[$idcatside][\\''summary\\'']."''.str_replace("\\''","''", addslashes($formatting_end)), $tpl[''code'']);\r\n$tpl[''code''] = str_replace(''{catname}'', str_replace("\\''","''", addslashes($formatting_front)).''".$con_tree[$idcat][\\''name\\'']."''.str_replace("\\''","''", addslashes($formatting_end)), $tpl[''code'']);\r\n$tpl[''code''] = str_replace(''{time}'', str_replace("\\''","''", addslashes($formatting_front)).''".date(\\''H:i\\'', time())."''.str_replace("\\''","''", addslashes($formatting_end)), $tpl[''code'']);\r\nif (strpos($tpl[''code''],''{visits}'')!==FALSE) {\r\n?>\r\n	// $cms_db[''stat''] is set automatically by cms in backend/config.php at install. Make sure it is correct!\r\n	$db->query(''SELECT visited FROM ''.$cms_db[''stat''].'' WHERE idcatside=''.$idcatside);\r\n	$db->next_record();\r\n	if ($db->affected_rows()) $tpl[''visits''] = $db->f(''visited'');\r\n         else $tpl[''visits''] = ''0'';\r\n<?PHP\r\n	$tpl[''code''] = str_replace(''{visits}'', str_replace("\\''","''", addslashes($formatting_front)).''".$tpl[\\''visits\\'']."''.str_replace("\\''","''", addslashes($formatting_end)), $tpl[''code'']);\r\n}\r\nif (strpos($tpl[''code''],''{allvisits}'')!==FALSE) {\r\n?>\r\n	$db->query(''SELECT SUM(visited) AS allvisited FROM ''.$cms_db[''stat''].'' WHERE idclient=''.$client);\r\n	$db->next_record();\r\n	if ($db->affected_rows()) $tpl[''allvisits''] = $db->f(''allvisited'');\r\n	else $tpl[''allvisits''] = ''0'';\r\n<?PHP\r\n	$tpl[''code''] = str_replace(''{allvisits}'', str_replace("\\''","''", addslashes($formatting_front)).''".$tpl[\\''allvisits\\'']."''.str_replace("\\''","''", addslashes($formatting_end)), $tpl[''code'']);\r\n}\r\nif (strpos($tpl[''code''],''{day}'')!==FALSE) {\r\n?>\r\n	$mod[''day''] = array(''Sonntag'', ''Montag'', ''Dienstag'', ''Mittwoch'', ''Donnerstag'', ''Freitag'', ''Samstag'');\r\n<?PHP\r\n	$tpl[''code''] = str_replace(''{day}'', str_replace("\\''","''", addslashes($formatting_front)).''".$mod[\\''day\\''][date(\\''w\\'')]."''.str_replace("\\''","''", addslashes($formatting_end)), $tpl[''code'']);\r\n}\r\nif (strpos($tpl[''code''],''{date}'')!==FALSE) {\r\n?>\r\n	$mod[''month''] = array('''', ''Januar'', ''Februar'', ''M&auml;rz'', ''April'', ''Mai'', ''Juni'', ''Juli'', ''August'', ''September'', ''Oktober'', ''November'', ''Dezember'');\r\n<?PHP\r\n	$tpl[''code''] = str_replace(''{date}'', str_replace("\\''","''", addslashes($formatting_front)).''".date(\\''d\\'', time()).\\''. \\''.$mod[\\''month\\''][date(\\''n\\'')].\\'' \\''.date(\\''Y\\'', time())."''.str_replace("\\''","''", addslashes($formatting_end)), $tpl[''code'']);\r\n}\r\nif ($cms_mod[''value''][0]) echo ''eval(" ?><span class=\\"''.$cms_mod[''value''][0].''\\">''.$tpl[''code''].''</span>");''."\\n";\r\nelse echo ''eval(" ?>''.$tpl[''code''].''");''."\\n";\r\n?>\r\nunset($tpl, $mod);\r\n</CMSPHP>', '', 0, 1, 1, 1066927900, 1110584067, 'mod:caf9b6b99962bf5c2264824231d7a40c:93adc4cc', '', '', '', 0, '', 'Info', '1');
INSERT INTO `cms_mod` VALUES (18, 'Entwicklervariablen', '1.3', 'Tools', '', '', '<table cellspacing="1" cellpadding="2" bgcolor="#BBC2CE" border="0">\r\n  <tr>\r\n    <td class="Verdana-10px-bold" bgcolor="#F7F7F7">Beschreibung</td>\r\n    <td class="Verdana-10px-bold" bgcolor="#F7F7F7">Variablenname</td>\r\n    <td class="Verdana-10px-bold" bgcolor="#F7F7F7">Inhalt</td>\r\n  </tr>\r\n<CMSPHP>\r\necho ''  <tr>''."\\n";\r\necho ''    <td colspan="3" class="Verdana-10px-bold" bgcolor="#FFFFFF">Eintrge aus der project0x/cms/inc/config.php</td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF"><font color="#666666">Systempfad zum Backend</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">$cms_path:string</td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">''.$cms_path.''</td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF"><font color="#666666">ID des eingestellten Projektes</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">$client:string</td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">''.$client.''</td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF"><font color="#666666">ID der voreingestellten Sprache</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">$startlang:string</td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">''.$startlang.''</td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td colspan="3" class="Verdana-10px-bold" bgcolor="#FFFFFF">aktuelle Variablen</td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF"><font color="#666666">ID der aktuellen Sprache</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">$lang:string</td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">''.$lang.''</td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF"><font color="#666666">ID des aktuellen Ordners</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">$idcat:string</td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">''.$idcat.''</td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF"><nobr><font color="#666666">aktuellen Seite ohne Ordnerzuweisung</font></nobr></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">$idside:string</td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">''.$idside.''</td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF"><font color="#666666">ID der aktuellen Seite mit Ordnerzuweisung</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">$idcatside:string</td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">''.$idcatside.''</td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF"><font color="#666666">aktuelle Session</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">$sid:string</td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">''.$sid.''</td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF"><font color="#666666">ID des aktuellen Layouts</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">$idlay:string</td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">''.$idlay.''</td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF"><font color="#666666">ID der aktuellen Templatevorlage</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">$idtpl:string</td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF">''.$idtpl.''</td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF" valign="top"><font color="#666666">Namen der Datenbanktabellen</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF" valign="top">$cms_db:array</td>''."\\n";\r\necho ''    <td style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px;" bgcolor="#FFFFFF"><pre>'';\r\n$mod[''tmp''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\nprint_r($cms_db);\r\n$mod[''array''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\necho $mod[''tmp''].htmlspecialchars($mod[''array''], ENT_COMPAT, ''UTF-8'');\r\nunset($mod[''tmp''],$mod[''array'']);\r\necho ''</pre></td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF" valign="top"><font color="#666666">Userinformationen</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF" valign="top">$auth->auth:array</td>''."\\n";\r\necho ''    <td style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px;" bgcolor="#FFFFFF"><pre>'';\r\n$mod[''tmp''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\nprint_r($auth->auth);\r\n$mod[''array''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\necho $mod[''tmp''].htmlspecialchars($mod[''array''], ENT_COMPAT, ''UTF-8'');\r\nunset($mod[''tmp''],$mod[''array'']);\r\necho ''</pre></td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF" valign="top"><font color="#666666">Allgemeine Einstellungen</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF" valign="top">$cfg_cms:array</td>''."\\n";\r\necho ''    <td style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px;" bgcolor="#FFFFFF"><pre>'';\r\n$mod[''tmp''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\nprint_r($cfg_cms);\r\n$mod[''array''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\necho $mod[''tmp''].htmlspecialchars($mod[''array''], ENT_COMPAT, ''UTF-8'');\r\nunset($mod[''tmp''],$mod[''array'']);\r\necho ''</pre></td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF" valign="top"><font color="#666666">Projekteinstellungen</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF" valign="top">$cfg_client:array</td>''."\\n";\r\necho ''    <td style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px;" bgcolor="#FFFFFF"><pre>'';\r\n$mod[''tmp''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\nprint_r($cfg_client);\r\n$mod[''array''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\necho $mod[''tmp''].htmlspecialchars($mod[''array''], ENT_COMPAT, ''UTF-8'');\r\nunset($mod[''tmp''],$mod[''array'']);\r\necho ''</pre></td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF" valign="top"><font color="#666666">aktuelles Layout</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF" valign="top">$layout:array</td>''."\\n";\r\necho ''    <td style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px;" bgcolor="#FFFFFF"><pre>'';\r\n$mod[''tmp''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\nprint_r($layout);\r\n$mod[''array''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\necho $mod[''tmp''].htmlspecialchars($mod[''array''], ENT_COMPAT, ''UTF-8'');\r\nunset($mod[''tmp''],$mod[''array'']);\r\necho ''</pre></td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF" valign="top"><font color="#666666">enthlt alle Informationen ber die Ordner</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF" valign="top">$con_tree:array</td>''."\\n";\r\necho ''    <td style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px;" bgcolor="#FFFFFF"><pre>'';\r\n$mod[''tmp''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\nprint_r($con_tree);\r\n$mod[''array''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\necho $mod[''tmp''].htmlspecialchars($mod[''array''], ENT_COMPAT, ''UTF-8'');\r\nunset($mod[''tmp''],$mod[''array'']);\r\necho ''</pre></td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF" valign="top"><font color="#666666">Sortierung von $con_tree</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF" valign="top">$catlist:array</td>''."\\n";\r\necho ''    <td style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px;" bgcolor="#FFFFFF"><pre>'';\r\n$mod[''tmp''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\nprint_r($catlist);\r\n$mod[''array''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\necho $mod[''tmp''].htmlspecialchars($mod[''array''], ENT_COMPAT, ''UTF-8'');\r\nunset($mod[''tmp''],$mod[''array'']);\r\necho ''</pre></td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF" valign="top"><font color="#666666">Einrckung der Ordner</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF" valign="top">$catlist_level:array</td>''."\\n";\r\necho ''    <td style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px;" bgcolor="#FFFFFF"><pre>'';\r\n$mod[''tmp''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\nprint_r($catlist_level);\r\n$mod[''array''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\necho $mod[''tmp''].htmlspecialchars($mod[''array''], ENT_COMPAT, ''UTF-8'');\r\nunset($mod[''tmp''],$mod[''array'']);\r\necho ''</pre></td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF" valign="top"><font color="#666666">enthlt alle Informationen ber die Seiten</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF" valign="top">$con_side:array</td>''."\\n";\r\necho ''    <td style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px;" bgcolor="#FFFFFF"><pre>'';\r\n$mod[''tmp''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\nprint_r($con_side);\r\n$mod[''array''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\necho $mod[''tmp''].htmlspecialchars($mod[''array''], ENT_COMPAT, ''UTF-8'');\r\nunset($mod[''tmp''],$mod[''array'']);\r\necho ''</pre></td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF" valign="top"><font color="#666666">Konfiguration der cms-Tags im Layout</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF" valign="top">$list:array</td>''."\\n";\r\necho ''    <td style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px;" bgcolor="#FFFFFF"><pre>'';\r\n$mod[''tmp''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\nprint_r($list);\r\n$mod[''array''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\necho $mod[''tmp''].htmlspecialchars($mod[''array''], ENT_COMPAT, ''UTF-8'');\r\nunset($mod[''tmp''],$mod[''array'']);\r\necho ''</pre></td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF" valign="top"><font color="#666666">Inhalte aller Container</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF" valign="top">$container:array</td>''."\\n";\r\necho ''    <td style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px;" bgcolor="#FFFFFF"><pre>'';\r\n$mod[''tmp''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\nprint_r($container);\r\n$mod[''array''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\necho $mod[''tmp''].htmlspecialchars($mod[''array''], ENT_COMPAT, ''UTF-8'');\r\nunset($mod[''tmp''],$mod[''array'']);\r\necho ''</pre></td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF" valign="top"><font color="#666666">aktuelle Sprachbersetzungen</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF" valign="top">$cms_lang:array</td>''."\\n";\r\necho ''    <td style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px;" bgcolor="#FFFFFF"><pre>'';\r\n$mod[''tmp''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\nprint_r($cms_lang);\r\n$mod[''array''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\necho $mod[''tmp''].htmlspecialchars($mod[''array''], ENT_COMPAT, ''UTF-8'');\r\nunset($mod[''tmp''],$mod[''array'']);\r\necho ''</pre></td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td colspan="3" class="Verdana-10px-bold" bgcolor="#FFFFFF">Eintrge, die besonders fr die Modulprogrammierung wichtig sind</td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF" valign="top"><font color="#666666">aktuelle Sprachbersetzungen</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF" valign="top">$mod_lang:array</td>''."\\n";\r\necho ''    <td style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px;" bgcolor="#FFFFFF"><pre>'';\r\n$mod[''tmp''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\nprint_r($mod_lang);\r\n$mod[''array''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\necho $mod[''tmp''].htmlspecialchars($mod[''array''], ENT_COMPAT, ''UTF-8'');\r\nunset($mod[''tmp''],$mod[''array'']);\r\necho ''</pre></td>''."\\n";\r\necho ''  </tr>''."\\n";\r\necho ''  <tr>''."\\n";\r\necho ''    <td class="Verdana-10px-bold" bgcolor="#FFFFFF" valign="top"><font color="#666666">Konfiguration des Moduls</font></td>''."\\n";\r\necho ''    <td class="Verdana-10px" bgcolor="#FFFFFF" valign="top">$cms_mod:array</td>''."\\n";\r\necho ''    <td style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px;" bgcolor="#FFFFFF"><pre>'';\r\n$mod[''tmp''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\nprint_r($cms_mod);\r\n$mod[''array''] = ob_get_contents ();\r\nob_end_clean ();\r\nob_start();\r\necho $mod[''tmp''].htmlspecialchars($mod[''array''], ENT_COMPAT, ''UTF-8'');\r\nunset($mod[''tmp''],$mod[''array'']);\r\necho ''</pre></td>''."\\n";\r\necho ''  </tr>''."\\n";\r\nunset($mod);\r\n</CMSPHP>\r\n</table>', NULL, 0, 1, 1, 1066927900, 1125074743, 'mod:d11670cae9abe9707e1aca88e9534196:ce1ea26d', '', '', '', 0, '', '', '1');
INSERT INTO `cms_mod` VALUES (19, 'CacheControl', '1.0', 'Tools', 'Lscht gecachte Seiten nach XXX- Sekunden', '<?PHP\r\n$mip_form[''1''][''cat''] = ''txt'';\r\n$mip_form[''1''][''desc''] = ''Cache wir alle X Sekunden gelscht<br><small>86400 Sekunden entspricht 24 Stunden</small>'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''cms_val_default''] = ''86400'';\r\n\r\nmip_formsp($mip_form[''1'']);\r\nunset($mip_form);\r\n?>', '<cms:mod type = "cache" expires="MOD_VALUE[1]" />', NULL, 0, 1, 1, 1066927900, 1083623684, 'mod:cc9d03f1b60e292d96f8f3e6f6ebf440:b698ef0d', '', '', '', 0, '', NULL, '1');
INSERT INTO `cms_mod` VALUES (20, 'CMSTAG Eingabefeld', '1.3', 'Content', 'Gibt die Mglichkeit, CMS:TAGs, CMSPHP und gecachtes PHP innerhalb der Templatekonfiguration einzugeben.', '<?PHP\r\n//configmode\r\n$mip_form[''13''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''13''][''cat''] = ''option'';\r\n$mip_form[''13''][''size''] = ''1'';\r\n$mip_form[''13''][''option_desc''][] = ''Normal'';\r\n$mip_form[''13''][''option_val''][] =  '''';\r\n$mip_form[''13''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''13''][''option_val''][] =  ''hidden'';\r\n$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n$mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n$mip_form[''13''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''13'']);//configmode\r\n$mip_form[''hide_in_standard_mode''] = array(0);\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''13''] == ''hidden''){\r\n  foreach($cms_mod[''value''] AS $ke=>$va){\r\n    if($ke != ''13''){\r\n    ?>\r\n      <input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n    <?php\r\n     }\r\n  }\r\n}\r\n//simple and advanced config\r\nelse if($cms_mod[''value''][''13''] == ''''){\r\n\r\n\r\n// Template\r\n$mip_form[''0''][''desc''] = ''Template'';\r\n$mip_form[''0''][''cat''] = ''txtarea'';\r\n$mip_form[''0''][''rows''] = ''20'';\r\n$mip_form[''0''][''type''] = ''long'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''cms_val_default''] = ''<cms:mod type="wysiwyg" id="1">'';\r\n\r\nmip_formsp($mip_form[''0'']);\r\n}\r\nunset($mip_form);\r\n\r\n?>', '<cms:mod constant="tagmode" />MOD_VALUE[0]\r\n', '', 0, 1, 1, 1066927900, 1125070309, 'mod:e51c54f98b5032ea90502cd725250c05:17f87c22', '', '', '', 0, '0', '', '1');
INSERT INTO `cms_mod` VALUES (22, 'Suchmodul', '1.3', 'Interaktion', 'Umfangreiche Volltextsuche. XHTML- konform', '<?php\r\n\r\n//configmode\r\n$mip_form[''99''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''99''][''cat''] = ''option'';\r\n$mip_form[''99''][''size''] = ''1'';\r\n$mip_form[''99''][''option_desc''][] = ''Normal'';\r\n$mip_form[''99''][''option_val''][] =  '''';\r\n$mip_form[''99''][''option_desc''][] = ''Erweitert'';\r\n$mip_form[''99''][''option_val''][] =  ''advanced'';\r\n$mip_form[''99''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''99''][''option_val''][] =  ''hidden'';\r\n$mip_form[''99''][''cms_var''] = ''MOD_VAR[99]'';\r\n$mip_form[''99''][''cms_val''] = $cms_mod[''value''][''99''];\r\n$mip_form[''99''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''99'']);//configmode\r\n$mip_form[''hide_in_standard_mode''] = array(26,22,23,24,25,37,30,31,32,33,34,35,36,38);\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''99''] == ''hidden''){\r\n  foreach($cms_mod[''value''] AS $ke=>$va){\r\n    if($ke != ''99''){\r\n    ?>\r\n      <input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n    <?php\r\n     }\r\n  }\r\n}\r\n//simple, advanced and all config (not hidden config)\r\nelse if($cms_mod[''value''][''99''] == '''' || $cms_mod[''value''][''99''] == ''advanced''){\r\n\r\n\r\n\r\n// Schriftart Link/Titel\r\n$mip_form[''0''][''desc''] = $mod_lang[''gen_font'']." Link/Titel";\r\n$mip_form[''0''][''cat''] = ''app_css'';\r\n$mip_form[''0''][''output_cat''] = ''option'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''flag''] = ''class_only'';\r\n\r\n// Schriftart Beschreibung\r\n$mip_form[''1''][''desc''] = $mod_lang[''gen_font'']." Beschreibung";\r\n$mip_form[''1''][''cat''] = ''app_css'';\r\n$mip_form[''1''][''output_cat''] = ''option'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''flag''] = ''class_only'';\r\n\r\n// Schriftart Feldbezeichner\r\n$mip_form[''2''][''desc''] = $mod_lang[''gen_font'']." Feldbezeichner";\r\n$mip_form[''2''][''cat''] = ''app_css'';\r\n$mip_form[''2''][''output_cat''] = ''option'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''flag''] = ''class_only'';\r\n\r\n// Schriftart Eingabefelder\r\n$mip_form[''3''][''desc''] = $mod_lang[''gen_font'']." Eingabefelder";\r\n$mip_form[''3''][''cat''] = ''app_css'';\r\n$mip_form[''3''][''output_cat''] = ''option'';\r\n$mip_form[''3''][''cms_var''] = ''MOD_VAR[3]'';\r\n$mip_form[''3''][''cms_val''] = $cms_mod[''value''][''3''];\r\n$mip_form[''3''][''flag''] = ''class_only'';\r\n\r\n// Schriftart Fehlermeldung\r\n$mip_form[''4''][''desc''] = $mod_lang[''gen_font'']." Fehlermeldung";\r\n$mip_form[''4''][''cat''] = ''app_css'';\r\n$mip_form[''4''][''output_cat''] = ''option'';\r\n$mip_form[''4''][''cms_var''] = ''MOD_VAR[4]'';\r\n$mip_form[''4''][''cms_val''] = $cms_mod[''value''][''4''];\r\n$mip_form[''4''][''flag''] = ''class_only'';\r\n\r\n// Schriftart Navigation\r\n$mip_form[''5''][''desc''] = $mod_lang[''gen_font'']." Navigation";\r\n$mip_form[''5''][''cat''] = ''app_css'';\r\n$mip_form[''5''][''output_cat''] = ''option'';\r\n$mip_form[''5''][''cms_var''] = ''MOD_VAR[5]'';\r\n$mip_form[''5''][''cms_val''] = $cms_mod[''value''][''5''];\r\n$mip_form[''5''][''flag''] = ''class_only'';\r\n\r\n// ----------------------------------------------------------------------------\r\n\r\n// Formulartemplate\r\n$mip_form[''6''][''cat''] = ''option'';\r\n$mip_form[''6''][''type''] = '''';\r\n$mip_form[''6''][''desc''] = ''Suchformular: <small>{modus [titel]}</small>'';\r\n$mip_form[''6''][''cms_var''] = ''MOD_VAR[6]'';\r\n$mip_form[''6''][''cms_val''] = $cms_mod[''value''][''6''];\r\n$mip_form[''6''][''cms_val_default''] = ''1'';\r\n$mip_form[''6''][''option_desc''][''0''] = ''kein Formular'';\r\n$mip_form[''6''][''option_val''][''0''] = ''none'';\r\n$mip_form[''6''][''option_desc''][''1''] = ''Template 1'';\r\n$mip_form[''6''][''option_val''][''1''] = ''1'';\r\n$mip_form[''6''][''option_desc''][''2''] = ''Template 2'';\r\n$mip_form[''6''][''option_val''][''2''] = ''2'';\r\n\r\n// Suchen in\r\n$mip_form[''7''][''cat''] = ''chk'';\r\n$mip_form[''7''][''type''] = '''';\r\n$mip_form[''7''][''desc''] = ''Felder durchsuchen: <small>{where}</small>'';\r\n$mip_form[''7''][''option_desc''][''0''] = ''Titel'';\r\n$mip_form[''7''][''option_var''][''0''] = ''MOD_VAR[70]'';\r\n$mip_form[''7''][''option_val''][''0''] = $cms_mod[''value''][''70''];\r\n$mip_form[''7''][''option_val_select''][''0''] = ''B.title'';\r\n$mip_form[''7''][''option_desc''][''1''] = ''Notizen'';\r\n$mip_form[''7''][''option_var''][''1''] = ''MOD_VAR[71]'';\r\n$mip_form[''7''][''option_val''][''1''] = $cms_mod[''value''][''71''];\r\n$mip_form[''7''][''option_val_select''][''1''] = ''B.summary'';\r\n$mip_form[''7''][''option_desc''][''2''] = ''Beschreibung'';\r\n$mip_form[''7''][''option_var''][''2''] = ''MOD_VAR[72]'';\r\n$mip_form[''7''][''option_val''][''2''] = $cms_mod[''value''][''72''];\r\n$mip_form[''7''][''option_val_select''][''2''] = ''B.meta_description'';\r\n$mip_form[''7''][''option_desc''][''3''] = ''Keywords'';\r\n$mip_form[''7''][''option_var''][''3''] = ''MOD_VAR[73]'';\r\n$mip_form[''7''][''option_val''][''3''] = $cms_mod[''value''][''73''];\r\n$mip_form[''7''][''option_val_select''][''3''] = ''B.meta_keywords'';\r\n$mip_form[''7''][''option_desc''][''4''] = ''Textbody'';\r\n$mip_form[''7''][''option_var''][''4''] = ''MOD_VAR[74]'';\r\n$mip_form[''7''][''option_val''][''4''] = $cms_mod[''value''][''74''];\r\n$mip_form[''7''][''option_val_select''][''4''] = ''A.value'';\r\n\r\n// Ausgabe von\r\n$mip_form[''8''][''cat''] = ''option'';\r\n$mip_form[''8''][''type''] = '''';\r\n$mip_form[''8''][''desc''] = ''Im Ergebnis mit anzeigen: <small>{what}</small>'';\r\n$mip_form[''8''][''cms_var''] = ''MOD_VAR[8]'';\r\n$mip_form[''8''][''cms_val''] = $cms_mod[''value''][''8''];\r\n$mip_form[''8''][''cms_val_default''] = ''body'';\r\n$mip_form[''8''][''option_desc''][''0''] = ''keine'';\r\n$mip_form[''8''][''option_val''][''0''] = ''none'';\r\n$mip_form[''8''][''option_desc''][''1''] = ''Notizen'';\r\n$mip_form[''8''][''option_val''][''1''] = ''summary'';\r\n$mip_form[''8''][''option_desc''][''2''] = ''Beschreibung'';\r\n$mip_form[''8''][''option_val''][''2''] = ''meta_description'';\r\n$mip_form[''8''][''option_desc''][''3''] = ''Textausschnitt'';\r\n$mip_form[''8''][''option_val''][''3''] = ''body'';\r\n\r\n// Suchvariante\r\n$mip_form[''9''][''cat''] = ''option'';\r\n$mip_form[''9''][''type''] = '''';\r\n$mip_form[''9''][''desc''] = ''logische Verbindung: <small>{how}</small>'';\r\n$mip_form[''9''][''cms_var''] = ''MOD_VAR[9]'';\r\n$mip_form[''9''][''cms_val''] = $cms_mod[''value''][''9''];\r\n$mip_form[''9''][''cms_val_default''] = ''AND'';\r\n$mip_form[''9''][''option_desc''][''0''] = ''UND'';\r\n$mip_form[''9''][''option_val''][''0''] = ''AND'';\r\n$mip_form[''9''][''option_desc''][''1''] = ''ODER'';\r\n$mip_form[''9''][''option_val''][''1''] = ''OR'';\r\n$mip_form[''9''][''option_desc''][''2''] = ''exakt'';\r\n$mip_form[''9''][''option_val''][''2''] = ''QUOT'';\r\n\r\n// Sortieren nach\r\n$mip_form[''10''][''cat''] = ''option'';\r\n$mip_form[''10''][''type''] = '''';\r\n$mip_form[''10''][''desc''] = ''Sortieren nach: <small>{sort}</small>'';\r\n$mip_form[''10''][''cms_var''] = ''MOD_VAR[10]'';\r\n$mip_form[''10''][''cms_val''] = $cms_mod[''value''][''10''];\r\n$mip_form[''10''][''cms_val_default''] = ''C.idcatside'';\r\n$mip_form[''10''][''option_desc''][''0''] = ''Index'';\r\n$mip_form[''10''][''option_val''][''0''] = ''C.idcatside'';\r\n$mip_form[''10''][''option_desc''][''1''] = ''Titel'';\r\n$mip_form[''10''][''option_val''][''1''] = ''B.title'';\r\n$mip_form[''10''][''option_desc''][''2''] = ''Notizen'';\r\n$mip_form[''10''][''option_val''][''2''] = ''B.summary'';\r\n$mip_form[''10''][''option_desc''][''3''] = ''Beschreibung'';\r\n$mip_form[''10''][''option_val''][''3''] = ''B.meta_description'';\r\n$mip_form[''10''][''option_desc''][''4''] = ''Keywords'';\r\n$mip_form[''10''][''option_val''][''4''] = ''B.meta_keywords'';\r\n\r\n// Ergebnisse pro Seite\r\n$mip_form[''11''][''cat''] = ''txt'';\r\n$mip_form[''11''][''type''] = '''';\r\n$mip_form[''11''][''desc''] = ''Ergebnisse pro Seite: <small>(0 = alle)</small>'';\r\n$mip_form[''11''][''cms_var''] = ''MOD_VAR[11]'';\r\n$mip_form[''11''][''cms_val''] = $cms_mod[''value''][''11''];\r\n$mip_form[''11''][''cms_val_default''] = ''5'';\r\n\r\n// Ausgabe-Ziel\r\n$mip_form[''12''][''cat''] = ''txt'';\r\n$mip_form[''12''][''type''] = '''';\r\n$mip_form[''12''][''desc''] = ''Ausgabeziel: <small>(idcatside angeben [0=hier])</small>'';\r\n$mip_form[''12''][''cms_var''] = ''MOD_VAR[12]'';\r\n$mip_form[''12''][''cms_val''] = $cms_mod[''value''][''12''];\r\n$mip_form[''12''][''cms_val_default''] = ''0'';\r\n\r\n// ----------------------------------------------------------------------------\r\n\r\n// Suchformular 1\r\n$mip_form[''13''][''cat''] = ''txtarea'';\r\n$mip_form[''13''][''rows''] = ''3'';\r\n$mip_form[''13''][''type''] = ''long'';\r\n$mip_form[''13''][''desc''] = ''Suchformular Template 1:<br><small>{search},{submit},{where},{what},{how},{sort},{modus [titel]}</small>'';\r\n$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n$mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n$mip_form[''13''][''cms_val_default''] = ''{search} {submit} {modus [Erweitert]}'';\r\n\r\n// Suchformular 2\r\n$mip_form[''14''][''cat''] = ''txtarea'';\r\n$mip_form[''14''][''rows''] = ''3'';\r\n$mip_form[''14''][''type''] = ''long'';\r\n$mip_form[''14''][''desc''] = ''Suchformular Template 2:<br><small>{search},{submit},{where},{what},{how},{sort},{modus\r\n [titel]}</small>'';\r\n$mip_form[''14''][''cms_var''] = ''MOD_VAR[14]'';\r\n$mip_form[''14''][''cms_val''] = $cms_mod[''value''][''14''];\r\n$mip_form[''14''][''cms_val_default''] = ''{search} {submit} {modus [Einfach]}<br />\r\n{where}<br />zustzlich anzeigen:<br />\r\n{what}<br />Suchmethode:<br />\r\n{how}<br />Sortierung:<br />\r\n{sort}'';\r\n\r\n// Liste pre\r\n$mip_form[''15''][''cat''] = ''txtarea'';\r\n$mip_form[''15''][''rows''] = ''1'';\r\n$mip_form[''15''][''type''] = ''long'';\r\n$mip_form[''15''][''desc''] = ''vor der Ergebnisliste<br><small>{count}</small>'';\r\n$mip_form[''15''][''cms_var''] = ''MOD_VAR[15]'';\r\n$mip_form[''15''][''cms_val''] = $cms_mod[''value''][''15''];\r\n$mip_form[''15''][''cms_val_default''] = ''<p>Insgesamt <strong>{count}</strong> Seiten gefunden</p>'';\r\n\r\n// Liste\r\n$mip_form[''16''][''cat''] = ''txtarea'';\r\n$mip_form[''16''][''rows''] = ''1'';\r\n$mip_form[''16''][''type''] = ''long'';\r\n$mip_form[''16''][''desc''] = ''Ergebnis:<br><small>{nr},{link},{descr}</small>'';\r\n$mip_form[''16''][''cms_var''] = ''MOD_VAR[16]'';\r\n$mip_form[''16''][''cms_val''] = $cms_mod[''value''][''16''];\r\n$mip_form[''16''][''cms_val_default''] = ''{nr}. <strong>{link}</strong>{descr}'';\r\n\r\n// Liste post\r\n$mip_form[''17''][''cat''] = ''txtarea'';\r\n$mip_form[''17''][''rows''] = ''1'';\r\n$mip_form[''17''][''type''] = ''long'';\r\n$mip_form[''17''][''desc''] = ''nach der Ergebnisliste'';\r\n$mip_form[''17''][''cms_var''] = ''MOD_VAR[17]'';\r\n$mip_form[''17''][''cms_val''] = $cms_mod[''value''][''17''];\r\n$mip_form[''17''][''cms_val_default''] = ''<hr  />'';\r\n\r\n\r\n// Navigation\r\n$mip_form[''18''][''cat''] = ''txtarea'';\r\n$mip_form[''18''][''rows''] = ''3'';\r\n$mip_form[''18''][''type''] = ''long'';\r\n$mip_form[''18''][''desc''] = ''Navigation:<br><small>{nav}</small>'';\r\n$mip_form[''18''][''cms_var''] = ''MOD_VAR[18]'';\r\n$mip_form[''18''][''cms_val''] = $cms_mod[''value''][''18''];\r\n$mip_form[''18''][''cms_val_default''] = ''{nav}'';\r\n\r\n// Seite nicht gefunden\r\n$mip_form[''19''][''cat''] = ''txt'';\r\n$mip_form[''19''][''type''] = ''long'';\r\n$mip_form[''19''][''desc''] = ''Meldung keine Suchergebnisse:'';\r\n$mip_form[''19''][''cms_var''] = ''MOD_VAR[19]'';\r\n$mip_form[''19''][''cms_val''] = $cms_mod[''value''][''19''];\r\n$mip_form[''19''][''cms_val_default''] = ''Es wurden keine Seiten gefunden die Ihrer Anfrage entsprechen'';\r\n\r\n\r\n// Suche nur in dieser Sprache\r\n$mip_form[''20''][''cat''] = ''chk'';\r\n$mip_form[''20''][''type''] = '''';\r\n$mip_form[''20''][''desc''] = ''Suche auf alle Sprachen ausdehnen'';\r\n$mip_form[''20''][''option_var''][''0''] = ''MOD_VAR[20]'';\r\n$mip_form[''20''][''option_val''][''0''] = $cms_mod[''value''][''20''];\r\n$mip_form[''20''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''20''][''option_val_select''][''0''] = ''true'';\r\n\r\n\r\n// Absenden Button\r\n$mip_form[''21''][''cat''] = ''txt'';\r\n$mip_form[''21''][''type''] = ''long'';\r\n$mip_form[''21''][''desc''] = ''Absende Button (Suche):'';\r\n$mip_form[''21''][''cms_var''] = ''MOD_VAR[21]'';\r\n$mip_form[''21''][''cms_val''] = $cms_mod[''value''][''21''];\r\n$mip_form[''21''][''cms_val_default''] = ''Suche'';\r\n\r\n\r\n// ----------------------------------------------------------------------------\r\n\r\n$mip_form[''26''][''cat''] = ''desc'';\r\n$mip_form[''26''][''type''] = '''';\r\n$mip_form[''26''][''desc''] = "<hr /><strong>Ein- / Ausschlieen:</strong><br />";\r\n$mip_form[''26''][''tab''] = ''0'';\r\n\r\n// Optionen\r\n$mip_form[''22''][''cat''] = ''option'';\r\n$mip_form[''22''][''type''] = '''';\r\n$mip_form[''22''][''desc''] = ''Seiten und Ordner aus der Suche auszuschlieen'';\r\n$mip_form[''22''][''cms_var''] = ''MOD_VAR[22]'';\r\n$mip_form[''22''][''cms_val''] = $cms_mod[''value''][''22''];\r\n$mip_form[''22''][''cms_val_default''] = ''all'';\r\n$mip_form[''22''][''option_desc''][''0''] = ''Alle erlauben, einige verbieten'';\r\n$mip_form[''22''][''option_val''][''0''] = ''all'';\r\n$mip_form[''22''][''option_desc''][''1''] = ''Alle verbieten, einige erlauben'';\r\n$mip_form[''22''][''option_val''][''1''] = ''none'';\r\n\r\n// Erlaubte/ Verbotene Kategorien\r\n$mip_form[''23''][''desc''] = ''Erlaubte / Verbotene Kategorien <br>Die Auswahl Root entspricht keiner Auswahl'';\r\n$mip_form[''23''][''cat''] = ''app_cat'';\r\n$mip_form[''23''][''output_cat''] = ''option'';\r\n$mip_form[''23''][''without_this_cat''] = true;\r\n$mip_form[''23''][''cms_var''] = ''MOD_VAR[23]'';\r\n$mip_form[''23''][''cms_val''] = $cms_mod[''value''][''23''];\r\n$mip_form[''23''][''cms_val_default''] = ''root'';\r\n$mip_form[''23''][''flag''] = ''multiple'';\r\n$mip_form[''23''][''size''] = ''5'';\r\n\r\n// Erlaubte/ Verbotene Seiten\r\n$mip_form[''24''][''cat''] = ''txt'';\r\n$mip_form[''24''][''type''] = '''';\r\n$mip_form[''24''][''desc''] = ''Erlaubte/ Verbotene Seiten <small>kommagetrennt anhand idcatside eintragen</small>'';\r\n$mip_form[''24''][''cms_var''] = ''MOD_VAR[24]'';\r\n$mip_form[''24''][''cms_val''] = $cms_mod[''value''][''24''];\r\n$mip_form[''24''][''cms_val_default''] = ''0'';\r\n\r\n//Featureauswahl\r\n$mip_form[''25''][''desc''] = ''Eingrenzung der Suche auf bestimmte Contenttypen'';\r\n$mip_form[''25''][''cat''] = ''option'';\r\n$mip_form[''25''][''flag''] = ''multiple'';\r\n$mip_form[''25''][''size''] = ''7'';\r\n$mip_form[''25''][''cms_var''] = ''MOD_VAR[25]'';\r\n$mip_form[''25''][''cms_val''] = $cms_mod[''value''][''25''];\r\n$mip_form[''25''][''cms_val_default''] = ''true'';\r\n$mip_form[''25''][''option_desc''][] = ''Alle Felder durchsuchen'';\r\n$mip_form[''25''][''option_val''][] =  ''true'';\r\n$mip_form[''25''][''option_desc''][] = ''text'';\r\n$mip_form[''25''][''option_val''][] =  ''1'';\r\n$mip_form[''25''][''option_desc''][] = ''textarea'';\r\n$mip_form[''25''][''option_val''][] =  ''3'';\r\n$mip_form[''25''][''option_desc''][] = ''wysiwyg'';\r\n$mip_form[''25''][''option_val''][] =  ''2'';\r\n$mip_form[''25''][''option_desc''][] = ''wysiwyg2'';\r\n$mip_form[''25''][''option_val''][] =  ''13'';\r\n$mip_form[''25''][''option_desc''][] = ''link'';\r\n$mip_form[''25''][''option_val''][] =  ''7'';\r\n$mip_form[''25''][''option_desc''][] = ''file'';\r\n$mip_form[''25''][''option_val''][] =  ''11'';\r\n$mip_form[''25''][''option_desc''][] = ''sourcecode'';\r\n$mip_form[''25''][''option_val''][] =  ''9'';\r\n\r\n// ----------------------------------------------------------------------------\r\n\r\n$mip_form[''37''][''cat''] = ''desc'';\r\n$mip_form[''37''][''type''] = '''';\r\n$mip_form[''37''][''desc''] = "<hr /><strong>Navigation</strong>";\r\n$mip_form[''37''][''tab''] = ''0'';\r\n\r\n// vor/zurck-links anzeigen\r\n$mip_form[''30''][''desc''] = ''Vor/Zur&uuml;ck-Links anzeigen'';\r\n$mip_form[''30''][''cat''] = ''option'';\r\n$mip_form[''30''][''cms_var''] = ''MOD_VAR[30]'';\r\n$mip_form[''30''][''cms_val''] = $cms_mod[''value''][''30''];\r\n$mip_form[''30''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''30''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''30''][''option_val''][''0''] = ''true'';\r\n$mip_form[''30''][''option_val''][''1''] = ''false'';\r\n$mip_form[''30''][''cms_val_default''] = ''true'';\r\n\r\n//\r\n\r\n// vor/zurck-linktexte definieren\r\nif ($cms_mod[''value''][''30''] == ''true'') {\r\n        // zurck-link\r\n        $mip_form[''33''][''desc''] = "Zurck-Linktext";\r\n        $mip_form[''33''][''cat''] = ''txt'';\r\n        $mip_form[''33''][''cms_var''] = ''MOD_VAR[33]'';\r\n        $mip_form[''33''][''cms_val''] = $cms_mod[''value''][''33''];\r\n        $mip_form[''33''][''cms_val_default''] = ''&lt;&lt;'';\r\n\r\n        // weiter-link\r\n        $mip_form[''34''][''desc''] = "Weiter-Linktext";\r\n        $mip_form[''34''][''cat''] = ''txt'';\r\n        $mip_form[''34''][''cms_var''] = ''MOD_VAR[34]'';\r\n        $mip_form[''34''][''cms_val''] = $cms_mod[''value''][''34''];\r\n        $mip_form[''34''][''cms_val_default''] = ''&gt;&gt;'';\r\n} else {\r\n        // zurck-link\r\n        $mip_form[''33''][''cat''] = ''hidden'';\r\n        $mip_form[''33''][''cms_var''] = ''MOD_VAR[33]'';\r\n        $mip_form[''33''][''cms_val''] = $cms_mod[''value''][''33''];\r\n        $mip_form[''33''][''cms_val_default''] = ''&lt;&lt;'';\r\n\r\n        // weiter-link\r\n        $mip_form[''34''][''cat''] = ''hidden'';\r\n        $mip_form[''34''][''cms_var''] = ''MOD_VAR[34]'';\r\n        $mip_form[''34''][''cms_val''] = $cms_mod[''value''][''34''];\r\n        $mip_form[''34''][''cms_val_default''] = ''&gt;&gt;'';\r\n}\r\n\r\n// anzahl der angezeigten Seitenlinks\r\n$mip_form[''31''][''desc''] = "Navigation: <small>(0 = Floating aus, 1-n = Max. angezeigter Links)</small>\\n";\r\n$mip_form[''31''][''cat''] = ''txt'';\r\n$mip_form[''31''][''cms_var''] = ''MOD_VAR[31]'';\r\n$mip_form[''31''][''cms_val''] = $cms_mod[''value''][''31''];\r\n$mip_form[''31''][''cms_val_default''] = ''0'';\r\n\r\n// separatoren\r\n$mip_form[''32''][''desc''] = "Separator zwischen den Seitenlinks <small>(leer = default-separator)</small>";\r\n$mip_form[''32''][''cat''] = ''txt'';\r\n$mip_form[''32''][''cms_var''] = ''MOD_VAR[32]'';\r\n$mip_form[''32''][''cms_val''] = $cms_mod[''value''][''32''];\r\n$mip_form[''32''][''cms_val_default''] = '''';\r\n\r\n// Aktuelle Galerieseite verlinken?\r\n$mip_form[''38''][''desc''] = ''Soll die aktuelle Seite in der Navigation verlinkt werden?'';\r\n$mip_form[''38''][''cat''] = ''option'';\r\n$mip_form[''38''][''cms_var''] = ''MOD_VAR[38]'';\r\n$mip_form[''38''][''cms_val''] = $cms_mod[''value''][''38''];\r\n$mip_form[''38''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''38''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''38''][''option_val''][''0''] = ''true'';\r\n$mip_form[''38''][''option_val''][''1''] = ''false'';\r\n$mip_form[''38''][''cms_val_default''] = ''true'';\r\n\r\n//\r\n//Schriftart 2\r\n$mip_form[''35''][''desc''] = $mod_lang[''gen_font'']." {font2} (Seitenlink in der Navigation+weiter (>>) in Navi)";\r\n$mip_form[''35''][''cat''] = ''app_css'';\r\n$mip_form[''35''][''output_cat''] = ''option'';\r\n$mip_form[''35''][''cms_var''] = ''MOD_VAR[35]'';\r\n$mip_form[''35''][''cms_val''] = $cms_mod[''value''][''35''];\r\n\r\n//Schriftart 3\r\n$mip_form[''36''][''desc''] = $mod_lang[''gen_font'']." {font3} (Aktueller Seitenlink in der Navigation)<BR><BR>\\n";\r\n$mip_form[''36''][''cat''] = ''app_css'';\r\n$mip_form[''36''][''output_cat''] = ''option'';\r\n$mip_form[''36''][''cms_var''] = ''MOD_VAR[36]'';\r\n$mip_form[''36''][''cms_val''] = $cms_mod[''value''][''36''];\r\n\r\n\r\n// Liste pre\r\n$mip_form[''40''][''cat''] = ''txtarea'';\r\n$mip_form[''40''][''rows''] = ''1'';\r\n$mip_form[''40''][''type''] = ''long'';\r\n$mip_form[''40''][''desc''] = ''Einleitung der Suche'';\r\n$mip_form[''40''][''cms_var''] = ''MOD_VAR[40]'';\r\n$mip_form[''40''][''cms_val''] = $cms_mod[''value''][''40''];\r\n$mip_form[''40''][''cms_val_default''] = '''';\r\n\r\n// Liste post\r\n$mip_form[''41''][''cat''] = ''txtarea'';\r\n$mip_form[''41''][''rows''] = ''1'';\r\n$mip_form[''41''][''type''] = ''long'';\r\n$mip_form[''41''][''desc''] = ''Ende der Suche'';\r\n$mip_form[''41''][''cms_var''] = ''MOD_VAR[41]'';\r\n$mip_form[''41''][''cms_val''] = $cms_mod[''value''][''41''];\r\n$mip_form[''41''][''cms_val_default''] = '''';\r\n\r\n// ----------------------------------------------------------------------------\r\n\r\n$mip_form[''28''][''cat''] = ''desc'';\r\n$mip_form[''28''][''type''] = '''';\r\n$mip_form[''28''][''desc''] = "<B><U>CSS-Einstellungen</U></B><BR>";\r\n$mip_form[''28''][''tab''] = ''0'';\r\n\r\n$mip_form[''29''][''cat''] = ''desc'';\r\n$mip_form[''29''][''type''] = '''';\r\n$mip_form[''29''][''desc''] = "<hr /><strong>Voreinstellungen</strong><br />";\r\n$mip_form[''29''][''tab''] = ''0'';\r\n\r\n$mip_form[''27''][''cat''] = ''desc'';\r\n$mip_form[''27''][''type''] = '''';\r\n$mip_form[''27''][''desc''] = "<hr /><strong>Templates:</strong><br />";\r\n$mip_form[''27''][''tab''] = ''0'';\r\n\r\n\r\n// Ausgabe\r\n\r\n//if simple mode\r\nif($cms_mod[''value''][''99''] == ''''){\r\n   foreach ($mip_form[''hide_in_standard_mode'']  AS $ke=>$va){\r\n     $mip_form[$va][''cat''] = ''hidden'';\r\n   }\r\n }\r\n\r\n\r\nmip_formsp($mip_form[''28'']);	// Beschreibung\r\nmip_formsp($mip_form[''0'']);\r\nmip_formsp($mip_form[''1'']);\r\nmip_formsp($mip_form[''2'']);\r\nmip_formsp($mip_form[''3'']);\r\nmip_formsp($mip_form[''4'']);\r\nmip_formsp($mip_form[''5'']);\r\n\r\nmip_formsp($mip_form[''29'']);	// Beschreibung\r\nmip_formsp($mip_form[''6'']);\r\nmip_formsp($mip_form[''7'']);\r\nmip_formsp($mip_form[''8'']);\r\nmip_formsp($mip_form[''9'']);\r\nmip_formsp($mip_form[''10'']);\r\nmip_formsp($mip_form[''11'']);\r\nmip_formsp($mip_form[''12'']);\r\nmip_formsp($mip_form[''20'']);\r\nmip_formsp($mip_form[''21'']);\r\n\r\nmip_formsp($mip_form[''27'']);	// Beschreibung\r\nmip_formsp($mip_form[''13'']);\r\necho "<br>";\r\nmip_formsp($mip_form[''14'']);\r\necho "<br>";\r\nmip_formsp($mip_form[''15'']);\r\nmip_formsp($mip_form[''16'']);\r\nmip_formsp($mip_form[''17'']);\r\necho "<br>";\r\nmip_formsp($mip_form[''18'']);\r\nmip_formsp($mip_form[''19'']);\r\n\r\nmip_formsp($mip_form[''26'']);	// Beschreibung\r\nmip_formsp($mip_form[''22'']);\r\nmip_formsp($mip_form[''23'']);\r\nmip_formsp($mip_form[''24'']);\r\nmip_formsp($mip_form[''25'']);\r\n\r\nmip_formsp($mip_form[''37'']);	// Beschreibung\r\nmip_formsp($mip_form[''30'']);\r\nmip_formsp($mip_form[''33'']);\r\nmip_formsp($mip_form[''34'']);\r\nmip_formsp($mip_form[''31'']);\r\nmip_formsp($mip_form[''32'']);\r\nmip_formsp($mip_form[''38'']);\r\nmip_formsp($mip_form[''35'']);\r\nmip_formsp($mip_form[''36'']);\r\nmip_formsp($mip_form[''40'']);\r\nmip_formsp($mip_form[''41'']);\r\n\r\n\r\n// ----------------------------------------------------------------------------\r\n}\r\nunset($mip_form);\r\n?>', '<CMSPHP>\r\ninclude_once($cms_path.''inc/fnc.search.php'');\r\n\r\n//  zur Fehlersuche\r\n//if(isset($test))\r\n//{\r\n//    $mod[''test''] = "true";\r\n//}\r\n\r\n##########################################################################################################################\r\n\r\necho "MOD_VALUE[40]";\r\n\r\nif ( !function_exists(''suchmodul_createPageLinks'') ) {\r\nfunction suchmodul_createPageLinks($isFloating, $separator, $showNavLinks,$id) {\r\n        global $mod, $cfg_client, $idcatside, $cms_mod;\r\n        if ($isFloating > 0) {\r\n                $floatdiff = ceil($isFloating / 2);\r\n\r\n                $start = $id - $floatdiff;\r\n                if ($start > $mod["anz"]) $start = $mod["anz"] - $floatdiff;\r\n                if ($start < 1) $start = 1;\r\n\r\n                $stop = $id + $floatdiff;\r\n                if ($stop > $mod["anz"]) $stop = $mod["anz"];\r\n        } else {\r\n                $start = 1;\r\n                $stop = $mod["anz"];\r\n        }\r\n\r\n        if ($id > 1 && $showNavLinks == ''true'') {\r\n                $previd = $id - 1;\r\n                $returnvalue .= "\\n<a href=\\"".$mod[''idcatlink'']."&amp;page=".$previd.$mod[''query'']."\\">MOD_VALUE[33]</a>\\n";\r\n        }\r\n\r\n        for ( $mod["pagecounter"] = $start; $mod["pagecounter"] <= $stop; $mod["pagecounter"]++ )\r\n        {\r\n                if ($mod["pagecounter"] > $start) $returnvalue .= $separator;\r\n                if ($mod["pagecounter"] == $id) {\r\n                       if ("MOD_VALUE[38]" == ''false''){\r\n                        $returnvalue .= "<span class=\\"MOD_VALUE[36]\\" >[".$mod["pagecounter"]."]</span>";\r\n                        } else {\r\n                        $returnvalue .= "\\n<a class=\\"MOD_VALUE[36]\\" href=\\"".$mod[''idcatlink'']."&amp;page=".$mod["pagecounter"].$mod[''query'']."\\">[".$mod["pagecounter"]."]</a>";\r\n                        }\r\n                } else {\r\n                        $returnvalue .= "\\n<a class=\\"MOD_VALUE[35]\\" href=\\"".$mod[''idcatlink'']."&amp;page=".$mod["pagecounter"].$mod[''query'']."\\">".$mod["pagecounter"]."</a>";\r\n                }\r\n        }\r\n\r\n        if ($id < $mod["anz"] && $showNavLinks == ''true'') {\r\n                $nextid = $id + 1;\r\n                $returnvalue .= "\\n<a class=\\"MOD_VALUE[35]\\" href=\\"".$mod[''idcatlink'']."&amp;page=".$nextid.$mod[''query'']."\\">MOD_VALUE[34]</a>";\r\n        }\r\n        return $returnvalue;\r\n}  // end function\r\n\r\n} // end if exist\r\n\r\n\r\n\r\n###########################\r\n\r\n\r\n//catch global vals\r\n$sf_wr =& $GLOBALS[''sf_factory'']->getObject(''HTTP'', ''WebRequest'');\r\n$suche = $sf_wr->getVal(''suche''); \r\n\r\n\r\n$mod[''hidden''] = "";\r\nif("MOD_VALUE[6]" != "none"){\r\n        // Suchformular aufbauen\r\n        if(!$modus)\r\n        {\r\n                $modus = "MOD_VALUE[6]";\r\n                $mod[''newmodus''] = false;\r\n        } else {\r\n                $mod[''newmodus''] = true;\r\n        }\r\n        if($modus == "1"){ $mod[''tpl_form''] = "MOD_VALUE[13]"; $mod[''xmodus''] = "2";} else { $mod[''tpl_form''] = "MOD_VALUE[14]"; $mod[''xmodus''] = "1";}\r\n        $mod[''tpl_form''] = str_replace("{search}","\\n<input type=''text'' name=''suche'' value=''$suche'' class=''MOD_VALUE[3]'' />",$mod[''tpl_form'']);\r\n        $mod[''tpl_form''] = str_replace("{submit}","\\n<input type=''submit'' value=''MOD_VALUE[21]'' class=''button'' />",$mod[''tpl_form'']);\r\n        if ($suche == "") {\r\n        	$mod[''tpl_form''] = preg_replace("/\\{modus \\[([^\\]]+)\\]\\}/","\\n<a class=''MOD_VALUE[5]'' href=''".$con_side[$idcatside][''link'']."&amp;modus=".$mod[''xmodus'']."''>\\\\1</a>",$mod[''tpl_form'']);\r\n        } else {\r\n        	$mod[''tpl_form''] = preg_replace("/\\{modus \\[([^\\]]+)\\]\\}/","\\n<a class=''MOD_VALUE[5]'' href=''".$con_side[$idcatside][''link'']."&amp;suche=$suche&amp;modus=".$mod[''xmodus'']."&amp;w_70=$w_70&amp;w_71=$w_71&amp;w_72=$w_72&amp;w_73=$w_73&amp;w_74=$w_74''>\\\\1</a>",$mod[''tpl_form'']);\r\n        }\r\n        // where - Suche in folgenden Feldern\r\n        if(strstr($mod[''tpl_form''],"{where}")){\r\n                $mod[''repl_string''] = "\\n<input type=''checkbox'' name=''w_70'' id=''w_70'' value=''B.title'' ";\r\n                if($w_70 || ("MOD_VALUE[70]" != "" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= "checked=\\"checked\\"";}\r\n                $mod[''repl_string''] .=" /><label class=''MOD_VALUE[2]'' for=''w_70''> Titel</label><br />\\n<input type=''checkbox'' name=''w_71'' id=''w_71'' value=''B.summary'' ";\r\n                if($w_71 || ("MOD_VALUE[71]" != "" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= "checked=\\"checked\\"";}\r\n                $mod[''repl_string''] .=" /><label class=''MOD_VALUE[2]'' for=''w_71''> Notizen</label><br />\\n<input type=''checkbox'' name=''w_72'' id=''w_72'' value=''B.meta_description'' ";\r\n                if($w_72 || ("MOD_VALUE[72]" != "" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= "checked=\\"checked\\"";}\r\n                $mod[''repl_string''] .=" /><label class=''MOD_VALUE[2]'' for=''w_72''> Beschreibung</label><br />\\n<input type=''checkbox'' name=''w_73'' id=''w_73'' value=''B.meta_keywords'' ";\r\n                if($w_73 || ("MOD_VALUE[73]" != "" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= "checked=\\"checked\\"";}\r\n                $mod[''repl_string''] .=" /><label class=''MOD_VALUE[2]'' for=''w_73''> Schlsselwrter</label><br />\\n<input type=''checkbox'' name=''w_74'' id=''w_74'' value=''A.value'' ";\r\n                if($w_74 || ("MOD_VALUE[74]" != "" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= "checked=\\"checked\\"";}\r\n                $mod[''repl_string''] .=" /><label class=''MOD_VALUE[2]'' for=''w_74''> Seiteninhalt</label>\\n";\r\n\r\n                $mod[''tpl_form''] = str_replace("{where}",$mod[''repl_string''],$mod[''tpl_form'']);\r\n        } else {\r\n                $mod[''hidden''] .= "<input type=''hidden'' name=''w_70'' value=''MOD_VALUE[70]'' />\\n<input type=''hidden'' name=''w_71'' value=''MOD_VALUE[71]'' />";\r\n                $mod[''hidden''] .= "\\n<input type=''hidden'' name=''w_72'' value=''MOD_VALUE[72]'' />\\n<input type=''hidden'' name=''w_73'' value=''MOD_VALUE[73]'' />";\r\n                $mod[''hidden''] .= "\\n<input type=''hidden'' name=''w_74'' value=''MOD_VALUE[74]'' />";\r\n        }\r\n        // what - zusaetzlich anzeigen\r\n        if(strstr($mod[''tpl_form''],"{what}")){\r\n                $mod[''repl_string''] = "\\n<select name=''what''>\\n<option value=''none''";\r\n                if($what == "none" || ("MOD_VALUE[8]" == "none" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= " selected=''selected''"; }\r\n                $mod[''repl_string''] .= ">Nichts</option>\\n<option value=''summary''";\r\n                if($what == "summary" || ("MOD_VALUE[8]" == "summary" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= " selected=''selected''"; }\r\n                $mod[''repl_string''] .= ">Notizen</option>\\n<option value=''meta_description''";\r\n                if($what == "meta_description" || ("MOD_VALUE[8]" == "meta_description" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= " selected=''selected''"; }\r\n                $mod[''repl_string''] .= ">Beschreibung</option>\\n<option value=''body''";\r\n                if($what == "body" || ("MOD_VALUE[8]" == "body" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= " selected=''selected''"; }\r\n                $mod[''repl_string''] .= ">Textausschnitt</option>\\n</select>";\r\n                $mod[''tpl_form''] = str_replace("{what}",$mod[''repl_string''],$mod[''tpl_form'']);\r\n        } else {\r\n                $mod[''hidden''] .= "\\n<input type=''hidden'' name=''what'' value=''MOD_VALUE[8]'' />\\n";\r\n        }\r\n        // how - logische Verbindung\r\n        if(strstr($mod[''tpl_form''],"{how}")){\r\n                $mod[''repl_string''] = "<select name=''how''>\\n<option value=''AND''";\r\n                if($how == "AND" || ("MOD_VALUE[9]" == "AND" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= " selected=''selected''"; }\r\n                $mod[''repl_string''] .= ">\\nUND</option>\\n<option value=''OR''";\r\n                if($how == "OR" || ("MOD_VALUE[9]" == "OR" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= " selected=''selected''"; }\r\n                $mod[''repl_string''] .= ">\\nODER</option><option value=''QUOT''";\r\n                if($how == "QUOT" || ("MOD_VALUE[9]" == "QUOT" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= " selected=''selected''"; }\r\n                $mod[''repl_string''] .= ">exakt</option>\\n</select>";\r\n                $mod[''tpl_form''] = str_replace("{how}",$mod[''repl_string''],$mod[''tpl_form'']);\r\n        } else {\r\n                $mod[''hidden''] .= "\\n<input type=''hidden'' name=''how'' value=''MOD_VALUE[9]'' />\\n";\r\n        }\r\n        // sort - Sortierungsoption\r\n        if(strstr($mod[''tpl_form''],"{sort}")){\r\n                $mod[''repl_string''] = "<select name=''sort''>\\n<option value=''C.idcatside''";\r\n                if($sort == "C.idcatside" || ("MOD_VALUE[10]" == "C.idcatside" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= " selected=''selected''"; }\r\n                $mod[''repl_string''] .= ">Index</option>\\n<option value=''B.title''";\r\n                if($sort == "B.title" || ("MOD_VALUE[10]" == "B.title" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= " selected=''selected''"; }\r\n                $mod[''repl_string''] .= ">Titel</option>\\n<option value=''B.summary''";\r\n                if($sort == "B.summary" || ("MOD_VALUE[10]" == "B.summary" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= " selected=''selected''"; }\r\n                $mod[''repl_string''] .= ">Notizen</option>\\n<option value=''B.meta_description''";\r\n                if($sort == "B.meta_description" || ("MOD_VALUE[10]" == "B.meta_description" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= " selected=''selected''"; }\r\n                $mod[''repl_string''] .= ">Beschreibung</option>\\n<option value=''B.meta_keywords''";\r\n                if($sort == "B.meta_keywords" || ("MOD_VALUE[10]" == "B.meta_keywords" && ( $mod[''newmodus''] || !$suche ))){ $mod[''repl_string''] .= " selected=''selected''"; }\r\n                $mod[''repl_string''] .= ">Schlsselwrter</option>\\n</select>";\r\n                $mod[''tpl_form''] = str_replace("{sort}",$mod[''repl_string''],$mod[''tpl_form'']);\r\n        } else {\r\n                $mod[''hidden''] .= "\\n<input type=''hidden'' name=''sort'' value=''MOD_VALUE[10]'' />\\n";\r\n        }\r\n        echo "\\n<form action=''";\r\n        if("MOD_VALUE[12]" != "0"){ echo $con_side[''MOD_VALUE[12]''][''link'']; } else { echo $con_side[$idcatside][''link'']; }\r\n        echo "'' method=''post''>\\n<div>\\n".$mod[''tpl_form''].$mod[''hidden'']."\\n<input type=''hidden'' name=''page'' value=''1'' /><input type=''hidden'' name=''modus'' value=''".$modus."'' />\\n</div>\\n</form>\\n";\r\n}\r\nif(strlen($suche) > 0){\r\n        $mod[''tpl_output''] = "";\r\n        // Die uebergebenen Werte ueberpruefen\r\n        if (!($w_70 == "B.title" OR $w_70 == "")) { $w_70 ="B.title"; }\r\n        if (!($w_71 == "B.summary" OR $w_71 == "")) { $w_71 ="B.summary"; }\r\n        if (!($w_72 == "B.meta_description" OR $w_72 == "")) { $w_72 ="B.meta_description"; }\r\n        if (!($w_73 == "B.meta_keywords" OR $w_73 == "")) { $w_73 ="B.meta_keywords"; }\r\n        if (!($w_74 == "A.value" OR $w_74 == "")) { $w_74 ="A.value"; }\r\n        //$what ueberpruefen\r\n        if (! in_array($what,array("none","summary","meta_description","body"))) {\r\n                $what = "body";\r\n        }\r\n        //$how ueberpruefen\r\n        if (! in_array($how,array("AND","OR","QUOT"))) {\r\n                $how = "AND";\r\n        }\r\n        //$sort ueberpruefen\r\n        if (! in_array($sort,array("C.idcatside","B.title","B.summary","B.meta_description","B.meta_keywords"))) {\r\n                $sort = "C.idcatside";\r\n        }\r\n        $mod[''sql_fields''] = implode(",",array_diff(array($w_70,$w_71,$w_72,$w_73,$w_74),array("")));\r\n        switch($what){\r\n                case "none": $mod[''get_fields'']    = "B.title,C.idcatside"; break;\r\n                case "summary": $mod[''get_fields''] = "B.title,C.idcatside,B.summary"; break;\r\n                case "meta_description": $mod[''get_fields''] = "B.title,C.idcatside,B.meta_description"; break;\r\n                case "body": $mod[''get_fields'']    = "B.title,C.idcatside,A.value"; break;\r\n        }\r\n        if("MOD_VALUE[11]" == "0"){\r\n                $mod[''res_limit''] = "";\r\n                $mod[''res_start''] = "";\r\n        } else {\r\n                $mod[''res_limit''] = "MOD_VALUE[11]";\r\n                if($page < 1 || !$page)\r\n                        {\r\n                                $page = "1";\r\n                                $mod[''res_start''] = 0;\r\n                        } else {\r\n                                if (! is_numeric($page))\r\n                                {\r\n                                        $mod[''res_start''] = 0;\r\n                                } else {\r\n                                        $mod[''res_start''] = ($page-1) * "MOD_VALUE[11]";\r\n                                }\r\n                        }\r\n        }\r\n\r\n                if ($mod[''test''] == "true") {echo "<hr />Diverses: [22]:MOD_VALUE[22] [23]:MOD_VALUE[23] [20]:MOD_VALUE[20]<br />";}\r\n\r\n        \r\n// Suche auf Seiten beschraenken fals erwuenscht\r\n        $mod[''sql_sidecat''] = "";\r\n        if(''MOD_VALUE[22]'' == ''none'') {\r\n                // alle Seiten/Kategorien ausschlissen bis auf die Ausgewaehlten\r\n                if("MOD_VALUE[23]" != "" AND (substr_count("MOD_VALUE[23]","root")==0)) {\r\n                        $mod[''sql_sidecat''] = "(C.idcat IN (MOD_VALUE[23]))";\r\n                }\r\n                if("MOD_VALUE[24]" != "" AND (substr_count("MOD_VALUE[24]","root")==0)) {\r\n                        if($mod[''sql_sidecat''] == "") {\r\n                                $mod[''sql_sidecat''] = " AND (C.idcatside IN (MOD_VALUE[24]))";\r\n                        } else {\r\n                                $mod[''sql_sidecat''] = " AND (".$mod[''sql_sidecat'']." OR (C.idcatside IN (MOD_VALUE[24])) )";\r\n                        }\r\n                } else {\r\n                        if($mod[''sql_sidecat''] != "") {\r\n                                $mod[''sql_sidecat''] = " AND ".$mod[''sql_sidecat''];\r\n                        }\r\n                }\r\n        } else {\r\n                // alle Seiten/Kategorien erlaube bis auf die Ausgewaehlten\r\n                if("MOD_VALUE[23]" != "" AND (substr_count("MOD_VALUE[23]","root")==0)) {\r\n                        $mod[''sql_sidecat''] .= " AND (C.idcat NOT IN (MOD_VALUE[23]))";\r\n                }\r\n                if("MOD_VALUE[24]" != "" AND (substr_count("MOD_VALUE[24]","root")==0)) {\r\n                        $mod[''sql_sidecat''] .= " AND (C.idcatside NOT IN (MOD_VALUE[24]))";\r\n                }\r\n        }\r\n\r\n        // Suche auf die aktuelle Sprache beschraenken fals erwuenscht\r\n        if("MOD_VALUE[20]" == "true") {\r\n                $mod[''sql_lang''] = "";\r\n        } else {\r\n                $mod[''sql_lang''] = " AND (B.idlang = ".$lang.")";\r\n        }\r\n\r\n        // im Backend alle Seiten durchsuchen im Frontend nur die Seiten die Online sind und auf die er berechtigung hat.\r\n        if($sess->name == ''cms'') {\r\n                $mod[''sql_online''] = "";\r\n        } else {\r\n                $mod[''sql_online''] = " AND (  (B.online & 0x03) = 0x01 OR (  (B.online & 0x02) = 0x02 AND ( UNIX_TIMESTAMP(NOW()) BETWEEN B.start AND B.end))) ";\r\n\r\n                // Abfrage Recht: Darf geschuetzte Seiten sehen\r\n                $mod[''sql_online''] .=  ( $perm->have_perm(2, ''area_frontend'', 0) ) ?  '''': '' AND (B.online & 0x04) = 0x00 '';\r\n        }\r\n\r\n        if(("MOD_VALUE[25]" != "") AND (substr_count("MOD_VALUE[25]","true")==0)) {\r\n                $mod[''sql_content''] = " AND (A.idtype IN (MOD_VALUE[25]))";\r\n        } else {\r\n                $mod[''sql_content''] = " AND (A.idtype IN (1,2,3,7,9,11,13))";\r\n        }\r\n\r\n        if ($mod[''test''] == "true") {echo "<hr />Kontrolle:".implode('','',$_POST)." --> GET 70:".$w_70." 71:".$w_71." 72:".$w_72." 73:".$w_73." 74:".$w_74."<br />lang: ".$lang." sql: ".$mod[''sql_lang''];}\r\n        if ($mod[''test''] == "true") {echo "<br />Suche: $suche<br />Suche in: ".$mod[''sql_fields'']."<br />Hole: ".$mod[''get_fields'']."<br />Verbinde: $how<br />Sortiere: $sort<br />Page: ".$mod[''res_start''].",".$mod[''res_limit''];}\r\n        if ($mod[''test''] == "true") {echo "<br />sql_where:".$mod[''sql_lang''].$mod[''sql_online''].$mod[''sql_content''].$mod[''sql_sidecat'']."<br /><hr />";}\r\n        $result = search(array(\r\n                        "querystring" => $suche,\r\n                        "sql_tables"  => $cms_db[''content'']." A, ".$cms_db[''side_lang'']." B, ".$cms_db[''cat_side'']." C,".$cms_db[''side'']." D",\r\n                        "sql_fields"  => $mod[''sql_fields''],\r\n                        "get_fields"  => $mod[''get_fields''],\r\n                        "sql_where"   => "A.idsidelang = B.idsidelang AND B.idside = C.idside AND B.idside = D.idside AND D.idclient = ".$client.$mod[''sql_lang''].$mod[''sql_online''].$mod[''sql_content''].$mod[''sql_sidecat''],\r\n                        "sql_group"   => "C.idcatside",\r\n                        "result_limit"=> $mod[''res_limit''],\r\n                        "result_start"=> $mod[''res_start''],\r\n                        "sort_index"  => $sort,\r\n                        "default_con" => $how\r\n                        )\r\n        );\r\n        // Wir brauchen die Seiten, die wir ausschliessen wollen\r\n        if ($mod[''test''] == "true") {echo "num_rows: ".$result[''num_rows'']."<hr />";}\r\n\r\n        $mod[''nr''] = $mod[''res_start'']+1;\r\n        if($result[''num_rows''] > 0){\r\n                foreach($result[''result''] as $mod[''res'']){\r\n                        if ($mod[''test''] == "true") {echo "Kontrolle Result<br />IDcatside: ".$mod[''res''][''idcatside'']."<br />Title: ".$mod[''res''][''title'']."<br>Nr: ".$mod[''nr'']."<hr />";}\r\n                        $mod[''repl_string''] = "\\n<a href=''".$con_side[$mod[''res''][''idcatside'']][''link'']."'' class=''MOD_VALUE[0]''>".$mod[''res''][''title'']."</a>\\n";\r\n                        $mod[''tpl_res''] = str_replace("{link}",$mod[''repl_string''],"MOD_VALUE[16]");\r\n                        if($what == "none"){\r\n                                $mod[''repl_string''] = "";\r\n                        } elseif($what == "summary"){\r\n                                $mod[''repl_string''] = "<p class=''MOD_VALUE[1]''>".$mod[''res''][''summary'']."</p>";\r\n                        } elseif($what == "meta_description"){\r\n                                $mod[''repl_string''] = "<p class=''MOD_VALUE[1]''>".$mod[''res''][''meta_description'']."</p>";\r\n                        } else {\r\n                                $mod[''repl_string''] = "<p class=''MOD_VALUE[1]''>";\r\n                                $mod[''res''][''value''] = strip_tags($mod[''res''][''value'']);\r\n                                $mod[''searchvalue''] = explode (" ", $suche);\r\n                                $mod[''searchstart''] = strpos ($mod[''res''][''value''],$mod[''searchvalue''][0])-40;\r\n                                if ($mod[''searchstart''] < 0) {\r\n                                        $mod[''searchstart'']=0;\r\n                                } else {\r\n                                        $mod[''repl_string''] .= "...";\r\n                                        $mod[''searchstart''] = strpos ($mod[''res''][''value'']," ",$mod[''searchstart'']);\r\n                                }\r\n\r\n                                if ($mod[''test''] == "true") {echo "Wort:''".$mod[''searchvalue''][0]."'' Start:".$mod[''searchstart'']."<hr />";}\r\n                                $mod[''repl_string''] .= substr($mod[''res''][''value''],$mod[''searchstart''],300)."...</p>";\r\n                        }\r\n                        $mod[''tpl_res''] = str_replace("{descr}",$mod[''repl_string''],$mod[''tpl_res'']);\r\n                        $mod[''tpl_res''] = str_replace("{nr}",$mod[''nr''],$mod[''tpl_res'']);\r\n                        $mod[''tpl_output''] .= $mod[''tpl_res''];\r\n                        $mod[''nr'']=$mod[''nr'']+1;\r\n                }\r\n        } else {\r\n                $mod[''tpl_res''] = "<p class=''MOD_VALUE[4]''>MOD_VALUE[19]</p>";\r\n                $mod[''tpl_output''] .= $mod[''tpl_res''];\r\n        }\r\n\r\n        $mod[''tpl_res_pre''] = str_replace("{count}",$result[''num_rows''],"MOD_VALUE[15]");\r\n\r\n        if($result[''num_rows''] > 0 && $mod[''res_limit''] != "" ) {\r\n                $mod[''anz''] = $result[''num_rows''];\r\n                $mod[''query''] = "&amp;w_70=$w_70&amp;w_71=$w_71&amp;w_72=$w_72&amp;w_73=$w_73&amp;w_74=$w_74&amp;what=$what&amp;how=$how&amp;modus=$modus&amp;sort=$sort&amp;suche=";\r\n                $mod[''query''] .= rawurlencode($suche);\r\n\r\n                // gesamtanzahl der seiten herausfinden\r\n                if("MOD_VALUE[11]" == "0"){\r\n                        $mod["anz"] = 1;\r\n                } else {\r\n                        $mod["anz"] = ceil($result[''num_rows''] / "MOD_VALUE[11]");\r\n                }\r\n\r\n                // wenn mod_value_32 leer ist, default-separator verwenden.\r\n                if ("MOD_VALUE[32]" == "")\r\n                {\r\n                        $separator = "&nbsp;&nbsp;|&nbsp;&nbsp;";\r\n                } else {\r\n                        $separator = "MOD_VALUE[32]";\r\n                }\r\n                $mod[''idcatlink'']= $con_side[$idcatside][''link''];\r\n                // vor/zurck-links anzeigen?\r\n                if ($mod["anz"]> 1)$mod["nav"] .= suchmodul_createPageLinks("MOD_VALUE[31]", $separator, "MOD_VALUE[30]", $page);\r\n      \r\n          if ($mod[''test''] == "true") {echo "<hr />Kontrolle Navigation: Anz ".$mod["anz"]." Seperator:".$separato.":   <br>Page: ".$page." [31]:MOD_VALUE[31] [30]:MOD_VALUE[30] [18]:MOD_VALUE[18]<br />";}\r\n\r\n                $mod[''tpl_nav''] = str_replace("{nav}", $mod[''nav''],"MOD_VALUE[18]");\r\n		\r\n		$mod[''tpl_res_pre'']  = str_replace("{nav}", $mod[''nav''],$mod[''tpl_res_pre'']);\r\n		$mod[''tpl_res_past''] = str_replace("{nav}", $mod[''nav''],"MOD_VALUE[17]");\r\n		\r\n		$mod[''tpl_output''] = $mod[''tpl_res_pre''].$mod[''tpl_output''].$mod[''tpl_res_past''];\r\n		\r\n	        echo $mod[''tpl_output''];\r\n		echo $mod[''tpl_nav''];\r\n		\r\n        } else {\r\n        	$mod[''tpl_output''] = $mod[''tpl_res_pre''].$mod[''tpl_output''];\r\n	        echo $mod[''tpl_output''];\r\n		\r\n	        echo "MOD_VALUE[17]";\r\n	}        	\r\n}\r\necho "MOD_VALUE[41]";\r\nunset($mod,$separator,$result);\r\n</CMSPHP>', '', 0, 1, 1, 1089569940, 1125877173, 'mod:931d2fc5c322bbcd2be1842c6a3c5db2:f7d22b0f', '', '', '', 0, '0', '', '1');
INSERT INTO `cms_mod` VALUES (23, 'Checkbox', '0.8.1', 'Content', 'Erzeugt als Formularelement eine Checkbox.\r\n', '<?PHP\r\n//configmode\r\n$mip_form[''10''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''10''][''cat''] = ''option'';\r\n$mip_form[''10''][''size''] = ''1'';\r\n$mip_form[''10''][''option_desc''][] = ''Normal'';\r\n$mip_form[''10''][''option_val''][] =  '''';\r\n$mip_form[''10''][''option_desc''][] = ''Erweitert'';\r\n$mip_form[''10''][''option_val''][] =  ''advanced'';\r\n$mip_form[''10''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''10''][''option_val''][] =  ''hidden'';\r\n$mip_form[''10''][''cms_var''] = ''MOD_VAR[10]'';\r\n$mip_form[''10''][''cms_val''] = $cms_mod[''value''][''10''];\r\n$mip_form[''10''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''10'']);//configmode\r\n$mip_form[''hide_in_standard_mode''] = array(0,1,6,7,8);\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''10''] == ''hidden''){\r\n  foreach($cms_mod[''value''] AS $ke=>$va){\r\n    if($ke != ''10''){\r\n    ?>\r\n      <input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n    <?php\r\n     }\r\n  }\r\n}\r\n//simple and advanced config\r\nelse if($cms_mod[''value''][''10''] == '''' || $cms_mod[''value''][''10''] == ''advanced''){\r\n\r\n\r\n//Formularname\r\n$mip_form[''0''][''cat''] = ''txt'';\r\n$mip_form[''0''][''type''] = '''';\r\n$mip_form[''0''][''desc''] = ''Formularfeldname'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''cms_val_default''] = ''Checkbox'';\r\n$mip_form[''0''][''tab''] = ''0'';\r\n\r\n//Formularname\r\n$mip_form[''1''][''cat''] = ''txt'';\r\n$mip_form[''1''][''type''] = '''';\r\n$mip_form[''1''][''desc''] = ''Checkbox  Label'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''cms_val_default''] = ''Checkbox'';\r\n$mip_form[''1''][''tab''] = ''0'';\r\n\r\n//Style Beschreibung\r\n$mip_form[''4''][''desc''] = ''Stylesheet fr die Ausgabe '';\r\n$mip_form[''4''][''cat''] = ''app_css'';\r\n$mip_form[''4''][''output_cat''] = ''option'';\r\n$mip_form[''4''][''cms_var''] = ''MOD_VAR[4]'';\r\n$mip_form[''4''][''cms_val''] = $cms_mod[''value''][''4''];\r\n$mip_form[''4''][''flag''] = ''class_only'';\r\n\r\n//checked Value\r\n$mip_form[''5''][''cat''] = ''txt'';\r\n$mip_form[''5''][''type''] = '''';\r\n$mip_form[''5''][''desc''] = ''Checkbox Wert, wenn selektiert'';\r\n$mip_form[''5''][''cms_var''] = ''MOD_VAR[5]'';\r\n$mip_form[''5''][''cms_val''] = $cms_mod[''value''][''5''];\r\n$mip_form[''5''][''cms_val_default''] = ''Checkbox ausgewhlt'';\r\n$mip_form[''5''][''tab''] = ''0'';\r\n\r\n//unchecked Value\r\n$mip_form[''6''][''cat''] = ''txt'';\r\n$mip_form[''6''][''type''] = '''';\r\n$mip_form[''6''][''desc''] = ''Checkbox Wert,  wenn nicht selektiert'';\r\n$mip_form[''6''][''cms_var''] = ''MOD_VAR[6]'';\r\n$mip_form[''6''][''cms_val''] = $cms_mod[''value''][''6''];\r\n$mip_form[''6''][''cms_val_default''] = '''';\r\n$mip_form[''6''][''tab''] = ''0'';\r\n\r\n// Default Einstellung\r\n$mip_form[''7''][''desc''] = ''Checkbox ist vorselektiert'';\r\n$mip_form[''7''][''cat''] = ''chk'';\r\n$mip_form[''7''][''option_var''][''0''] = ''MOD_VAR[7]'';\r\n$mip_form[''7''][''option_val''][''0''] = $cms_mod[''value''][''7''];\r\n$mip_form[''7''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''7''][''option_val_select''][''0''] = ''true'';\r\n\r\n//Erweitertes Bearbeitungsmen\r\n$mip_form[''8''][''cat''] = ''radio'';\r\n$mip_form[''8''][''type''] = '''';\r\n$mip_form[''8''][''desc''] = ''Bearbeitungsmen<br>\r\n<small>Ein <b>normales Men</b> besteht aus der Schalflche "bearbeiten", das <b>erweiterte Men</b> \r\nbietet darberhinaus die Schaltflchen "neu, lschen, nach oben, nach unten". Wird <b>kein Men</b> gewhlt, ist der \r\nContent nicht editierbar.</small>'';\r\n$mip_form[''8''][''cms_var''] = ''MOD_VAR[8]'';\r\n$mip_form[''8''][''cms_val''] = $cms_mod[''value''][''8''];\r\n$mip_form[''8''][''cms_val_default''] = ''true'';\r\n$mip_form[''8''][''option_desc''][''0''] = ''Normales Men'';\r\n$mip_form[''8''][''option_val''][''0''] = ''true'';\r\n$mip_form[''8''][''option_desc''][''1''] = ''Erweitertes Men'';\r\n$mip_form[''8''][''option_val''][''1''] = ''advanced'';\r\n$mip_form[''8''][''option_desc''][''2''] = ''Kein Men'';\r\n$mip_form[''8''][''option_val''][''2''] = ''false'';\r\n$mip_form[''8''][''tab''] = ''0'';\r\n\r\n//beschreibung/ Legende\r\n$mip_form[''9''][''cat''] = ''desc'';\r\n$mip_form[''9''][''type''] = '''';\r\n$mip_form[''9''][''desc''] = '' <small><b>Legende:</b><br> \r\nCheckbox: {checkbox}, Stylesheet fr die Checkbox: {style}<br>\r\nPhp-Code: &lt;?PHP echo "Ich bin gecachter phpcode! Ich werde immer nur dann neu generiert, wenn es eine<br>\r\nnderung auf der Seite gegeben hat"; ?&gt;<br>\r\n&lt;CMSPHP&gt; echo "Ich bin ungecachter phpcode! Ich werde bei jedem Aufruf der Seite ausgefhrt";&lt;/CMSPHP&gt;<br>\r\n</small>'';\r\n\r\n// Template\r\n$mip_form[''2''][''desc''] = ''Template'';\r\n$mip_form[''2''][''cat''] = ''txtarea'';\r\n$mip_form[''2''][''rows''] = ''6'';\r\n$mip_form[''2''][''type''] = ''long'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''cms_val_default''] = ''{checkbox}'';\r\n\r\n//if simple mode\r\nif($cms_mod[''value''][''10''] == ''''){\r\n   foreach ($mip_form[''hide_in_standard_mode'']  AS $ke=>$va){\r\n     $mip_form[$va][''cat''] = ''hidden'';\r\n   }\r\n }\r\n\r\nmip_formsp($mip_form[''0'']);//Formularfeldname\r\nmip_formsp($mip_form[''4'']);//Style Beschreibung\r\nmip_formsp($mip_form[''1'']);//Beschriftung \r\nmip_formsp($mip_form[''5'']);//checked Value\r\nmip_formsp($mip_form[''6'']);//unchecked Value\r\nmip_formsp($mip_form[''7'']);//Default Einstellung\r\nmip_formsp($mip_form[''8'']);//Men\r\nmip_formsp($mip_form[''2'']);//Template\r\nmip_formsp($mip_form[''9'']);//Legende\r\n\r\n}\r\nunset($mip_form);\r\n\r\n?>', '<?PHP\r\n$myCheckbox[''checkbox''] = <cms:mod type="checkbox" id="1" title="MOD_VALUE[0]" elementName="MOD_VALUE[1]"  elementValue="MOD_VALUE[5]" elementValueUnchecked="MOD_VALUE[6]" checked="MOD_VALUE[7]" menuoptions ="MOD_VALUE[8]" addslashes="true" />;\r\n$myCheckbox[''style''] = "MOD_VALUE[4]";\r\n\r\n$myTplVars[''checkbox''] = ''{checkbox}'';\r\n$myTplVars[''style''] = ''{style}'';\r\n\r\n$myTpl = "MOD_VALUE[2]";\r\n\r\n$myTpl = str_replace($myTplVars, $myCheckbox, $myTpl);\r\neval(''?>''.$myTpl); \r\nunset($myTpl, $myTplVars, $myCheckbox);\r\n?>', '', 0, 1, 1, 1126043474, 1126045153, 'mod:9fced129522f128b2445a41fb0b6ef9f:7fdb9e96', '', '', '', 0, '0', '', '1');
INSERT INTO `cms_mod` VALUES (24, 'Radiobutton', '0.8.2', 'Content', 'Erzeugt als Formularelement einzelnen Radiobutton', '<?PHP\r\n//configmode\r\n$mip_form[''10''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''10''][''cat''] = ''option'';\r\n$mip_form[''10''][''size''] = ''1'';\r\n$mip_form[''10''][''option_desc''][] = ''Normal'';\r\n$mip_form[''10''][''option_val''][] =  '''';\r\n$mip_form[''10''][''option_desc''][] = ''Erweitert'';\r\n$mip_form[''10''][''option_val''][] =  ''advanced'';\r\n$mip_form[''10''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''10''][''option_val''][] =  ''hidden'';\r\n$mip_form[''10''][''cms_var''] = ''MOD_VAR[10]'';\r\n$mip_form[''10''][''cms_val''] = $cms_mod[''value''][''10''];\r\n$mip_form[''10''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''10'']);//configmode\r\n$mip_form[''hide_in_standard_mode''] = array(0,5,6,7,8);\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''10''] == ''hidden''){\r\n  foreach($cms_mod[''value''] AS $ke=>$va){\r\n    if($ke != ''10''){\r\n    ?>\r\n      <input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n    <?php\r\n     }\r\n  }\r\n}\r\n//simple and advanced config\r\nelse if($cms_mod[''value''][''10''] == '''' || $cms_mod[''value''][''10''] == ''advanced''){\r\n\r\n\r\n//Formularname\r\n$mip_form[''0''][''cat''] = ''txt'';\r\n$mip_form[''0''][''type''] = '''';\r\n$mip_form[''0''][''desc''] = ''Formularfeldname'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''cms_val_default''] = ''Radiobutton'';\r\n$mip_form[''0''][''tab''] = ''0'';\r\n\r\n//element Name\r\n$mip_form[''1''][''cat''] = ''txt'';\r\n$mip_form[''1''][''type''] = '''';\r\n$mip_form[''1''][''desc''] = ''Radiobutton(s) Label(s)'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''cms_val_default''] = ''Radiobutton1,Radiobutton2'';\r\n$mip_form[''1''][''tab''] = ''0'';\r\n\r\n//Style Beschreibung\r\n$mip_form[''4''][''desc''] = ''Stylesheet fr die Ausgabe '';\r\n$mip_form[''4''][''cat''] = ''app_css'';\r\n$mip_form[''4''][''output_cat''] = ''option'';\r\n$mip_form[''4''][''cms_var''] = ''MOD_VAR[4]'';\r\n$mip_form[''4''][''cms_val''] = $cms_mod[''value''][''4''];\r\n$mip_form[''4''][''flag''] = ''class_only'';\r\n\r\n//element Value\r\n$mip_form[''5''][''cat''] = ''txt'';\r\n$mip_form[''5''][''type''] = '''';\r\n$mip_form[''5''][''desc''] = ''Radiobutton(s) Wert(e) <small>(Wenn leer werden Labels als Werte eingetragen)</small>'';\r\n$mip_form[''5''][''cms_var''] = ''MOD_VAR[5]'';\r\n$mip_form[''5''][''cms_val''] = $cms_mod[''value''][''5''];\r\n$mip_form[''5''][''cms_val_default''] = '''';\r\n$mip_form[''5''][''tab''] = ''0'';\r\n\r\n//Separator \r\n$mip_form[''6''][''cat''] = ''txt'';\r\n$mip_form[''6''][''type''] = '''';\r\n$mip_form[''6''][''desc''] = ''Radiobuttons Trenner <small>(Standardseperator/ Trenner ist ein Komma)</small>'';\r\n$mip_form[''6''][''cms_var''] = ''MOD_VAR[6]'';\r\n$mip_form[''6''][''cms_val''] = $cms_mod[''value''][''6''];\r\n$mip_form[''6''][''cms_val_default''] = '','';\r\n$mip_form[''6''][''tab''] = ''0'';\r\n\r\n//Default Einstellung\r\n$mip_form[''7''][''cat''] = ''txt'';\r\n$mip_form[''7''][''type''] = '''';\r\n$mip_form[''7''][''desc''] = ''Vorselektierter Radiobutton'';\r\n$mip_form[''7''][''cms_var''] = ''MOD_VAR[7]'';\r\n$mip_form[''7''][''cms_val''] = $cms_mod[''value''][''7''];\r\n$mip_form[''7''][''cms_val_default''] = ''Radiobutton1'';\r\n$mip_form[''7''][''tab''] = ''0'';\r\n\r\n//Erweitertes Bearbeitungsmen\r\n$mip_form[''8''][''cat''] = ''radio'';\r\n$mip_form[''8''][''type''] = '''';\r\n$mip_form[''8''][''desc''] = ''Bearbeitungsmen<br>\r\n<small>Ein <b>normales Men</b> besteht aus der Schalflche "bearbeiten", das <b>erweiterte Men</b> \r\nbietet darberhinaus die Schaltflchen "neu, lschen, nach oben, nach unten". Wird <b>kein Men</b> gewhlt, ist der \r\nContent nicht editierbar.</small>'';\r\n$mip_form[''8''][''cms_var''] = ''MOD_VAR[8]'';\r\n$mip_form[''8''][''cms_val''] = $cms_mod[''value''][''8''];\r\n$mip_form[''8''][''cms_val_default''] = ''true'';\r\n$mip_form[''8''][''option_desc''][''0''] = ''Normales Men'';\r\n$mip_form[''8''][''option_val''][''0''] = ''true'';\r\n$mip_form[''8''][''option_desc''][''1''] = ''Erweitertes Men'';\r\n$mip_form[''8''][''option_val''][''1''] = ''advanced'';\r\n$mip_form[''8''][''option_desc''][''2''] = ''Kein Men'';\r\n$mip_form[''8''][''option_val''][''2''] = ''false'';\r\n$mip_form[''8''][''tab''] = ''0'';\r\n\r\n//beschreibung/ Legende\r\n$mip_form[''9''][''cat''] = ''desc'';\r\n$mip_form[''9''][''type''] = '''';\r\n$mip_form[''9''][''desc''] = '' <small><b>Legende:</b><br> \r\nRadiobutton: {radio}, Stylesheet fr die Radiobutton: {style}<br>\r\nPhp-Code: &lt;?PHP echo "Ich bin gecachter phpcode! Ich werde immer nur dann neu generiert, wenn es eine<br>\r\nnderung auf der Seite gegeben hat"; ?&gt;<br>\r\n&lt;CMSPHP&gt; echo "Ich bin ungecachter phpcode! Ich werde bei jedem Aufruf der Seite ausgefhrt";&lt;/CMSPHP&gt;<br>\r\n</small>'';\r\n\r\n// Template\r\n$mip_form[''2''][''desc''] = ''Template'';\r\n$mip_form[''2''][''cat''] = ''txtarea'';\r\n$mip_form[''2''][''rows''] = ''6'';\r\n$mip_form[''2''][''type''] = ''long'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''cms_val_default''] = ''{radio}'';\r\n\r\n//if simple mode\r\nif($cms_mod[''value''][''10''] == ''''){\r\n   foreach ($mip_form[''hide_in_standard_mode'']  AS $ke=>$va){\r\n     $mip_form[$va][''cat''] = ''hidden'';\r\n   }\r\n }\r\n\r\nmip_formsp($mip_form[''0'']);//Formularfeldname\r\nmip_formsp($mip_form[''4'']);//Style Beschreibung\r\nmip_formsp($mip_form[''1'']);//element Name\r\nmip_formsp($mip_form[''5'']);//element Value\r\nmip_formsp($mip_form[''6'']);//Separator \r\nmip_formsp($mip_form[''7'']);//Default Einstellung\r\nmip_formsp($mip_form[''8'']);//Men\r\nmip_formsp($mip_form[''2'']);//Template\r\nmip_formsp($mip_form[''9'']);//Legende\r\n\r\n}\r\nunset($mip_form);\r\n\r\n?>', '<?PHP\r\n$myRadiobutton[''checkbox''] = <cms:mod type="radio" id="1" title="MOD_VALUE[0]" elementName="MOD_VALUE[1]"  elementValue="MOD_VALUE[5]" elementSeparator="MOD_VALUE[6]" default="MOD_VALUE[7]" menuoptions ="MOD_VALUE[8]" addslashes="true" />;\r\n$myRadiobutton[''style''] = "MOD_VALUE[4]";\r\n\r\n$myTplVars[''checkbox''] = ''{radio}'';\r\n$myTplVars[''style''] = ''{style}'';\r\n\r\n$myTpl = "MOD_VALUE[2]";\r\n\r\n$myTpl = str_replace($myTplVars, $myRadiobutton, $myTpl);\r\neval(''?>''.$myTpl); \r\nunset($myTpl, $myTplVars, $myRadiobutton);\r\n?>', '', 0, 1, 1, 1126043478, 1126047283, 'mod:e3e1207c5dd8bdbf279b3d12ffe6998b:b963206d', '', '', '', 0, '0', '', '1');
INSERT INTO `cms_mod` VALUES (25, 'Selectboxen', '0.8.1', 'Content', 'Erzeugt als Formularelement Selectboxen', '<?PHP\r\n//configmode\r\n$mip_form[''10''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''10''][''cat''] = ''option'';\r\n$mip_form[''10''][''size''] = ''1'';\r\n$mip_form[''10''][''option_desc''][] = ''Normal'';\r\n$mip_form[''10''][''option_val''][] =  '''';\r\n$mip_form[''10''][''option_desc''][] = ''Erweitert'';\r\n$mip_form[''10''][''option_val''][] =  ''advanced'';\r\n$mip_form[''10''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''10''][''option_val''][] =  ''hidden'';\r\n$mip_form[''10''][''cms_var''] = ''MOD_VAR[10]'';\r\n$mip_form[''10''][''cms_val''] = $cms_mod[''value''][''10''];\r\n$mip_form[''10''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''10'']);//configmode\r\n$mip_form[''hide_in_standard_mode''] = array(0,3,5,6,7,8,11);\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''10''] == ''hidden''){\r\n  foreach($cms_mod[''value''] AS $ke=>$va){\r\n    if($ke != ''10''){\r\n    ?>\r\n      <input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n    <?php\r\n     }\r\n  }\r\n}\r\n//simple and advanced config\r\nelse if($cms_mod[''value''][''10''] == '''' || $cms_mod[''value''][''10''] == ''advanced''){\r\n\r\n\r\n//Formularname\r\n$mip_form[''0''][''cat''] = ''txt'';\r\n$mip_form[''0''][''type''] = '''';\r\n$mip_form[''0''][''desc''] = ''Formularfeldname'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''cms_val_default''] = ''Selectboxen'';\r\n$mip_form[''0''][''tab''] = ''0'';\r\n\r\n//element Name\r\n$mip_form[''1''][''cat''] = ''txt'';\r\n$mip_form[''1''][''type''] = '''';\r\n$mip_form[''1''][''desc''] = ''Selectboxelemente - angezeigte Werte'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''cms_val_default''] = ''Feld1,Feld2'';\r\n$mip_form[''1''][''tab''] = ''0'';\r\n\r\n//Style Beschreibung\r\n$mip_form[''4''][''desc''] = ''Stylesheet fr die Ausgabe '';\r\n$mip_form[''4''][''cat''] = ''app_css'';\r\n$mip_form[''4''][''output_cat''] = ''option'';\r\n$mip_form[''4''][''cms_var''] = ''MOD_VAR[4]'';\r\n$mip_form[''4''][''cms_val''] = $cms_mod[''value''][''4''];\r\n$mip_form[''4''][''flag''] = ''class_only'';\r\n\r\n//element Value\r\n$mip_form[''5''][''cat''] = ''txt'';\r\n$mip_form[''5''][''type''] = '''';\r\n$mip_form[''5''][''desc''] = ''Selectboxelemente Werte <small>(Wenn leer gelten die angezeigten Werte)</small>'';\r\n$mip_form[''5''][''cms_var''] = ''MOD_VAR[5]'';\r\n$mip_form[''5''][''cms_val''] = $cms_mod[''value''][''5''];\r\n$mip_form[''5''][''cms_val_default''] = '''';\r\n$mip_form[''5''][''tab''] = ''0'';\r\n\r\n//Separator \r\n$mip_form[''6''][''cat''] = ''txt'';\r\n$mip_form[''6''][''type''] = '''';\r\n$mip_form[''6''][''desc''] = ''Selectboxelemente Trenner <small>(Standardseperator/ Trenner ist ein Komma)</small>'';\r\n$mip_form[''6''][''cms_var''] = ''MOD_VAR[6]'';\r\n$mip_form[''6''][''cms_val''] = $cms_mod[''value''][''6''];\r\n$mip_form[''6''][''cms_val_default''] = '','';\r\n$mip_form[''6''][''tab''] = ''0'';\r\n\r\n//Default Einstellung\r\n$mip_form[''7''][''cat''] = ''txt'';\r\n$mip_form[''7''][''type''] = '''';\r\n$mip_form[''7''][''desc''] = ''Vorselektierte(s) Selectboxelement(e)'';\r\n$mip_form[''7''][''cms_var''] = ''MOD_VAR[7]'';\r\n$mip_form[''7''][''cms_val''] = $cms_mod[''value''][''7''];\r\n$mip_form[''7''][''cms_val_default''] = '''';\r\n$mip_form[''7''][''tab''] = ''0'';\r\n\r\n//Mehrfachauswahl \r\n$mip_form[''3''][''desc''] = ''Mehrfachauswahl aktivieren '';\r\n$mip_form[''3''][''cat''] = ''chk'';\r\n$mip_form[''3''][''option_var''][''0''] = ''MOD_VAR[3]'';\r\n$mip_form[''3''][''option_val''][''0''] = $cms_mod[''value''][''3''];\r\n$mip_form[''3''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''3''][''option_val_select''][''0''] = ''true'';\r\n\r\n//grsse des Auswahlfeldes \r\n$mip_form[''11''][''cat''] = ''txt'';\r\n$mip_form[''11''][''type''] = '''';\r\n$mip_form[''11''][''desc''] = ''Anzahl gleichzeitig sichtbarer Selectboxelemente'';\r\n$mip_form[''11''][''cms_var''] = ''MOD_VAR[11]'';\r\n$mip_form[''11''][''cms_val''] = $cms_mod[''value''][''11''];\r\n$mip_form[''11''][''cms_val_default''] = '''';\r\n$mip_form[''11''][''tab''] = ''0'';\r\n\r\n//Erweitertes Bearbeitungsmen\r\n$mip_form[''8''][''cat''] = ''radio'';\r\n$mip_form[''8''][''type''] = '''';\r\n$mip_form[''8''][''desc''] = ''Bearbeitungsmen<br>\r\n<small>Ein <b>normales Men</b> besteht aus der Schalflche "bearbeiten", das <b>erweiterte Men</b> \r\nbietet darberhinaus die Schaltflchen "neu, lschen, nach oben, nach unten". Wird <b>kein Men</b> gewhlt, ist der \r\nContent nicht editierbar.</small>'';\r\n$mip_form[''8''][''cms_var''] = ''MOD_VAR[8]'';\r\n$mip_form[''8''][''cms_val''] = $cms_mod[''value''][''8''];\r\n$mip_form[''8''][''cms_val_default''] = ''true'';\r\n$mip_form[''8''][''option_desc''][''0''] = ''Normales Men'';\r\n$mip_form[''8''][''option_val''][''0''] = ''true'';\r\n$mip_form[''8''][''option_desc''][''1''] = ''Erweitertes Men'';\r\n$mip_form[''8''][''option_val''][''1''] = ''advanced'';\r\n$mip_form[''8''][''option_desc''][''2''] = ''Kein Men'';\r\n$mip_form[''8''][''option_val''][''2''] = ''false'';\r\n$mip_form[''8''][''tab''] = ''0'';\r\n\r\n//beschreibung/ Legende\r\n$mip_form[''9''][''cat''] = ''desc'';\r\n$mip_form[''9''][''type''] = '''';\r\n$mip_form[''9''][''desc''] = '' <small><b>Legende:</b><br> \r\nSelectboxen: {select}, Stylesheet fr die Selectboxen: {style}<br>\r\nPhp-Code: &lt;?PHP echo "Ich bin gecachter phpcode! Ich werde immer nur dann neu generiert, wenn es eine<br>\r\nnderung auf der Seite gegeben hat"; ?&gt;<br>\r\n&lt;CMSPHP&gt; echo "Ich bin ungecachter phpcode! Ich werde bei jedem Aufruf der Seite ausgefhrt";&lt;/CMSPHP&gt;<br>\r\n</small>'';\r\n\r\n// Template\r\n$mip_form[''2''][''desc''] = ''Template'';\r\n$mip_form[''2''][''cat''] = ''txtarea'';\r\n$mip_form[''2''][''rows''] = ''6'';\r\n$mip_form[''2''][''type''] = ''long'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''cms_val_default''] = ''{select}'';\r\n\r\n//if simple mode\r\nif($cms_mod[''value''][''10''] == ''''){\r\n   foreach ($mip_form[''hide_in_standard_mode'']  AS $ke=>$va){\r\n     $mip_form[$va][''cat''] = ''hidden'';\r\n   }\r\n }\r\n\r\nmip_formsp($mip_form[''0'']);//Formularfeldname\r\nmip_formsp($mip_form[''4'']);//Style Beschreibung\r\nmip_formsp($mip_form[''1'']);//element Name\r\nmip_formsp($mip_form[''5'']);//element Value\r\nmip_formsp($mip_form[''6'']);//Separator \r\nmip_formsp($mip_form[''3'']);//Mehrfachauswahl \r\nmip_formsp($mip_form[''7'']);//Default Einstellung\r\nmip_formsp($mip_form[''11'']);//grsse des Auswahlfeldes \r\nmip_formsp($mip_form[''8'']);//Men\r\nmip_formsp($mip_form[''2'']);//Template\r\nmip_formsp($mip_form[''9'']);//Legende\r\n\r\n}\r\nunset($mip_form);\r\n\r\n?>', '<?PHP\r\n$mySelect[''checkbox''] = <cms:mod type="select" id="1" title="MOD_VALUE[0]" elementName="MOD_VALUE[1]"  elementValue="MOD_VALUE[5]" elementSeparator="MOD_VALUE[6]" default="MOD_VALUE[7]" multiple="MOD_VALUE[3]" size="MOD_VALUE[11]" menuoptions ="MOD_VALUE[8]" addslashes="true" />;\r\n$mySelect[''style''] = "MOD_VALUE[4]";\r\n\r\n$myTplVars[''checkbox''] = ''{select}'';\r\n$myTplVars[''style''] = ''{style}'';\r\n\r\n$myTpl = "MOD_VALUE[2]";\r\n\r\n$myTpl = str_replace($myTplVars, $mySelect, $myTpl);\r\neval(''?>''.$myTpl); \r\nunset($myTpl, $myTplVars, $mySelect);\r\n?>', '', 0, 1, 1, 1126043481, 1126049682, 'mod:3aa0705b006c94c3a831649d6bb73309:80f5f2fd', '', '', '', 0, '0', '', '1');
INSERT INTO `cms_mod` VALUES (26, 'ContentFlex', '1.8.8', 'Contentliste', 'Stellt flexibel unterschiedliche Inhaltselemente und/oder Gruppen von Inhaltselementen zur Verfgung.', '<?php\r\n// Version 1.2.0 - ?.?.?\r\n// by Alexander M. Korn (amk@gmx.info)\r\n// Version 1.1.2\r\n// (c) 2005 by Reto Haldemann v/o Mistral\r\n\r\n//\r\n// zur Fehlersuche\r\n//if(isset($flextest))\r\n//{\r\n// $mod[''test''] = "true";\r\n//}\r\n\r\n$is_dev=false;\r\n\r\nif($is_dev) {\r\ninclude "C:/_server/www/_sefrengo/mod_dev/ContentFlex/cflex_config.php";\r\n} else {\r\n\r\n\r\nif(! function_exists(printsfconf)){\r\n function printsfconf($str,$mode)\r\n { \r\n global $cms_mod;\r\n if (in_array($cms_mod[''value''][''0''],explode('' '',$mode)))\r\n echo $str;\r\n }\r\n}\r\n\r\n//BBCode\r\n//mip_formsp($mip_form[''70'']);//features\r\n\r\n//configmode\r\n$mip_form[''0''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''0''][''cat''] = ''option'';\r\n$mip_form[''0''][''size''] = ''1'';\r\n$mip_form[''0''][''option_desc''][] = ''Normal'';\r\n$mip_form[''0''][''option_val''][] = '''';\r\n$mip_form[''0''][''option_desc''][] = ''Erweitert'';\r\n$mip_form[''0''][''option_val''][] = ''advanced'';\r\n$mip_form[''0''][''option_desc''][] = ''Alles'';\r\n$mip_form[''0''][''option_val''][] = ''all'';\r\n$mip_form[''0''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''0''][''option_val''][] = ''hidden'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''0'']);//configmode\r\n \r\n$mip_form[''hide_in_advanced_mode''] = array(14,13,30014,30013,30015,8,7,1000,1001,1002,1003,1004,5,10,11,12,60,95,9997,999,\r\n520,2020,500,501,502,510,28,2021,2016,2030,2031,2032,\r\n3479,3478,3379,3378,3279,3278,3179,3178,3079,3078,78,79,\r\n49,50,51,54,72,84,884,885,\r\n10000,10001,10002,\r\n10031,10030);\r\n$mip_form[''hide_in_standard_mode''] = array_merge( array(1,2,15,16,17,18,19,6,3,4,28,27,6000,6001,6002,6003,6004,6005,\r\n 80,82,70,53,54,74,75,76,77,78,79,71,72,73,84,90,6090,94,\r\n 886,887,873,874,\r\n 3074,3075,3076,3077,3078,3079,3094,\r\n 3174,3175,3176,3177,3178,3179,3194,\r\n 3274,3275,3276,3277,3278,3279,3294,\r\n 3374,3375,3376,3377,3378,3379,3394,\r\n 3474,3475,3476,3477,3478,3479,3494,\r\n 3574,3575,3576,3577,3578,3579,3594,\r\n 3674,3675,3676,3677,3678,3679,3694,\r\n 3774,3775,3776,3777,3778,3779,3794,\r\n 3874,3875,3876,3877,3878,3879,3894,\r\n 329,330,331,332,333,\r\n 500,501,502,510,520,9998,\r\n 9999,10000,10001,10002,10060,10030,10031,10050,100100,\r\n 100101,100102,100103,100400,100401,100402,10070,10071,\r\n 10032,10033,10034,\r\n 4010,4020,4090,\r\n 4110,4120,4190,\r\n 2000,2008,2009,2010,2011,2012,2013,2014,2015,2018,2019,\r\n 2004,2005,2002,2116,2001,2006,2003,2020,2021,2022,2023,\r\n 81,20,21,22,23,24,25,26,29,3029,3029,3029,3029,\r\n 30,31,32,\r\n 33,34,35,36,37,40,41,42,43,44,45,4045,4046,4047,4048,4049,4050,4051,\r\n 8045,8046,8047,8048,8049,8050,8051,8052,\r\n 342,343,443,444,\r\n 886,887,\r\n 46,47,48,5045,5046,5047,5048,5049,5050,5051,5052,\r\n 1044,1045,1046,1047,1048,1049,1050,\r\n 49,50,51,52,61,62,63,64,65,66,67,68,69,85,\r\n 6066,6067,6068,6069,\r\n 86,87,88,89,90,91,92,93,7093,7094,7095,7096,\r\n 999,3029,3129,3229,3329,3429,3529,3629,3729,3829) ,\r\n $mip_form[''hide_in_advanced_mode''] );\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''0''] == ''hidden''){\r\n foreach($cms_mod[''value''] AS $ke=>$va){\r\n if($ke != ''0''){\r\n ?>\r\n <input name="MOD_VAR[<?PHP echo $ke; ?>]" type="hidden" value="<?PHP echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n <?PHP\r\n }\r\n }\r\n}\r\n//simple, advanced and all config (not hidden config)\r\nelse if($cms_mod[''value''][''0''] == '''' || $cms_mod[''value''][''0''] == ''advanced'' || $cms_mod[''value''][''0''] == ''all''){\r\n\r\n\r\n// Schriftart 1\r\n$mip_form[''1''][''desc''] = $mod_lang[''gen_font'']." <small>{font1}</small>";\r\n$mip_form[''1''][''cat''] = ''app_css'';\r\n$mip_form[''1''][''output_cat''] = ''option'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n$mip_form[''1''][''flag''] = ''class_only'';\r\n\r\n// Schriftart 2\r\n$mip_form[''2''][''desc''] = $mod_lang[''gen_font'']." <small>{font2}</small>";\r\n$mip_form[''2''][''cat''] = ''app_css'';\r\n$mip_form[''2''][''output_cat''] = ''option'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n$mip_form[''2''][''flag''] = ''class_only'';\r\n\r\n// ***************************** Konfiguration *********************\r\n\r\n//Edit Template\r\n$mip_form[''13''][''desc''] = ''{editbutton}-Template <small>{title} {edit} {insert}</small>'';\r\n$mip_form[''13''][''cat''] = ''txtarea'';\r\n$mip_form[''13''][''rows''] = ''4'';\r\n$mip_form[''13''][''type''] = ''long'';\r\n$mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n$mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n$mip_form[''13''][''cms_val_default''] = ''<span class="flex2_edit">{title}{edit}&nbsp;{insert}</span>'';\r\n\r\n//Edit Template\r\n$mip_form[''30013''][''desc''] = ''Template f&#252;r das Einf&#252;gen an erster Stelle <small>{insert}</small>'';\r\n$mip_form[''30013''][''cat''] = ''txtarea'';\r\n$mip_form[''30013''][''rows''] = ''4'';\r\n$mip_form[''30013''][''type''] = ''long'';\r\n$mip_form[''30013''][''cms_var''] = ''MOD_VAR[30013]'';\r\n$mip_form[''30013''][''cms_val''] = $cms_mod[''value''][''30013''];\r\n$mip_form[''30013''][''cms_val_default''] = ''<span class="flex2_edit">{insert}</span>'';\r\n\r\n\r\n//Edit Template\r\n$mip_form[''30014''][''desc''] = ''{insert}-Template <small>{insert} {title}</small>'';\r\n$mip_form[''30014''][''cat''] = ''txtarea'';\r\n$mip_form[''30014''][''rows''] = ''2'';\r\n$mip_form[''30014''][''type''] = ''long'';\r\n$mip_form[''30014''][''cms_var''] = ''MOD_VAR[30014]'';\r\n$mip_form[''30014''][''cms_val''] = $cms_mod[''value''][''30014''];\r\n$mip_form[''30014''][''cms_val_default''] = ''<span class="flex2_edit">{insert}</span>'';\r\n\r\n//Edit Template\r\n$mip_form[''30015''][''desc''] = ''{edit}-Template <small>{edit} {title}</small>'';\r\n$mip_form[''30015''][''cat''] = ''txtarea'';\r\n$mip_form[''30015''][''rows''] = ''2'';\r\n$mip_form[''30015''][''type''] = ''long'';\r\n$mip_form[''30015''][''cms_var''] = ''MOD_VAR[30015]'';\r\n$mip_form[''30015''][''cms_val''] = $cms_mod[''value''][''30015''];\r\n$mip_form[''30015''][''cms_val_default''] = ''<span class="flex2_edit">{title} {edit}</span>'';\r\n\r\n// Template-Beschriftung ausgeben\r\n$mip_form[''14''][''desc''] = ''Template-Bezeichnung ausgeben'';\r\n$mip_form[''14''][''cat''] = ''option'';\r\n$mip_form[''14''][''cms_var''] = ''MOD_VAR[14]'';\r\n$mip_form[''14''][''cms_val''] = $cms_mod[''value''][''14''];\r\n$mip_form[''14''][''cms_val_default''] = '''';\r\n$mip_form[''14''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''14''][''option_val''][''0''] = ''true'';\r\n$mip_form[''14''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''14''][''option_val''][''1''] = '''';\r\n$mip_form[''14''][''tab''] = ''0'';\r\n\r\n// Default Position f&#252;r das Edit Template\r\n$mip_form[''60''][''desc''] = ''Standardposition des Edit-Template vor dem Element'';\r\n$mip_form[''60''][''cat''] = ''option'';\r\n$mip_form[''60''][''cms_var''] = ''MOD_VAR[60]'';\r\n$mip_form[''60''][''cms_val''] = $cms_mod[''value''][''60''];\r\n$mip_form[''60''][''cms_val_default''] = '''';\r\n$mip_form[''60''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''60''][''option_val''][''0''] = ''true'';\r\n$mip_form[''60''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''60''][''option_val''][''1''] = '''';\r\n$mip_form[''60''][''tab''] = ''0'';\r\n\r\n// Ergebnisse pro Seite\r\n$mip_form[''5''][''cat''] = ''txt'';\r\n$mip_form[''5''][''type''] = '''';\r\n$mip_form[''5''][''desc''] = ''Eintr&#228;ge pro Seite: <small>(0 = alle)</small>'';\r\n$mip_form[''5''][''cms_var''] = ''MOD_VAR[5]'';\r\n$mip_form[''5''][''cms_val''] = $cms_mod[''value''][''5''];\r\n$mip_form[''5''][''cms_val_default''] = ''0'';\r\n\r\n// Default Template nur im Backend\r\n$mip_form[''7''][''desc''] = ''Standard-Template nur im Backend'';\r\n$mip_form[''7''][''cat''] = ''option'';\r\n$mip_form[''7''][''cms_var''] = ''MOD_VAR[7]'';\r\n$mip_form[''7''][''cms_val''] = $cms_mod[''value''][''7''];\r\n$mip_form[''7''][''cms_val_default''] = '''';\r\n$mip_form[''7''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''7''][''option_val''][''0''] = ''true'';\r\n$mip_form[''7''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''7''][''option_val''][''1''] = '''';\r\n$mip_form[''7''][''tab''] = ''0'';\r\n\r\n// Template Eintrag\r\n$mip_form[''8''][''desc''] = ''Standard-Template'';\r\n$mip_form[''8''][''cat''] = ''txtarea'';\r\n$mip_form[''8''][''rows''] = ''7'';\r\n$mip_form[''8''][''type''] = ''long'';\r\n$mip_form[''8''][''cms_var''] = ''MOD_VAR[8]'';\r\n$mip_form[''8''][''cms_val''] = $cms_mod[''value''][''8''];\r\n$mip_form[''8''][''cms_val_default''] = ''<p><strong>Kein Template zugewiesen</strong><br />\r\ntext:1 -> {text:1}<br />\r\ntext:2 -> {text:2}<br />\r\ntext:3 -> {text:3}<br />\r\ntext:4 -> {text:4}<br />\r\ntext:5 -> {text:5}<br />\r\ntext:6 -> {text:6}<br />\r\ntext:7 -> {text:7}<br />\r\ntext:8 -> {text:8}<br />\r\ntext:9 -> {text:9}<br />\r\ntext:10 -> {text:10}<br />\r\ntextarea:1 -> {textarea:1}<br />\r\ntextarea:2 -> {textarea:2}<br />\r\ntextarea:3 -> {textarea:3}<br />\r\ntextarea:4 -> {textarea:4}<br />\r\ntextarea:5 -> {textarea:5}<br />\r\ntextarea:6 -> {textarea:6}<br />\r\ntextarea:7 -> {textarea:7}<br />\r\ntextarea:8 -> {textarea:8}<br />\r\ntextarea:9 -> {textarea:9}<br />\r\ntextarea:10 -> {textarea:10}<br />\r\nimage:1 -> {image:1}<br />\r\nimage:2 -> {image:2}<br />\r\nimage:3 -> {image:3}<br />\r\nimage:4 -> {image:4}<br />\r\nimage:5 -> {image:5}<br />\r\nimage:6 -> {image:6}<br />\r\nimage:7 -> {image:7}<br />\r\nimage:8 -> {image:8}<br />\r\nimage:9 -> {image:9}<br />\r\nimage:10 -> {image:10}<br />\r\nlink:1 -> {link:1}<br />\r\nlink:2 -> {link:2}<br />\r\nlink:3 -> {link:3}<br />\r\nlink:4 -> {link:4}<br />\r\nlink:5 -> {link:5}<br />\r\nlink:6 -> {link:6}<br />\r\nlink:7 -> {link:7}<br />\r\nlink:8 -> {link:8}<br />\r\nlink:9 -> {link:9}<br />\r\nlink:10 -> {link:10}<br />\r\nfile:1 -> {file:1}<br />\r\nfile:2 -> {file:2}<br />\r\nfile:3 -> {file:3}<br />\r\nfile:4 -> {file:4}<br />\r\nfile:5 -> {file:5}<br />\r\nfile:6 -> {file:6}<br />\r\nfile:7 -> {file:7}<br />\r\nfile:8 -> {file:8}<br />\r\nfile:9 -> {file:9}<br />\r\nfile:10 -> {file:10}<br />\r\nwysiwyg:1 -> {wysiwyg:1}<br />\r\nwysiwyg:2 -> {wysiwyg:2}<br />\r\nwysiwyg:3 -> {wysiwyg:3}<br />\r\nwysiwyg:4 -> {wysiwyg:4}<br />\r\nwysiwyg:5 -> {wysiwyg:5}<br />\r\nwysiwyg2:1 -> {wysiwyg2:1}<br />\r\nwysiwyg2:2 -> {wysiwyg2:2}<br />\r\nwysiwyg2:3 -> {wysiwyg2:3}<br />\r\nwysiwyg2:4 -> {wysiwyg2:4}<br />\r\nwysiwyg2:5 -> {wysiwyg2:5}<br />\r\nsourcecode:1 -> {sourcecode:1}<br />\r\nselect:1 -> {select:1}<br />\r\nselect:2 -> {select:2}<br />\r\nselect:3 -> {select:3}<br />\r\nselect:4 -> {select:4}<br />\r\nselect:5 -> {select:5}<br />\r\nselect:6 -> {select:6}<br />\r\nselect:7 -> {select:7}<br />\r\nselect:8 -> {select:8}<br />\r\nselect:9 -> {select:9}<br />\r\nselect:10 -> {select:10}<br />\r\ndate:1 -> {date:1}<br />\r\ndate:2 -> {date:2}<br />\r\ndate:3 -> {date:3}<br />\r\ndate:4 -> {date:4}<br />\r\ndate:5 -> {date:5}<br />\r\ntable -> {table}<br />\r\nlist:1-> {list:1}<br />\r\nlist:2 -> {list:2}<br />\r\n</p>'';\r\n\r\n//beschreibung/ Legende\r\n\r\n$mip_form[''9''][''cat''] = ''desc'';\r\n$mip_form[''9''][''type''] = '''';\r\n$mip_form[''9''][''desc''] = ''<div id="legend_MOD_VAR1" style="display:none;;text-align:right;"><small style="line-height:140%;"><strong>{text:x} {textarea:x} {select:x} {link:x} {file:x} {image:x} <em>(1-10)</em> | {wysiwyg:x} {wysiwyg2:x} {date:x} <em>(1-5)</em> | {sourcecode:x} <em>(1)</em></strong><br/><br/> \r\n{text:x} {textarea:x} {wysiwyg:x} {wysiwyg2:x}<br />\r\n{file:x} {fileid:x} {fileurl:x} {filedesc:x} {filesize:x} {filename:x} {filefmtitle:x} {filefmdesc:x}<br/>\r\n{filetype:x} {filetypedesc:x} {filetypeicon:x} {filetypeiconname:x} {filetypeiconurl:x} {filemimetype:x}<br/>\r\n{link:x} {linkurl:x} {linkdesc:x} {linktarget:x} {linksfsidetitle:x}<br />\r\n{image:x} {SF141_1} {imageurl:x} {imagedesc:x} {imagefmtitle:x} {imagefmdesc:x} {imagesize:x} {imagename:x}<br/>{imagewidth:x} {imageheight:x} {imagethumb:x} {SF141_2} {imagethumburl:x} {imagethumbheight:x}<br/>{imagethumbwidth:x} {imagethumbhalfheight:x} {imagethumbhalfwidth:x} {SF141_3} {imagedimensions:x}<br />\r\n{date:x} {select:x} {sourcecode:x}<br /><br /><strong>{table}</strong> {table_caption} <strong>{list:x}</strong><br /><br />\r\n''.(($cms_mod[''value''][''2003'']==''rb'')?''<strong>{filelist}</strong> {fl_selected_file} {fl_selected_filename} {fl_selected_fileurl} {fl_selected_filethumburl}<br/>{fl_selected_filetarget} {fl_selected_filedesc} {fl_selected_filefmtitle} {fl_selected_filefmdesc}<br/><br/>'':''<strong>{filelist}</strong>'').''<br/><br/>\r\n{author} {date} {created_date} {username} {name} {surname} {email} {uni:x} {font1-2} {popup}<br />{cat_name} {side_name} {container_id} {mod_key} {no}<br/><br/>\r\n<strong>{if_</strong><em>Element:x</em><strong>} {/if_</strong><em>Element:x</em><strong>}</strong> <strong>{if_not_</strong><em>Element:x</em><strong>} {/if_not_</strong><em>Element:x</em><strong>}</strong><br/>\r\n<strong>{if_</strong><em>Element:x</em><strong>=</strong><em>Value</em><strong>} {/if_</strong><em>Element:x</em><strong>=</strong><em>Value</em><strong>}</strong> <strong>{if_not_</strong><em>Element:x</em><strong>=</strong><em>Value</em><strong>} {/if_not_</strong><em>Element:x</em><strong>=</strong><em>Value</em><strong>}</strong><br/>\r\n<strong>{if_</strong><em>Element:x</em><strong>&gt;</strong><em>Value</em><strong>} {/if_</strong><em>Element:x</em><strong>&gt;</strong><em>Value</em><strong>}</strong> <strong>{if_not_</strong><em>Element:x</em><strong>&gt;</strong><em>Value</em><strong>} {/if_not_</strong><em>Element:x</em><strong>&gt;</strong><em>Value</em><strong>}</strong><br/>\r\n<strong>{if_</strong><em>Element:x</em><strong>&lt;</strong><em>Value</em><strong>} {/if_</strong><em>Element:x</em><strong>&lt;</strong><em>Value</em><strong>}</strong> <strong>{if_not_</strong><em>Element:x</em><strong>&lt;</strong><em>Value</em><strong>} {/if_not_</strong><em>Element:x</em><strong>&lt;</strong><em>Value</em><strong>}</strong><br/>\r\n{if_backend} {/if_backend} {if_preview} {/if_preview} {hide} {/hide}<br /><br/>\r\n<strong>{editbutton}</strong> {edit} {insert}</small>\r\n</div>\r\n<div style="text-align:right;" onclick="this.innerHTML=document.getElementById(\\''legend_MOD_VAR1\\'').innerHTML;"><small style="cursor: pointer;">Hilfe anzeigen<br /></small></div>'';\r\n\r\n\r\nif ((float) str_replace(''01.'','''',$cfg_cms[''version''])>4) {\r\n $mip_form[''9''][''desc'']=str_replace(''{SF141_1}'',\r\n ''{imageid:x} '',\r\n $mip_form[''9''][''desc'']);\r\n $mip_form[''9''][''desc'']=str_replace(''{SF141_2}'',\r\n ''{imagethumbpath:x}'',\r\n $mip_form[''9''][''desc'']); \r\n $mip_form[''9''][''desc'']=str_replace(''{SF141_3}'',\r\n ''{imagethumbamplitude:x} '',\r\n $mip_form[''9''][''desc'']);\r\n} else {\r\n $mip_form[''9''][''desc'']=str_replace(''{SF141_1}'','''',$mip_form[''9''][''desc'']);\r\n $mip_form[''9''][''desc'']=str_replace(''{SF141_2}'','''',$mip_form[''9''][''desc'']); \r\n $mip_form[''9''][''desc'']=str_replace(''{SF141_3}'','''',$mip_form[''9''][''desc'']);\r\n}\r\n\r\n// Template Nav\r\n$mip_form[''10''][''desc''] = ''Template-Navigation'';\r\n$mip_form[''10''][''cat''] = ''txtarea'';\r\n$mip_form[''10''][''rows''] = ''3'';\r\n$mip_form[''10''][''type''] = ''long'';\r\n$mip_form[''10''][''cms_var''] = ''MOD_VAR[10]'';\r\n$mip_form[''10''][''cms_val''] = $cms_mod[''value''][''10''];\r\n$mip_form[''10''][''cms_val_default''] = ''<table width="100%" border="0"><tr>''."\\n".''<td width="50%" align="left" class="{font2}">{prev}</td>''."\\n".''<td width="50%" align="right" class="{font2}">{next}</td></tr></table>'';\r\n\r\n// text fuer weiter\r\n$mip_form[''11''][''cat''] = ''txt'';\r\n$mip_form[''11''][''type''] = '''';\r\n$mip_form[''11''][''desc''] = ''Text f&#252;r Weiter-Link'';\r\n$mip_form[''11''][''cms_var''] = ''MOD_VAR[11]'';\r\n$mip_form[''11''][''cms_val''] = $cms_mod[''value''][''11''];\r\n$mip_form[''11''][''cms_val_default''] = ''Seite vorw&#228;rts'';\r\n\r\n// text fuer zurueck\r\n$mip_form[''12''][''cat''] = ''txt'';\r\n$mip_form[''12''][''type''] = '''';\r\n$mip_form[''12''][''desc''] = ''Text f&#252;r Zur&#252;ck-Link'';\r\n$mip_form[''12''][''cms_var''] = ''MOD_VAR[12]'';\r\n$mip_form[''12''][''cms_val''] = $cms_mod[''value''][''12''];\r\n$mip_form[''12''][''cms_val_default''] = ''Seite zur&#252;ck'';\r\n\r\n\r\n// ***************************** umschliessendes Template *********************\r\n// Beschreibungen umschliessendes Template\r\n#$mip_form[''65''][''cat''] = ''desc'';\r\n#$mip_form[''65''][''type''] = '''';\r\n#$mip_form[''65''][''desc''] = "<strong>Umschliessendes Template </strong><br />";\r\n#$mip_form[''65''][''tab''] = ''0'';\r\n\r\n// umschliessendes Template 1 Start\r\n$mip_form[''61''][''desc''] = ''Template 1 Start'';\r\n$mip_form[''61''][''cat''] = ''txtarea'';\r\nif ($cms_mod[''value''][''0''] != ''advanced'')\r\n $mip_form[''61''][''rows''] = ''4'';\r\nelse\r\n $mip_form[''61''][''rows''] = ''6'';\r\n$mip_form[''61''][''type''] = ''long'';\r\n$mip_form[''61''][''cms_var''] = ''MOD_VAR[61]'';\r\n$mip_form[''61''][''cms_val''] = $cms_mod[''value''][''61''];\r\n$mip_form[''61''][''cms_val_default''] = ''<table width="100%" border="1">'';\r\n\r\n// umschliessendes Template 1 Start\r\n$mip_form[''62''][''desc''] = ''Template 1 Ende'';\r\n$mip_form[''62''][''cat''] = ''txtarea'';\r\nif ($cms_mod[''value''][''0''] != ''advanced'')\r\n $mip_form[''62''][''rows''] = ''4'';\r\nelse\r\n $mip_form[''62''][''rows''] = ''6'';\r\n$mip_form[''62''][''type''] = ''long'';\r\n$mip_form[''62''][''cms_var''] = ''MOD_VAR[62]'';\r\n$mip_form[''62''][''cms_val''] = $cms_mod[''value''][''62''];\r\n$mip_form[''62''][''cms_val_default''] = ''</table>'';\r\n\r\n// umschliessendes Template 2 Start\r\n$mip_form[''63''][''desc''] = ''Template 2 Start'';\r\n$mip_form[''63''][''cat''] = ''txtarea'';\r\nif ($cms_mod[''value''][''0''] != ''advanced'')\r\n $mip_form[''63''][''rows''] = ''4'';\r\nelse\r\n $mip_form[''63''][''rows''] = ''6'';\r\n$mip_form[''63''][''type''] = ''long'';\r\n$mip_form[''63''][''cms_var''] = ''MOD_VAR[63]'';\r\n$mip_form[''63''][''cms_val''] = $cms_mod[''value''][''63''];\r\n$mip_form[''63''][''cms_val_default''] = ''<table width="100%" border="1">'';\r\n\r\n// umschliessendes Template 2 Start\r\n$mip_form[''64''][''desc''] = ''Template 2 Ende'';\r\n$mip_form[''64''][''cat''] = ''txtarea'';\r\nif ($cms_mod[''value''][''0''] != ''advanced'')\r\n $mip_form[''64''][''rows''] = ''4'';\r\nelse\r\n $mip_form[''64''][''rows''] = ''6'';\r\n$mip_form[''64''][''type''] = ''long'';\r\n$mip_form[''64''][''cms_var''] = ''MOD_VAR[64]'';\r\n$mip_form[''64''][''cms_val''] = $cms_mod[''value''][''64''];\r\n$mip_form[''64''][''cms_val_default''] = ''</table>'';\r\n\r\n// umschliessendes Template 3 Start\r\n$mip_form[''66''][''desc''] = ''Template 3 Start'';\r\n$mip_form[''66''][''cat''] = ''txtarea'';\r\nif ($cms_mod[''value''][''0''] != ''advanced'')\r\n $mip_form[''66''][''rows''] = ''4'';\r\nelse\r\n $mip_form[''66''][''rows''] = ''6'';\r\n$mip_form[''66''][''type''] = ''long'';\r\n$mip_form[''66''][''cms_var''] = ''MOD_VAR[66]'';\r\n$mip_form[''66''][''cms_val''] = $cms_mod[''value''][''66''];\r\n$mip_form[''66''][''cms_val_default''] = ''<ul>'';\r\n\r\n// umschliessendes Template 3 Start\r\n$mip_form[''67''][''desc''] = ''Template 3 Ende'';\r\n$mip_form[''67''][''cat''] = ''txtarea'';\r\nif ($cms_mod[''value''][''0''] != ''advanced'')\r\n $mip_form[''67''][''rows''] = ''4'';\r\nelse\r\n $mip_form[''67''][''rows''] = ''6'';\r\n$mip_form[''67''][''type''] = ''long'';\r\n$mip_form[''67''][''cms_var''] = ''MOD_VAR[67]'';\r\n$mip_form[''67''][''cms_val''] = $cms_mod[''value''][''67''];\r\n$mip_form[''67''][''cms_val_default''] = ''</ul>'';\r\n\r\n// umschliessendes Template 4 Start\r\n$mip_form[''68''][''desc''] = ''Template 4 Start'';\r\n$mip_form[''68''][''cat''] = ''txtarea'';\r\nif ($cms_mod[''value''][''0''] != ''advanced'')\r\n $mip_form[''68''][''rows''] = ''4'';\r\nelse\r\n $mip_form[''68''][''rows''] = ''6'';\r\n$mip_form[''68''][''type''] = ''long'';\r\n$mip_form[''68''][''cms_var''] = ''MOD_VAR[68]'';\r\n$mip_form[''68''][''cms_val''] = $cms_mod[''value''][''68''];\r\n$mip_form[''68''][''cms_val_default''] = ''<div align="right">'';\r\n\r\n// umschliessendes Template 4 Start\r\n$mip_form[''69''][''desc''] = ''Template 4 Ende'';\r\n$mip_form[''69''][''cat''] = ''txtarea'';\r\nif ($cms_mod[''value''][''0''] != ''advanced'')\r\n $mip_form[''69''][''rows''] = ''4'';\r\nelse\r\n $mip_form[''69''][''rows''] = ''6'';\r\n$mip_form[''69''][''type''] = ''long'';\r\n$mip_form[''69''][''cms_var''] = ''MOD_VAR[69]'';\r\n$mip_form[''69''][''cms_val''] = $cms_mod[''value''][''69''];\r\n$mip_form[''69''][''cms_val_default''] = ''</div>'';\r\n\r\n// umschliessendes Template 5 Start\r\n$mip_form[''6066''][''desc''] = ''Template 5 Start'';\r\n$mip_form[''6066''][''cat''] = ''txtarea'';\r\nif ($cms_mod[''value''][''0''] != ''advanced'')\r\n $mip_form[''6066''][''rows''] = ''4'';\r\nelse\r\n $mip_form[''6066''][''rows''] = ''6'';\r\n$mip_form[''6066''][''type''] = ''long'';\r\n$mip_form[''6066''][''cms_var''] = ''MOD_VAR[6066]'';\r\n$mip_form[''6066''][''cms_val''] = $cms_mod[''value''][''6066''];\r\n$mip_form[''6066''][''cms_val_default''] = '''';\r\n\r\n// umschliessendes Template 5 Start\r\n$mip_form[''6067''][''desc''] = ''Template 5 Ende'';\r\n$mip_form[''6067''][''cat''] = ''txtarea'';\r\nif ($cms_mod[''value''][''0''] != ''advanced'')\r\n $mip_form[''6067''][''rows''] = ''4'';\r\nelse\r\n $mip_form[''6067''][''rows''] = ''6'';\r\n$mip_form[''6067''][''type''] = ''long'';\r\n$mip_form[''6067''][''cms_var''] = ''MOD_VAR[6067]'';\r\n$mip_form[''6067''][''cms_val''] = $cms_mod[''value''][''6067''];\r\n$mip_form[''6067''][''cms_val_default''] = '''';\r\n\r\n// umschliessendes Template 6 Start\r\n$mip_form[''6068''][''desc''] = ''Template 6 Start'';\r\n$mip_form[''6068''][''cat''] = ''txtarea'';\r\nif ($cms_mod[''value''][''0''] != ''advanced'')\r\n $mip_form[''6068''][''rows''] = ''4'';\r\nelse\r\n $mip_form[''6068''][''rows''] = ''6'';\r\n$mip_form[''6068''][''type''] = ''long'';\r\n$mip_form[''6068''][''cms_var''] = ''MOD_VAR[6068]'';\r\n$mip_form[''6068''][''cms_val''] = $cms_mod[''value''][''6068''];\r\n$mip_form[''6068''][''cms_val_default''] = '''';\r\n\r\n// umschliessendes Template 6 Start\r\n$mip_form[''6069''][''desc''] = ''Template 6 Ende'';\r\n$mip_form[''6069''][''cat''] = ''txtarea'';\r\nif ($cms_mod[''value''][''0''] != ''advanced'')\r\n $mip_form[''6069''][''rows''] = ''4'';\r\nelse\r\n $mip_form[''6069''][''rows''] = ''6'';\r\n$mip_form[''6069''][''type''] = ''long'';\r\n$mip_form[''6069''][''cms_var''] = ''MOD_VAR[6069]'';\r\n$mip_form[''6069''][''cms_val''] = $cms_mod[''value''][''6069''];\r\n$mip_form[''6069''][''cms_val_default''] = '''';\r\n\r\n// ***************************** Bild aus dem Modul Bild 1.0 *********************\r\n//Dateitypen\r\n$mip_form[''15''][''desc''] = ''Ausw&#228;hlbare Grafiktypen'';\r\n$mip_form[''15''][''cat''] = ''option'';\r\n$mip_form[''15''][''flag''] = ''multiple'';\r\n$mip_form[''15''][''size''] = ''5'';\r\n$mip_form[''15''][''cms_var''] = ''MOD_VAR[15]'';\r\n$mip_form[''15''][''cms_val''] = $cms_mod[''value''][''15''];\r\n$mip_form[''15''][''cms_val_default''] = ''true'';\r\n$mip_form[''15''][''option_desc''][''0''] = ''Alle verf&#252;gbaren Webgrafiken'';\r\n$mip_form[''15''][''option_val''][''0''] = ''true'';\r\n$mip_form[''15''][''option_desc''][''1''] = ''*.gif'';\r\n$mip_form[''15''][''option_val''][''1''] = ''gif'';\r\n$mip_form[''15''][''option_desc''][''2''] = ''*.jpg'';\r\n$mip_form[''15''][''option_val''][''2''] = ''jpg'';\r\n$mip_form[''15''][''option_desc''][''3''] = ''*.jpeg'';\r\n$mip_form[''15''][''option_val''][''3''] = ''jpeg'';\r\n$mip_form[''15''][''option_desc''][''4''] = ''*.png'';\r\n$mip_form[''15''][''option_val''][''4''] = ''png'';\r\n\r\n//Ordner\r\n$mip_form[''16''][''desc''] = ''Grafikauswahl aus folgenden Verzeichnissen'';\r\n$mip_form[''16''][''cat''] = ''app_directory'';\r\n$mip_form[''16''][''output_cat''] = ''option'';\r\n$mip_form[''16''][''cms_var''] = ''MOD_VAR[16]'';\r\n$mip_form[''16''][''cms_val''] = $cms_mod[''value''][''16''];\r\n$mip_form[''16''][''flag''] = ''multiple'';\r\n$mip_form[''16''][''size''] = ''5'';\r\n\r\n//Unterordner anzeigen\r\n$mip_form[''17''][''cat''] = ''option'';\r\n$mip_form[''17''][''desc''] = ''Unterordner automatisch anzeigen'';\r\n$mip_form[''17''][''cms_var''] = ''MOD_VAR[17]'';\r\n$mip_form[''17''][''cms_val''] = $cms_mod[''value''][''17''];\r\n$mip_form[''17''][''cms_val_default''] = ''false'';\r\n$mip_form[''17''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''17''][''option_val''][''0''] = ''true'';\r\n$mip_form[''17''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''17''][''option_val''][''1''] = ''false'';\r\n$mip_form[''17''][''tab''] = ''0'';\r\n\r\n// ***************************** Wysiyg2 aus dem Modul wysiwyg2 1.1 *********************\r\n\r\n//Dateilinks Ordner\r\n$mip_form[''18''][''desc''] = ''Dateiauswahl aus folgenden Verzeichnissen'';\r\n$mip_form[''18''][''cat''] = ''app_directory'';\r\n$mip_form[''18''][''output_cat''] = ''option'';\r\n$mip_form[''18''][''cms_var''] = ''MOD_VAR[18]'';\r\n$mip_form[''18''][''cms_val''] = $cms_mod[''value''][''18''];\r\n$mip_form[''18''][''flag''] = ''multiple'';\r\n$mip_form[''18''][''size''] = ''5'';\r\n\r\n//Mit Unterverzeichnissen\r\n$mip_form[''19''][''cat''] = ''option'';\r\n$mip_form[''19''][''type''] = '''';\r\n$mip_form[''19''][''desc''] = ''Unterordner automatisch anzeigen'';\r\n$mip_form[''19''][''cms_var''] = ''MOD_VAR[19]'';\r\n$mip_form[''19''][''cms_val''] = $cms_mod[''value''][''19''];\r\n$mip_form[''19''][''cms_val_default''] = ''false'';\r\n$mip_form[''19''][''option_desc''][''0''] = ''Nein'';\r\n$mip_form[''19''][''option_val''][''0''] = ''false'';\r\n$mip_form[''19''][''option_desc''][''1''] = ''Ja'';\r\n$mip_form[''19''][''option_val''][''1''] = ''true'';\r\n$mip_form[''19''][''tab''] = ''0'';\r\n\r\n//Dateilinks -typen\r\n$mip_form[''6''][''desc''] = ''Ausw&#228;hlbare Dateitypen'';\r\n$mip_form[''6''][''cat''] = ''app_filetype'';\r\n$mip_form[''6''][''output_cat''] = ''option'';\r\n$mip_form[''6''][''cms_var''] = ''MOD_VAR[6]'';\r\n$mip_form[''6''][''cms_val''] = $cms_mod[''value''][''6''];\r\n$mip_form[''6''][''flag''] = ''multiple'';\r\n$mip_form[''6''][''size''] = ''5'';\r\n\r\n//configmode\r\n$mip_form[''329''][''desc''] = ''Separate Schaltfl&#228;chenkonfigurationen f&#252;r {wysiwyg2:1-5}'';\r\n$mip_form[''329''][''cat''] = ''option'';\r\n$mip_form[''329''][''size''] = ''1'';\r\n$mip_form[''329''][''option_desc''][] = ''Nein'';\r\n$mip_form[''329''][''option_val''][] = ''false'';\r\n$mip_form[''329''][''option_desc''][] = ''Ja'';\r\n$mip_form[''329''][''option_val''][] = ''true'';\r\n$mip_form[''329''][''cms_var''] = ''MOD_VAR[329]'';\r\n$mip_form[''329''][''cms_val''] = $cms_mod[''value''][''329''];\r\n$mip_form[''329''][''flag''] = ''reload'';\r\n\r\n//Featureauswahl\r\n$mip_form[''3''][''desc''] = ''Anzuzeigende Schaltfl&#228;chen''.(($cms_mod[''value''][''329''] == ''true'')?''<br/><small>{wysiwyg2:<strong>1</strong>}</small>'':'''');\r\n$mip_form[''3''][''cat''] = ''option'';\r\n$mip_form[''3''][''flag''] = ''multiple'';\r\n$mip_form[''3''][''size''] = ''7'';\r\n$mip_form[''3''][''option_desc''][] = ''Alle Felder sichtbar'';\r\n$mip_form[''3''][''option_val''][] = ''true'';\r\n$mip_form[''3''][''option_desc''][] = ''Fonts'';\r\n$mip_form[''3''][''option_val''][] = ''font'';\r\n$mip_form[''3''][''option_desc''][] = ''Fontgr&#246;sse'';\r\n$mip_form[''3''][''option_val''][] = ''fontsize'';\r\n$mip_form[''3''][''option_desc''][] = ''Stylesheets'';\r\n$mip_form[''3''][''option_val''][] = ''styles'';\r\n$mip_form[''3''][''option_desc''][] = ''Text zur&#252;cksetzten'';\r\n$mip_form[''3''][''option_val''][] = ''reset'';\r\n$mip_form[''3''][''option_desc''][] = ''Vorschau'';\r\n$mip_form[''3''][''option_val''][] = ''preview'';\r\n$mip_form[''3''][''option_desc''][] = ''Drucken'';\r\n$mip_form[''3''][''option_val''][] = ''print'';\r\n$mip_form[''3''][''option_desc''][] = ''Zwischenablagefunktionen'';\r\n$mip_form[''3''][''option_val''][] = ''clipboardtools'';\r\n$mip_form[''3''][''option_desc''][] = ''HTMLtags entfernen'';\r\n$mip_form[''3''][''option_val''][] = ''striptag'';\r\n$mip_form[''3''][''option_desc''][] = ''Undo/ Redo'';\r\n$mip_form[''3''][''option_val''][] = ''undo'';\r\n$mip_form[''3''][''option_desc''][] = ''Suchen und Ersetzen'';\r\n$mip_form[''3''][''option_val''][] = ''search'';\r\n$mip_form[''3''][''option_desc''][] = ''Upper-, Lowercase'';\r\n$mip_form[''3''][''option_val''][] = ''changecase'';\r\n$mip_form[''3''][''option_desc''][] = ''Umschalten in HTMLansicht'';\r\n$mip_form[''3''][''option_val''][] = ''changemode'';\r\n$mip_form[''3''][''option_desc''][] = ''Externes Bearbeitungsfenster'';\r\n$mip_form[''3''][''option_val''][] = ''popupeditor'';\r\n$mip_form[''3''][''option_desc''][] = ''Tabellen'';\r\n$mip_form[''3''][''option_val''][] = ''table'';\r\n$mip_form[''3''][''option_desc''][] = ''Fett'';\r\n$mip_form[''3''][''option_val''][] = ''bold'';\r\n$mip_form[''3''][''option_desc''][] = ''Kursiv'';\r\n$mip_form[''3''][''option_val''][] = ''italic'';\r\n$mip_form[''3''][''option_desc''][] = ''Unterstrichen'';\r\n$mip_form[''3''][''option_val''][] = ''underline'';\r\n$mip_form[''3''][''option_desc''][] = ''Durchgestrichen'';\r\n$mip_form[''3''][''option_val''][] = ''strikethrough'';\r\n$mip_form[''3''][''option_desc''][] = ''Tiefgestellt'';\r\n$mip_form[''3''][''option_val''][] = ''subscript'';\r\n$mip_form[''3''][''option_desc''][] = ''Hochgestellt'';\r\n$mip_form[''3''][''option_val''][] = ''superscript'';\r\n$mip_form[''3''][''option_desc''][] = ''Ausrichtung'';\r\n$mip_form[''3''][''option_val''][] = ''align'';\r\n$mip_form[''3''][''option_desc''][] = ''Fontfarbe'';\r\n$mip_form[''3''][''option_val''][] = ''fontcolor'';\r\n$mip_form[''3''][''option_desc''][] = ''Hintergrundfarbe'';\r\n$mip_form[''3''][''option_val''][] = ''backgroundcolor'';\r\n$mip_form[''3''][''option_desc''][] = ''Listen'';\r\n$mip_form[''3''][''option_val''][] = ''list'';\r\n$mip_form[''3''][''option_desc''][] = ''Einr&#252;ckung'';\r\n$mip_form[''3''][''option_val''][] = ''indent'';\r\n$mip_form[''3''][''option_desc''][] = ''Links einf&#252;gen'';\r\n$mip_form[''3''][''option_val''][] = ''link'';\r\n$mip_form[''3''][''option_desc''][] = ''Bilder einf&#252;gen'';\r\n$mip_form[''3''][''option_val''][] = ''image'';\r\n$mip_form[''3''][''option_desc''][] = ''Dateien einf&#252;gen'';\r\n$mip_form[''3''][''option_val''][] = ''file'';\r\n$mip_form[''3''][''option_desc''][] = ''Liveresize'';\r\n$mip_form[''3''][''option_val''][] = ''liveresize'';\r\n$mip_form[''3''][''option_desc''][] = ''Mehrfachauswahl'';\r\n$mip_form[''3''][''option_val''][] = ''multipleselect'';\r\n$mip_form[''3''][''option_desc''][] = ''Trennlinie'';\r\n$mip_form[''3''][''option_val''][] = ''hr'';\r\n$mip_form[''3''][''option_desc''][] = ''Besondere Zeichen'';\r\n$mip_form[''3''][''option_val''][] = ''specialchars'';\r\n$mip_form[''3''][''option_desc''][] = ''Aktuelles Datum'';\r\n$mip_form[''3''][''option_val''][] = ''date'';\r\n$mip_form[''3''][''option_desc''][] = ''Lauftexteditor'';\r\n$mip_form[''3''][''option_val''][] = ''marquee'';\r\n$mip_form[''3''][''cms_var''] = ''MOD_VAR[3]'';\r\n$mip_form[''3''][''cms_val''] = $cms_mod[''value''][''3'']; \r\n//Featureauswahl\r\n$mip_form[''331''][''desc''] = ''Anzuzeigende Schaltfl&#228;chen <br/><small>{wysiwyg2:<strong>3</strong>}</small>'';\r\n$mip_form[''331''][''cat''] = ''option'';\r\n$mip_form[''331''][''flag''] = ''multiple'';\r\n$mip_form[''331''][''size''] = ''7'';\r\n$mip_form[''331''][''option_desc''][] = ''Alle Felder sichtbar'';\r\n$mip_form[''331''][''option_val''][] = ''true'';\r\n$mip_form[''331''][''option_desc''][] = ''Fonts'';\r\n$mip_form[''331''][''option_val''][] = ''font'';\r\n$mip_form[''331''][''option_desc''][] = ''Fontgr&#246;sse'';\r\n$mip_form[''331''][''option_val''][] = ''fontsize'';\r\n$mip_form[''331''][''option_desc''][] = ''Stylesheets'';\r\n$mip_form[''331''][''option_val''][] = ''styles'';\r\n$mip_form[''331''][''option_desc''][] = ''Text zur&#252;cksetzten'';\r\n$mip_form[''331''][''option_val''][] = ''reset'';\r\n$mip_form[''331''][''option_desc''][] = ''Vorschau'';\r\n$mip_form[''331''][''option_val''][] = ''preview'';\r\n$mip_form[''331''][''option_desc''][] = ''Drucken'';\r\n$mip_form[''331''][''option_val''][] = ''print'';\r\n$mip_form[''331''][''option_desc''][] = ''Zwischenablagefunktionen'';\r\n$mip_form[''331''][''option_val''][] = ''clipboardtools'';\r\n$mip_form[''331''][''option_desc''][] = ''HTMLtags entfernen'';\r\n$mip_form[''331''][''option_val''][] = ''striptag'';\r\n$mip_form[''331''][''option_desc''][] = ''Undo/ Redo'';\r\n$mip_form[''331''][''option_val''][] = ''undo'';\r\n$mip_form[''331''][''option_desc''][] = ''Suchen und Ersetzen'';\r\n$mip_form[''331''][''option_val''][] = ''search'';\r\n$mip_form[''331''][''option_desc''][] = ''Upper-, Lowercase'';\r\n$mip_form[''331''][''option_val''][] = ''changecase'';\r\n$mip_form[''331''][''option_desc''][] = ''Umschalten in HTMLansicht'';\r\n$mip_form[''331''][''option_val''][] = ''changemode'';\r\n$mip_form[''331''][''option_desc''][] = ''Externes Bearbeitungsfenster'';\r\n$mip_form[''331''][''option_val''][] = ''popupeditor'';\r\n$mip_form[''331''][''option_desc''][] = ''Tabellen'';\r\n$mip_form[''331''][''option_val''][] = ''table'';\r\n$mip_form[''331''][''option_desc''][] = ''Fett'';\r\n$mip_form[''331''][''option_val''][] = ''bold'';\r\n$mip_form[''331''][''option_desc''][] = ''Kursiv'';\r\n$mip_form[''331''][''option_val''][] = ''italic'';\r\n$mip_form[''331''][''option_desc''][] = ''Unterstrichen'';\r\n$mip_form[''331''][''option_val''][] = ''underline'';\r\n$mip_form[''331''][''option_desc''][] = ''Durchgestrichen'';\r\n$mip_form[''331''][''option_val''][] = ''strikethrough'';\r\n$mip_form[''331''][''option_desc''][] = ''Tiefgestellt'';\r\n$mip_form[''331''][''option_val''][] = ''subscript'';\r\n$mip_form[''331''][''option_desc''][] = ''Hochgestellt'';\r\n$mip_form[''331''][''option_val''][] = ''superscript'';\r\n$mip_form[''331''][''option_desc''][] = ''Ausrichtung'';\r\n$mip_form[''331''][''option_val''][] = ''align'';\r\n$mip_form[''331''][''option_desc''][] = ''Fontfarbe'';\r\n$mip_form[''331''][''option_val''][] = ''fontcolor'';\r\n$mip_form[''331''][''option_desc''][] = ''Hintergrundfarbe'';\r\n$mip_form[''331''][''option_val''][] = ''backgroundcolor'';\r\n$mip_form[''331''][''option_desc''][] = ''Listen'';\r\n$mip_form[''331''][''option_val''][] = ''list'';\r\n$mip_form[''331''][''option_desc''][] = ''Einr&#252;ckung'';\r\n$mip_form[''331''][''option_val''][] = ''indent'';\r\n$mip_form[''331''][''option_desc''][] = ''Links einf&#252;gen'';\r\n$mip_form[''331''][''option_val''][] = ''link'';\r\n$mip_form[''331''][''option_desc''][] = ''Bilder einf&#252;gen'';\r\n$mip_form[''331''][''option_val''][] = ''image'';\r\n$mip_form[''331''][''option_desc''][] = ''Dateien einf&#252;gen'';\r\n$mip_form[''331''][''option_val''][] = ''file'';\r\n$mip_form[''331''][''option_desc''][] = ''Liveresize'';\r\n$mip_form[''331''][''option_val''][] = ''liveresize'';\r\n$mip_form[''331''][''option_desc''][] = ''Mehrfachauswahl'';\r\n$mip_form[''331''][''option_val''][] = ''multipleselect'';\r\n$mip_form[''331''][''option_desc''][] = ''Trennlinie'';\r\n$mip_form[''331''][''option_val''][] = ''hr'';\r\n$mip_form[''331''][''option_desc''][] = ''Besondere Zeichen'';\r\n$mip_form[''331''][''option_val''][] = ''specialchars'';\r\n$mip_form[''331''][''option_desc''][] = ''Aktuelles Datum'';\r\n$mip_form[''331''][''option_val''][] = ''date'';\r\n$mip_form[''331''][''option_desc''][] = ''Lauftexteditor'';\r\n$mip_form[''331''][''option_val''][] = ''marquee'';\r\n$mip_form[''331''][''cms_var''] = ''MOD_VAR[331]'';\r\n$mip_form[''331''][''cms_val''] = $cms_mod[''value''][''331''];\r\n\r\n//Featureauswahl\r\n$mip_form[''330''][''desc''] = ''Anzuzeigende Schaltfl&#228;chen <br/><small>{wysiwyg2:<strong>2</strong>}</small>'';\r\n$mip_form[''330''][''cat''] = ''option'';\r\n$mip_form[''330''][''flag''] = ''multiple'';\r\n$mip_form[''330''][''size''] = ''7'';\r\n$mip_form[''330''][''option_desc''][] = ''Alle Felder sichtbar'';\r\n$mip_form[''330''][''option_val''][] = ''true'';\r\n$mip_form[''330''][''option_desc''][] = ''Fonts'';\r\n$mip_form[''330''][''option_val''][] = ''font'';\r\n$mip_form[''330''][''option_desc''][] = ''Fontgr&#246;sse'';\r\n$mip_form[''330''][''option_val''][] = ''fontsize'';\r\n$mip_form[''330''][''option_desc''][] = ''Stylesheets'';\r\n$mip_form[''330''][''option_val''][] = ''styles'';\r\n$mip_form[''330''][''option_desc''][] = ''Text zur&#252;cksetzten'';\r\n$mip_form[''330''][''option_val''][] = ''reset'';\r\n$mip_form[''330''][''option_desc''][] = ''Vorschau'';\r\n$mip_form[''330''][''option_val''][] = ''preview'';\r\n$mip_form[''330''][''option_desc''][] = ''Drucken'';\r\n$mip_form[''330''][''option_val''][] = ''print'';\r\n$mip_form[''330''][''option_desc''][] = ''Zwischenablagefunktionen'';\r\n$mip_form[''330''][''option_val''][] = ''clipboardtools'';\r\n$mip_form[''330''][''option_desc''][] = ''HTMLtags entfernen'';\r\n$mip_form[''330''][''option_val''][] = ''striptag'';\r\n$mip_form[''330''][''option_desc''][] = ''Undo/ Redo'';\r\n$mip_form[''330''][''option_val''][] = ''undo'';\r\n$mip_form[''330''][''option_desc''][] = ''Suchen und Ersetzen'';\r\n$mip_form[''330''][''option_val''][] = ''search'';\r\n$mip_form[''330''][''option_desc''][] = ''Upper-, Lowercase'';\r\n$mip_form[''330''][''option_val''][] = ''changecase'';\r\n$mip_form[''330''][''option_desc''][] = ''Umschalten in HTMLansicht'';\r\n$mip_form[''330''][''option_val''][] = ''changemode'';\r\n$mip_form[''330''][''option_desc''][] = ''Externes Bearbeitungsfenster'';\r\n$mip_form[''330''][''option_val''][] = ''popupeditor'';\r\n$mip_form[''330''][''option_desc''][] = ''Tabellen'';\r\n$mip_form[''330''][''option_val''][] = ''table'';\r\n$mip_form[''330''][''option_desc''][] = ''Fett'';\r\n$mip_form[''330''][''option_val''][] = ''bold'';\r\n$mip_form[''330''][''option_desc''][] = ''Kursiv'';\r\n$mip_form[''330''][''option_val''][] = ''italic'';\r\n$mip_form[''330''][''option_desc''][] = ''Unterstrichen'';\r\n$mip_form[''330''][''option_val''][] = ''underline'';\r\n$mip_form[''330''][''option_desc''][] = ''Durchgestrichen'';\r\n$mip_form[''330''][''option_val''][] = ''strikethrough'';\r\n$mip_form[''330''][''option_desc''][] = ''Tiefgestellt'';\r\n$mip_form[''330''][''option_val''][] = ''subscript'';\r\n$mip_form[''330''][''option_desc''][] = ''Hochgestellt'';\r\n$mip_form[''330''][''option_val''][] = ''superscript'';\r\n$mip_form[''330''][''option_desc''][] = ''Ausrichtung'';\r\n$mip_form[''330''][''option_val''][] = ''align'';\r\n$mip_form[''330''][''option_desc''][] = ''Fontfarbe'';\r\n$mip_form[''330''][''option_val''][] = ''fontcolor'';\r\n$mip_form[''330''][''option_desc''][] = ''Hintergrundfarbe'';\r\n$mip_form[''330''][''option_val''][] = ''backgroundcolor'';\r\n$mip_form[''330''][''option_desc''][] = ''Listen'';\r\n$mip_form[''330''][''option_val''][] = ''list'';\r\n$mip_form[''330''][''option_desc''][] = ''Einr&#252;ckung'';\r\n$mip_form[''330''][''option_val''][] = ''indent'';\r\n$mip_form[''330''][''option_desc''][] = ''Links einf&#252;gen'';\r\n$mip_form[''330''][''option_val''][] = ''link'';\r\n$mip_form[''330''][''option_desc''][] = ''Bilder einf&#252;gen'';\r\n$mip_form[''330''][''option_val''][] = ''image'';\r\n$mip_form[''330''][''option_desc''][] = ''Dateien einf&#252;gen'';\r\n$mip_form[''330''][''option_val''][] = ''file'';\r\n$mip_form[''330''][''option_desc''][] = ''Liveresize'';\r\n$mip_form[''330''][''option_val''][] = ''liveresize'';\r\n$mip_form[''330''][''option_desc''][] = ''Mehrfachauswahl'';\r\n$mip_form[''330''][''option_val''][] = ''multipleselect'';\r\n$mip_form[''330''][''option_desc''][] = ''Trennlinie'';\r\n$mip_form[''330''][''option_val''][] = ''hr'';\r\n$mip_form[''330''][''option_desc''][] = ''Besondere Zeichen'';\r\n$mip_form[''330''][''option_val''][] = ''specialchars'';\r\n$mip_form[''330''][''option_desc''][] = ''Aktuelles Datum'';\r\n$mip_form[''330''][''option_val''][] = ''date'';\r\n$mip_form[''330''][''option_desc''][] = ''Lauftexteditor'';\r\n$mip_form[''330''][''option_val''][] = ''marquee'';\r\n$mip_form[''330''][''cms_var''] = ''MOD_VAR[330]'';\r\n$mip_form[''330''][''cms_val''] = $cms_mod[''value''][''330''];\r\n\r\n\r\n//Featureauswahl\r\n$mip_form[''332''][''desc''] = ''Anzuzeigende Schaltfl&#228;chen <br/><small>{wysiwyg2:<strong>4</strong>}</small>'';\r\n$mip_form[''332''][''cat''] = ''option'';\r\n$mip_form[''332''][''flag''] = ''multiple'';\r\n$mip_form[''332''][''size''] = ''7'';\r\n$mip_form[''332''][''option_desc''][] = ''Alle Felder sichtbar'';\r\n$mip_form[''332''][''option_val''][] = ''true'';\r\n$mip_form[''332''][''option_desc''][] = ''Fonts'';\r\n$mip_form[''332''][''option_val''][] = ''font'';\r\n$mip_form[''332''][''option_desc''][] = ''Fontgr&#246;sse'';\r\n$mip_form[''332''][''option_val''][] = ''fontsize'';\r\n$mip_form[''332''][''option_desc''][] = ''Stylesheets'';\r\n$mip_form[''332''][''option_val''][] = ''styles'';\r\n$mip_form[''332''][''option_desc''][] = ''Text zur&#252;cksetzten'';\r\n$mip_form[''332''][''option_val''][] = ''reset'';\r\n$mip_form[''332''][''option_desc''][] = ''Vorschau'';\r\n$mip_form[''332''][''option_val''][] = ''preview'';\r\n$mip_form[''332''][''option_desc''][] = ''Drucken'';\r\n$mip_form[''332''][''option_val''][] = ''print'';\r\n$mip_form[''332''][''option_desc''][] = ''Zwischenablagefunktionen'';\r\n$mip_form[''332''][''option_val''][] = ''clipboardtools'';\r\n$mip_form[''332''][''option_desc''][] = ''HTMLtags entfernen'';\r\n$mip_form[''332''][''option_val''][] = ''striptag'';\r\n$mip_form[''332''][''option_desc''][] = ''Undo/ Redo'';\r\n$mip_form[''332''][''option_val''][] = ''undo'';\r\n$mip_form[''332''][''option_desc''][] = ''Suchen und Ersetzen'';\r\n$mip_form[''332''][''option_val''][] = ''search'';\r\n$mip_form[''332''][''option_desc''][] = ''Upper-, Lowercase'';\r\n$mip_form[''332''][''option_val''][] = ''changecase'';\r\n$mip_form[''332''][''option_desc''][] = ''Umschalten in HTMLansicht'';\r\n$mip_form[''332''][''option_val''][] = ''changemode'';\r\n$mip_form[''332''][''option_desc''][] = ''Externes Bearbeitungsfenster'';\r\n$mip_form[''332''][''option_val''][] = ''popupeditor'';\r\n$mip_form[''332''][''option_desc''][] = ''Tabellen'';\r\n$mip_form[''332''][''option_val''][] = ''table'';\r\n$mip_form[''332''][''option_desc''][] = ''Fett'';\r\n$mip_form[''332''][''option_val''][] = ''bold'';\r\n$mip_form[''332''][''option_desc''][] = ''Kursiv'';\r\n$mip_form[''332''][''option_val''][] = ''italic'';\r\n$mip_form[''332''][''option_desc''][] = ''Unterstrichen'';\r\n$mip_form[''332''][''option_val''][] = ''underline'';\r\n$mip_form[''332''][''option_desc''][] = ''Durchgestrichen'';\r\n$mip_form[''332''][''option_val''][] = ''strikethrough'';\r\n$mip_form[''332''][''option_desc''][] = ''Tiefgestellt'';\r\n$mip_form[''332''][''option_val''][] = ''subscript'';\r\n$mip_form[''332''][''option_desc''][] = ''Hochgestellt'';\r\n$mip_form[''332''][''option_val''][] = ''superscript'';\r\n$mip_form[''332''][''option_desc''][] = ''Ausrichtung'';\r\n$mip_form[''332''][''option_val''][] = ''align'';\r\n$mip_form[''332''][''option_desc''][] = ''Fontfarbe'';\r\n$mip_form[''332''][''option_val''][] = ''fontcolor'';\r\n$mip_form[''332''][''option_desc''][] = ''Hintergrundfarbe'';\r\n$mip_form[''332''][''option_val''][] = ''backgroundcolor'';\r\n$mip_form[''332''][''option_desc''][] = ''Listen'';\r\n$mip_form[''332''][''option_val''][] = ''list'';\r\n$mip_form[''332''][''option_desc''][] = ''Einr&#252;ckung'';\r\n$mip_form[''332''][''option_val''][] = ''indent'';\r\n$mip_form[''332''][''option_desc''][] = ''Links einf&#252;gen'';\r\n$mip_form[''332''][''option_val''][] = ''link'';\r\n$mip_form[''332''][''option_desc''][] = ''Bilder einf&#252;gen'';\r\n$mip_form[''332''][''option_val''][] = ''image'';\r\n$mip_form[''332''][''option_desc''][] = ''Dateien einf&#252;gen'';\r\n$mip_form[''332''][''option_val''][] = ''file'';\r\n$mip_form[''332''][''option_desc''][] = ''Liveresize'';\r\n$mip_form[''332''][''option_val''][] = ''liveresize'';\r\n$mip_form[''332''][''option_desc''][] = ''Mehrfachauswahl'';\r\n$mip_form[''332''][''option_val''][] = ''multipleselect'';\r\n$mip_form[''332''][''option_desc''][] = ''Trennlinie'';\r\n$mip_form[''332''][''option_val''][] = ''hr'';\r\n$mip_form[''332''][''option_desc''][] = ''Besondere Zeichen'';\r\n$mip_form[''332''][''option_val''][] = ''specialchars'';\r\n$mip_form[''332''][''option_desc''][] = ''Aktuelles Datum'';\r\n$mip_form[''332''][''option_val''][] = ''date'';\r\n$mip_form[''332''][''option_desc''][] = ''Lauftexteditor'';\r\n$mip_form[''332''][''option_val''][] = ''marquee'';\r\n$mip_form[''332''][''cms_var''] = ''MOD_VAR[332]'';\r\n$mip_form[''332''][''cms_val''] = $cms_mod[''value''][''332''];\r\n\r\n\r\n//Featureauswahl\r\n$mip_form[''333''][''desc''] = ''Anzuzeigende Schaltfl&#228;chen <br/><small>{wysiwyg2:<strong>5</strong>}</small>'';\r\n$mip_form[''333''][''cat''] = ''option'';\r\n$mip_form[''333''][''flag''] = ''multiple'';\r\n$mip_form[''333''][''size''] = ''7'';\r\n$mip_form[''333''][''option_desc''][] = ''Alle Felder sichtbar'';\r\n$mip_form[''333''][''option_val''][] = ''true'';\r\n$mip_form[''333''][''option_desc''][] = ''Fonts'';\r\n$mip_form[''333''][''option_val''][] = ''font'';\r\n$mip_form[''333''][''option_desc''][] = ''Fontgr&#246;sse'';\r\n$mip_form[''333''][''option_val''][] = ''fontsize'';\r\n$mip_form[''333''][''option_desc''][] = ''Stylesheets'';\r\n$mip_form[''333''][''option_val''][] = ''styles'';\r\n$mip_form[''333''][''option_desc''][] = ''Text zur&#252;cksetzten'';\r\n$mip_form[''333''][''option_val''][] = ''reset'';\r\n$mip_form[''333''][''option_desc''][] = ''Vorschau'';\r\n$mip_form[''333''][''option_val''][] = ''preview'';\r\n$mip_form[''333''][''option_desc''][] = ''Drucken'';\r\n$mip_form[''333''][''option_val''][] = ''print'';\r\n$mip_form[''333''][''option_desc''][] = ''Zwischenablagefunktionen'';\r\n$mip_form[''333''][''option_val''][] = ''clipboardtools'';\r\n$mip_form[''333''][''option_desc''][] = ''HTMLtags entfernen'';\r\n$mip_form[''333''][''option_val''][] = ''striptag'';\r\n$mip_form[''333''][''option_desc''][] = ''Undo/ Redo'';\r\n$mip_form[''333''][''option_val''][] = ''undo'';\r\n$mip_form[''333''][''option_desc''][] = ''Suchen und Ersetzen'';\r\n$mip_form[''333''][''option_val''][] = ''search'';\r\n$mip_form[''333''][''option_desc''][] = ''Upper-, Lowercase'';\r\n$mip_form[''333''][''option_val''][] = ''changecase'';\r\n$mip_form[''333''][''option_desc''][] = ''Umschalten in HTMLansicht'';\r\n$mip_form[''333''][''option_val''][] = ''changemode'';\r\n$mip_form[''333''][''option_desc''][] = ''Externes Bearbeitungsfenster'';\r\n$mip_form[''333''][''option_val''][] = ''popupeditor'';\r\n$mip_form[''333''][''option_desc''][] = ''Tabellen'';\r\n$mip_form[''333''][''option_val''][] = ''table'';\r\n$mip_form[''333''][''option_desc''][] = ''Fett'';\r\n$mip_form[''333''][''option_val''][] = ''bold'';\r\n$mip_form[''333''][''option_desc''][] = ''Kursiv'';\r\n$mip_form[''333''][''option_val''][] = ''italic'';\r\n$mip_form[''333''][''option_desc''][] = ''Unterstrichen'';\r\n$mip_form[''333''][''option_val''][] = ''underline'';\r\n$mip_form[''333''][''option_desc''][] = ''Durchgestrichen'';\r\n$mip_form[''333''][''option_val''][] = ''strikethrough'';\r\n$mip_form[''333''][''option_desc''][] = ''Tiefgestellt'';\r\n$mip_form[''333''][''option_val''][] = ''subscript'';\r\n$mip_form[''333''][''option_desc''][] = ''Hochgestellt'';\r\n$mip_form[''333''][''option_val''][] = ''superscript'';\r\n$mip_form[''333''][''option_desc''][] = ''Ausrichtung'';\r\n$mip_form[''333''][''option_val''][] = ''align'';\r\n$mip_form[''333''][''option_desc''][] = ''Fontfarbe'';\r\n$mip_form[''333''][''option_val''][] = ''fontcolor'';\r\n$mip_form[''333''][''option_desc''][] = ''Hintergrundfarbe'';\r\n$mip_form[''333''][''option_val''][] = ''backgroundcolor'';\r\n$mip_form[''333''][''option_desc''][] = ''Listen'';\r\n$mip_form[''333''][''option_val''][] = ''list'';\r\n$mip_form[''333''][''option_desc''][] = ''Einr&#252;ckung'';\r\n$mip_form[''333''][''option_val''][] = ''indent'';\r\n$mip_form[''333''][''option_desc''][] = ''Links einf&#252;gen'';\r\n$mip_form[''333''][''option_val''][] = ''link'';\r\n$mip_form[''333''][''option_desc''][] = ''Bilder einf&#252;gen'';\r\n$mip_form[''333''][''option_val''][] = ''image'';\r\n$mip_form[''333''][''option_desc''][] = ''Dateien einf&#252;gen'';\r\n$mip_form[''333''][''option_val''][] = ''file'';\r\n$mip_form[''333''][''option_desc''][] = ''Liveresize'';\r\n$mip_form[''333''][''option_val''][] = ''liveresize'';\r\n$mip_form[''333''][''option_desc''][] = ''Mehrfachauswahl'';\r\n$mip_form[''333''][''option_val''][] = ''multipleselect'';\r\n$mip_form[''333''][''option_desc''][] = ''Trennlinie'';\r\n$mip_form[''333''][''option_val''][] = ''hr'';\r\n$mip_form[''333''][''option_desc''][] = ''Besondere Zeichen'';\r\n$mip_form[''333''][''option_val''][] = ''specialchars'';\r\n$mip_form[''333''][''option_desc''][] = ''Aktuelles Datum'';\r\n$mip_form[''333''][''option_val''][] = ''date'';\r\n$mip_form[''333''][''option_desc''][] = ''Lauftexteditor'';\r\n$mip_form[''333''][''option_val''][] = ''marquee'';\r\n$mip_form[''333''][''cms_var''] = ''MOD_VAR[333]'';\r\n$mip_form[''333''][''cms_val''] = $cms_mod[''value''][''333''];\r\n\r\n\r\nif ($cms_mod[''value''][''329''] != ''true'') {\r\n $mip_form[''330''][''cms_val''] = $cms_mod[''value''][''3''];\r\n $mip_form[''331''][''cms_val''] = $cms_mod[''value''][''3''];\r\n $mip_form[''332''][''cms_val''] = $cms_mod[''value''][''3''];\r\n $mip_form[''333''][''cms_val''] = $cms_mod[''value''][''3''];\r\n $mip_form[''330''][''cat''] = ''hidden'';\r\n $mip_form[''331''][''cat''] = ''hidden'';\r\n $mip_form[''332''][''cat''] = ''hidden'';\r\n $mip_form[''333''][''cat''] = ''hidden'';\r\n}\r\n//Auswaehlbare Stylesheets\r\n$mip_form[''4''][''desc''] = ''F&#252;r den Redakteur ausw&#228;hlbare Stylesheets'';\r\n$mip_form[''4''][''cat''] = ''app_css'';\r\n$mip_form[''4''][''output_cat''] = ''option'';\r\n$mip_form[''4''][''output_flag''] = ''multiple'';\r\n$mip_form[''4''][''size''] = ''5'';\r\n$mip_form[''4''][''cms_var''] = ''MOD_VAR[4]'';\r\n$mip_form[''4''][''cms_val''] = $cms_mod[''value''][''4''];\r\n$mip_form[''4''][''flag''] = ''class_only'';\r\n$mip_form[''4''][''return_val''] = ''idcssupl'';\r\n\r\n// styleclass {wysiwyg2:x}\r\n$mip_form[''28''][''cat''] = ''txt'';\r\n$mip_form[''28''][''type''] = '''';\r\n$mip_form[''28''][''desc''] = ''Styleclass'';\r\n$mip_form[''28''][''cms_var''] = ''MOD_VAR[28]'';\r\n$mip_form[''28''][''cms_val''] = $cms_mod[''value''][''28''];\r\n$mip_form[''28''][''cms_val_default''] = '''';\r\n\r\n// ***************************** Dateilink aus dem Modul Dateilink 1.0 *********************\r\n\r\n//target verstecken\r\n$mip_form[''27''][''cat''] = ''option'';\r\n$mip_form[''27''][''type''] = '''';\r\n$mip_form[''27''][''desc''] = ''Im Bearbeitungsmodus Zielfensterfeld ausblenden''.(($cms_mod[''value''][''2003'']==''rb'')?''<br/><small>{filelist} (-> Methode Resource-Browser / Dateiauswahl)</small>'':'''');\r\n$mip_form[''27''][''cms_var''] = ''MOD_VAR[27]'';\r\n$mip_form[''27''][''cms_val''] = $cms_mod[''value''][''27''];\r\n$mip_form[''27''][''cms_val_default''] = ''false'';\r\n$mip_form[''27''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''27''][''option_val''][''0''] = ''true'';\r\n$mip_form[''27''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''27''][''option_val''][''1''] = ''false'';\r\n$mip_form[''27''][''tab''] = ''0'';\r\n\r\n\r\n// ***************************** Date aus dem Modul Datum 0.8 *********************\r\n\r\n// Datum mode\r\n$mip_form[''53''][''cat''] = ''txt'';\r\n$mip_form[''53''][''type''] = '''';\r\n$mip_form[''53''][''desc''] = ''Anzeigeart <small>{date:<strong>1</strong>}</small>'';\r\n$mip_form[''53''][''cms_var''] = ''MOD_VAR[53]'';\r\n$mip_form[''53''][''cms_val''] = $cms_mod[''value''][''53''];\r\n$mip_form[''53''][''cms_val_default''] = ''default-cms-date-format'';\r\n$mip_form[''53''][''tab''] = ''0'';\r\n\r\n//formDateFormat \r\n$mip_form[''54''][''cat''] = ''txt'';\r\n$mip_form[''54''][''type''] = '''';\r\n$mip_form[''54''][''desc''] = ''Eingabeart <small>{date:<strong>1</strong>}</small>'';\r\n$mip_form[''54''][''cms_var''] = ''MOD_VAR[54]'';\r\n$mip_form[''54''][''cms_val''] = $cms_mod[''value''][''54''];\r\n$mip_form[''54''][''cms_val_default''] = '''';\r\n$mip_form[''54''][''tab''] = ''0'';\r\n\r\n// Datum mode\r\n$mip_form[''71''][''cat''] = ''txt'';\r\n$mip_form[''71''][''type''] = '''';\r\n$mip_form[''71''][''desc''] = ''Anzeigeart <small>{date:<strong>2</strong>}</small>'';\r\n$mip_form[''71''][''cms_var''] = ''MOD_VAR[71]'';\r\n$mip_form[''71''][''cms_val''] = $cms_mod[''value''][''71''];\r\n$mip_form[''71''][''cms_val_default''] = ''default-cms-date-format'';\r\n$mip_form[''71''][''tab''] = ''0'';\r\n\r\n//formDateFormat \r\n$mip_form[''72''][''cat''] = ''txt'';\r\n$mip_form[''72''][''type''] = '''';\r\n$mip_form[''72''][''desc''] = ''Eingabeart <small>{date:<strong>2</strong>}</small>'';\r\n$mip_form[''72''][''cms_var''] = ''MOD_VAR[72]'';\r\n$mip_form[''72''][''cms_val''] = $cms_mod[''value''][''72''];\r\n$mip_form[''72''][''cms_val_default''] = '''';\r\n$mip_form[''72''][''tab''] = ''0'';\r\n\r\n// Datum mode\r\n$mip_form[''73''][''cat''] = ''txt'';\r\n$mip_form[''73''][''type''] = '''';\r\n$mip_form[''73''][''desc''] = ''Anzeigeart <small>{date:<strong>3</strong>}</small>'';\r\n$mip_form[''73''][''cms_var''] = ''MOD_VAR[73]'';\r\n$mip_form[''73''][''cms_val''] = $cms_mod[''value''][''73''];\r\n$mip_form[''73''][''cms_val_default''] = ''default-cms-date-format'';\r\n$mip_form[''73''][''tab''] = ''0'';\r\n\r\n//formDateFormat \r\n$mip_form[''84''][''cat''] = ''txt'';\r\n$mip_form[''84''][''type''] = '''';\r\n$mip_form[''84''][''desc''] = ''Eingabeart <small>{date:<strong>3</strong>}</small>'';\r\n$mip_form[''84''][''cms_var''] = ''MOD_VAR[84]'';\r\n$mip_form[''84''][''cms_val''] = $cms_mod[''value''][''84''];\r\n$mip_form[''84''][''cms_val_default''] = '''';\r\n$mip_form[''84''][''tab''] = ''0'';\r\n\r\n// Datum mode\r\n$mip_form[''873''][''cat''] = ''txt'';\r\n$mip_form[''873''][''type''] = '''';\r\n$mip_form[''873''][''desc''] = ''Anzeigeart <small>{date:<strong>4</strong>}</small>'';\r\n$mip_form[''873''][''cms_var''] = ''MOD_VAR[873]'';\r\n$mip_form[''873''][''cms_val''] = $cms_mod[''value''][''873''];\r\n$mip_form[''873''][''cms_val_default''] = ''default-cms-date-format'';\r\n$mip_form[''873''][''tab''] = ''0'';\r\n\r\n//formDateFormat \r\n$mip_form[''884''][''cat''] = ''txt'';\r\n$mip_form[''884''][''type''] = '''';\r\n$mip_form[''884''][''desc''] = ''Eingabeart <small>{date:<strong>4</strong>}</small>'';\r\n$mip_form[''884''][''cms_var''] = ''MOD_VAR[884]'';\r\n$mip_form[''884''][''cms_val''] = $cms_mod[''value''][''884''];\r\n$mip_form[''884''][''cms_val_default''] = '''';\r\n$mip_form[''884''][''tab''] = ''0'';\r\n\r\n// Datum mode\r\n$mip_form[''874''][''cat''] = ''txt'';\r\n$mip_form[''874''][''type''] = '''';\r\n$mip_form[''874''][''desc''] = ''Anzeigeart <small>{date:<strong>5</strong>}</small>'';\r\n$mip_form[''874''][''cms_var''] = ''MOD_VAR[874]'';\r\n$mip_form[''874''][''cms_val''] = $cms_mod[''value''][''874''];\r\n$mip_form[''874''][''cms_val_default''] = ''default-cms-date-format'';\r\n$mip_form[''874''][''tab''] = ''0'';\r\n\r\n//formDateFormat \r\n$mip_form[''885''][''cat''] = ''txt'';\r\n$mip_form[''885''][''type''] = '''';\r\n$mip_form[''885''][''desc''] = ''Eingabeart <small>{date:<strong>5</strong>}</small>'';\r\n$mip_form[''885''][''cms_var''] = ''MOD_VAR[885]'';\r\n$mip_form[''885''][''cms_val''] = $cms_mod[''value''][''885''];\r\n$mip_form[''885''][''cms_val_default''] = '''';\r\n$mip_form[''885''][''tab''] = ''0'';\r\n// ***************************** Select aus dem Modul Select 0.8 *********************\r\n\r\n//element Name\r\n$mip_form[''74''][''cat''] = ''txt'';\r\n$mip_form[''74''][''type''] = '''';\r\n$mip_form[''74''][''desc''] = ''Eintr&#228;ge - angezeigte Werte'';\r\n$mip_form[''74''][''cms_var''] = ''MOD_VAR[74]'';\r\n$mip_form[''74''][''cms_val''] = $cms_mod[''value''][''74''];\r\n$mip_form[''74''][''cms_val_default''] = ''Feld1,Feld2'';\r\n$mip_form[''74''][''tab''] = ''0'';\r\n\r\n//element Value\r\n$mip_form[''75''][''cat''] = ''txt'';\r\n$mip_form[''75''][''type''] = '''';\r\n$mip_form[''75''][''desc''] = ''Eintr&#228;ge - Werte <br/><small>(Wenn leer gelten die angezeigten Werte)</small>'';\r\n$mip_form[''75''][''cms_var''] = ''MOD_VAR[75]'';\r\n$mip_form[''75''][''cms_val''] = $cms_mod[''value''][''75''];\r\n$mip_form[''75''][''cms_val_default''] = '''';\r\n$mip_form[''75''][''tab''] = ''0'';\r\n\r\n//Separator \r\n$mip_form[''76''][''cat''] = ''txt'';\r\n$mip_form[''76''][''type''] = '''';\r\n$mip_form[''76''][''desc''] = ''Eintr&#228;ge - Trenner <br/><small>(Standardseperator/ Trenner ist ein Komma)</small> '';\r\n$mip_form[''76''][''cms_var''] = ''MOD_VAR[76]'';\r\n$mip_form[''76''][''cms_val''] = $cms_mod[''value''][''76''];\r\n$mip_form[''76''][''cms_val_default''] = '','';\r\n$mip_form[''76''][''tab''] = ''0'';\r\n\r\n//Default Einstellung\r\n$mip_form[''77''][''cat''] = ''txt'';\r\n$mip_form[''77''][''type''] = '''';\r\n$mip_form[''77''][''desc''] = ''Vorselektierte Eintr&#228;ge'';\r\n$mip_form[''77''][''cms_var''] = ''MOD_VAR[77]'';\r\n$mip_form[''77''][''cms_val''] = $cms_mod[''value''][''77''];\r\n$mip_form[''77''][''cms_val_default''] = '''';\r\n$mip_form[''77''][''tab''] = ''0'';\r\n\r\n//Mehrfachauswahl \r\n$mip_form[''78''][''desc''] = ''Mehrfachauswahl aktivieren'';\r\n$mip_form[''78''][''cat''] = ''chk'';\r\n$mip_form[''78''][''option_var''][''0''] = ''MOD_VAR[78]'';\r\n$mip_form[''78''][''option_val''][''0''] = $cms_mod[''value''][''78''];\r\n$mip_form[''78''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''78''][''option_val_select''][''0''] = ''true'';\r\n\r\n//gr&#246;sse des Auswahlfeldes \r\n$mip_form[''79''][''cat''] = ''txt'';\r\n$mip_form[''79''][''type''] = '''';\r\n$mip_form[''79''][''desc''] = ''Anzahl gleichzeitig sichtbarer Eintr&#228;ge'';\r\n$mip_form[''79''][''cms_var''] = ''MOD_VAR[79]'';\r\n$mip_form[''79''][''cms_val''] = $cms_mod[''value''][''79''];\r\n$mip_form[''79''][''cms_val_default''] = '''';\r\n$mip_form[''79''][''tab''] = ''0'';\r\n\r\n//element Name\r\n$mip_form[''3074''][''cat''] = ''txt'';\r\n$mip_form[''3074''][''type''] = '''';\r\n$mip_form[''3074''][''desc''] = ''Eintr&#228;ge - angezeigte Werte'';\r\n$mip_form[''3074''][''cms_var''] = ''MOD_VAR[3074]'';\r\n$mip_form[''3074''][''cms_val''] = $cms_mod[''value''][''3074''];\r\n$mip_form[''3074''][''cms_val_default''] = ''Feld1,Feld2'';\r\n$mip_form[''3074''][''tab''] = ''0'';\r\n\r\n//element Value\r\n$mip_form[''3075''][''cat''] = ''txt'';\r\n$mip_form[''3075''][''type''] = '''';\r\n$mip_form[''3075''][''desc''] = ''Eintr&#228;ge - Werte <br/><small>(Wenn leer gelten die angezeigten Werte)</small>'';\r\n$mip_form[''3075''][''cms_var''] = ''MOD_VAR[3075]'';\r\n$mip_form[''3075''][''cms_val''] = $cms_mod[''value''][''3075''];\r\n$mip_form[''3075''][''cms_val_default''] = '''';\r\n$mip_form[''3075''][''tab''] = ''0'';\r\n\r\n//Separator \r\n$mip_form[''3076''][''cat''] = ''txt'';\r\n$mip_form[''3076''][''type''] = '''';\r\n$mip_form[''3076''][''desc''] = ''Eintr&#228;ge - Trenner <br/><small>(Standardseperator/ Trenner ist ein Komma)</small> '';\r\n$mip_form[''3076''][''cms_var''] = ''MOD_VAR[3076]'';\r\n$mip_form[''3076''][''cms_val''] = $cms_mod[''value''][''3076''];\r\n$mip_form[''3076''][''cms_val_default''] = '','';\r\n$mip_form[''3076''][''tab''] = ''0'';\r\n\r\n//Default Einstellung\r\n$mip_form[''3077''][''cat''] = ''txt'';\r\n$mip_form[''3077''][''type''] = '''';\r\n$mip_form[''3077''][''desc''] = ''Vorselektierte Eintr&#228;ge'';\r\n$mip_form[''3077''][''cms_var''] = ''MOD_VAR[3077]'';\r\n$mip_form[''3077''][''cms_val''] = $cms_mod[''value''][''3077''];\r\n$mip_form[''3077''][''cms_val_default''] = '''';\r\n$mip_form[''3077''][''tab''] = ''0'';\r\n\r\n//Mehrfachauswahl \r\n$mip_form[''3078''][''desc''] = ''Mehrfachauswahl aktivieren'';\r\n$mip_form[''3078''][''cat''] = ''chk'';\r\n$mip_form[''3078''][''option_var''][''0''] = ''MOD_VAR[3078]'';\r\n$mip_form[''3078''][''option_val''][''0''] = $cms_mod[''value''][''3078''];\r\n$mip_form[''3078''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''3078''][''option_val_select''][''0''] = ''true'';\r\n\r\n//gr&#246;sse des Auswahlfeldes \r\n$mip_form[''3079''][''cat''] = ''txt'';\r\n$mip_form[''3079''][''type''] = '''';\r\n$mip_form[''3079''][''desc''] = ''Anzahl gleichzeitig sichtbarer Eintr&#228;ge'';\r\n$mip_form[''3079''][''cms_var''] = ''MOD_VAR[3079]'';\r\n$mip_form[''3079''][''cms_val''] = $cms_mod[''value''][''3079''];\r\n$mip_form[''3079''][''cms_val_default''] = '''';\r\n$mip_form[''3079''][''tab''] = ''0'';\r\n\r\n\r\n//element Name\r\n$mip_form[''3174''][''cat''] = ''txt'';\r\n$mip_form[''3174''][''type''] = '''';\r\n$mip_form[''3174''][''desc''] = ''Eintr&#228;ge - angezeigte Werte'';\r\n$mip_form[''3174''][''cms_var''] = ''MOD_VAR[3174]'';\r\n$mip_form[''3174''][''cms_val''] = $cms_mod[''value''][''3174''];\r\n$mip_form[''3174''][''cms_val_default''] = ''Feld1,Feld2'';\r\n$mip_form[''3174''][''tab''] = ''0'';\r\n\r\n//element Value\r\n$mip_form[''3175''][''cat''] = ''txt'';\r\n$mip_form[''3175''][''type''] = '''';\r\n$mip_form[''3175''][''desc''] = ''Eintr&#228;ge - Werte <br/><small>(Wenn leer gelten die angezeigten Werte)</small>'';\r\n$mip_form[''3175''][''cms_var''] = ''MOD_VAR[3175]'';\r\n$mip_form[''3175''][''cms_val''] = $cms_mod[''value''][''3175''];\r\n$mip_form[''3175''][''cms_val_default''] = '''';\r\n$mip_form[''3175''][''tab''] = ''0'';\r\n\r\n//Separator \r\n$mip_form[''3176''][''cat''] = ''txt'';\r\n$mip_form[''3176''][''type''] = '''';\r\n$mip_form[''3176''][''desc''] = ''Eintr&#228;ge - Trenner <br/><small>(Standardseperator/ Trenner ist ein Komma)</small> '';\r\n$mip_form[''3176''][''cms_var''] = ''MOD_VAR[3176]'';\r\n$mip_form[''3176''][''cms_val''] = $cms_mod[''value''][''3176''];\r\n$mip_form[''3176''][''cms_val_default''] = '','';\r\n$mip_form[''3176''][''tab''] = ''0'';\r\n\r\n//Default Einstellung\r\n$mip_form[''3177''][''cat''] = ''txt'';\r\n$mip_form[''3177''][''type''] = '''';\r\n$mip_form[''3177''][''desc''] = ''Vorselektierte Eintr&#228;ge'';\r\n$mip_form[''3177''][''cms_var''] = ''MOD_VAR[3177]'';\r\n$mip_form[''3177''][''cms_val''] = $cms_mod[''value''][''3177''];\r\n$mip_form[''3177''][''cms_val_default''] = '''';\r\n$mip_form[''3177''][''tab''] = ''0'';\r\n\r\n//Mehrfachauswahl \r\n$mip_form[''3178''][''desc''] = ''Mehrfachauswahl aktivieren'';\r\n$mip_form[''3178''][''cat''] = ''chk'';\r\n$mip_form[''3178''][''option_var''][''0''] = ''MOD_VAR[3178]'';\r\n$mip_form[''3178''][''option_val''][''0''] = $cms_mod[''value''][''3178''];\r\n$mip_form[''3178''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''3178''][''option_val_select''][''0''] = ''true'';\r\n\r\n//gr&#246;sse des Auswahlfeldes \r\n$mip_form[''3179''][''cat''] = ''txt'';\r\n$mip_form[''3179''][''type''] = '''';\r\n$mip_form[''3179''][''desc''] = ''Anzahl gleichzeitig sichtbarer Eintr&#228;ge'';\r\n$mip_form[''3179''][''cms_var''] = ''MOD_VAR[3179]'';\r\n$mip_form[''3179''][''cms_val''] = $cms_mod[''value''][''3179''];\r\n$mip_form[''3179''][''cms_val_default''] = '''';\r\n$mip_form[''3179''][''tab''] = ''0'';\r\n\r\n\r\n//element Name\r\n$mip_form[''3274''][''cat''] = ''txt'';\r\n$mip_form[''3274''][''type''] = '''';\r\n$mip_form[''3274''][''desc''] = ''Eintr&#228;ge - angezeigte Werte'';\r\n$mip_form[''3274''][''cms_var''] = ''MOD_VAR[3274]'';\r\n$mip_form[''3274''][''cms_val''] = $cms_mod[''value''][''3274''];\r\n$mip_form[''3274''][''cms_val_default''] = ''Feld1,Feld2'';\r\n$mip_form[''3274''][''tab''] = ''0'';\r\n\r\n//element Value\r\n$mip_form[''3275''][''cat''] = ''txt'';\r\n$mip_form[''3275''][''type''] = '''';\r\n$mip_form[''3275''][''desc''] = ''Eintr&#228;ge - Werte <br/><small>(Wenn leer gelten die angezeigten Werte)</small>'';\r\n$mip_form[''3275''][''cms_var''] = ''MOD_VAR[3275]'';\r\n$mip_form[''3275''][''cms_val''] = $cms_mod[''value''][''3275''];\r\n$mip_form[''3275''][''cms_val_default''] = '''';\r\n$mip_form[''3275''][''tab''] = ''0'';\r\n\r\n//Separator \r\n$mip_form[''3276''][''cat''] = ''txt'';\r\n$mip_form[''3276''][''type''] = '''';\r\n$mip_form[''3276''][''desc''] = ''Eintr&#228;ge - Trenner <br/><small>(Standardseperator/ Trenner ist ein Komma)</small> '';\r\n$mip_form[''3276''][''cms_var''] = ''MOD_VAR[3276]'';\r\n\r\n\r\n$mip_form[''3276''][''cms_val''] = $cms_mod[''value''][''3276''];\r\n$mip_form[''3276''][''cms_val_default''] = '','';\r\n$mip_form[''3276''][''tab''] = ''0'';\r\n\r\n//Default Einstellung\r\n$mip_form[''3277''][''cat''] = ''txt'';\r\n$mip_form[''3277''][''type''] = '''';\r\n$mip_form[''3277''][''desc''] = ''Vorselektierte Eintr&#228;ge'';\r\n$mip_form[''3277''][''cms_var''] = ''MOD_VAR[3277]'';\r\n$mip_form[''3277''][''cms_val''] = $cms_mod[''value''][''3277''];\r\n$mip_form[''3277''][''cms_val_default''] = '''';\r\n$mip_form[''3277''][''tab''] = ''0'';\r\n\r\n//Mehrfachauswahl \r\n$mip_form[''3278''][''desc''] = ''Mehrfachauswahl aktivieren'';\r\n$mip_form[''3278''][''cat''] = ''chk'';\r\n$mip_form[''3278''][''option_var''][''0''] = ''MOD_VAR[3278]'';\r\n$mip_form[''3278''][''option_val''][''0''] = $cms_mod[''value''][''3278''];\r\n$mip_form[''3278''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''3278''][''option_val_select''][''0''] = ''true'';\r\n\r\n//gr&#246;sse des Auswahlfeldes \r\n$mip_form[''3279''][''cat''] = ''txt'';\r\n$mip_form[''3279''][''type''] = '''';\r\n$mip_form[''3279''][''desc''] = ''Anzahl gleichzeitig sichtbarer Eintr&#228;ge'';\r\n$mip_form[''3279''][''cms_var''] = ''MOD_VAR[3279]'';\r\n$mip_form[''3279''][''cms_val''] = $cms_mod[''value''][''3279''];\r\n$mip_form[''3279''][''cms_val_default''] = '''';\r\n$mip_form[''3279''][''tab''] = ''0'';\r\n\r\n\r\n\r\n\r\n//element Name\r\n$mip_form[''3374''][''cat''] = ''txt'';\r\n$mip_form[''3374''][''type''] = '''';\r\n$mip_form[''3374''][''desc''] = ''Eintr&#228;ge - angezeigte Werte'';\r\n$mip_form[''3374''][''cms_var''] = ''MOD_VAR[3374]'';\r\n$mip_form[''3374''][''cms_val''] = $cms_mod[''value''][''3374''];\r\n$mip_form[''3374''][''cms_val_default''] = ''Feld1,Feld2'';\r\n$mip_form[''3374''][''tab''] = ''0'';\r\n\r\n//element Value\r\n$mip_form[''3375''][''cat''] = ''txt'';\r\n$mip_form[''3375''][''type''] = '''';\r\n$mip_form[''3375''][''desc''] = ''Eintr&#228;ge - Werte <br/><small>(Wenn leer gelten die angezeigten Werte)</small>'';\r\n$mip_form[''3375''][''cms_var''] = ''MOD_VAR[3375]'';\r\n$mip_form[''3375''][''cms_val''] = $cms_mod[''value''][''3375''];\r\n$mip_form[''3375''][''cms_val_default''] = '''';\r\n$mip_form[''3375''][''tab''] = ''0'';\r\n\r\n//Separator \r\n$mip_form[''3376''][''cat''] = ''txt'';\r\n$mip_form[''3376''][''type''] = '''';\r\n$mip_form[''3376''][''desc''] = ''Eintr&#228;ge - Trenner <br/><small>(Standardseperator/ Trenner ist ein Komma)</small> '';\r\n$mip_form[''3376''][''cms_var''] = ''MOD_VAR[3376]'';\r\n$mip_form[''3376''][''cms_val''] = $cms_mod[''value''][''3376''];\r\n$mip_form[''3376''][''cms_val_default''] = '','';\r\n$mip_form[''3376''][''tab''] = ''0'';\r\n\r\n//Default Einstellung\r\n$mip_form[''3377''][''cat''] = ''txt'';\r\n$mip_form[''3377''][''type''] = '''';\r\n$mip_form[''3377''][''desc''] = ''Vorselektierte Eintr&#228;ge'';\r\n$mip_form[''3377''][''cms_var''] = ''MOD_VAR[3377]'';\r\n$mip_form[''3377''][''cms_val''] = $cms_mod[''value''][''3377''];\r\n$mip_form[''3377''][''cms_val_default''] = '''';\r\n$mip_form[''3377''][''tab''] = ''0'';\r\n\r\n//Mehrfachauswahl \r\n$mip_form[''3378''][''desc''] = ''Mehrfachauswahl aktivieren'';\r\n$mip_form[''3378''][''cat''] = ''chk'';\r\n$mip_form[''3378''][''option_var''][''0''] = ''MOD_VAR[3378]'';\r\n$mip_form[''3378''][''option_val''][''0''] = $cms_mod[''value''][''3378''];\r\n$mip_form[''3378''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''3378''][''option_val_select''][''0''] = ''true'';\r\n\r\n//gr&#246;sse des Auswahlfeldes \r\n$mip_form[''3379''][''cat''] = ''txt'';\r\n$mip_form[''3379''][''type''] = '''';\r\n$mip_form[''3379''][''desc''] = ''Anzahl gleichzeitig sichtbarer Eintr&#228;ge'';\r\n$mip_form[''3379''][''cms_var''] = ''MOD_VAR[3379]'';\r\n$mip_form[''3379''][''cms_val''] = $cms_mod[''value''][''3379''];\r\n$mip_form[''3379''][''cms_val_default''] = '''';\r\n$mip_form[''3379''][''tab''] = ''0'';\r\n\r\n\r\n\r\n\r\n//element Name\r\n$mip_form[''3474''][''cat''] = ''txt'';\r\n$mip_form[''3474''][''type''] = '''';\r\n$mip_form[''3474''][''desc''] = ''Eintr&#228;ge - angezeigte Werte'';\r\n$mip_form[''3474''][''cms_var''] = ''MOD_VAR[3474]'';\r\n$mip_form[''3474''][''cms_val''] = $cms_mod[''value''][''3474''];\r\n$mip_form[''3474''][''cms_val_default''] = ''Feld1,Feld2'';\r\n$mip_form[''3474''][''tab''] = ''0'';\r\n\r\n//element Value\r\n$mip_form[''3475''][''cat''] = ''txt'';\r\n$mip_form[''3475''][''type''] = '''';\r\n$mip_form[''3475''][''desc''] = ''Eintr&#228;ge - Werte <br/><small>(Wenn leer gelten die angezeigten Werte)</small>'';\r\n$mip_form[''3475''][''cms_var''] = ''MOD_VAR[3475]'';\r\n$mip_form[''3475''][''cms_val''] = $cms_mod[''value''][''3475''];\r\n$mip_form[''3475''][''cms_val_default''] = '''';\r\n$mip_form[''3475''][''tab''] = ''0'';\r\n\r\n//Separator \r\n$mip_form[''3476''][''cat''] = ''txt'';\r\n$mip_form[''3476''][''type''] = '''';\r\n$mip_form[''3476''][''desc''] = ''Eintr&#228;ge - Trenner <br/><small>(Standardseperator/ Trenner ist ein Komma)</small> '';\r\n$mip_form[''3476''][''cms_var''] = ''MOD_VAR[3476]'';\r\n$mip_form[''3476''][''cms_val''] = $cms_mod[''value''][''3476''];\r\n$mip_form[''3476''][''cms_val_default''] = '','';\r\n$mip_form[''3476''][''tab''] = ''0'';\r\n\r\n//Default Einstellung\r\n$mip_form[''3477''][''cat''] = ''txt'';\r\n$mip_form[''3477''][''type''] = '''';\r\n$mip_form[''3477''][''desc''] = ''Vorselektierte Eintr&#228;ge'';\r\n$mip_form[''3477''][''cms_var''] = ''MOD_VAR[3477]'';\r\n$mip_form[''3477''][''cms_val''] = $cms_mod[''value''][''3477''];\r\n$mip_form[''3477''][''cms_val_default''] = '''';\r\n$mip_form[''3477''][''tab''] = ''0'';\r\n\r\n//Mehrfachauswahl \r\n$mip_form[''3478''][''desc''] = ''Mehrfachauswahl aktivieren'';\r\n$mip_form[''3478''][''cat''] = ''chk'';\r\n$mip_form[''3478''][''option_var''][''0''] = ''MOD_VAR[3478]'';\r\n$mip_form[''3478''][''option_val''][''0''] = $cms_mod[''value''][''3478''];\r\n$mip_form[''3478''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''3478''][''option_val_select''][''0''] = ''true'';\r\n\r\n//gr&#246;sse des Auswahlfeldes \r\n$mip_form[''3479''][''cat''] = ''txt'';\r\n$mip_form[''3479''][''type''] = '''';\r\n$mip_form[''3479''][''desc''] = ''Anzahl gleichzeitig sichtbarer Eintr&#228;ge'';\r\n$mip_form[''3479''][''cms_var''] = ''MOD_VAR[3479]'';\r\n$mip_form[''3479''][''cms_val''] = $cms_mod[''value''][''3479''];\r\n$mip_form[''3479''][''cms_val_default''] = '''';\r\n$mip_form[''3479''][''tab''] = ''0'';\r\n\r\n\r\n\r\n\r\n//element Name\r\n$mip_form[''3574''][''cat''] = ''txt'';\r\n$mip_form[''3574''][''type''] = '''';\r\n$mip_form[''3574''][''desc''] = ''Eintr&#228;ge - angezeigte Werte'';\r\n$mip_form[''3574''][''cms_var''] = ''MOD_VAR[3574]'';\r\n$mip_form[''3574''][''cms_val''] = $cms_mod[''value''][''3574''];\r\n$mip_form[''3574''][''cms_val_default''] = ''Feld1,Feld2'';\r\n$mip_form[''3574''][''tab''] = ''0'';\r\n\r\n//element Value\r\n$mip_form[''3575''][''cat''] = ''txt'';\r\n$mip_form[''3575''][''type''] = '''';\r\n$mip_form[''3575''][''desc''] = ''Eintr&#228;ge - Werte <br/><small>(Wenn leer gelten die angezeigten Werte)</small>'';\r\n$mip_form[''3575''][''cms_var''] = ''MOD_VAR[3575]'';\r\n$mip_form[''3575''][''cms_val''] = $cms_mod[''value''][''3575''];\r\n$mip_form[''3575''][''cms_val_default''] = '''';\r\n$mip_form[''3575''][''tab''] = ''0'';\r\n\r\n//Separator \r\n$mip_form[''3576''][''cat''] = ''txt'';\r\n$mip_form[''3576''][''type''] = '''';\r\n$mip_form[''3576''][''desc''] = ''Eintr&#228;ge - Trenner <br/><small>(Standardseperator/ Trenner ist ein Komma)</small> '';\r\n$mip_form[''3576''][''cms_var''] = ''MOD_VAR[3576]'';\r\n$mip_form[''3576''][''cms_val''] = $cms_mod[''value''][''3576''];\r\n$mip_form[''3576''][''cms_val_default''] = '','';\r\n$mip_form[''3576''][''tab''] = ''0'';\r\n\r\n//Default Einstellung\r\n$mip_form[''3577''][''cat''] = ''txt'';\r\n$mip_form[''3577''][''type''] = '''';\r\n$mip_form[''3577''][''desc''] = ''Vorselektierte Eintr&#228;ge'';\r\n$mip_form[''3577''][''cms_var''] = ''MOD_VAR[3577]'';\r\n$mip_form[''3577''][''cms_val''] = $cms_mod[''value''][''3577''];\r\n$mip_form[''3577''][''cms_val_default''] = '''';\r\n$mip_form[''3577''][''tab''] = ''0'';\r\n\r\n//Mehrfachauswahl \r\n$mip_form[''3578''][''desc''] = ''Mehrfachauswahl aktivieren'';\r\n$mip_form[''3578''][''cat''] = ''chk'';\r\n$mip_form[''3578''][''option_var''][''0''] = ''MOD_VAR[3578]'';\r\n$mip_form[''3578''][''option_val''][''0''] = $cms_mod[''value''][''3578''];\r\n$mip_form[''3578''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''3578''][''option_val_select''][''0''] = ''true'';\r\n\r\n//gr&#246;sse des Auswahlfeldes \r\n$mip_form[''3579''][''cat''] = ''txt'';\r\n$mip_form[''3579''][''type''] = '''';\r\n$mip_form[''3579''][''desc''] = ''Anzahl gleichzeitig sichtbarer Eintr&#228;ge'';\r\n$mip_form[''3579''][''cms_var''] = ''MOD_VAR[3579]'';\r\n$mip_form[''3579''][''cms_val''] = $cms_mod[''value''][''3579''];\r\n$mip_form[''3579''][''cms_val_default''] = '''';\r\n$mip_form[''3579''][''tab''] = ''0'';\r\n\r\n\r\n\r\n//element Name\r\n$mip_form[''3674''][''cat''] = ''txt'';\r\n$mip_form[''3674''][''type''] = '''';\r\n$mip_form[''3674''][''desc''] = ''Eintr&#228;ge - angezeigte Werte'';\r\n$mip_form[''3674''][''cms_var''] = ''MOD_VAR[3674]'';\r\n$mip_form[''3674''][''cms_val''] = $cms_mod[''value''][''3674''];\r\n$mip_form[''3674''][''cms_val_default''] = ''Feld1,Feld2'';\r\n$mip_form[''3674''][''tab''] = ''0'';\r\n\r\n//element Value\r\n$mip_form[''3675''][''cat''] = ''txt'';\r\n$mip_form[''3675''][''type''] = '''';\r\n$mip_form[''3675''][''desc''] = ''Eintr&#228;ge - Werte <br/><small>(Wenn leer gelten die angezeigten Werte)</small>'';\r\n$mip_form[''3675''][''cms_var''] = ''MOD_VAR[3675]'';\r\n$mip_form[''3675''][''cms_val''] = $cms_mod[''value''][''3675''];\r\n$mip_form[''3675''][''cms_val_default''] = '''';\r\n$mip_form[''3675''][''tab''] = ''0'';\r\n\r\n//Separator \r\n$mip_form[''3676''][''cat''] = ''txt'';\r\n$mip_form[''3676''][''type''] = '''';\r\n$mip_form[''3676''][''desc''] = ''Eintr&#228;ge - Trenner <br/><small>(Standardseperator/ Trenner ist ein Komma)</small> '';\r\n$mip_form[''3676''][''cms_var''] = ''MOD_VAR[3676]'';\r\n$mip_form[''3676''][''cms_val''] = $cms_mod[''value''][''3676''];\r\n$mip_form[''3676''][''cms_val_default''] = '','';\r\n$mip_form[''3676''][''tab''] = ''0'';\r\n\r\n//Default Einstellung\r\n$mip_form[''3677''][''cat''] = ''txt'';\r\n$mip_form[''3677''][''type''] = '''';\r\n$mip_form[''3677''][''desc''] = ''Vorselektierte Eintr&#228;ge'';\r\n$mip_form[''3677''][''cms_var''] = ''MOD_VAR[3677]'';\r\n$mip_form[''3677''][''cms_val''] = $cms_mod[''value''][''3677''];\r\n$mip_form[''3677''][''cms_val_default''] = '''';\r\n$mip_form[''3677''][''tab''] = ''0'';\r\n\r\n//Mehrfachauswahl \r\n$mip_form[''3678''][''desc''] = ''Mehrfachauswahl aktivieren'';\r\n$mip_form[''3678''][''cat''] = ''chk'';\r\n$mip_form[''3678''][''option_var''][''0''] = ''MOD_VAR[3678]'';\r\n$mip_form[''3678''][''option_val''][''0''] = $cms_mod[''value''][''3678''];\r\n$mip_form[''3678''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''3678''][''option_val_select''][''0''] = ''true'';\r\n\r\n//gr&#246;sse des Auswahlfeldes \r\n$mip_form[''3679''][''cat''] = ''txt'';\r\n$mip_form[''3679''][''type''] = '''';\r\n$mip_form[''3679''][''desc''] = ''Anzahl gleichzeitig sichtbarer Eintr&#228;ge'';\r\n$mip_form[''3679''][''cms_var''] = ''MOD_VAR[3679]'';\r\n$mip_form[''3679''][''cms_val''] = $cms_mod[''value''][''3679''];\r\n$mip_form[''3679''][''cms_val_default''] = '''';\r\n$mip_form[''3679''][''tab''] = ''0'';\r\n\r\n\r\n\r\n//element Name\r\n$mip_form[''3774''][''cat''] = ''txt'';\r\n$mip_form[''3774''][''type''] = '''';\r\n$mip_form[''3774''][''desc''] = ''Eintr&#228;ge - angezeigte Werte'';\r\n$mip_form[''3774''][''cms_var''] = ''MOD_VAR[3774]'';\r\n$mip_form[''3774''][''cms_val''] = $cms_mod[''value''][''3774''];\r\n$mip_form[''3774''][''cms_val_default''] = ''Feld1,Feld2'';\r\n$mip_form[''3774''][''tab''] = ''0'';\r\n\r\n//element Value\r\n$mip_form[''3775''][''cat''] = ''txt'';\r\n$mip_form[''3775''][''type''] = '''';\r\n$mip_form[''3775''][''desc''] = ''Eintr&#228;ge - Werte <br/><small>(Wenn leer gelten die angezeigten Werte)</small>'';\r\n$mip_form[''3775''][''cms_var''] = ''MOD_VAR[3775]'';\r\n$mip_form[''3775''][''cms_val''] = $cms_mod[''value''][''3775''];\r\n$mip_form[''3775''][''cms_val_default''] = '''';\r\n$mip_form[''3775''][''tab''] = ''0'';\r\n\r\n//Separator \r\n$mip_form[''3776''][''cat''] = ''txt'';\r\n$mip_form[''3776''][''type''] = '''';\r\n$mip_form[''3776''][''desc''] = ''Eintr&#228;ge - Trenner <br/><small>(Standardseperator/ Trenner ist ein Komma)</small> '';\r\n$mip_form[''3776''][''cms_var''] = ''MOD_VAR[3776]'';\r\n$mip_form[''3776''][''cms_val''] = $cms_mod[''value''][''3776''];\r\n$mip_form[''3776''][''cms_val_default''] = '','';\r\n$mip_form[''3776''][''tab''] = ''0'';\r\n\r\n//Default Einstellung\r\n$mip_form[''3777''][''cat''] = ''txt'';\r\n$mip_form[''3777''][''type''] = '''';\r\n$mip_form[''3777''][''desc''] = ''Vorselektierte Eintr&#228;ge'';\r\n$mip_form[''3777''][''cms_var''] = ''MOD_VAR[3777]'';\r\n$mip_form[''3777''][''cms_val''] = $cms_mod[''value''][''3777''];\r\n$mip_form[''3777''][''cms_val_default''] = '''';\r\n$mip_form[''3777''][''tab''] = ''0'';\r\n\r\n//Mehrfachauswahl \r\n$mip_form[''3778''][''desc''] = ''Mehrfachauswahl aktivieren'';\r\n$mip_form[''3778''][''cat''] = ''chk'';\r\n$mip_form[''3778''][''option_var''][''0''] = ''MOD_VAR[3778]'';\r\n$mip_form[''3778''][''option_val''][''0''] = $cms_mod[''value''][''3778''];\r\n$mip_form[''3778''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''3778''][''option_val_select''][''0''] = ''true'';\r\n\r\n//gr&#246;sse des Auswahlfeldes \r\n$mip_form[''3779''][''cat''] = ''txt'';\r\n$mip_form[''3779''][''type''] = '''';\r\n$mip_form[''3779''][''desc''] = ''Anzahl gleichzeitig sichtbarer Eintr&#228;ge'';\r\n$mip_form[''3779''][''cms_var''] = ''MOD_VAR[3779]'';\r\n$mip_form[''3779''][''cms_val''] = $cms_mod[''value''][''3779''];\r\n$mip_form[''3779''][''cms_val_default''] = '''';\r\n$mip_form[''3779''][''tab''] = ''0'';\r\n\r\n\r\n\r\n//element Name\r\n$mip_form[''3874''][''cat''] = ''txt'';\r\n$mip_form[''3874''][''type''] = '''';\r\n$mip_form[''3874''][''desc''] = ''Eintr&#228;ge - angezeigte Werte'';\r\n$mip_form[''3874''][''cms_var''] = ''MOD_VAR[3874]'';\r\n$mip_form[''3874''][''cms_val''] = $cms_mod[''value''][''3874''];\r\n$mip_form[''3874''][''cms_val_default''] = ''Feld1,Feld2'';\r\n$mip_form[''3874''][''tab''] = ''0'';\r\n\r\n//element Value\r\n$mip_form[''3875''][''cat''] = ''txt'';\r\n$mip_form[''3875''][''type''] = '''';\r\n$mip_form[''3875''][''desc''] = ''Eintr&#228;ge - Werte <br/><small>(Wenn leer gelten die angezeigten Werte)</small>'';\r\n$mip_form[''3875''][''cms_var''] = ''MOD_VAR[3875]'';\r\n$mip_form[''3875''][''cms_val''] = $cms_mod[''value''][''3875''];\r\n$mip_form[''3875''][''cms_val_default''] = '''';\r\n$mip_form[''3875''][''tab''] = ''0'';\r\n\r\n//Separator \r\n$mip_form[''3876''][''cat''] = ''txt'';\r\n$mip_form[''3876''][''type''] = '''';\r\n$mip_form[''3876''][''desc''] = ''Eintr&#228;ge - Trenner <br/><small>(Standardseperator/ Trenner ist ein Komma)</small> '';\r\n$mip_form[''3876''][''cms_var''] = ''MOD_VAR[3876]'';\r\n$mip_form[''3876''][''cms_val''] = $cms_mod[''value''][''3876''];\r\n$mip_form[''3876''][''cms_val_default''] = '','';\r\n$mip_form[''3876''][''tab''] = ''0'';\r\n\r\n//Default Einstellung\r\n$mip_form[''3877''][''cat''] = ''txt'';\r\n$mip_form[''3877''][''type''] = '''';\r\n$mip_form[''3877''][''desc''] = ''Vorselektierte Eintr&#228;ge'';\r\n$mip_form[''3877''][''cms_var''] = ''MOD_VAR[3877]'';\r\n$mip_form[''3877''][''cms_val''] = $cms_mod[''value''][''3877''];\r\n$mip_form[''3877''][''cms_val_default''] = '''';\r\n$mip_form[''3877''][''tab''] = ''0'';\r\n\r\n//Mehrfachauswahl \r\n$mip_form[''3878''][''desc''] = ''Mehrfachauswahl aktivieren'';\r\n$mip_form[''3878''][''cat''] = ''chk'';\r\n$mip_form[''3878''][''option_var''][''0''] = ''MOD_VAR[3878]'';\r\n$mip_form[''3878''][''option_val''][''0''] = $cms_mod[''value''][''3878''];\r\n$mip_form[''3878''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''3878''][''option_val_select''][''0''] = ''true'';\r\n\r\n//gr&#246;sse des Auswahlfeldes \r\n$mip_form[''3879''][''cat''] = ''txt'';\r\n$mip_form[''3879''][''type''] = '''';\r\n$mip_form[''3879''][''desc''] = ''Anzahl gleichzeitig sichtbarer Eintr&#228;ge'';\r\n$mip_form[''3879''][''cms_var''] = ''MOD_VAR[3879]'';\r\n$mip_form[''3879''][''cms_val''] = $cms_mod[''value''][''3879''];\r\n$mip_form[''3879''][''cms_val_default''] = '''';\r\n$mip_form[''3879''][''tab''] = ''0'';\r\n\r\n\r\n// ***************************** BBCode aus keinem Modul *********************\r\n\r\n//Featureauswahl\r\n$mip_form[''70''][''desc''] = ''Angezeigt Schaltfl&#228;chen f&#252;r den BBCode {textarea:x}:'';\r\n$mip_form[''70''][''cat''] = ''option'';\r\n$mip_form[''70''][''flag''] = ''multiple'';\r\n$mip_form[''70''][''size''] = ''7'';\r\n$mip_form[''70''][''option_desc''][] = ''Alle Felder sichtbar'';\r\n$mip_form[''70''][''option_val''][] = ''true'';\r\n$mip_form[''70''][''option_desc''][] = ''Fonts'';\r\n$mip_form[''70''][''option_val''][] = ''font'';\r\n$mip_form[''70''][''option_desc''][] = ''Fontgr&#246;sse'';\r\n$mip_form[''70''][''option_val''][] = ''size'';\r\n$mip_form[''70''][''option_desc''][] = ''Klassen'';\r\n$mip_form[''70''][''option_val''][] = ''class'';\r\n$mip_form[''70''][''option_desc''][] = ''Tags entfernen'';\r\n$mip_form[''70''][''option_val''][] = ''striptag'';\r\n$mip_form[''70''][''option_desc''][] = ''Code'';\r\n$mip_form[''70''][''option_val''][] = ''code'';\r\n$mip_form[''70''][''option_desc''][] = ''Fett'';\r\n$mip_form[''70''][''option_val''][] = ''bold'';\r\n$mip_form[''70''][''option_desc''][] = ''Kursiv'';\r\n$mip_form[''70''][''option_val''][] = ''italic'';\r\n$mip_form[''70''][''option_desc''][] = ''Unterstrichen'';\r\n$mip_form[''70''][''option_val''][] = ''underline'';\r\n$mip_form[''70''][''option_desc''][] = ''Durchgestrichen'';\r\n$mip_form[''70''][''option_val''][] = ''strike'';\r\n$mip_form[''70''][''option_desc''][] = ''Tiefgestellt'';\r\n$mip_form[''70''][''option_val''][] = ''sub'';\r\n$mip_form[''70''][''option_desc''][] = ''Hochgestellt'';\r\n$mip_form[''70''][''option_val''][] = ''sup'';\r\n$mip_form[''70''][''option_desc''][] = ''Fontfarbe'';\r\n$mip_form[''70''][''option_val''][] = ''forecol'';\r\n$mip_form[''70''][''option_desc''][] = ''Hintergrundfarbe'';\r\n$mip_form[''70''][''option_val''][] = ''backcol'';\r\n$mip_form[''70''][''option_desc''][] = ''Listen'';\r\n$mip_form[''70''][''option_val''][] = ''list'';\r\n$mip_form[''70''][''option_desc''][] = ''Anker einf&#252;gen'';\r\n$mip_form[''70''][''option_val''][] = ''anchor'';\r\n$mip_form[''70''][''option_desc''][] = ''Links einf&#252;gen'';\r\n$mip_form[''70''][''option_val''][] = ''link'';\r\n$mip_form[''70''][''option_desc''][] = ''Nur interne Links einf&#252;gen'';\r\n$mip_form[''70''][''option_val''][] = ''ilink'';\r\n$mip_form[''70''][''option_desc''][] = ''Dateien einf&#252;gen'';\r\n$mip_form[''70''][''option_val''][] = ''filelink'';\r\n$mip_form[''70''][''option_desc''][] = ''Email einf&#252;gen'';\r\n$mip_form[''70''][''option_val''][] = ''email'';\r\n$mip_form[''70''][''option_desc''][] = ''Trennlinie'';\r\n$mip_form[''70''][''option_val''][] = ''hr'';\r\n$mip_form[''70''][''option_desc''][] = ''Besondere Zeichen'';\r\n$mip_form[''70''][''option_val''][] = ''charmap'';\r\n$mip_form[''70''][''option_desc''][] = ''Hilfe'';\r\n$mip_form[''70''][''option_val''][] = ''help'';\r\n$mip_form[''70''][''cms_var''] = ''MOD_VAR[70]'';\r\n$mip_form[''70''][''cms_val''] = $cms_mod[''value''][''70''];\r\n\r\n\r\n// ***************************** TITEL **********************\r\n// Titel fuer {text:1}\r\n$mip_form[''20''][''cat''] = ''txt'';\r\n$mip_form[''20''][''type''] = '''';\r\n$mip_form[''20''][''desc''] = ''{text:1}'';\r\n$mip_form[''20''][''cms_var''] = ''MOD_VAR[20]'';\r\n$mip_form[''20''][''cms_val''] = $cms_mod[''value''][''20''];\r\n$mip_form[''20''][''cms_val_default''] = ''Textzeile 1'';\r\n\r\n// Titel fuer {textarea:1}\r\n$mip_form[''21''][''cat''] = ''txt'';\r\n$mip_form[''21''][''type''] = '''';\r\n$mip_form[''21''][''desc''] = ''{textarea:1}'';\r\n$mip_form[''21''][''cms_var''] = ''MOD_VAR[21]'';\r\n$mip_form[''21''][''cms_val''] = $cms_mod[''value''][''21''];\r\n$mip_form[''21''][''cms_val_default''] = ''Text 1'';\r\n\r\n// Titel fuer {wysiwyg:1}\r\n$mip_form[''22''][''cat''] = ''txt'';\r\n$mip_form[''22''][''type''] = '''';\r\n$mip_form[''22''][''desc''] = ''{wysiwyg:1}'';\r\n$mip_form[''22''][''cms_var''] = ''MOD_VAR[22]'';\r\n$mip_form[''22''][''cms_val''] = $cms_mod[''value''][''22''];\r\n$mip_form[''22''][''cms_val_default''] = ''Text (formatierbar) 1'';\r\n\r\n// Titel fuer {wysiwyg2:1}\r\n$mip_form[''23''][''cat''] = ''txt'';\r\n$mip_form[''23''][''type''] = '''';\r\n$mip_form[''23''][''desc''] = ''{wysiwyg2:1}'';\r\n$mip_form[''23''][''cms_var''] = ''MOD_VAR[23]'';\r\n$mip_form[''23''][''cms_val''] = $cms_mod[''value''][''23''];\r\n$mip_form[''23''][''cms_val_default''] = ''Text (gezielt formatierbar) 1'';\r\n\r\n// Titel fuer {image:1}\r\n$mip_form[''24''][''cat''] = ''txt'';\r\n$mip_form[''24''][''type''] = '''';\r\n$mip_form[''24''][''desc''] = ''{image:1}'';\r\n$mip_form[''24''][''cms_var''] = ''MOD_VAR[24]'';\r\n$mip_form[''24''][''cms_val''] = $cms_mod[''value''][''24''];\r\n$mip_form[''24''][''cms_val_default''] = ''Bild 1'';\r\n\r\n// Titel fuer {file:1}\r\n$mip_form[''25''][''cat''] = ''txt'';\r\n$mip_form[''25''][''type''] = '''';\r\n$mip_form[''25''][''desc''] = ''{file:1}'';\r\n$mip_form[''25''][''cms_var''] = ''MOD_VAR[25]'';\r\n$mip_form[''25''][''cms_val''] = $cms_mod[''value''][''25''];\r\n$mip_form[''25''][''cms_val_default''] = ''Datei 1'';\r\n\r\n// Titel fuer {link:1}\r\n$mip_form[''26''][''cat''] = ''txt'';\r\n$mip_form[''26''][''type''] = '''';\r\n$mip_form[''26''][''desc''] = ''{link:1}'';\r\n$mip_form[''26''][''cms_var''] = ''MOD_VAR[26]'';\r\n$mip_form[''26''][''cms_val''] = $cms_mod[''value''][''26''];\r\n$mip_form[''26''][''cms_val_default''] = ''Link 1'';\r\n\r\n// Titel fuer {text:2}\r\n$mip_form[''30''][''cat''] = ''txt'';\r\n$mip_form[''30''][''type''] = '''';\r\n$mip_form[''30''][''desc''] = ''{text:2}'';\r\n$mip_form[''30''][''cms_var''] = ''MOD_VAR[30]'';\r\n$mip_form[''30''][''cms_val''] = $cms_mod[''value''][''30''];\r\n$mip_form[''30''][''cms_val_default''] = ''Textzeile 2'';\r\n\r\n// Titel fuer {textarea:2}\r\n$mip_form[''31''][''cat''] = ''txt'';\r\n$mip_form[''31''][''type''] = '''';\r\n$mip_form[''31''][''desc''] = ''{textarea:2}'';\r\n$mip_form[''31''][''cms_var''] = ''MOD_VAR[31]'';\r\n$mip_form[''31''][''cms_val''] = $cms_mod[''value''][''31''];\r\n$mip_form[''31''][''cms_val_default''] = ''Text 2'';\r\n\r\n// Titel fuer {wysiwyg:2}\r\n$mip_form[''32''][''cat''] = ''txt'';\r\n$mip_form[''32''][''type''] = '''';\r\n$mip_form[''32''][''desc''] = ''{wysiwyg:2}'';\r\n$mip_form[''32''][''cms_var''] = ''MOD_VAR[32]'';\r\n$mip_form[''32''][''cms_val''] = $cms_mod[''value''][''32''];\r\n$mip_form[''32''][''cms_val_default''] = ''Text (formatierbar) 2'';\r\n\r\n// Titel fuer {wysiwyg2:3}\r\n$mip_form[''33''][''cat''] = ''txt'';\r\n$mip_form[''33''][''type''] = '''';\r\n$mip_form[''33''][''desc''] = ''{wysiwyg2:2}'';\r\n$mip_form[''33''][''cms_var''] = ''MOD_VAR[33]'';\r\n$mip_form[''33''][''cms_val''] = $cms_mod[''value''][''33''];\r\n$mip_form[''33''][''cms_val_default''] = ''Text (gezielt formatierbar) 2'';\r\n\r\n// Titel fuer {image:2}\r\n$mip_form[''34''][''cat''] = ''txt'';\r\n$mip_form[''34''][''type''] = '''';\r\n$mip_form[''34''][''desc''] = ''{image:2}'';\r\n$mip_form[''34''][''cms_var''] = ''MOD_VAR[34]'';\r\n$mip_form[''34''][''cms_val''] = $cms_mod[''value''][''34''];\r\n$mip_form[''34''][''cms_val_default''] = ''Bild 2'';\r\n\r\n// Titel fuer {file:2}\r\n$mip_form[''35''][''cat''] = ''txt'';\r\n$mip_form[''35''][''type''] = '''';\r\n$mip_form[''35''][''desc''] = ''{file:2}'';\r\n$mip_form[''35''][''cms_var''] = ''MOD_VAR[35]'';\r\n$mip_form[''35''][''cms_val''] = $cms_mod[''value''][''35''];\r\n$mip_form[''35''][''cms_val_default''] = ''Datei 2'';\r\n\r\n// Titel fuer {link:2}\r\n$mip_form[''36''][''cat''] = ''txt'';\r\n$mip_form[''36''][''type''] = '''';\r\n$mip_form[''36''][''desc''] = ''{link:2}'';\r\n$mip_form[''36''][''cms_var''] = ''MOD_VAR[36]'';\r\n$mip_form[''36''][''cms_val''] = $cms_mod[''value''][''36''];\r\n$mip_form[''36''][''cms_val_default''] = ''Link 2'';\r\n\r\n// Titel fuer {text:3}\r\n$mip_form[''40''][''cat''] = ''txt'';\r\n$mip_form[''40''][''type''] = '''';\r\n$mip_form[''40''][''desc''] = ''{text:3}'';\r\n$mip_form[''40''][''cms_var''] = ''MOD_VAR[40]'';\r\n$mip_form[''40''][''cms_val''] = $cms_mod[''value''][''40''];\r\n$mip_form[''40''][''cms_val_default''] = ''Textzeile 3'';\r\n\r\n// Titel fuer {textarea:3}\r\n$mip_form[''41''][''cat''] = ''txt'';\r\n$mip_form[''41''][''type''] = '''';\r\n$mip_form[''41''][''desc''] = ''{textarea:3}'';\r\n$mip_form[''41''][''cms_var''] = ''MOD_VAR[41]'';\r\n$mip_form[''41''][''cms_val''] = $cms_mod[''value''][''41''];\r\n$mip_form[''41''][''cms_val_default''] = ''Text 3'';\r\n\r\n// Titel fuer {wysiwyg:3}\r\n$mip_form[''42''][''cat''] = ''txt'';\r\n$mip_form[''42''][''type''] = '''';\r\n$mip_form[''42''][''desc''] = ''{wysiwyg:3}'';\r\n$mip_form[''42''][''cms_var''] = ''MOD_VAR[42]'';\r\n$mip_form[''42''][''cms_val''] = $cms_mod[''value''][''42''];\r\n$mip_form[''42''][''cms_val_default''] = ''Text (formatierbar) 3'';\r\n\r\n// Titel fuer {wysiwyg:3}\r\n$mip_form[''342''][''cat''] = ''txt'';\r\n$mip_form[''342''][''type''] = '''';\r\n$mip_form[''342''][''desc''] = ''{wysiwyg:4}'';\r\n$mip_form[''342''][''cms_var''] = ''MOD_VAR[342]'';\r\n$mip_form[''342''][''cms_val''] = $cms_mod[''value''][''342''];\r\n$mip_form[''342''][''cms_val_default''] = ''Text (formatierbar) 4'';\r\n\r\n// Titel fuer {wysiwyg:3}\r\n$mip_form[''343''][''cat''] = ''txt'';\r\n$mip_form[''343''][''type''] = '''';\r\n$mip_form[''343''][''desc''] = ''{wysiwyg:5}'';\r\n$mip_form[''343''][''cms_var''] = ''MOD_VAR[343]'';\r\n$mip_form[''343''][''cms_val''] = $cms_mod[''value''][''343''];\r\n$mip_form[''343''][''cms_val_default''] = ''Text (formatierbar) 5'';\r\n\r\n// Titel fuer {wysiwyg2:3}\r\n$mip_form[''43''][''cat''] = ''txt'';\r\n$mip_form[''43''][''type''] = '''';\r\n$mip_form[''43''][''desc''] = ''{wysiwyg2:3}'';\r\n$mip_form[''43''][''cms_var''] = ''MOD_VAR[43]'';\r\n$mip_form[''43''][''cms_val''] = $cms_mod[''value''][''43''];\r\n$mip_form[''43''][''cms_val_default''] = ''Text (gezielt formatierbar) 3'';\r\n\r\n// Titel fuer {wysiwyg2:3}\r\n$mip_form[''443''][''cat''] = ''txt'';\r\n$mip_form[''443''][''type''] = '''';\r\n$mip_form[''443''][''desc''] = ''{wysiwyg2:4}'';\r\n$mip_form[''443''][''cms_var''] = ''MOD_VAR[443]'';\r\n$mip_form[''443''][''cms_val''] = $cms_mod[''value''][''443''];\r\n$mip_form[''443''][''cms_val_default''] = ''Text (gezielt formatierbar) 4'';\r\n\r\n// Titel fuer {wysiwyg2:3}\r\n$mip_form[''444''][''cat''] = ''txt'';\r\n$mip_form[''444''][''type''] = '''';\r\n$mip_form[''444''][''desc''] = ''{wysiwyg2:5}'';\r\n$mip_form[''444''][''cms_var''] = ''MOD_VAR[444]'';\r\n$mip_form[''444''][''cms_val''] = $cms_mod[''value''][''444''];\r\n$mip_form[''444''][''cms_val_default''] = ''Text (gezielt formatierbar) 5'';\r\n\r\n// Titel fuer {image:3}\r\n$mip_form[''44''][''cat''] = ''txt'';\r\n$mip_form[''44''][''type''] = '''';\r\n$mip_form[''44''][''desc''] = ''{image:3}'';\r\n$mip_form[''44''][''cms_var''] = ''MOD_VAR[44]'';\r\n$mip_form[''44''][''cms_val''] = $cms_mod[''value''][''44''];\r\n$mip_form[''44''][''cms_val_default''] = ''Bild 3'';\r\n\r\n// Titel fuer {image:4}\r\n$mip_form[''1044''][''cat''] = ''txt'';\r\n$mip_form[''1044''][''type''] = '''';\r\n$mip_form[''1044''][''desc''] = ''{image:4}'';\r\n$mip_form[''1044''][''cms_var''] = ''MOD_VAR[1044]'';\r\n$mip_form[''1044''][''cms_val''] = $cms_mod[''value''][''1044''];\r\n$mip_form[''1044''][''cms_val_default''] = ''Bild 4'';\r\n\r\n// Titel fuer {image:5}\r\n$mip_form[''1045''][''cat''] = ''txt'';\r\n$mip_form[''1045''][''type''] = '''';\r\n$mip_form[''1045''][''desc''] = ''{image:5}'';\r\n$mip_form[''1045''][''cms_var''] = ''MOD_VAR[1045]'';\r\n$mip_form[''1045''][''cms_val''] = $cms_mod[''value''][''1045''];\r\n$mip_form[''1045''][''cms_val_default''] = ''Bild 5'';\r\n\r\n// Titel fuer {image:6}\r\n$mip_form[''1046''][''cat''] = ''txt'';\r\n$mip_form[''1046''][''type''] = '''';\r\n$mip_form[''1046''][''desc''] = ''{image:6}'';\r\n$mip_form[''1046''][''cms_var''] = ''MOD_VAR[1046]'';\r\n$mip_form[''1046''][''cms_val''] = $cms_mod[''value''][''1046''];\r\n$mip_form[''1046''][''cms_val_default''] = ''Bild 6'';\r\n\r\n// Titel fuer {image:7}\r\n$mip_form[''1047''][''cat''] = ''txt'';\r\n$mip_form[''1047''][''type''] = '''';\r\n$mip_form[''1047''][''desc''] = ''{image:7}'';\r\n$mip_form[''1047''][''cms_var''] = ''MOD_VAR[1047]'';\r\n$mip_form[''1047''][''cms_val''] = $cms_mod[''value''][''1047''];\r\n$mip_form[''1047''][''cms_val_default''] = ''Bild 7'';\r\n\r\n// Titel fuer {image:8}\r\n$mip_form[''1048''][''cat''] = ''txt'';\r\n$mip_form[''1048''][''type''] = '''';\r\n$mip_form[''1048''][''desc''] = ''{image:8}'';\r\n$mip_form[''1048''][''cms_var''] = ''MOD_VAR[1048]'';\r\n$mip_form[''1048''][''cms_val''] = $cms_mod[''value''][''1048''];\r\n$mip_form[''1048''][''cms_val_default''] = ''Bild 8'';\r\n\r\n// Titel fuer {image:9}\r\n$mip_form[''1049''][''cat''] = ''txt'';\r\n$mip_form[''1049''][''type''] = '''';\r\n$mip_form[''1049''][''desc''] = ''{image:9}'';\r\n$mip_form[''1049''][''cms_var''] = ''MOD_VAR[1049]'';\r\n$mip_form[''1049''][''cms_val''] = $cms_mod[''value''][''1049''];\r\n$mip_form[''1049''][''cms_val_default''] = ''Bild 9'';\r\n\r\n// Titel fuer {image:10}\r\n$mip_form[''1050''][''cat''] = ''txt'';\r\n$mip_form[''1050''][''type''] = '''';\r\n$mip_form[''1050''][''desc''] = ''{image:10}'';\r\n$mip_form[''1050''][''cms_var''] = ''MOD_VAR[1050]'';\r\n$mip_form[''1050''][''cms_val''] = $cms_mod[''value''][''1050''];\r\n$mip_form[''1050''][''cms_val_default''] = ''Bild 10'';\r\n\r\n// Titel fuer {file:3}\r\n$mip_form[''45''][''cat''] = ''txt'';\r\n$mip_form[''45''][''type''] = '''';\r\n$mip_form[''45''][''desc''] = ''{file:3}'';\r\n$mip_form[''45''][''cms_var''] = ''MOD_VAR[45]'';\r\n$mip_form[''45''][''cms_val''] = $cms_mod[''value''][''45''];\r\n$mip_form[''45''][''cms_val_default''] = ''Datei 3'';\r\n\r\n// Titel fuer {file:3}\r\n$mip_form[''5045''][''cat''] = ''txt'';\r\n$mip_form[''5045''][''type''] = '''';\r\n$mip_form[''5045''][''desc''] = ''{file:4}'';\r\n$mip_form[''5045''][''cms_var''] = ''MOD_VAR[5045]'';\r\n$mip_form[''5045''][''cms_val''] = $cms_mod[''value''][''5045''];\r\n$mip_form[''5045''][''cms_val_default''] = ''Datei 4'';\r\n\r\n// Titel fuer {file:3}\r\n$mip_form[''5046''][''cat''] = ''txt'';\r\n$mip_form[''5046''][''type''] = '''';\r\n$mip_form[''5046''][''desc''] = ''{file:5}'';\r\n$mip_form[''5046''][''cms_var''] = ''MOD_VAR[5046]'';\r\n$mip_form[''5046''][''cms_val''] = $cms_mod[''value''][''5046''];\r\n$mip_form[''5046''][''cms_val_default''] = ''Datei 5'';\r\n\r\n// Titel fuer {file:3}\r\n$mip_form[''5047''][''cat''] = ''txt'';\r\n$mip_form[''5047''][''type''] = '''';\r\n$mip_form[''5047''][''desc''] = ''{file:6}'';\r\n$mip_form[''5047''][''cms_var''] = ''MOD_VAR[5047]'';\r\n$mip_form[''5047''][''cms_val''] = $cms_mod[''value''][''5047''];\r\n$mip_form[''5047''][''cms_val_default''] = ''Datei 6'';\r\n\r\n// Titel fuer {file:3}\r\n$mip_form[''5048''][''cat''] = ''txt'';\r\n$mip_form[''5048''][''type''] = '''';\r\n$mip_form[''5048''][''desc''] = ''{file:7}'';\r\n$mip_form[''5048''][''cms_var''] = ''MOD_VAR[5048]'';\r\n$mip_form[''5048''][''cms_val''] = $cms_mod[''value''][''5048''];\r\n$mip_form[''5048''][''cms_val_default''] = ''Datei 7'';\r\n\r\n// Titel fuer {file:3}\r\n$mip_form[''5049''][''cat''] = ''txt'';\r\n$mip_form[''5049''][''type''] = '''';\r\n$mip_form[''5049''][''desc''] = ''{file:8}'';\r\n$mip_form[''5049''][''cms_var''] = ''MOD_VAR[5049]'';\r\n$mip_form[''5049''][''cms_val''] = $cms_mod[''value''][''5049''];\r\n$mip_form[''5049''][''cms_val_default''] = ''Datei 8'';\r\n\r\n// Titel fuer {file:3}\r\n$mip_form[''5050''][''cat''] = ''txt'';\r\n$mip_form[''5050''][''type''] = '''';\r\n$mip_form[''5050''][''desc''] = ''{file:9}'';\r\n$mip_form[''5050''][''cms_var''] = ''MOD_VAR[5050]'';\r\n$mip_form[''5050''][''cms_val''] = $cms_mod[''value''][''5050''];\r\n$mip_form[''5050''][''cms_val_default''] = ''Datei 9'';\r\n\r\n// Titel fuer {file:3}\r\n$mip_form[''5051''][''cat''] = ''txt'';\r\n$mip_form[''5051''][''type''] = '''';\r\n$mip_form[''5051''][''desc''] = ''{file:10}'';\r\n$mip_form[''5051''][''cms_var''] = ''MOD_VAR[5051]'';\r\n$mip_form[''5051''][''cms_val''] = $cms_mod[''value''][''5051''];\r\n$mip_form[''5051''][''cms_val_default''] = ''Datei 10'';\r\n\r\n// Titel fuer {link:3}\r\n$mip_form[''46''][''cat''] = ''txt'';\r\n$mip_form[''46''][''type''] = '''';\r\n$mip_form[''46''][''desc''] = ''{link:3}'';\r\n$mip_form[''46''][''cms_var''] = ''MOD_VAR[46]'';\r\n$mip_form[''46''][''cms_val''] = $cms_mod[''value''][''46''];\r\n$mip_form[''46''][''cms_val_default''] = ''Link 3'';\r\n\r\n// Titel fuer {link:3}\r\n$mip_form[''8046''][''cat''] = ''txt'';\r\n$mip_form[''8046''][''type''] = '''';\r\n$mip_form[''8046''][''desc''] = ''{link:4}'';\r\n$mip_form[''8046''][''cms_var''] = ''MOD_VAR[8046]'';\r\n$mip_form[''8046''][''cms_val''] = $cms_mod[''value''][''8046''];\r\n$mip_form[''8046''][''cms_val_default''] = ''Link 4'';\r\n\r\n// Titel fuer {link:3}\r\n$mip_form[''8047''][''cat''] = ''txt'';\r\n$mip_form[''8047''][''type''] = '''';\r\n$mip_form[''8047''][''desc''] = ''{link:5}'';\r\n$mip_form[''8047''][''cms_var''] = ''MOD_VAR[8047]'';\r\n$mip_form[''8047''][''cms_val''] = $cms_mod[''value''][''8047''];\r\n$mip_form[''8047''][''cms_val_default''] = ''Link 5'';\r\n\r\n// Titel fuer {link:3}\r\n$mip_form[''8048''][''cat''] = ''txt'';\r\n$mip_form[''8048''][''type''] = '''';\r\n$mip_form[''8048''][''desc''] = ''{link:6}'';\r\n$mip_form[''8048''][''cms_var''] = ''MOD_VAR[8048]'';\r\n$mip_form[''8048''][''cms_val''] = $cms_mod[''value''][''8048''];\r\n$mip_form[''8048''][''cms_val_default''] = ''Link 6'';\r\n\r\n// Titel fuer {link:3}\r\n$mip_form[''8049''][''cat''] = ''txt'';\r\n$mip_form[''8049''][''type''] = '''';\r\n$mip_form[''8049''][''desc''] = ''{link:7}'';\r\n$mip_form[''8049''][''cms_var''] = ''MOD_VAR[8049]'';\r\n$mip_form[''8049''][''cms_val''] = $cms_mod[''value''][''8049''];\r\n$mip_form[''8049''][''cms_val_default''] = ''Link 7'';\r\n\r\n// Titel fuer {link:3}\r\n$mip_form[''8050''][''cat''] = ''txt'';\r\n$mip_form[''8050''][''type''] = '''';\r\n$mip_form[''8050''][''desc''] = ''{link:8}'';\r\n$mip_form[''8050''][''cms_var''] = ''MOD_VAR[8050]'';\r\n$mip_form[''8050''][''cms_val''] = $cms_mod[''value''][''8050''];\r\n$mip_form[''8050''][''cms_val_default''] = ''Link 8'';\r\n\r\n// Titel fuer {link:3}\r\n$mip_form[''8051''][''cat''] = ''txt'';\r\n$mip_form[''8051''][''type''] = '''';\r\n$mip_form[''8051''][''desc''] = ''{link:9}'';\r\n$mip_form[''8051''][''cms_var''] = ''MOD_VAR[8051]'';\r\n$mip_form[''8051''][''cms_val''] = $cms_mod[''value''][''8051''];\r\n$mip_form[''8051''][''cms_val_default''] = ''Link 9'';\r\n\r\n// Titel fuer {link:3}\r\n$mip_form[''8052''][''cat''] = ''txt'';\r\n$mip_form[''8052''][''type''] = '''';\r\n$mip_form[''8052''][''desc''] = ''{link:10}'';\r\n$mip_form[''8052''][''cms_var''] = ''MOD_VAR[8052]'';\r\n$mip_form[''8052''][''cms_val''] = $cms_mod[''value''][''8052''];\r\n$mip_form[''8052''][''cms_val_default''] = ''Link 10'';\r\n\r\n// Titel fuer {text:4}\r\n$mip_form[''47''][''cat''] = ''txt'';\r\n$mip_form[''47''][''type''] = '''';\r\n$mip_form[''47''][''desc''] = ''{text:4}'';\r\n$mip_form[''47''][''cms_var''] = ''MOD_VAR[47]'';\r\n$mip_form[''47''][''cms_val''] = $cms_mod[''value''][''47''];\r\n$mip_form[''47''][''cms_val_default''] = ''Textzeile 4'';\r\n\r\n// Titel fuer {text:5}\r\n$mip_form[''48''][''cat''] = ''txt'';\r\n$mip_form[''48''][''type''] = '''';\r\n$mip_form[''48''][''desc''] = ''{text:5}'';\r\n$mip_form[''48''][''cms_var''] = ''MOD_VAR[48]'';\r\n$mip_form[''48''][''cms_val''] = $cms_mod[''value''][''48''];\r\n$mip_form[''48''][''cms_val_default''] = ''Textzeile 5'';\r\n\r\n// Titel fuer {text:6}\r\n$mip_form[''87''][''cat''] = ''txt'';\r\n$mip_form[''87''][''type''] = '''';\r\n$mip_form[''87''][''desc''] = ''{text:6}'';\r\n$mip_form[''87''][''cms_var''] = ''MOD_VAR[87]'';\r\n$mip_form[''87''][''cms_val''] = $cms_mod[''value''][''87''];\r\n$mip_form[''87''][''cms_val_default''] = ''Textzeile 6'';\r\n\r\n// Titel fuer {text:7}\r\n$mip_form[''88''][''cat''] = ''txt'';\r\n$mip_form[''88''][''type''] = '''';\r\n$mip_form[''88''][''desc''] = ''{text:7}'';\r\n$mip_form[''88''][''cms_var''] = ''MOD_VAR[88]'';\r\n$mip_form[''88''][''cms_val''] = $cms_mod[''value''][''88''];\r\n$mip_form[''88''][''cms_val_default''] = ''Textzeile 7'';\r\n\r\n// Titel fuer {text:8}\r\n$mip_form[''89''][''cat''] = ''txt'';\r\n$mip_form[''89''][''type''] = '''';\r\n$mip_form[''89''][''desc''] = ''{text:8}'';\r\n$mip_form[''89''][''cms_var''] = ''MOD_VAR[89]'';\r\n$mip_form[''89''][''cms_val''] = $cms_mod[''value''][''89''];\r\n$mip_form[''89''][''cms_val_default''] = ''Textzeile 8'';\r\n\r\n// Titel fuer {text:9}\r\n$mip_form[''90''][''cat''] = ''txt'';\r\n$mip_form[''90''][''type''] = '''';\r\n$mip_form[''90''][''desc''] = ''{text:9}'';\r\n$mip_form[''90''][''cms_var''] = ''MOD_VAR[90]'';\r\n$mip_form[''90''][''cms_val''] = $cms_mod[''value''][''90''];\r\n$mip_form[''90''][''cms_val_default''] = ''Textzeile 9'';\r\n\r\n// Titel fuer {text:9}\r\n$mip_form[''6090''][''cat''] = ''txt'';\r\n$mip_form[''6090''][''type''] = '''';\r\n$mip_form[''6090''][''desc''] = ''{text:10}'';\r\n$mip_form[''6090''][''cms_var''] = ''MOD_VAR[6090]'';\r\n$mip_form[''6090''][''cms_val''] = $cms_mod[''value''][''6090''];\r\n$mip_form[''6090''][''cms_val_default''] = ''Textzeile 10'';\r\n\r\n// Titel fuer {textarea:3}\r\n$mip_form[''91''][''cat''] = ''txt'';\r\n$mip_form[''91''][''type''] = '''';\r\n$mip_form[''91''][''desc''] = ''{textarea:4}'';\r\n$mip_form[''91''][''cms_var''] = ''MOD_VAR[91]'';\r\n$mip_form[''91''][''cms_val''] = $cms_mod[''value''][''91''];\r\n$mip_form[''91''][''cms_val_default''] = ''Text 4'';\r\n\r\n// Titel fuer {textarea:3}\r\n$mip_form[''92''][''cat''] = ''txt'';\r\n$mip_form[''92''][''type''] = '''';\r\n$mip_form[''92''][''desc''] = ''{textarea:5}'';\r\n$mip_form[''92''][''cms_var''] = ''MOD_VAR[92]'';\r\n$mip_form[''92''][''cms_val''] = $cms_mod[''value''][''92''];\r\n$mip_form[''92''][''cms_val_default''] = ''Text 5'';\r\n\r\n// Titel fuer {textarea:3}\r\n$mip_form[''93''][''cat''] = ''txt'';\r\n$mip_form[''93''][''type''] = '''';\r\n$mip_form[''93''][''desc''] = ''{textarea:6}'';\r\n$mip_form[''93''][''cms_var''] = ''MOD_VAR[93]'';\r\n$mip_form[''93''][''cms_val''] = $cms_mod[''value''][''93''];\r\n$mip_form[''93''][''cms_val_default''] = ''Text 6'';\r\n\r\n// Titel fuer {textarea:3}\r\n$mip_form[''7093''][''cat''] = ''txt'';\r\n$mip_form[''7093''][''type''] = '''';\r\n$mip_form[''7093''][''desc''] = ''{textarea:7}'';\r\n$mip_form[''7093''][''cms_var''] = ''MOD_VAR[7093]'';\r\n$mip_form[''7093''][''cms_val''] = $cms_mod[''value''][''7093''];\r\n$mip_form[''7093''][''cms_val_default''] = ''Text 7'';\r\n\r\n// Titel fuer {textarea:3}\r\n$mip_form[''7094''][''cat''] = ''txt'';\r\n$mip_form[''7094''][''type''] = '''';\r\n$mip_form[''7094''][''desc''] = ''{textarea:8}'';\r\n$mip_form[''7094''][''cms_var''] = ''MOD_VAR[7094]'';\r\n$mip_form[''7094''][''cms_val''] = $cms_mod[''value''][''7094''];\r\n$mip_form[''7094''][''cms_val_default''] = ''Text 8'';\r\n\r\n// Titel fuer {textarea:3}\r\n$mip_form[''7095''][''cat''] = ''txt'';\r\n$mip_form[''7095''][''type''] = '''';\r\n$mip_form[''7095''][''desc''] = ''{textarea:9}'';\r\n$mip_form[''7095''][''cms_var''] = ''MOD_VAR[7095]'';\r\n$mip_form[''7095''][''cms_val''] = $cms_mod[''value''][''7095''];\r\n$mip_form[''7095''][''cms_val_default''] = ''Text 9'';\r\n\r\n// Titel fuer {textarea:3}\r\n$mip_form[''7096''][''cat''] = ''txt'';\r\n$mip_form[''7096''][''type''] = '''';\r\n$mip_form[''7096''][''desc''] = ''{textarea:10}'';\r\n$mip_form[''7096''][''cms_var''] = ''MOD_VAR[7096]'';\r\n$mip_form[''7096''][''cms_val''] = $cms_mod[''value''][''7096''];\r\n$mip_form[''7096''][''cms_val_default''] = ''Text 10'';\r\n\r\n\r\n// Titel fuer {textarea:3}\r\n$mip_form[''6093''][''cat''] = ''txt'';\r\n$mip_form[''6093''][''type''] = '''';\r\n$mip_form[''6093''][''desc''] = ''{textarea:7}'';\r\n$mip_form[''6093''][''cms_var''] = ''MOD_VAR[6093]'';\r\n$mip_form[''6093''][''cms_val''] = $cms_mod[''value''][''6093''];\r\n$mip_form[''6093''][''cms_val_default''] = ''Text 7'';\r\n\r\n// Titel fuer {sourcecode:1}\r\n$mip_form[''52''][''cat''] = ''txt'';\r\n$mip_form[''52''][''type''] = '''';\r\n$mip_form[''52''][''desc''] = ''{sourcecode:1}'';\r\n$mip_form[''52''][''cms_var''] = ''MOD_VAR[52]'';\r\n$mip_form[''52''][''cms_val''] = $cms_mod[''value''][''52''];\r\n$mip_form[''52''][''cms_val_default''] = ''Quellcode 1'';\r\n\r\n// Titel fuer {select:1}\r\n$mip_form[''29''][''cat''] = ''txt'';\r\n$mip_form[''29''][''type''] = '''';\r\n$mip_form[''29''][''desc''] = ''{select:1}'';\r\n$mip_form[''29''][''cms_var''] = ''MOD_VAR[29]'';\r\n$mip_form[''29''][''cms_val''] = $cms_mod[''value''][''29''];\r\n$mip_form[''29''][''cms_val_default''] = ''Wertauswahl 1'';\r\n\r\n// Titel fuer {select:1}\r\n$mip_form[''3029''][''cat''] = ''txt'';\r\n$mip_form[''3029''][''type''] = '''';\r\n$mip_form[''3029''][''desc''] = ''{select:2}'';\r\n$mip_form[''3029''][''cms_var''] = ''MOD_VAR[3029]'';\r\n$mip_form[''3029''][''cms_val''] = $cms_mod[''value''][''3029''];\r\n$mip_form[''3029''][''cms_val_default''] = ''Wertauswahl 2'';\r\n\r\n// Titel fuer {select:1}\r\n$mip_form[''3129''][''cat''] = ''txt'';\r\n$mip_form[''3129''][''type''] = '''';\r\n$mip_form[''3129''][''desc''] = ''{select:3}'';\r\n$mip_form[''3129''][''cms_var''] = ''MOD_VAR[3129]'';\r\n$mip_form[''3129''][''cms_val''] = $cms_mod[''value''][''3129''];\r\n$mip_form[''3129''][''cms_val_default''] = ''Wertauswahl 3'';\r\n\r\n// Titel fuer {select:4}\r\n$mip_form[''3229''][''cat''] = ''txt'';\r\n$mip_form[''3229''][''type''] = '''';\r\n$mip_form[''3229''][''desc''] = ''{select:4}'';\r\n$mip_form[''3229''][''cms_var''] = ''MOD_VAR[3229]'';\r\n$mip_form[''3229''][''cms_val''] = $cms_mod[''value''][''3229''];\r\n$mip_form[''3229''][''cms_val_default''] = ''Wertauswahl 4'';\r\n\r\n// Titel fuer {select:5}\r\n$mip_form[''3329''][''cat''] = ''txt'';\r\n$mip_form[''3329''][''type''] = '''';\r\n$mip_form[''3329''][''desc''] = ''{select:5}'';\r\n$mip_form[''3329''][''cms_var''] = ''MOD_VAR[3329]'';\r\n$mip_form[''3329''][''cms_val''] = $cms_mod[''value''][''3329''];\r\n$mip_form[''3329''][''cms_val_default''] = ''Wertauswahl 5'';\r\n\r\n// Titel fuer {select:6}\r\n$mip_form[''3429''][''cat''] = ''txt'';\r\n$mip_form[''3429''][''type''] = '''';\r\n$mip_form[''3429''][''desc''] = ''{select:6}'';\r\n$mip_form[''3429''][''cms_var''] = ''MOD_VAR[3429]'';\r\n$mip_form[''3429''][''cms_val''] = $cms_mod[''value''][''3429''];\r\n$mip_form[''3429''][''cms_val_default''] = ''Wertauswahl 6'';\r\n\r\n// Titel fuer {select:6}\r\n$mip_form[''3529''][''cat''] = ''txt'';\r\n$mip_form[''3529''][''type''] = '''';\r\n$mip_form[''3529''][''desc''] = ''{select:7}'';\r\n$mip_form[''3529''][''cms_var''] = ''MOD_VAR[3529]'';\r\n$mip_form[''3529''][''cms_val''] = $cms_mod[''value''][''3529''];\r\n$mip_form[''3529''][''cms_val_default''] = ''Wertauswahl 7'';\r\n\r\n// Titel fuer {select:6}\r\n$mip_form[''3629''][''cat''] = ''txt'';\r\n$mip_form[''3629''][''type''] = '''';\r\n$mip_form[''3629''][''desc''] = ''{select:8}'';\r\n$mip_form[''3629''][''cms_var''] = ''MOD_VAR[3629]'';\r\n$mip_form[''3629''][''cms_val''] = $cms_mod[''value''][''3629''];\r\n$mip_form[''3629''][''cms_val_default''] = ''Wertauswahl 8'';\r\n\r\n// Titel fuer {select:6}\r\n$mip_form[''3729''][''cat''] = ''txt'';\r\n$mip_form[''3729''][''type''] = '''';\r\n$mip_form[''3729''][''desc''] = ''{select:9}'';\r\n$mip_form[''3729''][''cms_var''] = ''MOD_VAR[3729]'';\r\n$mip_form[''3729''][''cms_val''] = $cms_mod[''value''][''3729''];\r\n$mip_form[''3729''][''cms_val_default''] = ''Wertauswahl 9'';\r\n\r\n// Titel fuer {select:6}\r\n$mip_form[''3829''][''cat''] = ''txt'';\r\n$mip_form[''3829''][''type''] = '''';\r\n$mip_form[''3829''][''desc''] = ''{select:10}'';\r\n$mip_form[''3829''][''cms_var''] = ''MOD_VAR[3829]'';\r\n$mip_form[''3829''][''cms_val''] = $cms_mod[''value''][''3829''];\r\n$mip_form[''3829''][''cms_val_default''] = ''Wertauswahl 10'';\r\n\r\n// Titel fuer {date:1}\r\n$mip_form[''37''][''cat''] = ''txt'';\r\n$mip_form[''37''][''type''] = '''';\r\n$mip_form[''37''][''desc''] = ''{date:1}'';\r\n$mip_form[''37''][''cms_var''] = ''MOD_VAR[37]'';\r\n$mip_form[''37''][''cms_val''] = $cms_mod[''value''][''37''];\r\n$mip_form[''37''][''cms_val_default''] = ''Zeit 1'';\r\n\r\n// Titel fuer {date:2}\r\n$mip_form[''85''][''cat''] = ''txt'';\r\n$mip_form[''85''][''type''] = '''';\r\n$mip_form[''85''][''desc''] = ''{date:2}'';\r\n$mip_form[''85''][''cms_var''] = ''MOD_VAR[85]'';\r\n$mip_form[''85''][''cms_val''] = $cms_mod[''value''][''85''];\r\n$mip_form[''85''][''cms_val_default''] = ''Zeit 2'';\r\n\r\n// Titel fuer {date:3}\r\n$mip_form[''86''][''cat''] = ''txt'';\r\n$mip_form[''86''][''type''] = '''';\r\n$mip_form[''86''][''desc''] = ''{date:3}'';\r\n$mip_form[''86''][''cms_var''] = ''MOD_VAR[86]'';\r\n$mip_form[''86''][''cms_val''] = $cms_mod[''value''][''86''];\r\n$mip_form[''86''][''cms_val_default''] = ''Zeit 3'';\r\n\r\n// Titel fuer {date:3}\r\n$mip_form[''886''][''cat''] = ''txt'';\r\n$mip_form[''886''][''type''] = '''';\r\n$mip_form[''886''][''desc''] = ''{date:4}'';\r\n$mip_form[''886''][''cms_var''] = ''MOD_VAR[886]'';\r\n$mip_form[''886''][''cms_val''] = $cms_mod[''value''][''886''];\r\n$mip_form[''886''][''cms_val_default''] = ''Zeit 4'';\r\n\r\n// Titel fuer {date:3}\r\n$mip_form[''887''][''cat''] = ''txt'';\r\n$mip_form[''887''][''type''] = '''';\r\n$mip_form[''887''][''desc''] = ''{date:5}'';\r\n$mip_form[''887''][''cms_var''] = ''MOD_VAR[887]'';\r\n$mip_form[''887''][''cms_val''] = $cms_mod[''value''][''887''];\r\n$mip_form[''887''][''cms_val_default''] = ''Zeit 5'';\r\n\r\n// Titel fuer {radio:1}\r\n$mip_form[''38''][''cat''] = ''txt'';\r\n$mip_form[''38''][''type''] = '''';\r\n$mip_form[''38''][''desc''] = ''{radio:1}'';\r\n$mip_form[''38''][''cms_var''] = ''MOD_VAR[38]'';\r\n$mip_form[''38''][''cms_val''] = $cms_mod[''value''][''38''];\r\n$mip_form[''38''][''cms_val_default''] = ''Option (Radio) 1'';\r\n\r\n// Titel fuer {checkbox:1}\r\n$mip_form[''39''][''cat''] = ''txt'';\r\n$mip_form[''39''][''type''] = '''';\r\n$mip_form[''39''][''desc''] = ''{checkbox:1}'';\r\n$mip_form[''39''][''cms_var''] = ''MOD_VAR[39]'';\r\n$mip_form[''39''][''cms_val''] = $cms_mod[''value''][''39''];\r\n$mip_form[''39''][''cms_val_default''] = ''Option (Checkbox) 1'';\r\n\r\n// BBCode fuer textarea:1\r\n$mip_form[''49''][''desc''] = ''bbcode im Text 1 einschalten'';\r\n$mip_form[''49''][''cat''] = ''option'';\r\n$mip_form[''49''][''cms_var''] = ''MOD_VAR[49]'';\r\n$mip_form[''49''][''cms_val''] = $cms_mod[''value''][''49''];\r\n$mip_form[''49''][''cms_val_default''] = '''';\r\n$mip_form[''49''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''49''][''option_val''][''0''] = ''bbcode'';\r\n$mip_form[''49''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''49''][''option_val''][''1''] = '''';\r\n$mip_form[''49''][''tab''] = ''0'';\r\n\r\n\r\n// BBCode fuer textarea:2\r\n$mip_form[''50''][''desc''] = ''bbcode im Text 2 einschalten'';\r\n$mip_form[''50''][''cat''] = ''option'';\r\n$mip_form[''50''][''cms_var''] = ''MOD_VAR[50]'';\r\n$mip_form[''50''][''cms_val''] = $cms_mod[''value''][''50''];\r\n$mip_form[''50''][''cms_val_default''] = '''';\r\n$mip_form[''50''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''50''][''option_val''][''0''] = ''bbcode'';\r\n$mip_form[''50''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''50''][''option_val''][''1''] = '''';\r\n$mip_form[''50''][''tab''] = ''0'';\r\n\r\n\r\n// BBCode fuer textarea:3\r\n$mip_form[''51''][''desc''] = ''bbcode im Text 3 einschalten'';\r\n$mip_form[''51''][''cat''] = ''option'';\r\n$mip_form[''51''][''cms_var''] = ''MOD_VAR[51]'';\r\n$mip_form[''51''][''cms_val''] = $cms_mod[''value''][''51''];\r\n$mip_form[''51''][''cms_val_default''] = '''';\r\n$mip_form[''51''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''51''][''option_val''][''0''] = ''bbcode'';\r\n$mip_form[''51''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''51''][''option_val''][''1''] = '''';\r\n$mip_form[''51''][''tab''] = ''0'';\r\n\r\n\r\n// ***************************** Beschreibungen *********************\r\n\r\n#$mip_form[''80''][''cat''] = ''desc'';\r\n#$mip_form[''80''][''type''] = '''';\r\n#$mip_form[''80''][''desc''] = "<strong>Navigation</strong><br />";\r\n#$mip_form[''80''][''tab''] = ''0'';\r\n\r\n#$mip_form[''81''][''cat''] = ''desc'';\r\n#$mip_form[''81''][''type''] = '''';\r\n#$mip_form[''81''][''desc''] = "<strong>Titel</strong><br />";\r\n#$mip_form[''81''][''tab''] = ''0'';\r\n\r\n#$mip_form[''82''][''cat''] = ''desc'';\r\n#$mip_form[''82''][''type''] = '''';\r\n#$mip_form[''82''][''desc''] = "<strong>Einschr&#228;nkungen</strong><br />";\r\n#$mip_form[''82''][''tab''] = ''0'';\r\n\r\n$mip_form[''999''][''cat''] = ''desc'';\r\n$mip_form[''999''][''desc''] = '''';\r\n\r\n$mip_form[''9999''][''cat''] = ''desc'';\r\n$mip_form[''9999''][''desc''] = '''';\r\n\r\n$mip_form[''9998''][''cat''] = ''desc'';\r\n$mip_form[''9998''][''desc''] = ''<br/><hr style="border: 0px;border-top:solid #d6d6d6 1px;border-bottom: solid 1px #FFFFFF;"/>'';\r\n\r\n$mip_form[''9997''][''cat''] = ''desc'';\r\n$mip_form[''9997''][''desc''] = ''<br/><hr style="border: 0px;border-top:solid #d6d6d6 1px;border-bottom: solid 1px #FFFFFF;"/>'';\r\n\r\n\r\n//Unterordner anzeigen\r\n$mip_form[''999999''][''cat''] = ''option'';\r\n$mip_form[''999999''][''desc''] = ''Template-Eingabefeldh&#246;he'';\r\n$mip_form[''999999''][''cms_var''] = ''MOD_VAR[999999]'';\r\n$mip_form[''999999''][''cms_val''] = $cms_mod[''value''][''999999''];\r\n$mip_form[''999999''][''cms_val_default''] = ''0'';\r\n$mip_form[''999999''][''option_desc''][''0''] = ''standard'';\r\n$mip_form[''999999''][''option_val''][''0''] = ''0'';\r\n$mip_form[''999999''][''option_desc''][''1''] = ''+ 100 Pixel'';\r\n$mip_form[''999999''][''option_val''][''1''] = ''100'';\r\n$mip_form[''999999''][''option_desc''][''2''] = ''+ 200 Pixel'';\r\n$mip_form[''999999''][''option_val''][''2''] = ''200'';\r\n$mip_form[''999999''][''option_desc''][''3''] = ''+ 400 Pixel'';\r\n$mip_form[''999999''][''option_val''][''3''] = ''400'';\r\n$mip_form[''999999''][''flag''] = ''reload'';\r\n$mip_form[''999999''][''tab''] = ''0'';\r\n\r\n\r\n#$mip_form[''83''][''cat''] = ''desc'';\r\n#$mip_form[''83''][''type''] = '''';\r\n#$mip_form[''83''][''desc''] = "<strong>Template</strong><br />";\r\n#$mip_form[''83''][''tab''] = ''0'';\r\n\r\n$mip_form[''94''][''cat''] = ''desc'';\r\n$mip_form[''94''][''type''] = '''';\r\n$mip_form[''94''][''desc''] = "<small>{select:<strong>1</strong>}</small>";\r\n$mip_form[''94''][''tab''] = ''0'';\r\n\r\n$mip_form[''3094''][''cat''] = ''desc'';\r\n$mip_form[''3094''][''type''] = '''';\r\n$mip_form[''3094''][''desc''] = "<small>{select:<strong>2</strong>}</small>";\r\n$mip_form[''3094''][''tab''] = ''0'';\r\n\r\n$mip_form[''3194''][''cat''] = ''desc'';\r\n$mip_form[''3194''][''type''] = '''';\r\n$mip_form[''3194''][''desc''] = "<small>{select:<strong>3</strong>}</small>";\r\n$mip_form[''3194''][''tab''] = ''0'';\r\n\r\n$mip_form[''3294''][''cat''] = ''desc'';\r\n$mip_form[''3294''][''type''] = '''';\r\n$mip_form[''3294''][''desc''] = "<small>{select:<strong>4</strong>}</small>";\r\n$mip_form[''3294''][''tab''] = ''0'';\r\n\r\n$mip_form[''3394''][''cat''] = ''desc'';\r\n$mip_form[''3394''][''type''] = '''';\r\n$mip_form[''3394''][''desc''] = "<small>{select:<strong>5</strong>}</small>";\r\n$mip_form[''3394''][''tab''] = ''0'';\r\n\r\n$mip_form[''3494''][''cat''] = ''desc'';\r\n$mip_form[''3494''][''type''] = '''';\r\n$mip_form[''3494''][''desc''] = "<small>{select:<strong>6</strong>}</small>";\r\n$mip_form[''3494''][''tab''] = ''0'';\r\n\r\n$mip_form[''3594''][''cat''] = ''desc'';\r\n$mip_form[''3594''][''type''] = '''';\r\n$mip_form[''3594''][''desc''] = "<small>{select:<strong>7</strong>}</small>";\r\n$mip_form[''3594''][''tab''] = ''0'';\r\n\r\n$mip_form[''3694''][''cat''] = ''desc'';\r\n$mip_form[''3694''][''type''] = '''';\r\n$mip_form[''3694''][''desc''] = "<small>{select:<strong>8</strong>}</small>";\r\n$mip_form[''3694''][''tab''] = ''0'';\r\n\r\n$mip_form[''3794''][''cat''] = ''desc'';\r\n$mip_form[''3794''][''type''] = '''';\r\n$mip_form[''3794''][''desc''] = "<small>{select:<strong>9</strong>}</small>";\r\n$mip_form[''3794''][''tab''] = ''0'';\r\n\r\n$mip_form[''3894''][''cat''] = ''desc'';\r\n$mip_form[''3894''][''type''] = '''';\r\n$mip_form[''3894''][''desc''] = "<small>{select:<strong>10</strong>}</small>";\r\n$mip_form[''3894''][''tab''] = ''0'';\r\n\r\n$mip_form[''95''][''cat''] = ''option'';\r\n$mip_form[''95''][''desc''] = ''Nach M&#246;glichkeit alle absoluten URLs in realitve URLs umwandeln<br/><small>{image:x} {file:x} {filelist}</small>'';\r\n$mip_form[''95''][''cms_var''] = ''MOD_VAR[95]'';\r\n$mip_form[''95''][''cms_val''] = $cms_mod[''value''][''95''];\r\n$mip_form[''95''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''95''][''option_val''][''0''] = ''true'';\r\n$mip_form[''95''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''95''][''option_val''][''1''] = ''false'';\r\n\r\n\r\n$mip_form[''500''][''cat''] = ''txt'';\r\n$mip_form[''500''][''type''] = '''';\r\n$mip_form[''500''][''desc''] = ''K&#252;rzel f&#252;r Byte'';\r\n$mip_form[''500''][''cms_var''] = ''MOD_VAR[500]'';\r\n$mip_form[''500''][''cms_val''] = $cms_mod[''value''][''500''];\r\n$mip_form[''500''][''cms_val_default''] = ''Byte'';\r\n\r\n$mip_form[''501''][''cat''] = ''txt'';\r\n$mip_form[''501''][''type''] = '''';\r\n$mip_form[''501''][''desc''] = ''K&#252;rzel f&#252;r Kilobyte'';\r\n$mip_form[''501''][''cms_var''] = ''MOD_VAR[501]'';\r\n$mip_form[''501''][''cms_val''] = $cms_mod[''value''][''501''];\r\n$mip_form[''501''][''cms_val_default''] = ''KByte'';\r\n\r\n$mip_form[''502''][''cat''] = ''txt'';\r\n$mip_form[''502''][''type''] = '''';\r\n$mip_form[''502''][''desc''] = ''K&#252;rzel f&#252;r Megabyte'';\r\n$mip_form[''502''][''cms_var''] = ''MOD_VAR[502]'';\r\n$mip_form[''502''][''cms_val''] = $cms_mod[''value''][''502''];\r\n$mip_form[''502''][''cms_val_default''] = ''MByte'';\r\n\r\n$mip_form[''510''][''cat''] = ''option'';\r\n$mip_form[''510''][''type''] = '''';\r\n$mip_form[''510''][''desc''] = ''Nachkommastellen'';\r\n$mip_form[''510''][''cms_var''] = ''MOD_VAR[510]'';\r\n$mip_form[''510''][''cms_val''] = $cms_mod[''value''][''510''];\r\n$mip_form[''510''][''cms_val_default''] = ''2'';\r\n$mip_form[''510''][''option_desc''][''0''] = ''0'';\r\n$mip_form[''510''][''option_val''][''0''] = ''0'';\r\n$mip_form[''510''][''option_desc''][''1''] = ''1'';\r\n$mip_form[''510''][''option_val''][''1''] = ''1'';\r\n$mip_form[''510''][''option_desc''][''2''] = ''2'';\r\n$mip_form[''510''][''option_val''][''2''] = ''2'';\r\n$mip_form[''510''][''tab''] = ''0'';\r\n\r\n\r\n$mip_form[''520''][''cat''] = ''txt'';\r\n$mip_form[''520''][''type''] = '''';\r\n$mip_form[''520''][''desc''] = ''Bild-Dimensionen Template {imagedimensions:x}<br/><small>(m&#246;gliche Elemente {width} {height})</small>'';\r\n$mip_form[''520''][''cms_var''] = ''MOD_VAR[520]'';\r\n$mip_form[''520''][''cms_val''] = $cms_mod[''value''][''520''];\r\n$mip_form[''520''][''cms_val_default''] = ''{width}x{height} Pixel'';\r\n\r\n\r\n//rights\r\n$mip_form[''1000''][''cat''] = ''desc'';\r\n$mip_form[''1000''][''type''] = '''';\r\n$mip_form[''1000''][''desc''] = ''Bearbeitungsrechte f&#252;r ausgeschlossene Gruppen'';\r\n$mip_form[''1000''][''tab''] = ''0'';\r\n\r\n$mip_form[''1004''][''desc''] = ''Hinzuf&#252;gen von Elementen / Elementgruppen erlauben '';\r\n$mip_form[''1004''][''cat''] = ''app_group'';\r\n$mip_form[''1004''][''output_cat''] = ''option'';\r\n$mip_form[''1004''][''cms_var''] = ''MOD_VAR[1004]'';\r\n$mip_form[''1004''][''cms_val''] = $cms_mod[''value''][''1004''];\r\n$mip_form[''1004''][''flag''] = ''multiple'';\r\n$mip_form[''1004''][''size''] = ''5'';\r\n$mip_form[''1004''][''cms_val_default''] = ''true'';\r\n$mip_form[''1004''][''with_admin''] = ''true'';\r\n\r\n$mip_form[''1001''][''desc''] = ''Ändern <small>(Bearbeiten)</small>'';\r\n$mip_form[''1001''][''cat''] = ''option'';\r\n$mip_form[''1001''][''cms_var''] = ''MOD_VAR[1001]'';\r\n$mip_form[''1001''][''cms_val''] = $cms_mod[''value''][''1001''];\r\n$mip_form[''1001''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''1001''][''option_val''][''0''] = ''true'';\r\n$mip_form[''1001''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''1001''][''option_val''][''1''] = ''false'';\r\n$mip_form[''1001''][''cms_val_default''] = ''false'';\r\n\r\n$mip_form[''1002''][''desc''] = ''L&#246;schen'';\r\n$mip_form[''1002''][''cat''] = ''option'';\r\n$mip_form[''1002''][''cms_var''] = ''MOD_VAR[1002]'';\r\n$mip_form[''1002''][''cms_val''] = $cms_mod[''value''][''1002''];\r\n$mip_form[''1002''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''1002''][''option_val''][''1''] = ''false'';\r\n$mip_form[''1002''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''1002''][''option_val''][''0''] = ''true'';\r\n$mip_form[''1002''][''cms_val_default''] = ''true'';\r\n\r\n$mip_form[''1003''][''desc''] = ''Verschieben'';\r\n$mip_form[''1003''][''cat''] = ''option'';\r\n$mip_form[''1003''][''cms_var''] = ''MOD_VAR[1003]'';\r\n$mip_form[''1003''][''cms_val''] = $cms_mod[''value''][''1003''];\r\n$mip_form[''1003''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''1003''][''option_val''][''1''] = ''false'';\r\n$mip_form[''1003''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''1003''][''option_val''][''0''] = ''true'';\r\n$mip_form[''1003''][''cms_val_default''] = ''true'';\r\n\r\n\r\n$mip_form[''10000''][''desc''] = ''Link onclick-Attribut <small>(&lt;a onclick=&quot;{imageurl:1}&quot; ... )</small>'';\r\n$mip_form[''10000''][''cat''] = ''txt'';\r\n$mip_form[''10000''][''type''] = ''long'';\r\n$mip_form[''10000''][''cms_var''] = ''MOD_VAR[10000]'';\r\n$mip_form[''10000''][''cms_val''] = $cms_mod[''value''][''10000''];\r\n$mip_form[''10000''][''cms_val_default''] = ''javascript:new_imagepopup("{imageurl:1}","","Fenster schliessen","","{imagewidth:1}","{imageheight:1}","true");return false;'';\r\n\r\n$mip_form[''10001''][''desc''] = ''Link href-Attribut <small>(&lt;a href=&quot;{imageurl:1}&quot; ... )</small>'';\r\n$mip_form[''10001''][''cat''] = ''txt'';\r\n$mip_form[''10001''][''type''] = '''';\r\n$mip_form[''10001''][''cms_var''] = ''MOD_VAR[10001]'';\r\n$mip_form[''10001''][''cms_val''] = $cms_mod[''value''][''10001''];\r\n$mip_form[''10001''][''cms_val_default''] = ''{imageurl:1}'';\r\n\r\n$mip_form[''10002''][''desc''] = ''Link-Inhalt <small>(&lt;a ... &gt;{imagethumb:1}&lt;/a&gt;)</small>'';\r\n$mip_form[''10002''][''cat''] = ''txt'';\r\n$mip_form[''10002''][''type''] = '''';\r\n$mip_form[''10002''][''cms_var''] = ''MOD_VAR[10002]'';\r\n$mip_form[''10002''][''cms_val''] = $cms_mod[''value''][''10002''];\r\n$mip_form[''10002''][''cms_val_default''] = ''{imagethumb:1}'';\r\n\r\n\r\n\r\n\r\n//list\r\n$mip_form[''4010''][''desc''] = ''Template-Listenrahmen <small>{list:1}</small>'';\r\n$mip_form[''4010''][''cat''] = ''txtarea'';\r\n$mip_form[''4010''][''rows''] = ''3'';\r\n$mip_form[''4010''][''type''] = ''long'';\r\n$mip_form[''4010''][''cms_var''] = ''MOD_VAR[4010]'';\r\n$mip_form[''4010''][''cms_val''] = $cms_mod[''value''][''4010''];\r\n$mip_form[''4010''][''cms_val_default''] = ''<ul>{entries}</ul>\r\n'';\r\n\r\n$mip_form[''4020''][''desc''] = ''Template-Listeneintr&#228;ge <small>{list:1}</small>'';\r\n$mip_form[''4020''][''cat''] = ''txtarea'';\r\n$mip_form[''4020''][''rows''] = ''3'';\r\n$mip_form[''4020''][''type''] = ''long'';\r\n$mip_form[''4020''][''cms_var''] = ''MOD_VAR[4020]'';\r\n$mip_form[''4020''][''cms_val''] = $cms_mod[''value''][''4020''];\r\n$mip_form[''4020''][''cms_val_default''] = ''<li>{content}</li>\r\n'';\r\n\r\n\r\n$mip_form[''4090''][''cat''] = ''txt'';\r\n$mip_form[''4090''][''type''] = '''';\r\n$mip_form[''4090''][''desc''] = ''{list:1}'';\r\n$mip_form[''4090''][''cms_var''] = ''MOD_VAR[4090]'';\r\n$mip_form[''4090''][''cms_val''] = $cms_mod[''value''][''4090''];\r\n$mip_form[''4090''][''cms_val_default''] = ''Aufz&#228;hlungsliste'';\r\n\r\n\r\n//list\r\n$mip_form[''4110''][''desc''] = ''Template-Listenrahmen <small>{list:2}</small>'';\r\n$mip_form[''4110''][''cat''] = ''txtarea'';\r\n$mip_form[''4110''][''rows''] = ''3'';\r\n$mip_form[''4110''][''type''] = ''long'';\r\n$mip_form[''4110''][''cms_var''] = ''MOD_VAR[4110]'';\r\n$mip_form[''4110''][''cms_val''] = $cms_mod[''value''][''4110''];\r\n$mip_form[''4110''][''cms_val_default''] = ''<ol>{entries}</ol>\r\n'';\r\n\r\n$mip_form[''4120''][''desc''] = ''Template-Listeneintr&#228;ge <small>{list:2}</small>'';\r\n$mip_form[''4120''][''cat''] = ''txtarea'';\r\n$mip_form[''4120''][''rows''] = ''3'';\r\n$mip_form[''4120''][''type''] = ''long'';\r\n$mip_form[''4120''][''cms_var''] = ''MOD_VAR[4120]'';\r\n$mip_form[''4120''][''cms_val''] = $cms_mod[''value''][''4120''];\r\n$mip_form[''4120''][''cms_val_default''] = ''<li>{content}</li>\r\n'';\r\n\r\n\r\n\r\n$mip_form[''4190''][''cat''] = ''txt'';\r\n$mip_form[''4190''][''type''] = '''';\r\n$mip_form[''4190''][''desc''] = ''{list:2}'';\r\n$mip_form[''4190''][''cms_var''] = ''MOD_VAR[4190]'';\r\n$mip_form[''4190''][''cms_val''] = $cms_mod[''value''][''4190''];\r\n$mip_form[''4190''][''cms_val_default''] = ''Nummerierte Liste'';\r\n\r\n//table \r\n$mip_form[''100400''][''cat''] = ''option'';\r\n$mip_form[''100400''][''desc''] = ''Tabellen&#252;berschrift'';\r\n$mip_form[''100400''][''cms_var''] = ''MOD_VAR[100400]'';\r\n$mip_form[''100400''][''cms_val''] = $cms_mod[''value''][''100400''];\r\n$mip_form[''100400''][''cms_val_default''] = ''true'';\r\n$mip_form[''100400''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''100400''][''option_val''][''0''] = ''true'';\r\n$mip_form[''100400''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''100400''][''option_val''][''1''] = ''false'';\r\n$mip_form[''100400''][''flag''] = ''reload'';\r\n\r\n$mip_form[''100401''][''cat''] = ''option'';\r\n$mip_form[''100401''][''desc''] = ''Tabellenkopf'';\r\n$mip_form[''100401''][''cms_var''] = ''MOD_VAR[100401]'';\r\n$mip_form[''100401''][''cms_val''] = $cms_mod[''value''][''100401''];\r\n$mip_form[''100401''][''cms_val_default''] = ''true'';\r\n$mip_form[''100401''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''100401''][''option_val''][''0''] = ''true'';\r\n$mip_form[''100401''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''100401''][''option_val''][''1''] = ''false'';\r\n$mip_form[''100401''][''flag''] = ''reload'';\r\n\r\n$mip_form[''100402''][''cat''] = ''option'';\r\n$mip_form[''100402''][''desc''] = ''Tabellenfu&#223;'';\r\n$mip_form[''100402''][''cms_var''] = ''MOD_VAR[100402]'';\r\n$mip_form[''100402''][''cms_val''] = $cms_mod[''value''][''100402''];\r\n$mip_form[''100402''][''cms_val_default''] = ''false'';\r\n$mip_form[''100402''][''option_desc''][''0''] = ''Ja - manuelle Eingabe notwendig'';\r\n$mip_form[''100402''][''option_val''][''0''] = ''true'';\r\n$mip_form[''100402''][''option_desc''][''1''] = ''Ja - identisch mit Tabellenkopf'';\r\n$mip_form[''100402''][''option_val''][''1''] = ''head'';\r\n$mip_form[''100402''][''option_desc''][''2''] = ''Nein'';\r\n$mip_form[''100402''][''option_val''][''2''] = ''false'';\r\n$mip_form[''100402''][''flag''] = ''reload'';\r\n\r\n\r\n$mip_form[''10030''][''desc''] = ''Style-Klasse - Tabellenzeilen (gerade)'';\r\n$mip_form[''10030''][''cat''] = ''app_css'';\r\n$mip_form[''10030''][''output_cat''] = ''option'';\r\n$mip_form[''10030''][''cms_var''] = ''MOD_VAR[10030]'';\r\n$mip_form[''10030''][''cms_val''] = $cms_mod[''value''][''10030''];\r\n$mip_form[''10030''][''flag''] = ''class_only'';\r\n\r\n$mip_form[''10032''][''cat''] = ''txt'';\r\n$mip_form[''10032''][''type''] = '''';\r\n$mip_form[''10032''][''desc''] = ''Optionale Attribute - Tabellenzeilen (gerade)'';\r\n$mip_form[''10032''][''cms_var''] = ''MOD_VAR[10032]'';\r\n$mip_form[''10032''][''cms_val''] = $cms_mod[''value''][''10032''];\r\n$mip_form[''10032''][''cms_val_default''] = '''';\r\n\r\n$mip_form[''10031''][''desc''] = ''Style-Klasse - Tabellenzeilen (ungerade)'';\r\n$mip_form[''10031''][''cat''] = ''app_css'';\r\n$mip_form[''10031''][''output_cat''] = ''option'';\r\n$mip_form[''10031''][''cms_var''] = ''MOD_VAR[10031]'';\r\n$mip_form[''10031''][''cms_val''] = $cms_mod[''value''][''10031''];\r\n$mip_form[''10031''][''flag''] = ''class_only'';\r\n\r\n$mip_form[''10033''][''cat''] = ''txt'';\r\n$mip_form[''10033''][''type''] = '''';\r\n$mip_form[''10033''][''desc''] = ''Optionale Attribute - Tabellenzeilen (ungerade)'';\r\n$mip_form[''10033''][''cms_var''] = ''MOD_VAR[10033]'';\r\n$mip_form[''10033''][''cms_val''] = $cms_mod[''value''][''10033''];\r\n$mip_form[''10033''][''cms_val_default''] = '''';\r\n\r\n$mip_form[''10034''][''cat''] = ''txt'';\r\n$mip_form[''10034''][''type''] = ''long'';\r\n$mip_form[''10034''][''desc''] = ''Optionale Attribute - Tabellenspalten <small><br/>(Trennzeichen: "|" - bspw. <em>class="col1"|class="col2"</em>)</small>'';\r\n$mip_form[''10034''][''cms_var''] = ''MOD_VAR[10034]'';\r\n$mip_form[''10034''][''cms_val''] = $cms_mod[''value''][''10034''];\r\n$mip_form[''10034''][''cms_val_default''] = '''';\r\n\r\n$mip_form[''10060''][''cat''] = ''txt'';\r\n$mip_form[''10060''][''type''] = '''';\r\n$mip_form[''10060''][''desc''] = ''Optionale Attribute &lt;table&gt;-Tag'';\r\n$mip_form[''10060''][''cms_var''] = ''MOD_VAR[10060]'';\r\n$mip_form[''10060''][''cms_val''] = $cms_mod[''value''][''10060''];\r\n$mip_form[''10060''][''cms_val_default''] = '''';\r\n\r\n$mip_form[''10050''][''cat''] = ''txt'';\r\n$mip_form[''10050''][''type''] = '''';\r\n$mip_form[''10050''][''desc''] = ''Spaltentrennzeichen - Eingabe Tabellenkopf''.(($cms_mod[''value''][''400'']==''true'')?'', -fu&#223;'':'''').'' und -daten'';\r\n$mip_form[''10050''][''cms_var''] = ''MOD_VAR[10050]'';\r\n$mip_form[''10050''][''cms_val''] = $cms_mod[''value''][''10050''];\r\n$mip_form[''10050''][''cms_val_default''] = ''|'';\r\n\r\n$mip_form[''10070''][''cat''] = ''txt'';\r\n$mip_form[''10070''][''type''] = '''';\r\n$mip_form[''10070''][''desc''] = ''Zeichenkonvertierung innerhalb Zellen bzw. Eintr&#228;gen&nbsp;&nbsp;&nbsp;<small><em><strong>aus ...</strong></em></small> <small><br/>(mehrere Zeichen mittels Komma trennen!)</small>'';\r\n$mip_form[''10070''][''cms_var''] = ''MOD_VAR[10070]'';\r\n$mip_form[''10070''][''cms_val''] = $cms_mod[''value''][''10070''];\r\n$mip_form[''10070''][''cms_val_default''] = ''#'';\r\n\r\n$mip_form[''10071''][''cat''] = ''txt'';\r\n$mip_form[''10071''][''type''] = '''';\r\n$mip_form[''10071''][''desc''] = ''Zeichenkonvertierung innerhalb Zellen bzw. Eintr&#228;gen&nbsp;&nbsp;&nbsp;<small><em><strong>... wird</strong></em></small> <small><br/>(mehrere Zeichen mittels Komma trennen!)</small>'';\r\n$mip_form[''10071''][''cms_var''] = ''MOD_VAR[10071]'';\r\n$mip_form[''10071''][''cms_val''] = $cms_mod[''value''][''10071''];\r\n$mip_form[''10071''][''cms_val_default''] = ''<br/>'';\r\n\r\n$mip_form[''100100''][''cat''] = ''txt'';\r\n$mip_form[''100100''][''type''] = '''';\r\n$mip_form[''100100''][''desc''] = ''{table_caption} <small>Tabellen&#252;berschrift</small>'';\r\n$mip_form[''100100''][''cms_var''] = ''MOD_VAR[100100]'';\r\n$mip_form[''100100''][''cms_val''] = $cms_mod[''value''][''100100''];\r\n$mip_form[''100100''][''cms_val_default''] = ''Tabellen&#252;berschrift'';\r\n\r\n$mip_form[''100101''][''cat''] = ''txt'';\r\n$mip_form[''100101''][''type''] = '''';\r\n$mip_form[''100101''][''desc''] = ''{table_head} <small>Tabellenkopf</small>'';\r\n$mip_form[''100101''][''cms_var''] = ''MOD_VAR[100101]'';\r\n$mip_form[''100101''][''cms_val''] = $cms_mod[''value''][''100101''];\r\n$mip_form[''100101''][''cms_val_default''] = ''Tabellenkopf'';\r\n\r\n$mip_form[''100102''][''cat''] = ''txt'';\r\n$mip_form[''100102''][''type''] = '''';\r\n$mip_form[''100102''][''desc''] = ''{table_data} <small>Tabellendaten</small>'';\r\n$mip_form[''100102''][''cms_var''] = ''MOD_VAR[100102]'';\r\n$mip_form[''100102''][''cms_val''] = $cms_mod[''value''][''100102''];\r\n$mip_form[''100102''][''cms_val_default''] = ''Tabellendaten'';\r\n\r\n$mip_form[''100103''][''cat''] = ''txt'';\r\n$mip_form[''100103''][''type''] = '''';\r\n$mip_form[''100103''][''desc''] = ''{table_foot} <small>Tabellenfu&#223;</small>'';\r\n$mip_form[''100103''][''cms_var''] = ''MOD_VAR[100103]'';\r\n$mip_form[''100103''][''cms_val''] = $cms_mod[''value''][''100103''];\r\n$mip_form[''100103''][''cms_val_default''] = ''Tabellenfu&#223;'';\r\n\r\n$mip_form[''2000''][''cat''] = ''txt'';\r\n$mip_form[''2000''][''type''] = '''';\r\n$mip_form[''2000''][''desc''] = ''{filelist}'';\r\n$mip_form[''2000''][''cms_var''] = ''MOD_VAR[2000]'';\r\n$mip_form[''2000''][''cms_val''] = $cms_mod[''value''][''2000''];\r\n$mip_form[''2000''][''cms_val_default''] = ''Verzeichnisauswahl'';\r\n\r\n$mip_form[''2001''][''cat''] = ''txt'';\r\n$mip_form[''2001''][''type''] = '''';\r\n$mip_form[''2001''][''desc''] = ''{filelist} <small>Unterverzeichnisse anzeigen?</small>'';\r\n\r\n\r\n$mip_form[''2001''][''cms_var''] = ''MOD_VAR[2001]'';\r\n$mip_form[''2001''][''cms_val''] = $cms_mod[''value''][''2001''];\r\n$mip_form[''2001''][''cms_val_default''] = ''Unterverzeichnisse anzeigen?'';\r\n\r\n$mip_form[''2010''][''desc''] = ''Template-Einleitung'';\r\n$mip_form[''2010''][''cat''] = ''txtarea'';\r\n$mip_form[''2010''][''rows''] = ''3'';\r\n$mip_form[''2010''][''type''] = ''long'';\r\n$mip_form[''2010''][''cms_var''] = ''MOD_VAR[2010]'';\r\n$mip_form[''2010''][''cms_val''] = $cms_mod[''value''][''2010''];\r\n$mip_form[''2010''][''cms_val_default''] = ''<ul>\r\n'';\r\n\r\n$mip_form[''2013''][''desc''] = ''Template-Verzeichniseinleitung'';\r\n$mip_form[''2013''][''cat''] = ''txtarea'';\r\n$mip_form[''2013''][''rows''] = ''4'';\r\n$mip_form[''2013''][''type''] = ''long'';\r\n$mip_form[''2013''][''cms_var''] = ''MOD_VAR[2013]'';\r\n$mip_form[''2013''][''cms_val''] = $cms_mod[''value''][''2013''];\r\n$mip_form[''2013''][''cms_val_default''] = ''<li><strong>{dirname}</strong>\r\n<ul>\r\n'';\r\n\r\n$mip_form[''2011''][''desc''] = ''Template-Dateieintrag'';\r\n$mip_form[''2011''][''cat''] = ''txtarea'';\r\n$mip_form[''2011''][''rows''] = ''8'';\r\n$mip_form[''2011''][''type''] = ''long'';\r\n$mip_form[''2011''][''cms_var''] = ''MOD_VAR[2011]'';\r\n$mip_form[''2011''][''cms_val''] = $cms_mod[''value''][''2011''];\r\n$mip_form[''2011''][''cms_val_default''] = ''<li>{file_no}. <a href="{fileurl}">{filename}</a> <small>Info: {filetypedesc}, {filesize}</small></li>\r\n'';\r\n\r\n$mip_form[''2030''][''desc''] = ''Template zwischen Dateieintr&#228;gen'';\r\n$mip_form[''2030''][''cat''] = ''txtarea'';\r\n$mip_form[''2030''][''rows''] = ''3'';\r\n$mip_form[''2030''][''type''] = ''long'';\r\n$mip_form[''2030''][''cms_var''] = ''MOD_VAR[2030]'';\r\n$mip_form[''2030''][''cms_val''] = $cms_mod[''value''][''2030''];\r\n$mip_form[''2030''][''cms_val_default''] = '''';\r\n\r\n$mip_form[''2031''][''cat''] = ''txt'';\r\n$mip_form[''2031''][''type''] = '''';\r\n$mip_form[''2031''][''desc''] = ''Template zwischen Dateieintr&#228;gen alle <em>n</em> Eintr&#228;ge'';\r\n$mip_form[''2031''][''cms_var''] = ''MOD_VAR[2031]'';\r\n$mip_form[''2031''][''cms_val''] = $cms_mod[''value''][''2031''];\r\n$mip_form[''2031''][''cms_val_default''] = ''1'';\r\n\r\n$mip_form[''2032''][''cat''] = ''option'';\r\n$mip_form[''2032''][''type''] = '''';\r\n$mip_form[''2032''][''desc''] = ''Z&#228;hler f&#252;r Template zwischen Dateieintr&#228;gen<br/> in jedem Verzeichnis zur&#252;cksetzen?'';\r\n$mip_form[''2032''][''cms_var''] = ''MOD_VAR[2032]'';\r\n$mip_form[''2032''][''cms_val''] = $cms_mod[''value''][''2032''];\r\n$mip_form[''2032''][''cms_val_default''] = ''true'';\r\n$mip_form[''2032''][''option_desc''][''0''] = ''Nein'';\r\n$mip_form[''2032''][''option_val''][''0''] = ''0'';\r\n$mip_form[''2032''][''option_desc''][''1''] = ''Ja'';\r\n$mip_form[''2032''][''option_val''][''1''] = ''1'';\r\n$mip_form[''2032''][''tab''] = ''0'';\r\n\r\n$mip_form[''2014''][''desc''] = ''Template-Verzeichnisabschluss'';\r\n$mip_form[''2014''][''cat''] = ''txtarea'';\r\n$mip_form[''2014''][''rows''] = ''3'';\r\n$mip_form[''2014''][''type''] = ''long'';\r\n$mip_form[''2014''][''cms_var''] = ''MOD_VAR[2014]'';\r\n$mip_form[''2014''][''cms_val''] = $cms_mod[''value''][''2014''];\r\n$mip_form[''2014''][''cms_val_default''] = ''</ul>\r\n</li>\r\n'';\r\n\r\n$mip_form[''2012''][''desc''] = ''Template-Abschluss'';\r\n$mip_form[''2012''][''cat''] = ''txtarea'';\r\n$mip_form[''2012''][''rows''] = ''2'';\r\n$mip_form[''2012''][''type''] = ''long'';\r\n$mip_form[''2012''][''cms_var''] = ''MOD_VAR[2012]'';\r\n$mip_form[''2012''][''cms_val''] = $cms_mod[''value''][''2012''];\r\n$mip_form[''2012''][''cms_val_default''] = ''</ul>\r\n'';\r\n\r\n$mip_form[''2018''][''desc''] = ''Anzuzeigende / ausw&#228;hlbare Ordner'';\r\n$mip_form[''2018''][''cat''] = ''app_directory'';\r\n$mip_form[''2018''][''output_cat''] = ''option'';\r\n$mip_form[''2018''][''cms_var''] = ''MOD_VAR[2018]'';\r\n$mip_form[''2018''][''cms_val''] = $cms_mod[''value''][''2018''];\r\n$mip_form[''2018''][''flag''] = ''multiple'';\r\n$mip_form[''2018''][''size''] = ''5'';\r\n\r\n$mip_form[''2019''][''cat''] = ''option'';\r\n$mip_form[''2019''][''type''] = '''';\r\n$mip_form[''2019''][''desc''] = ''Unterverzeichnisse der Ordner anzeigen / ausw&#228;hlen'';\r\n$mip_form[''2019''][''cms_var''] = ''MOD_VAR[2019]'';\r\n$mip_form[''2019''][''cms_val''] = $cms_mod[''value''][''2019''];\r\n$mip_form[''2019''][''cms_val_default''] = ''true'';\r\n$mip_form[''2019''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''2019''][''option_val''][''1''] = ''false'';\r\n$mip_form[''2019''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''2019''][''option_val''][''0''] = ''true'';\r\n$mip_form[''2019''][''tab''] = ''0'';\r\n\r\n$mip_form[''2002''][''cat''] = ''option'';\r\n$mip_form[''2002''][''type''] = '''';\r\n$mip_form[''2002''][''desc''] = ''F&#252;r die erste Verzeichnisebene<br/>Verzeichniseinleitung-/abschluss ausgeben.'';\r\n$mip_form[''2002''][''cms_var''] = ''MOD_VAR[2002]'';\r\n$mip_form[''2002''][''cms_val''] = $cms_mod[''value''][''2002''];\r\n$mip_form[''2002''][''cms_val_default''] = ''true'';\r\n$mip_form[''2002''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''2002''][''option_val''][''1''] = ''false'';\r\n$mip_form[''2002''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''2002''][''option_val''][''0''] = ''true'';\r\n$mip_form[''2002''][''tab''] = ''0'';\r\n\r\n$mip_form[''2004''][''cat''] = ''option'';\r\n$mip_form[''2004''][''type''] = '''';\r\n$mip_form[''2004''][''desc''] = ''Vollst&#228;ndige Pfade <small>{dirname}</small>'';\r\n$mip_form[''2004''][''cms_var''] = ''MOD_VAR[2004]'';\r\n$mip_form[''2004''][''cms_val''] = $cms_mod[''value''][''2004''];\r\n$mip_form[''2004''][''cms_val_default''] = ''true'';\r\n$mip_form[''2004''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''2004''][''option_val''][''1''] = ''false'';\r\n$mip_form[''2004''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''2004''][''option_val''][''0''] = ''true'';\r\n$mip_form[''2004''][''tab''] = ''0'';\r\n\r\n$mip_form[''2005''][''cat''] = ''txt'';\r\n$mip_form[''2005''][''type''] = '''';\r\n$mip_form[''2005''][''desc''] = ''Verzeichnis-Trennzeichen'';\r\n$mip_form[''2005''][''cms_var''] = ''MOD_VAR[2005]'';\r\n$mip_form[''2005''][''cms_val''] = $cms_mod[''value''][''2005''];\r\n$mip_form[''2005''][''cms_val_default''] = '' » '';\r\n\r\n$mip_form[''2006''][''desc''] = ''Dateitypen anzeigen / ausw&#228;hlen'';\r\n$mip_form[''2006''][''cat''] = ''app_filetype'';\r\n$mip_form[''2006''][''output_cat''] = ''option'';\r\n$mip_form[''2006''][''cms_var''] = ''MOD_VAR[2006]'';\r\n$mip_form[''2006''][''cms_val''] = $cms_mod[''value''][''2006''];\r\n$mip_form[''2006''][''flag''] = ''multiple'';\r\n$mip_form[''2006''][''size''] = ''5'';\r\n\r\n$mip_form[''2003''][''cat''] = ''option'';\r\n$mip_form[''2003''][''type''] = '''';\r\n$mip_form[''2003''][''desc''] = ''Methode zur Verzeichnisauswahl'';\r\n$mip_form[''2003''][''cms_var''] = ''MOD_VAR[2003]'';\r\n$mip_form[''2003''][''cms_val''] = $cms_mod[''value''][''2003''];\r\n$mip_form[''2003''][''cms_val_default''] = ''fsb'';\r\n$mip_form[''2003''][''option_desc''][''1''] = ''Resource-Browser / Dateiauswahl'';\r\n$mip_form[''2003''][''option_val''][''1''] = ''rb'';\r\n$mip_form[''2003''][''option_desc''][''0''] = ''Frontend-Selectbox / Verzeichnisauswahl'';\r\n$mip_form[''2003''][''option_val''][''0''] = ''fsb'';\r\n$mip_form[''2003''][''tab''] = ''0'';\r\n$mip_form[''2003''][''flag''] = ''reload'';\r\n\r\n$mip_form[''2009''][''cat''] = ''desc'';\r\n$mip_form[''2009''][''type''] = '''';\r\n$mip_form[''2009''][''desc''] = ''<div id="legend_MOD_VAR2000" style="display:none;;text-align:right;"><small style="line-height:140%;"><strong>M&#246;gliche Elemente</strong><br/><br/> \r\n{file} {filename} {filepath} {fileurl} {filefmtitle} {filefmdesc} {filesize}<br />\r\n{filetype} {filetypedesc} {filetypeicon} {filetypeiconname} {filetypeiconurl} {filemimetype} {filecreated} {filemodified}<br />\r\n{imagewidth} {imageheight} {imagethumburl} {imagethumbwidth} {imagethumbheight} {imagethumbhalfwidth} {imagethumbhalfheight}<br /><br />\r\n{dirname}<br/>\r\n{all_no} Z&#228;hler Verzeichnisse und Dateien<br/>\r\n{dir_no} Z&#228;hler Verzeichnisse<br/>\r\n{file_no} Z&#228;hler Dateien eines Verzichnisses<br/>\r\n{all_file_no} Z&#228;hler Dateien<br/><br/>\r\n<strong>{if_</strong>Element:x<strong>} {/if_</strong>Element:x<strong>}</strong> <strong>{if_not_</strong>Element:x<strong>} {/if_not_</strong>Element:x<strong>}</strong><br/>\r\n<strong>{if_</strong>Element:x<strong>=</strong>Value<strong>} {/if_</strong>Element:x<strong>=</strong>Value<strong>}</strong> <strong>{if_not_</strong>Element:x<strong>=</strong>Value<strong>} {/if_not_</strong>Element:x<strong>=</strong>Value<strong>}</strong></small>\r\n</div><div style="text-align:right;" onclick="this.innerHTML=document.getElementById(\\''legend_MOD_VAR2000\\'').innerHTML;"><small style="cursor: pointer;">Hilfe anzeigen<br /></small></div>'';\r\n\r\n//beschreibung/ Legende\r\n$mip_form[''2008''][''cat''] = ''desc'';\r\n$mip_form[''2008''][''type''] = '''';\r\n$mip_form[''2008''][''desc''] = ''<div id="legend_MOD_VAR2001" style="display:none;;text-align:right;"><small><strong>M&#246;gliche Elemente</strong><br/><br/> \r\n{dirname}<br/>\r\n{all_no} Z&#228;hler Verzeichnisse und Dateien<br/>\r\n{dir_no} Z&#228;hler Verzeichnisse<br/>\r\n{file_count} Anzahl Dateien des aktuellen Verzeichnisses\r\n</small>\r\n</div><div style="text-align:right;" onclick="this.innerHTML=document.getElementById(\\''legend_MOD_VAR2001\\'').innerHTML;"><small style="cursor: pointer;">Hilfe anzeigen<br /></small></div>'';\r\n\r\n$mip_form[''2015''][''desc''] = ''Hierarchische Listung'';\r\n$mip_form[''2015''][''cat''] = ''option'';\r\n$mip_form[''2015''][''cms_var''] = ''MOD_VAR[2015]'';\r\n$mip_form[''2015''][''cms_val''] = $cms_mod[''value''][''2015''];\r\n$mip_form[''2015''][''cms_val_default''] = '''';\r\n$mip_form[''2015''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''2015''][''option_val''][''0''] = ''true'';\r\n$mip_form[''2015''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''2015''][''option_val''][''1''] = ''false'';\r\n$mip_form[''2015''][''tab''] = ''0'';\r\n\r\n$mip_form[''2016''][''cat''] = ''txtarea'';\r\n$mip_form[''2016''][''type''] = '''';\r\n$mip_form[''2016''][''rows''] = ''3'';\r\n$mip_form[''2016''][''desc''] = ''Sortierung der Dateien<br/><small><strong><em>DATENFELD</strong> (s.u.) > <strong>SORTIERUNG</strong> (ASC = aufsteigend, DESC = absteigend)<br/>f&#252;r Zufallsausgabe RAND() eingeben</em><br/>\r\n<br/>filename&nbsp;&nbsp;filesize&nbsp;&nbsp;titel&nbsp;&nbsp;description&nbsp;&nbsp;created&nbsp;&nbsp;lastmodified</small>'';\r\n$mip_form[''2016''][''cms_var''] = ''MOD_VAR[2016]'';\r\n$mip_form[''2016''][''cms_val''] = $cms_mod[''value''][''2016''];\r\n$mip_form[''2016''][''cms_val_default''] = ''filename > ASC'';\r\n\r\n$mip_form[''2116''][''cat''] = ''txt'';\r\n$mip_form[''2116''][''type''] = '''';\r\n$mip_form[''2116''][''desc''] = ''Formatierung des Datums / der Zeit <small>{filecreated} {filemodified}</small>'';\r\n$mip_form[''2116''][''cms_var''] = ''MOD_VAR[2116]'';\r\n$mip_form[''2116''][''cms_val''] = $cms_mod[''value''][''2116''];\r\n$mip_form[''2116''][''cms_val_default''] = ''d.m.Y - H:i'';\r\n\r\n$mip_form[''2020''][''cat''] = ''txt'';\r\n$mip_form[''2020''][''type''] = '''';\r\n$mip_form[''2020''][''desc''] = ''Pfad f&#252;r die Dateityp-Icons'';\r\n$mip_form[''2020''][''cms_var''] = ''MOD_VAR[2020]'';\r\n$mip_form[''2020''][''cms_val''] = $cms_mod[''value''][''2020''];\r\n$mip_form[''2020''][''cms_val_default''] = $cfg_cms[''cms_html_path''].''tpl/''.$cfg_cms[''skin''].''/img/file_icons/'';\r\n\r\n$mip_form[''2021''][''desc''] = ''Verzeichnisauswahl erlauben '';\r\n$mip_form[''2021''][''cat''] = ''app_group'';\r\n$mip_form[''2021''][''output_cat''] = ''option'';\r\n$mip_form[''2021''][''cms_var''] = ''MOD_VAR[2021]'';\r\n$mip_form[''2021''][''cms_val''] = $cms_mod[''value''][''2021''];\r\n$mip_form[''2021''][''flag''] = ''multiple'';\r\n$mip_form[''2021''][''size''] = ''5'';\r\n$mip_form[''2021''][''cms_val_default''] = ''true'';\r\n$mip_form[''2021''][''with_admin''] = ''true'';\r\n\r\n// Template-Beschriftung ausgeben\r\n$mip_form[''2022''][''desc''] = ''Die ausgew&#228;hlte Datei soll in der Dateilliste mit aufgef&#252;hrt werden?'';\r\n$mip_form[''2022''][''cat''] = ''option'';\r\n$mip_form[''2022''][''cms_var''] = ''MOD_VAR[2022]'';\r\n$mip_form[''2022''][''cms_val''] = $cms_mod[''value''][''2022''];\r\n$mip_form[''2022''][''cms_val_default''] = '''';\r\n$mip_form[''2022''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''2022''][''option_val''][''0''] = ''true'';\r\n$mip_form[''2022''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''2022''][''option_val''][''1''] = ''false'';\r\n$mip_form[''2022''][''tab''] = ''0'';\r\n\r\n// text fuer zurueck\r\n$mip_form[''2023''][''cat''] = ''txt'';\r\n$mip_form[''2023''][''type''] = '''';\r\n$mip_form[''2023''][''desc''] = ''Maximale Anzahl von Dateieintr&#228;gen <small>(0 = alle)</small>'';\r\n$mip_form[''2023''][''cms_var''] = ''MOD_VAR[2023]'';\r\n$mip_form[''2023''][''cms_val''] = $cms_mod[''value''][''2023''];\r\n$mip_form[''2023''][''cms_val_default''] = ''0'';\r\n\r\n// text fuer zurueck\r\n$mip_form[''6000''][''cat''] = ''txt'';\r\n$mip_form[''6000''][''type''] = '''';\r\n$mip_form[''6000''][''desc''] = ''Wert <small>{uni:<strong>1</strong>}</small>'';\r\n$mip_form[''6000''][''cms_var''] = ''MOD_VAR[6000]'';\r\n$mip_form[''6000''][''cms_val''] = $cms_mod[''value''][''6000''];\r\n$mip_form[''6000''][''cms_val_default''] = '''';\r\n\r\n$mip_form[''6001''][''cat''] = ''txt'';\r\n$mip_form[''6001''][''type''] = '''';\r\n$mip_form[''6001''][''desc''] = ''Wert <small>{uni:<strong>2</strong>}</small>'';\r\n$mip_form[''6001''][''cms_var''] = ''MOD_VAR[6001]'';\r\n$mip_form[''6001''][''cms_val''] = $cms_mod[''value''][''6001''];\r\n$mip_form[''6001''][''cms_val_default''] = '''';\r\n\r\n$mip_form[''6002''][''cat''] = ''txt'';\r\n$mip_form[''6002''][''type''] = '''';\r\n$mip_form[''6002''][''desc''] = ''Wert <small>{uni:<strong>3</strong>}</small>'';\r\n$mip_form[''6002''][''cms_var''] = ''MOD_VAR[6002]'';\r\n$mip_form[''6002''][''cms_val''] = $cms_mod[''value''][''6002''];\r\n$mip_form[''6002''][''cms_val_default''] = '''';\r\n\r\n$mip_form[''6003''][''cat''] = ''txt'';\r\n$mip_form[''6003''][''type''] = '''';\r\n$mip_form[''6003''][''desc''] = ''Wert <small>{uni:<strong>4</strong>}</small>'';\r\n$mip_form[''6003''][''cms_var''] = ''MOD_VAR[6003]'';\r\n$mip_form[''6003''][''cms_val''] = $cms_mod[''value''][''6003''];\r\n$mip_form[''6003''][''cms_val_default''] = '''';\r\n\r\n$mip_form[''6004''][''cat''] = ''txt'';\r\n$mip_form[''6004''][''type''] = '''';\r\n$mip_form[''6004''][''desc''] = ''Wert <small>{uni:<strong>5</strong>}</small>'';\r\n$mip_form[''6004''][''cms_var''] = ''MOD_VAR[6004]'';\r\n$mip_form[''6004''][''cms_val''] = $cms_mod[''value''][''6004''];\r\n$mip_form[''6004''][''cms_val_default''] = '''';\r\n\r\n$mip_form[''6005''][''cat''] = ''txt'';\r\n$mip_form[''6005''][''type''] = '''';\r\n$mip_form[''6005''][''desc''] = ''Wert <small>{uni:<strong>6</strong>}</small>'';\r\n$mip_form[''6005''][''cms_var''] = ''MOD_VAR[6005]'';\r\n$mip_form[''6005''][''cms_val''] = $cms_mod[''value''][''6005''];\r\n$mip_form[''6005''][''cms_val_default''] = '''';\r\n\r\n\r\n\r\n\r\n\r\n// Ausgabe\r\n\r\n//if simple mode\r\nif($cms_mod[''value''][''0''] == ''''){\r\n foreach ($mip_form[''hide_in_standard_mode''] AS $ke=>$va){\r\n $mip_form[$va][''cat''] = ''hidden'';\r\n $mip_form[$va][''cms_var''] = ''MOD_VAR['' . $va . '']'';\r\n $mip_form[$va][''cms_val''] = $cms_mod[''value''][$va];\r\n }\r\n }\r\n\r\n//if simple mode\r\nif($cms_mod[''value''][''0''] == ''advanced''){\r\n foreach ($mip_form[''hide_in_advanced_mode''] AS $ke=>$va){\r\n $mip_form[$va][''cat''] = ''hidden'';\r\n $mip_form[$va][''cms_var''] = ''MOD_VAR['' . $va . '']'';\r\n $mip_form[$va][''cms_val''] = $cms_mod[''value''][$va];\r\n }\r\n }\r\n\r\nmip_forms_tabpane_beginp();\r\nmip_forms_tabitem_beginp(''Templates'');\r\n\r\n\r\nmip_formsp($mip_form[''9'']); // Legende\r\n\r\n// -------------------------\r\n\r\nif ($mod[''test''] == "true") { echo "change container count:".$cms_mod[''value''][''109'']."<br />"; }\r\n\r\n//memorize the counter\r\n$cms_mod[''value''][''101'']=$cms_mod[''value''][''100''];\r\n\r\n// keeps at least one template on ''cut''\r\nif (-round($cms_mod[''value''][''100''])>=round($cms_mod[''value''][''102'']) && $cms_mod[''value''][''102'']<0)\r\n $cms_mod[''value''][''102'']=-round($cms_mod[''value''][''100''])+1;\r\n\r\n// use the hidden delete-counter on ''cut''\r\nif ($cms_mod[''value''][''102'']<0)\r\n $cms_mod[''value''][''109'']=$cms_mod[''value''][''102''];\r\n \r\n//change handler, wenn Gruppen geloescht werden, alte uniqe ids loeschen\r\nif($cms_mod[''value''][''109''] != ''0'' && $cms_mod[''value''][''109''] != ''''){\r\n if ($mod[''test''] == "true") { echo "change unique id!!!!<br />"; }\r\n $change_fields = (int) $cms_mod[''value''][''109''];\r\n $uniqe_pointer = (int) $cms_mod[''value''][''100''] * 10 +102;\r\n if($change_fields < 0){\r\n for($i = $change_fields; $i <0 ; $i++){\r\n if ($mod[''test''] == "true") { echo $uniqe_pointer . ''<br />'';}\r\n $cms_mod[''value''][$uniqe_pointer] = '''';\r\n $uniqe_pointer = $uniqe_pointer-10;\r\n }\r\n }\r\n if ($mod[''test''] == "true") { echo " ;unique pointer:".$uniqe_pointer."<br />"; }\r\n}\r\n\r\n// Anzahl der Spalten -> $cms_mod[''value''][''100''] ist Zaehler\r\nif ($cms_mod[''value''][''100''] == ''''){\r\n $cms_mod[''value''][''100''] = ''8'';\r\n}\r\nif ($cms_mod[''value''][''100''] <= ''0''){\r\n $cms_mod[''value''][''100''] = ''1'';\r\n}\r\nif ($cms_mod[''value''][''109''] != ''0''){\r\n $cms_mod[''value''][''100''] = round($cms_mod[''value''][''100'']+$cms_mod[''value''][''109'']);\r\n}\r\n//$cms_mod[''value''][''106''] ist uniqe id counter\r\nif ($cms_mod[''value''][''106''] == ''''){\r\n $cms_mod[''value''][''106''] = 1;\r\n}\r\n\r\n\r\n//mod var 100 is container counter\r\n\r\n\r\n\r\n\r\n$mip_form[''100''][''cat''] = ''hidden'';\r\n$mip_form[''100''][''cms_var''] = ''MOD_VAR[100]'';\r\n$mip_form[''100''][''cms_val''] = $cms_mod[''value''][''100''];\r\n\r\n$mip_form[''101''][''cat''] = ''hidden'';\r\n$mip_form[''101''][''cms_var''] = ''MOD_VAR[101]'';\r\n$mip_form[''101''][''cms_val''] = $cms_mod[''value''][''101''];\r\n\r\n#echo "container count:".$cms_mod[''value''][''100'']."<br />"; \r\n#echo "container count mem:".$cms_mod[''value''][''101'']."<br />"; \r\n#echo "uniqe id counter:".$cms_mod[''value''][''106'']."<br />"; \r\n//Default Elemente\r\nif (($cms_mod[''value''][110] == '''') && ($cms_mod[''value''][''100''] >= 1)) $cms_mod[''value''][110] = ''Titel'';\r\nif (($cms_mod[''value''][111] == '''') && ($cms_mod[''value''][''100''] >= 1)) $cms_mod[''value''][111] = ''<h1>{text:1}</h1>'';\r\nif (($cms_mod[''value''][120] == '''') && ($cms_mod[''value''][''100''] >= 2)) $cms_mod[''value''][120] = ''Untertitel'';\r\nif (($cms_mod[''value''][121] == '''') && ($cms_mod[''value''][''100''] >= 2)) $cms_mod[''value''][121] = ''<h2>{text:1}</h2>'';\r\nif (($cms_mod[''value''][130] == '''') && ($cms_mod[''value''][''100''] >= 3)) $cms_mod[''value''][130] = ''Untertitel / Text'';\r\nif (($cms_mod[''value''][131] == '''') && ($cms_mod[''value''][''100''] >= 3)) $cms_mod[''value''][131] = ''<h2>{text:1}</h2>{textarea:1}'';\r\nif (($cms_mod[''value''][140] == '''') && ($cms_mod[''value''][''100''] >= 4)) $cms_mod[''value''][140] = ''Text'';\r\nif (($cms_mod[''value''][141] == '''') && ($cms_mod[''value''][''100''] >= 4)) $cms_mod[''value''][141] = ''{textarea:1}'';\r\nif (($cms_mod[''value''][150] == '''') && ($cms_mod[''value''][''100''] >= 5)) $cms_mod[''value''][150] = ''Bild'';\r\nif (($cms_mod[''value''][151] == '''') && ($cms_mod[''value''][''100''] >= 5)) $cms_mod[''value''][151] = ''{image:1}'';\r\nif (($cms_mod[''value''][160] == '''') && ($cms_mod[''value''][''100''] >= 6)) $cms_mod[''value''][160] = ''File'';\r\nif (($cms_mod[''value''][161] == '''') && ($cms_mod[''value''][''100''] >= 6)) $cms_mod[''value''][161] = ''<a href="{fileurl:1}" target="_blank">{filedesc:1}</a>{text:1} {filesize:1}<br>'';\r\nif (($cms_mod[''value''][170] == '''') && ($cms_mod[''value''][''100''] >= 7)) $cms_mod[''value''][170] = ''Text_Bild'';\r\nif (($cms_mod[''value''][171] == '''') && ($cms_mod[''value''][''100''] >= 7)) $cms_mod[''value''][171] = ''<span align="right" class="image">{image:1}</span>{textarea:1}'';\r\nif (($cms_mod[''value''][180] == '''') && ($cms_mod[''value''][''100''] >= 8)) $cms_mod[''value''][180] = ''Tabelle'';\r\nif (($cms_mod[''value''][181] == '''') && ($cms_mod[''value''][''100''] >= 8)) $cms_mod[''value''][181] = ''{table}'';\r\nif (($cms_mod[''value''][190] == '''') && ($cms_mod[''value''][''100''] >= 9)) $cms_mod[''value''][190] = ''wysiwyg2'';\r\nif (($cms_mod[''value''][191] == '''') && ($cms_mod[''value''][''100''] >= 9)) $cms_mod[''value''][191] = ''{wysiwyg2:1}'';\r\nif (($cms_mod[''value''][200] == '''') && ($cms_mod[''value''][''100''] >=10)) $cms_mod[''value''][200] = ''Zeile'';\r\nif (($cms_mod[''value''][201] == '''') && ($cms_mod[''value''][''100''] >=10)) $cms_mod[''value''][201] = ''<tr>\r\n<td><h2>{text:1}</h2></td>\r\n<td>{textarea:1}{editbutton}</td>\r\n</tr>'';\r\nif (($cms_mod[''value''][210] == '''') && ($cms_mod[''value''][''100''] >=11)) $cms_mod[''value''][210] = ''Listenpunkt'';\r\nif (($cms_mod[''value''][211] == '''') && ($cms_mod[''value''][''100''] >=11)) $cms_mod[''value''][211] = ''<li>{text:1}{editbutton}</li>'';\r\nif (($cms_mod[''value''][220] == '''') && ($cms_mod[''value''][''100''] >=12)) $cms_mod[''value''][220] = ''Trennlinie'';\r\nif (($cms_mod[''value''][221] == '''') && ($cms_mod[''value''][''100''] >=12)) $cms_mod[''value''][221] = ''<hr />'';\r\n\r\n//Default Elemente\r\nif (($cms_mod[''value''][110] == '''') && ($cms_mod[''value''][''100''] >= 1)) $cms_mod[''value''][113] = ''active'';\r\nif (($cms_mod[''value''][120] == '''') && ($cms_mod[''value''][''100''] >= 2)) $cms_mod[''value''][123] = ''active'';\r\nif (($cms_mod[''value''][130] == '''') && ($cms_mod[''value''][''100''] >= 3)) $cms_mod[''value''][133] = ''active'';\r\nif (($cms_mod[''value''][140] == '''') && ($cms_mod[''value''][''100''] >= 4)) $cms_mod[''value''][143] = ''active'';\r\nif (($cms_mod[''value''][150] == '''') && ($cms_mod[''value''][''100''] >= 5)) $cms_mod[''value''][153] = ''active'';\r\nif (($cms_mod[''value''][160] == '''') && ($cms_mod[''value''][''100''] >= 6)) $cms_mod[''value''][163] = ''active'';\r\nif (($cms_mod[''value''][170] == '''') && ($cms_mod[''value''][''100''] >= 7)) $cms_mod[''value''][173] = ''active'';\r\nif (($cms_mod[''value''][180] == '''') && ($cms_mod[''value''][''100''] >= 8)) $cms_mod[''value''][183] = ''active'';\r\nif (($cms_mod[''value''][190] == '''') && ($cms_mod[''value''][''100''] >= 9)) $cms_mod[''value''][193] = ''active'';\r\nif (($cms_mod[''value''][200] == '''') && ($cms_mod[''value''][''100''] >=10)) $cms_mod[''value''][203] = ''active'';\r\nif (($cms_mod[''value''][210] == '''') && ($cms_mod[''value''][''100''] >=11)) $cms_mod[''value''][213] = ''active'';\r\nif (($cms_mod[''value''][220] == '''') && ($cms_mod[''value''][''100''] >=12)) $cms_mod[''value''][223] = ''active'';\r\n\r\nmip_formsp($mip_form[''100'']);\r\n \r\n //$cms_mod[''value''][''n+2''] is reserved for unique id\r\n //if ($cms_mod[''value''][''110''] == '''') $cms_mod[''value''][''110''] = ''Text'';//Elementname\r\n //if ($cms_mod[''value''][''111''] == '''') $cms_mod[''value''][''111''] = ''{text}'';//Template\r\n // n+3 is on off button\r\n // n+4 Bearbeitungsrecht Gruppen\r\n // n+5 umschliessende Templates\r\n \r\n ?>\r\n\r\n\r\n <?PHP\r\n $mip_forms_tab_temp = $mip_forms_tab;\r\n \r\n $mip_forms_tab[''open''] = '''';\r\n $mip_forms_tab[''close''] = '''';\r\n $mip_forms_tab[''left''] = ''<!--%s-->%s'';\r\n $mip_forms_tab[''left_width''] = '''';\r\n $mip_forms_tab[''right''] = ''%s'';\r\n $mip_forms_tab[''full''] = ''%s%s'';\r\n $mip_forms_tab[''tab''] = ''%s''; \r\n\r\n\r\n ?>\r\n\r\n<style type="text/css">\r\n\r\n.cflex_MOD_VAR_element_tpl_table {\r\n width:100% !important;\r\n border:1px solid #dedede;\r\n padding:0 !important;\r\n margin-bottom:10px;\r\n}\r\n\r\n.cflex_MOD_VAR_element_tpl_col1 {\r\n width:20px;\r\n text-align:right;\r\n} \r\n\r\n.cflex_MOD_VAR_element_tpl_textarea {\r\n<?PHP \r\n\r\n$cflex_h1=100+$cms_mod[''value''][''999999''];\r\n$cflex_h2=150+$cms_mod[''value''][''999999''];\r\n$cflex_h3=200+$cms_mod[''value''][''999999''];\r\n\r\nif ($cms_mod[''value''][''0''] == ''all''){\r\n echo ''height:''.$cflex_h2.''px;width:98%;'';\r\n} else if ($cms_mod[''value''][''0''] == ''advanced'') {\r\n echo ''height:''.$cflex_h3.''px;width:99%;'';\r\n} else {\r\n echo ''height:''.$cflex_h1.''px;width:99%;'';\r\n}\r\n?>\r\n}\r\n.cflex_MOD_VAR_element_tpl_sub_table {\r\n width:100% !important;\r\n padding-right:10px;\r\n}\r\n\r\n.cflex_MOD_VAR_element_tpl_sub_col1 {\r\n text-align:left;\r\n float:left;\r\n<?PHP \r\nif ($cms_mod[''value''][''0''] == ''all'')\r\n echo ''width:500px;'';\r\nelse\r\n echo ''width:100%;'';\r\n?>\r\n}\r\n\r\n.cflex_MOD_VAR_element_tpl_sub_col2 {\r\n text-align:left;\r\n margin-top:10px;\r\n\r\n float:right;\r\n<?PHP \r\nif ($cms_mod[''value''][''0''] == ''all'')\r\n echo ''width:205px;'';\r\nelse\r\n echo ''display:none;padding:0;margin:0;width:1px;'';\r\n?>\r\n}\r\n.cflex_MOD_VAR_element_tpl_updownbox {\r\n width:40px;float:right;\r\n<?PHP \r\nif ($cms_mod[''value''][''0''] == ''all'')\r\n echo ''padding:2px;border:1px solid #dedede;'';\r\nelse\r\n echo ''display:none;'';\r\n?>\r\n}\r\n.hide {display:none;}\r\n\r\n</style>\r\n\r\n\r\n <?PHP\r\n\r\n\r\n \r\n // Konfiguration der einzelnen Spalten\r\n# for ($tmp_mod[''i''] = 1; $tmp_mod[''i''] <= $cms_mod[''value''][''106'']; $tmp_mod[''i'']++) { \r\n# \r\n# $y = round($tmp_mod[''i'']*10)+100;\r\n#\r\n# if ($tmp_mod[''i'']>$cms_mod[''value''][''100'']){\r\n# $cms_mod[''value''][$y+2]='''';\r\n# echo $y;\r\n# }\r\n# }\r\n\r\n for ($tmp_mod[''i''] = 1; $tmp_mod[''i''] <= $cms_mod[''value''][''100'']; $tmp_mod[''i'']++) {\r\n $y = round($tmp_mod[''i'']*10)+100;//ist name\r\n\r\n $tmp_mod[''row''][''1''] = $y+1;//ist tpl\r\n //make uniqe id -> $y+2\r\n# if(empty($cms_mod[''value''][$y+2])){\r\n if($tmp_mod[''i'']>$cms_mod[''value''][''101''] || empty($cms_mod[''value''][$y+2])){\r\n $cms_mod[''value''][$y+2] = $cms_mod[''value''][''106''];\r\n $cms_mod[''value''][''106'']++;\r\n }\r\n \r\n ?>\r\n \r\n \r\n \r\n<span id="table<?PHP echo $tmp_mod[''i'']; ?>">\r\n<table class="cflex_MOD_VAR_element_tpl_table" cellspacing="8">\r\n <tr>\r\n <td class="cflex_MOD_VAR_element_tpl_col1">\r\n <strong><?PHP echo $tmp_mod[''i'']; ?></strong>\r\n </td>\r\n <td class="cflex_MOD_VAR_element_tpl_col2" valign="top" nowrap>\r\n <input name="MOD_VAR[<?PHP echo $y+2; ?>]" type="hidden" value="<?PHP echo $cms_mod[''value''][$y+2];?>">\r\n <input name="MOD_VAR[<?PHP echo $y; ?>]" type="text" value="<?PHP echo $cms_mod[''value''][$y];?>" size="50" style="font-weight:bold;">&nbsp;\r\n <select name="MOD_VAR[<?PHP echo $y+3; ?>]" size="1">\r\n<?PHP \r\nif (empty($cms_mod[''value''][$y+3]))\r\n $cms_mod[''value''][$y+3]="active";\r\nif ($cms_mod[''value''][$y+3] == ''active''){ \r\n echo "<option value=\\"active\\" selected=\\"selected\\">aktiviert</option>"; \r\n echo "<option value=\\"inactive\\">deaktiviert</option>";\r\n\r\n} else{\r\n echo "<option value=\\"active\\">aktiviert</option>"; \r\n echo "<option value=\\"inactive\\" selected=\\"selected\\">deaktiviert</option>";\r\n\r\n} \r\n?> \r\n </select>\r\n </td>\r\n <td class="cflex_MOD_VAR_element_tpl_col3" style="width:45%;">\r\n\r\n\r\n<?PHP \r\nif($cms_mod[''value''][''0''] != '''') {\r\n echo ''<div style="padding:2px;width:100px;float:right;">'';\r\n\r\n if ($tmp_mod[''i'']>1)\r\n echo ''<input type="button" value="up" onclick="rotateentry_MOD_VAR(''.$y.'',\\''up\\'');" style="width:40px;font-weight:bold;font-size:10px;cursor:pointer;float:right;margin-left:5px;" />'';\r\n else\r\n echo ''<div style="width:40px;float:right;margin-left:5px;">&nbsp;</div>'';\r\n\r\n if ($tmp_mod[''i'']<$cms_mod[''value''][''100''])\r\n echo ''<input type="button" value="down" onclick="rotateentry_MOD_VAR(''.$y.'',\\''down\\'')" style="width:40px;font-weight:bold;font-size:10px;cursor:pointer;float:right;margin-left:5px;" />'';\r\n else\r\n echo ''<div style="width:40px;float:right;margin-left:5px;">&nbsp;</div>''; \r\n\r\n echo ''</div>'';\r\n\r\n echo '' \r\n <div id="copy_MOD_VAR_''.$y.''" style="padding:2px;width:185px;float:right;">\r\n <input type="button" value="insert" onclick="inserentry_MOD_VAR(''.$y.'',''.$cms_mod[''value''][''100''].'');" style="width:40px;font-weight:bold;font-size:10px;cursor:pointer;float:right;margin-left:5px;" />\r\n <input type="button" value="paste" onclick="pasteentry_MOD_VAR(''.$y.'')" style="width:40px;font-weight:bold;font-size:10px;cursor:pointer;float:right;margin-left:5px;" />\r\n <input type="button" value="copy" onclick="copyentry_MOD_VAR(''.$y.'',\\''copy_MOD_VAR_''.$y.''\\'')" style="width:40px;font-weight:bold;font-size:10px;cursor:pointer;float:right;margin-left:5px;" />\r\n <input type="button" value="cut" onclick="cutentry_MOD_VAR(''.$y.'',''.$cms_mod[''value''][''100''].'',\\''copy_MOD_VAR_''.$y.''\\'')" style="width:40px;font-weight:bold;font-size:10px;cursor:pointer;float:right;" />\r\n </div> \r\n '';\r\n}\r\n?>\r\n\r\n </td>\r\n </tr>\r\n <tr >\r\n <td class="cflex_MOD_VAR_element_tpl_col1">\r\n <?PHP if($cms_mod[''value''][''0''] != '''') { ?>\r\n <small style="display:block;color:#666">id<br/><?PHP echo $cms_mod[''value''][$y+2];?></small></td> \r\n <?PHP } ?> \r\n <td colspan="2" valign="bottom" style="clear:both;">\r\n\r\n <div class="cflex_MOD_VAR_element_tpl_sub_col1">\r\n<?PHP \r\necho ''<textarea wrap="off" name="MOD_VAR['' . $tmp_mod[''row''][''1''] . '']" class="cflex_MOD_VAR_element_tpl_textarea">'';\r\necho htmlentities($cms_mod[''value''][$tmp_mod[''row''][''1'']], ENT_COMPAT, ''UTF-8'');\r\necho ''</textarea>''."\\n"; \r\n\r\n?> \r\n \r\n<?PHP\r\n\r\nif ($cms_mod[''value''][''0''] == ''advanced'')\r\n echo ''<div style="text-align:right;padding-top:10px;"><small><strong>Umschliessendes Template&nbsp;&nbsp;</strong></small>''; \r\n$y_text= ''''.$y+5;\r\n//Umschliessendes Template\r\n$mip_form[$y_text][''desc''] = ''Umschliessendes Template: '';\r\n$mip_form[$y_text][''cat''] = ''option'';\r\n//$mip_form[$y_text][''output_cat''] = ''option'';\r\n$mip_form[$y_text][''cms_var''] = ''MOD_VAR[''.$y_text.'']'';\r\n$mip_form[$y_text][''cms_val''] = $cms_mod[''value''][$y_text];\r\n$mip_form[$y_text][''cms_val_default''] = '''';\r\n$mip_form[$y_text][''type''] = ''input'';\r\n$mip_form[$y_text][''option_desc''][] = ''kein umschliessendes Template'';\r\n$mip_form[$y_text][''option_val''][] = '''';\r\n$mip_form[$y_text][''option_desc''][] = ''Template 1'';\r\n$mip_form[$y_text][''option_val''][] = ''10'';\r\n$mip_form[$y_text][''option_desc''][] = ''erzwingt neues Template 1'';\r\n$mip_form[$y_text][''option_val''][] = ''11'';\r\n$mip_form[$y_text][''option_desc''][] = ''Template 2'';\r\n$mip_form[$y_text][''option_val''][] = ''20'';\r\n$mip_form[$y_text][''option_desc''][] = ''erzwingt neues Template 2'';\r\n$mip_form[$y_text][''option_val''][] = ''21'';\r\n$mip_form[$y_text][''option_desc''][] = ''Template 3'';\r\n$mip_form[$y_text][''option_val''][] = ''30'';\r\n$mip_form[$y_text][''option_desc''][] = ''erzwingt neues Template 3'';\r\n$mip_form[$y_text][''option_val''][] = ''31'';\r\n$mip_form[$y_text][''option_desc''][] = ''Template 4'';\r\n$mip_form[$y_text][''option_val''][] = ''40'';\r\n$mip_form[$y_text][''option_desc''][] = ''erzwingt neues Template 4'';\r\n$mip_form[$y_text][''option_val''][] = ''41'';\r\n$mip_form[$y_text][''option_desc''][] = ''Template 5'';\r\n$mip_form[$y_text][''option_val''][] = ''50'';\r\n$mip_form[$y_text][''option_desc''][] = ''erzwingt neues Template 5'';\r\n$mip_form[$y_text][''option_val''][] = ''51'';\r\n$mip_form[$y_text][''option_desc''][] = ''Template 6'';\r\n$mip_form[$y_text][''option_val''][] = ''60'';\r\n$mip_form[$y_text][''option_desc''][] = ''erzwingt neues Template 6'';\r\n$mip_form[$y_text][''option_val''][] = ''61'';\r\n\r\nif($cms_mod[''value''][''0''] == '''') \r\n $mip_form[$y_text][''cat''] = ''hidden'';\r\n \r\nif ($cms_mod[''value''][''0''] == ''advanced'') {\r\n echo '''';\r\n mip_formsp($mip_form[$y_text]); \r\n echo ''&nbsp;</div>''; \r\n }\r\n?>\r\n\r\n </div>\r\n <div class="cflex_MOD_VAR_element_tpl_sub_col2">\r\n\r\n<?PHP\r\nif($cms_mod[''value''][''0''] != '''' && $cms_mod[''value''][''0''] != ''advanced'') \r\n echo "<small><strong>Umschliessendes Template</strong></small><br />"; \r\nif ($cms_mod[''value''][''0''] != ''advanced'')\r\n mip_formsp($mip_form[$y_text]);\r\n?>\r\n\r\n<br />\r\n\r\n<?PHP \r\nif($cms_mod[''value''][''0''] != '''') \r\n echo "<small><br/><strong>Bearbeitungsrecht (Gruppen)</strong></small>"; \r\n?>\r\n\r\n<br />\r\n\r\n<?PHP\r\n$y_text= ''''.$y+4;\r\n//Bearbeitungsrecht Gruppen\r\n$mip_form[$y_text][''desc''] = ''Bearbeitungsrecht (Gruppen): '';\r\n$mip_form[$y_text][''cat''] = ''app_group'';\r\n$mip_form[$y_text][''output_cat''] = ''option'';\r\n$mip_form[$y_text][''cms_var''] = ''MOD_VAR[''.$y_text.'']'';\r\n$mip_form[$y_text][''cms_val''] = $cms_mod[''value''][$y_text];\r\n$mip_form[$y_text][''flag''] = ''multiple'';\r\n$mip_form[$y_text][''type''] = ''input'';\r\n$mip_form[$y_text][''size''] = ''5'';\r\n$mip_form[$y_text][''cms_val_default''] = ''true'';\r\n$mip_form[$y_text][''with_admin''] = ''true'';\r\n\r\nif($cms_mod[''value''][''0''] == '''') \r\n $mip_form[$y_text][''cat''] = ''hidden'';\r\n\r\nmip_formsp($mip_form[$y_text]);\r\n?>\r\n\r\n </div>\r\n </td>\r\n </tr>\r\n </table>\r\n</span>\r\n<?PHP\r\n }//end for\r\n $mip_forms_tab = $mip_forms_tab_temp;\r\n?>\r\n\r\n<!-- save unique id counter --> \r\n<input name="MOD_VAR[106]" type="hidden" value="<?PHP echo $cms_mod[''value''][''106''] ?>">\r\n<input name="MOD_VAR[102]" type="hidden" value="0">\r\n<script type="text/javascript">\r\n\r\n // array to memorize a set of form element values\r\n var val_mem_MOD_VAR=new Array();\r\n var val_mem_grp_MOD_VAR=new Array();\r\n // memorized flag\r\n var val_mem_saved_MOD_VAR=false;\r\n // current memorized entry (the id of the div-element to change the background color on copy)\r\n var centry_mem_MOD_VAR;\r\n // starting cmsmod-var id - depends on the module config\r\n var cmvid_MOD_VAR=110;\r\n // difference value betweend the cms_mod-var id''s from entry to entry\r\n var cmviddiff_MOD_VAR=10;\r\n // element counter per entry\r\n var ec_MOD_VAR=10;\r\n \r\n function copyentry_MOD_VAR(no,entry) {\r\n\r\n if (centry_mem_MOD_VAR==entry) {\r\n document.getElementById(centry_mem_MOD_VAR).style.backgroundColor="transparent";\r\n val_mem_MOD_VAR=new Array();\r\n val_mem_saved_MOD_VAR=false; \r\n centry_mem_MOD_VAR=null; \r\n return false;\r\n } \r\n\r\n if (centry_mem_MOD_VAR)\r\n document.getElementById(centry_mem_MOD_VAR).style.backgroundColor="transparent";\r\n \r\n document.getElementById(entry).style.backgroundColor="green";\r\n centry_mem_MOD_VAR=entry;\r\n\r\n val_mem_saved_MOD_VAR=true;\r\n \r\n for (i=0;i<ec_MOD_VAR;i++) {\r\n \r\n var no1=no+i;\r\n if (document.editform["MOD_VAR["+no1+"]"]){\r\n if (document.editform["MOD_VAR["+no1+"]"].type=="checkbox") {\r\n val_mem_MOD_VAR[i]=document.editform["MOD_VAR["+no1+"]"].checked;\r\n }\r\n if (document.editform["MOD_VAR["+no1+"]"].type=="text") {\r\n val_mem_MOD_VAR[i]=document.editform["MOD_VAR["+no1+"]"].value+" (Kopie)";\r\n }\r\n if (document.editform["MOD_VAR["+no1+"]"].type=="textarea") {\r\n val_mem_MOD_VAR[i]=document.editform["MOD_VAR["+no1+"]"].value;\r\n }\r\n if (document.editform["MOD_VAR["+no1+"]"].type=="select-one") {\r\n val_mem_MOD_VAR[i]=document.editform["MOD_VAR["+no1+"]"].selectedIndex;\r\n }\r\n }\r\n \r\n if (document.editform["MOD_VAR["+no1+"][]"]){\r\n val_mem_MOD_VAR[i]='''';\r\n var elm=document.editform["MOD_VAR["+no1+"][]"];\r\n val_mem_MOD_VAR[i]=''|'';\r\n for (n=0;n<elm.length;n++) {\r\n if (elm[n].selected)\r\n val_mem_MOD_VAR[i]+=n+"|";\r\n }\r\n }\r\n\r\n }\r\n }\r\n\r\n function pasteentry_MOD_VAR(no) {\r\n if (val_mem_saved_MOD_VAR==false)\r\n return false;\r\n\r\n if (centry_mem_MOD_VAR)\r\n document.getElementById(centry_mem_MOD_VAR).style.backgroundColor="transparent";\r\n\r\n for (i=0;i<ec_MOD_VAR;i++) {\r\n var no1=no+i;\r\n if (document.editform["MOD_VAR["+no1+"]"]){\r\n if (document.editform["MOD_VAR["+no1+"]"].type=="checkbox") {\r\n document.editform["MOD_VAR["+no1+"]"].checked=val_mem_MOD_VAR[i];\r\n }\r\n if (document.editform["MOD_VAR["+no1+"]"].type=="text" || document.editform["MOD_VAR["+no1+"]"].type=="textarea") {\r\n document.editform["MOD_VAR["+no1+"]"].value=val_mem_MOD_VAR[i];\r\n }\r\n if (document.editform["MOD_VAR["+no1+"]"].type=="select-one") {\r\n document.editform["MOD_VAR["+no1+"]"].selectedIndex=val_mem_MOD_VAR[i];\r\n }\r\n }\r\n \r\n if (document.editform["MOD_VAR["+no1+"][]"]){\r\n var elm=document.editform["MOD_VAR["+no1+"][]"];\r\n for (n=0;n<elm.length;n++) {\r\n elm[n].selected=false;\r\n if (val_mem_MOD_VAR[i].indexOf(''|''+n+''|'')!=-1)\r\n elm[n].selected=true;\r\n }\r\n }\r\n \r\n }\r\n val_mem_MOD_VAR=new Array();\r\n val_mem_saved_MOD_VAR=false;\r\n centry_mem_MOD_VAR=null;\r\n }\r\n \r\n function inserentry_MOD_VAR(no,entries) {\r\n\r\n if (document.editform["MOD_VAR["+(cmvid_MOD_VAR+3+(cmviddiff_MOD_VAR*(entries-1)))+"]"].selectedIndex==0) {\r\n check1 = confirm("Achtung! Das letzte Template is aktiv\\nund wird durch den Vorgang gel&#246;scht!");\r\n if (check1 == false)\r\n return; \r\n } \r\n \r\n if(Number(document.editform["MOD_VAR[102]"].value)<0){\r\n document.editform["MOD_VAR[102]"].value++;\r\n }\r\n \r\n var mem_last_tplid=document.editform["MOD_VAR["+(cmvid_MOD_VAR+2+(cmviddiff_MOD_VAR*(entries-1)))+"]"].value;\r\n\r\n for (j=1;j<entries-((no-cmvid_MOD_VAR)/cmviddiff_MOD_VAR);j++) {\r\n \r\n for (i=0;i<ec_MOD_VAR;i++) {\r\n var no2=(cmvid_MOD_VAR+(cmviddiff_MOD_VAR*(entries-j)))+i;\r\n var no1=(cmvid_MOD_VAR+(cmviddiff_MOD_VAR*(entries-j-1)))+i;\r\n\r\n if (document.editform["MOD_VAR["+no1+"]"]){\r\n\r\n if(document.editform["MOD_VAR["+no1+"]"].type=="checkbox") {\r\n document.editform["MOD_VAR["+no2+"]"].checked=document.editform["MOD_VAR["+no1+"]"].checked;\r\n }\r\n if(document.editform["MOD_VAR["+no1+"]"].type=="text" || document.editform["MOD_VAR["+no1+"]"].type=="textarea" || document.editform["MOD_VAR["+no1+"]"].type=="hidden") {\r\n document.editform["MOD_VAR["+no2+"]"].value=document.editform["MOD_VAR["+no1+"]"].value;\r\n }\r\n if(document.editform["MOD_VAR["+no1+"]"].type=="select-one") {\r\n document.editform["MOD_VAR["+no2+"]"].selectedIndex=document.editform["MOD_VAR["+no1+"]"].selectedIndex;\r\n }\r\n \r\n }\r\n\r\n if (document.editform["MOD_VAR["+no1+"][]"]){\r\n var elm1=document.editform["MOD_VAR["+no1+"][]"];\r\n var elm2=document.editform["MOD_VAR["+no2+"][]"];\r\n for (n=0;n<elm1.length;n++) {\r\n elm2[n].selected=elm1[n].selected;\r\n elm1[n].selected=false;\r\n }\r\n elm1[0].selected=true;\r\n }\r\n }\r\n \r\n }\r\n \r\n if (val_mem_saved_MOD_VAR==false) {\r\n for (i=no;i<no+ec_MOD_VAR;i++) {\r\n if (document.editform["MOD_VAR["+i+"]"]){\r\n \r\n if(document.editform["MOD_VAR["+i+"]"].type=="checkbox") {\r\n document.editform["MOD_VAR["+i+"]"].checked=false;\r\n }\r\n if(document.editform["MOD_VAR["+i+"]"].type=="textarea") {\r\n document.editform["MOD_VAR["+i+"]"].value=" ";\r\n }\r\n if(document.editform["MOD_VAR["+i+"]"].type=="text") {\r\n document.editform["MOD_VAR["+i+"]"].value="(ohne Bezeichnung)";\r\n }\r\n if(document.editform["MOD_VAR["+i+"]"].type=="hidden") {\r\n document.editform["MOD_VAR["+i+"]"].value=mem_last_tplid;\r\n }\r\n if(document.editform["MOD_VAR["+i+"]"].type=="select-one") {\r\n document.editform["MOD_VAR["+i+"]"].selectedIndex=null;\r\n }\r\n \r\n }\r\n }\r\n } else {\r\n if (centry_mem_MOD_VAR)\r\n document.getElementById(centry_mem_MOD_VAR).style.backgroundColor="transparent";\r\n for (i=0;i<ec_MOD_VAR;i++) {\r\n var no1=no+i;\r\n if (document.editform["MOD_VAR["+no1+"]"]){\r\n if (document.editform["MOD_VAR["+no1+"]"].type=="checkbox") {\r\n document.editform["MOD_VAR["+no1+"]"].checked=val_mem_MOD_VAR[i];\r\n }\r\n if (document.editform["MOD_VAR["+no1+"]"].type=="text" || document.editform["MOD_VAR["+no1+"]"].type=="textarea") {\r\n document.editform["MOD_VAR["+no1+"]"].value=val_mem_MOD_VAR[i];\r\n }\r\n if(document.editform["MOD_VAR["+no1+"]"].type=="hidden" && val_mem_MOD_VAR[i]) {\r\n document.editform["MOD_VAR["+no1+"]"].value=val_mem_MOD_VAR[i];\r\n }\r\n if(document.editform["MOD_VAR["+no1+"]"].type=="hidden" && !val_mem_MOD_VAR[i]) {\r\n document.editform["MOD_VAR["+no1+"]"].value=mem_last_tplid;\r\n }\r\n if (document.editform["MOD_VAR["+no1+"]"].type=="select-one") {\r\n document.editform["MOD_VAR["+no1+"]"].selectedIndex=val_mem_MOD_VAR[i];\r\n }\r\n }\r\n if (document.editform["MOD_VAR["+no1+"][]"]){\r\n var elm=document.editform["MOD_VAR["+no1+"][]"];\r\n for (n=0;n<elm.length;n++) {\r\n elm[n].selected=false;\r\n if (val_mem_MOD_VAR[i].indexOf(''|''+n+''|'')!=-1)\r\n elm[n].selected=true;\r\n }\r\n }\r\n }\r\n val_mem_MOD_VAR=new Array();\r\n val_mem_saved_MOD_VAR=false; \r\n centry_mem_MOD_VAR=null; \r\n }\r\n \r\n }\r\n \r\n function cutentry_MOD_VAR(no,entries,entry) {\r\n \r\n if (document.editform["MOD_VAR["+(no+3)+"]"].selectedIndex==0) {\r\n check1 = confirm("Achtung! Das Template is aktiv und wird gel&#246;scht!");\r\n if (check1 == false)\r\n return; \r\n } \r\n\r\n if (Number(document.editform["MOD_VAR[100]"].value)+Number(document.editform["MOD_VAR[102]"].value)>0){\r\n document.editform["MOD_VAR[102]"].value--;\r\n if (document.editform["MOD_VAR[102]"].value<-1) {\r\n var table=Number(document.editform["MOD_VAR[100]"].value)+(Number(document.editform["MOD_VAR[102]"].value)+2)\r\n //document.getElementById("table"+String(table)).style.display="none";\r\n //document.getElementById("table"+String(table)).style.backgroundColor="#000000";\r\n document.getElementById("table"+String(table)).innerHTML="";\r\n }\r\n }\r\n\r\n val_mem_saved_MOD_VAR=true;\r\n \r\n for (i=0;i<ec_MOD_VAR;i++) {\r\n var no1=no+i;\r\n if (document.editform["MOD_VAR["+no1+"]"]){\r\n if (document.editform["MOD_VAR["+no1+"]"].type=="checkbox") {\r\n val_mem_MOD_VAR[i]=document.editform["MOD_VAR["+no1+"]"].checked;\r\n }\r\n if (document.editform["MOD_VAR["+no1+"]"].type=="text" || document.editform["MOD_VAR["+no1+"]"].type=="textarea" || document.editform["MOD_VAR["+no1+"]"].type=="hidden") {\r\n val_mem_MOD_VAR[i]=document.editform["MOD_VAR["+no1+"]"].value;\r\n }\r\n if (document.editform["MOD_VAR["+no1+"]"].type=="select-one") {\r\n val_mem_MOD_VAR[i]=document.editform["MOD_VAR["+no1+"]"].selectedIndex;\r\n }\r\n }\r\n\r\n if (document.editform["MOD_VAR["+no1+"][]"]){\r\n val_mem_MOD_VAR[i]='''';\r\n var elm=document.editform["MOD_VAR["+no1+"][]"];\r\n val_mem_MOD_VAR[i]=''|'';\r\n for (n=0;n<elm.length;n++) {\r\n if (elm[n].selected)\r\n val_mem_MOD_VAR[i]+=n+"|";\r\n }\r\n }\r\n \r\n } \r\n \r\n \r\n \r\n for (j=((no-cmvid_MOD_VAR)/cmviddiff_MOD_VAR);j<entries;j++) {\r\n \r\n for (i=0;i<ec_MOD_VAR;i++) {\r\n var no2=(cmvid_MOD_VAR+(cmviddiff_MOD_VAR*(j+1)))+i;\r\n var no1=(cmvid_MOD_VAR+(cmviddiff_MOD_VAR*(j)))+i;\r\n\r\n if (document.editform["MOD_VAR["+no2+"]"]){\r\n if(document.editform["MOD_VAR["+no2+"]"].type=="checkbox") {\r\n document.editform["MOD_VAR["+no1+"]"].checked=document.editform["MOD_VAR["+no2+"]"].checked;\r\n }\r\n if(document.editform["MOD_VAR["+no2+"]"].type=="text" || document.editform["MOD_VAR["+no2+"]"].type=="textarea" || document.editform["MOD_VAR["+no2+"]"].type=="hidden") {\r\n document.editform["MOD_VAR["+no1+"]"].value=document.editform["MOD_VAR["+no2+"]"].value;\r\n }\r\n if(document.editform["MOD_VAR["+no2+"]"].type=="select-one") {\r\n document.editform["MOD_VAR["+no1+"]"].selectedIndex=document.editform["MOD_VAR["+no2+"]"].selectedIndex;\r\n }\r\n }\r\n \r\n if (document.editform["MOD_VAR["+no1+"][]"]){\r\n var elm1=document.editform["MOD_VAR["+no1+"][]"];\r\n var elm2=document.editform["MOD_VAR["+no2+"][]"];\r\n for (n=0;n<elm1.length;n++) {\r\n elm2[n].selected=elm1[n].selected;\r\n elm1[n].selected=false;\r\n }\r\n elm1[0].selected=true;\r\n } \r\n \r\n }\r\n }\r\n \r\n for (i=(cmvid_MOD_VAR+((entries-1)*cmviddiff_MOD_VAR));i<(cmvid_MOD_VAR+((entries-1)*cmviddiff_MOD_VAR))+ec_MOD_VAR;i++) {\r\n if (document.editform["MOD_VAR["+i+"]"]){\r\n if(document.editform["MOD_VAR["+i+"]"].type=="checkbox") {\r\n document.editform["MOD_VAR["+i+"]"].checked=false;\r\n }\r\n if(document.editform["MOD_VAR["+i+"]"].type=="text" || document.editform["MOD_VAR["+i+"]"].type=="textarea" || document.editform["MOD_VAR["+i+"]"].type=="hidden") {\r\n document.editform["MOD_VAR["+i+"]"].value="";\r\n }\r\n if(document.editform["MOD_VAR["+i+"]"].type=="select-one") {\r\n document.editform["MOD_VAR["+i+"]"].selectedIndex=1;\r\n }\r\n }\r\n } \r\n } \r\n\r\n\r\n function rotateentry_MOD_VAR(no,direction) {\r\n for (i=0;i<ec_MOD_VAR;i++) {\r\n if (direction=="up") {\r\n var no1=no+i;\r\n var no2=no-cmviddiff_MOD_VAR+i;\r\n } \r\n if (direction=="down") {\r\n var no1=no+i;\r\n var no2=cmviddiff_MOD_VAR+no+i;\r\n } \r\n \r\n \r\n if (document.editform["MOD_VAR["+no1+"]"]){\r\n if (document.editform["MOD_VAR["+no1+"]"].type=="checkbox") {\r\n var val_mem1=document.editform["MOD_VAR["+no1+"]"].checked;\r\n var val_mem2=document.editform["MOD_VAR["+no2+"]"].checked;\r\n document.editform["MOD_VAR["+no1+"]"].checked=val_mem2;\r\n document.editform["MOD_VAR["+no2+"]"].checked=val_mem1;\r\n }\r\n if (document.editform["MOD_VAR["+no1+"]"].type=="text" || document.editform["MOD_VAR["+no1+"]"].type=="textarea" || document.editform["MOD_VAR["+no1+"]"].type=="hidden") {\r\n var val_mem1=document.editform["MOD_VAR["+no1+"]"].value;\r\n var val_mem2=document.editform["MOD_VAR["+no2+"]"].value;\r\n document.editform["MOD_VAR["+no1+"]"].value=val_mem2;\r\n document.editform["MOD_VAR["+no2+"]"].value=val_mem1;\r\n }\r\n if (document.editform["MOD_VAR["+no1+"]"].type=="select-one") {\r\n var val_mem1=document.editform["MOD_VAR["+no1+"]"].selectedIndex;\r\n var val_mem2=document.editform["MOD_VAR["+no2+"]"].selectedIndex;\r\n document.editform["MOD_VAR["+no1+"]"].selectedIndex=val_mem2\r\n document.editform["MOD_VAR["+no2+"]"].selectedIndex=val_mem1;\r\n }\r\n }\r\n if (document.editform["MOD_VAR["+no1+"][]"]){\r\n var val_mem1=document.editform["MOD_VAR["+no1+"][]"];\r\n var val_mem2=document.editform["MOD_VAR["+no2+"][]"];\r\n for (n=0;n<val_mem1.length;n++) {\r\n var state_mem1=val_mem1[n].selected;\r\n var state_mem2=val_mem2[n].selected;\r\n val_mem1[n].selected = state_mem2;\r\n val_mem2[n].selected = state_mem1;\r\n }\r\n }\r\n\r\n }\r\n }\r\n\r\n\r\n\r\n function set_wysiwyg_base_feat_MOD_VAR(element){\r\n \r\n check1 = confirm("Achtung! Dieser Vorgang kann nicht r&#252;ckg&#228;ngig gemacht werden!");\r\n if (check1 == false)\r\n return;\r\n \r\n check2 = confirm("Sollen bereits ausgew&#228;hlte Schaltfl&#228;chen erhalten bleiben?");\r\n \r\n if (check2 == false) {\r\n for (i=0;i<document.editform[element].options.length;i++) \r\n document.editform[element].options[i].selected=false;\r\n }\r\n \r\n var base_feat=new Array(7,8,9,10,11,13,15,16,17,18,19,20,26,32,33);\r\n \r\n for (i=0;i<base_feat.length;i++)\r\n document.editform[element].options[base_feat[i]].selected=true;\r\n \r\n }\r\n\r\n </script>\r\n\r\n\r\n\r\n\r\n<table border="0" width="100%">\r\n <tr>\r\n <td align="right">\r\n <select name="MOD_VAR[109]" size="1" onchange="document.editform.action.value=''change'';if(document.editform.anchor){document.editform.anchor.value=''<?PHP echo $_container_name ?>''};document.editform.submit();">\r\n <option value="0" selected>Template hinzuf&#252;gen / entfernen</option>\r\n<?PHP if ($cms_mod[''value''][''100''] >= 6) echo '' <option value="-5">-5</option>''; ?>\r\n<?PHP if ($cms_mod[''value''][''100''] >= 5) echo '' <option value="-4">-4</option>''; ?>\r\n<?PHP if ($cms_mod[''value''][''100''] >= 4) echo '' <option value="-3">-3</option>''; ?>\r\n<?PHP if ($cms_mod[''value''][''100''] >= 3) echo '' <option value="-2">-2</option>''; ?>\r\n<?PHP if ($cms_mod[''value''][''100''] >= 2) echo '' <option value="-1">-1</option>''; ?>\r\n<?PHP \r\nif ($cms_mod[''value''][''100''] <= 60){\r\n echo '' <option value="1">+1</option>'';\r\n echo '' <option value="2">+2</option>'';\r\n echo '' <option value="3">+3</option>'';\r\n echo '' <option value="4">+4</option>'';\r\n echo '' <option value="5">+5</option>'';\r\n}\r\n?>\r\n </select>\r\n </td>\r\n </tr>\r\n</table>\r\n\r\n\r\n<?PHP\r\n\r\nmip_forms_tabitem_endp();\r\n\r\n\r\nif($cms_mod[''value''][''0''] == ''advanced'' || $cms_mod[''value''][''0''] == ''all'')\r\n mip_forms_tabitem_beginp(''Umschl. Templates'');\r\n\r\n#mip_formsp($mip_form[''65'']); // Beschreibungen umschliessendes Template\r\nmip_formsp($mip_form[''61'']); // umschliessendes Template 1 Start\r\nmip_formsp($mip_form[''62'']); // umschliessendes Template 1 Ende\r\nmip_formsp($mip_form[''63'']); // umschliessendes Template 2 Start\r\nmip_formsp($mip_form[''64'']); // umschliessendes Template 2 Ende\r\nmip_formsp($mip_form[''66'']); // umschliessendes Template 3 Start\r\nmip_formsp($mip_form[''67'']); // umschliessendes Template 3 Ende\r\nmip_formsp($mip_form[''68'']); // umschliessendes Template 4 Start\r\nmip_formsp($mip_form[''69'']); // umschliessendes Template 4 Ende\r\nmip_formsp($mip_form[''6066'']); // umschliessendes Template 5 Start\r\nmip_formsp($mip_form[''6067'']); // umschliessendes Template 5 Ende\r\nmip_formsp($mip_form[''6068'']); // umschliessendes Template 6 Start\r\nmip_formsp($mip_form[''6069'']); // umschliessendes Template 6 Ende\r\n\r\nif($cms_mod[''value''][''0''] == ''advanced'' || $cms_mod[''value''][''0''] == ''all'')\r\n mip_forms_tabitem_endp();\r\n\r\n\r\nif($cms_mod[''value''][''0''] == ''advanced'' || $cms_mod[''value''][''0''] == ''all'')\r\n mip_forms_tabitem_beginp(''Bezeichner'');\r\n\r\n// -------------------------\r\n\r\n#mip_formsp($mip_form[''81'']); // Beschreibung Titel\r\nmip_formsp($mip_form[''20'']); // Titel fuer {text:1}\r\nmip_formsp($mip_form[''30'']); // Titel fuer {text:2}\r\nmip_formsp($mip_form[''40'']); // Titel fuer {text:3}\r\nmip_formsp($mip_form[''47'']); // Titel fuer {text:4}\r\nmip_formsp($mip_form[''48'']); // Titel fuer {text:5}\r\nmip_formsp($mip_form[''87'']); // Titel fuer {text:6}\r\nmip_formsp($mip_form[''88'']); // Titel fuer {text:7}\r\nmip_formsp($mip_form[''89'']); // Titel fuer {text:8}\r\nmip_formsp($mip_form[''90'']); // Titel fuer {text:9}\r\nmip_formsp($mip_form[''6090'']); // Titel fuer {text:9}\r\n\r\nmip_formsp($mip_form[''9999'']); //br standard\r\n\r\nmip_formsp($mip_form[''21'']); // Titel fuer {textarea:1}\r\nmip_formsp($mip_form[''49'']); //BBCode fuer {textarea:1}\r\nmip_formsp($mip_form[''31'']); // Titel fuer {textarea:2}\r\nmip_formsp($mip_form[''50'']); //BBCode fuer {textarea:2}\r\nmip_formsp($mip_form[''41'']); // Titel fuer {textarea:3}\r\nmip_formsp($mip_form[''51'']); //BBCode fuer {textarea:3}\r\nmip_formsp($mip_form[''91'']); // Titel fuer {textarea:4}\r\nmip_formsp($mip_form[''92'']); // Titel fuer {textarea:5}\r\nmip_formsp($mip_form[''93'']); // Titel fuer {textarea:6}\r\nmip_formsp($mip_form[''7093'']); // Titel fuer {textarea:6}\r\nmip_formsp($mip_form[''7094'']); // Titel fuer {textarea:6}\r\nmip_formsp($mip_form[''7095'']); // Titel fuer {textarea:6}\r\nmip_formsp($mip_form[''7096'']); // Titel fuer {textarea:6}\r\n\r\nmip_formsp($mip_form[''9999'']); //br standard\r\n\r\nmip_formsp($mip_form[''22'']); // Titel fuer {wysiwyg:1}\r\nmip_formsp($mip_form[''32'']); // Titel fuer {wysiwyg:2}\r\nmip_formsp($mip_form[''42'']); // Titel fuer {wysiwyg:3}\r\nmip_formsp($mip_form[''342'']); // Titel fuer {wysiwyg:3}\r\nmip_formsp($mip_form[''343'']); // Titel fuer {wysiwyg:3}\r\nmip_formsp($mip_form[''23'']); // Titel fuer {wysiwyg2:1}\r\nmip_formsp($mip_form[''33'']); // Titel fuer {wysiwyg2:2}\r\nmip_formsp($mip_form[''43'']); // Titel fuer {wysiwyg2:3}\r\nmip_formsp($mip_form[''443'']); // Titel fuer {wysiwyg2:3}\r\nmip_formsp($mip_form[''444'']); // Titel fuer {wysiwyg2:3}\r\n\r\nmip_formsp($mip_form[''9999'']); //br standard\r\n\r\nmip_formsp($mip_form[''24'']); // Titel fuer {image:1}\r\nmip_formsp($mip_form[''34'']); // Titel fuer {image:2}\r\nmip_formsp($mip_form[''44'']); // Titel fuer {image:3}\r\nmip_formsp($mip_form[''1044'']); // Titel fuer {image:3}\r\nmip_formsp($mip_form[''1045'']); // Titel fuer {image:3}\r\nmip_formsp($mip_form[''1046'']); // Titel fuer {image:3}\r\nmip_formsp($mip_form[''1047'']); // Titel fuer {image:3}\r\nmip_formsp($mip_form[''1048'']); // Titel fuer {image:3}\r\nmip_formsp($mip_form[''1049'']); // Titel fuer {image:3}\r\nmip_formsp($mip_form[''1050'']); // Titel fuer {image:3}\r\n\r\nmip_formsp($mip_form[''9999'']); //br standard\r\n\r\nmip_formsp($mip_form[''26'']); // Titel fuer {link:1}\r\nmip_formsp($mip_form[''36'']); // Titel fuer {link:2}\r\nmip_formsp($mip_form[''46'']); // Titel fuer {link:3}\r\nmip_formsp($mip_form[''8046'']); // Titel fuer {link:3}\r\nmip_formsp($mip_form[''8047'']); // Titel fuer {link:3}\r\nmip_formsp($mip_form[''8048'']); // Titel fuer {link:3}\r\nmip_formsp($mip_form[''8049'']); // Titel fuer {link:3}\r\nmip_formsp($mip_form[''8050'']); // Titel fuer {link:3}\r\nmip_formsp($mip_form[''8051'']); // Titel fuer {link:3}\r\nmip_formsp($mip_form[''8052'']); // Titel fuer {link:3}\r\n\r\nmip_formsp($mip_form[''9999'']); //br standard\r\n\r\nmip_formsp($mip_form[''25'']); // Titel fuer {file:2}\r\nmip_formsp($mip_form[''35'']); // Titel fuer {file:3}\r\nmip_formsp($mip_form[''45'']); // Titel fuer {file:3}\r\nmip_formsp($mip_form[''5045'']); // Titel fuer {file:3}\r\nmip_formsp($mip_form[''5046'']); // Titel fuer {file:3}\r\nmip_formsp($mip_form[''5047'']); // Titel fuer {file:3}\r\nmip_formsp($mip_form[''5048'']); // Titel fuer {file:3}\r\nmip_formsp($mip_form[''5049'']); // Titel fuer {file:3}\r\nmip_formsp($mip_form[''5050'']); // Titel fuer {file:3}\r\nmip_formsp($mip_form[''5051'']); // Titel fuer {file:3}\r\n\r\nmip_formsp($mip_form[''9999'']); //br standard\r\n\r\nmip_formsp($mip_form[''37'']); // Titel fuer {date:1}\r\nmip_formsp($mip_form[''85'']); // Titel fuer {date:1}\r\nmip_formsp($mip_form[''86'']); // Titel fuer {date:1}\r\nmip_formsp($mip_form[''886'']); // Titel fuer {date:1}\r\nmip_formsp($mip_form[''887'']); // Titel fuer {date:1}\r\n\r\nmip_formsp($mip_form[''9999'']); //br standard\r\n\r\nmip_formsp($mip_form[''29'']); // Titel fuer {select:1}\r\nmip_formsp($mip_form[''3029'']); // Titel fuer {select:2}\r\nmip_formsp($mip_form[''3129'']); // Titel fuer {select:3}\r\nmip_formsp($mip_form[''3229'']); // Titel fuer {select:4}\r\nmip_formsp($mip_form[''3329'']); // Titel fuer {select:5}\r\nmip_formsp($mip_form[''3429'']); // Titel fuer {select:6}\r\nmip_formsp($mip_form[''3529'']); // Titel fuer {select:6}\r\nmip_formsp($mip_form[''3629'']); // Titel fuer {select:6}\r\nmip_formsp($mip_form[''3729'']); // Titel fuer {select:6}\r\nmip_formsp($mip_form[''3829'']); // Titel fuer {select:6}\r\n\r\nmip_formsp($mip_form[''9999'']); //br standard\r\n\r\nmip_formsp($mip_form[''52'']); // Titel fuer {sourcecode:1}\r\n\r\nmip_formsp($mip_form[''9999'']); //br standard\r\n\r\n// table\r\nif ($cms_mod[''value''][''100400'']!=''false'')\r\n mip_formsp($mip_form[''100100'']); // table caption\r\n\r\nif ($cms_mod[''value''][''100401'']!=''false'')\r\n mip_formsp($mip_form[''100101'']); // table head\r\n\r\nmip_formsp($mip_form[''100102'']); // table data\r\n\r\nif ($cms_mod[''value''][''100402'']!=''false'')\r\n mip_formsp($mip_form[''100103'']);\r\n \r\nmip_formsp($mip_form[''9999'']); //br standard\r\n\r\nmip_formsp($mip_form[''4090'']);\r\nmip_formsp($mip_form[''4190'']);\r\n\r\nmip_formsp($mip_form[''9999'']); //br standard\r\n// filelist\r\nmip_formsp($mip_form[''2000'']); // \r\nmip_formsp($mip_form[''2001'']); // \r\n//mip_formsp($mip_form[''38'']); // Titel fuer {radio:1}\r\n//mip_formsp($mip_form[''39'']); // Titel fuer {checkbox:1}\r\n\r\nif($cms_mod[''value''][''0''] == ''advanced'' || $cms_mod[''value''][''0''] == ''all'')\r\n mip_forms_tabitem_endp();\r\n\r\n\r\n\r\nif($cms_mod[''value''][''0''] == ''all'' || $cms_mod[''value''][''0''] == ''advanced'')\r\n mip_forms_tabitem_beginp(''Diverse Elemente'');\r\n\r\n\r\n\r\n\r\n\r\n#mip_formsp($mip_form[''82'']); // Beschreibung Einschraenkungen\r\n//bild und wysiwyg2\r\nprintsfconf(''<strong>{image:x} <small>{wysiwyg2:x}</small></strong><br/><br/>'',\r\n ''all advanced'');\r\n \r\nmip_formsp($mip_form[''16'']);//Ordner\r\nmip_formsp($mip_form[''17'']);//Unterordner anzeigen\r\nmip_formsp($mip_form[''15'']);//Dateitypen\r\n\r\nmip_formsp($mip_form[''520'']);//dimension template\r\n\r\nmip_formsp($mip_form[''9998'']); //hr advanced\r\n\r\nprintsfconf(''<strong>{file:x} <small>{wysiwyg2:x}</small></strong><br/><br/>'',\r\n ''all advanced'');\r\n \r\nmip_formsp($mip_form[''18'']);//ordner dateilinks\r\nmip_formsp($mip_form[''19'']);//subfolder\r\nmip_formsp($mip_form[''6'']);//dateitypen\r\n\r\nmip_formsp($mip_form[''9999'']); //br advanced\r\n\r\nmip_formsp($mip_form[''9997'']); //br advanced\r\nprintsfconf(''<strong>{file:x} {filelist}</strong><br/><br/>'',\r\n ''all'');\r\nmip_formsp($mip_form[''27'']);//Target verstecken\r\nmip_formsp($mip_form[''2020'']); //\r\nmip_formsp($mip_form[''9997'']); //br advanced\r\n\r\n\r\nprintsfconf(''<strong>{filesize:x} {imagesize:x}</strong><br/><br/>'',\r\n ''all'');\r\n\r\nmip_formsp($mip_form[''500'']);//byte string\r\nmip_formsp($mip_form[''501'']);//kbyte string\r\nmip_formsp($mip_form[''502'']);//mbyte string\r\nmip_formsp($mip_form[''510'']);//dezi\r\n\r\n\r\nmip_formsp($mip_form[''9998'']); //hr advanced\r\n\r\nprintsfconf(''<strong>{wysiwyg2:x}</strong><br/><br/>'',\r\n ''all advanced'');\r\n \r\n// wysiwyg2\r\nmip_formsp($mip_form[''329'']);//features\r\nmip_formsp($mip_form[''3'']);//features\r\nprintsfconf(''<table class="mipformtable"><tr><td class="firsttab" style="width: 450px;">\r\n &nbsp;\r\n </td><td class="secondtab">\r\n <input type="button" value="Basis-Schaltfl&#228;chen ausw&#228;hlen" onclick="set_wysiwyg_base_feat_MOD_VAR(\\''MOD_VAR[3][]\\'');"/>\r\n </td></tr></table>'',\r\n ''all advanced'');\r\n\r\n \r\nif($cms_mod[''value''][''329''] == ''true'') {\r\n\r\n mip_formsp($mip_form[''330'']);//features\r\n printsfconf(''<table class="mipformtable"><tr><td class="firsttab" style="width: 450px;">\r\n &nbsp;\r\n </td><td class="secondtab">\r\n <input type="button" value="Basis-Schaltfl&#228;chen ausw&#228;hlen" onclick="set_wysiwyg_base_feat_MOD_VAR(\\''MOD_VAR[330][]\\'');"/>\r\n </td></tr></table>'',\r\n ''all advanced'');\r\n \r\n mip_formsp($mip_form[''331'']);//features\r\n printsfconf(''<table class="mipformtable"><tr><td class="firsttab" style="width: 450px;">\r\n &nbsp;\r\n </td><td class="secondtab">\r\n <input type="button" value="Basis-Schaltfl&#228;chen ausw&#228;hlen" onclick="set_wysiwyg_base_feat_MOD_VAR(\\''MOD_VAR[331][]\\'');"/>\r\n </td></tr></table>'',\r\n ''all advanced'');\r\n\r\n \r\n mip_formsp($mip_form[''332'']);//features\r\n printsfconf(''<table class="mipformtable"><tr><td class="firsttab" style="width: 450px;">\r\n &nbsp;\r\n </td><td class="secondtab">\r\n <input type="button" value="Basis-Schaltfl&#228;chen ausw&#228;hlen" onclick="set_wysiwyg_base_feat_MOD_VAR(\\''MOD_VAR[332][]\\'');"/>\r\n </td></tr></table>'',\r\n ''all advanced'');\r\n\r\n \r\n mip_formsp($mip_form[''333'']);//features\r\n printsfconf(''<table class="mipformtable"><tr><td class="firsttab" style="width: 450px;">\r\n &nbsp;\r\n </td><td class="secondtab">\r\n <input type="button" value="Basis-Schaltfl&#228;chen ausw&#228;hlen" onclick="set_wysiwyg_base_feat_MOD_VAR(\\''MOD_VAR[333][]\\'');"/>\r\n </td></tr></table>'',\r\n ''all advanced'');\r\n\r\n} else {\r\n mip_formsp($mip_form[''330'']);//features\r\n mip_formsp($mip_form[''331'']);//features\r\n mip_formsp($mip_form[''332'']);//features\r\n mip_formsp($mip_form[''333'']);//features\r\n}\r\n\r\nmip_formsp($mip_form[''4'']);//auswaehlbare styles\r\nmip_formsp($mip_form[''28'']);// styleclass {wysiwyg2:x}\r\nmip_formsp($mip_form[''9998'']); //hr advanced\r\n\r\n// Select\r\n\r\nprintsfconf(''<strong>{select:x}</strong><br/><br/>'',\r\n ''all advanced'');\r\n\r\nmip_formsp($mip_form[''94'']);\r\nmip_formsp($mip_form[''74'']); //element Name {select:x}\r\nmip_formsp($mip_form[''75'']); //element Value {select:x}\r\nmip_formsp($mip_form[''76'']); //Separator {select:x}\r\nmip_formsp($mip_form[''77'']); //Default Einstellun {select:x}\r\nmip_formsp($mip_form[''78'']); //Mehrfachauswahl {select:x}\r\nmip_formsp($mip_form[''79'']); //gr&#246;sse des Auswahlfeldes {select:x}\r\nmip_formsp($mip_form[''9999'']); //br advanced\r\nmip_formsp($mip_form[''3094'']);\r\nmip_formsp($mip_form[''3074'']); //element Name {select:x}\r\nmip_formsp($mip_form[''3075'']); //element Value {select:x}\r\nmip_formsp($mip_form[''3076'']); //Separator {select:x}\r\nmip_formsp($mip_form[''3077'']); //Default Einstellun {select:x}\r\nmip_formsp($mip_form[''3078'']); //Mehrfachauswahl {select:x}\r\nmip_formsp($mip_form[''3079'']); //gr&#246;sse des Auswahlfeldes {select:x}\r\nmip_formsp($mip_form[''9999'']); //br advanced\r\nmip_formsp($mip_form[''3194'']);\r\nmip_formsp($mip_form[''3174'']); //element Name {select:x}\r\nmip_formsp($mip_form[''3175'']); //element Value {select:x}\r\nmip_formsp($mip_form[''3176'']); //Separator {select:x}\r\nmip_formsp($mip_form[''3177'']); //Default Einstellun {select:x}\r\nmip_formsp($mip_form[''3178'']); //Mehrfachauswahl {select:x}\r\nmip_formsp($mip_form[''3179'']); //gr&#246;sse des Auswahlfeldes {select:x}\r\nmip_formsp($mip_form[''9999'']); //br advanced\r\nmip_formsp($mip_form[''3294'']);\r\nmip_formsp($mip_form[''3274'']); //element Name {select:x}\r\nmip_formsp($mip_form[''3275'']); //element Value {select:x}\r\nmip_formsp($mip_form[''3276'']); //Separator {select:x}\r\nmip_formsp($mip_form[''3277'']); //Default Einstellun {select:x}\r\nmip_formsp($mip_form[''3278'']); //Mehrfachauswahl {select:x}\r\nmip_formsp($mip_form[''3279'']); //gr&#246;sse des Auswahlfeldes {select:x}\r\nmip_formsp($mip_form[''9999'']); //br advanced\r\nmip_formsp($mip_form[''3394'']);\r\nmip_formsp($mip_form[''3374'']); //element Name {select:x}\r\nmip_formsp($mip_form[''3375'']); //element Value {select:x}\r\nmip_formsp($mip_form[''3376'']); //Separator {select:x}\r\nmip_formsp($mip_form[''3377'']); //Default Einstellun {select:x}\r\nmip_formsp($mip_form[''3378'']); //Mehrfachauswahl {select:x}\r\nmip_formsp($mip_form[''3379'']); //gr&#246;sse des Auswahlfeldes {select:x}\r\nmip_formsp($mip_form[''9999'']); //br advanced\r\nmip_formsp($mip_form[''3494'']);\r\nmip_formsp($mip_form[''3474'']); //element Name {select:x}\r\nmip_formsp($mip_form[''3475'']); //element Value {select:x}\r\nmip_formsp($mip_form[''3476'']); //Separator {select:x}\r\nmip_formsp($mip_form[''3477'']); //Default Einstellun {select:x}\r\nmip_formsp($mip_form[''3478'']); //Mehrfachauswahl {select:x}\r\nmip_formsp($mip_form[''3479'']); //gr&#246;sse des Auswahlfeldes {select:x}\r\nmip_formsp($mip_form[''9999'']); //br advanced\r\nmip_formsp($mip_form[''3594'']);\r\nmip_formsp($mip_form[''3574'']); //element Name {select:x}\r\nmip_formsp($mip_form[''3575'']); //element Value {select:x}\r\nmip_formsp($mip_form[''3576'']); //Separator {select:x}\r\nmip_formsp($mip_form[''3577'']); //Default Einstellun {select:x}\r\nmip_formsp($mip_form[''3578'']); //Mehrfachauswahl {select:x}\r\nmip_formsp($mip_form[''3579'']); //gr&#246;sse des Auswahlfeldes {select:x}\r\nmip_formsp($mip_form[''9999'']); //br advanced\r\nmip_formsp($mip_form[''3694'']);\r\nmip_formsp($mip_form[''3674'']); //element Name {select:x}\r\nmip_formsp($mip_form[''3675'']); //element Value {select:x}\r\nmip_formsp($mip_form[''3676'']); //Separator {select:x}\r\nmip_formsp($mip_form[''3677'']); //Default Einstellun {select:x}\r\nmip_formsp($mip_form[''3678'']); //Mehrfachauswahl {select:x}\r\nmip_formsp($mip_form[''3679'']); //gr&#246;sse des Auswahlfeldes {select:x}\r\nmip_formsp($mip_form[''9999'']); //br advanced\r\nmip_formsp($mip_form[''3794'']);\r\nmip_formsp($mip_form[''3774'']); //element Name {select:x}\r\nmip_formsp($mip_form[''3775'']); //element Value {select:x}\r\nmip_formsp($mip_form[''3776'']); //Separator {select:x}\r\nmip_formsp($mip_form[''3777'']); //Default Einstellun {select:x}\r\nmip_formsp($mip_form[''3778'']); //Mehrfachauswahl {select:x}\r\nmip_formsp($mip_form[''3779'']); //gr&#246;sse des Auswahlfeldes {select:x}\r\nmip_formsp($mip_form[''9999'']); //br advanced\r\nmip_formsp($mip_form[''3894'']);\r\nmip_formsp($mip_form[''3874'']); //element Name {select:x}\r\nmip_formsp($mip_form[''3875'']); //element Value {select:x}\r\nmip_formsp($mip_form[''3876'']); //Separator {select:x}\r\nmip_formsp($mip_form[''3877'']); //Default Einstellun {select:x}\r\nmip_formsp($mip_form[''3878'']); //Mehrfachauswahl {select:x}\r\nmip_formsp($mip_form[''3879'']); //gr&#246;sse des Auswahlfeldes {select:x}\r\n\r\n\r\n\r\nmip_formsp($mip_form[''9998'']); //hr advanced\r\n\r\n\r\nprintsfconf(''<strong>{date:x}</strong><br/><br/>'',\r\n ''all advanced'');\r\n// Datum\r\nmip_formsp($mip_form[''53'']); // Anzeigeart des Datums\r\nmip_formsp($mip_form[''54'']); // Eingabeart des Datums\r\nmip_formsp($mip_form[''71'']); // Anzeigeart des Datums\r\nmip_formsp($mip_form[''72'']); // Eingabeart des Datums\r\nmip_formsp($mip_form[''73'']); // Anzeigeart des Datums\r\nmip_formsp($mip_form[''84'']); // Eingabeart des Datums\r\nmip_formsp($mip_form[''873'']); // Anzeigeart des Datums\r\nmip_formsp($mip_form[''884'']); // Eingabeart des Datums\r\nmip_formsp($mip_form[''874'']); // Anzeigeart des Datums\r\nmip_formsp($mip_form[''885'']); // Eingabeart des Datums\r\n\r\nmip_formsp($mip_form[''9998'']); //hr advanced\r\n\r\n\r\n\r\nprintsfconf(''<strong>{uni:x} {font1-2}</strong><br/><br/>'',\r\n ''all advanced'');\r\nmip_formsp($mip_form[''6000'']);\r\nmip_formsp($mip_form[''6001'']);\r\nmip_formsp($mip_form[''6002'']);\r\nmip_formsp($mip_form[''6003'']);\r\nmip_formsp($mip_form[''6004'']);\r\nmip_formsp($mip_form[''6005'']);\r\nmip_formsp($mip_form[''1'']); // Style Beschreibung {font1}\r\nmip_formsp($mip_form[''2'']); // Style Beschreibung {font2}\r\nmip_formsp($mip_form[''9997'']); //hr advanced\r\n\r\nprintsfconf(''<strong>{popup}</strong><br/><br/>'',\r\n ''all'');\r\nmip_formsp($mip_form[''10000'']); // Popup\r\nmip_formsp($mip_form[''10001'']); // Popup\r\nmip_formsp($mip_form[''10002'']); // Popup\r\n\r\nif($cms_mod[''value''][''0''] == ''all'' || $cms_mod[''value''][''0''] == ''advanced'')\r\n mip_forms_tabitem_endp();\r\n \r\n\r\n\r\nif($cms_mod[''value''][''0''] == ''all'' || $cms_mod[''value''][''0''] == ''advanced'')\r\n mip_forms_tabitem_beginp(''Tabelle / Listen'');\r\n\r\n printsfconf(''<strong>{table}</strong><br/><br/>'',\r\n ''all advanced'');\r\n \r\n mip_formsp($mip_form[''100400'']);\r\n mip_formsp($mip_form[''100401'']);\r\n mip_formsp($mip_form[''100402'']);\r\n\r\n mip_formsp($mip_form[''9999'']); //br standard\r\n mip_formsp($mip_form[''10050'']);\r\n mip_formsp($mip_form[''9999'']); //br standard\r\n \r\n mip_formsp($mip_form[''10060'']);\r\n mip_formsp($mip_form[''10030'']);\r\n mip_formsp($mip_form[''10032'']);\r\n mip_formsp($mip_form[''10031'']);\r\n mip_formsp($mip_form[''10033'']);\r\n mip_formsp($mip_form[''10034'']);\r\n\r\n\r\n mip_formsp($mip_form[''9998'']); //hr advanced\r\n\r\n printsfconf(''<strong>{list:x}</strong><br/><br/>'',\r\n ''all advanced'');\r\n\r\n mip_formsp($mip_form[''4010'']);\r\n mip_formsp($mip_form[''4020'']);\r\n\r\n mip_formsp($mip_form[''9999'']); //br standard \r\n \r\n mip_formsp($mip_form[''4110'']);\r\n mip_formsp($mip_form[''4120'']);\r\n mip_formsp($mip_form[''9998'']); //hr advanced\r\n \r\n printsfconf(''<strong>{table} {list:x}</strong><br/><br/>'',\r\n ''all advanced''); \r\n mip_formsp($mip_form[''10070'']);\r\n mip_formsp($mip_form[''10071'']);\r\nif($cms_mod[''value''][''0''] == ''all'' || $cms_mod[''value''][''0''] == ''advanced'')\r\n mip_forms_tabitem_endp();\r\n\r\n\r\n\r\nif($cms_mod[''value''][''0''] == ''all'' || $cms_mod[''value''][''0''] == ''advanced'')\r\n mip_forms_tabitem_beginp(''Dateiliste'');\r\nprintsfconf(''<strong>{filelist}</strong><br/><br/>'',\r\n ''all advanced'');\r\n// filelist\r\nmip_formsp($mip_form[''2003'']); // \r\nif ($cms_mod[''value''][''2003'']!=''rb''){\r\n mip_formsp($mip_form[''999'']); //br standard \r\n mip_formsp($mip_form[''2021'']); // \r\n} \r\nif ($cms_mod[''value''][''2003'']==''rb''){\r\n mip_formsp($mip_form[''9999'']); //br standard \r\n mip_formsp($mip_form[''2022'']); // \r\n} \r\nmip_formsp($mip_form[''9998'']); //hr advanced\r\nmip_formsp($mip_form[''2010'']); // \r\nmip_formsp($mip_form[''9999'']); //br standard \r\nmip_formsp($mip_form[''2013'']); //\r\nmip_formsp($mip_form[''2008'']); // legend\r\nmip_formsp($mip_form[''2011'']); //\r\nmip_formsp($mip_form[''2009'']); // legend\r\nmip_formsp($mip_form[''2030'']); //\r\nmip_formsp($mip_form[''2031'']); //\r\nmip_formsp($mip_form[''2032'']); //\r\nmip_formsp($mip_form[''9999'']); //br standard \r\nmip_formsp($mip_form[''2014'']); //\r\nmip_formsp($mip_form[''9999'']); //br standard \r\nmip_formsp($mip_form[''2012'']); //\r\nmip_formsp($mip_form[''9998'']); //hr advanced \r\nmip_formsp($mip_form[''2015'']); // \r\nmip_formsp($mip_form[''9999'']); //br standard \r\nmip_formsp($mip_form[''2002'']); // \r\nmip_formsp($mip_form[''9999'']); //br standard\r\nmip_formsp($mip_form[''2004'']); // \r\nmip_formsp($mip_form[''9999'']); //br standard\r\nmip_formsp($mip_form[''2005'']); // \r\nmip_formsp($mip_form[''999'']); //br standard\r\nmip_formsp($mip_form[''2023'']); // \r\nmip_formsp($mip_form[''999'']); //br standard\r\nmip_formsp($mip_form[''2016'']); // \r\n\r\nmip_formsp($mip_form[''9998'']); //hr advanced\r\n\r\nmip_formsp($mip_form[''2018'']); // \r\nmip_formsp($mip_form[''2019'']); //\r\nmip_formsp($mip_form[''2006'']); //\r\n\r\nmip_formsp($mip_form[''9998'']); //hr advanced\r\n \r\nmip_formsp($mip_form[''2116'']); //\r\n \r\n\r\nif($cms_mod[''value''][''0''] == ''all'' || $cms_mod[''value''][''0''] == ''advanced'')\r\n mip_forms_tabitem_endp();\r\n \r\n\r\n\r\nmip_forms_tabitem_beginp(''Spezielle Einstellungen'');\r\n\r\necho ''<strong>Modulkonfiguration</strong><br/><br/>'';\r\nmip_formsp($mip_form[''999999'']); // Beschreibung Template\r\n\r\nmip_formsp($mip_form[''9997'']); //hr advanced\r\nprintsfconf(''<strong>Bearbeitungshilfen/-einstellungen</strong><br/><br/>'',\r\n ''all'');\r\nmip_formsp($mip_form[''14'']); // Template-Beschriftung ausgeben\r\nmip_formsp($mip_form[''60'']); // Default Position f&#252;r das Edit Template\r\nmip_formsp($mip_form[''9997'']); //hr advanced\r\n\r\nmip_formsp($mip_form[''30013'']); //Edit Template\r\nmip_formsp($mip_form[''13'']); //Edit Template\r\nmip_formsp($mip_form[''30014'']); //Edit Template\r\nmip_formsp($mip_form[''30015'']); //Edit Template\r\nmip_formsp($mip_form[''999'']); //br advanced\r\nmip_formsp($mip_form[''8'']); // Template Default\r\nmip_formsp($mip_form[''7'']); // Template Default nur im Backend?\r\n\r\nmip_formsp($mip_form[''9997'']); //hr advanced\r\n\r\n// rights\r\nprintsfconf(''<strong>Bearbeitungsrechte</strong><br/><br/>'',\r\n ''all'');\r\nmip_formsp($mip_form[''1000'']); \r\nmip_formsp($mip_form[''1001'']); \r\nmip_formsp($mip_form[''1002'']); \r\nmip_formsp($mip_form[''1003'']); \r\nmip_formsp($mip_form[''999'']); //br advanced\r\nmip_formsp($mip_form[''1004'']); \r\nmip_formsp($mip_form[''9997'']); //hr advanced\r\n\r\n\r\nprintsfconf(''<strong>Navigation</strong><br/><br/>'',\r\n ''all'');\r\n#mip_formsp($mip_form[''80'']); // Beschreibung Navigation\r\nmip_formsp($mip_form[''5'']); // Ergebnisse pro Seite\r\nmip_formsp($mip_form[''10'']); // Template Nav\r\n\r\nmip_formsp($mip_form[''999'']); //br advanced\r\n\r\nmip_formsp($mip_form[''11'']); // text fuer weiter\r\nmip_formsp($mip_form[''12'']); // text fuer zurueck\r\nmip_formsp($mip_form[''9997'']); //hr advanced\r\nprintsfconf(''<strong>Ausgabe</strong><br/><br/>'',\r\n ''all'');\r\n \r\nmip_formsp($mip_form[''95'']);//byte string\r\n\r\n\r\n mip_forms_tabitem_endp();\r\n \r\nmip_forms_tabpane_endp();\r\n//BBCode\r\n//mip_formsp($mip_form[''70'']);//features\r\n\r\n}\r\nunset($mip_form);\r\n//if ($mod[''test''] == "true") {\r\n //echo "<pre>";\r\n //print_r($cms_mod);\r\n //echo "</pre>";\r\n//}\r\n\r\n}\r\n?>', '<CMSPHP:CACHE>\r\n// Version 1.2.0 - ?.?.?\r\n// by Alexander M. Korn (amk@gmx.info)\r\n// Version 1.1.2\r\n// (c) 2005 by Reto Haldemann v/o Mistral\r\n\r\n//	zur Fehlersuche\r\n//if(isset($flextest))\r\n//{\r\n//		$mod[''test''] = "true";\r\n//		$mod[''timetest''] = "true";\r\n//		$modv[''version''] = "true";\r\n//}\r\n\r\n$is_dev=false;\r\n\r\n// Time\r\nif ($mod[''timetest''] == "true") { \r\n	 if ($cms_mod[''modul''][''id''] == ''1'') {\r\n				list($usec, $sec) = explode(" ", microtime());\r\n				$time_start = ((float)$usec + (float)$sec);\r\n		}\r\n}\r\n\r\n// ****	 MOD_VALUE **************************************************************\r\n\r\n$modv[''tpl_nav''] = ''MOD_VALUE[10]'';\r\n$elements1[''font1'']	 = ''MOD_VALUE[1]'';\r\n$elements1[''font2'']	 = ''MOD_VALUE[2]'';\r\n// Anz Eintraege pro Seite\r\n$modv[''max_items''] = MOD_VALUE[5];\r\n$modv[''MOD_editbutton_at_top''] = ''MOD_VALUE[30013]'';\r\n$modv[''MOD_editbutton''] = ''MOD_VALUE[13]'';\r\n$modv[''MOD_insertbtn_tpl''] = ''MOD_VALUE[30014]'';\r\n$modv[''MOD_editbtn_tpl''] = ''MOD_VALUE[30015]'';\r\n\r\n\r\n$modv[''str_byte''] = ''MOD_VALUE[500]'';\r\n$modv[''str_kilobyte''] = ''MOD_VALUE[501]'';\r\n$modv[''str_megabyte''] = ''MOD_VALUE[502]'';\r\n$modv[''val_fsplaces''] = ''MOD_VALUE[510]'';\r\n$modv[''tpl_imgdimensions''] = ''MOD_VALUE[520]'';\r\n\r\n$modv[''MOD_VALUE_11''] = ''MOD_VALUE[11]'';\r\n$modv[''MOD_VALUE_12''] = ''MOD_VALUE[12]'';\r\n$modv[''MOD_VALUE_14''] = ''MOD_VALUE[14]'';\r\n$modv[''MOD_VALUE_60''] = ''MOD_VALUE[60]'';\r\n$modv[''MOD_VALUE_61''] = ''MOD_VALUE[61]'';\r\n$modv[''MOD_VALUE_62''] = ''MOD_VALUE[62]'';\r\n$modv[''MOD_VALUE_63''] = ''MOD_VALUE[63]'';\r\n$modv[''MOD_VALUE_64''] = ''MOD_VALUE[64]'';\r\n$modv[''MOD_VALUE_66''] = ''MOD_VALUE[66]'';\r\n$modv[''MOD_VALUE_67''] = ''MOD_VALUE[67]'';\r\n$modv[''MOD_VALUE_68''] = ''MOD_VALUE[68]'';\r\n$modv[''MOD_VALUE_69''] = ''MOD_VALUE[69]'';\r\n$modv[''MOD_VALUE_6066''] = ''MOD_VALUE[6066]'';\r\n$modv[''MOD_VALUE_6067''] = ''MOD_VALUE[6067]'';\r\n$modv[''MOD_VALUE_6068''] = ''MOD_VALUE[6068]'';\r\n$modv[''MOD_VALUE_6069''] = ''MOD_VALUE[6069]'';\r\n$modv[''MOD_VALUE_95''] = ''MOD_VALUE[95]'';\r\n$modv[''MOD_VALUE_329''] = ''MOD_VALUE[329]'';\r\n\r\n\r\n// rights\r\n$modv[''MOD_VALUE_1001'']	=	''MOD_VALUE[1001]'';\r\n$modv[''MOD_VALUE_1002'']	=	''MOD_VALUE[1002]'';\r\n$modv[''MOD_VALUE_1003'']	=	''MOD_VALUE[1003]'';\r\n$modv[''MOD_VALUE_1004'']	=	''MOD_VALUE[1004]'';\r\n\r\n// unis\r\n$modv[''MOD_VALUE_6000'']	=	''MOD_VALUE[6000]'';\r\n$modv[''MOD_VALUE_6001'']	=	''MOD_VALUE[6001]'';\r\n$modv[''MOD_VALUE_6002'']	=	''MOD_VALUE[6002]'';\r\n$modv[''MOD_VALUE_6003'']	=	''MOD_VALUE[6003]'';\r\n$modv[''MOD_VALUE_6004'']	=	''MOD_VALUE[6004]'';\r\n$modv[''MOD_VALUE_6005'']	=	''MOD_VALUE[6005]'';\r\n\r\n// popup-template\r\n$modv[''MOD_VALUE_10000'']	=	''MOD_VALUE[10000]'';\r\n$modv[''MOD_VALUE_10001'']	=	''MOD_VALUE[10001]'';\r\n$modv[''MOD_VALUE_10002'']	=	''MOD_VALUE[10002]'';\r\n\r\n// table settings\r\n$modv[''MOD_VALUE_10030'']	=	''MOD_VALUE[10030]'';\r\n$modv[''MOD_VALUE_10031'']	=	''MOD_VALUE[10031]'';\r\n$modv[''MOD_VALUE_10032'']	=	''MOD_VALUE[10032]'';\r\n$modv[''MOD_VALUE_10033'']	=	''MOD_VALUE[10033]'';\r\n$modv[''MOD_VALUE_10034'']	=	''MOD_VALUE[10034]'';\r\n$modv[''MOD_VALUE_10060'']	=	''MOD_VALUE[10060]'';\r\n$modv[''MOD_VALUE_10050'']	=	''MOD_VALUE[10050]'';\r\n$modv[''MOD_VALUE_100400'']	=	''MOD_VALUE[100400]'';\r\n$modv[''MOD_VALUE_100401'']	=	''MOD_VALUE[100401]'';\r\n$modv[''MOD_VALUE_100402'']	=	''MOD_VALUE[100402]'';\r\n$modv[''MOD_VALUE_10070'']	=	''MOD_VALUE[10070]'';\r\n$modv[''MOD_VALUE_10071'']	=	''MOD_VALUE[10071]'';\r\n\r\n// list settings\r\n$modv[''MOD_VALUE_4010'']	=	''MOD_VALUE[4010]'';\r\n$modv[''MOD_VALUE_4020'']	=	''MOD_VALUE[4020]'';\r\n$modv[''MOD_VALUE_4110'']	=	''MOD_VALUE[4110]'';\r\n$modv[''MOD_VALUE_4120'']	=	''MOD_VALUE[4120]'';\r\n\r\n// filelist settings\r\n$modv[''MOD_VALUE_2010'']	=	''MOD_VALUE[2010]'';\r\n$modv[''MOD_VALUE_2011'']	=	''MOD_VALUE[2011]'';\r\n$modv[''MOD_VALUE_2030'']	=	''MOD_VALUE[2030]'';\r\n$modv[''MOD_VALUE_2031'']	=	''MOD_VALUE[2031]'';\r\n$modv[''MOD_VALUE_2032'']	=	''MOD_VALUE[2032]'';\r\n$modv[''MOD_VALUE_2012'']	=	''MOD_VALUE[2012]'';\r\n$modv[''MOD_VALUE_2013'']	=	''MOD_VALUE[2013]'';\r\n$modv[''MOD_VALUE_2014'']	=	''MOD_VALUE[2014]'';\r\n$modv[''MOD_VALUE_2018'']	=	''MOD_VALUE[2018]'';\r\n$modv[''MOD_VALUE_2019'']	=	''MOD_VALUE[2019]'';\r\n$modv[''MOD_VALUE_2006'']	=	''MOD_VALUE[2006]'';\r\n$modv[''MOD_VALUE_2015'']	=	''MOD_VALUE[2015]'';\r\n$modv[''MOD_VALUE_2003'']	=	''MOD_VALUE[2003]'';\r\n$modv[''MOD_VALUE_2001'']	=	''MOD_VALUE[2001]'';\r\n$modv[''MOD_VALUE_2000'']	=	''MOD_VALUE[2000]'';\r\n$modv[''MOD_VALUE_2116'']	=	''MOD_VALUE[2116]'';\r\n$modv[''MOD_VALUE_2016'']	=	''MOD_VALUE[2016]'';\r\n$modv[''MOD_VALUE_2002'']	=	''MOD_VALUE[2002]'';\r\n$modv[''MOD_VALUE_2004'']	=	''MOD_VALUE[2004]'';\r\n$modv[''MOD_VALUE_2005'']	=	''MOD_VALUE[2005]'';\r\n$modv[''MOD_VALUE_2020'']	=	''MOD_VALUE[2020]'';\r\n$modv[''MOD_VALUE_2021'']	=	''MOD_VALUE[2021]'';\r\n$modv[''MOD_VALUE_2022'']	=	''MOD_VALUE[2022]'';\r\n$modv[''MOD_VALUE_2023'']	=	''MOD_VALUE[2023]'';\r\n\r\n$modv[''tpl_inner''] = ''MOD_VALUE[8]'';\r\n\r\n\r\nif (("MOD_VALUE[7]" == ''true'') && ($sess->name != ''cms'')) {$modv[''tpl_inner''] = ''''; }\r\n\r\n\r\n// **** include cached ********************************************************************************************\r\n\r\nif ($is_dev)\r\n	include "C:/_server/www/_sefrengo/mod_dev/ContentFlex/backend/inc/mod.contentflex_cache.php";\r\nelse\r\n	include $cms_path.''inc/mod.contentflex_cache.php'';\r\n\r\n\r\n// **** Tags definieren **************************************************************\r\n$elements[''none''] = '''';\r\n\r\n// for a overall speed up it''s needed to convert the temp-tag array into a string\r\n// and recognize the elements via strpos (in_array is slow)\r\n$cflex_temp_elmt_str=implode('' '',$modtemp[''tags''][1]);\r\n// the helper funtion cflex_chkelmt is only a strpos workaround to leave the\r\n// tag definition code part like before with in_array ;) \r\nif(! function_exists(cflex_chkelmt)){\r\n	function cflex_chkelmt($clfex_element,$cflex_tpl_elements)\r\n	{\r\n		if (strpos($cflex_tpl_elements,$clfex_element)!==false)\r\n			return true;\r\n		else\r\n			return false;\r\n	}\r\n}\r\n\r\nif(! function_exists(cflex_getfsize)){\r\n	function cflex_getfsize($cflex_file)\r\n	{\r\n			global $modv;\r\n			$cflex_filesize = '''';\r\n			if ($cflex_file != '''') {\r\n					if (is_file($cflex_file)) {\r\n							$cflex_filesize = filesize($cflex_file);\r\n							if ($cflex_filesize > 1048576) $cflex_filesize = sprintf( "%01.".$modv[''val_fsplaces'']."f", $cflex_filesize/1048576).'' ''.$modv[''str_megabyte''];\r\n							else $cflex_filesize = ($cflex_filesize > 1024) ? sprintf( "%01.".$modv[''val_fsplaces'']."f", $cflex_filesize/1024).'' ''.$modv[''str_kilobyte'']: $cflex_filesize.'' ''.$modv[''str_byte''];\r\n					}\r\n			}\r\n			return $cflex_filesize;\r\n	}\r\n}\r\n\r\nif (cflex_chkelmt(''filetype'',$cflex_temp_elmt_str)) {\r\n	$sql = "SELECT * FROM ".$cms_db[''filetype''];\r\n	$db->query($sql);\r\n	$modv[''filetypes'']=Array();\r\n	while ($db->next_record()) {\r\n		$modv[''filetypes''][strtolower($db->f(''filetype''))][''filetype'']=$db->f(''filetype'');\r\n		$modv[''filetypes''][strtolower($db->f(''filetype''))][''filetypepict'']=$db->f(''filetypepict'');\r\n		$modv[''filetypes''][strtolower($db->f(''filetype''))][''filetypedesc'']=$db->f(''description'');\r\n		$modv[''filetypes''][strtolower($db->f(''filetype''))][''filemimetype'']=$db->f(''mimetype'');\r\n	}\r\n}\r\n\r\n// Function that gets the name of the side or cat based on the url\r\nif(! function_exists(cflex_getSFSideTitle))\r\n{\r\n  function cflex_getSFSideTitle($url)\r\n  {\r\n    global $SF_pageinfos, $SF_catinfos;\r\n    $result = "";\r\n\r\n    if (strpos($url,''idcat'')!==false) {\r\n\r\n	    preg_match("/idcatside=(.*?)&/", urldecode($url . "&"), $matches_side);\r\n	    preg_match("/idcat=(.*?)&/", urldecode($url . "&"), $matches_cat);\r\n	    $catsideid = $matches_side[1];\r\n	    $catid = $matches_cat[1];\r\n	\r\n	    // The URL matched a page    \r\n	    if (is_object($SF_pageinfos) && $catsideid) {\r\n	      $result = $SF_pageinfos->getTitle($catsideid);\r\n	    }\r\n	\r\n	    // The URL matched a folder\r\n	    if (is_object($SF_catinfos) && $catid) {\r\n	      $result = $SF_catinfos->getTitle($catid);\r\n	    }\r\n\r\n		}\r\n\r\n    return trim($result);\r\n\r\n  }\r\n\r\n}\r\n\r\n// Function that gets the description of the side or cat based on the url\r\nif(! function_exists(cflex_getSFSideDesc))\r\n{\r\n  function cflex_getSFSideDesc($url)\r\n  {\r\n    global $SF_pageinfos, $SF_catinfos;\r\n    $result = "";\r\n\r\n    if (strpos($url,''idcat'')!==false) {\r\n\r\n	    preg_match("/idcatside=(.*?)&/", urldecode($url . "&"), $matches_side);\r\n	    preg_match("/idcat=(.*?)&/", urldecode($url . "&"), $matches_cat);\r\n	    $catsideid = $matches_side[1];\r\n	    $catid = $matches_cat[1];\r\n	\r\n	    // The URL matched a page    \r\n	    if (is_object($SF_pageinfos) && $catsideid) {\r\n	      $result = $SF_pageinfos->getMetaDescription($catsideid);\r\n	    }\r\n	\r\n	    // The URL matched a folder\r\n	    if (is_object($SF_catinfos) && $catid) {\r\n	      $result = $SF_catinfos->getDescription($catid);\r\n	    }\r\n\r\n		}\r\n\r\n    return trim($result);\r\n\r\n  }\r\n\r\n}\r\n\r\n// Function that gets the summary of the side or nothing (in case of cat) based on the url\r\nif(! function_exists(cflex_getSFSideSummary))\r\n{\r\n  function cflex_getSFSideSummary($url)\r\n  {\r\n    global $SF_pageinfos, $SF_catinfos;\r\n    $result = "";\r\n\r\n    if (strpos($url,''idcat'')!==false) {\r\n\r\n	    preg_match("/idcatside=(.*?)&/", urldecode($url . "&"), $matches_side);\r\n	    preg_match("/idcat=(.*?)&/", urldecode($url . "&"), $matches_cat);\r\n	    $catsideid = $matches_side[1];\r\n	    $catid = $matches_cat[1];\r\n	\r\n	    // The URL matched a page    \r\n	    if (is_object($SF_pageinfos) && $catsideid) {\r\n	      $result = $SF_pageinfos->getSummary($catsideid);\r\n	    }\r\n	\r\n	    // The URL matched a folder\r\n	    if (is_object($SF_catinfos) && $catid) {\r\n	      $result = "";\r\n	    }\r\n\r\n		}\r\n\r\n    return trim($result);\r\n\r\n  }\r\n\r\n}\r\n// filesize:1\r\nif (cflex_chkelmt(''editfile:1'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''filesize:1'',$cflex_temp_elmt_str)) { $elements[''filesize:1''] = cflex_getfsize(<cms:mod type="file" id=1 addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''file:1'',$cflex_temp_elmt_str)) { $elements[''file:1'']				 = <cms:mod type="file"	 id="1" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileurl:1'',$cflex_temp_elmt_str) || cflex_chkelmt(''filetype'',$cflex_temp_elmt_str) || cflex_chkelmt(''filemimetype:1'',$cflex_temp_elmt_str)) { $elements[''fileurl:1'']			= <cms:mod type="file"	id="1" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filedesc:1'',$cflex_temp_elmt_str)) { $elements[''filedesc:1'']		 = <cms:mod type="file"	 id="1" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filename:1'',$cflex_temp_elmt_str)) { $elements[''filename:1'']		 = <cms:mod type="file"	 id="1" addslashes="true" mode="filename" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmtitle:1'',$cflex_temp_elmt_str)) { $elements[''filefmtitle:1''] = <cms:mod type="file"	id="1" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmdesc:1'',$cflex_temp_elmt_str)) { $elements[''filefmdesc:1'']	 = <cms:mod type="file"	 id="1" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileid:1'',$cflex_temp_elmt_str)) { $elements[''fileid:1'']	 = <cms:mod type="file"	 id="1" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		$current_filetype=strtolower(substr(strrchr($elements[''fileurl:1''],''.''),1));\r\n		if (cflex_chkelmt(''filetypeicon:1'',$cflex_temp_elmt_str)) \r\n			$elements[''filetypeicon:1''] = ''<img src="''.$modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''].''" alt=""/>'';\r\n		if (cflex_chkelmt(''filetypeiconurl:1'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconurl:1''] = $modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetype:1'',$cflex_temp_elmt_str))\r\n			$elements[''filetype:1''] = $modv[''filetypes''][$current_filetype][''filetype''];\r\n		if (cflex_chkelmt(''filetypeiconname:1'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconname:1''] = $modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetypedesc:1'',$cflex_temp_elmt_str))\r\n			$elements[''filetypedesc:1''] =	 $modv[''filetypes''][$current_filetype][''filetypedesc''];\r\n		if (cflex_chkelmt(''filemimetype:1'',$cflex_temp_elmt_str))\r\n			$elements[''filemimetype:1''] =	 $modv[''filetypes''][$current_filetype][''filemimetype''];\r\n\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editfile:1'',$cflex_temp_elmt_str)) { $elements[''editfile:1'']		 = <cms:mod type="file"				id="1" title="MOD_VALUE[25]" mode="editbutton" hidetarget ="MOD_VALUE[27]" folders = "MOD_VALUE[18]" subfolders ="MOD_VALUE[19]" filetypes = "MOD_VALUE[6]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\n\r\nif (cflex_chkelmt(''editfile:2'',$cflex_temp_elmt_str)) {\r\n		// filesize:2\r\n		if (cflex_chkelmt(''filesize:2'',$cflex_temp_elmt_str)) { $elements[''filesize:2''] = cflex_getfsize(<cms:mod type="file" id=2 addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''file:2'',$cflex_temp_elmt_str)) { $elements[''file:2'']				 = <cms:mod type="file"	 id="2" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileurl:2'',$cflex_temp_elmt_str) || cflex_chkelmt(''filetype'',$cflex_temp_elmt_str) || cflex_chkelmt(''filemimetype:2'',$cflex_temp_elmt_str)) { $elements[''fileurl:2'']			= <cms:mod type="file"	id="2" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filedesc:2'',$cflex_temp_elmt_str)) { $elements[''filedesc:2'']		 = <cms:mod type="file"	 id="2" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filename:2'',$cflex_temp_elmt_str)) { $elements[''filename:2'']		 = <cms:mod type="file"	 id="2" addslashes="true" mode="filename" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmtitle:2'',$cflex_temp_elmt_str)) { $elements[''filefmtitle:2''] = <cms:mod type="file"	id="2" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmdesc:2'',$cflex_temp_elmt_str)) { $elements[''filefmdesc:2'']	 = <cms:mod type="file"	 id="2" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileid:2'',$cflex_temp_elmt_str)) { $elements[''fileid:2'']	 = <cms:mod type="file"	 id="2" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		$current_filetype=strtolower(substr(strrchr($elements[''fileurl:2''],''.''),1));\r\n		if (cflex_chkelmt(''filetypeicon:2'',$cflex_temp_elmt_str)) \r\n			$elements[''filetypeicon:2''] = ''<img src="''.$modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''].''" alt=""/>'';\r\n		if (cflex_chkelmt(''filetypeiconurl:2'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconurl:2''] = $modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetype:2'',$cflex_temp_elmt_str))\r\n			$elements[''filetype:2''] = $modv[''filetypes''][$current_filetype][''filetype''];\r\n		if (cflex_chkelmt(''filetypeiconname:2'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconname:2''] = $modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetypedesc:2'',$cflex_temp_elmt_str))\r\n			$elements[''filetypedesc:2''] =	 $modv[''filetypes''][$current_filetype][''filetypedesc''];\r\n		if (cflex_chkelmt(''filemimetype:2'',$cflex_temp_elmt_str))\r\n			$elements[''filemimetype:2''] =	 $modv[''filetypes''][$current_filetype][''filemimetype''];\r\n\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editfile:2'',$cflex_temp_elmt_str)) { $elements[''editfile:2'']		 = <cms:mod type="file"				id="2" title="MOD_VALUE[35]" mode="editbutton" hidetarget ="MOD_VALUE[27]" folders = "MOD_VALUE[18]" subfolders ="MOD_VALUE[19]" filetypes = "MOD_VALUE[6]" addslashes="true" menuoptions="false" />; }\r\n}\r\n\r\nif (cflex_chkelmt(''editfile:3'',$cflex_temp_elmt_str)) {\r\n		// filesize:3\r\n		if (cflex_chkelmt(''filesize:3'',$cflex_temp_elmt_str)) { $elements[''filesize:3''] = cflex_getfsize(<cms:mod type="file" id=3 addslashes="true" mode="path" menuoptions="false">);\r\n		}\r\n		if (cflex_chkelmt(''file:3'',$cflex_temp_elmt_str)) { $elements[''file:3'']				 = <cms:mod type="file"	 id="3" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileurl:3'',$cflex_temp_elmt_str) || cflex_chkelmt(''filetype'',$cflex_temp_elmt_str) || cflex_chkelmt(''filemimetype:3'',$cflex_temp_elmt_str)) { $elements[''fileurl:3'']			= <cms:mod type="file"	id="3" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filedesc:3'',$cflex_temp_elmt_str)) { $elements[''filedesc:3'']		 = <cms:mod type="file"	 id="3" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filename:3'',$cflex_temp_elmt_str)) { $elements[''filename:3'']		 = <cms:mod type="file"	 id="3" addslashes="true" mode="filename" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmtitle:3'',$cflex_temp_elmt_str)) { $elements[''filefmtitle:3''] = <cms:mod type="file"	id="3" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmdesc:3'',$cflex_temp_elmt_str)) { $elements[''filefmdesc:3'']	 = <cms:mod type="file"	 id="3" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileid:3'',$cflex_temp_elmt_str)) { $elements[''fileid:3'']	 = <cms:mod type="file"	 id="3" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		$current_filetype=strtolower(substr(strrchr($elements[''fileurl:3''],''.''),1));\r\n		if (cflex_chkelmt(''filetypeicon:3'',$cflex_temp_elmt_str)) \r\n			$elements[''filetypeicon:3''] = ''<img src="''.$modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''].''" alt=""/>'';\r\n		if (cflex_chkelmt(''filetypeiconurl:3'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconurl:3''] = $modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetype:3'',$cflex_temp_elmt_str))\r\n			$elements[''filetype:3''] = $modv[''filetypes''][$current_filetype][''filetype''];\r\n		if (cflex_chkelmt(''filetypeiconname:3'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconname:3''] = $modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetypedesc:3'',$cflex_temp_elmt_str))\r\n			$elements[''filetypedesc:3''] =	 $modv[''filetypes''][$current_filetype][''filetypedesc''];\r\n		if (cflex_chkelmt(''filemimetype:3'',$cflex_temp_elmt_str))\r\n			$elements[''filemimetype:3''] =	 $modv[''filetypes''][$current_filetype][''filemimetype''];\r\n\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editfile:3'',$cflex_temp_elmt_str)) { $elements[''editfile:3'']		 = <cms:mod type="file"				id="3" title="MOD_VALUE[45]" mode="editbutton" hidetarget ="MOD_VALUE[27]" folders = "MOD_VALUE[18]" subfolders ="MOD_VALUE[19]" filetypes = "MOD_VALUE[6]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\n\r\n\r\nif (cflex_chkelmt(''editfile:4'',$cflex_temp_elmt_str)) {\r\n		// filesize:3\r\n		if (cflex_chkelmt(''filesize:4'',$cflex_temp_elmt_str)) { $elements[''filesize:4''] = cflex_getfsize(<cms:mod type="file" id="4" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''file:4'',$cflex_temp_elmt_str)) { $elements[''file:4'']				 = <cms:mod type="file"	 id="4" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileurl:4'',$cflex_temp_elmt_str) || cflex_chkelmt(''filetype'',$cflex_temp_elmt_str) || cflex_chkelmt(''filemimetype:4'',$cflex_temp_elmt_str)) { $elements[''fileurl:4'']			= <cms:mod type="file"	id="4" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filedesc:4'',$cflex_temp_elmt_str)) { $elements[''filedesc:4'']		 = <cms:mod type="file"	 id="4" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filename:4'',$cflex_temp_elmt_str)) { $elements[''filename:4'']		 = <cms:mod type="file"	 id="4" addslashes="true" mode="filename" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmtitle:4'',$cflex_temp_elmt_str)) { $elements[''filefmtitle:4''] = <cms:mod type="file"	id="4" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmdesc:4'',$cflex_temp_elmt_str)) { $elements[''filefmdesc:4'']	 = <cms:mod type="file"	 id="4" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileid:4'',$cflex_temp_elmt_str)) { $elements[''fileid:4'']	 = <cms:mod type="file"	 id="4" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		$current_filetype=strtolower(substr(strrchr($elements[''fileurl:4''],''.''),1));\r\n		if (cflex_chkelmt(''filetypeicon:4'',$cflex_temp_elmt_str)) \r\n			$elements[''filetypeicon:4''] = ''<img src="''.$modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''].''" alt=""/>'';\r\n		if (cflex_chkelmt(''filetypeiconurl:4'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconurl:4''] = $modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetype:4'',$cflex_temp_elmt_str))\r\n			$elements[''filetype:4''] = $modv[''filetypes''][$current_filetype][''filetype''];\r\n		if (cflex_chkelmt(''filetypeiconname:4'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconname:4''] = $modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetypedesc:4'',$cflex_temp_elmt_str))\r\n			$elements[''filetypedesc:4''] =	 $modv[''filetypes''][$current_filetype][''filetypedesc''];\r\n		if (cflex_chkelmt(''filemimetype:4'',$cflex_temp_elmt_str))\r\n			$elements[''filemimetype:4''] =	 $modv[''filetypes''][$current_filetype][''filemimetype''];\r\n\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editfile:4'',$cflex_temp_elmt_str)) { $elements[''editfile:4'']		 = <cms:mod type="file"				id="4" title="MOD_VALUE[5045]" mode="editbutton" hidetarget ="MOD_VALUE[27]" folders = "MOD_VALUE[18]" subfolders ="MOD_VALUE[19]" filetypes = "MOD_VALUE[6]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\n\r\nif (cflex_chkelmt(''editfile:5'',$cflex_temp_elmt_str)) {\r\n		// filesize:3\r\n		if (cflex_chkelmt(''filesize:5'',$cflex_temp_elmt_str)) { $elements[''filesize:5''] = cflex_getfsize(<cms:mod type="file" id="5" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''file:5'',$cflex_temp_elmt_str)) { $elements[''file:5'']				 = <cms:mod type="file"	 id="5" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileurl:5'',$cflex_temp_elmt_str) || cflex_chkelmt(''filetype'',$cflex_temp_elmt_str) || cflex_chkelmt(''filemimetype:5'',$cflex_temp_elmt_str)) { $elements[''fileurl:5'']			= <cms:mod type="file"	id="5" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filedesc:5'',$cflex_temp_elmt_str)) { $elements[''filedesc:5'']		 = <cms:mod type="file"	 id="5" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filename:5'',$cflex_temp_elmt_str)) { $elements[''filename:5'']		 = <cms:mod type="file"	 id="5" addslashes="true" mode="filename" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmtitle:5'',$cflex_temp_elmt_str)) { $elements[''filefmtitle:5''] = <cms:mod type="file"	id="5" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmdesc:5'',$cflex_temp_elmt_str)) { $elements[''filefmdesc:5'']	 = <cms:mod type="file"	 id="5" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileid:5'',$cflex_temp_elmt_str)) { $elements[''fileid:5'']	 = <cms:mod type="file"	 id="5" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		$current_filetype=strtolower(substr(strrchr($elements[''fileurl:5''],''.''),1));\r\n		if (cflex_chkelmt(''filetypeicon:5'',$cflex_temp_elmt_str)) \r\n			$elements[''filetypeicon:5''] = ''<img src="''.$modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''].''" alt=""/>'';\r\n		if (cflex_chkelmt(''filetypeiconurl:5'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconurl:5''] = $modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetype:5'',$cflex_temp_elmt_str))\r\n			$elements[''filetype:5''] = $modv[''filetypes''][$current_filetype][''filetype''];\r\n		if (cflex_chkelmt(''filetypeiconname:5'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconname:5''] = $modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetypedesc:5'',$cflex_temp_elmt_str))\r\n			$elements[''filetypedesc:5''] =	 $modv[''filetypes''][$current_filetype][''filetypedesc''];\r\n		if (cflex_chkelmt(''filemimetype:5'',$cflex_temp_elmt_str))\r\n			$elements[''filemimetype:5''] =	 $modv[''filetypes''][$current_filetype][''filemimetype''];\r\n\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editfile:5'',$cflex_temp_elmt_str)) { $elements[''editfile:5'']		 = <cms:mod type="file"				id="5" title="MOD_VALUE[5046]" mode="editbutton" hidetarget ="MOD_VALUE[27]" folders = "MOD_VALUE[18]" subfolders ="MOD_VALUE[19]" filetypes = "MOD_VALUE[6]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\n\r\nif (cflex_chkelmt(''editfile:6'',$cflex_temp_elmt_str)) {\r\n		// filesize:3\r\n		if (cflex_chkelmt(''filesize:6'',$cflex_temp_elmt_str)) { $elements[''filesize:6''] = cflex_getfsize(<cms:mod type="file" id="6" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''file:6'',$cflex_temp_elmt_str)) { $elements[''file:6'']				 = <cms:mod type="file"	 id="6" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileurl:6'',$cflex_temp_elmt_str) || cflex_chkelmt(''filetype'',$cflex_temp_elmt_str) || cflex_chkelmt(''filemimetype:6'',$cflex_temp_elmt_str)) { $elements[''fileurl:6'']			= <cms:mod type="file"	id="6" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filedesc:6'',$cflex_temp_elmt_str)) { $elements[''filedesc:6'']		 = <cms:mod type="file"	 id="6" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filename:6'',$cflex_temp_elmt_str)) { $elements[''filename:6'']		 = <cms:mod type="file"	 id="6" addslashes="true" mode="filename" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmtitle:6'',$cflex_temp_elmt_str)) { $elements[''filefmtitle:6''] = <cms:mod type="file"	id="6" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmdesc:6'',$cflex_temp_elmt_str)) { $elements[''filefmdesc:6'']	 = <cms:mod type="file"	 id="6" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileid:6'',$cflex_temp_elmt_str)) { $elements[''fileid:6'']	 = <cms:mod type="file"	 id="6" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		$current_filetype=strtolower(substr(strrchr($elements[''fileurl:6''],''.''),1));\r\n		if (cflex_chkelmt(''filetypeicon:6'',$cflex_temp_elmt_str)) \r\n			$elements[''filetypeicon:6''] = ''<img src="''.$modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''].''" alt=""/>'';\r\n		if (cflex_chkelmt(''filetypeiconurl:6'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconurl:6''] = $modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetype:6'',$cflex_temp_elmt_str))\r\n			$elements[''filetype:6''] = $modv[''filetypes''][$current_filetype][''filetype''];\r\n		if (cflex_chkelmt(''filetypeiconname:6'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconname:6''] = $modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetypedesc:6'',$cflex_temp_elmt_str))\r\n			$elements[''filetypedesc:6''] =	 $modv[''filetypes''][$current_filetype][''filetypedesc''];\r\n		if (cflex_chkelmt(''filemimetype:6'',$cflex_temp_elmt_str))\r\n			$elements[''filemimetype:6''] =	 $modv[''filetypes''][$current_filetype][''filemimetype''];\r\n\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editfile:6'',$cflex_temp_elmt_str)) { $elements[''editfile:6'']		 = <cms:mod type="file"				id="6" title="MOD_VALUE[5047]" mode="editbutton" hidetarget ="MOD_VALUE[27]" folders = "MOD_VALUE[18]" subfolders ="MOD_VALUE[19]" filetypes = "MOD_VALUE[6]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\n\r\nif (cflex_chkelmt(''editfile:7'',$cflex_temp_elmt_str)) {\r\n		// filesize:3\r\n		if (cflex_chkelmt(''filesize:7'',$cflex_temp_elmt_str)) { $elements[''filesize:7''] = cflex_getfsize(<cms:mod type="file" id="7" addslashes="true" mode="path" menuoptions="false">);	}\r\n		if (cflex_chkelmt(''file:7'',$cflex_temp_elmt_str)) { $elements[''file:7'']				 = <cms:mod type="file"	 id="7" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileurl:7'',$cflex_temp_elmt_str) || cflex_chkelmt(''filetype'',$cflex_temp_elmt_str) || cflex_chkelmt(''filemimetype:7'',$cflex_temp_elmt_str)) { $elements[''fileurl:7'']			= <cms:mod type="file"	id="7" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filedesc:7'',$cflex_temp_elmt_str)) { $elements[''filedesc:7'']		 = <cms:mod type="file"	 id="7" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filename:7'',$cflex_temp_elmt_str)) { $elements[''filename:7'']		 = <cms:mod type="file"	 id="7" addslashes="true" mode="filename" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmtitle:7'',$cflex_temp_elmt_str)) { $elements[''filefmtitle:7''] = <cms:mod type="file"	id="7" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmdesc:7'',$cflex_temp_elmt_str)) { $elements[''filefmdesc:7'']	 = <cms:mod type="file"	 id="7" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileid:7'',$cflex_temp_elmt_str)) { $elements[''fileid:7'']	 = <cms:mod type="file"	 id="7" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		$current_filetype=strtolower(substr(strrchr($elements[''fileurl:7''],''.''),1));\r\n		if (cflex_chkelmt(''filetypeicon:7'',$cflex_temp_elmt_str)) \r\n			$elements[''filetypeicon:7''] = ''<img src="''.$modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''].''" alt=""/>'';\r\n		if (cflex_chkelmt(''filetypeiconurl:7'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconurl:7''] = $modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetype:7'',$cflex_temp_elmt_str))\r\n			$elements[''filetype:7''] = $modv[''filetypes''][$current_filetype][''filetype''];\r\n		if (cflex_chkelmt(''filetypeiconname:7'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconname:7''] = $modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetypedesc:7'',$cflex_temp_elmt_str))\r\n			$elements[''filetypedesc:7''] =	 $modv[''filetypes''][$current_filetype][''filetypedesc''];\r\n		if (cflex_chkelmt(''filemimetype:7'',$cflex_temp_elmt_str))\r\n			$elements[''filemimetype:7''] =	 $modv[''filetypes''][$current_filetype][''filemimetype''];\r\n\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editfile:7'',$cflex_temp_elmt_str)) { $elements[''editfile:7'']		 = <cms:mod type="file"				id="7" title="MOD_VALUE[5048]" mode="editbutton" hidetarget ="MOD_VALUE[27]" folders = "MOD_VALUE[18]" subfolders ="MOD_VALUE[19]" filetypes = "MOD_VALUE[6]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\n\r\nif (cflex_chkelmt(''editfile:8'',$cflex_temp_elmt_str)) {\r\n		// filesize:3\r\n		if (cflex_chkelmt(''filesize:8'',$cflex_temp_elmt_str)) { $elements[''filesize:8''] = cflex_getfsize(<cms:mod type="file" id="8" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''file:8'',$cflex_temp_elmt_str)) { $elements[''file:8'']				 = <cms:mod type="file"	 id="8" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileurl:8'',$cflex_temp_elmt_str) || cflex_chkelmt(''filetype'',$cflex_temp_elmt_str) || cflex_chkelmt(''filemimetype:8'',$cflex_temp_elmt_str)) { $elements[''fileurl:8'']			= <cms:mod type="file"	id="8" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filedesc:8'',$cflex_temp_elmt_str)) { $elements[''filedesc:8'']		 = <cms:mod type="file"	 id="8" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filename:8'',$cflex_temp_elmt_str)) { $elements[''filename:8'']		 = <cms:mod type="file"	 id="8" addslashes="true" mode="filename" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmtitle:8'',$cflex_temp_elmt_str)) { $elements[''filefmtitle:8''] = <cms:mod type="file"	id="8" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmdesc:8'',$cflex_temp_elmt_str)) { $elements[''filefmdesc:8'']	 = <cms:mod type="file"	 id="8" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileid:8'',$cflex_temp_elmt_str)) { $elements[''fileid:8'']	 = <cms:mod type="file"	 id="8" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		$current_filetype=strtolower(substr(strrchr($elements[''fileurl:8''],''.''),1));\r\n		if (cflex_chkelmt(''filetypeicon:8'',$cflex_temp_elmt_str)) \r\n			$elements[''filetypeicon:8''] = ''<img src="''.$modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''].''" alt=""/>'';\r\n		if (cflex_chkelmt(''filetypeiconurl:8'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconurl:8''] = $modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetype:8'',$cflex_temp_elmt_str))\r\n			$elements[''filetype:8''] = $modv[''filetypes''][$current_filetype][''filetype''];\r\n		if (cflex_chkelmt(''filetypeiconname:8'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconname:8''] = $modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetypedesc:8'',$cflex_temp_elmt_str))\r\n			$elements[''filetypedesc:8''] =	 $modv[''filetypes''][$current_filetype][''filetypedesc''];\r\n		if (cflex_chkelmt(''filemimetype:8'',$cflex_temp_elmt_str))\r\n			$elements[''filemimetype:8''] =	 $modv[''filetypes''][$current_filetype][''filemimetype''];\r\n\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editfile:8'',$cflex_temp_elmt_str)) { $elements[''editfile:8'']		 = <cms:mod type="file"				id="8" title="MOD_VALUE[5049]" mode="editbutton" hidetarget ="MOD_VALUE[27]" folders = "MOD_VALUE[18]" subfolders ="MOD_VALUE[19]" filetypes = "MOD_VALUE[6]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\n\r\nif (cflex_chkelmt(''editfile:9'',$cflex_temp_elmt_str)) {\r\n		// filesize:3\r\n		if (cflex_chkelmt(''filesize:9'',$cflex_temp_elmt_str)) { $elements[''filesize:9''] = cflex_getfsize(<cms:mod type="file" id="9" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''file:9'',$cflex_temp_elmt_str)) { $elements[''file:9'']				 = <cms:mod type="file"	 id="9" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileurl:9'',$cflex_temp_elmt_str) || cflex_chkelmt(''filetype'',$cflex_temp_elmt_str) || cflex_chkelmt(''filemimetype:9'',$cflex_temp_elmt_str)) { $elements[''fileurl:9'']			= <cms:mod type="file"	id="9" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filedesc:9'',$cflex_temp_elmt_str)) { $elements[''filedesc:9'']		 = <cms:mod type="file"	 id="9" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filename:9'',$cflex_temp_elmt_str)) { $elements[''filename:9'']		 = <cms:mod type="file"	 id="9" addslashes="true" mode="filename" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmtitle:9'',$cflex_temp_elmt_str)) { $elements[''filefmtitle:9''] = <cms:mod type="file"	id="9" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmdesc:9'',$cflex_temp_elmt_str)) { $elements[''filefmdesc:9'']	 = <cms:mod type="file"	 id="9" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileid:9'',$cflex_temp_elmt_str)) { $elements[''fileid:9'']	 = <cms:mod type="file"	 id="9" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		$current_filetype=strtolower(substr(strrchr($elements[''fileurl:9''],''.''),1));\r\n		if (cflex_chkelmt(''filetypeicon:9'',$cflex_temp_elmt_str)) \r\n			$elements[''filetypeicon:9''] = ''<img src="''.$modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''].''" alt=""/>'';\r\n		if (cflex_chkelmt(''filetypeiconurl:9'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconurl:9''] = $modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetype:9'',$cflex_temp_elmt_str))\r\n			$elements[''filetype:9''] = $modv[''filetypes''][$current_filetype][''filetype''];\r\n		if (cflex_chkelmt(''filetypeiconname:9'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconname:9''] = $modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetypedesc:9'',$cflex_temp_elmt_str))\r\n			$elements[''filetypedesc:9''] =	 $modv[''filetypes''][$current_filetype][''filetypedesc''];\r\n		if (cflex_chkelmt(''filemimetype:9'',$cflex_temp_elmt_str))\r\n			$elements[''filemimetype:9''] =	 $modv[''filetypes''][$current_filetype][''filemimetype''];\r\n\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editfile:9'',$cflex_temp_elmt_str)) { $elements[''editfile:9'']		 = <cms:mod type="file"				id="9" title="MOD_VALUE[5050]" mode="editbutton" hidetarget ="MOD_VALUE[27]" folders = "MOD_VALUE[18]" subfolders ="MOD_VALUE[19]" filetypes = "MOD_VALUE[6]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\n\r\n\r\nif (cflex_chkelmt(''editfile:10'',$cflex_temp_elmt_str)) {\r\n		// filesize:3\r\n		if (cflex_chkelmt(''filesize:10'',$cflex_temp_elmt_str)) { $elements[''filesize:10''] = cflex_getfsize(<cms:mod type="file" id="10" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''file:10'',$cflex_temp_elmt_str)) { $elements[''file:10'']				 = <cms:mod type="file"	 id="10" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileurl:10'',$cflex_temp_elmt_str) || cflex_chkelmt(''filetype'',$cflex_temp_elmt_str) || cflex_chkelmt(''filemimetype:10'',$cflex_temp_elmt_str)) { $elements[''fileurl:10'']			= <cms:mod type="file"	id="10" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filedesc:10'',$cflex_temp_elmt_str)) { $elements[''filedesc:10'']		 = <cms:mod type="file"	 id="10" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filename:10'',$cflex_temp_elmt_str)) { $elements[''filename:10'']		 = <cms:mod type="file"	 id="10" addslashes="true" mode="filename" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmtitle:10'',$cflex_temp_elmt_str)) { $elements[''filefmtitle:10''] = <cms:mod type="file"	id="10" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''filefmdesc:10'',$cflex_temp_elmt_str)) { $elements[''filefmdesc:10'']	 = <cms:mod type="file"	 id="10" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''fileid:10'',$cflex_temp_elmt_str)) { $elements[''fileid:10'']	 = <cms:mod type="file"	 id="10" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		$current_filetype=strtolower(substr(strrchr($elements[''fileurl:10''],''.''),1));\r\n		if (cflex_chkelmt(''filetypeicon:10'',$cflex_temp_elmt_str)) \r\n			$elements[''filetypeicon:10''] = ''<img src="''.$modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''].''" alt=""/>'';\r\n		if (cflex_chkelmt(''filetypeiconurl:10'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconurl:10''] = $modv[''MOD_VALUE_2020''].$modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetype:10'',$cflex_temp_elmt_str))\r\n			$elements[''filetype:10''] = $modv[''filetypes''][$current_filetype][''filetype''];\r\n		if (cflex_chkelmt(''filetypeiconname:10'',$cflex_temp_elmt_str))\r\n			$elements[''filetypeiconname:10''] = $modv[''filetypes''][$current_filetype][''filetypepict''];\r\n		if (cflex_chkelmt(''filetypedesc:10'',$cflex_temp_elmt_str))\r\n			$elements[''filetypedesc:10''] =	 $modv[''filetypes''][$current_filetype][''filetypedesc''];\r\n		if (cflex_chkelmt(''filemimetype:10'',$cflex_temp_elmt_str))\r\n			$elements[''filemimetype:10''] =	 $modv[''filetypes''][$current_filetype][''filemimetype''];\r\n\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editfile:10'',$cflex_temp_elmt_str)) { $elements[''editfile:10'']		 = <cms:mod type="file"				id="10" title="MOD_VALUE[5051]" mode="editbutton" hidetarget ="MOD_VALUE[27]" folders = "MOD_VALUE[18]" subfolders ="MOD_VALUE[19]" filetypes = "MOD_VALUE[6]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\n\r\n\r\n\r\n\r\n\r\nif (cflex_chkelmt(''editlink:1'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''link:1'',$cflex_temp_elmt_str)) { $elements[''link:1'']				 = <cms:mod type="link"	 id="1" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linkurl:1'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidetitle:1'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidedesc:1'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidesummary:1'',$cflex_temp_elmt_str)) { \r\n			$elements[''linkurl:1'']			= <cms:mod type="link"	id="1" addslashes="true" mode="url" menuoptions="false" />; \r\n    	$elements[''linksfsidetitle:1''] = cflex_getSFSideTitle($elements[''linkurl:1'']);\r\n        $elements[''linksfsidedesc:1''] = cflex_getSFSideDesc($elements[''linkurl:1'']);\r\n        $elements[''linksfsidesummary:1''] = cflex_getSFSideSummary($elements[''linkurl:1'']);\r\n		}\r\n		if (cflex_chkelmt(''linkdesc:1'',$cflex_temp_elmt_str)) { $elements[''linkdesc:1'']		 = <cms:mod type="link"	 id="1" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linktarget:1'',$cflex_temp_elmt_str)) { $elements[''linktarget:1'']	 = <cms:mod type="link"	 id="1" addslashes="true" mode="target" menuoptions="false" />; }\r\n\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editlink:1'',$cflex_temp_elmt_str)) { $elements[''editlink:1'']		 = <cms:mod type="link"				id="1" title="MOD_VALUE[26]" mode="editbutton" addslashes="true" menuoptions="false" />; }\r\n}\r\nif (cflex_chkelmt(''editlink:2'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''link:2'',$cflex_temp_elmt_str)) { $elements[''link:2'']				 = <cms:mod type="link"	 id="2" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linkurl:2'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidetitle:2'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidedesc:2'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidesummary:2'',$cflex_temp_elmt_str)) { \r\n			$elements[''linkurl:2'']			= <cms:mod type="link"	id="2" addslashes="true" mode="url" menuoptions="false" />; \r\n    	$elements[''linksfsidetitle:2''] = cflex_getSFSideTitle($elements[''linkurl:2'']);\r\n        $elements[''linksfsidedesc:2''] = cflex_getSFSideDesc($elements[''linkurl:2'']);\r\n        $elements[''linksfsidesummary:2''] = cflex_getSFSideSummary($elements[''linkurl:2'']);\r\n		}\r\n		if (cflex_chkelmt(''linkdesc:2'',$cflex_temp_elmt_str)) { $elements[''linkdesc:2'']		 = <cms:mod type="link"	 id="2" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linktarget:2'',$cflex_temp_elmt_str)) { $elements[''linktarget:2'']	 = <cms:mod type="link"	 id="2" addslashes="true" mode="target" menuoptions="false" />; }\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editlink:2'',$cflex_temp_elmt_str)) { $elements[''editlink:2'']		 = <cms:mod type="link"				id="2" title="MOD_VALUE[36]" mode="editbutton" addslashes="true" menuoptions="false" />; }\r\n}\r\nif (cflex_chkelmt(''editlink:3'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''link:3'',$cflex_temp_elmt_str)) { $elements[''link:3'']				 = <cms:mod type="link"	 id="3" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linkurl:3'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidetitle:3'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidedesc:3'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidesummary:3'',$cflex_temp_elmt_str)) { \r\n			$elements[''linkurl:3'']			= <cms:mod type="link"	id="3" addslashes="true" mode="url" menuoptions="false" />; \r\n    	$elements[''linksfsidetitle:3''] = cflex_getSFSideTitle($elements[''linkurl:3'']);\r\n        $elements[''linksfsidedesc:3''] = cflex_getSFSideDesc($elements[''linkurl:3'']);\r\n        $elements[''linksfsidesummary:3''] = cflex_getSFSideSummary($elements[''linkurl:3'']);\r\n		}\r\n		if (cflex_chkelmt(''linkdesc:3'',$cflex_temp_elmt_str)) { $elements[''linkdesc:3'']		 = <cms:mod type="link"	 id="3" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linktarget:3'',$cflex_temp_elmt_str)) { $elements[''linktarget:3'']	 = <cms:mod type="link"	 id="3" addslashes="true" mode="target" menuoptions="false" />; }\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editlink:3'',$cflex_temp_elmt_str)) { $elements[''editlink:3'']		 = <cms:mod type="link"				id="3" title="MOD_VALUE[46]" mode="editbutton" addslashes="true" menuoptions="false" />; }\r\n}\r\nif (cflex_chkelmt(''editlink:4'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''link:4'',$cflex_temp_elmt_str)) { $elements[''link:4'']				 = <cms:mod type="link"	 id="4" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linkurl:4'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidetitle:4'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidedesc:4'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidesummary:4'',$cflex_temp_elmt_str)) { \r\n			$elements[''linkurl:4'']			= <cms:mod type="link"	id="4" addslashes="true" mode="url" menuoptions="false" />; \r\n    	$elements[''linksfsidetitle:4''] = cflex_getSFSideTitle($elements[''linkurl:4'']);\r\n        $elements[''linksfsidedesc:4''] = cflex_getSFSideDesc($elements[''linkurl:4'']);\r\n        $elements[''linksfsidesummary:4''] = cflex_getSFSideSummary($elements[''linkurl:4'']);\r\n		}\r\n		if (cflex_chkelmt(''linkdesc:4'',$cflex_temp_elmt_str)) { $elements[''linkdesc:4'']		 = <cms:mod type="link"	 id="4" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linktarget:4'',$cflex_temp_elmt_str)) { $elements[''linktarget:4'']	 = <cms:mod type="link"	 id="4" addslashes="true" mode="target" menuoptions="false" />; }\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editlink:4'',$cflex_temp_elmt_str)) { $elements[''editlink:4'']		 = <cms:mod type="link"				id="4" title="MOD_VALUE[8046]" mode="editbutton" addslashes="true" menuoptions="false" />; }\r\n}\r\nif (cflex_chkelmt(''editlink:5'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''link:5'',$cflex_temp_elmt_str)) { $elements[''link:5'']				 = <cms:mod type="link"	 id="5" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linkurl:5'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidetitle:5'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidedesc:5'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidesummary:5'',$cflex_temp_elmt_str)) { \r\n			$elements[''linkurl:5'']			= <cms:mod type="link"	id="5" addslashes="true" mode="url" menuoptions="false" />; \r\n    	$elements[''linksfsidetitle:5''] = cflex_getSFSideTitle($elements[''linkurl:5'']);\r\n        $elements[''linksfsidedesc:5''] = cflex_getSFSideDesc($elements[''linkurl:5'']);\r\n        $elements[''linksfsidesummary:5''] = cflex_getSFSideSummary($elements[''linkurl:5'']);\r\n		}\r\n		if (cflex_chkelmt(''linkdesc:5'',$cflex_temp_elmt_str)) { $elements[''linkdesc:5'']		 = <cms:mod type="link"	 id="5" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linktarget:5'',$cflex_temp_elmt_str)) { $elements[''linktarget:5'']	 = <cms:mod type="link"	 id="5" addslashes="true" mode="target" menuoptions="false" />; }\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editlink:5'',$cflex_temp_elmt_str)) { $elements[''editlink:5'']		 = <cms:mod type="link"				id="5" title="MOD_VALUE[8047]" mode="editbutton" addslashes="true" menuoptions="false" />; }\r\n}\r\nif (cflex_chkelmt(''editlink:6'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''link:6'',$cflex_temp_elmt_str)) { $elements[''link:6'']				 = <cms:mod type="link"	 id="6" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linkurl:6'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidetitle:6'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidedesc:6'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidesummary:6'',$cflex_temp_elmt_str)) { \r\n			$elements[''linkurl:6'']			= <cms:mod type="link"	id="6" addslashes="true" mode="url" menuoptions="false" />; \r\n    	$elements[''linksfsidetitle:6''] = cflex_getSFSideTitle($elements[''linkurl:6'']);\r\n        $elements[''linksfsidedesc:6''] = cflex_getSFSideDesc($elements[''linkurl:6'']);\r\n        $elements[''linksfsidesummary:6''] = cflex_getSFSideSummary($elements[''linkurl:6'']);\r\n		}\r\n		if (cflex_chkelmt(''linkdesc:6'',$cflex_temp_elmt_str)) { $elements[''linkdesc:6'']		 = <cms:mod type="link"	 id="6" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linktarget:6'',$cflex_temp_elmt_str)) { $elements[''linktarget:6'']	 = <cms:mod type="link"	 id="6" addslashes="true" mode="target" menuoptions="false" />; }\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editlink:6'',$cflex_temp_elmt_str)) { $elements[''editlink:6'']		 = <cms:mod type="link"				id="6" title="MOD_VALUE[8048]" mode="editbutton" addslashes="true" menuoptions="false" />; }\r\n}\r\nif (cflex_chkelmt(''editlink:7'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''link:7'',$cflex_temp_elmt_str)) { $elements[''link:7'']				 = <cms:mod type="link"	 id="7" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linkurl:7'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidetitle:7'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidedesc:7'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidesummary:7'',$cflex_temp_elmt_str)) { \r\n			$elements[''linkurl:7'']			= <cms:mod type="link"	id="7" addslashes="true" mode="url" menuoptions="false" />; \r\n    	$elements[''linksfsidetitle:7''] = cflex_getSFSideTitle($elements[''linkurl:7'']);\r\n        $elements[''linksfsidedesc:7''] = cflex_getSFSideDesc($elements[''linkurl:7'']);\r\n        $elements[''linksfsidesummary:7''] = cflex_getSFSideSummary($elements[''linkurl:7'']);\r\n		}\r\n		if (cflex_chkelmt(''linkdesc:7'',$cflex_temp_elmt_str)) { $elements[''linkdesc:7'']		 = <cms:mod type="link"	 id="7" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linktarget:7'',$cflex_temp_elmt_str)) { $elements[''linktarget:7'']	 = <cms:mod type="link"	 id="7" addslashes="true" mode="target" menuoptions="false" />; }\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editlink:7'',$cflex_temp_elmt_str)) { $elements[''editlink:7'']		 = <cms:mod type="link"				id="7" title="MOD_VALUE[8049]" mode="editbutton" addslashes="true" menuoptions="false" />; }\r\n}\r\nif (cflex_chkelmt(''editlink:8'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''link:8'',$cflex_temp_elmt_str)) { $elements[''link:8'']				 = <cms:mod type="link"	 id="8" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linkurl:8'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidetitle:8'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidedesc:8'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidesummary:8'',$cflex_temp_elmt_str)) { \r\n			$elements[''linkurl:8'']			= <cms:mod type="link"	id="8" addslashes="true" mode="url" menuoptions="false" />; \r\n    	$elements[''linksfsidetitle:8''] = cflex_getSFSideTitle($elements[''linkurl:8'']);\r\n        $elements[''linksfsidedesc:8''] = cflex_getSFSideDesc($elements[''linkurl:8'']);\r\n        $elements[''linksfsidesummary:8''] = cflex_getSFSideSummary($elements[''linkurl:8'']);\r\n		}\r\n		if (cflex_chkelmt(''linkdesc:8'',$cflex_temp_elmt_str)) { $elements[''linkdesc:8'']		 = <cms:mod type="link"	 id="8" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linktarget:8'',$cflex_temp_elmt_str)) { $elements[''linktarget:8'']	 = <cms:mod type="link"	 id="8" addslashes="true" mode="target" menuoptions="false" />; }\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editlink:8'',$cflex_temp_elmt_str)) { $elements[''editlink:8'']		 = <cms:mod type="link"				id="8" title="MOD_VALUE[8050]" mode="editbutton" addslashes="true" menuoptions="false" />; }\r\n}\r\nif (cflex_chkelmt(''editlink:9'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''link:9'',$cflex_temp_elmt_str)) { $elements[''link:9'']				 = <cms:mod type="link"	 id="9" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linkurl:9'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidetitle:9'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidedesc:9'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidesummary:9'',$cflex_temp_elmt_str)) { \r\n			$elements[''linkurl:9'']			= <cms:mod type="link"	id="9" addslashes="true" mode="url" menuoptions="false" />; \r\n    	$elements[''linksfsidetitle:9''] = cflex_getSFSideTitle($elements[''linkurl:9'']);\r\n        $elements[''linksfsidedesc:9''] = cflex_getSFSideDesc($elements[''linkurl:9'']);\r\n        $elements[''linksfsidesummary:9''] = cflex_getSFSideSummary($elements[''linkurl:9'']);\r\n		}\r\n		if (cflex_chkelmt(''linkdesc:9'',$cflex_temp_elmt_str)) { $elements[''linkdesc:9'']		 = <cms:mod type="link"	 id="9" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linktarget:9'',$cflex_temp_elmt_str)) { $elements[''linktarget:9'']	 = <cms:mod type="link"	 id="9" addslashes="true" mode="target" menuoptions="false" />; }\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editlink:9'',$cflex_temp_elmt_str)) { $elements[''editlink:9'']		 = <cms:mod type="link"				id="9" title="MOD_VALUE[8051]" mode="editbutton" addslashes="true" menuoptions="false" />; }\r\n}\r\nif (cflex_chkelmt(''editlink:10'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''link:10'',$cflex_temp_elmt_str)) { $elements[''link:10'']				 = <cms:mod type="link"	 id="10" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linkurl:10'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidetitle:10'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidedesc:10'',$cflex_temp_elmt_str) || cflex_chkelmt(''linksfsidesummary:10'',$cflex_temp_elmt_str)) { \r\n			$elements[''linkurl:10'']			= <cms:mod type="link"	id="10" addslashes="true" mode="url" menuoptions="false" />; \r\n    	$elements[''linksfsidetitle:10''] = cflex_getSFSideTitle($elements[''linkurl:10'']);\r\n        $elements[''linksfsidedesc:10''] = cflex_getSFSideDesc($elements[''linkurl:10'']);\r\n        $elements[''linksfsidesummary:10''] = cflex_getSFSideSummary($elements[''linkurl:10'']);\r\n		}\r\n		if (cflex_chkelmt(''linkdesc:10'',$cflex_temp_elmt_str)) { $elements[''linkdesc:10'']		 = <cms:mod type="link"	 id="10" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''linktarget:10'',$cflex_temp_elmt_str)) { $elements[''linktarget:10'']	 = <cms:mod type="link"	 id="10" addslashes="true" mode="target" menuoptions="false" />; }\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editlink:10'',$cflex_temp_elmt_str)) { $elements[''editlink:10'']		 = <cms:mod type="link"				id="10" title="MOD_VALUE[8052]" mode="editbutton" addslashes="true" menuoptions="false" />; }\r\n}\r\n\r\n\r\nif (cflex_chkelmt(''editimage:1'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''imagesize:1'',$cflex_temp_elmt_str)) { $elements[''imagesize:1''] = cflex_getfsize(<cms:mod type="image" id="1" addslashes="true" mode="path" menuoptions="false">); }\r\n		\r\n		if (cflex_chkelmt(''image:1'',$cflex_temp_elmt_str)) { $elements[''image:1'']				= <cms:mod type="image" id="1" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageurl:1'',$cflex_temp_elmt_str)) { $elements[''imageurl:1'']		 = <cms:mod type="image" id="1" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagename:1'',$cflex_temp_elmt_str)) { $elements[''imagename:1'']		 = basename(<cms:mod type="image" id="1" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''imagewidth:1'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:1'',$cflex_temp_elmt_str)) { $elements[''imagewidth:1'']	= <cms:mod type="image" id="1" addslashes="true" mode="width" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageheight:1'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:1'',$cflex_temp_elmt_str)) { $elements[''imageheight:1''] = <cms:mod type="image" id="1" addslashes="true" mode="height" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagedesc:1'',$cflex_temp_elmt_str)) { $elements[''imagedesc:1'']		= <cms:mod type="image" id="1" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumb:1'',$cflex_temp_elmt_str)) { $elements[''imagethumb:1'']	 = <cms:mod type="image" id="1" addslashes="true" mode="thumb" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmtitle:1'',$cflex_temp_elmt_str)) { $elements[''imagefmtitle:1''] = <cms:mod type="image" id="1" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmdesc:1'',$cflex_temp_elmt_str)) { $elements[''imagefmdesc:1'']	 = <cms:mod type="image" id="1" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n\r\n		if (cflex_chkelmt(''imagethumbwidth:1'',$cflex_temp_elmt_str)) { $elements[''imagethumbwidth:1'']	 = <cms:mod type="image" id="1" addslashes="true" mode="thumbwidth" menuoptions="false" />; $elements[''imagethumbhalfwidth:1'']=round($elements[''imagethumbwidth:1'']/2);}\r\n		if (cflex_chkelmt(''imagethumbheight:1'',$cflex_temp_elmt_str)) { $elements[''imagethumbheight:1''] = <cms:mod type="image" id="1" addslashes="true" mode="thumbheight" menuoptions="false" />; $elements[''imagethumbhalfwidth:1'']=round($elements[''imagethumbheight:1'']/2);}\r\n		if ((float) str_replace(''01.'','''',$cfg_cms[''version''])>4) {\r\n			if (cflex_chkelmt(''imagethumburl:1'',$cflex_temp_elmt_str)) { $elements[''imagethumburl:1'']		 = <cms:mod type="image" id="1" addslashes="true" mode="thumburl" menuoptions="false" />; }\r\n		} else {\r\n			if (cflex_chkelmt(''imagethumburl:1'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbwidth:1'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbheight:1'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfheight:1'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfwidth:1'',$cflex_temp_elmt_str)) {\r\n				$elements[''imageurl:1''] = <cms:mod type="image" id="1" addslashes="true" mode="url" menuoptions="false" />;\r\n				if (!empty($elements[''imageurl:1''])) {\r\n					$elements[''imagethumburl:1''] = substr($elements[''imageurl:1''],0,strrpos($elements[''imageurl:1''],''.'')).$cfg_client[''thumbext''].substr($elements[''imageurl:1''],strrpos($elements[''imageurl:1''],''.''));\r\n				\r\n					$imagesize = getimagesize(str_replace($cfg_client[''htmlpath''],$cfg_client[''path''],$elements[''imagethumburl:1'']));\r\n					$elements[''imagethumbwidth:1'']=$imagesize[0];\r\n					$elements[''imagethumbheight:1'']=$imagesize[1];\r\n					$elements[''imagethumbhalfwidth:1'']=round($imagesize[0]/2);\r\n					$elements[''imagethumbhalfheight:1'']=round($imagesize[1]/2);\r\n				} else {\r\n					$elements[''imagethumburl:1''] = '''';\r\n					$elements[''imagethumbwidth:1'']='''';\r\n					$elements[''imagethumbheight:1'']='''';\r\n					$elements[''imagethumbhalfwidth:1'']='''';\r\n					$elements[''imagethumbhalfheight:1'']='''';\r\n				}\r\n			}\r\n		}\r\n		if (cflex_chkelmt(''imagethumbpath:1'',$cflex_temp_elmt_str)) { $elements[''imagethumbpath:1'']		 = <cms:mod type="image" id="1" addslashes="true" mode="thumbpath" menuoptions="false" />; }\r\n\r\n		if (cflex_chkelmt(''imagethumbamplitude:1'',$cflex_temp_elmt_str)) { $elements[''imagethumbamplitude:1'']		 = <cms:mod type="image" id="1" addslashes="true" mode="thumbamplitude" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageid:1'',$cflex_temp_elmt_str)) { $elements[''imageid:1'']		 = <cms:mod type="image" id="1" addslashes="true" mode="id" menuoptions="false" />; }\r\n																									\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editimage:1'',$cflex_temp_elmt_str)) { $elements[''editimage:1'']		= <cms:mod type="image"			 id="1" title="MOD_VALUE[24]" mode="editbutton" filetypes = "MOD_VALUE[15]" folders = "MOD_VALUE[16]" subfolders ="MOD_VALUE[17]" addslashes="true" menuoptions="false" />; }\r\n}\r\nif (cflex_chkelmt(''editimage:2'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''imagesize:2'',$cflex_temp_elmt_str)) { $elements[''imagesize:2''] = cflex_getfsize(<cms:mod type="image" id="2" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''image:2'',$cflex_temp_elmt_str)) { $elements[''image:2'']				= <cms:mod type="image" id="2" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageurl:2'',$cflex_temp_elmt_str)) { $elements[''imageurl:2'']		 = <cms:mod type="image" id="2" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagename:2'',$cflex_temp_elmt_str)) { $elements[''imagename:2'']		 = basename(<cms:mod type="image" id="2" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''imagewidth:2'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:2'',$cflex_temp_elmt_str)) { $elements[''imagewidth:2'']	= <cms:mod type="image" id="2" addslashes="true" mode="width" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageheight:2'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:2'',$cflex_temp_elmt_str)) { $elements[''imageheight:2''] = <cms:mod type="image" id="2" addslashes="true" mode="height" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagedesc:2'',$cflex_temp_elmt_str)) { $elements[''imagedesc:2'']		= <cms:mod type="image" id="2" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumb:2'',$cflex_temp_elmt_str)) { $elements[''imagethumb:2'']	 = <cms:mod type="image" id="2" addslashes="true" mode="thumb" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmtitle:2'',$cflex_temp_elmt_str)) { $elements[''imagefmtitle:2''] = <cms:mod type="image" id="2" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmdesc:2'',$cflex_temp_elmt_str)) { $elements[''imagefmdesc:2'']	 = <cms:mod type="image" id="2" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n\r\n		if (cflex_chkelmt(''imagethumbwidth:2'',$cflex_temp_elmt_str)) { $elements[''imagethumbwidth:2'']	 = <cms:mod type="image" id="2" addslashes="true" mode="thumbwidth" menuoptions="false" />; $elements[''imagethumbhalfwidth:2'']=round($elements[''imagethumbwidth:2'']/2);}\r\n		if (cflex_chkelmt(''imagethumbheight:2'',$cflex_temp_elmt_str)) { $elements[''imagethumbheight:2''] = <cms:mod type="image" id="2" addslashes="true" mode="thumbheight" menuoptions="false" />; $elements[''imagethumbhalfwidth:2'']=round($elements[''imagethumbheight:2'']/2);}\r\n		if ((float) str_replace(''01.'','''',$cfg_cms[''version''])>4) {\r\n			if (cflex_chkelmt(''imagethumburl:2'',$cflex_temp_elmt_str)) { $elements[''imagethumburl:2'']		 = <cms:mod type="image" id="2" addslashes="true" mode="thumburl" menuoptions="false" />; }\r\n		} else {\r\n			if (cflex_chkelmt(''imagethumburl:2'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbwidth:2'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbheight:2'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfheight:2'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfwidth:2'',$cflex_temp_elmt_str)) {\r\n				$elements[''imageurl:2''] = <cms:mod type="image" id="2" addslashes="true" mode="url" menuoptions="false" />;\r\n				if (!empty($elements[''imageurl:2''])) {\r\n					$elements[''imagethumburl:2''] = substr($elements[''imageurl:2''],0,strrpos($elements[''imageurl:2''],''.'')).$cfg_client[''thumbext''].substr($elements[''imageurl:2''],strrpos($elements[''imageurl:2''],''.''));\r\n					$imagesize = getimagesize(str_replace($cfg_client[''htmlpath''],$cfg_client[''path''],$elements[''imagethumburl:2'']));\r\n					$elements[''imagethumbwidth:2'']=$imagesize[0];\r\n					$elements[''imagethumbheight:2'']=$imagesize[1];\r\n					$elements[''imagethumbhalfwidth:2'']=round($imagesize[0]/2);\r\n					$elements[''imagethumbhalfheight:2'']=round($imagesize[1]/2);\r\n				} else {\r\n					$elements[''imagethumburl:2''] = '''';\r\n					$elements[''imagethumbwidth:2'']='''';\r\n					$elements[''imagethumbheight:2'']='''';\r\n					$elements[''imagethumbhalfwidth:2'']='''';\r\n					$elements[''imagethumbhalfheight:2'']='''';\r\n				}\r\n			}\r\n		}\r\n		if (cflex_chkelmt(''imagethumbpath:2'',$cflex_temp_elmt_str)) { $elements[''imagethumbpath:2'']		 = <cms:mod type="image" id="2" addslashes="true" mode="thumbpath" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumbamplitude:2'',$cflex_temp_elmt_str)) { $elements[''imagethumbamplitude:2'']		 = <cms:mod type="image" id="2" addslashes="true" mode="thumbamplitude" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageid:2'',$cflex_temp_elmt_str)) { $elements[''imageid:2'']		 = <cms:mod type="image" id="2" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		//Konfiguration\r\n		if (cflex_chkelmt(''editimage:2'',$cflex_temp_elmt_str)) { $elements[''editimage:2'']		= <cms:mod type="image"			 id="2" title="MOD_VALUE[34]" mode="editbutton" filetypes = "MOD_VALUE[15]" folders = "MOD_VALUE[16]" subfolders ="MOD_VALUE[17]" addslashes="true" menuoptions="false" />; }\r\n}\r\nif (cflex_chkelmt(''editimage:3'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''imagesize:3'',$cflex_temp_elmt_str)) { $elements[''imagesize:3''] = cflex_getfsize(<cms:mod type="image" id="3" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''image:3'',$cflex_temp_elmt_str)) { $elements[''image:3'']				= <cms:mod type="image" id="3" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageurl:3'',$cflex_temp_elmt_str)) { $elements[''imageurl:3'']		 = <cms:mod type="image" id="3" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagename:3'',$cflex_temp_elmt_str)) { $elements[''imagename:3'']		 = basename(<cms:mod type="image" id="3" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''imagewidth:3'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:3'',$cflex_temp_elmt_str)) { $elements[''imagewidth:3'']	= <cms:mod type="image" id="3" addslashes="true" mode="width" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageheight:3'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:3'',$cflex_temp_elmt_str)) { $elements[''imageheight:3''] = <cms:mod type="image" id="3" addslashes="true" mode="height" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagedesc:3'',$cflex_temp_elmt_str)) { $elements[''imagedesc:3'']		= <cms:mod type="image" id="3" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumb:3'',$cflex_temp_elmt_str)) { $elements[''imagethumb:3'']	 = <cms:mod type="image" id="3" addslashes="true" mode="thumb" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmtitle:3'',$cflex_temp_elmt_str)) { $elements[''imagefmtitle:3''] = <cms:mod type="image" id="3" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmdesc:3'',$cflex_temp_elmt_str)) { $elements[''imagefmdesc:3'']	 = <cms:mod type="image" id="3" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n\r\n		if (cflex_chkelmt(''imagethumbwidth:3'',$cflex_temp_elmt_str)) { $elements[''imagethumbwidth:3'']	 = <cms:mod type="image" id="3" addslashes="true" mode="thumbwidth" menuoptions="false" />; $elements[''imagethumbhalfwidth:3'']=round($elements[''imagethumbwidth:3'']/2);}\r\n		if (cflex_chkelmt(''imagethumbheight:3'',$cflex_temp_elmt_str)) { $elements[''imagethumbheight:3''] = <cms:mod type="image" id="3" addslashes="true" mode="thumbheight" menuoptions="false" />; $elements[''imagethumbhalfwidth:3'']=round($elements[''imagethumbheight:3'']/2);}\r\n		if ((float) str_replace(''01.'','''',$cfg_cms[''version''])>4) {\r\n			if (cflex_chkelmt(''imagethumburl:3'',$cflex_temp_elmt_str)) { $elements[''imagethumburl:3'']		 = <cms:mod type="image" id="3" addslashes="true" mode="thumburl" menuoptions="false" />; }\r\n		} else {\r\n			if (cflex_chkelmt(''imagethumburl:3'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbwidth:3'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbheight:3'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfheight:3'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfwidth:3'',$cflex_temp_elmt_str)) {\r\n				$elements[''imageurl:3''] = <cms:mod type="image" id="3" addslashes="true" mode="url" menuoptions="false" />;\r\n				if (!empty($elements[''imageurl:3''])) {\r\n					$elements[''imagethumburl:3''] = substr($elements[''imageurl:3''],0,strrpos($elements[''imageurl:3''],''.'')).$cfg_client[''thumbext''].substr($elements[''imageurl:3''],strrpos($elements[''imageurl:3''],''.''));\r\n					$imagesize = getimagesize(str_replace($cfg_client[''htmlpath''],$cfg_client[''path''],$elements[''imagethumburl:3'']));\r\n					$elements[''imagethumbwidth:3'']=$imagesize[0];\r\n					$elements[''imagethumbheight:3'']=$imagesize[1];\r\n					$elements[''imagethumbhalfwidth:3'']=round($imagesize[0]/2);\r\n					$elements[''imagethumbhalfheight:3'']=round($imagesize[1]/2);\r\n				} else {\r\n					$elements[''imagethumburl:3''] = '''';\r\n					$elements[''imagethumbwidth:3'']='''';\r\n					$elements[''imagethumbheight:3'']='''';\r\n					$elements[''imagethumbhalfwidth:3'']='''';\r\n					$elements[''imagethumbhalfheight:3'']='''';\r\n				}\r\n			}\r\n		}\r\n		if (cflex_chkelmt(''imagethumbpath:3'',$cflex_temp_elmt_str)) { $elements[''imagethumbpath:3'']		 = <cms:mod type="image" id="3" addslashes="true" mode="thumbpath" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumbamplitude:3'',$cflex_temp_elmt_str)) { $elements[''imagethumbamplitude:3'']		 = <cms:mod type="image" id="3" addslashes="true" mode="thumbamplitude" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageid:3'',$cflex_temp_elmt_str)) { $elements[''imageid:3'']		 = <cms:mod type="image" id="3" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		 //Konfiguration\r\n		if (cflex_chkelmt(''editimage:3'',$cflex_temp_elmt_str)) { $elements[''editimage:3'']		= <cms:mod type="image"			 id="3" title="MOD_VALUE[44]" mode="editbutton" filetypes = "MOD_VALUE[15]" folders = "MOD_VALUE[16]" subfolders ="MOD_VALUE[17]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\nif (cflex_chkelmt(''editimage:4'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''imagesize:4'',$cflex_temp_elmt_str)) { $elements[''imagesize:4''] = cflex_getfsize(<cms:mod type="image" id="4" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''image:4'',$cflex_temp_elmt_str)) { $elements[''image:4'']				= <cms:mod type="image" id="4" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageurl:4'',$cflex_temp_elmt_str)) { $elements[''imageurl:4'']		 = <cms:mod type="image" id="4" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagename:4'',$cflex_temp_elmt_str)) { $elements[''imagename:4'']		 = basename(<cms:mod type="image" id="4" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''imagewidth:4'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:4'',$cflex_temp_elmt_str)) { $elements[''imagewidth:4'']	= <cms:mod type="image" id="4" addslashes="true" mode="width" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageheight:4'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:4'',$cflex_temp_elmt_str)) { $elements[''imageheight:4''] = <cms:mod type="image" id="4" addslashes="true" mode="height" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagedesc:4'',$cflex_temp_elmt_str)) { $elements[''imagedesc:4'']		= <cms:mod type="image" id="4" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumb:4'',$cflex_temp_elmt_str)) { $elements[''imagethumb:4'']	 = <cms:mod type="image" id="4" addslashes="true" mode="thumb" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmtitle:4'',$cflex_temp_elmt_str)) { $elements[''imagefmtitle:4''] = <cms:mod type="image" id="4" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmdesc:4'',$cflex_temp_elmt_str)) { $elements[''imagefmdesc:4'']	 = <cms:mod type="image" id="4" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n\r\n		if (cflex_chkelmt(''imagethumbwidth:4'',$cflex_temp_elmt_str)) { $elements[''imagethumbwidth:4'']	 = <cms:mod type="image" id="4" addslashes="true" mode="thumbwidth" menuoptions="false" />; $elements[''imagethumbhalfwidth:4'']=round($elements[''imagethumbwidth:4'']/2);}\r\n		if (cflex_chkelmt(''imagethumbheight:4'',$cflex_temp_elmt_str)) { $elements[''imagethumbheight:4''] = <cms:mod type="image" id="4" addslashes="true" mode="thumbheight" menuoptions="false" />; $elements[''imagethumbhalfwidth:4'']=round($elements[''imagethumbheight:4'']/2);}\r\n		if ((float) str_replace(''01.'','''',$cfg_cms[''version''])>4) {\r\n			if (cflex_chkelmt(''imagethumburl:4'',$cflex_temp_elmt_str)) { $elements[''imagethumburl:4'']		 = <cms:mod type="image" id="4" addslashes="true" mode="thumburl" menuoptions="false" />; }\r\n		} else {\r\n			if (cflex_chkelmt(''imagethumburl:4'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbwidth:4'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbheight:4'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfheight:4'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfwidth:4'',$cflex_temp_elmt_str)) {\r\n				$elements[''imageurl:4''] = <cms:mod type="image" id="4" addslashes="true" mode="url" menuoptions="false" />;\r\n				if (!empty($elements[''imageurl:4''])) {\r\n					$elements[''imagethumburl:4''] = substr($elements[''imageurl:4''],0,strrpos($elements[''imageurl:4''],''.'')).$cfg_client[''thumbext''].substr($elements[''imageurl:4''],strrpos($elements[''imageurl:4''],''.''));\r\n					$imagesize = getimagesize(str_replace($cfg_client[''htmlpath''],$cfg_client[''path''],$elements[''imagethumburl:4'']));\r\n					$elements[''imagethumbwidth:4'']=$imagesize[0];\r\n					$elements[''imagethumbheight:4'']=$imagesize[1];\r\n					$elements[''imagethumbhalfwidth:4'']=round($imagesize[0]/2);\r\n					$elements[''imagethumbhalfheight:4'']=round($imagesize[1]/2);\r\n				} else {\r\n					$elements[''imagethumburl:4''] = '''';\r\n					$elements[''imagethumbwidth:4'']='''';\r\n					$elements[''imagethumbheight:4'']='''';\r\n					$elements[''imagethumbhalfwidth:4'']='''';\r\n					$elements[''imagethumbhalfheight:4'']='''';\r\n				}\r\n			}\r\n		}\r\n		if (cflex_chkelmt(''imagethumbpath:4'',$cflex_temp_elmt_str)) { $elements[''imagethumbpath:4'']		 = <cms:mod type="image" id="4" addslashes="true" mode="thumbpath" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumbamplitude:4'',$cflex_temp_elmt_str)) { $elements[''imagethumbamplitude:4'']		 = <cms:mod type="image" id="4" addslashes="true" mode="thumbamplitude" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageid:4'',$cflex_temp_elmt_str)) { $elements[''imageid:4'']		 = <cms:mod type="image" id="4" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		 //Konfiguration\r\n		if (cflex_chkelmt(''editimage:4'',$cflex_temp_elmt_str)) { $elements[''editimage:4'']		= <cms:mod type="image"			 id="4" title="MOD_VALUE[1044]" mode="editbutton" filetypes = "MOD_VALUE[15]" folders = "MOD_VALUE[16]" subfolders ="MOD_VALUE[17]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\nif (cflex_chkelmt(''editimage:5'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''imagesize:5'',$cflex_temp_elmt_str)) { $elements[''imagesize:5''] = cflex_getfsize(<cms:mod type="image" id="5" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''image:5'',$cflex_temp_elmt_str)) { $elements[''image:5'']				= <cms:mod type="image" id="5" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageurl:5'',$cflex_temp_elmt_str)) { $elements[''imageurl:5'']		 = <cms:mod type="image" id="5" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagename:5'',$cflex_temp_elmt_str)) { $elements[''imagename:5'']		 = basename(<cms:mod type="image" id="5" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''imagewidth:5'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:5'',$cflex_temp_elmt_str)) { $elements[''imagewidth:5'']	= <cms:mod type="image" id="5" addslashes="true" mode="width" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageheight:5'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:5'',$cflex_temp_elmt_str)) { $elements[''imageheight:5''] = <cms:mod type="image" id="5" addslashes="true" mode="height" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagedesc:5'',$cflex_temp_elmt_str)) { $elements[''imagedesc:5'']		= <cms:mod type="image" id="5" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumb:5'',$cflex_temp_elmt_str)) { $elements[''imagethumb:5'']	 = <cms:mod type="image" id="5" addslashes="true" mode="thumb" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmtitle:5'',$cflex_temp_elmt_str)) { $elements[''imagefmtitle:5''] = <cms:mod type="image" id="5" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmdesc:5'',$cflex_temp_elmt_str)) { $elements[''imagefmdesc:5'']	 = <cms:mod type="image" id="5" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n\r\n		if (cflex_chkelmt(''imagethumbwidth:5'',$cflex_temp_elmt_str)) { $elements[''imagethumbwidth:5'']	 = <cms:mod type="image" id="5" addslashes="true" mode="thumbwidth" menuoptions="false" />; $elements[''imagethumbhalfwidth:5'']=round($elements[''imagethumbwidth:5'']/2);}\r\n		if (cflex_chkelmt(''imagethumbheight:5'',$cflex_temp_elmt_str)) { $elements[''imagethumbheight:5''] = <cms:mod type="image" id="5" addslashes="true" mode="thumbheight" menuoptions="false" />; $elements[''imagethumbhalfwidth:5'']=round($elements[''imagethumbheight:5'']/2);}\r\n		if ((float) str_replace(''01.'','''',$cfg_cms[''version''])>4) {\r\n			if (cflex_chkelmt(''imagethumburl:5'',$cflex_temp_elmt_str)) { $elements[''imagethumburl:5'']		 = <cms:mod type="image" id="5" addslashes="true" mode="thumburl" menuoptions="false" />; }\r\n		} else {\r\n			if (cflex_chkelmt(''imagethumburl:5'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbwidth:5'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbheight:5'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfheight:5'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfwidth:5'',$cflex_temp_elmt_str)) {\r\n				$elements[''imageurl:5''] = <cms:mod type="image" id="5" addslashes="true" mode="url" menuoptions="false" />;\r\n				if (!empty($elements[''imageurl:5''])) {\r\n					$elements[''imagethumburl:5''] = substr($elements[''imageurl:5''],0,strrpos($elements[''imageurl:5''],''.'')).$cfg_client[''thumbext''].substr($elements[''imageurl:5''],strrpos($elements[''imageurl:5''],''.''));\r\n					$imagesize = getimagesize(str_replace($cfg_client[''htmlpath''],$cfg_client[''path''],$elements[''imagethumburl:5'']));\r\n					$elements[''imagethumbwidth:5'']=$imagesize[0];\r\n					$elements[''imagethumbheight:5'']=$imagesize[1];\r\n					$elements[''imagethumbhalfwidth:5'']=round($imagesize[0]/2);\r\n					$elements[''imagethumbhalfheight:5'']=round($imagesize[1]/2);\r\n				} else {\r\n					$elements[''imagethumburl:5''] = '''';\r\n					$elements[''imagethumbwidth:5'']='''';\r\n					$elements[''imagethumbheight:5'']='''';\r\n					$elements[''imagethumbhalfwidth:5'']='''';\r\n					$elements[''imagethumbhalfheight:5'']='''';\r\n				}\r\n			}\r\n		}\r\n		if (cflex_chkelmt(''imagethumbpath:5'',$cflex_temp_elmt_str)) { $elements[''imagethumbpath:5'']		 = <cms:mod type="image" id="5" addslashes="true" mode="thumbpath" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumbamplitude:5'',$cflex_temp_elmt_str)) { $elements[''imagethumbamplitude:5'']		 = <cms:mod type="image" id="5" addslashes="true" mode="thumbamplitude" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageid:5'',$cflex_temp_elmt_str)) { $elements[''imageid:5'']		 = <cms:mod type="image" id="5" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		 //Konfiguration\r\n		if (cflex_chkelmt(''editimage:5'',$cflex_temp_elmt_str)) { $elements[''editimage:5'']		= <cms:mod type="image"			 id="5" title="MOD_VALUE[1045]" mode="editbutton" filetypes = "MOD_VALUE[15]" folders = "MOD_VALUE[16]" subfolders ="MOD_VALUE[17]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\nif (cflex_chkelmt(''editimage:6'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''imagesize:6'',$cflex_temp_elmt_str)) { $elements[''imagesize:6''] = cflex_getfsize(<cms:mod type="image" id="6" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''image:6'',$cflex_temp_elmt_str)) { $elements[''image:6'']				= <cms:mod type="image" id="6" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageurl:6'',$cflex_temp_elmt_str)) { $elements[''imageurl:6'']		 = <cms:mod type="image" id="6" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagename:6'',$cflex_temp_elmt_str)) { $elements[''imagename:6'']		 = basename(<cms:mod type="image" id="6" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''imagewidth:6'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:6'',$cflex_temp_elmt_str)) { $elements[''imagewidth:6'']	= <cms:mod type="image" id="6" addslashes="true" mode="width" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageheight:6'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:6'',$cflex_temp_elmt_str)) { $elements[''imageheight:6''] = <cms:mod type="image" id="6" addslashes="true" mode="height" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagedesc:6'',$cflex_temp_elmt_str)) { $elements[''imagedesc:6'']		= <cms:mod type="image" id="6" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumb:6'',$cflex_temp_elmt_str)) { $elements[''imagethumb:6'']	 = <cms:mod type="image" id="6" addslashes="true" mode="thumb" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmtitle:6'',$cflex_temp_elmt_str)) { $elements[''imagefmtitle:6''] = <cms:mod type="image" id="6" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmdesc:6'',$cflex_temp_elmt_str)) { $elements[''imagefmdesc:6'']	 = <cms:mod type="image" id="6" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n\r\n		if (cflex_chkelmt(''imagethumbwidth:6'',$cflex_temp_elmt_str)) { $elements[''imagethumbwidth:6'']	 = <cms:mod type="image" id="6" addslashes="true" mode="thumbwidth" menuoptions="false" />; $elements[''imagethumbhalfwidth:6'']=round($elements[''imagethumbwidth:6'']/2);}\r\n		if (cflex_chkelmt(''imagethumbheight:6'',$cflex_temp_elmt_str)) { $elements[''imagethumbheight:6''] = <cms:mod type="image" id="6" addslashes="true" mode="thumbheight" menuoptions="false" />; $elements[''imagethumbhalfwidth:6'']=round($elements[''imagethumbheight:6'']/2);}\r\n		if ((float) str_replace(''01.'','''',$cfg_cms[''version''])>4) {\r\n			if (cflex_chkelmt(''imagethumburl:6'',$cflex_temp_elmt_str)) { $elements[''imagethumburl:6'']		 = <cms:mod type="image" id="6" addslashes="true" mode="thumburl" menuoptions="false" />; }\r\n		} else {\r\n			if (cflex_chkelmt(''imagethumburl:6'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbwidth:6'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbheight:6'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfheight:6'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfwidth:6'',$cflex_temp_elmt_str)) {\r\n				$elements[''imageurl:6''] = <cms:mod type="image" id="6" addslashes="true" mode="url" menuoptions="false" />;\r\n				if (!empty($elements[''imageurl:6''])) {\r\n					$elements[''imagethumburl:6''] = substr($elements[''imageurl:6''],0,strrpos($elements[''imageurl:6''],''.'')).$cfg_client[''thumbext''].substr($elements[''imageurl:6''],strrpos($elements[''imageurl:6''],''.''));\r\n					$imagesize = getimagesize(str_replace($cfg_client[''htmlpath''],$cfg_client[''path''],$elements[''imagethumburl:6'']));\r\n					$elements[''imagethumbwidth:6'']=$imagesize[0];\r\n					$elements[''imagethumbheight:6'']=$imagesize[1];\r\n					$elements[''imagethumbhalfwidth:6'']=round($imagesize[0]/2);\r\n					$elements[''imagethumbhalfheight:6'']=round($imagesize[1]/2);\r\n				} else {\r\n					$elements[''imagethumburl:6''] = '''';\r\n					$elements[''imagethumbwidth:6'']='''';\r\n					$elements[''imagethumbheight:6'']='''';\r\n					$elements[''imagethumbhalfwidth:6'']='''';\r\n					$elements[''imagethumbhalfheight:6'']='''';\r\n				}\r\n			}\r\n		}\r\n		if (cflex_chkelmt(''imagethumbpath:6'',$cflex_temp_elmt_str)) { $elements[''imagethumbpath:6'']		 = <cms:mod type="image" id="6" addslashes="true" mode="thumbpath" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumbamplitude:6'',$cflex_temp_elmt_str)) { $elements[''imagethumbamplitude:6'']		 = <cms:mod type="image" id="6" addslashes="true" mode="thumbamplitude" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageid:6'',$cflex_temp_elmt_str)) { $elements[''imageid:6'']		 = <cms:mod type="image" id="6" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		 //Konfiguration\r\n		if (cflex_chkelmt(''editimage:6'',$cflex_temp_elmt_str)) { $elements[''editimage:6'']		= <cms:mod type="image"			 id="6" title="MOD_VALUE[1046]" mode="editbutton" filetypes = "MOD_VALUE[15]" folders = "MOD_VALUE[16]" subfolders ="MOD_VALUE[17]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\nif (cflex_chkelmt(''editimage:7'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''imagesize:7'',$cflex_temp_elmt_str)) { $elements[''imagesize:7''] = cflex_getfsize(<cms:mod type="image" id="7" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''image:7'',$cflex_temp_elmt_str)) { $elements[''image:7'']				= <cms:mod type="image" id="7" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageurl:7'',$cflex_temp_elmt_str)) { $elements[''imageurl:7'']		 = <cms:mod type="image" id="7" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagename:7'',$cflex_temp_elmt_str)) { $elements[''imagename:7'']		 = basename(<cms:mod type="image" id="7" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''imagewidth:7'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:7'',$cflex_temp_elmt_str)) { $elements[''imagewidth:7'']	= <cms:mod type="image" id="7" addslashes="true" mode="width" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageheight:7'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:7'',$cflex_temp_elmt_str)) { $elements[''imageheight:7''] = <cms:mod type="image" id="7" addslashes="true" mode="height" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagedesc:7'',$cflex_temp_elmt_str)) { $elements[''imagedesc:7'']		= <cms:mod type="image" id="7" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumb:7'',$cflex_temp_elmt_str)) { $elements[''imagethumb:7'']	 = <cms:mod type="image" id="7" addslashes="true" mode="thumb" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmtitle:7'',$cflex_temp_elmt_str)) { $elements[''imagefmtitle:7''] = <cms:mod type="image" id="7" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmdesc:7'',$cflex_temp_elmt_str)) { $elements[''imagefmdesc:7'']	 = <cms:mod type="image" id="7" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n\r\n		if (cflex_chkelmt(''imagethumbwidth:7'',$cflex_temp_elmt_str)) { $elements[''imagethumbwidth:7'']	 = <cms:mod type="image" id="7" addslashes="true" mode="thumbwidth" menuoptions="false" />; $elements[''imagethumbhalfwidth:7'']=round($elements[''imagethumbwidth:7'']/2);}\r\n		if (cflex_chkelmt(''imagethumbheight:7'',$cflex_temp_elmt_str)) { $elements[''imagethumbheight:7''] = <cms:mod type="image" id="7" addslashes="true" mode="thumbheight" menuoptions="false" />; $elements[''imagethumbhalfwidth:7'']=round($elements[''imagethumbheight:7'']/2);}\r\n		if ((float) str_replace(''01.'','''',$cfg_cms[''version''])>4) {\r\n			if (cflex_chkelmt(''imagethumburl:7'',$cflex_temp_elmt_str)) { $elements[''imagethumburl:7'']		 = <cms:mod type="image" id="7" addslashes="true" mode="thumburl" menuoptions="false" />; }\r\n		} else {\r\n			if (cflex_chkelmt(''imagethumburl:7'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbwidth:7'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbheight:7'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfheight:7'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfwidth:7'',$cflex_temp_elmt_str)) {\r\n				$elements[''imageurl:7''] = <cms:mod type="image" id="7" addslashes="true" mode="url" menuoptions="false" />;\r\n				if (!empty($elements[''imageurl:7''])) {\r\n					$elements[''imagethumburl:7''] = substr($elements[''imageurl:7''],0,strrpos($elements[''imageurl:7''],''.'')).$cfg_client[''thumbext''].substr($elements[''imageurl:7''],strrpos($elements[''imageurl:7''],''.''));\r\n					$imagesize = getimagesize(str_replace($cfg_client[''htmlpath''],$cfg_client[''path''],$elements[''imagethumburl:7'']));\r\n					$elements[''imagethumbwidth:7'']=$imagesize[0];\r\n					$elements[''imagethumbheight:7'']=$imagesize[1];\r\n					$elements[''imagethumbhalfwidth:7'']=round($imagesize[0]/2);\r\n					$elements[''imagethumbhalfheight:7'']=round($imagesize[1]/2);\r\n				} else {\r\n					$elements[''imagethumburl:7''] = '''';\r\n					$elements[''imagethumbwidth:7'']='''';\r\n					$elements[''imagethumbheight:7'']='''';\r\n					$elements[''imagethumbhalfwidth:7'']='''';\r\n					$elements[''imagethumbhalfheight:7'']='''';\r\n				}\r\n			}\r\n		}\r\n		if (cflex_chkelmt(''imagethumbpath:7'',$cflex_temp_elmt_str)) { $elements[''imagethumbpath:7'']		 = <cms:mod type="image" id="7" addslashes="true" mode="thumbpath" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumbamplitude:7'',$cflex_temp_elmt_str)) { $elements[''imagethumbamplitude:7'']		 = <cms:mod type="image" id="7" addslashes="true" mode="thumbamplitude" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageid:7'',$cflex_temp_elmt_str)) { $elements[''imageid:7'']		 = <cms:mod type="image" id="7" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		 //Konfiguration\r\n		if (cflex_chkelmt(''editimage:7'',$cflex_temp_elmt_str)) { $elements[''editimage:7'']		= <cms:mod type="image"			 id="7" title="MOD_VALUE[1047]" mode="editbutton" filetypes = "MOD_VALUE[15]" folders = "MOD_VALUE[16]" subfolders ="MOD_VALUE[17]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\nif (cflex_chkelmt(''editimage:8'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''imagesize:8'',$cflex_temp_elmt_str)) { $elements[''imagesize:8''] = cflex_getfsize(<cms:mod type="image" id="8" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''image:8'',$cflex_temp_elmt_str)) { $elements[''image:8'']				= <cms:mod type="image" id="8" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageurl:8'',$cflex_temp_elmt_str)) { $elements[''imageurl:8'']		 = <cms:mod type="image" id="8" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagename:8'',$cflex_temp_elmt_str)) { $elements[''imagename:8'']		 = basename(<cms:mod type="image" id="8" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''imagewidth:8'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:8'',$cflex_temp_elmt_str)) { $elements[''imagewidth:8'']	= <cms:mod type="image" id="8" addslashes="true" mode="width" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageheight:8'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:8'',$cflex_temp_elmt_str)) { $elements[''imageheight:8''] = <cms:mod type="image" id="8" addslashes="true" mode="height" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagedesc:8'',$cflex_temp_elmt_str)) { $elements[''imagedesc:8'']		= <cms:mod type="image" id="8" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumb:8'',$cflex_temp_elmt_str)) { $elements[''imagethumb:8'']	 = <cms:mod type="image" id="8" addslashes="true" mode="thumb" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmtitle:8'',$cflex_temp_elmt_str)) { $elements[''imagefmtitle:8''] = <cms:mod type="image" id="8" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmdesc:8'',$cflex_temp_elmt_str)) { $elements[''imagefmdesc:8'']	 = <cms:mod type="image" id="8" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n\r\n		if (cflex_chkelmt(''imagethumbwidth:8'',$cflex_temp_elmt_str)) { $elements[''imagethumbwidth:8'']	 = <cms:mod type="image" id="8" addslashes="true" mode="thumbwidth" menuoptions="false" />; $elements[''imagethumbhalfwidth:8'']=round($elements[''imagethumbwidth:8'']/2);}\r\n		if (cflex_chkelmt(''imagethumbheight:8'',$cflex_temp_elmt_str)) { $elements[''imagethumbheight:8''] = <cms:mod type="image" id="8" addslashes="true" mode="thumbheight" menuoptions="false" />; $elements[''imagethumbhalfwidth:8'']=round($elements[''imagethumbheight:8'']/2);}\r\n		if ((float) str_replace(''01.'','''',$cfg_cms[''version''])>4) {\r\n			if (cflex_chkelmt(''imagethumburl:8'',$cflex_temp_elmt_str)) { $elements[''imagethumburl:8'']		 = <cms:mod type="image" id="8" addslashes="true" mode="thumburl" menuoptions="false" />; }\r\n		} else {\r\n			if (cflex_chkelmt(''imagethumburl:8'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbwidth:8'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbheight:8'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfheight:8'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfwidth:8'',$cflex_temp_elmt_str)) {\r\n				$elements[''imageurl:8''] = <cms:mod type="image" id="8" addslashes="true" mode="url" menuoptions="false" />;\r\n				if (!empty($elements[''imageurl:8''])) {\r\n					$elements[''imagethumburl:8''] = substr($elements[''imageurl:8''],0,strrpos($elements[''imageurl:8''],''.'')).$cfg_client[''thumbext''].substr($elements[''imageurl:8''],strrpos($elements[''imageurl:8''],''.''));\r\n					$imagesize = getimagesize(str_replace($cfg_client[''htmlpath''],$cfg_client[''path''],$elements[''imagethumburl:8'']));\r\n					$elements[''imagethumbwidth:8'']=$imagesize[0];\r\n					$elements[''imagethumbheight:8'']=$imagesize[1];\r\n					$elements[''imagethumbhalfwidth:8'']=round($imagesize[0]/2);\r\n					$elements[''imagethumbhalfheight:8'']=round($imagesize[1]/2);\r\n				} else {\r\n					$elements[''imagethumburl:8''] = '''';\r\n					$elements[''imagethumbwidth:8'']='''';\r\n					$elements[''imagethumbheight:8'']='''';\r\n					$elements[''imagethumbhalfwidth:8'']='''';\r\n					$elements[''imagethumbhalfheight:8'']='''';\r\n				}\r\n			}\r\n		}\r\n		if (cflex_chkelmt(''imagethumbpath:8'',$cflex_temp_elmt_str)) { $elements[''imagethumbpath:8'']		 = <cms:mod type="image" id="8" addslashes="true" mode="thumbpath" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumbamplitude:8'',$cflex_temp_elmt_str)) { $elements[''imagethumbamplitude:8'']		 = <cms:mod type="image" id="8" addslashes="true" mode="thumbamplitude" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageid:8'',$cflex_temp_elmt_str)) { $elements[''imageid:8'']		 = <cms:mod type="image" id="8" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		 //Konfiguration\r\n		if (cflex_chkelmt(''editimage:8'',$cflex_temp_elmt_str)) { $elements[''editimage:8'']		= <cms:mod type="image"			 id="8" title="MOD_VALUE[1048]" mode="editbutton" filetypes = "MOD_VALUE[15]" folders = "MOD_VALUE[16]" subfolders ="MOD_VALUE[17]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\nif (cflex_chkelmt(''editimage:9'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''imagesize:9'',$cflex_temp_elmt_str)) { $elements[''imagesize:9''] = cflex_getfsize(<cms:mod type="image" id="9" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''image:9'',$cflex_temp_elmt_str)) { $elements[''image:9'']				= <cms:mod type="image" id="9" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageurl:9'',$cflex_temp_elmt_str)) { $elements[''imageurl:9'']		 = <cms:mod type="image" id="9" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagename:9'',$cflex_temp_elmt_str)) { $elements[''imagename:9'']		 = basename(<cms:mod type="image" id="9" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''imagewidth:9'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:9'',$cflex_temp_elmt_str)) { $elements[''imagewidth:9'']	= <cms:mod type="image" id="9" addslashes="true" mode="width" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageheight:9'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:9'',$cflex_temp_elmt_str)) { $elements[''imageheight:9''] = <cms:mod type="image" id="9" addslashes="true" mode="height" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagedesc:9'',$cflex_temp_elmt_str)) { $elements[''imagedesc:9'']		= <cms:mod type="image" id="9" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumb:9'',$cflex_temp_elmt_str)) { $elements[''imagethumb:9'']	 = <cms:mod type="image" id="9" addslashes="true" mode="thumb" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmtitle:9'',$cflex_temp_elmt_str)) { $elements[''imagefmtitle:9''] = <cms:mod type="image" id="9" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmdesc:9'',$cflex_temp_elmt_str)) { $elements[''imagefmdesc:9'']	 = <cms:mod type="image" id="9" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n\r\n		if (cflex_chkelmt(''imagethumbwidth:9'',$cflex_temp_elmt_str)) { $elements[''imagethumbwidth:9'']	 = <cms:mod type="image" id="9" addslashes="true" mode="thumbwidth" menuoptions="false" />; $elements[''imagethumbhalfwidth:9'']=round($elements[''imagethumbwidth:9'']/2);}\r\n		if (cflex_chkelmt(''imagethumbheight:9'',$cflex_temp_elmt_str)) { $elements[''imagethumbheight:9''] = <cms:mod type="image" id="9" addslashes="true" mode="thumbheight" menuoptions="false" />; $elements[''imagethumbhalfwidth:9'']=round($elements[''imagethumbheight:9'']/2);}\r\n		if ((float) str_replace(''01.'','''',$cfg_cms[''version''])>4) {\r\n			if (cflex_chkelmt(''imagethumburl:9'',$cflex_temp_elmt_str)) { $elements[''imagethumburl:9'']		 = <cms:mod type="image" id="9" addslashes="true" mode="thumburl" menuoptions="false" />; }\r\n		} else {\r\n			if (cflex_chkelmt(''imagethumburl:9'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbwidth:9'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbheight:9'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfheight:9'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfwidth:9'',$cflex_temp_elmt_str)) {\r\n				$elements[''imageurl:9''] = <cms:mod type="image" id="9" addslashes="true" mode="url" menuoptions="false" />;\r\n				if (!empty($elements[''imageurl:9''])) {\r\n					$elements[''imagethumburl:9''] = substr($elements[''imageurl:9''],0,strrpos($elements[''imageurl:9''],''.'')).$cfg_client[''thumbext''].substr($elements[''imageurl:9''],strrpos($elements[''imageurl:9''],''.''));\r\n					$imagesize = getimagesize(str_replace($cfg_client[''htmlpath''],$cfg_client[''path''],$elements[''imagethumburl:9'']));\r\n					$elements[''imagethumbwidth:9'']=$imagesize[0];\r\n					$elements[''imagethumbheight:9'']=$imagesize[1];\r\n					$elements[''imagethumbhalfwidth:9'']=round($imagesize[0]/2);\r\n					$elements[''imagethumbhalfheight:9'']=round($imagesize[1]/2);\r\n				} else {\r\n					$elements[''imagethumburl:9''] = '''';\r\n					$elements[''imagethumbwidth:9'']='''';\r\n					$elements[''imagethumbheight:9'']='''';\r\n					$elements[''imagethumbhalfwidth:9'']='''';\r\n					$elements[''imagethumbhalfheight:9'']='''';\r\n				}\r\n			}\r\n		}\r\n		if (cflex_chkelmt(''imagethumbpath:9'',$cflex_temp_elmt_str)) { $elements[''imagethumbpath:9'']		 = <cms:mod type="image" id="9" addslashes="true" mode="thumbpath" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumbamplitude:9'',$cflex_temp_elmt_str)) { $elements[''imagethumbamplitude:9'']		 = <cms:mod type="image" id="9" addslashes="true" mode="thumbamplitude" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageid:9'',$cflex_temp_elmt_str)) { $elements[''imageid:9'']		 = <cms:mod type="image" id="9" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		 //Konfiguration\r\n		if (cflex_chkelmt(''editimage:9'',$cflex_temp_elmt_str)) { $elements[''editimage:9'']		= <cms:mod type="image"			 id="9" title="MOD_VALUE[1049]" mode="editbutton" filetypes = "MOD_VALUE[15]" folders = "MOD_VALUE[16]" subfolders ="MOD_VALUE[17]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\nif (cflex_chkelmt(''editimage:10'',$cflex_temp_elmt_str)) {\r\n		if (cflex_chkelmt(''imagesize:10'',$cflex_temp_elmt_str)) { $elements[''imagesize:10''] = cflex_getfsize(<cms:mod type="image" id="10" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''image:10'',$cflex_temp_elmt_str)) { $elements[''image:10'']				= <cms:mod type="image" id="10" addslashes="true" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageurl:10'',$cflex_temp_elmt_str)) { $elements[''imageurl:10'']		 = <cms:mod type="image" id="10" addslashes="true" mode="url" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagename:10'',$cflex_temp_elmt_str)) { $elements[''imagename:10'']		 = basename(<cms:mod type="image" id="10" addslashes="true" mode="path" menuoptions="false">); }\r\n		if (cflex_chkelmt(''imagewidth:10'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:10'',$cflex_temp_elmt_str)) { $elements[''imagewidth:10'']	= <cms:mod type="image" id="10" addslashes="true" mode="width" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageheight:10'',$cflex_temp_elmt_str) || \r\n				cflex_chkelmt(''imagedimensions:10'',$cflex_temp_elmt_str)) { $elements[''imageheight:10''] = <cms:mod type="image" id="10" addslashes="true" mode="height" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagedesc:10'',$cflex_temp_elmt_str)) { $elements[''imagedesc:10'']		= <cms:mod type="image" id="10" addslashes="true" mode="desc" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumb:10'',$cflex_temp_elmt_str)) { $elements[''imagethumb:10'']	 = <cms:mod type="image" id="10" addslashes="true" mode="thumb" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmtitle:10'',$cflex_temp_elmt_str)) { $elements[''imagefmtitle:10''] = <cms:mod type="image" id="10" addslashes="true" mode="fmtitle" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagefmdesc:10'',$cflex_temp_elmt_str)) { $elements[''imagefmdesc:10'']	 = <cms:mod type="image" id="10" addslashes="true" mode="fmdesc" menuoptions="false" />; }\r\n\r\n		if (cflex_chkelmt(''imagethumbwidth:10'',$cflex_temp_elmt_str)) { $elements[''imagethumbwidth:10'']	 = <cms:mod type="image" id="10" addslashes="true" mode="thumbwidth" menuoptions="false" />; $elements[''imagethumbhalfwidth:10'']=round($elements[''imagethumbwidth:10'']/2);}\r\n		if (cflex_chkelmt(''imagethumbheight:10'',$cflex_temp_elmt_str)) { $elements[''imagethumbheight:10''] = <cms:mod type="image" id="10" addslashes="true" mode="thumbheight" menuoptions="false" />; $elements[''imagethumbhalfwidth:10'']=round($elements[''imagethumbheight:10'']/2);}\r\n		if ((float) str_replace(''01.'','''',$cfg_cms[''version''])>4) {\r\n			if (cflex_chkelmt(''imagethumburl:10'',$cflex_temp_elmt_str)) { $elements[''imagethumburl:10'']		 = <cms:mod type="image" id="10" addslashes="true" mode="thumburl" menuoptions="false" />; }\r\n		} else {\r\n			if (cflex_chkelmt(''imagethumburl:10'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbwidth:10'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbheight:10'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfheight:10'',$cflex_temp_elmt_str) ||\r\n					cflex_chkelmt(''imagethumbhalfwidth:10'',$cflex_temp_elmt_str)) {\r\n				$elements[''imageurl:10''] = <cms:mod type="image" id="10" addslashes="true" mode="url" menuoptions="false" />;\r\n				if (!empty($elements[''imageurl:10''])) {\r\n					$elements[''imagethumburl:10''] = substr($elements[''imageurl:10''],0,strrpos($elements[''imageurl:10''],''.'')).$cfg_client[''thumbext''].substr($elements[''imageurl:10''],strrpos($elements[''imageurl:10''],''.''));\r\n					$imagesize = getimagesize(str_replace($cfg_client[''htmlpath''],$cfg_client[''path''],$elements[''imagethumburl:10'']));\r\n					$elements[''imagethumbwidth:10'']=$imagesize[0];\r\n					$elements[''imagethumbheight:10'']=$imagesize[1];\r\n					$elements[''imagethumbhalfwidth:10'']=round($imagesize[0]/2);\r\n					$elements[''imagethumbhalfheight:10'']=round($imagesize[1]/2);\r\n				} else {\r\n					$elements[''imagethumburl:10''] = '''';\r\n					$elements[''imagethumbwidth:10'']='''';\r\n					$elements[''imagethumbheight:10'']='''';\r\n					$elements[''imagethumbhalfwidth:10'']='''';\r\n					$elements[''imagethumbhalfheight:10'']='''';\r\n				}\r\n			}\r\n		}\r\n		if (cflex_chkelmt(''imagethumbpath:10'',$cflex_temp_elmt_str)) { $elements[''imagethumbpath:10'']		 = <cms:mod type="image" id="10" addslashes="true" mode="thumbpath" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imagethumbamplitude:10'',$cflex_temp_elmt_str)) { $elements[''imagethumbamplitude:10'']		 = <cms:mod type="image" id="10" addslashes="true" mode="thumbamplitude" menuoptions="false" />; }\r\n		if (cflex_chkelmt(''imageid:10'',$cflex_temp_elmt_str)) { $elements[''imageid:10'']		 = <cms:mod type="image" id="10" addslashes="true" mode="id" menuoptions="false" />; }\r\n\r\n		 //Konfiguration\r\n		if (cflex_chkelmt(''editimage:10'',$cflex_temp_elmt_str)) { $elements[''editimage:10'']		= <cms:mod type="image"			 id="10" title="MOD_VALUE[1050]" mode="editbutton" filetypes = "MOD_VALUE[15]" folders = "MOD_VALUE[16]" subfolders ="MOD_VALUE[17]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\n//Gibt es mehrere Tags, bei denen type und id gleich sind, ist es wichtig, dass das letzt "gleiche" Element alle erweiterten\r\n//Konfigurationsvariablen enthaelt (z.B. folders, subfolders) . Den nur die Variablen des "letzten" Tags koennen im Formular\r\n//weiterverarbeitet werden. Andernfalls bleibt z.B. die Auswahl von bestimmten Dateitypen ohne Wirkung.\r\nif (cflex_chkelmt(''text:'',$cflex_temp_elmt_str)) {\r\n	if (cflex_chkelmt(''text:1'',$cflex_temp_elmt_str)) { $elements[''text:1'']				 = <cms:mod type="text"				id="1" title="MOD_VALUE[20]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''text:2'',$cflex_temp_elmt_str)) { $elements[''text:2'']				 = <cms:mod type="text"				id="2" title="MOD_VALUE[30]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''text:3'',$cflex_temp_elmt_str)) { $elements[''text:3'']				 = <cms:mod type="text"				id="3" title="MOD_VALUE[40]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''text:4'',$cflex_temp_elmt_str)) { $elements[''text:4'']				 = <cms:mod type="text"				id="4" title="MOD_VALUE[47]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''text:5'',$cflex_temp_elmt_str)) { $elements[''text:5'']				 = <cms:mod type="text"				id="5" title="MOD_VALUE[48]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''text:6'',$cflex_temp_elmt_str)) { $elements[''text:6'']				 = <cms:mod type="text"				id="6" title="MOD_VALUE[87]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''text:7'',$cflex_temp_elmt_str)) { $elements[''text:7'']				 = <cms:mod type="text"				id="7" title="MOD_VALUE[88]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''text:8'',$cflex_temp_elmt_str)) { $elements[''text:8'']				 = <cms:mod type="text"				id="8" title="MOD_VALUE[89]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''text:9'',$cflex_temp_elmt_str)) { $elements[''text:9'']				 = <cms:mod type="text"				id="9" title="MOD_VALUE[90]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''text:10'',$cflex_temp_elmt_str)) { $elements[''text:10'']				 = <cms:mod type="text"				id="10" title="MOD_VALUE[6090]" addslashes="true" menuoptions="false" />; }\r\n}\r\nif (cflex_chkelmt(''textarea'',$cflex_temp_elmt_str)) {\r\n	if (cflex_chkelmt(''textarea:1'',$cflex_temp_elmt_str)) { $elements[''textarea:1'']		 = <cms:mod type="textarea"		id="1" title="MOD_VALUE[21]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''textarea:2'',$cflex_temp_elmt_str)) { $elements[''textarea:2'']		 = <cms:mod type="textarea"		id="2" title="MOD_VALUE[31]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''textarea:3'',$cflex_temp_elmt_str)) { $elements[''textarea:3'']		 = <cms:mod type="textarea"		id="3" title="MOD_VALUE[41]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''textarea:4'',$cflex_temp_elmt_str)) { $elements[''textarea:4'']		 = <cms:mod type="textarea"		id="4" title="MOD_VALUE[91]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''textarea:5'',$cflex_temp_elmt_str)) { $elements[''textarea:5'']		 = <cms:mod type="textarea"		id="5" title="MOD_VALUE[92]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''textarea:6'',$cflex_temp_elmt_str)) { $elements[''textarea:6'']		 = <cms:mod type="textarea"		id="6" title="MOD_VALUE[93]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''textarea:7'',$cflex_temp_elmt_str)) { $elements[''textarea:7'']		 = <cms:mod type="textarea"		id="7" title="MOD_VALUE[7093]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''textarea:8'',$cflex_temp_elmt_str)) { $elements[''textarea:8'']		 = <cms:mod type="textarea"		id="8" title="MOD_VALUE[7094]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''textarea:9'',$cflex_temp_elmt_str)) { $elements[''textarea:9'']		 = <cms:mod type="textarea"		id="9" title="MOD_VALUE[7095]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''textarea:10'',$cflex_temp_elmt_str)) { $elements[''textarea:10'']		 = <cms:mod type="textarea"		id="10" title="MOD_VALUE[7096]" addslashes="true" menuoptions="false" />; }\r\n}\r\n\r\nif (cflex_chkelmt(''wysiwyg'',$cflex_temp_elmt_str)) {\r\n	if (cflex_chkelmt(''wysiwyg:1'',$cflex_temp_elmt_str)) { $elements[''wysiwyg:1'']			= <cms:mod type="wysiwyg"		 id="1" title="MOD_VALUE[22]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''wysiwyg:2'',$cflex_temp_elmt_str)) { $elements[''wysiwyg:2'']			= <cms:mod type="wysiwyg"		 id="2" title="MOD_VALUE[32]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''wysiwyg:3'',$cflex_temp_elmt_str)) { $elements[''wysiwyg:3'']			= <cms:mod type="wysiwyg"		 id="3" title="MOD_VALUE[42]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''wysiwyg:4'',$cflex_temp_elmt_str)) { $elements[''wysiwyg:4'']			= <cms:mod type="wysiwyg"		 id="4" title="MOD_VALUE[342]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''wysiwyg:5'',$cflex_temp_elmt_str)) { $elements[''wysiwyg:5'']			= <cms:mod type="wysiwyg"		 id="5" title="MOD_VALUE[343]" addslashes="true" menuoptions="false" />; }\r\n}\r\nif (cflex_chkelmt(''wysiwyg2'',$cflex_temp_elmt_str)) {\r\n	if (cflex_chkelmt(''wysiwyg2:1'',$cflex_temp_elmt_str)) { $elements[''wysiwyg2:1'']		 = <cms:mod type="wysiwyg2"		id="1" title="MOD_VALUE[23]" features="MOD_VALUE[3]" styleclass="MOD_VALUE[28]" selectablestyles = "MOD_VALUE[4]" imagefolders = "MOD_VALUE[16]" imagesubfolders ="MOD_VALUE[17]" imagefiletypes = "MOD_VALUE[15]" filefolders = "MOD_VALUE[18]" filesubfolders ="MOD_VALUE[19]" filefiletypes = "MOD_VALUE[6]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''wysiwyg2:2'',$cflex_temp_elmt_str)) { $elements[''wysiwyg2:2'']		 = <cms:mod type="wysiwyg2"		id="2" title="MOD_VALUE[33]" features="MOD_VALUE[330]" styleclass="MOD_VALUE[28]" selectablestyles = "MOD_VALUE[4]" imagefolders = "MOD_VALUE[16]" imagesubfolders ="MOD_VALUE[17]" imagefiletypes = "MOD_VALUE[15]" filefolders = "MOD_VALUE[18]" filesubfolders ="MOD_VALUE[19]" filefiletypes = "MOD_VALUE[6]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''wysiwyg2:3'',$cflex_temp_elmt_str)) { $elements[''wysiwyg2:3'']		 = <cms:mod type="wysiwyg2"		id="3" title="MOD_VALUE[43]" features="MOD_VALUE[331]" styleclass="MOD_VALUE[28]" selectablestyles = "MOD_VALUE[4]" imagefolders = "MOD_VALUE[16]" imagesubfolders ="MOD_VALUE[17]" imagefiletypes = "MOD_VALUE[15]" filefolders = "MOD_VALUE[18]" filesubfolders ="MOD_VALUE[19]" filefiletypes = "MOD_VALUE[6]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''wysiwyg2:4'',$cflex_temp_elmt_str)) { $elements[''wysiwyg2:4'']		 = <cms:mod type="wysiwyg2"		id="4" title="MOD_VALUE[443]" features="MOD_VALUE[332]" styleclass="MOD_VALUE[28]" selectablestyles = "MOD_VALUE[4]" imagefolders = "MOD_VALUE[16]" imagesubfolders ="MOD_VALUE[17]" imagefiletypes = "MOD_VALUE[15]" filefolders = "MOD_VALUE[18]" filesubfolders ="MOD_VALUE[19]" filefiletypes = "MOD_VALUE[6]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''wysiwyg2:5'',$cflex_temp_elmt_str)) { $elements[''wysiwyg2:5'']		 = <cms:mod type="wysiwyg2"		id="5" title="MOD_VALUE[444]" features="MOD_VALUE[333]" styleclass="MOD_VALUE[28]" selectablestyles = "MOD_VALUE[4]" imagefolders = "MOD_VALUE[16]" imagesubfolders ="MOD_VALUE[17]" imagefiletypes = "MOD_VALUE[15]" filefolders = "MOD_VALUE[18]" filesubfolders ="MOD_VALUE[19]" filefiletypes = "MOD_VALUE[6]" addslashes="true" menuoptions="false" />; }\r\n}\r\n\r\nif (cflex_chkelmt(''sourcecode:1'',$cflex_temp_elmt_str))		{ $elements[''sourcecode:1'']	 = <cms:mod type="sourcecode" id="1" title="MOD_VALUE[52]" addslashes="true" menuoptions="false" />; }\r\nif (cflex_chkelmt(''select'',$cflex_temp_elmt_str)) {\r\n	if (cflex_chkelmt(''select:1'',$cflex_temp_elmt_str))				{ $elements[''select:1'']			 = <cms:mod type="select" id="1" title="MOD_VALUE[29]" elementName="MOD_VALUE[74]" elementValue="MOD_VALUE[75]" elementSeparator="MOD_VALUE[76]" default="MOD_VALUE[77]" multiple="MOD_VALUE[78]" size="MOD_VALUE[79]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''select:2'',$cflex_temp_elmt_str))				{ $elements[''select:2'']			 = <cms:mod type="select" id="2" title="MOD_VALUE[3029]" elementName="MOD_VALUE[3074]" elementValue="MOD_VALUE[3075]" elementSeparator="MOD_VALUE[3076]" default="MOD_VALUE[3077]" multiple="MOD_VALUE[3078]" size="MOD_VALUE[3079]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''select:3'',$cflex_temp_elmt_str))				{ $elements[''select:3'']			 = <cms:mod type="select" id="3" title="MOD_VALUE[3129]" elementName="MOD_VALUE[3174]" elementValue="MOD_VALUE[3175]" elementSeparator="MOD_VALUE[3176]" default="MOD_VALUE[3177]" multiple="MOD_VALUE[3178]" size="MOD_VALUE[3179]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''select:4'',$cflex_temp_elmt_str))				{ $elements[''select:4'']			 = <cms:mod type="select" id="4" title="MOD_VALUE[3229]" elementName="MOD_VALUE[3274]" elementValue="MOD_VALUE[3275]" elementSeparator="MOD_VALUE[3276]" default="MOD_VALUE[3277]" multiple="MOD_VALUE[3278]" size="MOD_VALUE[3279]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''select:5'',$cflex_temp_elmt_str))				{ $elements[''select:5'']			 = <cms:mod type="select" id="5" title="MOD_VALUE[3329]" elementName="MOD_VALUE[3374]" elementValue="MOD_VALUE[3375]" elementSeparator="MOD_VALUE[3376]" default="MOD_VALUE[3377]" multiple="MOD_VALUE[3378]" size="MOD_VALUE[3379]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''select:6'',$cflex_temp_elmt_str))				{ $elements[''select:6'']			 = <cms:mod type="select" id="6" title="MOD_VALUE[3429]" elementName="MOD_VALUE[3474]" elementValue="MOD_VALUE[3475]" elementSeparator="MOD_VALUE[3476]" default="MOD_VALUE[3477]" multiple="MOD_VALUE[3478]" size="MOD_VALUE[3479]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''select:7'',$cflex_temp_elmt_str))				{ $elements[''select:7'']			 = <cms:mod type="select" id="7" title="MOD_VALUE[3529]" elementName="MOD_VALUE[3574]" elementValue="MOD_VALUE[3575]" elementSeparator="MOD_VALUE[3576]" default="MOD_VALUE[3577]" multiple="MOD_VALUE[3578]" size="MOD_VALUE[3579]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''select:8'',$cflex_temp_elmt_str))				{ $elements[''select:8'']			 = <cms:mod type="select" id="8" title="MOD_VALUE[3629]" elementName="MOD_VALUE[3674]" elementValue="MOD_VALUE[3675]" elementSeparator="MOD_VALUE[3676]" default="MOD_VALUE[3677]" multiple="MOD_VALUE[3678]" size="MOD_VALUE[3679]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''select:9'',$cflex_temp_elmt_str))				{ $elements[''select:9'']			 = <cms:mod type="select" id="9" title="MOD_VALUE[3729]" elementName="MOD_VALUE[3774]" elementValue="MOD_VALUE[3775]" elementSeparator="MOD_VALUE[3776]" default="MOD_VALUE[3777]" multiple="MOD_VALUE[3778]" size="MOD_VALUE[3779]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''select:10'',$cflex_temp_elmt_str))			{ $elements[''select:10'']			 = <cms:mod type="select" id="10" title="MOD_VALUE[3829]" elementName="MOD_VALUE[3874]" elementValue="MOD_VALUE[3875]" elementSeparator="MOD_VALUE[3876]" default="MOD_VALUE[3877]" multiple="MOD_VALUE[3878]" size="MOD_VALUE[3879]" addslashes="true" menuoptions="false" />; }\r\n\r\n}\r\nif (cflex_chkelmt(''date'',$cflex_temp_elmt_str)) {\r\n	if (cflex_chkelmt(''date:1'',$cflex_temp_elmt_str))					{ $elements[''date:1'']				 = <cms:mod type="date" id="1" title="MOD_VALUE[37]" mode="MOD_VALUE[53]"	 formDateFormat ="MOD_VALUE[54]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''date:2'',$cflex_temp_elmt_str))					{ $elements[''date:2'']				 = <cms:mod type="date" id="2" title="MOD_VALUE[85]" mode="MOD_VALUE[71]"	 formDateFormat ="MOD_VALUE[72]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''date:3'',$cflex_temp_elmt_str))					{ $elements[''date:3'']				 = <cms:mod type="date" id="3" title="MOD_VALUE[86]" mode="MOD_VALUE[73]"	 formDateFormat ="MOD_VALUE[84]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''date:4'',$cflex_temp_elmt_str))					{ $elements[''date:4'']				 = <cms:mod type="date" id="4" title="MOD_VALUE[886]" mode="MOD_VALUE[873]"	 formDateFormat ="MOD_VALUE[884]" addslashes="true" menuoptions="false" />; }\r\n	if (cflex_chkelmt(''date:5'',$cflex_temp_elmt_str))					{ $elements[''date:5'']				 = <cms:mod type="date" id="5" title="MOD_VALUE[887]" mode="MOD_VALUE[874]"	 formDateFormat ="MOD_VALUE[885]" addslashes="true" menuoptions="false" />; }\r\n}\r\n//if (cflex_chkelmt('''',$cflex_temp_elmt_str))								{	 $elements[''radio:1'']				= <cms:mod type="radio" id="1" title="MOD_VALUE[38]" addslashes="true" menuoptions="false" />; }\r\n//if (cflex_chkelmt('''',$cflex_temp_elmt_str))								{	 $elements[''checkbox:1'']		= <cms:mod type="checkbox" id="1" title="MOD_VALUE[39]" addslashes="true" menuoptions="false" />; }\r\n\r\n\r\nif (cflex_chkelmt(''table_data:102'',$cflex_temp_elmt_str)) { \r\n\r\n	if ($modv[''MOD_VALUE_100400'']==''true'')\r\n		$elements[''table_caption'']			= <cms:mod type="text"			 id="100" title="MOD_VALUE[100100]" addslashes="true" menuoptions="false" />; \r\n\r\n	if ($modv[''MOD_VALUE_100401'']==''true'')\r\n		$elements[''table_head'']				 	= <cms:mod type="text"			 id="101" title="MOD_VALUE[100101]" addslashes="true" menuoptions="false" />; \r\n\r\n	$elements[''table_data'']		 				= <cms:mod type="textarea"	 id="102" title="MOD_VALUE[100102]" addslashes="true" menuoptions="false" />;\r\n\r\n	if ($modv[''MOD_VALUE_100402'']==''true'')\r\n		$elements[''table_foot'']					= <cms:mod type="text"			 id="103" title="MOD_VALUE[100103]" addslashes="true" menuoptions="false" />; \r\n\r\n}\r\n\r\n\r\nif (cflex_chkelmt(''list_data:300'',$cflex_temp_elmt_str)) { \r\n	$elements[''list_data1'']		 				= <cms:mod type="textarea"	 id="300" title="MOD_VALUE[4090]" addslashes="true" menuoptions="false" />;\r\n}\r\nif (cflex_chkelmt(''list_data:310'',$cflex_temp_elmt_str)) { \r\n	$elements[''list_data2'']		 				= <cms:mod type="textarea"	 id="310" title="MOD_VALUE[4190]" addslashes="true" menuoptions="false" />;\r\n}\r\n\r\nif (cflex_chkelmt(''filelist:200'',$cflex_temp_elmt_str)) {\r\n\r\n		global $cfg_client;\r\n\r\n		$elements[''fl_selected_file'']				 = <cms:mod type="file"	 id="200" addslashes="true" mode="textlink" menuoptions="false" />; \r\n		$elements[''fl_selected_fileurl'']		 = <cms:mod type="file"	 id="200" addslashes="true" mode="url" menuoptions="false" />; \r\n		$elements[''fl_selected_filename'']		 = <cms:mod type="file"	 id="200" addslashes="true" mode="filename" menuoptions="false" />;\r\n		$elements[''fl_selected_filetype'']		 = <cms:mod type="file"	 id="200" addslashes="true" mode="filetype" menuoptions="false" />;\r\n		$elements[''fl_selected_filefmtitle''] = <cms:mod type="file"	 id="200" addslashes="true" mode="fmtitle" menuoptions="false" />; \r\n		$elements[''fl_selected_filefmdesc'']	 = <cms:mod type="file"	 id="200" addslashes="true" mode="fmdesc" menuoptions="false" />; \r\n\r\n		if(!empty($elements[''fl_selected_fileurl''])){\r\n			$mod[''thumbfile_ext''] = substr (strrchr ($elements[''fl_selected_fileurl''], "."), 1);\r\n			$mod[''thumbfile''] = substr ($elements[''fl_selected_fileurl''], 0, -(strlen( $mod[''thumbfile_ext''] ))-1 ).$cfg_client["thumbext"].''.''.$mod["thumbfile_ext"];\r\n	 		$elements[''fl_selected_filethumburl''] = $mod[''thumbfile''];\r\n		} else\r\n			$elements[''fl_selected_filethumburl'']='''';\r\n\r\n		$elements[''fl_selected_filedesc'']		 = <cms:mod type="file"	 id="200" addslashes="true" mode="desc" menuoptions="false" />;\r\n\r\n		$elements[''fl_selected_filetarget''] = <cms:mod type="file" id="200" addslashes="true" mode="target" menuoptions="false">;\r\n		\r\n		$elements[''fl_selected_filesize''] = cflex_getfsize(<cms:mod type="file" id="200" addslashes="true" mode="path" menuoptions="false">);\r\n\r\n		if (''MOD_VALUE[2019]''==''true'')\r\n			$elements[''fl_subdirs'']				 = <cms:mod type="checkbox" elementName="" elementValue="true" elementValueUnchecked="false" title="MOD_VALUE[2001]" id="201" addslashes="true" menuoptions="false" />;\r\n\r\n 		$elements[''editfile:200'']		 = <cms:mod type="file" id="200" title="MOD_VALUE[2000]" mode="editbutton" hidetarget="MOD_VALUE[27]" folders="MOD_VALUE[2018]" subfolders="MOD_VALUE[2019]" filetypes="MOD_VALUE[2006]" addslashes="true" menuoptions="false" />;\r\n\r\n}\r\n\r\n\r\n\r\n// **** Template abarbeiten	 **************************************************************\r\n\r\n// imagedimension\r\nif(strpos($modv[''tpl_inner''],''{imagedimensions:'')!==false)\r\n	for ($i=1;$i<4;$i++)\r\n		if(strpos($modv[''tpl_inner''],''{imagedimensions:''.$i.''}'')!==false)\r\n				$elements[''imagedimensions:''.$i]=str_replace(array(''{width}'',''{height}''),\r\n																							 			array($elements[''imagewidth:''.$i],$elements[''imageheight:''.$i]),\r\n																										$modv[''tpl_imgdimensions'']);\r\n// global hide\r\nif(strpos($modv[''tpl_inner''],''{hide}'')!==false)\r\n	$modv[''tpl_inner''] = preg_replace(''#\\{hide\\}(.*)\\{/hide\\}#sU'','''',$modv[''tpl_inner'']);\r\n\r\n// global if-backend\r\nif(strpos($modv[''tpl_inner''],''{if_backend}'')!==false)\r\n	if (($sess->name == ''sefrengo'' && $view != ''preview'')) {\r\n		$modv[''tpl_inner''] = str_replace(array(''{if_backend}'',''{/if_backend}''), array('''',''''), $modv[''tpl_inner'']);\r\n	} else {\r\n		$modv[''tpl_inner''] = preg_replace(''#\\{if_backend\\}(.*)\\{/if_backend\\}#sU'','''',$modv[''tpl_inner'']);\r\n	}\r\n// global if-previw\r\nif(strpos($modv[''tpl_inner''],''{if_preview}'')!==false)\r\n	if (($sess->name == ''sefrengo'' && $view == ''preview'')) {\r\n		$modv[''tpl_inner''] = str_replace(array(''{if_preview}'',''{/if_preview}''), array('''',''''), $modv[''tpl_inner'']);\r\n	} else {\r\n		$modv[''tpl_inner''] = preg_replace(''#\\{if_preview\\}(.*)\\{/if_preview\\}#sU'','''',$modv[''tpl_inner'']);\r\n	}\r\n\r\nif ($cms_mod[''modul''][''id''] == ''1'')\r\n	$cf_paracounter=0;\r\n$cf_paracounter++;\r\n$modv[''tpl_inner'']=str_replace(''{no}'',$cf_paracounter, $modv[''tpl_inner'']);\r\n\r\nforeach($elements AS $k => $v){\r\n\r\n		$modv[''tpl_inner'']=element_ifstatements($modv[''tpl_inner''],$elements,$k,$v);\r\n\r\n		// insert content\r\n	 	$modv[''tpl_inner''] = str_replace(''{''.$k.''}'', $v, $modv[''tpl_inner'']);\r\n\r\n 		if (strpos($modv[''tpl_inner''],''{uni:'')!==false)\r\n 			$modv[''tpl_inner'']=str_replace(	array(''{uni:1}'',\r\n 																						''{uni:2}'',\r\n 																						''{uni:3}'',\r\n 																						''{uni:4}'',\r\n 																						''{uni:5}'',\r\n 																						''{uni:6}''),\r\n 																			array($modv[''MOD_VALUE_6000''],\r\n 																						$modv[''MOD_VALUE_6001''],\r\n 																						$modv[''MOD_VALUE_6002''],\r\n 																						$modv[''MOD_VALUE_6003''],\r\n 																						$modv[''MOD_VALUE_6004''],\r\n 																						$modv[''MOD_VALUE_6005'']),\r\n 																			$modv[''tpl_inner'']); \r\n\r\n		// check for list-element and generate table-html\r\n		if (strpos($modv[''tpl_inner''],''{list:1}'')!==false)\r\n			$modv[''tpl_inner''] = str_replace(''{list:1}'',\r\n																			 txt2htmllist(	$modv[''MOD_VALUE_4010''],\r\n																											$modv[''MOD_VALUE_4020''],\r\n																											$elements[''list_data1'']),\r\n																			 $modv[''tpl_inner'']); \r\n		if (strpos($modv[''tpl_inner''],''{list:2}'')!==false)\r\n			$modv[''tpl_inner''] = str_replace(''{list:2}'',\r\n																			 txt2htmllist(	$modv[''MOD_VALUE_4110''],\r\n																											$modv[''MOD_VALUE_4120''],\r\n																											$elements[''list_data2'']),\r\n																			 $modv[''tpl_inner'']); \r\n																					 																			 \r\n		// check for table-element and generate table-html\r\n		if (strpos($modv[''tpl_inner''],''{table}'')!==false)\r\n			$modv[''tpl_inner''] = str_replace(''{table}'',\r\n																			 txt2htmltable( $elements[''table_caption''],\r\n																											$elements[''table_head''],\r\n																											$elements[''table_foot''],\r\n																											$elements[''table_data'']),\r\n																			 $modv[''tpl_inner'']); \r\n\r\n 		// check for filelist-element and generate list\r\n		if (strpos($modv[''tpl_inner''],''{filelist}'')!==false){\r\n			$modv[''filelist_feature_used'']=true;\r\n			$modv[''tpl_inner''] = str_replace(	''{filelist}'',\r\n																				contentflexfilelist($elements[''fl_selected_fileurl''],\r\n																														$modv[''MOD_VALUE_2010''],\r\n																														$modv[''MOD_VALUE_2013''],\r\n																														$modv[''MOD_VALUE_2011''],\r\n																														$modv[''MOD_VALUE_2030''],\r\n																														$modv[''MOD_VALUE_2014''],\r\n																														$modv[''MOD_VALUE_2012''],\r\n																														$elements[''fl_subdirs''],																														\r\n																														$modv[''MOD_VALUE_2019''],\r\n																														$modv[''MOD_VALUE_2018''],\r\n																														$modv[''MOD_VALUE_2006''],\r\n																														$modv[''MOD_VALUE_2031''],\r\n																														$modv[''MOD_VALUE_2032''],\r\n																														$modv[''MOD_VALUE_2002''],\r\n																														$modv[''MOD_VALUE_2000''],\r\n																														$modv[''MOD_VALUE_2001''],\r\n																														$modv[''MOD_VALUE_2005''],\r\n																														$modv[''MOD_VALUE_2116''],\r\n																														$modv[''MOD_VALUE_2004''],\r\n																														$modv[''MOD_VALUE_2015''],\r\n																														$modv[''MOD_VALUE_2020''],\r\n																														$modv[''MOD_VALUE_2003''],\r\n																														$modv[''MOD_VALUE_2022''],																														\r\n																														$modv[''MOD_VALUE_2021''],\r\n																														$modv[''MOD_VALUE_2023''],\r\n																														$modv[''MOD_VALUE_2016'']),		 																												\r\n																				$modv[''tpl_inner'']); \r\n		} else {\r\n 				$modv[''filelist_feature_used'']=false;\r\n		}\r\n		\r\n}\r\n\r\n// kill absolute pathes\r\nif ($modv[''MOD_VALUE_95'']!=''false'' &&\r\n		strpos($modv[''tpl_inner''],$cfg_client[''upl_htmlpath''])!==false &&\r\n		strpos($cfg_client[''upl_htmlpath''],$cfg_client[''htmlpath''])!==false)\r\n	$modv[''tpl_inner'']=str_replace($cfg_client[''htmlpath''],'''',$modv[''tpl_inner'']);\r\n\r\n$modv[''tpl_inner''] = str_replace(''{container_id}'',$cms_mod[''container''][''id''],$modv[''tpl_inner'']);\r\n$modv[''tpl_inner''] = str_replace(''{mod_key}'',$cms_mod[''key''],$modv[''tpl_inner'']);\r\n$modv[''tpl_inner''] = str_replace(''{cat_name}'',$con_tree[$idcat][''name''],$modv[''tpl_inner'']);\r\n$modv[''tpl_inner''] = str_replace(''{side_name}'',$con_side[$idcatside][''name''],$modv[''tpl_inner'']);\r\n\r\n\r\n// Template mit den allgemeinem Inhalt ersetzen\r\nforeach($elements1 AS $k => $v){\r\n		$modv[''tpl_inner''] = str_replace(''{''.$k.''}'', $v, $modv[''tpl_inner'']);\r\n}\r\n\r\n// urlencode\r\nif(strpos($modv[''tpl_inner''],''{urlencode}'')!==false) {\r\n		$thisstring=getstringparts($modv[''tpl_inner''],''{urlencode}'',''{/urlencode}'');\r\n		$modv[''tpl_inner''] = preg_replace(''#\\{urlencode\\}(.*)\\{/urlencode\\}#sU'',urlencode($thisstring[''middle'']),$modv[''tpl_inner'']);\r\n	}\r\n	\r\n// NavTemplate mit den allgemeinem Inhalt ersetzen\r\nforeach($elements1 AS $k => $v){\r\n		$modv[''tpl_nav''] = str_replace(''{''.$k.''}'', $v, $modv[''tpl_nav'']);\r\n}\r\n\r\n#if(strpos($modv[''tpl_inner''],''{pagebreak}'')!==false) {\r\n#	$modv[''max_items'']=$modv[''repeat_id'']-$page;\r\n#	$modv[''tpl_inner'']=str_replace(''{pagebreak}'','''',$modv[''tpl_inner'']);\r\n#}\r\n			\r\n// Time\r\nif ($mod[''timetest''] == "true") { \r\n		if ((bool) $cms_mod[''modul''][''lastentry'']) \r\n		{\r\n				list($usec, $sec) = explode(" ", microtime());\r\n				$time_end = ((float)$usec + (float)$sec); \r\n				$time = $time_end - $time_start;\r\n				$modv[''tpl_inner''] .= "<hr>execute time cache: ".((int)($time*100)/100)." sec / ".$cms_mod[''modul''][''id'']." => ".(int)(($time/$cms_mod[''modul''][''id''])*1000)." ms<hr>"; \r\n		}\r\n}\r\n\r\n// ****	 **************************************************************\r\n//Alle Variablen, die nur innerhalb des gecachten PHPs sichtbar sind,\r\n//auch fuer dynamisches PHP zur Verfuegung stellen\r\necho ''<CMSPHP>'';\r\nif (is_array($modv)) {\r\nforeach($modv AS $k => $v){\r\nif (! is_array($v)) {\r\necho ''$mvars["''.$k.''"] = "''. addslashes($v) .''";''."\\n";\r\n}\r\n}}\r\necho ''</CMSPHP>'';\r\n\r\nif ($mod[''test''] == "true") { echo "<hr>"; }\r\n\r\nunset($modv, $modtemp, $elements, $elements1, $spezelements, $typegroup_conf, $k, $v);\r\n</CMSPHP:CACHE>\r\n<CMSPHP>\r\n// clear page cache on filelist-use\r\nif ($mvars[''filelist_feature_used'']==true)\r\n	 change_code_status($idcatside, 1, ''idcatside'');\r\n\r\n// **** include uncached ********************************************************************************************\r\n\r\nif ($is_dev)\r\n	include "C:/_server/www/_sefrengo/mod_dev/ContentFlex/backend/inc/mod.contentflex.php";\r\nelse\r\n	include $cms_path."inc/mod.contentflex.php";\r\n	\r\n</CMSPHP>\r\n\r\n', '', 0, 1, 1, 1110746092, 1361822340, 'mod:7b1c741bb9e90ce7ada1ed43b57f70c7:3f7a21d8', '', '', '', 0, '0', '', '1');
INSERT INTO `cms_mod` VALUES (27, 'Pic-Galerie', '3.5.0', 'Content', 'Galerie aus ausgewhltem Ordner des Dateimanagers', '<?\r\n\r\n// Version 3.5.0\r\n// (c) 2005 by Sascha Postner v/o saschapi\r\n\r\n//Belegt sind mip_forms 0 - 31 und 51-52 und 60-61 und 90005-90010\r\n\r\n\r\n\r\n//Config-mode ( Normal, Erweitert, Ausgeblendet)\r\n$mip_form[''0''][''desc''] = ''Konfigurationsmodus'';\r\n$mip_form[''0''][''cat''] = ''option'';\r\n$mip_form[''0''][''size''] = ''1'';\r\n$mip_form[''0''][''option_desc''][] = ''Normal'';\r\n$mip_form[''0''][''option_val''][] =  '''';\r\n$mip_form[''0''][''option_desc''][] = ''Erweitert'';\r\n$mip_form[''0''][''option_val''][] =  ''advanced'';\r\n$mip_form[''0''][''option_desc''][] = ''Erweitert + Detailfeatures'';\r\n$mip_form[''0''][''option_val''][] =  ''detail'';\r\n$mip_form[''0''][''option_desc''][] = ''Ausgeblendet'';\r\n$mip_form[''0''][''option_val''][] =  ''hidden'';\r\n$mip_form[''0''][''cms_var''] = ''MOD_VAR[0]'';\r\n$mip_form[''0''][''cms_val''] = $cms_mod[''value''][''0''];\r\n$mip_form[''0''][''flag''] = ''reload'';\r\nmip_formsp($mip_form[''0'']);//configmode\r\n$mip_form[''hide_in_standard_mode''] = array(1,2,3,5,6,7,10,11,12,13,14,15,16,17,18,20,21,22,23,24,25,27,28,30,31,60,61,90007,90008,90009,90010);\r\n$mip_form[''hide_in_advanced_mode''] = array(20,23,90009,90010);\r\n$mip_form[''hide_in_detail_mode''] = array();\r\n\r\n//hidden config\r\nif($cms_mod[''value''][''0''] == ''hidden''){\r\n  foreach($cms_mod[''value''] AS $ke=>$va){\r\n    if($ke != ''0''){\r\n    ?>\r\n      <input name="MOD_VAR[<?php echo $ke; ?>]" type="hidden" value="<?php echo htmlentities($va, ENT_COMPAT, ''UTF-8'');?>">\r\n    <?php\r\n     }\r\n  }\r\n}\r\n//simple and advanced config\r\nelse if($cms_mod[''value''][''0''] == '''' || $cms_mod[''value''][''0''] == ''advanced'' || $cms_mod[''value''][''0''] == ''detail''){\r\n\r\n\r\n##############################################\r\n# Schriftarten\r\n##############################################\r\n\r\n//Schriftart 1\r\n$mip_form[''1''][''desc''] = $mod_lang[''gen_font'']." {font1}";\r\n$mip_form[''1''][''cat''] = ''app_css'';\r\n$mip_form[''1''][''output_cat''] = ''option'';\r\n$mip_form[''1''][''cms_var''] = ''MOD_VAR[1]'';\r\n$mip_form[''1''][''cms_val''] = $cms_mod[''value''][''1''];\r\n\r\n//Schriftart 2\r\n$mip_form[''2''][''desc''] = $mod_lang[''gen_font'']." {font2} (Walker Seitenlink)";\r\n$mip_form[''2''][''cat''] = ''app_css'';\r\n$mip_form[''2''][''output_cat''] = ''option'';\r\n$mip_form[''2''][''cms_var''] = ''MOD_VAR[2]'';\r\n$mip_form[''2''][''cms_val''] = $cms_mod[''value''][''2''];\r\n\r\n//Schriftart 3\r\n$mip_form[''3''][''desc''] = $mod_lang[''gen_font'']." {font3} (Aktueller Walker Seitenlink)<br/><br/>\\n";\r\n$mip_form[''3''][''cat''] = ''app_css'';\r\n$mip_form[''3''][''output_cat''] = ''option'';\r\n$mip_form[''3''][''cms_var''] = ''MOD_VAR[3]'';\r\n$mip_form[''3''][''cms_val''] = $cms_mod[''value''][''3''];\r\n\r\n//Schriftart 4\r\n$mip_form[''27''][''desc''] = $mod_lang[''gen_font'']." {font4} (Bildtitel)<br/><br/>\\n";\r\n$mip_form[''27''][''cat''] = ''app_css'';\r\n$mip_form[''27''][''output_cat''] = ''option'';\r\n$mip_form[''27''][''cms_var''] = ''MOD_VAR[27]'';\r\n$mip_form[''27''][''cms_val''] = $cms_mod[''value''][''27''];\r\n\r\n//Schriftart 4\r\n$mip_form[''28''][''desc''] = $mod_lang[''gen_font'']." {font5} (Bildbeschreibung)<br/><br/>\\n";\r\n$mip_form[''28''][''cat''] = ''app_css'';\r\n$mip_form[''28''][''output_cat''] = ''option'';\r\n$mip_form[''28''][''cms_var''] = ''MOD_VAR[28]'';\r\n$mip_form[''28''][''cms_val''] = $cms_mod[''value''][''28''];\r\n\r\n\r\n##############################################\r\n# generelle Einstellungen\r\n##############################################\r\n\r\n\r\n// Verzeichnis im Frontend oder Backend auswhlen?\r\n$mip_form[''51''][''desc''] = ''Soll der Redakteur das Verzeichnis im Frontend einstellen?'';\r\n$mip_form[''51''][''cat''] = ''option'';\r\n$mip_form[''51''][''cms_var''] = ''MOD_VAR[51]'';\r\n$mip_form[''51''][''cms_val''] = $cms_mod[''value''][''51''];\r\n$mip_form[''51''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''51''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''51''][''option_val''][''0''] = true;\r\n$mip_form[''51''][''option_val''][''1''] = false;\r\n$mip_form[''51''][''cms_val_default''] = false;\r\n$mip_form[''51''][''flag''] = ''reload'';\r\n\r\n\r\n//Ordnerauswahl\r\n$mip_form[''4''][''desc''] = ''Ordner: '';\r\n$mip_form[''4''][''cat''] = ''app_directory'';\r\n$mip_form[''4''][''output_cat''] = ''option'';\r\n$mip_form[''4''][''cms_var''] = ''MOD_VAR[4]'';\r\n$mip_form[''4''][''cms_val''] = $cms_mod[''value''][''4''];\r\n$mip_form[''4''][''flag''] = ''single'';\r\n\r\n//StartOrdnerauswahl\r\n$mip_form[''52''][''desc''] = ''Startverzeichnis: '';\r\n$mip_form[''52''][''cat''] = ''app_directory'';\r\n$mip_form[''52''][''output_cat''] = ''option'';\r\n$mip_form[''52''][''cms_var''] = ''MOD_VAR[52]'';\r\n$mip_form[''52''][''cms_val''] = $cms_mod[''value''][''52''];\r\n$mip_form[''52''][''flag''] = ''single'';\r\n\r\n// Unterordner verwenden??\r\n$mip_form[''26''][''desc''] = ''Unterordner einschlieen?'';\r\n$mip_form[''26''][''cat''] = ''option'';\r\n$mip_form[''26''][''cms_var''] = ''MOD_VAR[26]'';\r\n$mip_form[''26''][''cms_val''] = $cms_mod[''value''][''26''];\r\n$mip_form[''26''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''26''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''26''][''option_val''][''0''] = true;\r\n$mip_form[''26''][''option_val''][''1''] = false;\r\n$mip_form[''26''][''cms_val_default''] = false;\r\n\r\n\r\n//Anzahl Bilder\r\n$mip_form[''6''][''desc''] = "Anzahl Bilder pro Galerie-Seite";\r\n$mip_form[''6''][''cat''] = ''txt'';\r\n$mip_form[''6''][''cms_var''] = ''MOD_VAR[6]'';\r\n$mip_form[''6''][''cms_val''] = $cms_mod[''value''][''6''];\r\n$mip_form[''6''][''cms_val_default''] = ''9'';\r\n\r\n// Anzahl pro Reihe\r\n$mip_form[''7''][''desc''] = "Anzahl Bilder in einer Reihe";\r\n$mip_form[''7''][''cat''] = ''txt'';\r\n$mip_form[''7''][''cms_var''] = ''MOD_VAR[7]'';\r\n$mip_form[''7''][''cms_val''] = $cms_mod[''value''][''7''];\r\n$mip_form[''7''][''cms_val_default''] = ''3'';\r\n\r\n\r\n// Galerie-ID\r\n$mip_form[''5''][''desc''] = "welche Seite bei Galerieaufruf: <br/>\\n";\r\n$mip_form[''5''][''cat''] = ''txt'';\r\n$mip_form[''5''][''cms_var''] = ''MOD_VAR[5]'';\r\n$mip_form[''5''][''cms_val''] = $cms_mod[''value''][''5''];\r\n$mip_form[''5''][''cms_val_default''] = ''1'';\r\n\r\n//Sortierreihenfolge\r\n$mip_form[''15''][''desc''] = "Sortierreihenfolge";\r\n$mip_form[''15''][''cat''] = ''option'';\r\n$mip_form[''15''][''cms_var''] = ''MOD_VAR[15]'';\r\n$mip_form[''15''][''cms_val''] = $cms_mod[''value''][''15''];\r\n$mip_form[''15''][''option_desc''][''0''] = ''anhand Dateiname'';\r\n$mip_form[''15''][''option_val''][''0''] = ''filename'';\r\n$mip_form[''15''][''option_desc''][''1''] = ''anhand Titel'';\r\n$mip_form[''15''][''option_val''][''1''] = ''titel'';\r\n$mip_form[''15''][''option_desc''][''2''] = ''anhand &lt;order&gt-Tag; in Beschreibung'';\r\n$mip_form[''15''][''option_val''][''2''] = ''description'';\r\n$mip_form[''15''][''option_desc''][''3''] = ''anhand Erstellungsdatum'';\r\n$mip_form[''15''][''option_val''][''3''] = ''created'';\r\n$mip_form[''15''][''option_desc''][''4''] = ''anhand nderungsdatum'';\r\n$mip_form[''15''][''option_val''][''4''] = ''lastmodified'';\r\n$mip_form[''15''][''option_desc''][''5''] = ''anhand Dateigre'';\r\n$mip_form[''15''][''option_val''][''5''] = ''filesize'';\r\n$mip_form[''15''][''option_desc''][''6''] = ''anhand Autor'';\r\n$mip_form[''15''][''option_val''][''6''] = ''author'';\r\n$mip_form[''15''][''cms_val_default''] = ''filename'';\r\n\r\n//aufsteigend-absteigend\r\n$mip_form[''16''][''cat''] = ''radio'';\r\n$mip_form[''16''][''cms_var''] = ''MOD_VAR[16]'';\r\n$mip_form[''16''][''cms_val''] = $cms_mod[''value''][''16''];\r\n$mip_form[''16''][''cms_val_default''] = ''ASC'';\r\n$mip_form[''16''][''option_desc''][''0''] = ''aufsteigend'';\r\n$mip_form[''16''][''option_val''][''0''] = ''ASC'';\r\n$mip_form[''16''][''option_desc''][''1''] = ''absteigend'';\r\n$mip_form[''16''][''option_val''][''1''] = ''DESC'';\r\n\r\n##############################################\r\n# Bildergren\r\n##############################################\r\n\r\n// max image size\r\n$mip_form[''17''][''desc''] = ''maximale Bild-Gre: {maximgsize} (leer = Originalgre)'';\r\n$mip_form[''17''][''cat''] = ''txt'';\r\n$mip_form[''17''][''cms_var''] = ''MOD_VAR[17]'';\r\n$mip_form[''17''][''cms_val''] = $cms_mod[''value''][''17''];\r\n$mip_form[''17''][''cms_val_default''] = '''';\r\n\r\n// max image size 2\r\n$mip_form[''21''][''desc''] = ''maximale Bild-Gre: {maximgsize2} (leer = Originalgre)'';\r\n$mip_form[''21''][''cat''] = ''txt'';\r\n$mip_form[''21''][''cms_var''] = ''MOD_VAR[21]'';\r\n$mip_form[''21''][''cms_val''] = $cms_mod[''value''][''21''];\r\n$mip_form[''21''][''cms_val_default''] = '''';\r\n\r\n##############################################\r\n# Galeriewalker\r\n##############################################\r\n\r\n// vor/zurck-links anzeigen\r\n$mip_form[''10''][''desc''] = ''Vor/Zur&uuml;ck-Links anzeigen'';\r\n$mip_form[''10''][''cat''] = ''option'';\r\n$mip_form[''10''][''cms_var''] = ''MOD_VAR[10]'';\r\n$mip_form[''10''][''cms_val''] = $cms_mod[''value''][''10''];\r\n$mip_form[''10''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''10''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''10''][''option_val''][''0''] = ''true'';\r\n$mip_form[''10''][''option_val''][''1''] = ''false'';\r\n$mip_form[''10''][''cms_val_default''] = ''false'';\r\n$mip_form[''10''][''flag''] = ''reload'';\r\n//\r\n\r\n// vor/zurck-linktexte definieren\r\nif ($cms_mod[''value''][''10''] == ''true'') {\r\n        // zurck-link\r\n        $mip_form[''13''][''desc''] = "Zurck-Linktext";\r\n        $mip_form[''13''][''cat''] = ''txt'';\r\n        $mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n        $mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n        $mip_form[''13''][''cms_val_default''] = ''&lt;&lt;'';\r\n\r\n        // weiter-link\r\n        $mip_form[''14''][''desc''] = "Weiter-Linktext";\r\n        $mip_form[''14''][''cat''] = ''txt'';\r\n        $mip_form[''14''][''cms_var''] = ''MOD_VAR[14]'';\r\n        $mip_form[''14''][''cms_val''] = $cms_mod[''value''][''14''];\r\n        $mip_form[''14''][''cms_val_default''] = ''&gt;&gt;'';\r\n} else {\r\n        // zurck-link\r\n        $mip_form[''13''][''cat''] = ''hidden'';\r\n        $mip_form[''13''][''cms_var''] = ''MOD_VAR[13]'';\r\n        $mip_form[''13''][''cms_val''] = $cms_mod[''value''][''13''];\r\n        $mip_form[''13''][''cms_val_default''] = ''&lt;&lt;'';\r\n\r\n        // weiter-link\r\n        $mip_form[''14''][''cat''] = ''hidden'';\r\n        $mip_form[''14''][''cms_var''] = ''MOD_VAR[14]'';\r\n        $mip_form[''14''][''cms_val''] = $cms_mod[''value''][''14''];\r\n        $mip_form[''14''][''cms_val_default''] = ''&gt;&gt;'';\r\n}\r\n\r\n// anzahl der angezeigten Seitenlinks\r\n$mip_form[''11''][''desc''] = "Floating Galerie-Walker:<br/>\\n (0 = Floating aus, 1-n = Max. angezeigter Links)<br/><br/>\\n";\r\n$mip_form[''11''][''cat''] = ''txt'';\r\n$mip_form[''11''][''cms_var''] = ''MOD_VAR[11]'';\r\n$mip_form[''11''][''cms_val''] = $cms_mod[''value''][''11''];\r\n$mip_form[''11''][''cms_val_default''] = ''0'';\r\n\r\n// separatoren\r\n$mip_form[''12''][''desc''] = "Separator zwischen den Seitenlinks im Walker:<br/>\\n (leer = default-separator)<br/><br/>\\n";\r\n$mip_form[''12''][''cat''] = ''txt'';\r\n$mip_form[''12''][''cms_var''] = ''MOD_VAR[12]'';\r\n$mip_form[''12''][''cms_val''] = $cms_mod[''value''][''12''];\r\n$mip_form[''12''][''cms_val_default''] = '''';\r\n\r\n// Aktuelle Galerieseite verlinken?\r\n$mip_form[''18''][''desc''] = ''Soll die aktuelle Seite im Galerie-Walker verlinkt werden?'';\r\n$mip_form[''18''][''cat''] = ''option'';\r\n$mip_form[''18''][''cms_var''] = ''MOD_VAR[18]'';\r\n$mip_form[''18''][''cms_val''] = $cms_mod[''value''][''18''];\r\n$mip_form[''18''][''option_desc''][''0''] = ''Ja'';\r\n$mip_form[''18''][''option_desc''][''1''] = ''Nein'';\r\n$mip_form[''18''][''option_val''][''0''] = true;\r\n$mip_form[''18''][''option_val''][''1''] = false;\r\n$mip_form[''18''][''cms_val_default''] = false;\r\n$mip_form[''18''][''flag''] = ''reload'';\r\n//\r\n\r\n##############################################\r\n# Templates\r\n##############################################\r\n\r\n\r\n// Layout der Galerie Tabelle\r\n$mip_form[''8''][''desc''] = ''Layout der Galerie-Tabelle'';\r\n$mip_form[''8''][''cat''] = ''txtarea'';\r\n$mip_form[''8''][''type''] = ''long'';\r\n$mip_form[''8''][''rows''] = ''10'';\r\n$mip_form[''8''][''cms_var''] = ''MOD_VAR[8]'';\r\n$mip_form[''8''][''cms_val''] = $cms_mod[''value''][''8''];\r\n$mip_form[''8''][''cms_val_default''] = "<table width=\\"100%\\">\r\n  <tr class=\\"{font1}\\">\r\n    <td align=\\"center\\">Seite {id}</td>\r\n  </tr>\r\n  <tr class=\\"{font2}\\">\r\n    <td align=\\"center\\">{walker}</td>\r\n   </tr>\r\n   <tr>\r\n     <td><table width=\\"100%\\"><tr>{content}</tr></table></td>\r\n  </tr>\r\n  <tr class=\\"{font2}\\">\r\n    <td align=\\"center\\">{walker}</td>\r\n  </tr>\r\n</table>";\r\n// legend Layout der Galerie Tabelle\r\n$mip_form[''90005''][''cat''] = ''desc'';\r\n$mip_form[''90005''][''type''] = '''';\r\n$mip_form[''90005''][''desc''] = ''<div id="legend1" style="display:none;text-align:right;"><small><strong>Inhaltselemente</strong><br/>{font1},{font2},{font3},{id},{walker},<b>{content}</b><br/><br/><u>Bemerkung:</u> {content} ist zwingend erforderlich!</small></div>\r\n<div style="text-align:right;" onclick="this.innerHTML=document.getElementById(\\''legend1\\'').innerHTML;"><small style="cursor: pointer;">Hilfe anzeigen<br /></small></div>'';\r\n// Einzelne Tabellenelemente\r\n$mip_form[''9''][''cat''] = ''txtarea'';\r\n$mip_form[''9''][''type''] = ''long'';\r\n$mip_form[''9''][''rows''] = ''10'';\r\n$mip_form[''9''][''desc''] = ''Layout der einzelnen Tabellenelemente (also {content} im Template oben)<br/>'';\r\n$mip_form[''9''][''cms_var''] = ''MOD_VAR[9]'';\r\n$mip_form[''9''][''cms_val''] = $cms_mod[''value''][''9''];\r\n$mip_form[''9''][''cms_val_default''] = "<td align=\\"center\\">\r\n<span class=\\"{font4}\\">{title}</span><br />\r\n  <a href=\\"javascript:new_imagepopup(''{path}{urlencode}{file}{/urlencode}'',''{title}'',''{description}'','''',''{width}'',''{height}'',''true'')\\">\r\n    <img src=\\"{path}{thumbfile}\\" {maximgsize} border=\\"0\\" alt=\\"{filedesc}\\" />\r\n  </a><br/ >\r\n  <span class=\\"{font5}\\">{description}<br/ >\r\n  Dateigrsse: {filesize}</span>\r\n</td>";\r\n// legend Einzelne Tabellenelemente\r\n$mip_form[''90006''][''cat''] = ''desc'';\r\n$mip_form[''90006''][''type''] = '''';\r\n$mip_form[''90006''][''desc''] = ''<div id="legend2" style="display:none;text-align:right;"><small><strong>Inhaltselemente</strong><br/><small>{font1},{font2},{font3},<br/>{path},{real_path},{file},{thumbfile},{filename},<br/>{title},{filedesc},{description},<br/>{urlencode}data{/urlencode},<br/>{maximgsize},{maximgsize2},{filesize},<br/>{width},{height},{thumbwidth},{thumbheight},{detailurl},{idupl},{number}</small></div>\r\n<div style="text-align:right;" onclick="this.innerHTML=document.getElementById(\\''legend2\\'').innerHTML;"><small style="cursor: pointer;">Hilfe anzeigen<br /></small></div>'';\r\n\r\n        // Umschlieende Templates von den einzelnen Bilderzeilen\r\n        $mip_form[''30''][''desc''] = "Vor den einzelnen Bilderzeilen";\r\n        $mip_form[''30''][''cat''] = ''txt'';\r\n        $mip_form[''30''][''cms_var''] = ''MOD_VAR[30]'';\r\n        $mip_form[''30''][''cms_val''] = $cms_mod[''value''][''30''];\r\n        $mip_form[''30''][''cms_val_default''] = ''<tr>'';\r\n\r\n        $mip_form[''31''][''desc''] = "Nach den einzelnen Bilderzeilen";\r\n        $mip_form[''31''][''cat''] = ''txt'';\r\n        $mip_form[''31''][''cms_var''] = ''MOD_VAR[31]'';\r\n        $mip_form[''31''][''cms_val''] = $cms_mod[''value''][''31''];\r\n        $mip_form[''31''][''cms_val_default''] = ''</tr>'';\r\n\r\n\r\n##############################################\r\n# Detail Templates\r\n##############################################\r\n		  \r\n\r\n// Zurck Template\r\n$mip_form[''22''][''desc''] = "Zurck-Link Template in der Detailansicht:";\r\n$mip_form[''22''][''cat''] = ''txtarea'';\r\n$mip_form[''22''][''type''] = ''long'';\r\n$mip_form[''22''][''rows''] = ''1'';\r\n$mip_form[''22''][''cms_var''] = ''MOD_VAR[22]'';\r\n$mip_form[''22''][''cms_val''] = $cms_mod[''value''][''22''];\r\n$mip_form[''22''][''cms_val_default''] = "<a href=\\"{prev}\\">Bild zurck</a>&nbsp;&nbsp;|";\r\n\r\n// legend Zurck Template\r\n$mip_form[''90007''][''cat''] = ''desc'';\r\n$mip_form[''90007''][''type''] = '''';\r\n$mip_form[''90007''][''desc''] = ''<div id="legend3" style="display:none;text-align:right;"><small><strong>Inhaltselemente</strong><br/><small>{font1},{font2},{font3},{prev}, {idupl}</small></div>\r\n<div style="text-align:right;" onclick="this.innerHTML=document.getElementById(\\''legend3\\'').innerHTML;"><small style="cursor: pointer;">Hilfe anzeigen<br /></small></div>'';\r\n\r\n// VorTemplate\r\n$mip_form[''25''][''desc''] = "Vor-Link Template in der Detailansicht:";\r\n$mip_form[''25''][''cat''] = ''txtarea'';\r\n$mip_form[''25''][''type''] = ''long'';\r\n$mip_form[''25''][''rows''] = ''1'';\r\n$mip_form[''25''][''cms_var''] = ''MOD_VAR[25]'';\r\n$mip_form[''25''][''cms_val''] = $cms_mod[''value''][''25''];\r\n$mip_form[''25''][''cms_val_default''] = "|&nbsp;&nbsp;<a href=\\"{next}\\">Bild vor</a>";\r\n\r\n// legend VorTemplate\r\n$mip_form[''90008''][''cat''] = ''desc'';\r\n$mip_form[''90008''][''type''] = '''';\r\n$mip_form[''90008''][''desc''] = ''<div id="legend4" style="display:none;text-align:right;"><small><strong>Inhaltselemente</strong><br/><small>{font1},{font2},{font3},{next}, {idupl}</small></div>\r\n<div style="text-align:right;" onclick="this.innerHTML=document.getElementById(\\''legend4\\'').innerHTML;"><small style="cursor: pointer;">Hilfe anzeigen<br /></small></div>'';\r\n\r\n// Rcklink zur Galerie\r\n$mip_form[''23''][''desc''] = "Rcklink zur Galerie";\r\n$mip_form[''23''][''cat''] = ''txtarea'';\r\n$mip_form[''23''][''type''] = ''long'';\r\n$mip_form[''23''][''rows''] = ''1'';\r\n$mip_form[''23''][''cms_var''] = ''MOD_VAR[23]'';\r\n$mip_form[''23''][''cms_val''] = $cms_mod[''value''][''23''];\r\n$mip_form[''23''][''cms_val_default''] = "<a href=\\"{galerie}\\">Galerieseite {page_id}</a> <a href=\\"{galeriestart}\\">Galeriestartseite</a>";\r\n\r\n// legend Rcklink zur Galerie\r\n$mip_form[''90009''][''cat''] = ''desc'';\r\n$mip_form[''90009''][''type''] = '''';\r\n$mip_form[''90009''][''desc''] = ''<div id="legend5" style="display:none;text-align:right;"><small><strong>Inhaltselemente</strong><br/><small>{font1},{font2},{font3},{page_id},{galerie},{galeriestart}</small></div>\r\n<div style="text-align:right;" onclick="this.innerHTML=document.getElementById(\\''legend5\\'').innerHTML;"><small style="cursor: pointer;">Hilfe anzeigen<br /></small></div>'';\r\n\r\n//Vor und zurck zyklisch oder endend?\r\n$mip_form[''24''][''cat''] = ''radio'';\r\n$mip_form[''24''][''desc''] = ''Vor- und Zurck-Links in der Detailansicht <br/> zyklisch oder endend generieren?'';\r\n$mip_form[''24''][''cms_var''] = ''MOD_VAR[24]'';\r\n$mip_form[''24''][''cms_val''] = $cms_mod[''value''][''24''];\r\n$mip_form[''24''][''cms_val_default''] = ''zykl'';\r\n$mip_form[''24''][''option_desc''][''0''] = ''zyklisch'';\r\n$mip_form[''24''][''option_val''][''0''] = ''zykl'';\r\n$mip_form[''24''][''option_desc''][''1''] = ''endend'';\r\n$mip_form[''24''][''option_val''][''1''] = ''end'';\r\n\r\n// Detail Template\r\n$mip_form[''20''][''cat''] = ''txtarea'';\r\n$mip_form[''20''][''type''] = ''long'';\r\n$mip_form[''20''][''rows''] = ''10'';\r\n$mip_form[''20''][''desc''] = ''Layout der optionalen Detailansicht'';\r\n$mip_form[''20''][''cms_var''] = ''MOD_VAR[20]'';\r\n$mip_form[''20''][''cms_val''] = $cms_mod[''value''][''20''];\r\n$mip_form[''20''][''cms_val_default''] = "<table width=\\"100%\\">\r\n  <tr class=\\"{font1}\\">\r\n    <td align=\\"center\\">Bild {pic_id}/{pic_count}</td>\r\n  </tr>\r\n  <tr class=\\"{font2}\\">\r\n    <td align=\\"center\\">{prev}&nbsp;&nbsp;{galerie}&nbsp;&nbsp;{next}</td>\r\n   </tr>\r\n   <tr>\r\n     <td><table width=\\"100%\\"><tr><td align=\\"center\\"><img src=\\"{path}{file}\\" border=\\"0\\" alt=\\"{filedesc}\\"/ ></td></tr></table></td>\r\n  </tr>\r\n  <tr class=\\"{font2}\\">\r\n    <td align=\\"center\\">Bild ist von Seite {page_id}</td>\r\n  </tr>\r\n</table>";\r\n\r\n// legend Detail Template\r\n$mip_form[''90010''][''cat''] = ''desc'';\r\n$mip_form[''90010''][''type''] = '''';\r\n$mip_form[''90010''][''desc''] = ''<div id="legend6" style="display:none;text-align:right;"><small><strong>Inhaltselemente</strong><br/><small>{page_id},{font1},{font2},{font3},<br/>{prev},{next},{galerie},{path},{real_path},{file},{thumbfile},{filename},{title},\r\n{filedesc},{description},<br/>{maximgsize},{maximgsize2},{filesize},{width},{height},{pic_id},{idupl},{pic_count}</small></div>\r\n<div style="text-align:right;" onclick="this.innerHTML=document.getElementById(\\''legend6\\'').innerHTML;"><small style="cursor: pointer;">Hilfe anzeigen<br /></small></div>'';\r\n\r\n\r\n// mit detailtemp starten\r\n$mip_form[''60''][''desc''] = ''Direkt mit der Detailansicht beginnen?'';\r\n$mip_form[''60''][''cat''] = ''chk'';\r\n$mip_form[''60''][''option_var''][''0''] = ''MOD_VAR[60]'';\r\n$mip_form[''60''][''option_val''][''0''] = $cms_mod[''value''][''60''];\r\n$mip_form[''60''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''60''][''option_val_select''][''0''] = ''true'';\r\n\r\n// mit detailtemp starten\r\n$mip_form[''61''][''desc''] = ''Thumbnails in die Detailinsicht includen?'';\r\n$mip_form[''61''][''cat''] = ''chk'';\r\n$mip_form[''61''][''option_var''][''0''] = ''MOD_VAR[61]'';\r\n$mip_form[''61''][''option_val''][''0''] = $cms_mod[''value''][''61''];\r\n$mip_form[''61''][''option_desc''][''0''] = ''ja'';\r\n$mip_form[''61''][''option_val_select''][''0''] = ''true'';\r\n\r\n// <br>\r\n$mip_form[''99999''][''cat''] = ''desc'';\r\n$mip_form[''99999''][''type''] = '''';\r\n$mip_form[''99999''][''desc''] = '''';\r\n\r\n//if simple mode\r\nif($cms_mod[''value''][''0''] == ''''){\r\n   foreach ($mip_form[''hide_in_standard_mode'']  AS $ke=>$va){\r\n     $mip_form[$va][''cat''] = ''hidden'';\r\n   }\r\n }\r\n \r\n//if advanced mode\r\nif($cms_mod[''value''][''0''] == ''advanced''){\r\n   foreach ($mip_form[''hide_in_advanced_mode'']  AS $ke=>$va){\r\n     $mip_form[$va][''cat''] = ''hidden'';\r\n   }\r\n }\r\n\r\n\r\n\r\n#######################################################################################################################\r\n\r\nmip_forms_tabpane_beginp();\r\nif($cms_mod[''value''][''0''] == ''advanced''||$cms_mod[''value''][''0''] == ''detail'')\r\nmip_forms_tabitem_beginp(''Schriftarten'');	\r\nmip_formsp($mip_form[''1'']);\r\nmip_formsp($mip_form[''2'']);\r\nmip_formsp($mip_form[''3'']);\r\nmip_formsp($mip_form[''27'']);\r\nmip_formsp($mip_form[''28'']);\r\nif($cms_mod[''value''][''0''] == ''advanced''||$cms_mod[''value''][''0''] == ''detail'')\r\nmip_forms_tabitem_endp();\r\n\r\nif($cms_mod[''value''][''0''] == '''' ||$cms_mod[''value''][''0''] == ''advanced'' || $cms_mod[''value''][''0''] == ''detail'')\r\nmip_forms_tabitem_beginp('' generelle Einstellungen '');\r\n//Verzeichnis im Frontend bearbeiten?\r\nmip_formsp($mip_form[''51'']);\r\n\r\nif ($cms_mod[''value''][''51''] == false)\r\n{\r\nmip_formsp($mip_form[''4'']);\r\n}\r\n\r\nif ($cms_mod[''value''][''51''] == true)\r\n{mip_formsp($mip_form[''52'']);\r\n}\r\n\r\n//Unterordner verwenden?\r\nmip_formsp($mip_form[''26'']);\r\n\r\n//Anzahl der Bilder pro seite\r\nmip_formsp($mip_form[''6'']);\r\n//Wieviele Bilder nebeneinander?\r\nmip_formsp($mip_form[''7'']);\r\n\r\n//Startseite dieser Galerie?\r\nmip_formsp($mip_form[''5'']);\r\n\r\n//Sortierreihenfolge der Bilder\r\nmip_formsp($mip_form[''15'']);\r\n//Aufsteigend Absteigend?\r\nmip_formsp($mip_form[''16'']);\r\nif($cms_mod[''value''][''0''] == '''' ||$cms_mod[''value''][''0''] == ''advanced'' || $cms_mod[''value''][''0''] == ''detail'')\r\nmip_forms_tabitem_endp();\r\n\r\nif($cms_mod[''value''][''0''] == ''advanced'' || $cms_mod[''value''][''0''] == ''detail'')\r\nmip_forms_tabitem_beginp(''Bildergren'');\r\nmip_formsp($mip_form[''17'']);\r\nmip_formsp($mip_form[''21'']);\r\nif($cms_mod[''value''][''0''] == ''advanced'' || $cms_mod[''value''][''0''] == ''detail'')\r\nmip_forms_tabitem_endp();\r\n\r\nif($cms_mod[''value''][''0''] == ''advanced'' || $cms_mod[''value''][''0''] == ''detail'')\r\nmip_forms_tabitem_beginp(''Galerie-Walker'');\r\n//Vor und Zurcklinks\r\nmip_formsp($mip_form[''10'']);\r\nmip_formsp($mip_form[''13'']);\r\nmip_formsp($mip_form[''14'']);\r\nmip_formsp($mip_form[''11'']);\r\nmip_formsp($mip_form[''12'']);\r\n\r\n//Aktuelle Seite verlinken?\r\nmip_formsp($mip_form[''18'']);\r\nif($cms_mod[''value''][''0''] == ''advanced'' || $cms_mod[''value''][''0''] == ''detail'')\r\nmip_forms_tabitem_endp();\r\n\r\nif($cms_mod[''value''][''0''] == '''' ||$cms_mod[''value''][''0''] == ''advanced'' || $cms_mod[''value''][''0''] == ''detail'')\r\nmip_forms_tabitem_beginp(''Templates'');\r\n//Galerietabelle\r\nmip_formsp($mip_form[''8'']);\r\nmip_formsp($mip_form[''90005'']);\r\n\r\n//einzelne Elemente\r\nmip_formsp($mip_form[''9'']);\r\nmip_formsp($mip_form[''90006'']);\r\n\r\n//Umschlieendes Template\r\nmip_formsp($mip_form[''30'']);\r\nmip_formsp($mip_form[''31'']);\r\nmip_formsp($mip_form[''22'']);\r\nmip_formsp($mip_form[''90007'']);\r\nmip_formsp($mip_form[''25'']);\r\nmip_formsp($mip_form[''90008'']);\r\nmip_formsp($mip_form[''23'']);\r\nmip_formsp($mip_form[''90009'']);\r\nmip_formsp($mip_form[''99999'']);\r\nmip_formsp($mip_form[''24'']);\r\n\r\n//Detailtemplate\r\nmip_formsp($mip_form[''20'']);\r\nmip_formsp($mip_form[''90010'']);\r\n\r\n//Detailtemplate\r\nmip_formsp($mip_form[''60'']);\r\nmip_formsp($mip_form[''61'']);\r\nif($cms_mod[''value''][''0''] == '''' ||$cms_mod[''value''][''0''] == ''advanced'' || $cms_mod[''value''][''0''] == ''detail'')\r\nmip_forms_tabitem_endp();\r\n\r\n}\r\nunset($mip_form);\r\n?>', '<CMSPHP>\r\n\r\n// Version 3.5.0\r\n// (c) 2005 by Sascha Postner v/o saschapi\r\n\r\n//Achtung! Es sind noch einige Wasserzeichengeschichten in dieser Version enthalten\r\n//Wasserzeichen werden jedoch NICHT mehr untersttzt. \r\n\r\n\r\n##########################################################################################################################\r\n//Hier lagere ich mal ein paar Funktionen aus\r\n##########################################################################################################################\r\n\r\n\r\n//Funktion zum erstellen von Wasserzeichen\r\n	if (!function_exists(''make_watermark_image_galerie'')) {\r\n		function make_watermark_image_galerie($image, $watermarkfile, $new_image, $x, $y, $transition) {\r\n			global $cfg_cms, $cfg_client;\r\n			require_once ''Image/Transform.php'';\r\n			$cms_image = Image_Transform::factory($cfg_cms[''image_mode'']);\r\n			$cms_image->load($image);\r\n			$cms_watermark = Image_Transform::factory($cfg_cms[''image_mode'']);\r\n			$cms_watermark->load($watermarkfile);\r\n\r\n			//if ($x != $cms_image->img_x || $y != $cms_image->img_y) $cms_image->resize($x, $y);\r\n			//$watermark = imagecreatefromstring(base64_decode($watermarkfile));\r\n                         $watermark_width = imagesx($cms_watermark->imageHandle);\r\n                         $watermark_height = imagesy($cms_watermark->imageHandle);\r\n			//(Bild, Watermark, Position des Watermarks X, Position des Watermarks Y, Breite des Bilds, Hhe des Bilds Y, Breite des Watermarks, Hhe des Bildes, Transparenz)\r\n			imagecopymerge($cms_image->imageHandle, $cms_watermark->imageHandle, $x, $y, 0, 0, $watermark_width, $watermark_height, $transition);\r\n			$cms_image->save($new_image);\r\n			$cms_image->free();\r\n			unset($cms_image);\r\n		}\r\n	}\r\n\r\n\r\n//Funktion zum auslesen der Thumbgren\r\n	if (!function_exists(''get_thumb_size'')) {\r\n		function get_thumb_size($xy, $thumb) {\r\n			global $cfg_cms, $cfg_client;\r\n			require_once ''Image/Transform.php'';\r\n			$cms_image = Image_Transform::factory($cfg_cms[''image_mode'']);\r\n			$cms_image->load($thumb);\r\n\r\n			//if ($x != $cms_image->img_x || $y != $cms_image->img_y) $cms_image->resize($x, $y);\r\n			//$watermark = imagecreatefromstring(base64_decode($watermarkfile));\r\n                         $width = imagesx($cms_image->imageHandle);\r\n                         $height = imagesy($cms_image->imageHandle);\r\n			 $cms_image->free();\r\n			 unset($cms_image);\r\n\r\n			 if ($xy == ''x'') {\r\n			 return $width;\r\n			 }\r\n			 elseif ($xy == ''y'') {\r\n			 return $height;\r\n			 }\r\n\r\n		}\r\n	}\r\n\r\n\r\n\r\n//Funktion zum umwandeln von Bilder IDs in Pfade\r\n    if(! function_exists(get_path)){\r\n			    function get_path($id)\r\n			    {\r\n			     global $cfg_cms, $cfg_client, $cms_db, $db, $cms_mod;\r\n\r\n			     $sql = "SELECT A.*, B.dirname\r\n			     FROM\r\n			     ".$cms_db[''upl''] ." as A, ". $cms_db[''directory''] ." as B\r\n			     WHERE\r\n			     idupl=''".$id."''\r\n			     AND\r\n			     A.iddirectory = B.iddirectory";\r\n\r\n			     $db->query($sql);\r\n			     $db->next_record();\r\n			     $filepath = $cfg_client["upl_path"].$db->f(''dirname'').$db->f(''filename'');\r\n			     return $filepath;\r\n			    }\r\n			 }\r\n\r\n\r\n\r\n\r\n\r\n###########################################################################################################################\r\n#Hier ein paar Variablen, die wir berall brauchen\r\n###########################################################################################################################\r\n\r\n//Variable fr den Link zur aktuellen Seite mit Session ID\r\n$mod[''idcatlink''] =  $con_side[$idcatside][''link''];\r\n\r\n//Auslesen ob im Frontend-Editiert werden darf\r\n$mod[''frontedit''] = "MOD_VALUE[51]";\r\n\r\n//Auslesen ob mit Detailansicht gestartet wird\r\n$mod[''detailid_start''] = "MOD_VALUE[60]";\r\n\r\n//Auslesen ob Thumbs in der Detailansicht verwendet werden\r\n$mod[''detailid_thumb''] = "MOD_VALUE[61]";\r\n\r\n//Ordner beim Editieren im Frontend (inkl. Container fr mehrere Galerien pro Seite\r\n$mod[''change_dir_string''] = "change_dir_".$cms_mod[''container''][''id''];\r\n$mod[''change_dir''] = ${$mod[''change_dir_string'']};\r\n\r\n//Anzahl der Bilder pro Seite\r\n$mod["number_of_pics_per_page"] = MOD_VALUE[6];\r\n\r\n//Anzahl der Bilder pro Zeile\r\n$mod["break_after_number_of_pics"] = MOD_VALUE[7];\r\n\r\n//Thumbtext im Projekt\r\n$mod["filename_suffix"] = $cfg_client["thumbext"];\r\n\r\n//Auslesen welche Galerieseite angezeigt werden soll\r\nif (isset($galerie))\r\n{\r\n     $mod["galerie"] = array();\r\n     $mod["galerie"] = explode("_",$galerie);\r\n     for ($i = 0; $i < count($mod["galerie"])/2; $i++)\r\n     { if ($cms_mod[''container''][''id''] == $mod["galerie"][$i*2])\r\n       { $id = $mod["galerie"][$i*2+1];\r\n       }\r\n       else\r\n       { $mod[''query''] .= "_" . $mod["galerie"][$i*2] . "_" . $mod["galerie"][$i*2+1];\r\n       }\r\n     }\r\n}\r\n\r\n//soll eine bestimmte Galerieseite angezeigt werden?\r\nif (!isset($id))\r\n{ if ("MOD_VALUE[5]" == "1")\r\n  { $id = 1;\r\n  }\r\n  else\r\n  { $id = "MOD_VALUE[5]";\r\n  }\r\n}\r\n\r\n//Falls Thumbs in der Detailansicht gezeigt werden umblttern bei Detailbildern\r\nif ($mod[''detailid_thumb''] AND !$galerie AND $detailid) {\r\n$id = ceil($detailid / $mod["number_of_pics_per_page"]);\r\n}\r\n\r\n// Automatisch die Dateilseiten zeigen und dann beim umblttern die neueste Detailid zeigen\r\nif(!isset($detailid) AND $sess->name != ''cms'' AND $mod[''detailid_start'']  AND !$galerie) {\r\n  $detailid = 1;\r\n} elseif (!isset($detailid) AND $sess->name != ''cms'' AND $mod[''detailid_start'']  AND $galerie) {\r\n $detailid = (($id-1) * $mod["number_of_pics_per_page"])+1 ;\r\n}\r\n\r\n\r\n##########################################################################################################################\r\n  // FRONTEND BEARBEITUNG (wird in der Detailansicht ausgeschlossen! Habe das fr nicht sinnvoll gehalten. Lt sich aber leicht wieder aktivieren.)\r\n##########################################################################################################################\r\n\r\n//Frontend-editieren\r\nif ($mod[''frontedit''] == true)\r\n\r\n    {\r\n\r\n    //bjoerns funktion\r\n    if(! function_exists(get_val)){\r\n    function get_val($value_name)\r\n    {\r\n     global $idcatside, $cms_db, $db, $con_side, $cms_mod;\r\n\r\n     $sql = "SELECT\r\n        *\r\n       FROM\r\n        ".$cms_db[''content_external''] ."\r\n       WHERE\r\n        idsidelang=''".$con_side[$idcatside][''idsidelang'']."''\r\n        AND container=''".$cms_mod[''container''][''id'']."''\r\n        AND idtype=''$value_name''";\r\n     $db->query($sql);\r\n     $db->next_record();\r\n\r\n     return $db->f(''value'');\r\n    }\r\n    }\r\n\r\n    if(! function_exists(set_val)){\r\n    function set_val($value_name, $value)\r\n    {\r\n     global $idcatside, $cms_db, $db, $con_side, $cms_mod;\r\n     //Schauen, ob es den Wert schon gibt\r\n     $sql = "SELECT\r\n        *\r\n       FROM\r\n        ".$cms_db[''content_external''] ."\r\n       WHERE\r\n        idsidelang=''".$con_side[$idcatside][''idsidelang'']."''\r\n        AND container=''".$cms_mod[''container''][''id'']."''\r\n        AND idtype=''$value_name''";\r\n     $db->query($sql);\r\n\r\n     //Es gibt den Wert schon -> wert aktuallisieren\r\n     if ($db->next_record()){\r\n      $sql = "UPDATE\r\n         ". $cms_db[''content_external''] ."\r\n        SET\r\n         value=''$value''\r\n        WHERE\r\n         idsidelang=''".$con_side[$idcatside][''idsidelang'']."''\r\n         AND container=''".$cms_mod[''container''][''id'']."''\r\n         AND idtype=''$value_name''";\r\n     }\r\n     //Es gibt den Wert noch nicht, neu in tabelle einfgen\r\n     else{\r\n      $sql = "INSERT INTO\r\n         ". $cms_db[''content_external''] ."\r\n         (idsidelang, container, idtype, value)\r\n        VALUES\r\n         (''".$con_side[$idcatside][''idsidelang'']."'',\r\n          ''".$cms_mod[''container''][''id'']."'',\r\n          ''$value_name'', ''$value'')";\r\n     }\r\n\r\n     $db->query($sql);\r\n\r\n    //Letzte nderung Datum ndern!\r\n    $sql = "UPDATE ". $cms_db[''side_lang'']. " SET lastmodified=''".time()."'' WHERE idsidelang=''".$con_side[$idcatside][''idsidelang'']."'' ";\r\n                    $db->query($sql);\r\n\r\n     //Cache lschen\r\n     //Seite frs frontend neu generieren, da sich ein Wert gendert hat\r\n     change_code_status($idcatside, 1, ''idcatside'');\r\n\r\n    }\r\n    }\r\n\r\n    //Editierwechsel beachten\r\n                            if  ($mod[''change_dir'']) {\r\n                                     //Formular ist abgeschickt worden\r\n                                    //Neuen Wert in die DB einfgen\r\n                                    set_val(''galerie_folder'', $mod[''change_dir'']);\r\n                                            }\r\n\r\n    //Wert aus der DB holen\r\n    $mod[''galerie_folder''] = get_val(''galerie_folder'');\r\n\r\n\r\n    //Bearbeitenbutton\r\n    $aktverz = $mod[''galerie_folder''];\r\n    if ($cms_side[''edit'']) {\r\n\r\n    //Startverzeichnis auslesen\r\n    $mod[''startdir''] = "MOD_VALUE[52]";\r\n\r\n    if ($mod[''startdir'']) {\r\n\r\n    //Startverzeichnis Namen auslesen\r\n    $sql = "SELECT A.dirname\r\n       FROM\r\n        ".$cms_db[''directory''] ." as A\r\n       WHERE\r\n        A.iddirectory=''".$mod[''startdir'']."''\r\n    ORDER BY dirname";\r\n    $db -> query($sql);\r\n    $db->next_record();\r\n\r\n    $mod[''startdirname''] =  $db->f(''dirname'');\r\n\r\n     }\r\n\r\n\r\n    if ($mod[''startdirname'']) {\r\n\r\n    //Dateimanager Verzeichnisse auslesen mit Startverzeichnis\r\n    $sql = "SELECT A.iddirectory, A.dirname\r\n       FROM\r\n        ".$cms_db[''directory''] ." as A\r\n       WHERE\r\n        A.idclient=''".$client."''\r\n        AND A.status & 0x05 = 0x00\r\n        AND A.dirname like ''".$mod[''startdirname'']."%''\r\n\r\n    ORDER BY dirname";\r\n    $result = mysql_query($sql);\r\n\r\n    }else{\r\n\r\n    //Dateimanager Verzeichnisse auslesen\r\n    $sql = "SELECT A.iddirectory, A.dirname\r\n       FROM\r\n        ".$cms_db[''directory''] ." as A\r\n       WHERE\r\n        A.idclient=''".$client."''\r\n        AND A.status & 0x05 = 0x00\r\n\r\n    ORDER BY dirname";\r\n    $result = mysql_query($sql);\r\n\r\n    }\r\n\r\n\r\n\r\n    //Aktion auf aktuelle Seite legen\r\n    $action = $con_side[$idcatside][''link''];\r\n    //Bearbeitungsformular ausgeben\r\n    echo "<div align=\\"center\\"><form method=\\"POST\\" action=\\"$action\\"><select name=\\"change_dir_".$cms_mod[''container''][''id'']."\\" size=\\"1\\">";\r\n\r\n    while ($row = mysql_fetch_array($result, MYSQL_ASSOC))\r\n    {\r\n\r\n    if($perm->have_perm(0x01, "folder", $row[''iddirectory'']))\r\n    {\r\n    if ($mod[''galerie_folder''] == $row[''iddirectory''])\r\n    { echo "<option  selected value=\\""; }\r\n    else { echo "<option value=\\"";}\r\n      echo $row[''iddirectory''];\r\n      echo "\\">";\r\n      echo $row[''dirname''];\r\n      echo "</option>";\r\n    }}\r\n    echo"</select>";\r\n    echo"<input type=\\"submit\\" value=\\"Submit\\">";\r\n\r\n		//Kstchen fr Watermark neu Berechnung einfgen wenn Watermarkpfad vorhanden\r\n		if (($mod[''watermark_thumb_id'']) OR ($mod[''watermark_thumb_id''])) {\r\n		    echo"<input type=\\"checkbox\\" name=\\"resample_watermarks\\"> Wasserzeichen neu berechnen?";\r\n		   }\r\n\r\necho"</form></div>";\r\n\r\n\r\n    unset($cms_side[''edit'']);\r\n    }\r\n\r\n\r\n    }\r\n    //END-Frontend-Editieren\r\n    else\r\n    {\r\n    //Wenn der Ordner in der Konfiguration eingestellt wird\r\n    $mod[''galerie_folder''] = "MOD_VALUE[4]";\r\n}\r\n\r\n\r\n##########################################################################################################################\r\n  // Daten ermitteln\r\n##########################################################################################################################\r\n//Ist das Verzeichnis in der Datenbank? False bedeutet ja! Weiter unten in der if schleife wird das nochmal mglichweise nochmal berschrieben!\r\n//Das ist wichtig fr das Bearbeiten im Frontend. When false wird die Galerie angezeigt, wenn true bedeutet das, dass der Wert in der DB noch nicht\r\n//gesetzt ist, was zu einem SQL-Fehler fhren wrde, der so abgefangen wird!\r\n$mod[''no_dir''] = false;\r\n\r\n\r\n//diese if-schleife fngt den SQL-Fehler ab wenn im FE noch kein Verzeicnis festgelegt wurde\r\nif ( ($mod[''galerie_folder''] ==false) AND ($mod[''frontedit''] == true))\r\n	{\r\n	$mod[''error_no_dir''] = "<div align=\\"center\\" class=\\"{font1}\\">Diese Galerie ist noch nicht eingerichtet worden.</div>";\r\n	$mod[''error_no_dir''] = str_replace("{font1}", "MOD_VALUE[1]", $mod[''error_no_dir'']);\r\n	echo $mod[''error_no_dir''];\r\n	$mod[''no_dir''] = true;\r\n	}\r\nelse\r\n	{\r\n    //Mit dieser if-Schleife wird fr Unterordner gesorgt und fr "Alle Ordner"\r\n    if ( ($mod[''galerie_folder''] ==false) AND ($mod[''frontedit''] == false))\r\n        {\r\n        $sql = "SELECT A.*, B.dirname\r\n                            FROM " . $cms_db[''upl''] . " as A, ". $cms_db[''directory''] ." as B\r\n\r\n                            WHERE\r\n                                    A.idclient = ''$client''\r\n                            AND\r\n                                    A.iddirectory = B.iddirectory\r\n                            AND\r\n                                    idfiletype = 3\r\n                            ORDER BY\r\n                                    A." . "MOD_VALUE[15]" . " " . "MOD_VALUE[16]";\r\n        }\r\n\r\n    else\r\n        {\r\n        	//Unterordner bercksichtigen?\r\n            if ("MOD_VALUE[26]" == true)\r\n                {\r\n\r\n				//Name des eingestellten Verzeichnisses auslesen\r\n    			$sqlsub = "SELECT A.dirname\r\n       			FROM\r\n        		".$cms_db[''directory''] ." as A\r\n       			WHERE\r\n        		A.iddirectory=''".$mod[''galerie_folder'']."''\r\n    			ORDER BY dirname";\r\n    			$db -> query($sqlsub);\r\n    			$db->next_record();\r\n			    $mod[''name_of_galerie_folder''] =  $db->f(''dirname'');\r\n\r\n				//IDs der Unterordner auslesen\r\n			    $sqlsub = "SELECT A.iddirectory\r\n       			FROM\r\n        		".$cms_db[''directory''] ." as A\r\n       			WHERE\r\n        		A.idclient=''".$client."''\r\n			    AND A.dirname like ''".$mod[''name_of_galerie_folder'']."%''";\r\n				$mod[''sub_dirs''] = mysql_query($sqlsub);\r\n\r\n  				//array mit den ids fllen\r\n  				$mod[''sub_dirs_ids''] = array();\r\n  				while ($row = mysql_fetch_array($mod[''sub_dirs''], MYSQL_ASSOC))\r\n   				 {\r\n   				  array_push($mod[''sub_dirs_ids''], "OR B.parentid = ".$row[''iddirectory'']."");\r\n				 }\r\n   				 $mod[''sub_dirs_ids''] = implode(" ", $mod[''sub_dirs_ids'']);\r\n\r\n				//SQL Where Abfrage fr Unterverzeichnisse fllen\r\n                $mod[''where''] = "(A.iddirectory = ". $mod[''galerie_folder''] ." ".$mod[''sub_dirs_ids''].")";\r\n                }\r\n                                else\r\n                {\r\n                $mod[''where''] = "A.iddirectory = ". $mod[''galerie_folder''] ." ";\r\n                }\r\n\r\n        $sql = "SELECT A.*, B.dirname\r\n            FROM " . $cms_db[''upl''] . " as A, ". $cms_db[''directory''] ." as B\r\n\r\n            WHERE\r\n                " . $mod[''where''] . "\r\n            AND\r\n                A.idclient = ''$client''\r\n            AND\r\n                A.iddirectory = B.iddirectory\r\n            ORDER BY\r\n                A." . "MOD_VALUE[15]" . " " . "MOD_VALUE[16]";\r\n        }\r\n\r\n             $db->query($sql);\r\n             $i = 0;\r\n\r\n             //Anfang von while\r\n             while ($db->next_record() )\r\n             { $mod["file"][$i]["title"] = $db->f(''titel'');\r\n               $mod["file"][$i]["filename"] = $db->f(''filename'');\r\n               $mod["file"][$i]["idupl"] = $db->f(''idupl'');\r\n               $mod["file"][$i]["description"] = $db->f(''description'');\r\n               $mod["file"][$i]["dirname"] = $db->f(''dirname'');\r\n               $mod["file"][$i]["filesize"] = $db->f(''filesize'');\r\n               $mod["file"][$i]["width"] = $db->f(''pictwidth'');\r\n               $mod["file"][$i]["height"] = $db->f(''pictheight'');\r\n               $mod["file"][$i]["thumbwidth"] = $db->f(''pictthumbwidth'');\r\n               $mod["file"][$i]["thumbheight"] = $db->f(''pictthumbheight'');\r\n            ### BEGIN filter  fr <order>\r\n                   if (strstr($mod["file"][$i]["description"],"<order>"))\r\n                   { $mod[''order_firstpos''] = strpos($mod["file"][$i]["description"],"<order>")+7;\r\n                     $mod[''order_lastpos'']  = strpos($mod["file"][$i]["description"],"</order>");\r\n                     $mod["file"][$i][''order''] = substr($mod["file"][$i]["description"],$mod[''order_firstpos''],$mod[''order_lastpos'']-$mod[''order_firstpos'']);\r\n                     $mod[''order_tag''] = "<order>". $mod["file"][$i][''order''] ."</order>";\r\n                     $mod["file"][$i]["description"] = str_replace($mod[''order_tag''], "" ,$mod["file"][$i]["description"]);\r\n                   }\r\n                   else\r\n                   { $mod["file"][$i][''order''] = "ZZZ";   // wenn keine Reihenfolge definiert, dann hinten dran\r\n                   }\r\n            ### END filter  fr <order>\r\n\r\n            ### BEGIN  maximgsize\r\n            if ("MOD_VALUE[17]" != "")\r\n            {\r\n                                    if ( ($mod["file"][$i]["width"] > "MOD_VALUE[17]") OR ( $mod["file"][$i]["height"] > "MOD_VALUE[17]") )\r\n                                    { if ($mod["file"][$i]["width"] > $mod["file"][$i]["height"])\r\n                                      {    $mod["file"][$i]["h_show"] = round($mod["file"][$i]["height"] * "MOD_VALUE[17]" / $mod["file"][$i]["width"]);\r\n                                           $mod["file"][$i]["w_show"] = "MOD_VALUE[17]";\r\n                                      }\r\n                                      ELSE\r\n                                      {    $mod["file"][$i]["w_show"] = round($mod["file"][$i]["width"] * "MOD_VALUE[17]" / $mod["file"][$i]["height"]);\r\n                                           $mod["file"][$i]["h_show"] = "MOD_VALUE[17]";\r\n                                      }\r\n                                    }\r\n                                    ELSE\r\n                                    { $mod["file"][$i]["w_show"] = $mod["file"][$i]["width"];\r\n                                      $mod["file"][$i]["h_show"] = $mod["file"][$i]["height"];\r\n                                    }\r\n               $mod["file"][$i]["maximgsize"] = "width=\\"" . $mod["file"][$i]["w_show"] . "\\" height=\\"" . $mod["file"][$i]["h_show"] . "\\"";\r\n            }\r\n            ### END maximgsize\r\n            ### BEGIN  maximgsize2\r\n            if ("MOD_VALUE[21]" != "")\r\n            {\r\n                                    if ( ($mod["file"][$i]["width"] > "MOD_VALUE[21]") OR ( $mod["file"][$i]["height"] > "MOD_VALUE[21]") )\r\n                                    { if ($mod["file"][$i]["width"] > $mod["file"][$i]["height"])\r\n                                      {    $mod["file"][$i]["h_show"] = round($mod["file"][$i]["height"] * "MOD_VALUE[21]" / $mod["file"][$i]["width"]);\r\n                                           $mod["file"][$i]["w_show"] = "MOD_VALUE[21]";\r\n                                      }\r\n                                      ELSE\r\n                                      {    $mod["file"][$i]["w_show"] = round($mod["file"][$i]["width"] * "MOD_VALUE[21]" / $mod["file"][$i]["height"]);\r\n                                           $mod["file"][$i]["h_show"] = "MOD_VALUE[21]";\r\n                                      }\r\n                                    }\r\n                                    ELSE\r\n                                    { $mod["file"][$i]["w_show"] = $mod["file"][$i]["width"];\r\n                                      $mod["file"][$i]["h_show"] = $mod["file"][$i]["height"];\r\n                                    }\r\n               $mod["file"][$i]["maximgsize2"] = "width=\\"" . $mod["file"][$i]["w_show"] . "\\" height=\\"" . $mod["file"][$i]["h_show"] . "\\"";\r\n            }\r\n            ### END maximgsize2\r\n\r\n               $i++;\r\n\r\n            // Ende von while\r\n             }\r\n\r\n	//Ende der if-else-schleife fr das Abfangen des SQL-Fehlers bei nicht vergebenem Verzeichnis\r\n	}\r\n\r\n\r\n    ### BEGIN individual order\r\n    if (MOD_VALUE[15] == "description")\r\n    {\r\n      function cmp ($a, $b)\r\n      { return strcmp($a["order"], $b["order"]);\r\n      }\r\n      function rcmp ($a, $b)\r\n      { return strcmp($b["order"], $a["order"]);\r\n      }\r\n\r\n      if (MOD_VALUE[16] == "ASC")\r\n      { usort($mod["file"], "cmp");}\r\n      else\r\n      { usort($mod["file"], "rcmp");}\r\n    }\r\n    ###  // END individual order\r\n\r\n\r\n\r\n    $i = ($id - 1) * $mod["number_of_pics_per_page"];\r\n    $mod["last_pic"] = $id * $mod["number_of_pics_per_page"];\r\n    if ($mod["last_pic"] > count($mod["file"]))\r\n   		 { $mod["last_pic"] = count($mod["file"]);\r\n    	 }\r\n\r\n##########################################################################################################################\r\n  // Galerie-Walker:\r\n##########################################################################################################################\r\n\r\nif ( !function_exists(''galeriecreatePageLinks'') ) {\r\nfunction galeriecreatePageLinks($isFloating, $separator, $showNavLinks) {\r\n        global $mod, $cfg_client, $idcatside, $id, $cms_mod;\r\n        if ($isFloating > 0) {\r\n                $floatdiff = ceil($isFloating / 2);\r\n\r\n                $start = $id - $floatdiff;\r\n                if ($start > $mod["anz"]) $start = $mod["anz"] - $floatdiff;\r\n                if ($start < 1) $start = 1;\r\n\r\n                $stop = $id + $floatdiff;\r\n                if ($stop > $mod["anz"]) $stop = $mod["anz"];\r\n        } else {\r\n                $start = 1;\r\n                $stop = $mod["anz"];\r\n        }\r\n\r\n        if ($id > 1 && $showNavLinks == ''true'') {\r\n                $previd = $id - 1;\r\n                $returnvalue .= "<a href=\\"".$mod[''idcatlink'']."&amp;galerie=".$cms_mod[''container''][''id'']."_".$previd.$mod[''query'']."\\">MOD_VALUE[13]</a>";\r\n        }\r\n\r\n        for ( $mod["pagecounter"] = $start; $mod["pagecounter"] <= $stop; $mod["pagecounter"]++ )\r\n        {\r\n                if ($mod["pagecounter"] > $start) $returnvalue .= $separator;\r\n                if ($mod["pagecounter"] == $id) {\r\n                       if ("MOD_VALUE[18]" == false){\r\n                        $returnvalue .= "<span class=\\"MOD_VALUE[3]\\">[".$mod["pagecounter"]."]</span>";\r\n                        } else {\r\n                        $returnvalue .= "<a href=\\"".$mod[''idcatlink'']."&amp;galerie=".$cms_mod[''container''][''id'']."_".$mod["pagecounter"].$mod[''query'']."\\"><span class=\\"MOD_VALUE[3]\\">[".$mod["pagecounter"]."]</span></a>";\r\n                        }\r\n                } else {\r\n                        $returnvalue .= "<a href=\\"".$mod[''idcatlink'']."&amp;galerie=".$cms_mod[''container''][''id'']."_".$mod["pagecounter"].$mod[''query'']."\\"><span class=\\"MOD_VALUE[2]\\">".$mod["pagecounter"]."</span></a>";\r\n                }\r\n        }\r\n\r\n        if ($id < $mod["anz"] && $showNavLinks == ''true'') {\r\n                $nextid = $id + 1;\r\n                $returnvalue .= "<a href=\\"".$mod[''idcatlink'']."&amp;galerie=".$cms_mod[''container''][''id'']."_".$nextid.$mod[''query'']."\\">MOD_VALUE[14]</a>";\r\n        }\r\n        return $returnvalue;\r\n}  // end function\r\n\r\n} // end if exist\r\n\r\n// gesamtanzahl der seiten herausfinden\r\n$mod["anz"] = ceil(count($mod["file"]) / $mod["number_of_pics_per_page"]);\r\n\r\n// wenn mod_value_12 leer ist, default-separator verwenden.\r\nif ("MOD_VALUE[12]" == "")\r\n{\r\n        $separator = "&nbsp;&nbsp;|&nbsp;&nbsp;";\r\n} else {\r\n        $separator = "MOD_VALUE[12]";\r\n}\r\n\r\n// vor/zurck-links anzeigen?\r\nif ($mod["anz"]> 1)$mod["walker"] .= galeriecreatePageLinks("MOD_VALUE[11]", $separator, "MOD_VALUE[10]");\r\n\r\n##########################################################################################################################\r\n  // Ausgabe\r\n##########################################################################################################################\r\nfor($i;$i<$mod["last_pic"];$i++)\r\n{\r\n  //\r\n\r\n\r\n  $mod[''temp''] = "MOD_VALUE[9]";\r\n\r\n  $mod["file"][$i]["filename"] = trim($mod["file"][$i]["filename"]);\r\n\r\n  $mod["file_ext"] = substr (strrchr ($mod["file"][$i]["filename"], "."), 1);\r\n  $mod["filename"] = substr ($mod["file"][$i]["filename"], 0, -(strlen($mod["file_ext"]))-1 );\r\n\r\n\r\n\r\n\r\n\r\n\r\n//Wasserzeichen\r\n\r\n\r\n//Wasserzeichenposition errechnen\r\n\r\n//links oben\r\nif ($mod[''watermark_image_location''] == ''lo'') {\r\n\r\n}\r\n//mitte oben\r\nelseif ($mod[''watermark_image_location''] == ''mo'') {\r\n $mod[''watermark_image_positionxx''] = (($mod["file"][$i]["width"] / 2) + ($mod[''watermark_image_positionx'']));\r\n}\r\n//rechts oben\r\nelseif ($mod[''watermark_image_location''] == ''ro'') {\r\n $mod[''watermark_image_positionxx''] = ($mod["file"][$i]["width"] + ($mod[''watermark_image_positionx'']));\r\n}\r\n//links mitte\r\nelseif ($mod[''watermark_image_location''] == ''lm'') {\r\n $mod[''watermark_image_positionyy''] = (($mod["file"][$i]["height"] / 2) + ($mod[''watermark_image_positiony'']));\r\n}\r\n//mitte mitte\r\nelseif ($mod[''watermark_image_location''] == ''mm'') {\r\n $mod[''watermark_image_positionxx''] = (($mod["file"][$i]["width"] / 2) + ($mod[''watermark_image_positionx'']));\r\n $mod[''watermark_image_positionyy''] = (($mod["file"][$i]["height"] / 2) + ($mod[''watermark_image_positiony'']));\r\n}\r\n//rechts mitte\r\nelseif ($mod[''watermark_image_location''] == ''rm'') {\r\n $mod[''watermark_image_positionxx''] = ($mod["file"][$i]["width"] + ($mod[''watermark_image_positionx'']));\r\n $mod[''watermark_image_positionyy''] = (($mod["file"][$i]["height"] / 2) + ($mod[''watermark_image_positiony'']));\r\n}\r\n//links unten\r\nelseif ($mod[''watermark_image_location''] == ''lu'') {\r\n $mod[''watermark_image_positionyy''] = ($mod["file"][$i]["height"] + ($mod[''watermark_image_positiony'']));\r\n}\r\n//mitte unten\r\nelseif ($mod[''watermark_image_location''] == ''mu'') {\r\n $mod[''watermark_image_positionxx''] = (($mod["file"][$i]["width"] / 2) + ($mod[''watermark_image_positionx'']));\r\n $mod[''watermark_image_positionyy''] = ($mod["file"][$i]["height"] + ($mod[''watermark_image_positiony'']));\r\n}\r\n//rechts unten\r\nelseif ($mod[''watermark_image_location''] == ''ru'') {\r\n $mod[''watermark_image_positionxx''] = ($mod["file"][$i]["width"] + ($mod[''watermark_image_positionx'']));\r\n $mod[''watermark_image_positionyy''] = ($mod["file"][$i]["height"] + ($mod[''watermark_image_positiony'']));\r\n}\r\n\r\n\r\n\r\n\r\n		if ($mod[''watermark_image_id'']) {\r\n\r\n			//Bildformat fr die Bilder bereitstellen\r\n			$mod[''watermark_image''] = $mod["file"][$i]["dirname"].$mod["filename"].$cfg_client[''thumbext''].''_watermark_image.''.strtolower($mod["file_ext"]);\r\n\r\n\r\n			//If Wasserzeichen ist nicht vorhanden aber Thumb ist vorhanden\r\n			 if ( (!@file_exists($cfg_client["upl_path"].$mod[''watermark_image'']) ) OR ($resample_watermarks)   )\r\n				{\r\n					make_watermark_image_galerie($cfg_client["upl_path"].$mod["file"][$i]["dirname"].$mod["filename"].".".strtolower($mod["file_ext"]), $mod[''watermark_image_path''], $cfg_client["upl_path"].$mod["file"][$i]["dirname"].$mod["filename"].$cfg_client[''thumbext''].''_watermark_image.''.strtolower($mod["file_ext"]), $mod[''watermark_image_positionxx''], $mod[''watermark_image_positionyy''], $mod[''watermark_image_transparent'']);\r\n					$mod[''temp''] = str_replace("{file}",$mod["filename"].$cfg_client[''thumbext''].''_watermark_image.''.strtolower($mod["file_ext"]),$mod[''temp'']);\r\n		    }\r\n				elseif ((strtolower($mod["file_ext"])) == "gif")\r\n				     {\r\n				     $mod[''temp''] = str_replace("{file}", $mod["file"][$i]["filename"] ,$mod[''temp'']);\r\n				     }\r\n\r\n\r\n				     else\r\n					{\r\n						$mod[''temp''] = str_replace("{file}",$mod["filename"].$cfg_client[''thumbext''].''_watermark_image.''.strtolower($mod["file_ext"]),$mod[''temp'']);\r\n					}\r\n\r\n\r\n\r\n				}\r\n\r\n			   else\r\n			   {\r\n\r\n                        $mod[''temp''] = str_replace("{file}", $mod["file"][$i]["filename"] ,$mod[''temp'']);\r\n\r\n  			   }\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n  //filedesc\r\n  if ($mod["file"][$i]["title"] != "")\r\n  { $mod["filedesc"] = $mod["file"][$i]["title"];\r\n  }\r\n  else\r\n  { $mod["filedesc"] = $mod["file"][$i]["filename"];\r\n  }\r\n  $mod[''temp''] = str_replace("{filedesc}",$mod["filedesc"] ,$mod[''temp'']);\r\n\r\n  //filename\r\n  $mod[''temp''] = str_replace("{filename}",$mod["filename"] ,$mod[''temp'']);\r\n\r\n  // path\r\n  $mod[''temp''] = str_replace("{path}",$cfg_client["upl_htmlpath"]  . $mod["file"][$i]["dirname"] ,$mod[''temp'']);\r\n  $mod[''temp''] = str_replace("{real_path}",$cfg_client["upl_path"]  . $mod["file"][$i]["dirname"] ,$mod[''temp'']);\r\n\r\n  // file\r\n  //$mod[''temp''] = str_replace("{file}", $mod["file"][$i]["filename"] ,$mod[''temp'']);\r\n\r\n  // idupl\r\n  $mod[''temp''] = str_replace("{idupl}", $mod["file"][$i]["idupl"] ,$mod[''temp'']);\r\n\r\n  // filesize\r\n  $mod[''temp''] = str_replace("{filesize}", round(($mod["file"][$i]["filesize"]/1024), 1)." kb" ,$mod[''temp'']);\r\n\r\n  // maximgsize\r\n  $mod[''temp''] = str_replace("{maximgsize}", $mod["file"][$i]["maximgsize"] ,$mod[''temp'']);\r\n\r\n  // maximgsize2\r\n  $mod[''temp''] = str_replace("{maximgsize2}", $mod["file"][$i]["maximgsize2"] ,$mod[''temp'']);\r\n\r\n  // width\r\n  $mod[''temp''] = str_replace("{width}", $mod["file"][$i]["width"] ,$mod[''temp'']);\r\n\r\n  // height\r\n  $mod[''temp''] = str_replace("{height}", $mod["file"][$i]["height"] ,$mod[''temp'']);\r\n\r\n  // title\r\n  $mod[''temp''] = str_replace("{title}", $mod["file"][$i]["title"] ,$mod[''temp'']);\r\n\r\n  // desc\r\n  $mod[''temp''] = str_replace("{description}",$mod["file"][$i]["description"],$mod[''temp'']);\r\n\r\n  // detailurl\r\n  $mod[''temp''] = str_replace("{detailurl}",$mod[''idcatlink''] . "&amp;detailid=" . ($i+1),$mod[''temp'']);\r\n\r\n  // number\r\n  $mod[''temp''] = str_replace("{number}", $i+1 ,$mod[''temp'']);  \r\n\r\n  ###################################################################################################################\r\n  #WASSERZEICHENERSTELLUNG\r\n  ###################################################################################################################\r\n  //Wasserzeichen fr Thumbs erstellen?\r\n\r\n\r\n  //Wasserzeichenposition errechnen\r\n\r\nif (file_exists($cfg_client["upl_path"].$mod["file"][$i]["dirname"].$mod["filename"].$cfg_client[''thumbext''].".".strtolower($mod["file_ext"]))) {\r\n  $mod["thumb_width"] = get_thumb_size(x, $cfg_client["upl_path"].$mod["file"][$i]["dirname"].$mod["filename"].$cfg_client[''thumbext''].".".strtolower($mod["file_ext"]));\r\n  $mod["thumb_height"] = get_thumb_size(y, $cfg_client["upl_path"].$mod["file"][$i]["dirname"].$mod["filename"].$cfg_client[''thumbext''].".".strtolower($mod["file_ext"]));\r\n  } else {\r\n   $mod["thumb_width"] = $mod["file"][$i]["width"];\r\n  $mod["thumb_height"] = $mod["file"][$i]["height"];\r\n  }\r\n\r\n  // thumbheight\r\n  $mod[''temp''] = str_replace("{thumbheight}", $mod["thumb_height"] ,$mod[''temp'']);\r\n\r\n  // thumbwidth\r\n  $mod[''temp''] = str_replace("{thumbwidth}", $mod["thumb_width"] ,$mod[''temp'']);\r\n\r\n\r\n//links oben\r\nif ($mod[''watermark_thumb_location''] == ''lo'') {\r\n\r\n}\r\n//mitte oben\r\nelseif ($mod[''watermark_thumb_location''] == ''mo'') {\r\n $mod[''watermark_thumb_positionxx''] = (($mod["thumb_width"] / 2) + ($mod[''watermark_thumb_positionx'']));\r\n}\r\n//rechts oben\r\nelseif ($mod[''watermark_thumb_location''] == ''ro'') {\r\n $mod[''watermark_thumb_positionxx''] = ($mod["thumb_width"] + ($mod[''watermark_thumb_positionx'']));\r\n}\r\n//links mitte\r\nelseif ($mod[''watermark_thumb_location''] == ''lm'') {\r\n $mod[''watermark_thumb_positionyy''] = (($mod["thumb_height"] / 2) + ($mod[''watermark_thumb_positiony'']));\r\n}\r\n//mitte mitte\r\nelseif ($mod[''watermark_thumb_location''] == ''mm'') {\r\n $mod[''watermark_thumb_positionxx''] = (($mod["thumb_width"] / 2) + ($mod[''watermark_thumb_positionx'']));\r\n $mod[''watermark_thumb_positionyy''] = (($mod["thumb_height"] / 2) + ($mod[''watermark_thumb_positiony'']));\r\n}\r\n//rechts mitte\r\nelseif ($mod[''watermark_thumb_location''] == ''rm'') {\r\n $mod[''watermark_thumb_positionxx''] = ($mod["thumb_width"] + ($mod[''watermark_thumb_positionx'']));\r\n $mod[''watermark_thumb_positionyy''] = (($mod["thumb_height"] / 2) + ($mod[''watermark_thumb_positiony'']));\r\n}\r\n//links unten\r\nelseif ($mod[''watermark_thumb_location''] == ''lu'') {\r\n $mod[''watermark_thumb_positionyy''] = ($mod["thumb_height"] + ($mod[''watermark_thumb_positiony'']));\r\n}\r\n//mitte unten\r\nelseif ($mod[''watermark_thumb_location''] == ''mu'') {\r\n $mod[''watermark_thumb_positionxx''] = (($mod["thumb_width"] / 2) + ($mod[''watermark_thumb_positionx'']));\r\n $mod[''watermark_thumb_positionyy''] = ($mod["thumb_height"] + ($mod[''watermark_thumb_positiony'']));\r\n}\r\n//rechts unten\r\nelseif ($mod[''watermark_thumb_location''] == ''ru'') {\r\n $mod[''watermark_thumb_positionxx''] = ($mod["thumb_width"] + ($mod[''watermark_thumb_positionx'']));\r\n $mod[''watermark_thumb_positionyy''] = ($mod["thumb_height"] + ($mod[''watermark_thumb_positiony'']));\r\n}\r\n\r\n\r\n\r\n\r\n\r\n		//Wasserzeichen in Thumbs einfgen?\r\n		if ($mod[''watermark_thumb_id'']) {\r\n\r\n\r\n\r\n			//Bildformat fr die Thumbs bereitstellen\r\n			$mod[''watermark_thumb''] = $mod["file"][$i]["dirname"].$mod["filename"].$cfg_client[''thumbext''].''_watermark_thumb.''.strtolower($mod["file_ext"]);\r\n\r\n\r\n					//If Wasserzeichen ist nicht vorhanden aber Thumb ist vorhanden\r\n				 if (((!@file_exists($cfg_client["upl_path"].$mod[''watermark_thumb''])) AND (file_exists($cfg_client["upl_path"].$mod["file"][$i]["dirname"].$mod["filename"].$cfg_client[''thumbext''].".".strtolower($mod["file_ext"]))) OR ($resample_watermarks)  ) )\r\n					{\r\n\r\n									make_watermark_image_galerie($cfg_client["upl_path"].$mod["file"][$i]["dirname"].$mod["filename"].$cfg_client[''thumbext''].".".strtolower($mod["file_ext"]), $mod[''watermark_thumb_path''], $cfg_client["upl_path"].$mod["file"][$i]["dirname"].$mod["filename"].$cfg_client[''thumbext''].''_watermark_thumb.''.strtolower($mod["file_ext"]), $mod[''watermark_thumb_positionxx''], $mod[''watermark_thumb_positionyy''], $mod[''watermark_thumb_transparent'']);\r\n									$mod[''temp''] = str_replace("{thumbfile}",$mod["filename"].$cfg_client[''thumbext''].''_watermark_thumb.''.strtolower($mod["file_ext"]),$mod[''temp'']);\r\n		    }\r\n\r\n\r\n				     elseif ((strtolower($mod["file_ext"])) == "gif")\r\n				     {\r\n				     $mod[''temp''] = str_replace("{thumbfile}",$mod["file"][$i]["filename"] ,$mod[''temp'']);\r\n				     }\r\n\r\n		//Elseif Wasserzeichen ist nicht vorhanden und Thumb ist nicht vorhanden\r\n				     elseif  (((!@file_exists($cfg_client["upl_path"].$mod[''watermark_thumb''])) AND (!@file_exists($cfg_client["upl_path"].$mod["file"][$i]["dirname"].$mod["filename"].$cfg_client[''thumbext''].".".strtolower($mod["file_ext"])))  OR ($resample_watermarks)) )\r\n					{\r\n				make_watermark_image_galerie($cfg_client["upl_path"].$mod["file"][$i]["dirname"].$mod["filename"].".".strtolower($mod["file_ext"]), $mod[''watermark_thumb_path''], $cfg_client["upl_path"].$mod["file"][$i]["dirname"].$mod["filename"].$cfg_client[''thumbext''].''_watermark_thumb.''.strtolower($mod["file_ext"]), $mod[''watermark_thumb_positionxx''], $mod[''watermark_thumb_positionyy''], $mod[''watermark_thumb_transparent'']);\r\n				$mod[''temp''] = str_replace("{thumbfile}",$mod["filename"].$cfg_client[''thumbext''].''_watermark_thumb.''.strtolower($mod["file_ext"]),$mod[''temp'']);\r\n\r\n\r\n					}\r\n\r\n					else\r\n					{\r\n				$mod[''temp''] = str_replace("{thumbfile}",$mod["filename"].$cfg_client[''thumbext''].''_watermark_thumb.''.strtolower($mod["file_ext"]),$mod[''temp'']);\r\n					}\r\n\r\n\r\n\r\n				}\r\n\r\n			   else\r\n			   {\r\n\r\n\r\n                      // thumb\r\n                      if (is_file($cfg_client["upl_path"]. $mod["file"][$i]["dirname"] . $mod["filename"] . $mod["filename_suffix"] . "." . strtolower($mod["file_ext"]) ) )\r\n                      {\r\n                      $mod[''temp''] = str_replace("{thumbfile}",$mod["filename"] . $mod["filename_suffix"] . "." . strtolower($mod["file_ext"]),$mod[''temp'']);\r\n                      }\r\n                      else\r\n                      { $mod[''temp''] = str_replace("{thumbfile}",$mod["file"][$i]["filename"] ,$mod[''temp'']);\r\n                      }\r\n\r\n  			   }\r\n\r\n\r\n\r\n\r\n  // URLencode\r\n  while (strstr($mod[''temp''],"{urlencode}"))\r\n  { $mod[''url_firstpos''] = strpos($mod[''temp''],"{urlencode}")+11;\r\n    $mod[''url_lastpos'']  = strpos($mod[''temp''],"{/urlencode}");\r\n    $mod[''url''] = substr($mod[''temp''],$mod[''url_firstpos''],$mod[''url_lastpos'']-$mod[''url_firstpos'']);\r\n    $mod[''url_tag''] = "{urlencode}". $mod[''url''] ."{/urlencode}";\r\n    $mod[''url''] = rawurlencode($mod[''url'']);\r\n    $mod[''temp''] = str_replace($mod[''url_tag''], $mod[''url''] ,$mod[''temp'']);\r\n  }\r\n\r\n  //\r\n  $mod[''out''] .= $mod[''temp''];\r\n\r\n  //\r\n  if ( ( (($i+1) / $mod["break_after_number_of_pics"] ) - round((($i+1) / $mod["break_after_number_of_pics"] ),0) ) == 0)\r\n  { $mod[''out''] .= "MOD_VALUE[31] \\n";\r\n    $mod[''out''] .= "MOD_VALUE[30] \\n";\r\n  }\r\n\r\n}\r\n\r\n##########################################################################################################################\r\n  //  Detailansicht Ausgabe\r\n##########################################################################################################################\r\n$mod[''dtpl''] = "MOD_VALUE[20]";\r\n\r\n//Id der Galerieseite generieren auf der das Bild ist\r\n$mod[''pic_is_from_page''] = ceil($detailid / $mod["number_of_pics_per_page"]) ;\r\n\r\n//Links im Wlaker\r\n$mod[''dtplwalker_prev''] = "".$mod[''idcatlink'']."&amp;detailid=".($detailid-1)."";\r\n$mod[''dtplwalker_prev_first''] = "".$mod[''idcatlink'']."&amp;detailid=".(count($mod["file"]))."";\r\n$mod[''dtplwalker_galerie''] = "".$mod[''idcatlink'']."&amp;galerie=".$cms_mod[''container''][''id'']."_".$mod[''pic_is_from_page'']."";\r\n$mod[''dtplwalker_galeriestart''] = "".$mod[''idcatlink'']."";\r\n$mod[''dtplwalker_next''] = "".$mod[''idcatlink'']."&amp;detailid=".($detailid+1)."";\r\n$mod[''dtplwalker_next_last''] = "".$mod[''idcatlink'']."&amp;detailid=1";\r\n\r\n//Tags fr die Links ersetzen\r\n$mod[''dtplwalker_22''] = "MOD_VALUE[22]";\r\n$mod[''dtplwalker_25''] = "MOD_VALUE[25]";\r\n$mod[''dtplwalker_23''] = "MOD_VALUE[23]";\r\n$mod[''dtplwalker_22''] = str_replace("{font1}", "MOD_VALUE[1]", $mod[''dtplwalker_22'']);\r\n$mod[''dtplwalker_22''] = str_replace("{font2}", "MOD_VALUE[2]", $mod[''dtplwalker_22'']);\r\n$mod[''dtplwalker_22''] = str_replace("{font3}", "MOD_VALUE[3]", $mod[''dtplwalker_22'']);\r\n$mod[''dtplwalker_25''] = str_replace("{font1}", "MOD_VALUE[1]", $mod[''dtplwalker_25'']);\r\n$mod[''dtplwalker_25''] = str_replace("{font2}", "MOD_VALUE[2]", $mod[''dtplwalker_25'']);\r\n$mod[''dtplwalker_25''] = str_replace("{font3}", "MOD_VALUE[3]", $mod[''dtplwalker_25'']);\r\n$mod[''dtplwalker_23''] = str_replace("{font1}", "MOD_VALUE[1]", $mod[''dtplwalker_23'']);\r\n$mod[''dtplwalker_23''] = str_replace("{font2}", "MOD_VALUE[2]", $mod[''dtplwalker_23'']);\r\n$mod[''dtplwalker_23''] = str_replace("{font3}", "MOD_VALUE[3]", $mod[''dtplwalker_23'']);\r\n$mod[''dtplwalker_23''] = str_replace("{page_id}", $mod[''pic_is_from_page''], $mod[''dtplwalker_23'']);\r\n$mod[''dtplwalker_23''] = str_replace("{galerie}", $mod[''dtplwalker_galerie''], $mod[''dtplwalker_23'']);\r\n$mod[''dtplwalker_23''] = str_replace("{galeriestart}", $mod[''dtplwalker_galeriestart''], $mod[''dtplwalker_23'']);\r\n$mod[''dtpl''] = str_replace("{galerie}", $mod[''dtplwalker_23''], $mod[''dtpl'']);\r\n\r\n$mod[''dtplwalker_prevtag''] = $mod[''dtplwalker_22''];\r\n$mod[''dtplwalker_nexttag''] = $mod[''dtplwalker_25''];\r\n$mod[''dtplwalker_nexttag'']  = str_replace("{next}", $mod[''dtplwalker_next''], $mod[''dtplwalker_nexttag''] );\r\n$mod[''dtplwalker_prevtag'']  = str_replace("{prev}", $mod[''dtplwalker_prev''], $mod[''dtplwalker_prevtag''] );\r\n$mod[''dtplwalker_nexttag'']  = str_replace("{idupl}", $mod["file"][($detailid)]["idupl"], $mod[''dtplwalker_nexttag''] );\r\n$mod[''dtplwalker_prevtag'']  = str_replace("{idupl}", $mod["file"][($detailid-2)]["idupl"], $mod[''dtplwalker_prevtag''] );\r\n\r\n//Hier wird zwischen zyklisch und endend entschieden\r\nif ("MOD_VALUE[24]" == "end")\r\n//ab hier wenn endend\r\n\r\n{\r\n//Zurck und Vor nicht anzeigen wenn Anfang oder Ende\r\nif ($detailid == 1){\r\n$mod[''dtpl''] = str_replace("{prev}", "", $mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{next}", $mod[''dtplwalker_nexttag''], $mod[''dtpl'']);\r\n} elseif ($detailid == count($mod["file"])) {\r\n$mod[''dtpl''] = str_replace("{prev}", $mod[''dtplwalker_prevtag''], $mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{next}", "", $mod[''dtpl'']);\r\n} else {\r\n$mod[''dtpl''] = str_replace("{prev}", $mod[''dtplwalker_prevtag''], $mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{next}", $mod[''dtplwalker_nexttag''], $mod[''dtpl'']);\r\n}\r\n\r\n//ab hier wenn zyklisch\r\n} else {\r\n//Fr erste und letzte Variablen definieren\r\n$mod[''dtplwalker_prev_firsttag''] = $mod[''dtplwalker_22''];\r\n$mod[''dtplwalker_next_lasttag''] = $mod[''dtplwalker_25''];\r\n$mod[''dtplwalker_next_lasttag'']  = str_replace("{next}", $mod[''dtplwalker_next_last''], $mod[''dtplwalker_next_lasttag''] );\r\n$mod[''dtplwalker_prev_firsttag'']  = str_replace("{prev}", $mod[''dtplwalker_prev_first''], $mod[''dtplwalker_prev_firsttag''] );\r\nif ($detailid == 1){\r\n$mod[''dtpl''] = str_replace("{prev}", $mod[''dtplwalker_prev_firsttag''], $mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{next}", $mod[''dtplwalker_nexttag''], $mod[''dtpl'']);\r\n} elseif ($detailid == count($mod["file"])) {\r\n$mod[''dtpl''] = str_replace("{prev}", $mod[''dtplwalker_prevtag''], $mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{next}", $mod[''dtplwalker_next_lasttag''], $mod[''dtpl'']);\r\n} else {\r\n$mod[''dtpl''] = str_replace("{prev}", $mod[''dtplwalker_prevtag''], $mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{next}", $mod[''dtplwalker_nexttag''], $mod[''dtpl'']);\r\n}\r\n\r\n}\r\n\r\n\r\n\r\n##########################################################################################################################\r\n  //  Templatevariablen ersetzen\r\n##########################################################################################################################\r\n//no_dir ist true, wenn im Frontencmst der Ordner noch nicht in die DB geschrieben wurde!\r\nif ($mod[''no_dir''] == false ) {\r\n//Galerie-Template\r\n$mod[''tpl''] = "MOD_VALUE[8]";\r\n$mod[''tpl''] = str_replace("{content}",$mod[''out''],$mod[''tpl'']);\r\n$mod[''tpl''] = str_replace("{id}", $id, $mod[''tpl'']);\r\n$mod[''tpl''] = str_replace("{walker}", $mod[''walker''],$mod[''tpl'']);\r\n$mod[''tpl''] = str_replace("{font1}", "MOD_VALUE[1]", $mod[''tpl'']);\r\n$mod[''tpl''] = str_replace("{font2}", "MOD_VALUE[2]", $mod[''tpl'']);\r\n$mod[''tpl''] = str_replace("{font3}", "MOD_VALUE[3]", $mod[''tpl'']);\r\n$mod[''tpl''] = str_replace("{font4}", "MOD_VALUE[27]", $mod[''tpl'']);\r\n$mod[''tpl''] = str_replace("{font5}", "MOD_VALUE[28]", $mod[''tpl'']);\r\n}\r\n\r\n\r\n//Detailansichts-Template\r\n$mod[''dtpl''] = str_replace("{pic_id}", $detailid, $mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{page_id}", $mod[''pic_is_from_page''], $mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{pic_count}", count($mod["file"]), $mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{path}",$cfg_client["upl_htmlpath"]  . $mod["file"][($detailid-1)]["dirname"] ,$mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{real_path}",$cfg_client["upl_path"]  . $mod["file"][($detailid-1)]["dirname"] ,$mod[''dtpl'']);\r\n\r\n//Normales Bild oder Watermark nutzen?\r\nif ($mod[''watermark_image_id'']) {\r\n  $mod["file_ext"] = substr (strrchr ($mod["file"][$detailid-1]["filename"], "."), 1);\r\n  $mod["filename"] = substr ($mod["file"][$detailid-1]["filename"], 0, -(strlen($mod["file_ext"]))-1 );\r\n  $mod[''dtpl''] = str_replace("{file}",$mod["filename"].$cfg_client[''thumbext''].''_watermark_image.''.strtolower($mod["file_ext"]),$mod[''dtpl'']);\r\n} else{\r\n  $mod[''dtpl''] = str_replace("{file}", $mod["file"][($detailid-1)]["filename"] ,$mod[''dtpl'']);\r\n}\r\n$mod[''dtpl''] = str_replace("{idupl}", $mod["file"][($detailid-1)]["idupl"] ,$mod[''dtpl'']);\r\n\r\n\r\n$mod[''dtpl''] = str_replace("{font1}", "MOD_VALUE[1]", $mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{font2}", "MOD_VALUE[2]", $mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{font3}", "MOD_VALUE[3]", $mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{font4}", "MOD_VALUE[27]", $mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{font5}", "MOD_VALUE[28]", $mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{maximgsize}", $mod["file"][($detailid-1)]["maximgsize"] ,$mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{maximgsize2}", $mod["file"][($detailid-1)]["maximgsize2"] ,$mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{filesize}",  round(($mod["file"][($detailid-1)]["filesize"]/1024), 1)." kb" ,$mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{width}", $mod["file"][($detailid-1)]["width"] ,$mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{height}", $mod["file"][($detailid-1)]["height"] ,$mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{title}", $mod["file"][($detailid-1)]["title"] ,$mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{description}",$mod["file"][($detailid-1)]["description"],$mod[''dtpl'']);\r\n\r\n  $mod["file_ext"] = substr (strrchr ($mod["file"][($detailid-1)]["filename"], "."), 1);\r\n  $mod["filename"] = substr ($mod["file"][($detailid-1)]["filename"], 0, -(strlen($mod["file_ext"]))-1 );\r\n  //filedesc\r\n  if ($mod["file"][($detailid-1)]["title"] != "")\r\n  { $mod["filedesc"] = $mod["file"][($detailid-1)]["title"];\r\n  }\r\n  else\r\n  { $mod["filedesc"] = $mod["file"][($detailid-1)]["filename"];\r\n  }\r\n$mod[''dtpl''] = str_replace("{filedesc}",$mod["filedesc"] ,$mod[''dtpl'']);\r\n$mod[''dtpl''] = str_replace("{filename}",$mod["filename"] ,$mod[''dtpl'']);\r\n\r\n  // thumb oder watermark Thumb nutzen\r\nif ($mod[''watermark_thumb_id'']) {\r\n\r\n  if (is_file($cfg_client["upl_path"]. $mod["file"][($detailid-1)]["dirname"] . $mod["filename"] . $mod["filename_suffix"] . "." . strtolower($mod["file_ext"]) ) )\r\n  {\r\n  $mod[''dtpl''] = str_replace("{thumbfile}",$mod["filename"] . $mod["filename_suffix"] . "_watermark_thumb." . strtolower($mod["file_ext"]),$mod[''dtpl'']);\r\n  }\r\n\r\n} else {\r\n\r\n  if (is_file($cfg_client["upl_path"]. $mod["file"][($detailid-1)]["dirname"] . $mod["filename"] . $mod["filename_suffix"] . "." . strtolower($mod["file_ext"]) ) )\r\n  {\r\n  $mod[''dtpl''] = str_replace("{thumbfile}",$mod["filename"] . $mod["filename_suffix"] . "." . strtolower($mod["file_ext"]),$mod[''dtpl'']);\r\n  }\r\n  else\r\n  { $mod[''dtpl''] = str_replace("{thumbfile}",$mod["file"][($detailid-1)]["filename"] ,$mod[''dtpl'']);\r\n  }\r\n	}\r\n\r\n\r\n//Ausgabe Detail-Template\r\nif ($detailid) {\r\n\r\necho $mod[''dtpl''];}\r\n\r\nif ($mod[''detailid_thumb''] OR !$detailid){\r\necho  $mod[''tpl''];\r\n}\r\n\r\n// VARIABLEN LEEREN\r\nunset($size);\r\nunset($id);\r\nunset($mod);\r\nunset($detailid);\r\n\r\n</CMSPHP>', '', 0, 1, 1, 1110349542, 1215636805, 'mod:844f16bb5bb7c43344209685afeccea4:7b8b6d76', '', '', '', 0, '0', 'Pic-Galerie', '1');

    
# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_perms`
#

DROP TABLE IF EXISTS cms_perms;
CREATE TABLE cms_perms (
  idperm int(11) NOT NULL auto_increment,
  idgroup int(11) NOT NULL default '0',
  idlang int(11) NOT NULL default '0',
  type varchar(63) NOT NULL default '',
  id varchar(63) NOT NULL default '0',
  perm varchar(63) NOT NULL default '',
  PRIMARY KEY  (idperm),
  KEY idgroup (idgroup),
  KEY idlang (idlang),
  FULLTEXT KEY type (type),
  FULLTEXT KEY id (id)
) ENGINE=MyISAM;



#
# Tabellenstruktur fr Tabelle `cms_plug`
#
DROP TABLE IF EXISTS cms_plug;
CREATE TABLE cms_plug (
  idplug int(6) NOT NULL auto_increment,
  name varchar(255) NOT NULL default '',
  version varchar(63) default NULL,
  cat varchar(63) default NULL,
  description text,
  config text,
  idclient int(6) unsigned NOT NULL default '0',
  root_name varchar(150) default NULL,
  index_file varchar(50) default NULL,
  deletable tinyint(1) NOT NULL default '1',
  author int(6) NOT NULL default '0',
  created int(10) NOT NULL default '0',
  lastmodified int(10) NOT NULL default '0',
  repository_id varchar(255) default NULL,
  source_id int(6) unsigned NOT NULL default '0',
  is_install enum('0','1') NOT NULL default '0',
  verbose varchar(100) default NULL,
  checked enum('1','0') NOT NULL default '0',
  PRIMARY KEY  (idplug)
) ENGINE=MyISAM;


#
# Table structure for table 'cms_repository'
#

DROP TABLE IF EXISTS cms_repository;
CREATE TABLE cms_repository (
  idrepository int(6) unsigned NOT NULL auto_increment,
  source int(6) unsigned NOT NULL default '0',
  idclient int(6) NOT NULL default '0',
  type varchar(25) NOT NULL default '',
  value text NOT NULL,
  PRIMARY KEY  (idrepository),
  KEY idclient (idclient)
) ENGINE=MyISAM;


#
# Tabellenstruktur fr Tabelle `cms_sessions`
#

DROP TABLE IF EXISTS cms_sessions;
CREATE TABLE cms_sessions (
  sid varchar(32) NOT NULL default '',
  name varchar(32) NOT NULL default '',
  val mediumtext,
  changed varchar(14) NOT NULL default '',
  user_id INT(11) NOT NULL,
  PRIMARY KEY  (name,sid),
  KEY changed (changed)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_sessions`
#

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_side`
#

DROP TABLE IF EXISTS cms_side;
CREATE TABLE cms_side (
  idside int(6) NOT NULL auto_increment,
  idclient int(6) NOT NULL default '0',
  PRIMARY KEY  (idside),
  KEY idclient (idclient)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_side`
#

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_side_lang`
#

DROP TABLE IF EXISTS cms_side_lang;
CREATE TABLE cms_side_lang (
  idsidelang int(6) NOT NULL auto_increment,
  idside int(6) NOT NULL default '0',
  idlang int(6) NOT NULL default '0',
  idtplconf int(6) NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  summary text,
  online tinyint(1) NOT NULL default '0',
  start int(10) NOT NULL default '0',
  end int(10) NOT NULL default '0',
  author int(6) NOT NULL default '0',
  created int(10) NOT NULL default '0',
  lastmodified int(10) NOT NULL default '0',
  user_protected int(11) default NULL,
  visited int(6) NOT NULL default '0',
  edit_ttl int(11) default '0',
  rewrite_use_automatic TINYINT( 1 ) NOT NULL DEFAULT '1',
  rewrite_url VARCHAR( 255 ) default NULL,
  meta_author varchar(255) NOT NULL default '',
  meta_description varchar(255) NOT NULL default '',
  meta_keywords varchar(255) NOT NULL default '',
  meta_robots varchar(255) NOT NULL default '',
  meta_redirect int(6) NOT NULL default '0',
  meta_redirect_time int(6) NOT NULL default '0',
  meta_redirect_url varchar(255) NOT NULL default '',
  PRIMARY KEY  (idsidelang),
  KEY idside (idside),
  KEY idlang (idlang),
  KEY rewrite_use_automatic (rewrite_use_automatic),
  KEY rewrite_url (rewrite_url),
  KEY idtplconf (idtplconf)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_side_lang`
#

# --------------------------------------------------------


#
# Tabellenstruktur fr Tabelle `cms_tpl`
#

DROP TABLE IF EXISTS cms_tpl;
CREATE TABLE cms_tpl (
  idtpl int(6) NOT NULL auto_increment,
  name varchar(255) NOT NULL default '',
  description text NOT NULL,
  is_start tinyint(1) unsigned NOT NULL default '0',
  deletable tinyint(1) NOT NULL default '1',
  idlay int(6) NOT NULL default '0',
  idclient int(6) NOT NULL default '0',
  author int(6) NOT NULL default '0',
  created int(10) NOT NULL default '0',
  lastmodified int(10) NOT NULL default '0',
  PRIMARY KEY  (idtpl),
  KEY idlay (idlay),
  KEY idclient (idclient)
) ENGINE=MyISAM;
#
# Daten fr Tabelle `cms_tpl`
#

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_tpl_conf`
#

DROP TABLE IF EXISTS cms_tpl_conf;
CREATE TABLE cms_tpl_conf (
  idtplconf int(6) NOT NULL auto_increment,
  idtpl int(6) NOT NULL default '0',
  PRIMARY KEY  (idtplconf)
) ENGINE=MyISAM;


#
# Tabellenstruktur fr Tabelle `cms_tracker`
#
CREATE TABLE cms_tracker (
  `idtracker` int(11) unsigned NOT NULL auto_increment,
  `idclient` int(11) default NULL,
  `idlang` int(6) default NULL,
  `iduser` int(11) default NULL,
  `created` int(11) default NULL,
  `ip` varchar(32) default NULL,
  `groupname` varchar(32) default NULL,
  `action` varchar(64) default NULL,
  `value1` varchar(255) default NULL,
  `value2` varchar(255) default NULL,
  `value3` varchar(255) default NULL,
  `value4` varchar(255) default NULL,
  `value5` varchar(255) default NULL,
  PRIMARY KEY  (`idtracker`),
  KEY `idclient` (`idclient`),
  KEY `group` (`groupname`)
) ENGINE=MyISAM;
ALTER TABLE cms_tracker ADD INDEX ( `idclient` );
ALTER TABLE cms_tracker ADD INDEX ( `idlang` );
ALTER TABLE cms_tracker ADD INDEX ( `iduser` );
ALTER TABLE cms_tracker ADD INDEX ( `created` );
ALTER TABLE cms_tracker ADD FULLTEXT (`ip`);
ALTER TABLE cms_tracker ADD FULLTEXT (`groupname`);
ALTER TABLE cms_tracker ADD FULLTEXT (`action`);
#
# Tabellenstruktur fr Tabelle `cms_upl`
#

DROP TABLE IF EXISTS cms_upl;
CREATE TABLE cms_upl (
  idupl int(6) NOT NULL auto_increment,
  idclient int(6) NOT NULL default '0',
  titel varchar(200) NOT NULL default '',
  filename varchar(255) NOT NULL default '',
  iddirectory int(6) NOT NULL default '0',
  idfiletype int(6) NOT NULL default '0',
  pictwidth int(6) NOT NULL default '0',
  pictheight int(6) NOT NULL default '0',
  pictcolors int(6) NOT NULL default '0',
  pictthumbwidth int(6) NOT NULL default '0',
  pictthumbheight int(6) NOT NULL default '0',
  filesize int(6) NOT NULL default '0',
  used int(6) NOT NULL default '0',
  status int(6) NOT NULL default '0',
  description text NOT NULL,
  author int(6) NOT NULL default '0',
  lastmodified timestamp NOT NULL,
  created timestamp NOT NULL,
  PRIMARY KEY  (idupl),
  KEY titel (titel)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_upl`
#

INSERT INTO cms_upl VALUES (1, 0, '', 'standard.js', 2, 2, 0, 0, 0, 0, 0, 0, 0, 5, 'Standardfunktionen fr Popups und Bild-Mouseover.', 1, 20030525233600, 20030521025623);
INSERT INTO cms_upl VALUES (2, 0, '', 'inner_scroll.js', 2, 2, 0, 0, 0, 0, 0, 0, 0, 5, 'Ermglicht Content in einem bestimmten Bereich zu scrollen.', 1, 20030826173915, 20030826173915);
INSERT INTO cms_upl VALUES (3, 0, '', 'lib.js', 2, 2, 0, 0, 0, 0, 0, 0, 0, 5, 'Eine ziemlich einfache DHTML-Klasse die es vereinfacht Browserbergreifende Scripte zu schreiben.', 1, 20030826173915, 20030826173915);
INSERT INTO cms_upl VALUES (4, 0, '', 'side_scroll.js', 2, 2, 0, 0, 0, 0, 0, 0, 0, 5, 'Ermglicht Content ber die Seite zu scrollen.', 1, 20030826173915, 20030826173915);
# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_uplcontent`
#

DROP TABLE IF EXISTS cms_uplcontent;
CREATE TABLE cms_uplcontent (
  idupl int(6) NOT NULL default '0',
  uplcontent mediumblob,
  PRIMARY KEY  (idupl)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_uplcontent`
#

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_users`
#

DROP TABLE IF EXISTS cms_users;
CREATE TABLE cms_users (
  user_id int(11) NOT NULL auto_increment,
  username varchar(32) NOT NULL default '',
  password varchar(32) NOT NULL default '',
  title varchar(255) default NULL,
  name varchar(255) default NULL,
  surname varchar(255) default NULL,
  email varchar(255) default NULL,
  is_active tinyint(1) NOT NULL default '0',
  is_deletable tinyint(1) NOT NULL default '1',
  position varchar(255) default NULL,
  salutation varchar(32) default NULL,
  street varchar(255) default NULL,
  zip varchar(15) default NULL,
  location varchar(255) default NULL,
  phone varchar(32) default NULL,
  fax varchar(32) default NULL,
  comment varchar(255) default NULL,
  street_alt varchar(255) default NULL,
  state varchar(255) default NULL,
  country varchar(255) default NULL,
  mobile varchar(50) default NULL,
  pager varchar(50) default NULL,
  homepage varchar(255) default NULL,
  birthday varchar(15) default NULL,
  firm varchar(255) default NULL,
  firm_street varchar(255) default NULL,
  firm_street_alt varchar(255) default NULL,
  firm_zip varchar(15) default NULL,
  firm_location varchar(255) default NULL,
  firm_state varchar(255) default NULL,
  firm_country varchar(255) default NULL,
  firm_email varchar(255) default NULL,
  firm_phone varchar(50) default NULL,
  firm_fax varchar(50) default NULL,
  firm_mobile varchar(50) default NULL,
  firm_pager varchar(50) default NULL,
  firm_homepage varchar(255) default NULL,
  author INT( 6 ) NOT NULL,
  created INT( 10 ) NOT NULL,
  lastmodified INT( 10 ) NOT NULL,
  lastmodified_author INT( 10 ) NOT NULL,
  currentlogin INT( 10 ) NOT NULL,
  lastlogin INT( 10 ) NOT NULL,
  lastlogin_failed INT( 10 ) NOT NULL default '0',
  failed_count INT( 6 ) NOT NULL default '0',
  password_recover_hash VARCHAR(63) default NULL,
  registration_hash varchar(63) default NULL,
  accept_agreement tinyint(1) unsigned default '0',
  accept_agreement_timestamp INT( 10 ) default NULL,
  registers_timestamp INT( 10 ) default NULL,
  registration_valid tinyint(1) unsigned default '0',
  PRIMARY KEY  (user_id),
  UNIQUE KEY username (username),
  KEY user_id (user_id)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_users`
#

INSERT INTO cms_users (user_id, username, password, name, surname, email, is_active, is_deletable, firm, position, salutation, street, zip, location, phone, fax, comment, street_alt, state, country, mobile, pager, homepage, birthday, firm_street, firm_street_alt, firm_zip, firm_location, firm_state, firm_country, firm_email, firm_phone, firm_fax, firm_mobile, firm_pager, firm_homepage) VALUES (1, 'admin', '{adminpass}', 'CMS', 'Sefrengo', 'Sefrengo CMS', 1, 0, '', '', '', '', NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO cms_users (user_id, username, password, name, surname, email, is_active, is_deletable, firm, position, salutation, street, zip, location, phone, fax, comment, street_alt, state, country, mobile, pager, homepage, birthday, firm_street, firm_street_alt, firm_zip, firm_location, firm_state, firm_country, firm_email, firm_phone, firm_fax, firm_mobile, firm_pager, firm_homepage) VALUES (2, '', '', 'nobody', 'nobody', 'nobody', 1, 0, '', '', '', '', NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_users_groups`
#

DROP TABLE IF EXISTS cms_users_groups;
CREATE TABLE cms_users_groups (
  u_g_id int(11) NOT NULL auto_increment,
  user_id int(11) NOT NULL default '0',
  idgroup int(11) NOT NULL default '0',
  PRIMARY KEY  (u_g_id),
  KEY user_id (user_id),
  KEY idgroup (idgroup),
  KEY user_id_2 (user_id),
  KEY idgroup_2 (idgroup)
) ENGINE=MyISAM;

#
# Daten fr Tabelle `cms_users_groups`
#

INSERT INTO cms_users_groups VALUES (1, 1, 2);

# --------------------------------------------------------

#
# Tabellenstruktur fr Tabelle `cms_cache`
DROP TABLE IF EXISTS cms_db_cache;
CREATE TABLE cms_db_cache (
  sid varchar(32) NOT NULL default '',
  name varchar(32) NOT NULL default '',
  val mediumtext,
  changed varchar(14) NOT NULL default '',
  releasetime varchar(14) default '0',
  groups varchar(32) NOT NULL default '',
  item varchar(25),
  PRIMARY KEY  (name,sid),
  KEY changed (changed)
) ENGINE=MyISAM;
