<?php
//**********************************************************/
//
//  Open Translation Engine
//
//  Documentation:  Dictionary Format
//
//**********************************************************/

// main OTE configuration file
include_once('../config.php');

// make my name my own...
$title .= " -- Documentation - Dictionary Format";

include($ote_home . '/skins/header.php'); 

?>
<pre>

The Open Translation Engine (OTE)  XML Format:

OTE dictionaries are XML files with the following structure:

-  &lt;ote&gt;
	All OTE dictionaries must be enclosed in one &lt;ote&gt; tag

- - &lt;base_name&gt; 
	The name of the dictionary, in the source language

- - &lt;reverse_name&gt; 
	The name of the dictionary, in the target language	

- - &lt;version&gt; 
	The version of the dictionary

- - &lt;base_language&gt;
        The tag to use for the source language of this dictionary.

- - &lt;reverse_language&gt;
        The tag to use for the target language of this dictionary.

- - &lt;dirty_dictionary&gt;
	Pointer to XML file with low-confidence translations

- - &lt;engine_dictionary&gt;
	Pointer to XML file with offsite internet translation engines

- - &lt;words&gt;
	Container for all word pairs / word translations

- - - (dynamic 'box' tag)
	Any level of un-reserved tag names.  These will be used as the 
	'box' meta-info for all child nodes.
	Examples:  &lt;noun&gt;  &lt;adjective&gt;

- - - &lt;word&gt;
        this is the main wrapper around a word pair / word translation

- - - - (pre-defined base_language tag)
        contains the base word.
        ONLY ONE base_language tag per word tag allowed!
        base word SHOULD ALWAYS be the first element in a word tag

- - - - (pre-defined reverse_language tag)
        contains a translation of the base word
        There many be infinute numbers of to_language tags within a word tag



<hr size="1">
DIRTY DICTIONARY

Dirty dictionaries are OTE dictionaries containing low-confidence translations
within the &lt;words&gt; tag.

Tags specific to dirty dictionaries:

- &ltclean_dictionary&gt;
	Pointer to XML file with high-confidence translations


<hr size="1">
ENGINES

Engine dictionaries contain everything 
in a basic OTE dictionary <b>except</b> the &lt;words&gt; block.

These tags are specific to the engine dictionaries:

- - &lt;engines&gt;
	Holder container for all offsite translation engines

- - - &lt;engine&gt;
	Holder container for a single offsite translation engine

- - - - &lt;engine_name&gt;
	The name of the offsite translation engine

- - - - &lt;base_url&gt;
	URL to translate a single word in BASE language to TO language
	GET method only, POST not supported yet
	URL should end with the suitable '&search=' at END of URL
	&amp; character must be replaced with --AMPERSAND--

- - - - &lt;to_url&gt;	
	URL to translate single words in TO language to BASE language

- - - - &lt;full_base_url&gt;	
- - - - &lt;full_to_url&gt;	
	Same as base_url and to_url, but these engines support multi word lookups



<hr size="1">
You may <a href="../dictionary/">view the raw OTE dictionaries</a> 
or use the <a href="../tools/view.php">Dictionary Viewer</a> tool.

<hr size="1">

There is currently no DTD for the OTE dictionary format.


</pre>
<?
// print footer
include($ote_home  . '/skins/footer.php'); 

/*****************************************************************/
?>
