<?
////////////////////////////////////////////////////////////////////////////
// Open Translation Engine
// http://www.ibiblio.org/dbarberi/ote/
//
// OTEbase class
// OTEweb class
// OTEword class
// OTEdictionary class
// OTE class
//

////////////////////////////////////////////////////////////////////////////
class OTEbase {

	var $cr;	// The system Carriage Return

	function xdebug( $msg ) { // real debug
		ob_start(); print_r( $msg ); $gc = ob_get_contents(); ob_end_clean(); return $gc; 
	}

	function start_timer() { return microtime(); } //  start the timer

	function end_timer( $start_time ) { //  end the timer, return how many seconds elapsed
		$end_time = microtime();
		$end_chunks = explode(" ", $end_time);
		$real_end = $end_chunks[1] + $end_chunks[0];
		$start_chunks = explode(" ", $start_time);
		$real_start = $start_chunks[1] +  $start_chunks[0];
		$parse_time = $real_end - $real_start;
		return $parse_time;
	}

} // END of class OTEbase


////////////////////////////////////////////////////////////////////////////
class OTEword extends OTEbase {
	
	// Public variables
	var $source;	// The text for this word in the source language
	var $target;	// This word translated to the target language
	var $box;	// meta information on this word

	// Private variables
	var $__soundex;	// soundex of this word
	var $__metaphone;	// metaphone of this word

// OTEword constructor
function OTEword( $source="", $target="", $box="" ) {
	$this->source = $source;	
	$this->target = $target;	
	$this->box = $box;
	$this->cr = '<br />';
} // END of OTEword constructor

// pretty list of target words
function target_list() {
	while( list( $key, $x ) = each($this->target) ) { $r .=  $x . $this->cr; } return $r;
} // END of function target_list

function soundex() {
	if ( !$this->__soundex ) { // soundex not generated yet?
		$this->__soundex = soundex( $this->source ); // generate it
	}
	return $this->__soundex;
} // END of function soundex

function metaphone() {
	if ( !$this->__metaphone ) { // metaphone not generated yet?
		$this->__metaphone = metaphone( $this->source ); // generate it
	}
	return $this->__metaphone;
} // END of function metaphone



/**
 * linked_target_list
 * @args object word
 * returns string of HTML listing all targets for this word object,
 * linked to the word TOOL
**/
function linked_target_list( $url="" ) {

	// TO BE MOVED to OTEweb class:
	global $dictionary, $wordtool;

	// If no url defined, use the system wordtool
	if( !$url ) { $url = $wordtool . '?dictionary=' . $dictionary . '&q='; }

	$x = $this->target; // get the target array for this word object
	if( !$x ) { return; } // no targets? go away
	reset ( $x ); // reset target array
	while ( list( $id, $t ) = each( $x ) ) { // for each target word...
		$r .= '<a href="' . $url . $t . '">' . $t . '</a>' . $this->cr;
	}
	return $r;

} // END of linked_target_list



} // END of class OTEword


////////////////////////////////////////////////////////////////////////////
// OTEdictionary class
//
// Public Functions:
//
//	load_dictionary( $dictionary )	- Loads an OTE XML dictionary
//	get_word_count()		- reports number of word pairs in dictionary
//
// Input variables:
//
//	$direction		- '','normal', 'reverse'.  Default: 'normal'
//				  What direction are we doing this translation in?
//	$against		- '', 'all', 'clean', 'dirty'. Default: 'all'
//				  What words (clean and/or dirty) should we use?
//	$dictionary_home	- System path to dictionary directory 
//
// Output variables:
//
//	$wo			- The word object array
//	$base_language		- 2 letter ISO 639 code for base language
//	$reverse_language	- 2 letter ISO 639 code for reverse language
//	$base_name		- Name of the dictionary, in base language
//	$reverse_name		- Name of the dictionary, in reverse language
//	$version		- Version of the dictionary
//	$clean_dictionary	- OTE XML file containing clean <words>
//	$dirty_dictionary	- OTE XML file containing dirty <words>
//	$engine_dictionary	- OTE XML file with info on Internet Tranlsation <Engines>
//	$single_engines		- array of offsite translation engines taking single words
//	$single_engines_reverse	-  " " , reversed
//	$multi_engines		- array of offsite translation engines taking multiple words
//	$multi_engines_reverse	-  " " , reversed

class OTEdictionary extends OTEbase {

	// public variables
	var $wo; // word object array
	var $base_language; var $reverse_language; var $base_name;
	var $reverse_name; var $version; var $clean_dictionary; var $dictionary_home;	
	var $dirty_dictionary; var $engine_dictionary; var $direction;	var $against;	
	var $single_engines; var $single_engines_reverse;	
	var $multi_engines; var $multi_engines_reverse;

	// Internal variables
	var $__in_words;	// Are we within a WORDS tag?   1/0
	var $__in_word;	// Are we within a WORD tag?   1/0
	var $__current_base_word;	// what is our current BASE word?
	var $__current_target_array;	// array of target words
	var $__current_box;	// What is our current box descriptor(s) ?
	var $__current_tag;	// What is the current XML tag?
	var $__current_engine; // What is the current engine name?


// Class Constructor
function OTEdictionary() { 

	// get global configuration variables
	global $dictionary_home, $direction, $against;
	$this->dictionary_home = $dictionary_home;
	$this->direction = $direction;
	$this->against = $against;

	$err = 'OTE dictionary not loaded';

	// Initialize all variables
	$this->wo = array();
	$this->__current_target_array = array();
	$this->single_engines = array();
	$this->single_engines_reverse = array();
	$this->multi_engines = array();
	$this->multi_engines_reverse = array();
	$this->base_language = $err;
	$this->reverse_language = $err;
	$this->base_name = $err;
	$this->reverse_name = $err;
	$this->__in_words = 0;
	$this->__in_word = 0;
	$this->cr = '<br />';
}

// load_dictionary
//
function load_dictionary( $file ) {

  // error checking .. does file exist?
  if ( !is_file( $file ) ) { return "OTE error: '$file' not a file."; }

  // error checking .. is the file NOT a directory?
  if ( is_dir( $file ) ) { return "OTE error: '$file' is a drectory."; }

  // parse the XML file, return any error
  $error = $this->parseXMLFile( $file );

  // Load the dirty dictionary, if available and if requested 
  if( $this->dirty_dictionary && 
    ($this->against == "" || $this->against == "all" || $this->against == "dirty") ) {
      $errord = $this->parseXMLFile ( $this->dictionary_home . $this->dirty_dictionary );
  }

  // load the engine dictionary, if available 
  if( $this->engine_dictionary ) {
    $errore = $this->parseXMLFile ( $this->dictionary_home . $this->engine_dictionary );
  }

  return $error;

} // END of load_dictionary


// word count
function get_word_count() { return sizeof( $this->wo ); }


//
// XML parsing.......
//

//	parse an external xml file
//	@param	string	$file	filename, without dirname
function parseXMLFile( $file ) {
  $parser = $this->createParser();
  if( !( $fp = fopen( $file, "r" ) ) )
    return ( "OTE error: Couldn't open XML file ".$file );
  while( $data = fread( $fp, 4096 ) ) {
    if ( !xml_parse( $parser, $data, feof( $fp ) ) ) {
      return ( sprintf( "OTE error: XML error: %s at line %d",
      xml_error_string( xml_get_error_code( $parser ) ),
      xml_get_current_line_number( $parser ) ) );
    } }
  xml_parser_free( $parser );
  return;
} // END of parseXMLFile


//	create an XML parser (within an object)
//	@return	object	$parser
function createParser() {
  $parser = xml_parser_create(); //	init XML Parser
  xml_set_object( $parser, &$this );
  xml_set_element_handler( $parser, "startElement", "endElement" );
  xml_set_character_data_handler( $parser, "char" );
  //xml_set_external_entity_ref_handler( $parser, "externalEntity" );
  // make everything upper CASE or not?
  //xml_parser_set_option( $parser, XML_OPTION_CASE_FOLDING, false );
  return $parser;
} // END of createParser


//
function startElement($parser, $name, $attrs) {
  $this->__current_tag  = $name; // save this tag name as the current one
  if( $name == "WORD" ) { $this->__in_word = 1; return; } // remember we are in WORD, return
  if( $name == "WORDS" ) { $this->__in_words = 1; return; } // remember we are in WORDS, return
	if( !$this->__in_words ) { return; }  // if not in the WORDS tag, return
  if( $this->__in_word ) { return; }	// if inside a WORD tag, return
	// otherwise, this is a BOX tag
    if ( $this->__current_box ) { $this->__current_box .= '-'; } //box defined? add a dash
    $this->__current_box .= $name; // make this the current box
    return;
} // END of function startElement

//
function endElement($parser, $name) { 
  $this->__current_tag = '';  // Tag is over, erase the current tag
	if( $name == "WORD" ) {
 		// we are ENDING a word tag, thus it is OK to create the final word object
  	$word = new OTEword( $this->__current_base_word, $this->__current_target_array, $this->__current_box);
		array_push( $this->wo, $word); // save the word object in our master wo array
		$this->__current_base_word = ''; // clean out the current stuff
		$this->__current_target_array = array();
		$this->__in_word = 0; // forget we are in WORD
		return; 
	} 
  if( $name == "WORDS" ) { $this->__in_words = 0; return; } // forget we are in WORDS, return
  if( !$this->__in_words ) { return; }  // if not in the WORDS tag, return
  if( $this->__in_word ) { return; }  // if inside a WORD tag, return
  // otherwise, we are in a BOX tag
	// erase this name, and any dashes before it, from the current box
	$this->__current_box = eregi_replace('[-]*' . $name,  '', $this->__current_box);
	return;

} // END of endElement

//
function char($parser, $data) {

  $data = trim($data); // get rid of white space
  if ( $data == NULL ) { return; }; // if there is no real data, go away!

  switch ( $this->__current_tag) { // switch on current tag
    case $this->base_language: // remember this word, as it is the start of all word-pairs for this WORD
      $this->__current_base_word = $data; break;
    case $this->reverse_language: // remember this word, as it is a translation of our current base word
      array_push( $this->__current_target_array, $data); break;
    case "BASE_NAME": $this->base_name = $data; break;
    case "REVERSE_NAME": $this->reverse_name = $data; break;
    case "BASE_LANGUAGE": $this->base_language = strtoupper($data); break;
    case "REVERSE_LANGUAGE": $this->reverse_language = strtoupper($data); break;
    case "VERSION": $this->version = $data; break;
    case "CLEAN_DICTIONARY": $this->clean_dictionary = $data; break;
    case "DIRTY_DICTIONARY": $this->dirty_dictionary = $data; break;
    case "ENGINE_DICTIONARY": $this->engine_dictionary = $data; break;
		case "ENGINE_NAME": $this->__current_engine_name = $data; break; // save the current engine name
		case "BASE_URL": // add this engine name and url to the Single Engines array
			$data = eregi_replace('--AMPERSAND--', '&', $data); // transform --AMPSERAND-- to &
			$engine_array = array( $this->__current_engine_name, $data ); // create the engine array
			array_push( $this->single_engines, $engine_array); // add this engine to the global engine array
			break;
		case "FULL_BASE_URL":
			$data = eregi_replace('--AMPERSAND--', '&', $data);
			$engine_array = array( $this->__current_engine_name, $data );
			array_push( $this->multi_engines, $engine_array);
			break;
		case "TO_URL": case "REVERSE_URL": 
			$data = eregi_replace('--AMPERSAND--', '&', $data);
			$engine_array = array( $this->__current_engine_name, $data );
			array_push( $this->single_engines_reverse, $engine_array);
			break;
		case "FULL_TO_URL": case "FULL_REVERSE_URL": 
			$data = eregi_replace('--AMPERSAND--', '&', $data);
			$engine_array = array( $this->__current_engine_name, $data );
			array_push( $this->multi_engines_reverse, $engine_array);
			break;
  } // END of switch on current tag
} // end function char


} // END of class OTEdictionary

//
// Open Translation Engine
// http://www.ibiblio.org/dbarberi/ote/
//
// OTE class
//
// Public Functions:
//
//	word_info( $word )
//	translate( $string )
//	translate_similar( $string )
//	translate_fuzzy( $string )
//	engines( $string )
//	clean( $string )
//	random_word()
//
//	do_*($b, $b)
//	  _exact
//	  _fuzzy
//	  _soundex
//	  _metaphone
//	  _double_metaphone
//	  _levenshtein
//	  _similar_text
//
// Informational variables (from OTEdictionary):
//
//	$base_language		- ISO 639 code for base language
//	$reverse_language	- ISO 639 code for reverse language
//	$base_name		- Name of the dictionary, in base language
//	$reverse_name		- Name of the dictionary, in reverse language
//	$version		- Version of the dictionary
//  
// Translation setup variables (from OTEdictionary):
//
//	$direction 		- 'normal', 'reverse', or 'multi'
//				- The direction of the translation
//	$against		- 'all', 'clean', 'dirty' 
//				- what type of words to match against 

// Load the Double MetaPhone class, if needed
//include_once( $ote_home . '/functions/DoubleMetaPhone.class.php');

////////////////////////////////////////////////////////////////////////////
class OTE extends OTEdictionary {





function word_info( $word ) {
// sim and fuzzy not working
// for some odd odd reason.. why ?
//
        $this->cr = ', ';
        //$s = $this->translate_similar( $word );
        //$f = $this->translate_fuzzy( $word );
        return
          "<table border=0 class=header_reverse>"
        . "<tr><td class=header width=60>source</td><td>$word->source</td></tr>"
        . "<tr><td class=header>target</td><td class=header>" . $word->target_list() . "</td></tr>"
        . "<tr><td class=header>box</td><td>$word->box</td></tr>"
        . "<tr><td class=header>soundex</td><td>" . $word->soundex() . "</td></tr>"
        . "<tr><td class=header>metaphone</td><td>" . $word->metaphone() . "</td></tr>"
        //. "<tr><td class=header>fuzzy</td><td>"
        //. $this->xdebug($f->target)
        //. "</td></tr>"
        //. "<tr><td class=header>similar</td><td>"
        //.  $this->xdebug($s->target)
        //. "</td></tr>"
        . "<tr><td class=header>engines</td><td>"
        . $this->engines( $word->source ) . "</td></tr>"
        . "</table>"
        ;
} // END word_info


// 
function engines ( $x ) {

	$rval = '';
	$target = 'target="_lookup"';

	// if the input has a space in it, it is a MULTI
	// if the input has a no space in it, it is a SINGLE 
	//  $direction is 'reverse' or NOT 'reverse'
	
	if ( eregi(" ", $x) && $this->direction != 'reverse') {
		reset( $this->multi_engines );	
		while( list($key,list($name,$url))  = each($this->multi_engines) ) { 
			$rval .= '<a href="' . $url . urlencode($x) . '"' . " $target>$name</a>" . $this->cr; }
	} else if ( eregi(" ", $x) ) {
		reset( $this->multi_engines_reverse );	
		while( list($key,list($name,$url))  = each($this->multi_engines_reverse) ) { 
			$rval .= '<a href="' . $url . urlencode($x) . '"' . " $target>$name</a>" . $this->cr; }
	} else if ( $this->direction != 'reverse') {
		reset( $this->single_engines );	
		while( list($key,list($name,$url))  = each($this->single_engines) ) { 
			$rval .= '<a href="' . $url . urlencode($x) . '"' . " $target>$name</a>" . $this->cr; }
	} else {
		reset( $this->single_engines_reverse );
		while( list($key,list($name,$url))  = each($this->single_engines_reverse) ) { 
			$rval .= '<a href="' . $url . urlencode($x) . '"' . " $target>$name</a>" . $this->cr; }
	}

	return $rval;

} // END function engines



// internal search types
//   Inputs
//     compares $a into $b
//   Outputs
//	1 on a successfull match
//	0 on no match found
function do_exact( $a, $b ) {
  if ( strtoupper($a) == strtoupper($b) ) { return 1; } else { return 0; }
}
function do_fuzzy( $a, $b ) {
  if( !$a || !$b ) { return 0; }
  if ( eregi( $a, $b ) ) { return 1; } else { return 0; }
}
function do_soundex( $a, $b ) {
  if ( soundex($a) == soundex($b) ) { return 1; } else { return 0; }
}
function do_metaphone( $a, $b ) {
  if ( metaphone($a) == metaphone($b) ) { return 1; } else { return 0; }
}
//function do_double_metaphone( $a, $b) {
// $ma = new DoubleMetaPhone($a);
// $mb = new DoubleMetaPhone($b);
// if ( $ma->primary == $mb->primary ) { return 1; } 
// if ( $ma->secondary == $mb->secondary) { return 1; } 
// return 0;
//}
// need error check for this:   how long is too long?
// Warning: levenshtein(): argument string(s) too long 
// Complexity: O(m*n)
function do_levenshtein( $a, $b ) {
  $distance = levenshtein($a,$b);
  if ( $distance < $this->do_range(strlen($a)) ) { return 1; } else { return 0; }
}
// Complexity: O(max(n,m)**3)
function do_similar_text( $a, $b ) {
  $sim = similar_text($a,$b);
  $as = strlen($a);
  $range = $this->do_range($as);
  if (	$as > $sim - $range  && $as < $sim + $range ) { return 1; } else { return 0; }
}

// calculate range based on size of a word
function do_range( $size ) {
  if ( $size <= 2 )  { return 0; } else
  if ( $size <= 3 )  { return 0; } else
  if ( $size <= 4 )  { return 1; } else
  if ( $size <= 5 )  { return 1; } else
  if ( $size <= 6 )  { return 1; } else
  if ( $size <= 8 )  { return 2; } else
  if ( $size <= 10 ) { return 4; } else
  if ( $size <= 15 ) { return 6; } else
  if ( $size <= 20 ) { return 8; } else 
                    { return 10; }
}


/*********************************************************/
function clean( $q ) {
	trim( $q );
        $q = ereg_replace("\n"," ",$q);
        $q = ereg_replace("\t"," ",$q);
        $q = ereg_replace("\r"," ",$q);
        $q = ereg_replace("\."," ",$q);
        $q = ereg_replace("\?"," ",$q);
        $q = ereg_replace("\!"," ",$q);
        $q = ereg_replace("\,"," ",$q);
        $q = ereg_replace("\`"," ",$q);
//        $q = ereg_replace("\'"," ",$q);
        $q = ereg_replace("\""," ",$q);
        $q = ereg_replace("\("," ",$q);
        $q = ereg_replace("\)"," ",$q);
        $q = ereg_replace(">"," ",$q);
        $q = ereg_replace("<"," ",$q);
        $q = ereg_replace("-","",$q);
        $q = ereg_replace(":"," ",$q);
        $q = ereg_replace("/"," ",$q);
        $q = ereg_replace("[\x5c]"," ",$q);  // get rid of \ slashes
        $q = ereg_replace("\\223"," ", $q);  // get rid of double quote char
        return $q;
} // END of clean


// Translate Fuzzy
// Find words that are FUZZILY LIKE to source word
// by way of the soundex and metaphone methods
function translate_fuzzy( $source_word ) { 
	return $this->translate_similar( $source_word, 1 ); 
}

// Translate Similar
// Finds words that are SIMILAR to the source word
// by way of similar_text and levenshtein methods
function translate_similar ( $source_word, $do_fuzzy=0) {

	if( !$source_word ) { return; } // if no word object, return NULL
	reset( $this->wo ); // reset the word object array

	// create a word object from our source_word
	$x = new OTEword( $source_word );
	$rt = array();  // return target words

	if ( $this->direction != 'reverse' ) {

 		// Normal Direction // loop thru each word object
		while( list( $key, $word ) = each( $this->wo ) ) {

			if( $do_fuzzy ) {
				// if we have a match of type (soundex,metaphone, etc), save this word
				if ( $word->soundex() == $x->soundex() ) { array_push( $rt, $word->source ); }
 				elseif ( $word->metaphone() == $x->metaphone() ) { array_push( $rt, $word->source ); }
			} else {
 				if ( $this->do_levenshtein($word->source,$x->source) ) { array_push( $rt, $word->source ); }
 				elseif ( $this->do_similar_text($word->source,$x->source) ) { array_push( $rt, $word->source ); }
			}
		}	

 	} else {

		// Reverse Direction // loop thru all words
		while( list( $key, $word ) = each( $this->wo ) ) {
			reset($word->target);  // reset the target array
			// loop thru this words targets
			while( list( $trash, $t ) = each ($word->target) ) {
				if( $do_fuzzy ) {
					if ( soundex($t) == $x->soundex() ) { array_push($rt, $word->source ); }
					elseif ( metaphone($t) == $x->metaphone() ) { array_push($rt, $word->source ); }
				} else {
 					if ( $this->do_levenshtein($x->source,$t) ) { array_push( $rt, $word->source ); }
 					elseif ( $this->do_similar_text($x->source,$t) ) { array_push( $rt, $word->source ); }
				}
			}
		}

	} // end of if ( direction )

	// if we have target values, build new word object with this source 
	// and unique targets and fake box and return it
	if( $rt ) { return new OTEword( $source_word, array_unique($rt), 'SIMILAR' ); }

} // END of translate_similar


// translate
//
function translate( $source_word ) {

	$source_word = trim($source_word); // clean the input
	if( !$source_word ) { return; } // if no word, return NULL
	reset( $this->wo ); // reset the word object array

	if ( $this->direction != 'reverse' ) { 
		// Normal Direction
		// loop thru each word object
		while( list( $key, $word ) = each( $this->wo ) ) {
			// if the sources are the same, return this word object
			if ( strtoupper($word->source) == strtoupper($source_word) ) { return $word; }
		}
	} else {
		// Reverse Direction
		$rt = array(); // return target words
		$rb = array(); // return box(es)
		// loop thru all words
		while( list( $key, $word ) = each( $this->wo ) ) {
			// loop thru this words targets
			while( list( $kkey, $t ) = each ($word->target) ) {
				// if matched, save for later
				if ( strtoupper($t) == strtoupper($source_word)) { 
					array_push($rt, $word->source ); // save word
					array_push($rb, $word->box ); // save box
				} 
			}
		}
		$rb = array_unique( $rb ); // only unique values in box array
		while( list($key,$bb) = each( $rb ) ) { $box .= $bb . $this->cr; }	// save box as a string
		// build new word object with this source, target, box, IF we have stuff
		if( $rt ) { $rw = new OTEword( $source_word, $rt, $box); }
		// return new word
		return $rw;
	}
} // END of translate


// random word
function random_word() {
  return $this->wo[ array_rand($this->wo,1) ]; // get random word object from $wo and return it
} // END of random_word



// debug (OTE)
//
function debug ( $a="dog", $b="cat" ) {

$br = "<br>";
$rval .= 
   "OTE Debug Report " . microtime() . $br
  . $br . $this->base_name . " ( " . $this->reverse_name . " ) "
  . $br . $this->base_language . " to " . $this->reverse_language
  . $br . "version: " . $this->version
  . $br . "clean_dictionary: " . $this->clean_dictionary
  . $br . "dirty_dictionary: " . $this->dirty_dictionary
  . "<br>engine_dictionary: " . $this->engine_dictionary 
  . "<br>word count: " . $this->get_word_count()
  . "<br>sizeof(wo): " . sizeof($this->wo) 
  . "<br>sizeof(single_engines): " . sizeof($this->single_engines) 
  . "<br>sizeof(single_engines_reverse): " . sizeof($this->single_engines_reverse) 
  . "<br>sizeof(multi_engines): " . sizeof($this->multi_engines) 
  . "<br>sizeof(multi_engines_reverse): " . sizeof($this->multi_engines_reverse) 
  . "<br>reverse: " . $this->reverse
  . "<br>Matching <b>$a</b> into <b>$b</b>"
  . "<br>exact: " . $this->do_exact($a,$b)
  . "<br>fuzzy: " . $this->do_fuzzy($a,$b)
  . "<br>soundex: " . $this->do_soundex($a,$b)
  . "<br>&nbsp;soundex = " . soundex($a) . " " . soundex($b)
  . "<br>metaphone: " . $this->do_metaphone($a,$b)
  . "<br>&nbsp;metaphone = " . metaphone($a) . " " . metaphone($b)
  . $br . "similar_text: " . $this->do_similar_text($a,$b)
  . $br . "levenshtein: " . $this->do_levenshtein($a,$b)
  . $br . $br . "<br>translate($a) = " . $this->translate($a)
  . $br . "translate($b) = " . $this->translate($b)
  . $br 
  ;
  return $rval;
} // END of debug 

} // END of class OTE


////////////////////////////////////////////////////////////////////////////
class OTEweb extends OTEbase {
function show_dictionary_pulldown () {
  global $dictionary_list, $dictionary;
  // reset the dictionary_list array, or this will NOT work multiple times
  reset($dictionary_list);
  // Start select form
  echo '<select name="dictionary">';
  echo '<option value="">Select Dictionary:';
  // Loop thru the dictionary_list
  while (list ($key, $val) = each ($dictionary_list)) {
   echo '<option value="' . $val[1]  . '"';
   //if this is our selected dictionary...
   if ( $val[1] == $dictionary ) { echo 'selected'; }
        // show BASE_NAME
   echo '>' . $val[0];
  } // END of loop thru dict
  echo '</select>';
} // END of show_dictionary_pulldown


function log_it( $stuff ) {
  global $logfile, $logfilecutoff, $logfileheader, $logfileemail, $dictionary, $reverse ;
  if( !$logfile ) { return; } // if no $logfile defined, do nothing
  $date = `date`; chop($date); // get the current date/time
  $cr = "\n";
  $logstuff .= $cr . $date; $logstuff .= $dictionary; // build the log entry
  if ( $reverse ) { $logstuff .= '&reverse=1'; }
  $logstuff .= $cr . $stuff . $cr;

  //$fd = fopen($logfile, "a+"); // open the log file for appending
  if ( $fd = fopen($logfile, "a+") ) { // open the log file for appending
   $fout = fwrite($fd, $logstuff); // append our log entry
   fclose($fd);
   if( $logfileemail && (filesize($logfile) > $logfilecutoff) ) { // If the log is too big, make new one
    if ( $logfileemail ) { // Email the old log, if we have an email defined
     $fp = fopen($logfile, "r"); 
     $body = fread($fp, filesize($logfile)); fclose($fp);
     $mailsend = mail("$logfileemail", "$logfileheader", "$body"); // send the contents out via email
    } // END if logfileemail
    $fp = fopen($logfile, "w"); // Overwrite the current log with a clean log file
    $fout = fwrite($fp, "$logfileheader\n\n"); fclose($fp);
   } // END if log is too big
 } // END of open log file

} // END of log_it
} // END of class OTEweb

?>
