<?
//**************************************************//
//
//  Open Translation Engine (OTE)
//  http://www.ibiblio.org/dbarberi/ote/
//
//  Wordbox
//  Multi word translation tool
//
//*************************************************//

include_once("../../config.php"); // Main OTE Configuration
$title = "Word Box -- " . $title; // make my name my own
include($ote_home . "/skins/header.php"); // header
include( $ote_home . "/skins/dictionary_toolbar.php");
include( $ote_home . "/skins/wordbox_box.php");

// if there is data to look at
if($q) { 

	log_it($q); // Log the incoming query
	$ote = new OTE(); // create a new OTE instance

	if( $error_message = $ote->load_dictionary( $dictionary_home . $dictionary ) ) {
 		// error!
		print '<p>' . $error_message . '</p>';
	} else {
		// do the word box
		print word_boxen( $ote->clean( $q ) );
	}
	
}  // END of if($q)


// Footer HTML
include( $ote_home . "/skins/footer.php");


/*********************************************************/



/*****************************************/
function word_boxen( $sentance ) {

  global $ote, $green, $red, $view, $dictionary, $direction, $wordtool;
  
  // Get rid of extra spaces and other cleaning
  $sentance = $ote->clean($sentance);

  // if we have nothing to examine, go away!
  if( $sentance == NULL ) { return; }

  // put the sentance into an array
  $word_array = explode (" ", $sentance);

  // loop through all words
  while (list ($trash,$single_word) = each ($word_array) ) {

	// if we have a real word
	if( $single_word != "" ) { 
		// create the 'original' table row
		$original_row .= "<td><a href=$wordtool?dictionary=$dictionary&direction=$direction&q=$single_word>$single_word</a></td>"; 

		// create the translated table row
		// translate my word
		$myword = $ote->translate($single_word);
	
		if ( $myword ) {

			// if we found a translation...
			$translation_row .= '<td class="exact">' . $myword->target_list() . '</td>';
			$fuzzy_row .= '<td class="exact">&nbsp;</td>';
			$similar_row .= '<td class="exact">&nbsp;</td>';
			$box_row .= '<td class="exact">' . $myword->box . '</td>';

		} else {
			// if we found no translation
			$translation_row .= '<td class="failure">&nbsp;</td>';
			$box_row .= '<td class="failure">&nbsp;</td>';

			// try to find fuzzy matches
			$fuz = $ote->translate_fuzzy($single_word);
			if( $fuz ) {
				$fuzzy_row .= '<td class="similar">' . $fuz->target_list() . '</td>';
			} else { 
				$fuzzy_row .= '<td class="failure">&nbsp;</td>';
			}

		// then try to find similar words
		$sim = $ote->translate_similar($single_word);
		if ( $sim ) {
			// if we found similar words
			$similar_row .= '<td class="similar">' . $sim->target_list() . '</td>';
		} else {
			// if we found NO similar words
			$similar_row .= '<td class="failure">&nbsp;</td>';
		}
      } // END of if myword
      
      // create the 'offsite engine' table row
      $engine_row .= '<td class="offsite">' . $ote->engines( $single_word ) . '</td>';

    } // END of if we have a real word

  } // END of loop through all words


  // Build HTML table


  // switch language tags if in reverse mode
  if( $ote->direction == "reverse" ) { 
	$tmp = $ote->base_language;
	$ote->base_language = $ote->reverse_language;
	$ote->reverse_language = $tmp;
  }

  // HTML header
  $rval .=  '<table border="0" cellpadding="4" cellspacing="3" bgcolor="#FFFFFF">';

  // BOXES
  $rval .= "<tr><td><em>Box:</em></td>" . $box_row . "</tr>";


  // ORIGINAL
  $rval .= '<tr><td><em>' . $ote->base_language . ':</em></td>' . $original_row . '</tr>';

 // TRANSLATE EXACT
  $rval .= '<tr><td><em>' . $ote->reverse_language . ':</em></td>' . $translation_row . '</tr>';

	// FUZZY
  $rval .= '<tr><td><em>Fuzzy:</em></td>' . $fuzzy_row . '</tr>';
  // SIMILAR
  $rval .= '<tr><td><em>Similar:</em></td>' . $similar_row . '</tr>';

  // SINGLE ENGINES
  $rval .= "<tr><td><em>single<br/ >engines</em></td>" . $engine_row . '</tr>';

  // MULTI ENGINES
  //$foe = get_full_offsite_engines( $sentance );
 	 $rval .= '<tr><td><em>multi<br />engines</em></td>'
		. '<td class="offsite" colspan="10">' . $ote->engines( $sentance ) . "</td></tr>";


  // HTML closing
  $rval .= "</table>";

  return $rval;

} // END of word_boxen



/****************************************************************/
?>
