<?php
//**********************************************************/
//
//  Open Translation Engine
//
//  View 
//
//  Dictionary Viewing Tool
//
//  INPUTS:
//
//  dictionary	 - OTE XML dictionary file
//  format 	- How to display the dictionary list
//  q		 - search query
//  filter_length	- filter by characters of this length
//
//
//**********************************************************/

// no format is defined? (may be just a 'reset' of page)
if( !$format ) { $no_format = 1; }

// main OTE configuration file  (sets default for $dictionary)
include_once('../../config.php');

// first, do we need to redirect somewhere else?
if ( $format == 'OTE' && $dictionary ) {
        // if we have a dictionary, and are in OTE raw-XML view mode
        header("Location: " .  $web_dictionary_home . $dictionary);
}



// make my name my own...
$title .= " -- Dictionary Viewer";

// print header
include($ote_home . '/skins/header.php');

// dictionary tool bar
include($ote_home . '/skins/dictionary_toolbar.php');

// print View html form
include($ote_home . '/skins/view_box.php');

// reset skin to null if needed
if ( $no_format ) { $format = NULL; }

// print the view, if applicable
if ( $dictionary && $format ) { print view_dictionary(); }

// print footer
include($ote_home  . '/skins/footer.php');


/*****************************************************************/
function view_dictionary() {

  global $ote, $format, $dictionary, $dictionary_home, $web_dictionary_home, $parse_time;

  // create a new OTE object
  $ote = new OTE();

  // load the dictionary
  $start_time = start_timer();
  if ( $err = $ote->load_dictionary($dictionary_home . $dictionary) ) { return $err; }
  $parse_time = end_timer( $start_time );

  // dictionary is parsed, now view it:

  switch ( $format ) {
   case 'JAVASCRIPT': return JAVASCRIPT_view(); break;
   case 'CSV': return CSV_view(); break;
   case 'TAB': return TAB_view(); break;
   case 'HTML': return HTML_view(); break;
   case 'DEBUG': return DEBUG_view(); break;
   case 'OTE':  
	// view the raw XML file
        // You should never get here, because of the location() command
        // at the start of this file... but just in case:
        print '<p><a href="' . $web_dictionary_home . $dictionary . '">'
                 . $web_dictionary_home . $dictionary . '</a></p>'; break;
   default: return;

  } // END switch on format  


} // END of view_dictionary 


/*****************************************************************/
function DEBUG_view() {
  global $ote, $parse_time;
  $rval = '<pre class="code">Dictionary parsed in <b>' . "$parse_time</b> seconds<br>\n";
  $rval .= $ote->debug() . "\n</pre>";
  return $rval;
}


/*****************************************************************/
function JAVASCRIPT_VIEW() {
  global $ote, $dictionary;

  
  $r = $dictionary . '_array = new Array(';

// loop thru all words
while ( list($key, $word) = each($ote->wo) ) {
  $word->cr = ', ';
  $r .= 'new Array("' 
	.  $word->source 
      	. '","'
	. $word->target_list("-")
	. '"),'
	;

} // END of loop thru all words

  $r .= ')';

  return $r;
}

/*****************************************************************/
function HTML_view() {

  global $ote, $wordtool, $dictionary;

  $rval = '<p><table border="1" cellpadding="0" cellspacing="0" class="header_reverse"><tr>'
  . '<td><b>' . $ote->base_language . '</b></td><td>' . $ote->reverse_language
  . '</td><td>[BOX]</td></tr>';

  // loop thru all words
  //while ( list($key, list($base_word,$reverse_word,$box)) = each($ote->w) ) {

  while ( list($key, $word) = each($ote->wo) ) {
	//   if ( filter($base_word,$reverse_word) ) {
	$rval .= '<tr><td><b>' 
		. '<a href=' . $wordtool . '?dictionary=' . $dictionary . '&q=' . $word->source . '>'
		. $word->source . '</a></b></td><td>' 
		. $word->target_list()
	. '</td><td>' . $word->box. '</td></tr>'; 
 //  }

  } // END of loop thru all words

  $rval .= '</table></p>';

  return $rval;
}


/*****************************************************************/
function TAB_view() {

  global $ote, $web_dictionary_home, $dictionary, $web_url, $title, $version;

  $cr = "\n";
  $tab = "\t";
  $hash = '# ';

  $rval = '<pre class="code">';

  $rval .= $hash . $title . $cr 
  . $hash . $web_url . $cr 
  . $hash . $cr
  . $hash . 'Format:' . $cr 
  . $hash .  $ote->base_language . ' (tab) ' . '[BOX]' . ' (tab) ' . $ote->reverse_language . ' (tab) ...' . $cr
  . $hash . $cr; 


  // loop thru all words
  //while ( list($key, list($base_word,$reverse_word,$box)) = each($ote->w) ) {
  while ( list($key, $word) = each($ote->wo) ) {

   //if ( filter($base_word,$reverse_word) ) {

	$word->cr = $tab;

    $rval .= 
	  $word->source . $tab 
	. '[' .  $word->box . ']' . $tab
	. $word->target_list() . $tab 
	. $cr;

   //}
  } // END of loop thru all words


  return $rval . '</pre></p>';


}

/*****************************************************************/
function CSV_view() {

  global $ote;

  $c = ',';
  $cr = "\n";
  $rval = ''; 


  $rval .= '<pre class="code">' 
	. 'KEY,' 
	. $ote->base_language . $c
	. '[BOX]' . $c
	. $ote->reverse_language . '[...]' . $c . $cr;


  // loop thru all words
  //while ( list($key, list($base_word,$reverse_word,$box)) = each($ote->w) ) {
  while ( list($key, $word) = each($ote->wo) ) {

//   if ( filter($word->source,$word->target) ) {
       
	$word->cr = ',';  // for target_list
	$rval .= 
		  $key . $c 
		. $word->source . $c 
		. '[' . $word->box . ']' . $c
		. $word->target_list() . $cr;

 //  }
  } // END of loop thru all words


  return $rval . '</pre>';

}


/*****************************************************************/
//
//   View Tool Filter
//   
//  INPUT:
// 	base_word, reverse_word
//  
//  INPUT (globals):
//	q	- search term filter
//	filter_length	- length filter, *,1-7,8+   
//
//  OUTPUT:
//    
function filter( $base_word, $reverse_word ) {

  // until this is fixed... no filtering
  return 1;
  global $q, $filter_length;

  // if we have a (Q)uery, pass thru the seearch filter
  if ( $q ) {  
	return filter_search( $base_word, $reverse_word ); 
  } else {
	return 0;
  }

  // pass thru the length filter, sets $word to NULL if not correct length 
//  if( $filter_length && $filter_length != "*" ) { 
//	$word = filter_length( $word ); 
//  }

  return 0;


}

/*****************************************************************/
// 
// returns 1 on match found
// returns 0 on no match or error
//
function filter_search( $base_word, $reverse_word ) {

  global $ote, $q, $match;

  //print "<BR />filter_search b=$base_word, r=$reverse_word";

  switch ( $match ) {
    case 'exact':
      if( $ote->do_exact($base_word,$q) || $ote->do_exact($reverse_word,$q)  ) { return 1; }
      break;

    case 'similar':
      if( $ote->do_fuzzy($base_word,$q) || $ote->do_fuzzy($reverse_word,$q)  ) { return 1; }
      break;

    case 'fuzzy':
       if ( $ote->do_fuzzy($q,$base_word) || $ote->do_fuzzy($q,$reverse_word) ) { return 1; } 
       break;
    default:
       return 0;
  }


} // END of filter_search

/*****************************************************************/
function filter_length( $word ) {

  global $filter_length, $BASE, $TO;

    // show all words, no filter
    if ( $filter_length == '*' ) { return $word; }

    // show all words of 8 or more characters
    if ( $filter_length == '8+' ) {
      if ( strlen($word[$BASE]) > 7 || strlen($word[$TO]) > 7 ) {
        return $word;
      } 
    }

    // show words of 1 to 7 characters long
    if ( strlen($word[$BASE]) == $filter_length || strlen($word[$TO]) == $filter_length ) {
      return $word;
    }

    // failed our filters, return null!
    return NULL; 


}
/*****************************************************************/
?>
