<?
//**************************************************//
//
//  Open Translation Engine (OTE)
//  http://www.ibiblio.org/dbarberi/ote/
//
//
//*************************************************//

include_once("../../config.php"); // Main OTE Configuration
$title .= " -- Word Tool"; // make my name my own
include($ote_home . "/skins/header.php"); // header
include($ote_home . "/skins/dictionary_toolbar.php");
include($ote_home . "/skins/wordtool_box.php");

$ote = new OTE(); // create a new OTE instance

// attempt to load the dictionary
if ( $error_message = $ote->load_dictionary( $dictionary_home . $dictionary ) ) {
	print $error_message;
} else {
	$word = $ote->translate( $q ); // translate the user input 
	if ( !is_object($word) ) { // no translation? 
		$word = new OTEword( $q ); // create an empty word
		$word->target = array("Word not in dictionary");
	}
	print $ote->word_info( $word ); // print pretty info about the word
}


print "<pre>" . $ote->xdebug( $word ) . "</pre>";
print "<pre>" . $word->linked_target_list() . "</pre>";

include($ote_home . "/skins/footer.php"); // Footer HTML
/*********************************************************/
?>
