<?
// BumbleBee
//
// Worldwide Lexicon (WWL) PHP Class library
//
// Open Translation Engine
// http://ibiblio.org/dbarberi/ote/
//
//


class WWL {


// Utility Functions

/**
* response
* Build an WWL XML response from an array of name/values
*
* @param $values array
**/
function response( $values ) {

  if(!is_array($values)) { return "<wwl><result>error</result></wwl>"; }

  $xml_r = "<wwl>\n";
  while( list($name, $value) = each($values) ) { 
    $xml_r .= "<$name>$value</$name>\n"; 
  }
  $xml_r .= "</wwl>";
  return $xml_r;
} // END of function response

/**
* xdebug
* print any value: string, array, object, whatever 
*
* @param $msg string
*/
function xdebug($msg) {
  ob_start(); print_r( $msg ); $gc = ob_get_contents(); ob_end_clean(); return $gc;
}


// Server and Supernode Functions


function WWLPing() { 
	return $this->response( array("result"=>"ok") ); 
}

function WWLMethods() { 
	return $this->response( array("result"=>"error") ); 
}

function WWLServerStatus( $status_message, $verbose_message="" ) {
	return $this->response( 
	  array(
		"result"=>"error",
		"status_message"=>$status_message,
		"verbose_message"=>$verbose_message
	  ) 
	);
}

function WWLMOTD( $language="", $text="" ) { 
	return $this->response( 
		array(
			"language"=>$language,
			"text"=>$text
		)
	); 
}

function WWLFindServers( $source_language, $target_language, 
	$netmask="", $servertype="") {

	return $this->response(
		array(
			"result"=>"error",
			"source_langauge"=>$source_language,
			"target_language"=>$target_language, 
			"netmask"=>$netmask, 
			"servertype"=>$servertype
		)
	);
}

function WWLCount() { 
	return $this->response( array("result"=>"error") ); 
}

function WWLRegister( 
 $nickname, $description, $www,
 $version, $proxy, $uri,
 $jabber="", $supernode,
 $read, $post, $post_anon, $realtime,
 $source_lang, $target_lang, $servertype,
 $monolingual_query, $word_translation, $text_translation,
 $transliteration, $semantic_net, $authreqd, $etc="" ) { 

	return $this->response( 
		array(
			"result"=>"error",
			"nickname"=>$nickname, 
			"description"=>$description, 
"www"=>$www,
"version"=>$version, 
"proxy"=>$proxy, 
"uri"=>$uri,
"jabber"=>$jabber,
"supernode"=>$supernode,
"read"=>$read, 
"post"=>$post, 
"post_anon"=>$post_anon, 
"realtime"=>$realtime,
"source_lang"=>$source_lang, 
"target_lang"=>$target_lang, 
"servertype"=>$servertype,
"monolingual_query"=>$monolingual_query, 
"word_translation"=>$word_translation, 
"text_translation"=>$text_translation,
"transliteration"=>$transliteration, 
"semantic_name"=>$semantic_net, 
"authreqd"=>$authreqd, 
"etc"=>$etc
		) 
	); 
}


// lexicon functions
function WWLQuery() {
	return $this->response( array("result"=>"error") ); 
}
function WWLSearchText() { 
	return $this->response( array("result"=>"error") ); 
}

function WWLTranslate( $source_language, $target_language, $source_text, $searchtype) {

        global $dictionary_home;

        $ote = new OTE();
	$ote->cr = " ";

        $ld = $ote->load_dictionary( $dictionary_home . 'NL-EN.xml');

        if( $source_language == "eng" && $target_language == "dut" ) {
        	$ote->direction = 'reverse';
	}

        $t = $ote->translate( $source_text );

        $url = 'http://www.ibiblio.org/dbarberi/ote/';

  if( $t->target ) { // if we have a translation ...

    $r = "<wwl>\n"
	. " <result>ok</result>\n"
	. " <count>" . sizeof($t->target) .  "</count>\n"
	;

    while( list($id,$text) = each( $t->target ) ) { 
	$r .= " <record>\n"
	. "  <id>$id</id>\n"
	. "  <sl>$source_language</sl>\n"
	. "  <tl>$target_language</tl>\n"
	. "  <stext>$source_text</stext>\n"
	. "  <ttext>$text</ttext>\n"
	. "  <role>" . trim($t->box) . "</role>\n"
	. " </record>\n"
	;
    } // end of each target 
    //$r .= " <debug>" . $this->xdebug($t) . "</debug>\n";
    $r .= "</wwl>";

    return $r;

  } else {
  	$ra = array( 'result'=>"error", 'text'=>"No translation found for '$source_text'" );
  	return $this->response($ra);
  } // end of if we have a translation


} // END of WWLTranslate


// lexicon@home functions
function WWLFetch( $jobid ) { 
	return $this->response( array("result"=>"error","jobid"=>$jobid) ); 
}
function WWLReject( $jobid, $reason, $message ) { 

	return $this->response( array(
	"result"=>"error",
	"jobid"=>$jobid,
	"reason"=>$reason,
	"message"=>$message
	) ); 
}
function WWLRequest( $source_language, $target_language, $mode, 
	$username="", $pw="", $bid_price="", $bid_currency="" ) { 

	return $this->response( array(
	"result"=>"error",
	"source_language"=>$source_language,
	"target_language"=>$target_language,
	"mode"=>$mode,
	"username"=>$username,
	"pw"=>$pw,
	"bid_price"=>$bid_price,
	"bid_currency"=>$big_currency
	) ); 

} // END of WWLRequest



function BabelFishTranslate( $source_language, $target_language, $source_text) {

 $allowed = array(
"en_fr", //English -> French           
"en_de", //English -> German           
"en_it", //English -> Italian          
"en_pt", //English -> Portugese        
"en_es", //English -> Spanish          
"fr_en", //French -> English           
"de_en", //German -> English           
"it_en", //Italian -> English          
"pt_en", //Portugese -> English        
"ru_en", //Russian -> English          
"es_en" //Spanish -> English          
);

$source_language = strtolower($source_language); $target_language = strtolower($target_language);
$old_source_language = $source_language;
$old_target_language = $target_language;
switch($source_language) {
  case 'eng': $source_language = 'en'; break;
  case 'fre': $source_language = 'fr'; break;
  case 'ger': $source_language = 'de'; break;
  case 'ita': $source_language = 'it'; break;
  case 'por': $source_language = 'pt'; break;
  case 'spa': $source_language = 'es'; break;
  case 'rus': $source_language = 'ru'; break;
}
switch($target_language) {
  case 'eng': $target_language = 'en'; break;
  case 'fre': $target_language = 'fr'; break;
  case 'ger': $target_language = 'de'; break;
  case 'ita': $target_language = 'it'; break;
  case 'por': $target_language = 'pt'; break;
  case 'spa': $target_language = 'es'; break;
}
$ll = $source_language . "_" . $target_language;

$good_ll = 0;
while( list($trash,$x) = each($allowed) ) {
  if( $ll == $x ) { $good_ll = 1; } // we have a good language string
}

if( $good_ll && $source_text ) {

  $bf = new soapclient('http://services.xmethods.net:80/perl/soaplite.cgi'); // set up the soap client
  $input = array( "translationmode"=>$ll, "sourcedata"=>$source_text ); // setup the input variables
  $rr = $bf->call('BabelFish', $input, 'urn:xmethodsBabelFish', 'urn:xmethodsBabelFish#BabelFish'); // do the call
  $url = "http://babelfish.altavista.com/";
  if( is_array($rr) ) { $debug = $this->xdebug($rr); }  // if there is an error
  $context = 'BabelFish via xmethods.net via WWL Gateway Server';
//  $ra = array( 'id'=>$id,'url'=>$url,'ttext'=>$rr,'context'=>$context, 'debug'=>$debug); 

  $rr = trim($rr);

  $ra = "
<wwl>
  <result>ok</result>
  <count>1</count>
  <record>
    <id>0</id>
    <sl>$old_source_language</sl>
    <tl>$old_target_language</tl>
    <stext>$source_text</stext>
    <ttext>$rr</ttext>
  </record>
</wwl>
";
  return $ra;

} else {

  $err_text = "
This server supports:
[Source Language] [Target Language] [Description]
eng	fre	English to French
eng	ger	English to German
eng	ita	English to Italian
eng	por	English to Portugese
eng	spa	English to Spanish
fre	eng	French to English
ger	eng	German to English
ita	eng	Italian to English
por	eng	Portugese to English
rus	eng	Russian to English
spa	eng	Spanish to English
";

	$ra = array( 'result'=>'error', 'text'=>$err_text);
  	return $this->response($ra);
}
	
} // END of babelfish
 



} // END of class WWL


?>
