<?php

print "<h1>" . microtime() . " - A Taste of PRAX</h1>\n";

# Display XML
print '<b>Given the XML:</b> <pre>' . htmlentities( implode("", file("./servers.xml")) ) . '</pre>';

# Include the RAX library
include( "./prax.class.php" );

# Create a new RAX object
$rax = new RAX();

# Open the XML document
//$rax->openfile("./sample.xml");
$rax->openfile("./servers.xml");

# Select the individual record delimiter
//$rax->record_delim = 'implementation';
$rax->record_delim = 'server';

# Start parsing the XML document
$rax->parse();

# Read the first record
$rec = $rax->readRecord();

# Field Names
$fieldnames = $rec->getFieldnames();
print 
	"<b>\$rec->getFieldnames()</b>" .
	"<blockquote>" .  join( "<br />", $fieldnames ) . "</blockquote>";

# Field Values
print 
	"<b>\$rec->getFields()</b>" .
	"<blockquote>" .  join( "<br />", $rec->getFields() ) . "</blockquote>";

print 
	"A loop around <b>\$rec->getRow()</b>" .
	"<blockquote>";

while ( $rec ) {
	$row = $rec->getRow();
	print "<a href='" . $row["url"] . "'>" . $row["module"] . " for " . $row["language"] . "</a> by " . $row["author"] . "<br />\n";
	$rec = $rax->readRecord();
}

print "</blockquote>";

?>

