<?php

// ***************************************************************************
// * Copyright  2003 - Thomas Egtvedt - www.evaria.com - thomas@evaria.com  *
// *                                                                         *
// *      ECMS - Content Management System - Support: forum.evaria.com       *
// *                                                                         *
// * This program is commercial software; you can not redistribute/reproduce *
// * it and/or sell it without the prior written consent of www.evaria.com   *
// *                                                                         *
// * This program is distributed in the hope that it will be useful,         *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of          *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
// ***************************************************************************

/******************************* LINK MANAGER FUNCTIONS START *************************************/

// These functions are used to control the link directory
// To test locally, just set the 2 functions below to false
define ("TEST_URL",true);
define ("TEST_MAIL",true);

/******************************* BASIC LINK MANAGER FUNCTIONS *************************************/

// Initializing the DB connection...
function connection_BD()
{
	global $db_server, $db_user_login, $db_user_pass, $db_name;
	// Connecting to server
	$linkid = @mysql_connect($db_server,$db_user_login,$db_user_pass) or die ("Could not connect to MySQL server!");
	// Selecting DataBase
	@mysql_select_db($db_name,$linkid) or die("Impossible to select your DataBase of choice<br>\nHere is what your mySQL server said:<br>\n".mysql_error());
	return $linkid;
}

// Building $sql message if there should be some sort of a problem
function send_sql($sql,$message)
{
	if(!$res = @mysql_query($sql))
	{
		$message_erreur = "<font color=\"#ff0000\">\n";
		$message_erreur .= "Impossible to complete your request for $message\n";
		$message_erreur .= "<br><br>\n";
//		$message_erreur .= "Here is your request:<br>\n";
//		$message_erreur .= "$sql\n";
//		$message_erreur .= "<br><br>\n";
		$message_erreur .= "Here is the error message given by your mySQL DB:<br>\n";
		die ("$message_erreur".mysql_errno()." : ".mysql_error()."</font>\n");
	}
	return $res;
}

// Building HTML to display the links in various ways...
function affiche_site($resultat,$type="index")
{
global $nb_days2benew,$position;
?>

<TABLE class="link_border" align="center" width="100%" cellspacing="0" cellpadding="0" border="0">
  <TR>
   <TD>
<TABLE width="100%" cellspacing="1" cellpadding="2" border="0">
  <TR>
	<?
	if ($type == "search" || $type == "index")
	{
	echo "    <TD class=\"link_top\" align=\"left\" colspan=\"6\">\n";
	} else {
	echo "    <TD class=\"link_top\" align=\"left\">\n";
	}
	?>
<TABLE width="100%" cellspacing="0" cellpadding="0" border="0">
  <TR>
    <TD class="date" align="left" valign="middle">
	<?
	if ($type == "topc" || $type == "topv")
	echo "<span class=\"link_number\">".$position.") </span>\n";
	?>
	<a href="link_goto.php?id=<? echo $resultat["id"]; ?>" target="_blank" class="link_title"><? echo $resultat["titre"]; ?></a></TD>
	<TD align="right" valign="middle" class="date">
	<?
	if ($type == "topv")
	{
	?>
	<span class="link_rating">Rated <? echo $resultat["moyenne_votes"]; ?>/10 after <? echo $resultat["nb_votes"];
	if ($resultat["nb_votes"] > 1)
	{ ?> votes <? }
	else
	{ ?> vote <? }
	?>
	</span>
	<?
	} else {
	if ($type == "index") 
	{
	?>
	<span class="link_date"><? echo "Added ".convert_date_us2fr($resultat["date_validation"]); ?></span>
	<?
	} else {
	if ($type != "search")
	{
	?>
	<span class="link_hits"><? echo $resultat["nb_clics"];
	if ($resultat["nb_clics"] <= 1)
	{ ?> hit <? }
	else
	{ ?> hits <? }
	?>
	</span><span class="link_date"><? echo " since ".convert_date_us2fr($resultat["date_validation"]); ?></span>
	<?
	}
	}
	}
	// Display image besides new links...
	if ($resultat["dif_days"] > $nb_days2benew && $type == "search")
	{
	?>
	<span class="link_to_cat"><a class="link_cat_nav" href="?view=link_home&cat_id=<? echo $resultat["id_cat"]; ?>"><? echo $resultat["cat_name"]; ?></a><img
	src="./img/folder_smal_o.gif" border="0" align="absmiddle" hspace="5"></span>
	<?
	} else {
   if($resultat["dif_days"] <= $nb_days2benew && $type != "new" && $type != "search")
	{
   echo "<img src=\"img/new.gif\" border=\"0\" align=\"absmiddle\" hspace=\"5\">\n";
   }
   if($resultat["dif_days"] <= $nb_days2benew && $type == "search")
	{
   ?>
   <span class="link_to_cat"><a class="link_cat_nav" href="?view=link_home&cat_id=<? echo $resultat["id_cat"]; ?>"><? echo $resultat["cat_name"]; ?></a><img
	src="./img/new.gif" border="0" align="absmiddle" hspace="5"></span>
   <?
   }
	}
	?></TD>
  </TR>
</TABLE>
    </TD>
  </TR>
  <TR>
	<?
	if ($type == "search" || $type == "index")
	{
	echo "    <TD class=\"link_mid\" valign=\"top\" colspan=\"6\">\n";
	} else {
	echo "    <TD class=\"link_mid\" valign=\"top\">\n";
	}
	?>
	<span class="link_description"><? echo $resultat["description"]; ?></span></TD>
  </TR>
  <TR>
    <?
	if ($type == "index" || $type == "search")
	{
	?>
	<TD class="link_foot" align="center" valign="middle" width="15%"><span
	class="link_hits"><? echo $resultat["nb_clics"];
	if ($resultat["nb_clics"] <= 1)
	{ ?> hit <? }
	else
	{ ?> hits <? }
	?>
	</span></TD>
	<TD class="link_foot" align="center" valign="middle" width="20%"><span
	 class="link_rating">Rated <? echo $resultat["moyenne_votes"]; ?>/10</span></TD>
	<TD class="link_foot" align="center" valign="middle" width="15%"><span
	class="link_rating"><? echo $resultat["nb_votes"];
	if ($resultat["nb_votes"] <= 1)
	echo " vote";
	else
	{ echo " votes"; }
	?></span></TD>
	<TD class="link_foot" align="center" valign="middle" width="15%"><a class="link_vote" 
	href="#" onclick="window.open('link_vote.php?id_site=<? echo $resultat["id"]; ?>', 'win2', 'status=no,toolbar=no,scrollbars=no,titlebar=no,menubar=no,resizable=no,width=350,height=180,directories=no,location=no,top=10,left=10');return false">Vote</a></TD>
	<TD class="link_foot" align="center" valign="middle" width="20%"><span class="link_review"><a class="link_add_review"
	href="#" onclick="window.open('link_reviews.php?id_site=<? echo $resultat["id"]; ?>', 'win3', 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=no,width=350,height=500,directories=no,location=no,top=10,left=10');return false">Reviews</a> (<? echo $resultat["nb_com"]; ?>)</span></TD>
	<TD class="link_foot" align="center" valign="middle" width="15%"><a class="link_add_review"
	href="#" onclick="window.open('link_reviews.php?id_site=<? echo $resultat["id"]; ?>#add', 'win4', 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=no,width=350,height=500,directories=no,location=no,top=10,left=10');return false">Write new</a></TD>
	<?
	} else {	
	?>	
   <TD class="link_foot" align="right" valign="middle"><span class="link_to_cat"><a
	class="link_to_cat" href="?view=link_home&cat_id=<? echo $resultat["id_cat"]; ?>"><? echo $resultat["cat_name"]; ?></a><img
	src="./img/folder_smal.gif" border="0" align="absmiddle" hspace="5"></span></TD>
	<?
	}
	?>
  </TR>
</TABLE>
    </TD>
  </TR>
</TABLE>
<br>

<?
}

// Building category navigation menu...
function show_arbo_en_ligne($id_cat,$page_name = "?view=link_home",$sep = " &raquo; ", $sessid = false)
{
	global $T_categories;
	
	$accueil = "<span class=\"link_navigation\"><a href=\"";
	if (!$sessid)
		$accueil .= $page_name;
	else
		$accueil .= addsess2url($page_name,$sessid);
	$accueil .= "\">Home</a>". $sep ."\n";

	$id_cat_mere = 1;
	while($id_cat_mere)
	{
		$sql = "SELECT id_cat_mere,cat_name FROM $T_categories WHERE id = '$id_cat' ";
		$res = send_sql($sql,"creating navigation");
		$result = mysql_fetch_array($res,MYSQL_ASSOC);
		$id_cat_mere = $result["id_cat_mere"];
		$nom = $result["cat_name"];
		if (!$sessid)
			$arbo = "<a href=\"$page_name&cat_id=$id_cat\">".$nom."</a>" . $sep . $arbo;			
		else
			$arbo = "<a href=\"".addsess2url("$page_name?cat_id=$id_cat",$sessid)."\">".$nom."</a>" . $sep . $arbo;
		$id_cat = $id_cat_mere;
	}
	$arbo = substr($arbo,0,strlen($arbo)-strlen($sep));
	$arbo .= "</span>\n";
	return $accueil.$arbo;
}

// Creating path to the categories...
function path2cat($cat_id,$separateur = " &raquo; ")
{
	global $T_categories;
	
	$id_cat_mere = 1;
	
	while($id_cat_mere)
	{
		$sql = "select cat_name,id_cat_mere from $T_categories where id = '$cat_id'";
		$res = send_sql($sql,"finding the path to a category in order to create the list");
		$resultat = mysql_fetch_array($res,MYSQL_ASSOC);
		$id_cat_mere = $resultat["id_cat_mere"];
		$cat_name = $resultat["cat_name"];
		if(empty($path))
			$path = $cat_name;
		else
			$path = $cat_name . $separateur . $path;
		$cat_id = $id_cat_mere;
	}
	return $path;
}

// Displaying drop down menu over all categories...
function show_list_cats($name_field = "id_cat", $idselected = "", $cache_cat = false)
{
	global $T_categories;

	$list = "<select name=\"$name_field\" class=\"link_cats_list\">\n";	
	$list .= "<option value=0>Select a Category</option>\n";
	$list .= "<option value=0>--------------------------</option>\n";

	if ($cache_cat)
		$sql = "SELECT id FROM $T_categories WHERE activation = 1 AND can_add = 1 ORDER BY cat_name ASC ";
	else		
		$sql = "SELECT id FROM $T_categories ORDER BY cat_name ASC ";
	$res = send_sql($sql,"finding categories to build the list");
	
	while ($resultat = mysql_fetch_array($res,MYSQL_ASSOC))
	{
		$path = path2cat($resultat["id"]);
		if ($resultat["id"] != $idselected)
			$list_cats[] = "<option label=\"$path \" value=$resultat[id]>$path</option>";
		else
			$list_cats[] = "<option label=\"$path \" value=$resultat[id] selected>$path</option>";		
	}
	// order list alfabetically
	@asort($list_cats);
	$list .= @implode("\n",$list_cats);
	$list .= "</select>\n";
	return $list;
}

function keyword_in_bold($mots,$chaine)
{
return eregi_replace($mots,"<b>\\0</b>",$chaine);
}

/******************************* DIVERSE LINK MANAGER FUNCTIONS ****************************************/

// Checking that new sub-cats is added under a valid main-cat...
function is_scat_of($id_fille,$id_mere)
{
	global $T_categories;

	if ($id_fille == 0)
		return false;
	$sql = "SELECT id_cat_mere FROM $T_categories WHERE id = $id_fille ";
	$res = send_sql($sql,"finding main category");
	$id_cat = mysql_result($res,0,"id_cat_mere");
	
	if ($id_cat == $id_mere)
		return true;
	else
		return is_scat_of($id_cat,$id_mere);
}

// Similar to function array_merge, allows fusion of 2 tables into a third...
function concat_arrays($tab_1,$tab_2)
{
	$ln_1 = sizeof($tab_1);
	$tab_out = $tab_1;
	$ln_2 = sizeof($tab_2);
	$j = $ln_1;
	for ($i=0;$i<$ln_2;$i++,$j++)
		$tab_out[$j] = $tab_2[$i];	
	return $tab_out;
}

// Similar to function in_array...
function is_in_array($valeur,$tab)
{
	$ln = sizeof($tab);
	for ($i=0;$i<$ln;$i++)
		if ($tab[$i] == $valeur)
			return true;
	return false;
}

// Altering date format from YYYY-MM-DD to DD-MM-YYYY
function convert_date_us2fr($date_us)
{
	$date_in = explode("-",$date_us);
	$date_out = $date_in[1];
	$date_out .= "/";
	$date_out .= $date_in[2];
	$date_out .= "/";
	$date_out .= $date_in[0];
	return $date_out;
}

// Returning date in format: DD-MM-YYYY
function get_datefr_from_tamp($tampon)
{
return date("d-m-Y",$tampon);
}

// Sending an Email to admin or visitor...
function send_mail($emailto,$sujet,$corps,$emailfrom,$priority=3)
{
	global $titre_site, $email_master;
	
	$corps = $corps;
	
	if ($emailto  == $email_master)
		$to = "$titre_site<$email_master>";
	else
	{
		$to = "$emailto";
		$corps .= "\n------------------------------------------------------------\n";
		$corps .= "Have a nice day - Regards Admin @ $titre_site";
	}
	if ($emailfrom == $email_master)
		$from = "From: Linkmanager<$email_master>\r\nReply-To: $email_master\r\nReturn-Path: $email_master";
	else
	{
	    $from = "From: Linkmanager<$emailfrom>\nReply-To: $email_master\r\nReturn-Path: $email_master";
	}

	$options = $from;
	$options .= "X-Priority: $priority\n";
	return @mail($to,$sujet,$corps,$options);
	//If you have Online.net change the above line with the line below...
	//return @email("webmaster",$to,$sujet,$corps);
}

// Gathering and displaying the number of categories, sub-cats and links...
function get_nbsites($cat)
{
	global $T_categories,$T_sites;
	
	$list_all_cats[] = $cat;
	
	while (list($cle,$id_cat) = each ($list_all_cats))
	{
		$sql_scats = "SELECT id FROM $T_categories WHERE id_cat_mere = '$id_cat' AND activation = 1 ";
		$res_scats = send_sql($sql_scats,"number of sub-cats in category $id_cat");
		while ($result = mysql_fetch_array($res_scats,MYSQL_ASSOC))
			$list_all_cats[] = $result["id"];
	}

	$sql_nb_sites = "SELECT count(id) as count FROM $T_sites WHERE activation = 1 and (";
	$nb_cats = sizeof($list_all_cats);
	for ($i=0;$i<$nb_cats-1;$i++)
		$sql_nb_sites .= "id_cat = '$list_all_cats[$i]' or ";
	$sql_nb_sites .= "id_cat = '$list_all_cats[$i]') ";
	$res_nb_sites = send_sql($sql_nb_sites,"number of links in category $id_cat");
	return mysql_result($res_nb_sites,0,"count");
}

/******************************* LINK MANAGER VERIFICATION FUNCTIONS ******************************/

// Checking to see if link (URL) is already present...
function cherche_presence_url($url,$id_categorie,$max_presence)
{
	global $T_sites,$T_sites_in_wait;
	
	$presence_in_site = url_exist($url,"$T_sites");
	$presence_in_site_wait = url_exist($url,"$T_sites_in_wait");
	$tab_presence = concat_arrays($presence_in_site,$presence_in_site_wait);
	
	$nb_presence = sizeof($tab_presence);
	
	if($nb_presence)
	{
		if(is_in_array($id_categorie,$tab_presence))
		{
			echo "The link already exists in this category !\n";
			return true;
		}
		if ($nb_presence >= $max_presence)
		{
			echo "We only allow $max_presence listing for a specific URL in our directory !\n";
			return true;
		}
	}
	return false;
}

// Finding ID to present categories if URL already exists...
function url_exist($url,$table)
{
	$sql = "SELECT id_cat FROM $table WHERE url = '$url' ";
	$res = send_sql($sql,"la recherche de site dans $table");
	while($resultat = mysql_fetch_array($res,MYSQL_ASSOC))
		$present_in_cat[] = $resultat["id_cat"];
	return $present_in_cat;
}

// Verifying if category ID exist (is valid)...
function id_cat_exist($id_cat)
{
	global $T_categories;
	
	if ($id_cat == 0)
		return true;
	else
	{
		$sql = "SELECT id FROM $T_categories WHERE id = '$id_cat'";
		$res = send_sql($sql,"verifying if category ID exist");
		if (mysql_num_rows($res))
			return true;
		else
		{
		    return false;
		}
	}
}

// Verifying to see that hexadecimal code is valid...
function hexa_correct($code_hexa)
{
	$code_hexa = strtolower($code_hexa);
	
	if (!(ereg("^#[0-9a-f]{6}$",$code_hexa)) )
	{
		$message = "Your hexadecimal code $code_hexa is not valid!";
		$message .= "<br><br>\n";
		$message .= "<input type=\"button\" onclick=\"javascript:history.go(-1);\" value=\"Return\" class=\"link_close_button\">\n";
		die ($message);
	}
	return true;
}

// Verifying given Email address (syntax and domaine)...
function admin_email($email,$inc = true)
{
    $message = "<br><br><br><br><br><br><br><br><center><span class=\"link_error\">";
	if (empty($email))
	{
		$message .= "Please enter your Email address!<br>\n";
		$email_ok = false;
	}
	else
	{
		$email_ok = eregi("^[_\.0-9a-z-]+@([0-9a-z-]+\.)+[a-z]{2,4}$",$email);		
		if(TEST_MAIL)
		{		
			list($user, $domaine) = split("@", $email, 2);
			$domain_ok = @checkdnsrr($domaine, "MX");
		}
		else
		{
		    $domain_ok = true;
		}
	}
	if (!$email_ok || !$domain_ok)
	{
		$message .= "Your Email address: \"$email\" is not valid!<br>\n";
		$message .= "Please verify your spelling, and try again!<br>\n";
		$message .= "<br><br>\n";
		$message .= "<input type=\"button\" onclick=\"javascript:history.go(-1);\" value=\"Correct Email\" class=\"link_close_button\"></span></center>\n";
		echo "<HTML><HEAD><TITLE>Status Message</TITLE><link type=\"text/css\" href=\"./style/admin.css\" rel=stylesheet></HEAD><BODY>";
		echo $message."</span></center></BODY></HTML>";
		exit;
	}
	return true;
}

// Verifying given Email address, syntax and domaine (link_section)...
function link_email($email,$inc = true)
{
    $message = "<br><br><br><br><br><br><br><br><center><span class=\"link_error\">\n";
	if (empty($email))
	{
		$message .= "Please enter your Email address!<br>\n";
		$email_ok = false;
	}
	else
	{
		$email_ok = eregi("^[_\.0-9a-z-]+@([0-9a-z-]+\.)+[a-z]{2,4}$",$email);		
		if(TEST_MAIL)
		{		
			list($user, $domaine) = split("@", $email, 2);
			$domain_ok = @checkdnsrr($domaine, "MX");
		}
		else
		{
		    $domain_ok = true;
		}
	}
	if (!$email_ok || !$domain_ok)
	{
		$message .= "Your Email address: \"$email\" is not valid!<br>\n";
		$message .= "Please verify your spelling, and try again!<br>\n";
		$message .= "<br><br><br>\n";
		$message .= "<input type=\"button\" onclick=\"javascript:history.go(-1);\" value=\"Return\" class=\"link_close_button\">\n";
		echo $message;
		exit;
	}
	return true;
}

// Verifies that no field is empty (link section)...
function link_field_check($champ,$message,$inc = true)
{
	$message .= "<br><br><br>";
	$message .= "<input type=\"button\" onclick=\"javascript:history.go(-1);\" value=\"Return\" class=\"link_close_button\">\n";
	$champ = trim($champ);
	if (empty($champ))
	{
		echo "<br><br><br><br><br><br><br><br><center><span class=\"link_error\">".$message."\n";
		exit;
	}
	else
		return false;
}

// Verifies that no field is empty (admin section)...
function admin_field_check($champ,$message,$inc = true)
{
	$message .= "<br><br><br>";
	$message .= "<input type=\"button\" onclick=\"javascript:history.go(-1);\" value=\"Return to correct...\" class=\"link_close_button\">\n";
	$champ = trim($champ);
	if (empty($champ))
	{
		echo "<HTML><HEAD><TITLE>Status Message</TITLE><link type=\"text/css\" href=\"./style/admin.css\" rel=stylesheet></HEAD><BODY>";
		echo "<center><br><br><br><br><br><br><br><br><span class=\"link_error\">".$message."</span></center></BODY></HTML>";
		exit;
	}
	else
		return false;
}

// Checking length of message (error when to long)...
function est_trop_long($champ,$ln_max,$message,$inc = true)
{
	$ln_champ = strlen($champ);
	$message = "<br><br>";
	$message .= "Your message contains $ln_champ characters. Please reduce it to meet our maximum, which is $ln_max characters...\n";
	$message .= "<br><br><br>\n";
	$message .= "<input type=\"button\" onclick=\"javascript:history.go(-1);\" value=\"Return\" class=\"link_close_button\">\n";

	if ($ln_champ > $ln_max )
	{
		echo "<HTML><HEAD><TITLE>Status Message</TITLE><link type=\"text/css\" href=\"./style/admin.css\" rel=stylesheet></HEAD><BODY>";
		echo "<center><br><br><br><br><br><br><span class=\"link_error\">".$message."</span></center></BODY></HTML>";
		exit;
	}
	else
		return false;
}

// Checking length of message (error when to short)...
function est_trop_court($champ,$ln_min,$message,$inc = true)
{
	$ln_champ = strlen($champ);

	$message = "<br><br>";
	$message .= "Your message contains $ln_champ characters. Our minimum is $ln_min characters, please extend your message...\n";
	$message .= "<br><br><br>\n";
	$message .= "<input type=\"button\" onclick=\"javascript:history.go(-1);\" value=\"Return\" class=\"link_close_button\">\n";

	if ($ln_champ < $ln_min )
	{
		echo "<HTML><HEAD><TITLE>Status Message</TITLE><link type=\"text/css\" href=\"./style/admin.css\" rel=stylesheet></HEAD><BODY>";
		echo "<center><br><br><br><br><br><br><span class=\"link_error\">".$message."</span></center></BODY></HTML>";
		exit;
	}
	else
		return false;
}

// Verifying entered number in vote...
function est_entier($n)
{
	if (!(ereg("^[0-9]{1,9}$", $n)))
	{
		$message = "<HTML><HEAD><TITLE>Status Message</TITLE><link type=\"text/css\" href=\"./style/admin.css\" rel=stylesheet></HEAD><BODY>\n";
		$message .= "<center><br><br><br><br><br><br><br><br><span class=\"link_error\">\n";
		$message .= "\"$n\" is not a given number!\n";
		$message .= "<br><br><br>\n";
		$message .= "<input type=\"button\" onclick=\"javascript:history.go(-1);\" value=\"Return\" class=\"link_close_button\">\n";
		die($message);
	}
	return true;
}

// Almost same as above...
function est_reel($n)
{
	if (!(ereg("^[0-9]{1,9}"."[.]{0,1}"."[0-9]{0,9}$", $n)))
	{
		$message = "<HTML><HEAD><TITLE>Status Message</TITLE><link type=\"text/css\" href=\"./style/admin.css\" rel=stylesheet></HEAD><BODY>\n";
		$message .= "<center><br><br><br><br><br><br><br><br><span class=\"link_error\">\n";
		$message .= "\"$n\" is not a valid number in this context!\n";
		$message .= "<br><br><br>\n";
		$message .= "<input type=\"button\" onclick=\"javascript:history.go(-1);\" value=\"Return\" class=\"link_close_button\">\n";
		die($message);
	}
	return true;
}

// Placing the number (n) into [min,max]
function place_dans_intervalle($n,$min,$max,$type = "")
{
	if($type == "int")
		est_entier($n);
	if($type == "float")
		est_reel($n);
	if (empty ($n) || $n < 0)
		$n = $min;
	if ($n > $max)
		$n = $max;
	if ($n < $min)
		$n = $min;
	return $n;
}

/******************************* LINK MANAGER URL CHECKER FUNCTIONS *************************************/

// Verifying the validity of an URL
function url_valide ($url,$inc = true)
{
	$message = "";
	if (empty($url) || $url == "http://")
		$message .= "Please enter the URL to your link!\n";
	else
	{
		// Verifiy that the URL is on a valid form...
		$cmp_h = strcmp(substr($url,0,7),"http://");
		$cmp_n = strcmp(substr($url,0,7),"news://");
		$cmp_f = strcmp(substr($url,0,6),"ftp://");
		$cmp_m = strcmp(substr($url,0,7),"mailto:");
		if ($cmp_h != 0 && $cmp_n != 0 && $cmp_f != 0 && $cmp_m != 0)
			$message .= "Invalid URL! We only allow: http:// , news:// , ftp:// or mailto:\n";
		if ($cmp_h== 0) //if URL = http://
		{
			$url_parsee = @parse_url($url);
			$host = trim($url_parsee["host"]);
			$path = trim($url_parsee["path"]);
			if (check_syntaxe_domaine($host))
			{
				$tab_return = check_connect($host,$path);
				if ($tab_return["statut"] == 0)
					$message .= "We are unable to verify your site &raquo; $url<br><br>Your server may be down!\n";
			}
			else
			{
			    $message .= "We are unable to connect to your host &raquo; $host<br><br>Your server may be down!\n";
			}
		}
	}
	if ($message)
	{	
	    $message .= "<br><br><br>\n";	
		$message .= "<input type=\"button\" onclick=\"javascript:history.go(-1);\" value=\"Return\" class=\"link_close_button\"></center>\n";
		echo "<HTML><HEAD><TITLE>Status Message</TITLE><link type=\"text/css\" href=\"./style/admin.css\" rel=stylesheet></HEAD><BODY>\n";
		echo "<center><br><br><br><br><br><br><br><br><span class=\"link_error\">".$message."</span></center></BODY></HTML>";
		exit;
	}
	else
	{
	    return false;
	}	
}

// Verifying the syntax of a given URL...
function check_syntaxe_domaine($domaine)
{
	$domaine_ok = eregi("^(www\.)?[a-z0-9]{1,1}[_a-z0-9-]*[a-z0-9]{1,1}(\.[a-z0-9]{1,1}[a-z0-9-]*)?\.[a-z]{2,4}$",$domaine);
	if (!$domaine_ok)
		$domaine_ok = ($domaine == "localhost") || ($domaine == "127.0.0.1");
	if(!$domaine_ok)
		$domaine_ok = ereg("^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$",$domaine);

	return $domaine_ok;
}

// Verifying the validity of an URL by establishing a connection...
// If an error is returned, a proper explanation is gathered from the
// table (array) further down. Feel free to add more if you feel that
// it is needed
function check_connect($host,$path)
{
	if(!TEST_URL)
	// if working locally, no attempt is made to connect...
	{
		$tab_return["statut"] = 1; // 0=KO, 1=redirect/local, 2=OK
		$tab_return["code"] = 0;   // HTTP error message
		$tab_return["message"] = "<span color=\"#FF9900\">Failed to connect...</span>\n";
		return $tab_return;
	}
	$connect = 0;
	$no_code = 0;
	if($fp = @fsockopen($host,80))
	{
		if(substr($path,strlen($path)-1) != '/')
		{
			if(!ereg("\.",$path))
				$path .= "/";
		}
		fputs($fp,"GET ".$path." HTTP/1.1\r\n");
		fputs($fp,"Host: ".$host."\r\n");
		fputs($fp,"Connection: close\r\n\r\n");
		$line = fread($fp,255);
		$en_tete = $line;
		while (!feof($fp) && !ereg("<",$line) )
		{		
		    $en_tete .= $line;
			$line = fread($fp,255);
		}
		fclose($fp);
		$no_code = substr($en_tete,9,3);
		switch ($no_code)
		{
			// 2** page is found, and no main problem occurred...
			case 200 :	$message = "200 - OK, successful page request!";
						$color = "#33CC00";
						$connect = 2;
						break;
			case 204 :	$message = "204 - Dragon, page has no content!";
						$color = "#FF9966";
						break;
			case 206 :	$message = "206 - Could only load partial page!";
						$color = "#FF9966";	
						break;
			// 3** page is found, but is only for redirection purposes...
			case 301 :	$message = "301 - The page is moved permanently!";
						$message .= seek_redirect_location($en_tete);	
						$color = "#FF8080";
						$connect = 1;
						break;
			case 302 :	$message = "302 - The page is moved temporarily!";
						$message .= seek_redirect_location($en_tete);
						$color = "#FF8080";
						$connect = 1;
						break;
			// 4** Client error pages...
			case 400 :	$message = "400 - Bad request due to malformed syntax!";
						$color = "#C00000";
						break;
			case 401 :	$message = "401 - Unauthorized, the request requires user authentication!";
						$color = "#C00000";
						break;
			case 402 :	$message = "402 - Payment Required, designed for future use!";
						$color = "#C00000";
						break;
			case 403 :	$message = "403 - Access denied, server denied entry!";
						$color = "#C00000";
						break;
			case 404 :	$message = "404 - Page not found, the server has tried but failed matching the Request-URL!";
						$color = "#C00000";
						break;
			case 407 :	$message = "407 - Proxy authentication required!";
						$color = "#C00000";
						break;
			case 410 :	$message = "410 - Gone, the requested resource is no longer available on the server!";
						$color = "#C00000";
						break;												
			// 5** Server error pages...
			case 500 :	$message = "500 - Internal server error!";
						$color = "#C00000";
						$connect = 1;
						break;
			case 502 :	$message = "502 - Bad gateway!";
						$color = "#C00000";
						break;
			case 503 :	$message = "503 - Service unavailable!";
						$color = "#C00000";
						break;
			case 504 :	$message = "504 - Gateway timeout!";
						$color = "#C00000";
						break;						
			// If not listed above...
			default :	$message = "Error $no_code, no definition available!";
						$color = "#000000";
						break;
		}
	}
	else
	{
		$message = "Impossible to connect to socket, proxy error!";
		$color = "#C00000";
	}
	// Creating the error message table...
	$data_return["statut"] = $connect;
	$data_return["code"] = $no_code;
	$data_return["message"] = "<font color=\"".$color."\">".$message."</font>\n";
	return $data_return;
}

// Finding correct URL if given is only a redirect...
function seek_redirect_location($header)
{
	$location = "";
	$tab_header = explode("\n",$header);
	for ($i=0;$tab_header[$i];$i++)
	{
		$line = split(":",$tab_header[$i],2);
		if(eregi("location",$line[0]))
		{
			$location= trim($line[1]);
			break;
		}
	}
	if ($location)
		return "<br>Redirecting to :<br><a href=\"$location\" target=\"_blank\">".$location."</a>\n";
	else
		return "<br>No valid redirect address (URL) found...\n";
}

/******************************* LINK MANAGER SESSION FUNCTIONS *************************************/

// Creating the admin session length, preset at 3600s = 1 hour...
function create_session($admin_id,$delai = 3600)
{
	if(empty($admin_id))
		exit;
		
	global $T_sessions;
	
	// Creating the session ID...
	$session_id = uniqid((double)microtime()*1000000, true);
	$sql_del = "DELETE FROM $T_sessions WHERE timestamp < UNIX_TIMESTAMP() ";
	$sql_sel = "SELECT count(admin_id) AS count FROM $T_sessions WHERE admin_id = '$admin_id' ";
	$sql_ins = "INSERT INTO $T_sessions (session_id,timestamp,admin_id) VALUES ('$session_id',UNIX_TIMESTAMP()+$delai,'$admin_id') ";
	$del = send_sql($sql_del,"deleting previous sessions");
	$sel = send_sql($sql_sel,"verifying that admin is not already logged in");
	if(mysql_result($sel,0,"count") != 0)
	{
		?>
		<br><br><br><br><br>
		<center><b>Hello Master</b>, you are already logged in to the admin section!
		<br>
		Unfortunately, you did not quit your previous session correctly!
		<br>
		To avoid this message in the future, please log out after each session!
		<br>
		In this case you may find yourself having to wait as long as 1 (one) hour<br>
		before you are able to continue. This due to the time cookie you created...
		<br><br>
		<a href="<? echo $baseurl; ?>">Return home...</a></center>
		<?
		exit;
	}
	if ($ins = send_sql($sql_ins,"inserting session to DB"))
		return $session_id;
	else
		die("Can not create a new session...");
}

// Verify if session is valid...
function check_session($sess_id)
{
	if (empty($sess_id))
		return false;

	global $T_sessions;

	$del = "DELETE FROM $T_sessions WHERE timestamp < UNIX_TIMESTAMP() ";
	$sql = "SELECT * FROM $T_sessions WHERE session_id = '$sess_id' ";
	$del = send_sql($del,"deleting previous sessions");
	$res = send_sql($sql,"verifying that the session is created today");
	if (mysql_num_rows($res) == 1)
		return true;
	else
		return false;
}

// Combining the session ID with the URL...
function addsess2url($url,$session_id)
{
    // uses & if some parameters is already included
	if(ereg("\?",$url))
		return $url."&session_id=".$session_id;
    // uses ? if no parameters are included
	else
		return $url."?session_id=".$session_id;
}

/******************************* LINK MANAGER FUNCTIONS END *************************************/

?>
