<?php

// ***************************************************************************
// * Copyright  2003 - Thomas Egtvedt - www.evaria.com - thomas@evaria.com  *
// *                                                                         *
// *      ECMS - Content Management System - Support: forum.evaria.com       *
// *                                                                         *
// * This program is commercial software; you can not redistribute/reproduce *
// * it and/or sell it without the prior written consent of www.evaria.com   *
// *                                                                         *
// * This program is distributed in the hope that it will be useful,         *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of          *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
// ***************************************************************************
//
// This file acts as the admin control panel for creating new polls and
// archive previous poll(s) to the text database. It's viewed online (browser).

// Include files to enable functions and security
include("config.inc.php");
include("dir_functions.php");
include("secure.php");

if (isset($write)) {
   if (isset($archive)) {
          $poll_contents = file($current_poll);
          // Count number of total votes
          $total_votes = sizeof($poll_contents);
          $my_answers = file($config);
          if ($total_votes == 0) {
            echo "<center><font color=\"#C00000\">&nbsp;&raquo;&nbsp;Nothing to archive (zero votes)</font></center>\n";
          }
          else {

              // Opening the archive text DB
              $fp = fopen($archive_poll, "a");
              $answers_file = file($config);
              $current_question = $answers_file[0];

              // Start saving current poll, starting with the poll title...
              $size_question = strlen($current_question) + 1;
              fputs($fp, chop($current_question) . "|", $size_question);

			  // Adding the total number of votes in current poll...
              $total_votes_string = "<TD align=\"right\" colspan=\"1\"><b>Total votes:</b> " . $total_votes . "</TD></TR>";
			  $size_total_votes_string = strlen($total_votes_string);
			  fputs($fp, $total_votes_string, $size_total_votes_string);
			
			  // Adding all the answers and visualizations in current poll...
			  $size_answers = sizeof($my_answers) - 1;
              $votes[$size_answers] = 0;
              for ($current_number = 1; $current_number <= $size_answers; $current_number++) {
                  foreach ($poll_contents as $line) {
                          $line = chop($line); $line_parts = explode("|", $line);
                          if ($line_parts[0] == $current_number) {
                             $votes[$current_number]++;
                          }
                  }
                  $percentage = $votes[$current_number]/$total_votes*100;
                  $graph_width = round($percentage, 0) + 1;
                  $graph_width2 = 2*$graph_width;
                  $graph_width3 = 100 - $graph_width;
                  $graph_width4 = 2*$graph_width3;
                  $archive_string = "<TR class=\"poll_vcontent\"><TD align=\"left\">" . chop($answers_file[$current_number]) . "</TD><TD align=\"right\">" . round($percentage, 0) . " %</TD><TD align=\"center\"><img src=\"img/image1.gif\" width=\"" . $graph_width2 . "\" height=\"10\"><img src=\"img/image2.gif\" width=\"" . $graph_width4 . "\" height=\"10\"></TD><TD align=\"right\">" . $votes[$current_number]/1 . " votes</TD></TR>";
                  $size_string = strlen($archive_string);
                  fputs($fp, $archive_string, $size_string);
				  }

          // Separate the polls in poll_previous.txt
          fputs($fp, "<TR><TD colspan=\"4\" align=\"right\"><b>Poll ended:</b> " . date("d M Y") . "</TD></TR>");
          fputs($fp, "\n", 1);
          fclose($fp);
          echo "<center><font color=\"#C00000\">&nbsp;&raquo;&nbsp;Current poll saved to archive</font></center>\n";
          }
   }
   // Empty the poll_current.txt file
   $poll_file = fopen($current_poll, "w");
   ftruncate($poll_file, 0);
   fclose($poll_file);

   if ((strlen($question) != 0) && (strlen($answers) != 0)) {



      // Write new question
      $fp = fopen($config, "w");
      $string = stripslashes($question) . "\n" . trim(stripslashes($answers));
      $string_size = strlen($string);
      if (fputs($fp, $string, $string_size)) {
         echo "<center><font color=\"#C00000\">&nbsp;&raquo;&nbsp;New poll added successfully</font></center>\n";
      }
      fclose($fp);
   }
}
if(isset($deletecurrent)) {  if (isset($archive)) {
          $poll_contents = file($current_poll);
          // Count number of total votes
          $total_votes = sizeof($poll_contents);
          $my_answers = file($config);
          if ($total_votes == 0) {
            echo "<center><font color=\"#C00000\">&nbsp;&raquo;&nbsp;Nothing to archive (zero votes)</font></center>\n";
          } else {

			  // Opening the archive text DB
			  $fp = fopen($archive_poll, "a");
              $answers_file = file($config);
              $current_question = $answers_file[0];

              // Start saving current poll, starting with the poll title...
              $size_question = strlen($current_question) + 1;
              fputs($fp, chop($current_question) . "|", $size_question);

			  // Adding the total number of votes in current poll...
              $total_votes_string = "<TD align=\"right\" colspan=\"1\"><b>Total votes:</b> " . $total_votes . "</TD></TR>";
			  $size_total_votes_string = strlen($total_votes_string);
			  fputs($fp, $total_votes_string, $size_total_votes_string);
			
			  // Adding all the answers and visualizations in current poll...
              $size_answers = sizeof($my_answers) - 1;
              $votes[$size_answers] = 0;
              for ($current_number = 1; $current_number <= $size_answers; $current_number++) {
                  foreach ($poll_contents as $line) {
                          $line = chop($line);$line_parts = explode("|", $line);
						  if ($line_parts[0] == $current_number) {
                             $votes[$current_number]++;
                          }
                  }
                  $percentage = $votes[$current_number]/$total_votes*100;
                  $graph_width = round($percentage, 0) + 1;
                  $graph_width2 = 2*$graph_width;
                  $graph_width3 = 100 - $graph_width;
                  $graph_width4 = 2*$graph_width3;
                  $archive_string = "<TR class=\"poll_vcontent\"><TD align=\"left\">" . chop($answers_file[$current_number]) . "</TD><TD align=\"right\">" . round($percentage, 0) . " %</TD><TD align=\"center\"><img src=\"img/image1.gif\" width=\"" . $graph_width2 . "\" height=\"10\"><img src=\"img/image2.gif\" width=\"" . $graph_width4 . "\" height=\"10\"></TD><TD align=\"right\">" . $votes[$current_number]/1 . " votes</TD></TR>";
                  $size_string = strlen($archive_string);
                  fputs($fp, $archive_string, $size_string);
				  }

          // Separate the polls in poll_previous.txt
          fputs($fp, "<TR><TD colspan=\"4\" align=\"right\"><b>Poll ended:</b> " . date("d M Y") . "</TD></TR>");
          fputs($fp, "\n", 1);
          fclose($fp);
		  // Move results from poll_current.txt && poll_config.txt to poll_previous.txt
          echo "<center><font color=\"#C00000\">&nbsp;&raquo;&nbsp;Current poll saved to archive</font></center>\n";
          }
   }
   // Empty the poll_current.txt file
   $poll_file = fopen($current_poll, "w");
   if (ftruncate($poll_file, 0)) {
      echo "<center><font color=\"#C00000\">&nbsp;&raquo;&nbsp;Vote file emptied</font></center>\n";
   }
   fclose($poll_file);

   // Empty the poll_config.txt file
   $config_file = fopen($config, "w");
   if (ftruncate($config_file, 0)) {
      echo "<center><font color=\"#C00000\">&nbsp;&raquo;&nbsp;Poll file emptied</font></center>\n";
   }
   fclose($config_file);
}
?>

<HTML>
<HEAD>
<TITLE><?=$sitename?> - poll admin</TITLE>
<LINK rel="stylesheet" href="./style/admin.css" type="text/css">
<script language="JavaScript" src="seek.js"></script>
</HEAD>

<BODY>
<center>

<br><br>

<TABLE  class="admtabl" width="<?=$table_width?>" border="0" cellpadding="5" cellspacing="1">
 <TR>
  <TD class="admhead">
<TABLE width="100%" border="0" cellpadding="0" cellspacing="0">
 <TR>
  <TD align="left"><input type="button" value=" Return " onclick="top.location.href='<? echo addsess2url("admin.php",$session_id); ?>'"></TD>
  <TD class="admhead" align="center"><b><?=$sitename?> | administer your polls</b></TD>
  <TD align="right"><input type="button" value=" Return " onclick="top.location.href='<? echo addsess2url("admin.php",$session_id); ?>'"></TD>
 </TR>
</TABLE>
  </TD>
 </TR>
 <TR>
  <TD class="admtext">This page allows you to stop, delete or save your current poll, 
  and off course start a new survey if your feel like it...</TD>
  </TR>
</TABLE>

<br><br>

<FORM name="setup" action="<? echo addsess2url("poll_admin.php",$session_id); ?>" method="post">
<TABLE  class="admtabl" width="<?=$table_width?>" border="0" cellpadding="5" cellspacing="1">
 <TR>
  <TD class="admhead" align="center"><b>Start a new survey | poll session</b></TD>
 </TR>
 <TR>
  <TD align="center" class="admtext">
  <input type="text" name="question" size="50" value="Enter your poll title here...">
  <br><br>Answers (one per line):<br>
<textarea name="answers" cols="40" rows="6">
Answer 1
Answer 2
Answer 3
etc...
</textarea><br>
  Save current poll to archive? <input type="checkbox" name="archive" value="on">
  <br><br>
  <input type="submit" name="write" value="save new poll &amp; update settings"></TD>
  </TR>
</TABLE>
</FORM>

<br><br>

<FORM name="deletecurrent" action="<? echo addsess2url("poll_admin.php",$session_id); ?>" method="post">
<TABLE  class="admtabl" width="<?=$table_width?>" border="0" cellpadding="5" cellspacing="1">
 <TR>
  <TD class="admhead" align="center"><b>Stop survey momentarily...</b></TD>
 </TR>
 <TR>
  <TD align="center" class="admtext">
  Save current poll to archive? <input type="checkbox" name="archive" value="on">
  <br><br>
  <input type="submit" name="deletecurrent" value="close poll &amp; update settings"></TD>
  </TR>
</TABLE>
</FORM>

</center>
</BODY>
</HTML>
